/* This file is generated by vkr_device_object.py. */

#ifndef VKR_BUFFER_GEN_H
#define VKR_BUFFER_GEN_H

#include "vkr_common.h"

#include "venus-protocol/vn_protocol_renderer_buffer.h"
#include "venus-protocol/vn_protocol_renderer_buffer_view.h"

#include "vkr_context.h"
#include "vkr_device.h"

/* create a driver VkBuffer and update the vkr_buffer */
static inline VkResult
vkr_buffer_create_driver_handle(
   UNUSED struct vkr_context *ctx,
   struct vn_command_vkCreateBuffer *args,
   struct vkr_buffer *obj)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);
   struct vn_device_proc_table *vk = &dev->proc_table;

   /* handles in args are replaced */
   vn_replace_vkCreateBuffer_args_handle(args);
   args->ret = vk->CreateBuffer(args->device, args->pCreateInfo, NULL,
      &obj->base.handle.buffer);
   return args->ret;
}

/* create a vkr_buffer */
static inline struct vkr_buffer *
vkr_buffer_create(
   struct vkr_context *ctx,
   struct vn_command_vkCreateBuffer *args)
{
   struct vkr_buffer *obj = vkr_context_alloc_object(ctx, sizeof(*obj),
      VK_OBJECT_TYPE_BUFFER, args->pBuffer);
   if (!obj) {
      args->ret = VK_ERROR_OUT_OF_HOST_MEMORY;
      return NULL;
   }

   /* handles in args are replaced */
   if (vkr_buffer_create_driver_handle(ctx, args, obj) != VK_SUCCESS) {
      free(obj);
      return NULL;
   }

   return obj;
}

/* create a vkr_buffer and add it to the vkr_device */
static inline struct vkr_buffer *
vkr_buffer_create_and_add(
   struct vkr_context *ctx,
   struct vn_command_vkCreateBuffer *args)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);

   struct vkr_buffer *obj = vkr_buffer_create(ctx, args);
   if (!obj)
      return NULL;

   vkr_device_add_object(ctx, dev, &obj->base);
   return obj;
}

/* destroy a driver VkBuffer */
static inline void
vkr_buffer_destroy_driver_handle(
   UNUSED struct vkr_context *ctx,
   struct vn_command_vkDestroyBuffer *args)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);
   struct vn_device_proc_table *vk = &dev->proc_table;

   /* handles in args are replaced */
   vn_replace_vkDestroyBuffer_args_handle(args);
   vk->DestroyBuffer(args->device, args->buffer, NULL);
}

/* remove a vkr_buffer from the device and destroy it */
static inline void
vkr_buffer_destroy_and_remove(
   struct vkr_context *ctx,
   struct vn_command_vkDestroyBuffer *args)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);
   struct vkr_buffer *obj = vkr_buffer_from_handle(args->buffer);
   if (!obj)
      return;

   vkr_buffer_destroy_driver_handle(ctx, args);

   vkr_device_remove_object(ctx, dev, &obj->base);
}

/* create a driver VkBufferView and update the vkr_buffer_view */
static inline VkResult
vkr_buffer_view_create_driver_handle(
   UNUSED struct vkr_context *ctx,
   struct vn_command_vkCreateBufferView *args,
   struct vkr_buffer_view *obj)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);
   struct vn_device_proc_table *vk = &dev->proc_table;

   /* handles in args are replaced */
   vn_replace_vkCreateBufferView_args_handle(args);
   args->ret = vk->CreateBufferView(args->device, args->pCreateInfo, NULL,
      &obj->base.handle.buffer_view);
   return args->ret;
}

/* create a vkr_buffer_view */
static inline struct vkr_buffer_view *
vkr_buffer_view_create(
   struct vkr_context *ctx,
   struct vn_command_vkCreateBufferView *args)
{
   struct vkr_buffer_view *obj = vkr_context_alloc_object(ctx, sizeof(*obj),
      VK_OBJECT_TYPE_BUFFER_VIEW, args->pView);
   if (!obj) {
      args->ret = VK_ERROR_OUT_OF_HOST_MEMORY;
      return NULL;
   }

   /* handles in args are replaced */
   if (vkr_buffer_view_create_driver_handle(ctx, args, obj) != VK_SUCCESS) {
      free(obj);
      return NULL;
   }

   return obj;
}

/* create a vkr_buffer_view and add it to the vkr_device */
static inline struct vkr_buffer_view *
vkr_buffer_view_create_and_add(
   struct vkr_context *ctx,
   struct vn_command_vkCreateBufferView *args)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);

   struct vkr_buffer_view *obj = vkr_buffer_view_create(ctx, args);
   if (!obj)
      return NULL;

   vkr_device_add_object(ctx, dev, &obj->base);
   return obj;
}

/* destroy a driver VkBufferView */
static inline void
vkr_buffer_view_destroy_driver_handle(
   UNUSED struct vkr_context *ctx,
   struct vn_command_vkDestroyBufferView *args)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);
   struct vn_device_proc_table *vk = &dev->proc_table;

   /* handles in args are replaced */
   vn_replace_vkDestroyBufferView_args_handle(args);
   vk->DestroyBufferView(args->device, args->bufferView, NULL);
}

/* remove a vkr_buffer_view from the device and destroy it */
static inline void
vkr_buffer_view_destroy_and_remove(
   struct vkr_context *ctx,
   struct vn_command_vkDestroyBufferView *args)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);
   struct vkr_buffer_view *obj = vkr_buffer_view_from_handle(args->bufferView);
   if (!obj)
      return;

   vkr_buffer_view_destroy_driver_handle(ctx, args);

   vkr_device_remove_object(ctx, dev, &obj->base);
}

#endif /* VKR_BUFFER_GEN_H */
