// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// NewIsVaultPluginRegisteredParams creates a new IsVaultPluginRegisteredParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIsVaultPluginRegisteredParams() *IsVaultPluginRegisteredParams {
	return &IsVaultPluginRegisteredParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIsVaultPluginRegisteredParamsWithTimeout creates a new IsVaultPluginRegisteredParams object
// with the ability to set a timeout on a request.
func NewIsVaultPluginRegisteredParamsWithTimeout(timeout time.Duration) *IsVaultPluginRegisteredParams {
	return &IsVaultPluginRegisteredParams{
		timeout: timeout,
	}
}

// NewIsVaultPluginRegisteredParamsWithContext creates a new IsVaultPluginRegisteredParams object
// with the ability to set a context for a request.
func NewIsVaultPluginRegisteredParamsWithContext(ctx context.Context) *IsVaultPluginRegisteredParams {
	return &IsVaultPluginRegisteredParams{
		Context: ctx,
	}
}

// NewIsVaultPluginRegisteredParamsWithHTTPClient creates a new IsVaultPluginRegisteredParams object
// with the ability to set a custom HTTPClient for a request.
func NewIsVaultPluginRegisteredParamsWithHTTPClient(client *http.Client) *IsVaultPluginRegisteredParams {
	return &IsVaultPluginRegisteredParams{
		HTTPClient: client,
	}
}

/*
IsVaultPluginRegisteredParams contains all the parameters to send to the API endpoint

	for the is vault plugin registered operation.

	Typically these are written to a http.Request.
*/
type IsVaultPluginRegisteredParams struct {

	// Body.
	Body *models.HashicorpCloudVault20201125IsVaultPluginRegisteredRequest

	// ClusterID.
	ClusterID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the is vault plugin registered params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IsVaultPluginRegisteredParams) WithDefaults() *IsVaultPluginRegisteredParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the is vault plugin registered params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IsVaultPluginRegisteredParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the is vault plugin registered params
func (o *IsVaultPluginRegisteredParams) WithTimeout(timeout time.Duration) *IsVaultPluginRegisteredParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the is vault plugin registered params
func (o *IsVaultPluginRegisteredParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the is vault plugin registered params
func (o *IsVaultPluginRegisteredParams) WithContext(ctx context.Context) *IsVaultPluginRegisteredParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the is vault plugin registered params
func (o *IsVaultPluginRegisteredParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the is vault plugin registered params
func (o *IsVaultPluginRegisteredParams) WithHTTPClient(client *http.Client) *IsVaultPluginRegisteredParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the is vault plugin registered params
func (o *IsVaultPluginRegisteredParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the is vault plugin registered params
func (o *IsVaultPluginRegisteredParams) WithBody(body *models.HashicorpCloudVault20201125IsVaultPluginRegisteredRequest) *IsVaultPluginRegisteredParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the is vault plugin registered params
func (o *IsVaultPluginRegisteredParams) SetBody(body *models.HashicorpCloudVault20201125IsVaultPluginRegisteredRequest) {
	o.Body = body
}

// WithClusterID adds the clusterID to the is vault plugin registered params
func (o *IsVaultPluginRegisteredParams) WithClusterID(clusterID string) *IsVaultPluginRegisteredParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the is vault plugin registered params
func (o *IsVaultPluginRegisteredParams) SetClusterID(clusterID string) {
	o.ClusterID = clusterID
}

// WithLocationOrganizationID adds the locationOrganizationID to the is vault plugin registered params
func (o *IsVaultPluginRegisteredParams) WithLocationOrganizationID(locationOrganizationID string) *IsVaultPluginRegisteredParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the is vault plugin registered params
func (o *IsVaultPluginRegisteredParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the is vault plugin registered params
func (o *IsVaultPluginRegisteredParams) WithLocationProjectID(locationProjectID string) *IsVaultPluginRegisteredParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the is vault plugin registered params
func (o *IsVaultPluginRegisteredParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *IsVaultPluginRegisteredParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
