/* valastruct.c generated by valac, the Vala compiler
 * generated from valastruct.vala, do not modify */

/* valastruct.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaStructPrivate {
	ValaList* type_parameters;
	ValaList* constants;
	ValaList* fields;
	ValaList* methods;
	ValaList* properties;
	ValaSet* property_fields;
	ValaDataType* _base_type;
	gboolean* boolean_type;
	gboolean* integer_type;
	gboolean* floating_type;
	gboolean* decimal_floating_type;
	gboolean* simple_type;
	gint* _rank;
	gint* _width;
	gboolean* _signed;
	gboolean* _is_immutable;
	ValaCreationMethod* _default_construction_method;
};

static gint ValaStruct_private_offset;
static gpointer vala_struct_parent_class = NULL;

static void vala_struct_set_default_construction_method (ValaStruct* self,
                                                  ValaCreationMethod* value);
static gboolean* _bool_dup (gboolean* self);
static gint* _int_dup (gint* self);
static void vala_struct_real_add_constant (ValaSymbol* base,
                                    ValaConstant* c);
static void vala_struct_real_add_field (ValaSymbol* base,
                                 ValaField* f);
static void vala_struct_real_add_method (ValaSymbol* base,
                                  ValaMethod* m);
static void vala_struct_real_add_property (ValaSymbol* base,
                                    ValaProperty* prop);
static void vala_struct_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_struct_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static gint vala_struct_real_get_type_parameter_index (ValaTypeSymbol* base,
                                                const gchar* name);
static void vala_struct_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static gboolean vala_struct_real_is_subtype_of (ValaTypeSymbol* base,
                                         ValaTypeSymbol* t);
static gboolean vala_struct_is_recursive_value_type (ValaStruct* self,
                                              ValaCodeContext* context,
                                              ValaDataType* type);
static gboolean vala_struct_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static void vala_struct_finalize (ValaCodeNode * obj);
static GType vala_struct_get_type_once (void);

static inline gpointer
vala_struct_get_instance_private (ValaStruct* self)
{
	return G_STRUCT_MEMBER_P (self, ValaStruct_private_offset);
}

ValaDataType*
vala_struct_get_base_type (ValaStruct* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_struct_set_base_type (ValaStruct* self,
                           ValaDataType* value)
{
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	vala_code_node_set_parent_node ((ValaCodeNode*) value, (ValaCodeNode*) self);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_type);
	self->priv->_base_type = _tmp0_;
}

ValaStruct*
vala_struct_get_base_struct (ValaStruct* self)
{
	ValaStruct* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_type;
	if (_tmp0_ != NULL) {
		ValaDataType* _tmp1_;
		ValaTypeSymbol* _tmp2_;
		ValaTypeSymbol* _tmp3_;
		_tmp1_ = self->priv->_base_type;
		_tmp2_ = vala_data_type_get_type_symbol (_tmp1_);
		_tmp3_ = _tmp2_;
		result = VALA_IS_STRUCT (_tmp3_) ? ((ValaStruct*) _tmp3_) : NULL;
		return result;
	}
	result = NULL;
	return result;
}

ValaCreationMethod*
vala_struct_get_default_construction_method (ValaStruct* self)
{
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}

static void
vala_struct_set_default_construction_method (ValaStruct* self,
                                             ValaCreationMethod* value)
{
	ValaCreationMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

gboolean
vala_struct_get_is_immutable (ValaStruct* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp1_ = vala_code_node_has_attribute ((ValaCodeNode*) self, "Immutable");
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_is_immutable);
		self->priv->_is_immutable = _tmp2_;
	}
	_tmp3_ = self->priv->_is_immutable;
	result = *_tmp3_;
	return result;
}

void
vala_struct_set_is_immutable (ValaStruct* self,
                              gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_immutable);
	self->priv->_is_immutable = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Immutable", value, NULL);
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

gint
vala_struct_get_width (ValaStruct* self)
{
	gint result;
	gint* _tmp0_;
	gint* _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_width;
	if (_tmp0_ == NULL) {
		if (vala_struct_is_integer_type (self)) {
			gint _tmp1_;
			gint* _tmp2_;
			_tmp1_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) self, "IntegerType", "width", 32);
			_tmp2_ = __int_dup0 (&_tmp1_);
			_g_free0 (self->priv->_width);
			self->priv->_width = _tmp2_;
		} else {
			gint _tmp3_;
			gint* _tmp4_;
			_tmp3_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) self, "FloatingType", "width", 32);
			_tmp4_ = __int_dup0 (&_tmp3_);
			_g_free0 (self->priv->_width);
			self->priv->_width = _tmp4_;
		}
	}
	_tmp5_ = self->priv->_width;
	result = *_tmp5_;
	return result;
}

void
vala_struct_set_width (ValaStruct* self,
                       gint value)
{
	gint* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __int_dup0 (&value);
	_g_free0 (self->priv->_width);
	self->priv->_width = _tmp0_;
	if (vala_struct_is_integer_type (self)) {
		vala_code_node_set_attribute_integer ((ValaCodeNode*) self, "IntegerType", "width", value, NULL);
	} else {
		vala_code_node_set_attribute_integer ((ValaCodeNode*) self, "FloatingType", "width", value, NULL);
	}
}

gboolean
vala_struct_get_signed (ValaStruct* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_signed;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "IntegerType", "signed", TRUE);
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_signed);
		self->priv->_signed = _tmp2_;
	}
	_tmp3_ = self->priv->_signed;
	result = *_tmp3_;
	return result;
}

void
vala_struct_set_signed (ValaStruct* self,
                        gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_signed);
	self->priv->_signed = _tmp0_;
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "IntegerType", "signed", value, NULL);
}

gint
vala_struct_get_rank (ValaStruct* self)
{
	gint result;
	gint* _tmp0_;
	gint* _tmp16_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rank;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		if (vala_struct_is_integer_type (self)) {
			_tmp1_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) self, "IntegerType", "rank");
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gint _tmp2_;
			gint* _tmp3_;
			_tmp2_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) self, "IntegerType", "rank", 0);
			_tmp3_ = __int_dup0 (&_tmp2_);
			_g_free0 (self->priv->_rank);
			self->priv->_rank = _tmp3_;
		} else {
			if (vala_code_node_has_attribute_argument ((ValaCodeNode*) self, "FloatingType", "rank")) {
				gint _tmp4_;
				gint* _tmp5_;
				_tmp4_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) self, "FloatingType", "rank", 0);
				_tmp5_ = __int_dup0 (&_tmp4_);
				_g_free0 (self->priv->_rank);
				self->priv->_rank = _tmp5_;
			} else {
				ValaStruct* st = NULL;
				ValaStruct* _tmp6_;
				ValaStruct* _tmp7_;
				ValaStruct* _tmp8_;
				ValaStruct* _tmp9_;
				_tmp6_ = vala_struct_get_base_struct (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = _vala_code_node_ref0 (_tmp7_);
				st = _tmp8_;
				_tmp9_ = st;
				if (_tmp9_ != NULL) {
					ValaStruct* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					gint* _tmp13_;
					_tmp10_ = st;
					_tmp11_ = vala_struct_get_rank (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = __int_dup0 (&_tmp12_);
					_g_free0 (self->priv->_rank);
					self->priv->_rank = _tmp13_;
				} else {
					ValaSourceReference* _tmp14_;
					ValaSourceReference* _tmp15_;
					_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp15_ = _tmp14_;
					vala_report_error (_tmp15_, "internal error: struct has no rank");
					result = 0;
					_vala_code_node_unref0 (st);
					return result;
				}
				_vala_code_node_unref0 (st);
			}
		}
	}
	_tmp16_ = self->priv->_rank;
	result = *_tmp16_;
	return result;
}

void
vala_struct_set_rank (ValaStruct* self,
                      gint value)
{
	gint* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __int_dup0 (&value);
	_g_free0 (self->priv->_rank);
	self->priv->_rank = _tmp0_;
	if (vala_struct_is_integer_type (self)) {
		gint* _tmp1_;
		_tmp1_ = self->priv->_rank;
		vala_code_node_set_attribute_integer ((ValaCodeNode*) self, "IntegerType", "rank", *_tmp1_, NULL);
	} else {
		gint* _tmp2_;
		_tmp2_ = self->priv->_rank;
		vala_code_node_set_attribute_integer ((ValaCodeNode*) self, "FloatingType", "rank", *_tmp2_, NULL);
	}
}

/**
 * Creates a new struct.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @return                 newly created struct
 */
ValaStruct*
vala_struct_construct (GType object_type,
                       const gchar* name,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaStruct* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaStruct*) vala_typesymbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaStruct*
vala_struct_new (const gchar* name,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_struct_construct (VALA_TYPE_STRUCT, name, source_reference, comment);
}

/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_struct_add_type_parameter (ValaStruct* self,
                                ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, p);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) p);
}

/**
 * Returns the type parameter list.
 *
 * @return list of type parameters
 */
ValaList*
vala_struct_get_type_parameters (ValaStruct* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified constant as a member to this struct.
 *
 * @param c a constant
 */
static void
vala_struct_real_add_constant (ValaSymbol* base,
                               ValaConstant* c)
{
	ValaStruct * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaStruct*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->constants;
	vala_collection_add ((ValaCollection*) _tmp0_, c);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) c);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) c);
}

/**
 * Adds the specified field as a member to this struct.
 *
 * @param f a field
 */
static void
vala_struct_real_add_field (ValaSymbol* base,
                            ValaField* f)
{
	ValaStruct * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaStruct*) base;
	g_return_if_fail (f != NULL);
	vala_symbol_set_access ((ValaSymbol*) f, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp0_ = self->priv->fields;
	vala_collection_add ((ValaCollection*) _tmp0_, f);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) f);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) f);
}

/**
 * Returns the list of fields.
 *
 * @return list of fields
 */
ValaList*
vala_struct_get_fields (ValaStruct* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->fields;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of constants.
 *
 * @return list of constants
 */
ValaList*
vala_struct_get_constants (ValaStruct* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->constants;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified method as a member to this struct.
 *
 * @param m a method
 */
static void
vala_struct_real_add_method (ValaSymbol* base,
                             ValaMethod* m)
{
	ValaStruct * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp17_ = FALSE;
	ValaDataType* _tmp18_;
	ValaDataType* _tmp19_;
	ValaList* _tmp52_;
	ValaScope* _tmp53_;
	ValaScope* _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	self = (ValaStruct*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_MEMBER_BINDING_INSTANCE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaParameter* _tmp7_;
		ValaParameter* _tmp8_;
		ValaScope* _tmp9_;
		ValaScope* _tmp10_;
		ValaParameter* _tmp11_;
		ValaParameter* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		ValaParameter* _tmp15_;
		ValaParameter* _tmp16_;
		_tmp3_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) m, (ValaTypeSymbol*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_parameter_new ("this", _tmp4_, _tmp6_);
		_tmp8_ = _tmp7_;
		vala_method_set_this_parameter (m, _tmp8_);
		_vala_code_node_unref0 (_tmp8_);
		_vala_code_node_unref0 (_tmp4_);
		_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_method_get_this_parameter (m);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_symbol_get_name ((ValaSymbol*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_method_get_this_parameter (m);
		_tmp16_ = _tmp15_;
		vala_scope_add (_tmp10_, _tmp14_, (ValaSymbol*) _tmp16_);
	}
	_tmp18_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp19_ = _tmp18_;
	if (!VALA_IS_VOID_TYPE (_tmp19_)) {
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp20_ = vala_method_get_postconditions (m);
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp17_ = _tmp22_ > 0;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		ValaDataType* _tmp23_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaDataType* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaSourceReference* _tmp28_;
		ValaLocalVariable* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		ValaLocalVariable* _tmp32_;
		_tmp23_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_data_type_copy (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_local_variable_new (_tmp26_, "result", NULL, _tmp28_);
		_tmp30_ = _tmp29_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp30_);
		_vala_code_node_unref0 (_tmp30_);
		_vala_code_node_unref0 (_tmp26_);
		_tmp31_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp32_ = _tmp31_;
		vala_local_variable_set_is_result (_tmp32_, TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		ValaCreationMethod* cm = NULL;
		ValaCreationMethod* _tmp35_;
		gboolean _tmp36_ = FALSE;
		ValaCreationMethod* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		_tmp33_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp34_ = _tmp33_;
		if (_tmp34_ == NULL) {
			vala_struct_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		_tmp35_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
		cm = _tmp35_;
		_tmp37_ = cm;
		_tmp38_ = vala_creation_method_get_class_name (_tmp37_);
		_tmp39_ = _tmp38_;
		if (_tmp39_ != NULL) {
			ValaCreationMethod* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			const gchar* _tmp44_;
			_tmp40_ = cm;
			_tmp41_ = vala_creation_method_get_class_name (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp44_ = _tmp43_;
			_tmp36_ = g_strcmp0 (_tmp42_, _tmp44_) != 0;
		} else {
			_tmp36_ = FALSE;
		}
		if (_tmp36_) {
			ValaSourceReference* _tmp45_;
			ValaSourceReference* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			ValaCreationMethod* _tmp49_;
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp48_ = _tmp47_;
			_tmp49_ = cm;
			_tmp50_ = vala_creation_method_get_class_name (_tmp49_);
			_tmp51_ = _tmp50_;
			vala_report_error (_tmp46_, "missing return type in method `%s.%s´", _tmp48_, _tmp51_);
			_g_free0 (_tmp48_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			_vala_code_node_unref0 (cm);
			return;
		}
		_vala_code_node_unref0 (cm);
	}
	_tmp52_ = self->priv->methods;
	vala_collection_add ((ValaCollection*) _tmp52_, m);
	_tmp53_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_symbol_get_name ((ValaSymbol*) m);
	_tmp56_ = _tmp55_;
	vala_scope_add (_tmp54_, _tmp56_, (ValaSymbol*) m);
}

/**
 * Returns the list of methods.
 *
 * @return list of methods
 */
ValaList*
vala_struct_get_methods (ValaStruct* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->methods;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified property as a member to this struct.
 *
 * @param prop a property
 */
static void
vala_struct_real_add_property (ValaSymbol* base,
                               ValaProperty* prop)
{
	ValaStruct * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaMemberBinding _tmp5_;
	ValaMemberBinding _tmp6_;
	ValaField* _tmp21_;
	ValaField* _tmp22_;
	self = (ValaStruct*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->properties;
	vala_collection_add ((ValaCollection*) _tmp0_, prop);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) prop);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) prop);
	_tmp5_ = vala_property_get_binding (prop);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaParameter* _tmp11_;
		ValaParameter* _tmp12_;
		ValaScope* _tmp13_;
		ValaScope* _tmp14_;
		ValaParameter* _tmp15_;
		ValaParameter* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		ValaParameter* _tmp19_;
		ValaParameter* _tmp20_;
		_tmp7_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) prop, (ValaTypeSymbol*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_parameter_new ("this", _tmp8_, _tmp10_);
		_tmp12_ = _tmp11_;
		vala_property_set_this_parameter (prop, _tmp12_);
		_vala_code_node_unref0 (_tmp12_);
		_vala_code_node_unref0 (_tmp8_);
		_tmp13_ = vala_symbol_get_scope ((ValaSymbol*) prop);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_property_get_this_parameter (prop);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_property_get_this_parameter (prop);
		_tmp20_ = _tmp19_;
		vala_scope_add (_tmp14_, _tmp18_, (ValaSymbol*) _tmp20_);
	}
	_tmp21_ = vala_property_get_field (prop);
	_tmp22_ = _tmp21_;
	if (_tmp22_ != NULL) {
		ValaField* _tmp23_;
		ValaField* _tmp24_;
		ValaSet* _tmp25_;
		ValaField* _tmp26_;
		ValaField* _tmp27_;
		_tmp23_ = vala_property_get_field (prop);
		_tmp24_ = _tmp23_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp24_);
		_tmp25_ = self->priv->property_fields;
		_tmp26_ = vala_property_get_field (prop);
		_tmp27_ = _tmp26_;
		vala_collection_add ((ValaCollection*) _tmp25_, _tmp27_);
	}
}

/**
 * Returns the list of properties.
 *
 * @return list of properties
 */
ValaList*
vala_struct_get_properties (ValaStruct* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->properties;
	result = _tmp0_;
	return result;
}

static void
vala_struct_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaStruct * self;
	self = (ValaStruct*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_struct (visitor, self);
}

static void
vala_struct_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaStruct * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaStruct*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_struct_get_base_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_struct_get_base_type (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp4_;
		gint _p_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _p_index = 0;
		_tmp4_ = self->priv->type_parameters;
		_p_list = _tmp4_;
		_tmp5_ = _p_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_p_size = _tmp7_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValaTypeParameter* _tmp12_;
			_p_index = _p_index + 1;
			_tmp8_ = _p_index;
			_tmp9_ = _p_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _p_list;
			_tmp11_ = vala_list_get (_tmp10_, _p_index);
			p = (ValaTypeParameter*) _tmp11_;
			_tmp12_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
			_vala_code_node_unref0 (p);
		}
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp13_;
		gint _f_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _f_index = 0;
		_tmp13_ = self->priv->fields;
		_f_list = _tmp13_;
		_tmp14_ = _f_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_f_size = _tmp16_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			ValaField* f = NULL;
			ValaList* _tmp19_;
			gpointer _tmp20_;
			ValaField* _tmp21_;
			_f_index = _f_index + 1;
			_tmp17_ = _f_index;
			_tmp18_ = _f_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _f_list;
			_tmp20_ = vala_list_get (_tmp19_, _f_index);
			f = (ValaField*) _tmp20_;
			_tmp21_ = f;
			vala_code_node_accept ((ValaCodeNode*) _tmp21_, visitor);
			_vala_code_node_unref0 (f);
		}
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp22_;
		gint _c_size = 0;
		ValaList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _c_index = 0;
		_tmp22_ = self->priv->constants;
		_c_list = _tmp22_;
		_tmp23_ = _c_list;
		_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_c_size = _tmp25_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp26_;
			gint _tmp27_;
			ValaConstant* c = NULL;
			ValaList* _tmp28_;
			gpointer _tmp29_;
			ValaConstant* _tmp30_;
			_c_index = _c_index + 1;
			_tmp26_ = _c_index;
			_tmp27_ = _c_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _c_list;
			_tmp29_ = vala_list_get (_tmp28_, _c_index);
			c = (ValaConstant*) _tmp29_;
			_tmp30_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp30_, visitor);
			_vala_code_node_unref0 (c);
		}
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp31_;
		gint _m_size = 0;
		ValaList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _m_index = 0;
		_tmp31_ = self->priv->methods;
		_m_list = _tmp31_;
		_tmp32_ = _m_list;
		_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_m_size = _tmp34_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp35_;
			gint _tmp36_;
			ValaMethod* m = NULL;
			ValaList* _tmp37_;
			gpointer _tmp38_;
			ValaMethod* _tmp39_;
			_m_index = _m_index + 1;
			_tmp35_ = _m_index;
			_tmp36_ = _m_size;
			if (!(_tmp35_ < _tmp36_)) {
				break;
			}
			_tmp37_ = _m_list;
			_tmp38_ = vala_list_get (_tmp37_, _m_index);
			m = (ValaMethod*) _tmp38_;
			_tmp39_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp39_, visitor);
			_vala_code_node_unref0 (m);
		}
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp40_;
		gint _prop_size = 0;
		ValaList* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint _prop_index = 0;
		_tmp40_ = self->priv->properties;
		_prop_list = _tmp40_;
		_tmp41_ = _prop_list;
		_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_prop_size = _tmp43_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp44_;
			gint _tmp45_;
			ValaProperty* prop = NULL;
			ValaList* _tmp46_;
			gpointer _tmp47_;
			ValaProperty* _tmp48_;
			_prop_index = _prop_index + 1;
			_tmp44_ = _prop_index;
			_tmp45_ = _prop_size;
			if (!(_tmp44_ < _tmp45_)) {
				break;
			}
			_tmp46_ = _prop_list;
			_tmp47_ = vala_list_get (_tmp46_, _prop_index);
			prop = (ValaProperty*) _tmp47_;
			_tmp48_ = prop;
			vala_code_node_accept ((ValaCodeNode*) _tmp48_, visitor);
			_vala_code_node_unref0 (prop);
		}
	}
}

/**
 * Returns whether this is a boolean type.
 *
 * @return true if this is a boolean type, false otherwise
 */
gboolean
vala_struct_is_boolean_type (ValaStruct* self)
{
	ValaStruct* st = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaStruct* _tmp3_;
	gboolean* _tmp5_;
	gboolean* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	st = _tmp1_;
	_tmp3_ = st;
	if (_tmp3_ != NULL) {
		ValaStruct* _tmp4_;
		_tmp4_ = st;
		_tmp2_ = vala_struct_is_boolean_type (_tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp5_ = self->priv->boolean_type;
	if (_tmp5_ == NULL) {
		gboolean _tmp6_;
		gboolean* _tmp7_;
		_tmp6_ = vala_code_node_has_attribute ((ValaCodeNode*) self, "BooleanType");
		_tmp7_ = __bool_dup0 (&_tmp6_);
		_g_free0 (self->priv->boolean_type);
		self->priv->boolean_type = _tmp7_;
	}
	_tmp8_ = self->priv->boolean_type;
	result = *_tmp8_;
	return result;
}

/**
 * Returns whether this is an integer type.
 *
 * @return true if this is an integer type, false otherwise
 */
gboolean
vala_struct_is_integer_type (ValaStruct* self)
{
	ValaStruct* st = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaStruct* _tmp3_;
	gboolean* _tmp5_;
	gboolean* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	st = _tmp1_;
	_tmp3_ = st;
	if (_tmp3_ != NULL) {
		ValaStruct* _tmp4_;
		_tmp4_ = st;
		_tmp2_ = vala_struct_is_integer_type (_tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp5_ = self->priv->integer_type;
	if (_tmp5_ == NULL) {
		gboolean _tmp6_;
		gboolean* _tmp7_;
		_tmp6_ = vala_code_node_has_attribute ((ValaCodeNode*) self, "IntegerType");
		_tmp7_ = __bool_dup0 (&_tmp6_);
		_g_free0 (self->priv->integer_type);
		self->priv->integer_type = _tmp7_;
	}
	_tmp8_ = self->priv->integer_type;
	result = *_tmp8_;
	return result;
}

/**
 * Returns whether this is a floating point type.
 *
 * @return true if this is a floating point type, false otherwise
 */
gboolean
vala_struct_is_floating_type (ValaStruct* self)
{
	ValaStruct* st = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaStruct* _tmp3_;
	gboolean* _tmp5_;
	gboolean* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	st = _tmp1_;
	_tmp3_ = st;
	if (_tmp3_ != NULL) {
		ValaStruct* _tmp4_;
		_tmp4_ = st;
		_tmp2_ = vala_struct_is_floating_type (_tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp5_ = self->priv->floating_type;
	if (_tmp5_ == NULL) {
		gboolean _tmp6_;
		gboolean* _tmp7_;
		_tmp6_ = vala_code_node_has_attribute ((ValaCodeNode*) self, "FloatingType");
		_tmp7_ = __bool_dup0 (&_tmp6_);
		_g_free0 (self->priv->floating_type);
		self->priv->floating_type = _tmp7_;
	}
	_tmp8_ = self->priv->floating_type;
	result = *_tmp8_;
	return result;
}

gboolean
vala_struct_is_decimal_floating_type (ValaStruct* self)
{
	ValaStruct* st = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaStruct* _tmp3_;
	gboolean* _tmp5_;
	gboolean* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	st = _tmp1_;
	_tmp3_ = st;
	if (_tmp3_ != NULL) {
		ValaStruct* _tmp4_;
		_tmp4_ = st;
		_tmp2_ = vala_struct_is_decimal_floating_type (_tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp5_ = self->priv->decimal_floating_type;
	if (_tmp5_ == NULL) {
		gboolean _tmp6_;
		gboolean* _tmp7_;
		_tmp6_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "FloatingType", "decimal", FALSE);
		_tmp7_ = __bool_dup0 (&_tmp6_);
		_g_free0 (self->priv->decimal_floating_type);
		self->priv->decimal_floating_type = _tmp7_;
	}
	_tmp8_ = self->priv->decimal_floating_type;
	result = *_tmp8_;
	return result;
}

static gint
vala_struct_real_get_type_parameter_index (ValaTypeSymbol* base,
                                           const gchar* name)
{
	ValaStruct * self;
	gint i = 0;
	gint result;
	self = (ValaStruct*) base;
	g_return_val_if_fail (name != NULL, 0);
	i = 0;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		gint _p_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = self->priv->type_parameters;
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaTypeParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gint _tmp11_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = vala_list_get (_tmp6_, _p_index);
			p = (ValaTypeParameter*) _tmp7_;
			_tmp8_ = p;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (g_strcmp0 (_tmp10_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (p);
				return result;
			}
			_tmp11_ = i;
			i = _tmp11_ + 1;
			_vala_code_node_unref0 (p);
		}
	}
	result = -1;
	return result;
}

/**
 * Returns whether this struct is a simple type, i.e. whether
 * instances are passed by value.
 */
gboolean
vala_struct_is_simple_type (ValaStruct* self)
{
	ValaStruct* st = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaStruct* _tmp3_;
	gboolean* _tmp5_;
	gboolean* _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	st = _tmp1_;
	_tmp3_ = st;
	if (_tmp3_ != NULL) {
		ValaStruct* _tmp4_;
		_tmp4_ = st;
		_tmp2_ = vala_struct_is_simple_type (_tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp5_ = self->priv->simple_type;
	if (_tmp5_ == NULL) {
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean* _tmp9_;
		if (vala_code_node_has_attribute ((ValaCodeNode*) self, "SimpleType")) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = vala_code_node_has_attribute ((ValaCodeNode*) self, "BooleanType");
		}
		if (_tmp8_) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = vala_code_node_has_attribute ((ValaCodeNode*) self, "IntegerType");
		}
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = vala_code_node_has_attribute ((ValaCodeNode*) self, "FloatingType");
		}
		_tmp9_ = __bool_dup0 (&_tmp6_);
		_g_free0 (self->priv->simple_type);
		self->priv->simple_type = _tmp9_;
	}
	_tmp10_ = self->priv->simple_type;
	result = *_tmp10_;
	return result;
}

/**
 * Marks this struct as simple type, i.e. instances will be passed by
 * value.
 */
void
vala_struct_set_simple_type (ValaStruct* self,
                             gboolean simple_type)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&simple_type);
	_g_free0 (self->priv->simple_type);
	self->priv->simple_type = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "SimpleType", simple_type, NULL);
}

static void
vala_struct_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaStruct * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaStruct*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_struct_get_base_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_struct_set_base_type (self, new_type);
	}
}

static gboolean
vala_struct_real_is_subtype_of (ValaTypeSymbol* base,
                                ValaTypeSymbol* t)
{
	ValaStruct * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	gboolean result;
	self = (ValaStruct*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	_tmp0_ = vala_struct_get_base_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		ValaTypeSymbol* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		_tmp3_ = vala_struct_get_base_type (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_data_type_get_type_symbol (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ != NULL) {
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_tmp7_ = vala_struct_get_base_type (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp2_ = vala_typesymbol_is_subtype_of (_tmp10_, t);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

gboolean
vala_struct_is_disposable (ValaStruct* self)
{
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_code_node_has_attribute_argument ((ValaCodeNode*) self, "CCode", "destroy_function")) {
		result = TRUE;
		return result;
	}
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaStruct* _tmp2_;
		ValaStruct* _tmp3_;
		_tmp2_ = vala_struct_get_base_struct (self);
		_tmp3_ = _tmp2_;
		result = vala_struct_is_disposable (_tmp3_);
		return result;
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp4_;
		gint _f_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _f_index = 0;
		_tmp4_ = self->priv->fields;
		_f_list = _tmp4_;
		_tmp5_ = _f_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_f_size = _tmp7_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaField* f = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			ValaField* _tmp14_;
			ValaMemberBinding _tmp15_;
			ValaMemberBinding _tmp16_;
			_f_index = _f_index + 1;
			_tmp8_ = _f_index;
			_tmp9_ = _f_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _f_list;
			_tmp11_ = vala_list_get (_tmp10_, _f_index);
			f = (ValaField*) _tmp11_;
			_tmp14_ = f;
			_tmp15_ = vala_field_get_binding (_tmp14_);
			_tmp16_ = _tmp15_;
			if (_tmp16_ == VALA_MEMBER_BINDING_INSTANCE) {
				ValaField* _tmp17_;
				_tmp17_ = f;
				_tmp13_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp17_, "CCode", "delegate_target", TRUE);
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				ValaField* _tmp18_;
				ValaDataType* _tmp19_;
				ValaDataType* _tmp20_;
				_tmp18_ = f;
				_tmp19_ = vala_variable_get_variable_type ((ValaVariable*) _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp12_ = vala_data_type_is_disposable (_tmp20_);
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				if (vala_struct_is_simple_type (self)) {
					ValaField* _tmp21_;
					ValaSourceReference* _tmp22_;
					ValaSourceReference* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp21_ = f;
					_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp25_ = _tmp24_;
					vala_report_error (_tmp23_, "[SimpleType] struct `%s' cannot have owned heap-allocated fields", _tmp25_);
					_g_free0 (_tmp25_);
				}
				result = TRUE;
				_vala_code_node_unref0 (f);
				return result;
			}
			_vala_code_node_unref0 (f);
		}
	}
	result = FALSE;
	return result;
}

static gboolean
vala_struct_is_recursive_value_type (ValaStruct* self,
                                     ValaCodeContext* context,
                                     ValaDataType* type)
{
	ValaStructValueType* struct_type = NULL;
	gboolean _tmp0_ = FALSE;
	ValaStructValueType* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	struct_type = VALA_IS_STRUCT_VALUE_TYPE (type) ? ((ValaStructValueType*) type) : NULL;
	_tmp1_ = struct_type;
	if (_tmp1_ != NULL) {
		ValaStructValueType* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = struct_type;
		_tmp3_ = vala_data_type_get_nullable ((ValaDataType*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaStruct* st = NULL;
		ValaStructValueType* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaStruct* _tmp8_;
		ValaStruct* _tmp9_;
		_tmp5_ = struct_type;
		_tmp6_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp5_);
		_tmp7_ = _tmp6_;
		st = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp8_ = st;
		if (_tmp8_ == self) {
			result = TRUE;
			return result;
		}
		_tmp9_ = st;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp9_, context)) {
			result = FALSE;
			return result;
		}
		{
			ValaList* _f_list = NULL;
			ValaStruct* _tmp10_;
			ValaList* _tmp11_;
			gint _f_size = 0;
			ValaList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _f_index = 0;
			_tmp10_ = st;
			_tmp11_ = _tmp10_->priv->fields;
			_f_list = _tmp11_;
			_tmp12_ = _f_list;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_f_size = _tmp14_;
			_f_index = -1;
			while (TRUE) {
				gint _tmp15_;
				gint _tmp16_;
				ValaField* f = NULL;
				ValaList* _tmp17_;
				gpointer _tmp18_;
				gboolean _tmp19_ = FALSE;
				ValaField* _tmp20_;
				ValaMemberBinding _tmp21_;
				ValaMemberBinding _tmp22_;
				_f_index = _f_index + 1;
				_tmp15_ = _f_index;
				_tmp16_ = _f_size;
				if (!(_tmp15_ < _tmp16_)) {
					break;
				}
				_tmp17_ = _f_list;
				_tmp18_ = vala_list_get (_tmp17_, _f_index);
				f = (ValaField*) _tmp18_;
				_tmp20_ = f;
				_tmp21_ = vala_field_get_binding (_tmp20_);
				_tmp22_ = _tmp21_;
				if (_tmp22_ == VALA_MEMBER_BINDING_INSTANCE) {
					ValaField* _tmp23_;
					ValaDataType* _tmp24_;
					ValaDataType* _tmp25_;
					_tmp23_ = f;
					_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) _tmp23_);
					_tmp25_ = _tmp24_;
					_tmp19_ = vala_struct_is_recursive_value_type (self, context, _tmp25_);
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					result = TRUE;
					_vala_code_node_unref0 (f);
					return result;
				}
				_vala_code_node_unref0 (f);
			}
		}
	}
	result = FALSE;
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_struct_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaStruct * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	gboolean _tmp175_ = FALSE;
	gboolean _tmp176_;
	gboolean _tmp177_;
	ValaSemanticAnalyzer* _tmp208_;
	ValaSemanticAnalyzer* _tmp209_;
	ValaSourceFile* _tmp210_;
	ValaSemanticAnalyzer* _tmp211_;
	ValaSemanticAnalyzer* _tmp212_;
	ValaSymbol* _tmp213_;
	gboolean _tmp214_;
	gboolean _tmp215_;
	gboolean result;
	self = (ValaStruct*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	_tmp24_ = vala_struct_get_base_type (self);
	_tmp25_ = _tmp24_;
	if (_tmp25_ != NULL) {
		ValaDataType* _tmp26_;
		ValaDataType* _tmp27_;
		ValaDataType* _tmp28_;
		ValaDataType* _tmp29_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		_tmp26_ = vala_struct_get_base_type (self);
		_tmp27_ = _tmp26_;
		vala_code_node_check ((ValaCodeNode*) _tmp27_, context);
		_tmp28_ = vala_struct_get_base_type (self);
		_tmp29_ = _tmp28_;
		if (!VALA_IS_VALUE_TYPE (_tmp29_)) {
			ValaSourceReference* _tmp30_;
			ValaSourceReference* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_struct_get_base_type (self);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_code_node_to_string ((ValaCodeNode*) _tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp37_ = _tmp36_;
			vala_report_error (_tmp31_, "The base type `%s' of struct `%s' is not a struct", _tmp35_, _tmp37_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp35_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp38_ = vala_struct_get_base_type (self);
		_tmp39_ = _tmp38_;
		if (!vala_data_type_is_accessible (_tmp39_, (ValaSymbol*) self)) {
			ValaSourceReference* _tmp40_;
			ValaSourceReference* _tmp41_;
			ValaDataType* _tmp42_;
			ValaDataType* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_struct_get_base_type (self);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_code_node_to_string ((ValaCodeNode*) _tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp47_ = _tmp46_;
			vala_report_error (_tmp41_, "base type `%s' is less accessible than struct `%s'", _tmp45_, _tmp47_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp45_);
		}
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp48_;
		gint _p_size = 0;
		ValaList* _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		gint _p_index = 0;
		_tmp48_ = self->priv->type_parameters;
		_p_list = _tmp48_;
		_tmp49_ = _p_list;
		_tmp50_ = vala_collection_get_size ((ValaCollection*) _tmp49_);
		_tmp51_ = _tmp50_;
		_p_size = _tmp51_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp52_;
			gint _tmp53_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp54_;
			gpointer _tmp55_;
			ValaTypeParameter* _tmp56_;
			_p_index = _p_index + 1;
			_tmp52_ = _p_index;
			_tmp53_ = _p_size;
			if (!(_tmp52_ < _tmp53_)) {
				break;
			}
			_tmp54_ = _p_list;
			_tmp55_ = vala_list_get (_tmp54_, _p_index);
			p = (ValaTypeParameter*) _tmp55_;
			_tmp56_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp56_, context);
			_vala_code_node_unref0 (p);
		}
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp57_;
		gint _f_size = 0;
		ValaList* _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		gint _f_index = 0;
		_tmp57_ = self->priv->fields;
		_f_list = _tmp57_;
		_tmp58_ = _f_list;
		_tmp59_ = vala_collection_get_size ((ValaCollection*) _tmp58_);
		_tmp60_ = _tmp59_;
		_f_size = _tmp60_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp61_;
			gint _tmp62_;
			ValaField* f = NULL;
			ValaList* _tmp63_;
			gpointer _tmp64_;
			ValaField* _tmp65_;
			gboolean _tmp66_ = FALSE;
			ValaField* _tmp67_;
			ValaMemberBinding _tmp68_;
			ValaMemberBinding _tmp69_;
			gboolean _tmp76_ = FALSE;
			ValaField* _tmp77_;
			ValaMemberBinding _tmp78_;
			ValaMemberBinding _tmp79_;
			gboolean _tmp86_ = FALSE;
			ValaField* _tmp87_;
			ValaMemberBinding _tmp88_;
			ValaMemberBinding _tmp89_;
			_f_index = _f_index + 1;
			_tmp61_ = _f_index;
			_tmp62_ = _f_size;
			if (!(_tmp61_ < _tmp62_)) {
				break;
			}
			_tmp63_ = _f_list;
			_tmp64_ = vala_list_get (_tmp63_, _f_index);
			f = (ValaField*) _tmp64_;
			_tmp65_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp65_, context);
			_tmp67_ = f;
			_tmp68_ = vala_field_get_binding (_tmp67_);
			_tmp69_ = _tmp68_;
			if (_tmp69_ == VALA_MEMBER_BINDING_INSTANCE) {
				ValaField* _tmp70_;
				ValaDataType* _tmp71_;
				ValaDataType* _tmp72_;
				_tmp70_ = f;
				_tmp71_ = vala_variable_get_variable_type ((ValaVariable*) _tmp70_);
				_tmp72_ = _tmp71_;
				_tmp66_ = vala_struct_is_recursive_value_type (self, context, _tmp72_);
			} else {
				_tmp66_ = FALSE;
			}
			if (_tmp66_) {
				ValaField* _tmp73_;
				ValaSourceReference* _tmp74_;
				ValaSourceReference* _tmp75_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp73_ = f;
				_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
				_tmp75_ = _tmp74_;
				vala_report_error (_tmp75_, "Recursive value types are not allowed");
				result = FALSE;
				_vala_code_node_unref0 (f);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp77_ = f;
			_tmp78_ = vala_field_get_binding (_tmp77_);
			_tmp79_ = _tmp78_;
			if (_tmp79_ == VALA_MEMBER_BINDING_INSTANCE) {
				ValaField* _tmp80_;
				ValaExpression* _tmp81_;
				ValaExpression* _tmp82_;
				_tmp80_ = f;
				_tmp81_ = vala_variable_get_initializer ((ValaVariable*) _tmp80_);
				_tmp82_ = _tmp81_;
				_tmp76_ = _tmp82_ != NULL;
			} else {
				_tmp76_ = FALSE;
			}
			if (_tmp76_) {
				ValaField* _tmp83_;
				ValaSourceReference* _tmp84_;
				ValaSourceReference* _tmp85_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp83_ = f;
				_tmp84_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp83_);
				_tmp85_ = _tmp84_;
				vala_report_error (_tmp85_, "Instance field initializers not supported");
				result = FALSE;
				_vala_code_node_unref0 (f);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp87_ = f;
			_tmp88_ = vala_field_get_binding (_tmp87_);
			_tmp89_ = _tmp88_;
			if (_tmp89_ == VALA_MEMBER_BINDING_STATIC) {
				ValaField* _tmp90_;
				ValaExpression* _tmp91_;
				ValaExpression* _tmp92_;
				_tmp90_ = f;
				_tmp91_ = vala_variable_get_initializer ((ValaVariable*) _tmp90_);
				_tmp92_ = _tmp91_;
				_tmp86_ = _tmp92_ != NULL;
			} else {
				_tmp86_ = FALSE;
			}
			if (_tmp86_) {
				gboolean _tmp93_ = FALSE;
				gboolean _tmp94_ = FALSE;
				gboolean _tmp95_ = FALSE;
				ValaSet* _tmp96_;
				ValaField* _tmp97_;
				_tmp96_ = self->priv->property_fields;
				_tmp97_ = f;
				if (!vala_collection_contains ((ValaCollection*) _tmp96_, _tmp97_)) {
					ValaField* _tmp98_;
					ValaExpression* _tmp99_;
					ValaExpression* _tmp100_;
					ValaDataType* _tmp101_;
					ValaDataType* _tmp102_;
					_tmp98_ = f;
					_tmp99_ = vala_variable_get_initializer ((ValaVariable*) _tmp98_);
					_tmp100_ = _tmp99_;
					_tmp101_ = vala_expression_get_value_type (_tmp100_);
					_tmp102_ = _tmp101_;
					_tmp95_ = !VALA_IS_NULL_TYPE (_tmp102_);
				} else {
					_tmp95_ = FALSE;
				}
				if (_tmp95_) {
					ValaField* _tmp103_;
					ValaDataType* _tmp104_;
					ValaDataType* _tmp105_;
					_tmp103_ = f;
					_tmp104_ = vala_variable_get_variable_type ((ValaVariable*) _tmp103_);
					_tmp105_ = _tmp104_;
					_tmp94_ = vala_data_type_is_disposable (_tmp105_);
				} else {
					_tmp94_ = FALSE;
				}
				if (_tmp94_) {
					ValaField* _tmp106_;
					ValaDataType* _tmp107_;
					ValaDataType* _tmp108_;
					gboolean _tmp109_;
					gboolean _tmp110_;
					_tmp106_ = f;
					_tmp107_ = vala_variable_get_variable_type ((ValaVariable*) _tmp106_);
					_tmp108_ = _tmp107_;
					_tmp109_ = vala_data_type_get_value_owned (_tmp108_);
					_tmp110_ = _tmp109_;
					_tmp93_ = _tmp110_;
				} else {
					_tmp93_ = FALSE;
				}
				if (_tmp93_) {
					ValaField* _tmp111_;
					ValaExpression* _tmp112_;
					ValaExpression* _tmp113_;
					ValaSourceReference* _tmp114_;
					ValaSourceReference* _tmp115_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp111_ = f;
					_tmp112_ = vala_variable_get_initializer ((ValaVariable*) _tmp111_);
					_tmp113_ = _tmp112_;
					_tmp114_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp113_);
					_tmp115_ = _tmp114_;
					vala_report_error (_tmp115_, "Owned static struct fields can only be initialized in a function or me" \
"thod");
				}
			}
			_vala_code_node_unref0 (f);
		}
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp116_;
		gint _c_size = 0;
		ValaList* _tmp117_;
		gint _tmp118_;
		gint _tmp119_;
		gint _c_index = 0;
		_tmp116_ = self->priv->constants;
		_c_list = _tmp116_;
		_tmp117_ = _c_list;
		_tmp118_ = vala_collection_get_size ((ValaCollection*) _tmp117_);
		_tmp119_ = _tmp118_;
		_c_size = _tmp119_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp120_;
			gint _tmp121_;
			ValaConstant* c = NULL;
			ValaList* _tmp122_;
			gpointer _tmp123_;
			ValaConstant* _tmp124_;
			_c_index = _c_index + 1;
			_tmp120_ = _c_index;
			_tmp121_ = _c_size;
			if (!(_tmp120_ < _tmp121_)) {
				break;
			}
			_tmp122_ = _c_list;
			_tmp123_ = vala_list_get (_tmp122_, _c_index);
			c = (ValaConstant*) _tmp123_;
			_tmp124_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp124_, context);
			_vala_code_node_unref0 (c);
		}
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp125_;
		gint _m_size = 0;
		ValaList* _tmp126_;
		gint _tmp127_;
		gint _tmp128_;
		gint _m_index = 0;
		_tmp125_ = self->priv->methods;
		_m_list = _tmp125_;
		_tmp126_ = _m_list;
		_tmp127_ = vala_collection_get_size ((ValaCollection*) _tmp126_);
		_tmp128_ = _tmp127_;
		_m_size = _tmp128_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp129_;
			gint _tmp130_;
			ValaMethod* m = NULL;
			ValaList* _tmp131_;
			gpointer _tmp132_;
			ValaMethod* _tmp133_;
			_m_index = _m_index + 1;
			_tmp129_ = _m_index;
			_tmp130_ = _m_size;
			if (!(_tmp129_ < _tmp130_)) {
				break;
			}
			_tmp131_ = _m_list;
			_tmp132_ = vala_list_get (_tmp131_, _m_index);
			m = (ValaMethod*) _tmp132_;
			_tmp133_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp133_, context);
			_vala_code_node_unref0 (m);
		}
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp134_;
		gint _prop_size = 0;
		ValaList* _tmp135_;
		gint _tmp136_;
		gint _tmp137_;
		gint _prop_index = 0;
		_tmp134_ = self->priv->properties;
		_prop_list = _tmp134_;
		_tmp135_ = _prop_list;
		_tmp136_ = vala_collection_get_size ((ValaCollection*) _tmp135_);
		_tmp137_ = _tmp136_;
		_prop_size = _tmp137_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp138_;
			gint _tmp139_;
			ValaProperty* prop = NULL;
			ValaList* _tmp140_;
			gpointer _tmp141_;
			ValaProperty* _tmp142_;
			ValaProperty* _tmp143_;
			ValaMemberBinding _tmp144_;
			ValaMemberBinding _tmp145_;
			_prop_index = _prop_index + 1;
			_tmp138_ = _prop_index;
			_tmp139_ = _prop_size;
			if (!(_tmp138_ < _tmp139_)) {
				break;
			}
			_tmp140_ = _prop_list;
			_tmp141_ = vala_list_get (_tmp140_, _prop_index);
			prop = (ValaProperty*) _tmp141_;
			_tmp142_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp142_, context);
			_tmp143_ = prop;
			_tmp144_ = vala_property_get_binding (_tmp143_);
			_tmp145_ = _tmp144_;
			if (_tmp145_ == VALA_MEMBER_BINDING_STATIC) {
				ValaField* field = NULL;
				ValaProperty* _tmp146_;
				ValaField* _tmp147_;
				ValaField* _tmp148_;
				gboolean _tmp149_ = FALSE;
				gboolean _tmp150_ = FALSE;
				gboolean _tmp151_ = FALSE;
				gboolean _tmp152_ = FALSE;
				ValaField* _tmp153_;
				_tmp146_ = prop;
				_tmp147_ = vala_property_get_field (_tmp146_);
				_tmp148_ = _tmp147_;
				field = _tmp148_;
				_tmp153_ = field;
				if (_tmp153_ != NULL) {
					ValaField* _tmp154_;
					ValaExpression* _tmp155_;
					ValaExpression* _tmp156_;
					_tmp154_ = field;
					_tmp155_ = vala_variable_get_initializer ((ValaVariable*) _tmp154_);
					_tmp156_ = _tmp155_;
					_tmp152_ = _tmp156_ != NULL;
				} else {
					_tmp152_ = FALSE;
				}
				if (_tmp152_) {
					ValaField* _tmp157_;
					ValaExpression* _tmp158_;
					ValaExpression* _tmp159_;
					ValaDataType* _tmp160_;
					ValaDataType* _tmp161_;
					_tmp157_ = field;
					_tmp158_ = vala_variable_get_initializer ((ValaVariable*) _tmp157_);
					_tmp159_ = _tmp158_;
					_tmp160_ = vala_expression_get_value_type (_tmp159_);
					_tmp161_ = _tmp160_;
					_tmp151_ = !VALA_IS_NULL_TYPE (_tmp161_);
				} else {
					_tmp151_ = FALSE;
				}
				if (_tmp151_) {
					ValaField* _tmp162_;
					ValaDataType* _tmp163_;
					ValaDataType* _tmp164_;
					_tmp162_ = field;
					_tmp163_ = vala_variable_get_variable_type ((ValaVariable*) _tmp162_);
					_tmp164_ = _tmp163_;
					_tmp150_ = vala_data_type_is_disposable (_tmp164_);
				} else {
					_tmp150_ = FALSE;
				}
				if (_tmp150_) {
					ValaField* _tmp165_;
					ValaDataType* _tmp166_;
					ValaDataType* _tmp167_;
					gboolean _tmp168_;
					gboolean _tmp169_;
					_tmp165_ = field;
					_tmp166_ = vala_variable_get_variable_type ((ValaVariable*) _tmp165_);
					_tmp167_ = _tmp166_;
					_tmp168_ = vala_data_type_get_value_owned (_tmp167_);
					_tmp169_ = _tmp168_;
					_tmp149_ = _tmp169_;
				} else {
					_tmp149_ = FALSE;
				}
				if (_tmp149_) {
					ValaField* _tmp170_;
					ValaExpression* _tmp171_;
					ValaExpression* _tmp172_;
					ValaSourceReference* _tmp173_;
					ValaSourceReference* _tmp174_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp170_ = field;
					_tmp171_ = vala_variable_get_initializer ((ValaVariable*) _tmp170_);
					_tmp172_ = _tmp171_;
					_tmp173_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp172_);
					_tmp174_ = _tmp173_;
					vala_report_error (_tmp174_, "Owned static struct properties can only be initialized in a function o" \
"r method");
				}
			}
			_vala_code_node_unref0 (prop);
		}
	}
	vala_struct_is_disposable (self);
	_tmp176_ = vala_symbol_get_external ((ValaSymbol*) self);
	_tmp177_ = _tmp176_;
	if (!_tmp177_) {
		gboolean _tmp178_;
		gboolean _tmp179_;
		_tmp178_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp179_ = _tmp178_;
		_tmp175_ = !_tmp179_;
	} else {
		_tmp175_ = FALSE;
	}
	if (_tmp175_) {
		gboolean has_instance_field = FALSE;
		gboolean _tmp191_ = FALSE;
		gboolean _tmp192_ = FALSE;
		gboolean _tmp193_ = FALSE;
		gboolean _tmp194_ = FALSE;
		ValaDataType* _tmp195_;
		ValaDataType* _tmp196_;
		has_instance_field = FALSE;
		{
			ValaList* _f_list = NULL;
			ValaList* _tmp180_;
			gint _f_size = 0;
			ValaList* _tmp181_;
			gint _tmp182_;
			gint _tmp183_;
			gint _f_index = 0;
			_tmp180_ = self->priv->fields;
			_f_list = _tmp180_;
			_tmp181_ = _f_list;
			_tmp182_ = vala_collection_get_size ((ValaCollection*) _tmp181_);
			_tmp183_ = _tmp182_;
			_f_size = _tmp183_;
			_f_index = -1;
			while (TRUE) {
				gint _tmp184_;
				gint _tmp185_;
				ValaField* f = NULL;
				ValaList* _tmp186_;
				gpointer _tmp187_;
				ValaField* _tmp188_;
				ValaMemberBinding _tmp189_;
				ValaMemberBinding _tmp190_;
				_f_index = _f_index + 1;
				_tmp184_ = _f_index;
				_tmp185_ = _f_size;
				if (!(_tmp184_ < _tmp185_)) {
					break;
				}
				_tmp186_ = _f_list;
				_tmp187_ = vala_list_get (_tmp186_, _f_index);
				f = (ValaField*) _tmp187_;
				_tmp188_ = f;
				_tmp189_ = vala_field_get_binding (_tmp188_);
				_tmp190_ = _tmp189_;
				if (_tmp190_ == VALA_MEMBER_BINDING_INSTANCE) {
					has_instance_field = TRUE;
					_vala_code_node_unref0 (f);
					break;
				}
				_vala_code_node_unref0 (f);
			}
		}
		_tmp195_ = vala_struct_get_base_type (self);
		_tmp196_ = _tmp195_;
		if (_tmp196_ == NULL) {
			_tmp194_ = !has_instance_field;
		} else {
			_tmp194_ = FALSE;
		}
		if (_tmp194_) {
			_tmp193_ = !vala_struct_is_boolean_type (self);
		} else {
			_tmp193_ = FALSE;
		}
		if (_tmp193_) {
			_tmp192_ = !vala_struct_is_integer_type (self);
		} else {
			_tmp192_ = FALSE;
		}
		if (_tmp192_) {
			_tmp191_ = !vala_struct_is_floating_type (self);
		} else {
			_tmp191_ = FALSE;
		}
		if (_tmp191_) {
			ValaSourceReference* _tmp197_;
			ValaSourceReference* _tmp198_;
			gchar* _tmp199_;
			gchar* _tmp200_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp197_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp198_ = _tmp197_;
			_tmp199_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp200_ = _tmp199_;
			vala_report_error (_tmp198_, "struct `%s' cannot be empty", _tmp200_);
			_g_free0 (_tmp200_);
		} else {
			gboolean _tmp201_ = FALSE;
			ValaDataType* _tmp202_;
			ValaDataType* _tmp203_;
			_tmp202_ = vala_struct_get_base_type (self);
			_tmp203_ = _tmp202_;
			if (_tmp203_ != NULL) {
				_tmp201_ = has_instance_field;
			} else {
				_tmp201_ = FALSE;
			}
			if (_tmp201_) {
				ValaSourceReference* _tmp204_;
				ValaSourceReference* _tmp205_;
				gchar* _tmp206_;
				gchar* _tmp207_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp204_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp205_ = _tmp204_;
				_tmp206_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp207_ = _tmp206_;
				vala_report_error (_tmp205_, "derived struct `%s' may not have instance fields", _tmp207_);
				_g_free0 (_tmp207_);
			}
		}
	}
	_tmp208_ = vala_code_context_get_analyzer (context);
	_tmp209_ = _tmp208_;
	_tmp210_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp209_, _tmp210_);
	_tmp211_ = vala_code_context_get_analyzer (context);
	_tmp212_ = _tmp211_;
	_tmp213_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp212_, _tmp213_);
	_tmp214_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp215_ = _tmp214_;
	result = !_tmp215_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_struct_class_init (ValaStructClass * klass,
                        gpointer klass_data)
{
	vala_struct_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_struct_finalize;
	g_type_class_adjust_private_offset (klass, &ValaStruct_private_offset);
	((ValaSymbolClass *) klass)->add_constant = (void (*) (ValaSymbol*, ValaConstant*)) vala_struct_real_add_constant;
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_struct_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_struct_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_struct_real_add_property;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_struct_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_struct_real_accept_children;
	((ValaTypeSymbolClass *) klass)->get_type_parameter_index = (gint (*) (ValaTypeSymbol*, const gchar*)) vala_struct_real_get_type_parameter_index;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_struct_real_replace_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_struct_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_struct_real_check;
}

static void
vala_struct_instance_init (ValaStruct * self,
                           gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	GEqualFunc _tmp6_;
	ValaArrayList* _tmp7_;
	GEqualFunc _tmp8_;
	ValaArrayList* _tmp9_;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	ValaHashSet* _tmp12_;
	self->priv = vala_struct_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_parameters = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->constants = (ValaList*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
	self->priv->fields = (ValaList*) _tmp5_;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp6_);
	self->priv->methods = (ValaList*) _tmp7_;
	_tmp8_ = g_direct_equal;
	_tmp9_ = vala_array_list_new (VALA_TYPE_PROPERTY, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp8_);
	self->priv->properties = (ValaList*) _tmp9_;
	_tmp10_ = g_direct_hash;
	_tmp11_ = g_direct_equal;
	_tmp12_ = vala_hash_set_new (VALA_TYPE_FIELD, NULL, NULL, _tmp10_, _tmp11_);
	self->priv->property_fields = (ValaSet*) _tmp12_;
	self->priv->_base_type = NULL;
}

static void
vala_struct_finalize (ValaCodeNode * obj)
{
	ValaStruct * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_STRUCT, ValaStruct);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_iterable_unref0 (self->priv->constants);
	_vala_iterable_unref0 (self->priv->fields);
	_vala_iterable_unref0 (self->priv->methods);
	_vala_iterable_unref0 (self->priv->properties);
	_vala_iterable_unref0 (self->priv->property_fields);
	_vala_code_node_unref0 (self->priv->_base_type);
	_g_free0 (self->priv->boolean_type);
	_g_free0 (self->priv->integer_type);
	_g_free0 (self->priv->floating_type);
	_g_free0 (self->priv->decimal_floating_type);
	_g_free0 (self->priv->simple_type);
	_g_free0 (self->priv->_rank);
	_g_free0 (self->priv->_width);
	_g_free0 (self->priv->_signed);
	_g_free0 (self->priv->_is_immutable);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	VALA_CODE_NODE_CLASS (vala_struct_parent_class)->finalize (obj);
}

/**
 * Represents a struct declaration in the source code.
 */
static GType
vala_struct_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaStructClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_struct_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaStruct), 0, (GInstanceInitFunc) vala_struct_instance_init, NULL };
	GType vala_struct_type_id;
	vala_struct_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaStruct", &g_define_type_info, 0);
	ValaStruct_private_offset = g_type_add_instance_private (vala_struct_type_id, sizeof (ValaStructPrivate));
	return vala_struct_type_id;
}

GType
vala_struct_get_type (void)
{
	static volatile gsize vala_struct_type_id__once = 0;
	if (g_once_init_enter (&vala_struct_type_id__once)) {
		GType vala_struct_type_id;
		vala_struct_type_id = vala_struct_get_type_once ();
		g_once_init_leave (&vala_struct_type_id__once, vala_struct_type_id);
	}
	return vala_struct_type_id__once;
}

