/* Stream.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Stream.vala, do not modify */

/* Smoothing function adapted from https://gitlab.gnome.org/GNOME/gnome-control-center/-/blob/ea8bafc5d1ebb945a0806b03dea0c3abf29c58d9/panels/sound/cc-level-bar.c*/

#include <glib-object.h>
#include <gst/gst.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#define TUBA_WIDGETS_AUDIO_STREAM_SMOOTHING 0.4
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TUBA_WIDGETS_AUDIO_TYPE_STREAM (tuba_widgets_audio_stream_get_type ())
#define TUBA_WIDGETS_AUDIO_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_WIDGETS_AUDIO_TYPE_STREAM, TubaWidgetsAudioStream))
#define TUBA_WIDGETS_AUDIO_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_WIDGETS_AUDIO_TYPE_STREAM, TubaWidgetsAudioStreamClass))
#define TUBA_WIDGETS_AUDIO_IS_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_WIDGETS_AUDIO_TYPE_STREAM))
#define TUBA_WIDGETS_AUDIO_IS_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_WIDGETS_AUDIO_TYPE_STREAM))
#define TUBA_WIDGETS_AUDIO_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_WIDGETS_AUDIO_TYPE_STREAM, TubaWidgetsAudioStreamClass))

typedef struct _TubaWidgetsAudioStream TubaWidgetsAudioStream;
typedef struct _TubaWidgetsAudioStreamClass TubaWidgetsAudioStreamClass;
typedef struct _TubaWidgetsAudioStreamPrivate TubaWidgetsAudioStreamPrivate;
enum  {
	TUBA_WIDGETS_AUDIO_STREAM_0_PROPERTY,
	TUBA_WIDGETS_AUDIO_STREAM_LEVEL_PROPERTY,
	TUBA_WIDGETS_AUDIO_STREAM_VOLUME_PROPERTY,
	TUBA_WIDGETS_AUDIO_STREAM_MUTED_PROPERTY,
	TUBA_WIDGETS_AUDIO_STREAM_READY_PROPERTY,
	TUBA_WIDGETS_AUDIO_STREAM_PROGRESS_PROPERTY,
	TUBA_WIDGETS_AUDIO_STREAM_DURATION_PROPERTY,
	TUBA_WIDGETS_AUDIO_STREAM_CURRENT_PROPERTY,
	TUBA_WIDGETS_AUDIO_STREAM_URL_PROPERTY,
	TUBA_WIDGETS_AUDIO_STREAM_STATE_PROPERTY,
	TUBA_WIDGETS_AUDIO_STREAM_NUM_PROPERTIES
};
static GParamSpec* tuba_widgets_audio_stream_properties[TUBA_WIDGETS_AUDIO_STREAM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	TUBA_WIDGETS_AUDIO_STREAM_ENDED_SIGNAL,
	TUBA_WIDGETS_AUDIO_STREAM_NUM_SIGNALS
};
static guint tuba_widgets_audio_stream_signals[TUBA_WIDGETS_AUDIO_STREAM_NUM_SIGNALS] = {0};

struct _TubaWidgetsAudioStream {
	GObject parent_instance;
	TubaWidgetsAudioStreamPrivate * priv;
};

struct _TubaWidgetsAudioStreamClass {
	GObjectClass parent_class;
};

struct _TubaWidgetsAudioStreamPrivate {
	GstBin* pipeline;
	GstBus* bus;
	GstElement* uridecodebin;
	gdouble _level;
	gdouble _volume;
	gboolean _muted;
	gboolean _ready;
	gint64 _duration;
	gint64 _current;
	gchar* _url;
	GstState _state;
	guint timeout_id;
};

static gint TubaWidgetsAudioStream_private_offset;
static gpointer tuba_widgets_audio_stream_parent_class = NULL;

VALA_EXTERN GType tuba_widgets_audio_stream_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaWidgetsAudioStream, g_object_unref)
static gboolean tuba_widgets_audio_stream_update_metadata (TubaWidgetsAudioStream* self);
VALA_EXTERN GstState tuba_widgets_audio_stream_get_state (TubaWidgetsAudioStream* self);
static void tuba_widgets_audio_stream_update_current (TubaWidgetsAudioStream* self);
static gboolean tuba_widgets_audio_stream_bus_callback (TubaWidgetsAudioStream* self,
                                                 GstBus* bus,
                                                 GstMessage* message);
VALA_EXTERN gboolean tuba_widgets_audio_stream_get_ready (TubaWidgetsAudioStream* self);
static void tuba_widgets_audio_stream_set_ready (TubaWidgetsAudioStream* self,
                                          gboolean value);
VALA_EXTERN gdouble tuba_widgets_audio_stream_get_level (TubaWidgetsAudioStream* self);
static void tuba_widgets_audio_stream_set_level (TubaWidgetsAudioStream* self,
                                          gdouble value);
VALA_EXTERN gint64 tuba_widgets_audio_stream_get_duration (TubaWidgetsAudioStream* self);
static void tuba_widgets_audio_stream_update_duration (TubaWidgetsAudioStream* self);
VALA_EXTERN const gchar* tuba_widgets_audio_stream_get_url (TubaWidgetsAudioStream* self);
static void tuba_widgets_audio_stream_set_duration (TubaWidgetsAudioStream* self,
                                             gint64 value);
VALA_EXTERN gint64 tuba_widgets_audio_stream_get_current (TubaWidgetsAudioStream* self);
static void tuba_widgets_audio_stream_set_current (TubaWidgetsAudioStream* self,
                                            gint64 value);
VALA_EXTERN void tuba_widgets_audio_stream_destroy (TubaWidgetsAudioStream* self);
VALA_EXTERN void tuba_widgets_audio_stream_set_state (TubaWidgetsAudioStream* self,
                                          GstState value);
VALA_EXTERN TubaWidgetsAudioStream* tuba_widgets_audio_stream_new (void);
VALA_EXTERN TubaWidgetsAudioStream* tuba_widgets_audio_stream_construct (GType object_type);
VALA_EXTERN gdouble tuba_widgets_audio_stream_get_volume (TubaWidgetsAudioStream* self);
VALA_EXTERN void tuba_widgets_audio_stream_set_volume (TubaWidgetsAudioStream* self,
                                           gdouble value);
VALA_EXTERN gboolean tuba_widgets_audio_stream_get_muted (TubaWidgetsAudioStream* self);
VALA_EXTERN void tuba_widgets_audio_stream_set_muted (TubaWidgetsAudioStream* self,
                                          gboolean value);
VALA_EXTERN void tuba_widgets_audio_stream_set_progress (TubaWidgetsAudioStream* self,
                                             gdouble value);
VALA_EXTERN void tuba_widgets_audio_stream_set_url (TubaWidgetsAudioStream* self,
                                        const gchar* value);
static GObject * tuba_widgets_audio_stream_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties);
static gboolean _tuba_widgets_audio_stream_bus_callback_gst_bus_func (GstBus* bus,
                                                               GstMessage* message,
                                                               gpointer self);
static gboolean _tuba_widgets_audio_stream_update_metadata_gsource_func (gpointer self);
static void tuba_widgets_audio_stream_finalize (GObject * obj);
static GType tuba_widgets_audio_stream_get_type_once (void);
static void _vala_tuba_widgets_audio_stream_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_tuba_widgets_audio_stream_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);

static inline gpointer
tuba_widgets_audio_stream_get_instance_private (TubaWidgetsAudioStream* self)
{
	return G_STRUCT_MEMBER_P (self, TubaWidgetsAudioStream_private_offset);
}

static gboolean
tuba_widgets_audio_stream_update_metadata (TubaWidgetsAudioStream* self)
{
	GstBus* _tmp0_;
	GstState _tmp1_;
	GstState _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->bus;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = tuba_widgets_audio_stream_get_state (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ <= GST_STATE_PAUSED) {
		result = TRUE;
		return result;
	}
	tuba_widgets_audio_stream_update_current (self);
	result = TRUE;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
tuba_widgets_audio_stream_bus_callback (TubaWidgetsAudioStream* self,
                                        GstBus* bus,
                                        GstMessage* message)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	switch (message->type) {
		case GST_MESSAGE_ERROR:
		{
			GError* err = NULL;
			gchar* debug_log = NULL;
			GError* _tmp0_ = NULL;
			gchar* _tmp1_ = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gst_message_parse_error (message, &_tmp0_, &_tmp1_);
			_g_error_free0 (err);
			err = _tmp0_;
			_g_free0 (debug_log);
			debug_log = _tmp1_;
			_tmp2_ = err;
			_tmp3_ = _tmp2_->message;
			_tmp4_ = string_to_string (_tmp3_);
			_tmp5_ = g_strconcat ("Gst Error: ", _tmp4_, NULL);
			_tmp6_ = _tmp5_;
			g_critical ("Stream.vala:58: %s", _tmp6_);
			_g_free0 (_tmp6_);
			_tmp7_ = debug_log;
			_tmp8_ = string_to_string (_tmp7_);
			_tmp9_ = g_strconcat ("Gst Error Debug: ", _tmp8_, NULL);
			_tmp10_ = _tmp9_;
			g_debug ("Stream.vala:59: %s", _tmp10_);
			_g_free0 (_tmp10_);
			_g_free0 (debug_log);
			_g_error_free0 (err);
			break;
		}
		case GST_MESSAGE_EOS:
		{
			GstBin* _tmp11_;
			_tmp11_ = self->priv->pipeline;
			gst_element_seek_simple ((GstElement*) _tmp11_, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH, (gint64) 0);
			g_signal_emit (self, tuba_widgets_audio_stream_signals[TUBA_WIDGETS_AUDIO_STREAM_ENDED_SIGNAL], 0);
			break;
		}
		case GST_MESSAGE_STATE_CHANGED:
		{
			GstState _tmp12_ = 0;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
			gst_message_parse_state_changed (message, NULL, &_tmp12_, NULL);
			self->priv->_state = _tmp12_;
			_tmp14_ = self->priv->_ready;
			if (!_tmp14_) {
				gboolean _tmp15_ = FALSE;
				if (self->priv->_state == GST_STATE_READY) {
					_tmp15_ = TRUE;
				} else {
					_tmp15_ = self->priv->_state == GST_STATE_PLAYING;
				}
				_tmp13_ = _tmp15_;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				tuba_widgets_audio_stream_set_ready (self, TRUE);
			}
			break;
		}
		case GST_MESSAGE_ELEMENT:
		{
			GstStructure* s = NULL;
			GstStructure* _tmp16_;
			gboolean _tmp17_ = FALSE;
			GstStructure* _tmp18_;
			_tmp16_ = gst_message_get_structure (message);
			s = _tmp16_;
			_tmp18_ = s;
			if (_tmp18_ != NULL) {
				GstStructure* _tmp19_;
				const gchar* _tmp20_;
				_tmp19_ = s;
				_tmp20_ = gst_structure_get_name (_tmp19_);
				_tmp17_ = g_strcmp0 (_tmp20_, "level") == 0;
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				GValue peaks = {0};
				GstStructure* _tmp21_;
				GValueArray* value_array = NULL;
				void* _tmp22_;
				gdouble level_sum = 0.0;
				GValueArray* _tmp23_;
				gdouble levels = 0.0;
				GValueArray* _tmp24_;
				gdouble _tmp25_;
				_tmp21_ = s;
				peaks = *gst_structure_get_value (_tmp21_, "peak");
				_tmp22_ = g_value_get_boxed (&peaks);
				value_array = (GValueArray*) _tmp22_;
				level_sum = (gdouble) 0;
				_tmp23_ = value_array;
				{
					GValueArray* val_collection = NULL;
					guint val_index = 0U;
					val_collection = _tmp23_;
					for (val_index = 0; val_index < val_collection->n_values; val_index = val_index + 1) {
						GValue val = {0};
						val = *g_value_array_get_nth (val_collection, val_index);
						{
							level_sum += pow ((gdouble) 10, g_value_get_double (&val) / 20);
						}
					}
				}
				_tmp24_ = value_array;
				levels = level_sum / _tmp24_->n_values;
				_tmp25_ = self->priv->_level;
				tuba_widgets_audio_stream_set_level (self, (levels * TUBA_WIDGETS_AUDIO_STREAM_SMOOTHING) + (_tmp25_ * (1.0 - TUBA_WIDGETS_AUDIO_STREAM_SMOOTHING)));
			}
			break;
		}
		case GST_MESSAGE_ASYNC_DONE:
		{
			gint64 _tmp26_;
			_tmp26_ = self->priv->_duration;
			if (_tmp26_ == ((gint64) 0)) {
				tuba_widgets_audio_stream_update_duration (self);
			}
			break;
		}
		case GST_MESSAGE_DURATION_CHANGED:
		{
			tuba_widgets_audio_stream_update_duration (self);
			break;
		}
		default:
		{
			break;
		}
	}
	result = TRUE;
	return result;
}

static void
tuba_widgets_audio_stream_update_duration (TubaWidgetsAudioStream* self)
{
	gint64 t_duration = 0LL;
	GstBin* _tmp0_;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_;
	gint64 _tmp8_;
	g_return_if_fail (self != NULL);
	t_duration = (gint64) 0;
	_tmp0_ = self->priv->pipeline;
	_tmp2_ = gst_element_query_duration ((GstElement*) _tmp0_, GST_FORMAT_TIME, &_tmp1_);
	t_duration = _tmp1_;
	if (!_tmp2_) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp3_ = tuba_widgets_audio_stream_get_url (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("Couldn't get duration of ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		g_debug ("Stream.vala:103: %s", _tmp7_);
		_g_free0 (_tmp7_);
		return;
	}
	_tmp8_ = self->priv->_duration;
	if (t_duration != _tmp8_) {
		tuba_widgets_audio_stream_set_duration (self, t_duration);
	}
}

static void
tuba_widgets_audio_stream_update_current (TubaWidgetsAudioStream* self)
{
	gint64 t_current = 0LL;
	GstBin* _tmp0_;
	gint64 _tmp1_ = 0LL;
	gboolean _tmp2_;
	gint64 _tmp8_;
	g_return_if_fail (self != NULL);
	t_current = (gint64) 0;
	_tmp0_ = self->priv->pipeline;
	_tmp2_ = gst_element_query_position ((GstElement*) _tmp0_, GST_FORMAT_TIME, &_tmp1_);
	t_current = _tmp1_;
	if (!_tmp2_) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp3_ = tuba_widgets_audio_stream_get_url (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("Couldn't get current position of ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		g_debug ("Stream.vala:112: %s", _tmp7_);
		_g_free0 (_tmp7_);
		return;
	}
	_tmp8_ = self->priv->_current;
	if (t_current != _tmp8_) {
		tuba_widgets_audio_stream_set_current (self, t_current);
	}
}

void
tuba_widgets_audio_stream_destroy (TubaWidgetsAudioStream* self)
{
	GstBus* _tmp0_;
	GstBin* _tmp2_;
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	_tmp0_ = self->priv->bus;
	if (_tmp0_ != NULL) {
		GstBus* _tmp1_;
		_tmp1_ = self->priv->bus;
		gst_bus_remove_watch (_tmp1_);
		_g_object_unref0 (self->priv->bus);
		self->priv->bus = NULL;
	}
	_tmp2_ = self->priv->pipeline;
	if (_tmp2_ != NULL) {
		tuba_widgets_audio_stream_set_state (self, GST_STATE_NULL);
		_g_object_unref0 (self->priv->pipeline);
		self->priv->pipeline = NULL;
	}
}

TubaWidgetsAudioStream*
tuba_widgets_audio_stream_construct (GType object_type)
{
	TubaWidgetsAudioStream * self = NULL;
	self = (TubaWidgetsAudioStream*) g_object_new (object_type, NULL);
	return self;
}

TubaWidgetsAudioStream*
tuba_widgets_audio_stream_new (void)
{
	return tuba_widgets_audio_stream_construct (TUBA_WIDGETS_AUDIO_TYPE_STREAM);
}

gdouble
tuba_widgets_audio_stream_get_level (TubaWidgetsAudioStream* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_level;
	return result;
}

static void
tuba_widgets_audio_stream_set_level (TubaWidgetsAudioStream* self,
                                     gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_widgets_audio_stream_get_level (self);
	if (old_value != value) {
		self->priv->_level = value;
		g_object_notify_by_pspec ((GObject *) self, tuba_widgets_audio_stream_properties[TUBA_WIDGETS_AUDIO_STREAM_LEVEL_PROPERTY]);
	}
}

gdouble
tuba_widgets_audio_stream_get_volume (TubaWidgetsAudioStream* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_volume;
	return result;
}

void
tuba_widgets_audio_stream_set_volume (TubaWidgetsAudioStream* self,
                                      gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_widgets_audio_stream_get_volume (self);
	if (old_value != value) {
		self->priv->_volume = value;
		g_object_notify_by_pspec ((GObject *) self, tuba_widgets_audio_stream_properties[TUBA_WIDGETS_AUDIO_STREAM_VOLUME_PROPERTY]);
	}
}

gboolean
tuba_widgets_audio_stream_get_muted (TubaWidgetsAudioStream* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_muted;
	return result;
}

void
tuba_widgets_audio_stream_set_muted (TubaWidgetsAudioStream* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_widgets_audio_stream_get_muted (self);
	if (old_value != value) {
		self->priv->_muted = value;
		g_object_notify_by_pspec ((GObject *) self, tuba_widgets_audio_stream_properties[TUBA_WIDGETS_AUDIO_STREAM_MUTED_PROPERTY]);
	}
}

gboolean
tuba_widgets_audio_stream_get_ready (TubaWidgetsAudioStream* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_ready;
	return result;
}

static void
tuba_widgets_audio_stream_set_ready (TubaWidgetsAudioStream* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_widgets_audio_stream_get_ready (self);
	if (old_value != value) {
		self->priv->_ready = value;
		g_object_notify_by_pspec ((GObject *) self, tuba_widgets_audio_stream_properties[TUBA_WIDGETS_AUDIO_STREAM_READY_PROPERTY]);
	}
}

void
tuba_widgets_audio_stream_set_progress (TubaWidgetsAudioStream* self,
                                        gdouble value)
{
	GstBin* _tmp0_;
	gint64 _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pipeline;
	_tmp1_ = self->priv->_duration;
	gst_element_seek_simple ((GstElement*) _tmp0_, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH | GST_SEEK_FLAG_KEY_UNIT, (gint64) ((value / 10) * _tmp1_));
	tuba_widgets_audio_stream_update_metadata (self);
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_audio_stream_properties[TUBA_WIDGETS_AUDIO_STREAM_PROGRESS_PROPERTY]);
}

gint64
tuba_widgets_audio_stream_get_duration (TubaWidgetsAudioStream* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_duration;
	return result;
}

static void
tuba_widgets_audio_stream_set_duration (TubaWidgetsAudioStream* self,
                                        gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_widgets_audio_stream_get_duration (self);
	if (old_value != value) {
		self->priv->_duration = value;
		g_object_notify_by_pspec ((GObject *) self, tuba_widgets_audio_stream_properties[TUBA_WIDGETS_AUDIO_STREAM_DURATION_PROPERTY]);
	}
}

gint64
tuba_widgets_audio_stream_get_current (TubaWidgetsAudioStream* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_current;
	return result;
}

static void
tuba_widgets_audio_stream_set_current (TubaWidgetsAudioStream* self,
                                       gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_widgets_audio_stream_get_current (self);
	if (old_value != value) {
		self->priv->_current = value;
		g_object_notify_by_pspec ((GObject *) self, tuba_widgets_audio_stream_properties[TUBA_WIDGETS_AUDIO_STREAM_CURRENT_PROPERTY]);
	}
}

const gchar*
tuba_widgets_audio_stream_get_url (TubaWidgetsAudioStream* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_url;
	result = _tmp0_;
	return result;
}

void
tuba_widgets_audio_stream_set_url (TubaWidgetsAudioStream* self,
                                   const gchar* value)
{
	gchar* _tmp0_;
	GstElement* _tmp1_;
	GValue _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_url);
	self->priv->_url = _tmp0_;
	_tmp1_ = self->priv->uridecodebin;
	g_value_init (&_tmp2_, G_TYPE_STRING);
	g_value_set_string (&_tmp2_, value);
	g_object_set_property ((GObject*) _tmp1_, "uri", &_tmp2_);
	G_IS_VALUE (&_tmp2_) ? (g_value_unset (&_tmp2_), NULL) : NULL;
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_audio_stream_properties[TUBA_WIDGETS_AUDIO_STREAM_URL_PROPERTY]);
}

GstState
tuba_widgets_audio_stream_get_state (TubaWidgetsAudioStream* self)
{
	GstState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
tuba_widgets_audio_stream_set_state (TubaWidgetsAudioStream* self,
                                     GstState value)
{
	GstBin* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pipeline;
	gst_element_set_state ((GstElement*) _tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_audio_stream_properties[TUBA_WIDGETS_AUDIO_STREAM_STATE_PROPERTY]);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_tuba_widgets_audio_stream_bus_callback_gst_bus_func (GstBus* bus,
                                                      GstMessage* message,
                                                      gpointer self)
{
	gboolean result;
	result = tuba_widgets_audio_stream_bus_callback ((TubaWidgetsAudioStream*) self, bus, message);
	return result;
}

static gboolean
_tuba_widgets_audio_stream_update_metadata_gsource_func (gpointer self)
{
	gboolean result;
	result = tuba_widgets_audio_stream_update_metadata ((TubaWidgetsAudioStream*) self);
	return result;
}

static GObject *
tuba_widgets_audio_stream_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TubaWidgetsAudioStream * self;
	gchar* pipestr = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (tuba_widgets_audio_stream_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_WIDGETS_AUDIO_TYPE_STREAM, TubaWidgetsAudioStream);
	_tmp0_ = g_strdup ("uridecodebin name=uridecodebin ! audioconvert ! audio/x-raw,channels=2" \
" ! volume name=volume ! level name=level interval=100000000 ! autoaudi" \
"osink name=sink");
	pipestr = _tmp0_;
	{
		GstElement* _tmp1_ = NULL;
		const gchar* _tmp2_;
		GstElement* _tmp3_;
		GstBin* _tmp4_;
		GstBin* _tmp5_;
		GstElement* _tmp6_;
		GstElement* volume = NULL;
		GstBin* _tmp7_;
		GstElement* _tmp8_;
		GstElement* _tmp9_;
		GstElement* level = NULL;
		GstBin* _tmp10_;
		GstElement* _tmp11_;
		GstElement* _tmp12_;
		GValue _tmp13_ = {0};
		GstElement* sink = NULL;
		GstBin* _tmp14_;
		GstElement* _tmp15_;
		GstElement* _tmp16_;
		GValue _tmp17_ = {0};
		GstBin* _tmp18_;
		GstBus* _tmp19_;
		GstBus* _tmp20_;
		_tmp2_ = pipestr;
		_tmp3_ = gst_parse_launch_full (_tmp2_, NULL, GST_PARSE_FLAG_NONE, &_inner_error0_);
		if (_tmp3_ != NULL) {
			g_object_ref_sink (_tmp3_);
		}
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gst_bin_get_type (), GstBin));
		_g_object_unref0 (self->priv->pipeline);
		self->priv->pipeline = _tmp4_;
		_tmp5_ = self->priv->pipeline;
		_tmp6_ = gst_bin_get_by_name (_tmp5_, "uridecodebin");
		_g_object_unref0 (self->priv->uridecodebin);
		self->priv->uridecodebin = _tmp6_;
		_tmp7_ = self->priv->pipeline;
		_tmp8_ = gst_bin_get_by_name (_tmp7_, "volume");
		volume = _tmp8_;
		_tmp9_ = volume;
		g_object_bind_property_with_closures ((GObject*) self, "volume", (GObject*) _tmp9_, "volume", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
		_tmp10_ = self->priv->pipeline;
		_tmp11_ = gst_bin_get_by_name (_tmp10_, "level");
		level = _tmp11_;
		_tmp12_ = level;
		g_value_init (&_tmp13_, G_TYPE_BOOLEAN);
		g_value_set_boolean (&_tmp13_, TRUE);
		g_object_set_property ((GObject*) _tmp12_, "post-messages", &_tmp13_);
		G_IS_VALUE (&_tmp13_) ? (g_value_unset (&_tmp13_), NULL) : NULL;
		_tmp14_ = self->priv->pipeline;
		_tmp15_ = gst_bin_get_by_name (_tmp14_, "sink");
		sink = _tmp15_;
		_tmp16_ = sink;
		g_value_init (&_tmp17_, G_TYPE_BOOLEAN);
		g_value_set_boolean (&_tmp17_, TRUE);
		g_object_set_property ((GObject*) _tmp16_, "sync", &_tmp17_);
		G_IS_VALUE (&_tmp17_) ? (g_value_unset (&_tmp17_), NULL) : NULL;
		_tmp18_ = self->priv->pipeline;
		_tmp19_ = gst_element_get_bus ((GstElement*) _tmp18_);
		_g_object_unref0 (self->priv->bus);
		self->priv->bus = _tmp19_;
		_tmp20_ = self->priv->bus;
		gst_bus_add_watch_full (_tmp20_, 0, _tuba_widgets_audio_stream_bus_callback_gst_bus_func, g_object_ref (self), g_object_unref);
		self->priv->timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _tuba_widgets_audio_stream_update_metadata_gsource_func, g_object_ref (self), g_object_unref);
		_g_object_unref0 (sink);
		_g_object_unref0 (level);
		_g_object_unref0 (volume);
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		_tmp23_ = string_to_string (_tmp22_);
		_tmp24_ = g_strconcat ("Error while constructing pipeline: ", _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		g_critical ("Stream.vala:140: %s", _tmp25_);
		_g_free0 (_tmp25_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (pipestr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_g_free0 (pipestr);
	return obj;
}

static void
tuba_widgets_audio_stream_class_init (TubaWidgetsAudioStreamClass * klass,
                                      gpointer klass_data)
{
	tuba_widgets_audio_stream_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TubaWidgetsAudioStream_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_tuba_widgets_audio_stream_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tuba_widgets_audio_stream_set_property;
	G_OBJECT_CLASS (klass)->constructor = tuba_widgets_audio_stream_constructor;
	G_OBJECT_CLASS (klass)->finalize = tuba_widgets_audio_stream_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_AUDIO_STREAM_LEVEL_PROPERTY, tuba_widgets_audio_stream_properties[TUBA_WIDGETS_AUDIO_STREAM_LEVEL_PROPERTY] = g_param_spec_double ("level", "level", "level", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_AUDIO_STREAM_VOLUME_PROPERTY, tuba_widgets_audio_stream_properties[TUBA_WIDGETS_AUDIO_STREAM_VOLUME_PROPERTY] = g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 1.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_AUDIO_STREAM_MUTED_PROPERTY, tuba_widgets_audio_stream_properties[TUBA_WIDGETS_AUDIO_STREAM_MUTED_PROPERTY] = g_param_spec_boolean ("muted", "muted", "muted", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_AUDIO_STREAM_READY_PROPERTY, tuba_widgets_audio_stream_properties[TUBA_WIDGETS_AUDIO_STREAM_READY_PROPERTY] = g_param_spec_boolean ("ready", "ready", "ready", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_AUDIO_STREAM_PROGRESS_PROPERTY, tuba_widgets_audio_stream_properties[TUBA_WIDGETS_AUDIO_STREAM_PROGRESS_PROPERTY] = g_param_spec_double ("progress", "progress", "progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_AUDIO_STREAM_DURATION_PROPERTY, tuba_widgets_audio_stream_properties[TUBA_WIDGETS_AUDIO_STREAM_DURATION_PROPERTY] = g_param_spec_int64 ("duration", "duration", "duration", G_MININT64, G_MAXINT64, (gint64) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_AUDIO_STREAM_CURRENT_PROPERTY, tuba_widgets_audio_stream_properties[TUBA_WIDGETS_AUDIO_STREAM_CURRENT_PROPERTY] = g_param_spec_int64 ("current", "current", "current", G_MININT64, G_MAXINT64, (gint64) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_AUDIO_STREAM_URL_PROPERTY, tuba_widgets_audio_stream_properties[TUBA_WIDGETS_AUDIO_STREAM_URL_PROPERTY] = g_param_spec_string ("url", "url", "url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_AUDIO_STREAM_STATE_PROPERTY, tuba_widgets_audio_stream_properties[TUBA_WIDGETS_AUDIO_STREAM_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", gst_state_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	tuba_widgets_audio_stream_signals[TUBA_WIDGETS_AUDIO_STREAM_ENDED_SIGNAL] = g_signal_new ("ended", TUBA_WIDGETS_AUDIO_TYPE_STREAM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
tuba_widgets_audio_stream_instance_init (TubaWidgetsAudioStream * self,
                                         gpointer klass)
{
	gchar* _tmp0_;
	self->priv = tuba_widgets_audio_stream_get_instance_private (self);
	self->priv->_level = 0.0;
	self->priv->_volume = 1.0;
	self->priv->_muted = FALSE;
	self->priv->_ready = FALSE;
	self->priv->_duration = (gint64) 0;
	self->priv->_current = (gint64) 0;
	_tmp0_ = g_strdup ("");
	self->priv->_url = _tmp0_;
	self->priv->_state = GST_STATE_NULL;
	self->priv->timeout_id = (guint) 0;
}

static void
tuba_widgets_audio_stream_finalize (GObject * obj)
{
	TubaWidgetsAudioStream * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_WIDGETS_AUDIO_TYPE_STREAM, TubaWidgetsAudioStream);
	g_debug ("Stream.vala:164: Destroying AudioStream");
	_g_object_unref0 (self->priv->pipeline);
	_g_object_unref0 (self->priv->bus);
	_g_object_unref0 (self->priv->uridecodebin);
	_g_free0 (self->priv->_url);
	G_OBJECT_CLASS (tuba_widgets_audio_stream_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
tuba_widgets_audio_stream_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TubaWidgetsAudioStreamClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_widgets_audio_stream_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaWidgetsAudioStream), 0, (GInstanceInitFunc) tuba_widgets_audio_stream_instance_init, NULL };
	GType tuba_widgets_audio_stream_type_id;
	tuba_widgets_audio_stream_type_id = g_type_register_static (G_TYPE_OBJECT, "TubaWidgetsAudioStream", &g_define_type_info, 0);
	TubaWidgetsAudioStream_private_offset = g_type_add_instance_private (tuba_widgets_audio_stream_type_id, sizeof (TubaWidgetsAudioStreamPrivate));
	return tuba_widgets_audio_stream_type_id;
}

GType
tuba_widgets_audio_stream_get_type (void)
{
	static gsize tuba_widgets_audio_stream_type_id__once = 0;
	if (g_once_init_enter (&tuba_widgets_audio_stream_type_id__once)) {
		GType tuba_widgets_audio_stream_type_id;
		tuba_widgets_audio_stream_type_id = tuba_widgets_audio_stream_get_type_once ();
		g_once_init_leave (&tuba_widgets_audio_stream_type_id__once, tuba_widgets_audio_stream_type_id);
	}
	return tuba_widgets_audio_stream_type_id__once;
}

static void
_vala_tuba_widgets_audio_stream_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	TubaWidgetsAudioStream * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_WIDGETS_AUDIO_TYPE_STREAM, TubaWidgetsAudioStream);
	switch (property_id) {
		case TUBA_WIDGETS_AUDIO_STREAM_LEVEL_PROPERTY:
		g_value_set_double (value, tuba_widgets_audio_stream_get_level (self));
		break;
		case TUBA_WIDGETS_AUDIO_STREAM_VOLUME_PROPERTY:
		g_value_set_double (value, tuba_widgets_audio_stream_get_volume (self));
		break;
		case TUBA_WIDGETS_AUDIO_STREAM_MUTED_PROPERTY:
		g_value_set_boolean (value, tuba_widgets_audio_stream_get_muted (self));
		break;
		case TUBA_WIDGETS_AUDIO_STREAM_READY_PROPERTY:
		g_value_set_boolean (value, tuba_widgets_audio_stream_get_ready (self));
		break;
		case TUBA_WIDGETS_AUDIO_STREAM_DURATION_PROPERTY:
		g_value_set_int64 (value, tuba_widgets_audio_stream_get_duration (self));
		break;
		case TUBA_WIDGETS_AUDIO_STREAM_CURRENT_PROPERTY:
		g_value_set_int64 (value, tuba_widgets_audio_stream_get_current (self));
		break;
		case TUBA_WIDGETS_AUDIO_STREAM_URL_PROPERTY:
		g_value_set_string (value, tuba_widgets_audio_stream_get_url (self));
		break;
		case TUBA_WIDGETS_AUDIO_STREAM_STATE_PROPERTY:
		g_value_set_enum (value, tuba_widgets_audio_stream_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tuba_widgets_audio_stream_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	TubaWidgetsAudioStream * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_WIDGETS_AUDIO_TYPE_STREAM, TubaWidgetsAudioStream);
	switch (property_id) {
		case TUBA_WIDGETS_AUDIO_STREAM_LEVEL_PROPERTY:
		tuba_widgets_audio_stream_set_level (self, g_value_get_double (value));
		break;
		case TUBA_WIDGETS_AUDIO_STREAM_VOLUME_PROPERTY:
		tuba_widgets_audio_stream_set_volume (self, g_value_get_double (value));
		break;
		case TUBA_WIDGETS_AUDIO_STREAM_MUTED_PROPERTY:
		tuba_widgets_audio_stream_set_muted (self, g_value_get_boolean (value));
		break;
		case TUBA_WIDGETS_AUDIO_STREAM_READY_PROPERTY:
		tuba_widgets_audio_stream_set_ready (self, g_value_get_boolean (value));
		break;
		case TUBA_WIDGETS_AUDIO_STREAM_PROGRESS_PROPERTY:
		tuba_widgets_audio_stream_set_progress (self, g_value_get_double (value));
		break;
		case TUBA_WIDGETS_AUDIO_STREAM_DURATION_PROPERTY:
		tuba_widgets_audio_stream_set_duration (self, g_value_get_int64 (value));
		break;
		case TUBA_WIDGETS_AUDIO_STREAM_CURRENT_PROPERTY:
		tuba_widgets_audio_stream_set_current (self, g_value_get_int64 (value));
		break;
		case TUBA_WIDGETS_AUDIO_STREAM_URL_PROPERTY:
		tuba_widgets_audio_stream_set_url (self, g_value_get_string (value));
		break;
		case TUBA_WIDGETS_AUDIO_STREAM_STATE_PROPERTY:
		tuba_widgets_audio_stream_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

