/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_SCREENSAVER_CLIENT_PROTOCOL_H
#define TREELAND_SCREENSAVER_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_treeland_screensaver The treeland_screensaver protocol
 * @section page_ifaces_treeland_screensaver Interfaces
 * - @subpage page_iface_treeland_screensaver - Simple idle inhibit protocol
 * @section page_copyright_treeland_screensaver Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2025 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_screensaver;

#ifndef TREELAND_SCREENSAVER_INTERFACE
#define TREELAND_SCREENSAVER_INTERFACE
/**
 * @page page_iface_treeland_screensaver treeland_screensaver
 * @section page_iface_treeland_screensaver_desc Description
 *
 * This object implements a simple idle inhibit protocol.
 *
 * Call inhibit to prevent treeland from entering idle state.
 * Call uninhibit or disconnect from the global to release
 * the inhibit.
 *
 * If the client disconnects from the compositor, the inhibit
 * associated with that client is automatically released.
 *
 * There can be only one inhibit per client per time. Calling
 * inhibit multiple times will raise an error. Call uninhibit
 * before inhibit to update application_name and reason
 * recorded.
 *
 * Warning! The protocol described in this file is currently
 * in the testing phase. Backward compatible changes may be
 * added together with the corresponding interface version
 * bump. Backward incompatible changes can only be done by
 * creating a new major version of the extension.
 * @section page_iface_treeland_screensaver_api API
 * See @ref iface_treeland_screensaver.
 */
/**
 * @defgroup iface_treeland_screensaver The treeland_screensaver interface
 *
 * This object implements a simple idle inhibit protocol.
 *
 * Call inhibit to prevent treeland from entering idle state.
 * Call uninhibit or disconnect from the global to release
 * the inhibit.
 *
 * If the client disconnects from the compositor, the inhibit
 * associated with that client is automatically released.
 *
 * There can be only one inhibit per client per time. Calling
 * inhibit multiple times will raise an error. Call uninhibit
 * before inhibit to update application_name and reason
 * recorded.
 *
 * Warning! The protocol described in this file is currently
 * in the testing phase. Backward compatible changes may be
 * added together with the corresponding interface version
 * bump. Backward incompatible changes can only be done by
 * creating a new major version of the extension.
 */
extern const struct wl_interface treeland_screensaver_interface;
#endif

#ifndef TREELAND_SCREENSAVER_ERROR_ENUM
#define TREELAND_SCREENSAVER_ERROR_ENUM
enum treeland_screensaver_error {
	/**
	 * Trying to uninhibit but no active inhibit existed
	 */
	TREELAND_SCREENSAVER_ERROR_NOT_YET_INHIBITED = 0,
	/**
	 * Trying to inhibit with an active inhibit existed
	 */
	TREELAND_SCREENSAVER_ERROR_ALREADY_INHIBITED = 1,
};
#endif /* TREELAND_SCREENSAVER_ERROR_ENUM */

#define TREELAND_SCREENSAVER_INHIBIT 0
#define TREELAND_SCREENSAVER_UNINHIBIT 1


/**
 * @ingroup iface_treeland_screensaver
 */
#define TREELAND_SCREENSAVER_INHIBIT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_screensaver
 */
#define TREELAND_SCREENSAVER_UNINHIBIT_SINCE_VERSION 1

/** @ingroup iface_treeland_screensaver */
static inline void
treeland_screensaver_set_user_data(struct treeland_screensaver *treeland_screensaver, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_screensaver, user_data);
}

/** @ingroup iface_treeland_screensaver */
static inline void *
treeland_screensaver_get_user_data(struct treeland_screensaver *treeland_screensaver)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_screensaver);
}

static inline uint32_t
treeland_screensaver_get_version(struct treeland_screensaver *treeland_screensaver)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_screensaver);
}

/** @ingroup iface_treeland_screensaver */
static inline void
treeland_screensaver_destroy(struct treeland_screensaver *treeland_screensaver)
{
	wl_proxy_destroy((struct wl_proxy *) treeland_screensaver);
}

/**
 * @ingroup iface_treeland_screensaver
 *
 * Inhibit idleness with given application_name and reason_for_inhibit.
 */
static inline void
treeland_screensaver_inhibit(struct treeland_screensaver *treeland_screensaver, const char *application_name, const char *reason_for_inhibit)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_screensaver,
			 TREELAND_SCREENSAVER_INHIBIT, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_screensaver), 0, application_name, reason_for_inhibit);
}

/**
 * @ingroup iface_treeland_screensaver
 *
 * Uninhibit idleness previously inhibited by inhibit request.
 */
static inline void
treeland_screensaver_uninhibit(struct treeland_screensaver *treeland_screensaver)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_screensaver,
			 TREELAND_SCREENSAVER_UNINHIBIT, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_screensaver), 0);
}

#ifdef  __cplusplus
}
#endif

#endif
