/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_SHORTCUT_MANAGER_V1_SERVER_PROTOCOL_H
#define TREELAND_SHORTCUT_MANAGER_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_treeland_shortcut_manager_v1 The treeland_shortcut_manager_v1 protocol
 * @section page_ifaces_treeland_shortcut_manager_v1 Interfaces
 * - @subpage page_iface_treeland_shortcut_manager_v1 - shortcut manager
 * - @subpage page_iface_treeland_shortcut_context_v1 - client shortcut context
 * @section page_copyright_treeland_shortcut_manager_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_shortcut_context_v1;
struct treeland_shortcut_manager_v1;

#ifndef TREELAND_SHORTCUT_MANAGER_V1_INTERFACE
#define TREELAND_SHORTCUT_MANAGER_V1_INTERFACE
/**
 * @page page_iface_treeland_shortcut_manager_v1 treeland_shortcut_manager_v1
 * @section page_iface_treeland_shortcut_manager_v1_desc Description
 *
 * This interface allows a client to get some shell's info.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_shortcut_manager_v1_api API
 * See @ref iface_treeland_shortcut_manager_v1.
 */
/**
 * @defgroup iface_treeland_shortcut_manager_v1 The treeland_shortcut_manager_v1 interface
 *
 * This interface allows a client to get some shell's info.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_shortcut_manager_v1_interface;
#endif
#ifndef TREELAND_SHORTCUT_CONTEXT_V1_INTERFACE
#define TREELAND_SHORTCUT_CONTEXT_V1_INTERFACE
/**
 * @page page_iface_treeland_shortcut_context_v1 treeland_shortcut_context_v1
 * @section page_iface_treeland_shortcut_context_v1_desc Description
 *
 * This interface allows a client to listen a shortcut action.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_shortcut_context_v1_api API
 * See @ref iface_treeland_shortcut_context_v1.
 */
/**
 * @defgroup iface_treeland_shortcut_context_v1 The treeland_shortcut_context_v1 interface
 *
 * This interface allows a client to listen a shortcut action.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_shortcut_context_v1_interface;
#endif

/**
 * @ingroup iface_treeland_shortcut_manager_v1
 * @struct treeland_shortcut_manager_v1_interface
 */
struct treeland_shortcut_manager_v1_interface {
	/**
	 * register shortcut key
	 *
	 * The format of the shortcut key is 'Modify+Key', such as
	 * 'Ctrl+Alt+T'. If the format is wrong, the synthesizer will give
	 * a "format error". If the shortcut key is already registered, the
	 * compositor will give a "register error" and issue a destruction
	 * to the context.
	 */
	void (*register_shortcut_context)(struct wl_client *client,
					  struct wl_resource *resource,
					  const char *key,
					  uint32_t id);
};


/**
 * @ingroup iface_treeland_shortcut_manager_v1
 */
#define TREELAND_SHORTCUT_MANAGER_V1_REGISTER_SHORTCUT_CONTEXT_SINCE_VERSION 1

#ifndef TREELAND_SHORTCUT_CONTEXT_V1_ERROR_ENUM
#define TREELAND_SHORTCUT_CONTEXT_V1_ERROR_ENUM
enum treeland_shortcut_context_v1_error {
	/**
	 * shortcut register failed
	 */
	TREELAND_SHORTCUT_CONTEXT_V1_ERROR_REGISTER_FAILED = 1,
};
#endif /* TREELAND_SHORTCUT_CONTEXT_V1_ERROR_ENUM */

#ifndef TREELAND_SHORTCUT_CONTEXT_V1_ERROR_ENUM_IS_VALID
#define TREELAND_SHORTCUT_CONTEXT_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_shortcut_context_v1
 * Validate a treeland_shortcut_context_v1 error value.
 *
 * @return true on success, false on error.
 * @ref treeland_shortcut_context_v1_error
 */
static inline bool
treeland_shortcut_context_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_SHORTCUT_CONTEXT_V1_ERROR_REGISTER_FAILED:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_SHORTCUT_CONTEXT_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_treeland_shortcut_context_v1
 * @struct treeland_shortcut_context_v1_interface
 */
struct treeland_shortcut_context_v1_interface {
	/**
	 * destroy the context object
	 *
	 * Destroy the context object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define TREELAND_SHORTCUT_CONTEXT_V1_SHORTCUT 0

/**
 * @ingroup iface_treeland_shortcut_context_v1
 */
#define TREELAND_SHORTCUT_CONTEXT_V1_SHORTCUT_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_shortcut_context_v1
 */
#define TREELAND_SHORTCUT_CONTEXT_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_shortcut_context_v1
 * Sends an shortcut event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_shortcut_context_v1_send_shortcut(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, TREELAND_SHORTCUT_CONTEXT_V1_SHORTCUT);
}

#ifdef  __cplusplus
}
#endif

#endif
