/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v2

import (
	autoscalingv2 "k8s.io/api/autoscaling/v2"
	resource "k8s.io/apimachinery/pkg/api/resource"
)

// HPAScalingRulesApplyConfiguration represents a declarative configuration of the HPAScalingRules type for use
// with apply.
//
// HPAScalingRules configures the scaling behavior for one direction via
// scaling Policy Rules and a configurable metric tolerance.
//
// Scaling Policy Rules are applied after calculating DesiredReplicas from metrics for the HPA.
// They can limit the scaling velocity by specifying scaling policies.
// They can prevent flapping by specifying the stabilization window, so that the
// number of replicas is not set instantly, instead, the safest value from the stabilization
// window is chosen.
//
// The tolerance is applied to the metric values and prevents scaling too
// eagerly for small metric variations. (Note that setting a tolerance requires
// the beta HPAConfigurableTolerance feature gate to be enabled.)
type HPAScalingRulesApplyConfiguration struct {
	// stabilizationWindowSeconds is the number of seconds for which past recommendations should be
	// considered while scaling up or scaling down.
	// StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour).
	// If not set, use the default values:
	// - For scale up: 0 (i.e. no stabilization is done).
	// - For scale down: 300 (i.e. the stabilization window is 300 seconds long).
	StabilizationWindowSeconds *int32 `json:"stabilizationWindowSeconds,omitempty"`
	// selectPolicy is used to specify which policy should be used.
	// If not set, the default value Max is used.
	SelectPolicy *autoscalingv2.ScalingPolicySelect `json:"selectPolicy,omitempty"`
	// policies is a list of potential scaling polices which can be used during scaling.
	// If not set, use the default values:
	// - For scale up: allow doubling the number of pods, or an absolute change of 4 pods in a 15s window.
	// - For scale down: allow all pods to be removed in a 15s window.
	Policies []HPAScalingPolicyApplyConfiguration `json:"policies,omitempty"`
	// tolerance is the tolerance on the ratio between the current and desired
	// metric value under which no updates are made to the desired number of
	// replicas (e.g. 0.01 for 1%). Must be greater than or equal to zero. If not
	// set, the default cluster-wide tolerance is applied (by default 10%).
	//
	// For example, if autoscaling is configured with a memory consumption target of 100Mi,
	// and scale-down and scale-up tolerances of 5% and 1% respectively, scaling will be
	// triggered when the actual consumption falls below 95Mi or exceeds 101Mi.
	//
	// This is an beta field and requires the HPAConfigurableTolerance feature
	// gate to be enabled.
	Tolerance *resource.Quantity `json:"tolerance,omitempty"`
}

// HPAScalingRulesApplyConfiguration constructs a declarative configuration of the HPAScalingRules type for use with
// apply.
func HPAScalingRules() *HPAScalingRulesApplyConfiguration {
	return &HPAScalingRulesApplyConfiguration{}
}

// WithStabilizationWindowSeconds sets the StabilizationWindowSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the StabilizationWindowSeconds field is set to the value of the last call.
func (b *HPAScalingRulesApplyConfiguration) WithStabilizationWindowSeconds(value int32) *HPAScalingRulesApplyConfiguration {
	b.StabilizationWindowSeconds = &value
	return b
}

// WithSelectPolicy sets the SelectPolicy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SelectPolicy field is set to the value of the last call.
func (b *HPAScalingRulesApplyConfiguration) WithSelectPolicy(value autoscalingv2.ScalingPolicySelect) *HPAScalingRulesApplyConfiguration {
	b.SelectPolicy = &value
	return b
}

// WithPolicies adds the given value to the Policies field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Policies field.
func (b *HPAScalingRulesApplyConfiguration) WithPolicies(values ...*HPAScalingPolicyApplyConfiguration) *HPAScalingRulesApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithPolicies")
		}
		b.Policies = append(b.Policies, *values[i])
	}
	return b
}

// WithTolerance sets the Tolerance field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Tolerance field is set to the value of the last call.
func (b *HPAScalingRulesApplyConfiguration) WithTolerance(value resource.Quantity) *HPAScalingRulesApplyConfiguration {
	b.Tolerance = &value
	return b
}
