/* CaldavDialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CaldavDialog.vala, do not modify */

/*
* Copyright 2020-2021 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
*/

#include "onlineaccounts.h"
#include <gio/gio.h>
#include <granite-7.h>
#include <gtk/gtk.h>
#include <adwaita.h>
#include <glib-object.h>
#include <libedataserver/libedataserver.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <camel/camel.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_VALIDATION_MESSAGE (validation_message_get_type ())
#define VALIDATION_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALIDATION_MESSAGE, ValidationMessage))
#define VALIDATION_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALIDATION_MESSAGE, ValidationMessageClass))
#define IS_VALIDATION_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALIDATION_MESSAGE))
#define IS_VALIDATION_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALIDATION_MESSAGE))
#define VALIDATION_MESSAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALIDATION_MESSAGE, ValidationMessageClass))

typedef struct _ValidationMessage ValidationMessage;
typedef struct _ValidationMessageClass ValidationMessageClass;
enum  {
	ONLINE_ACCOUNTS_CALDAV_DIALOG_0_PROPERTY,
	ONLINE_ACCOUNTS_CALDAV_DIALOG_NUM_PROPERTIES
};
static GParamSpec* online_accounts_caldav_dialog_properties[ONLINE_ACCOUNTS_CALDAV_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ONLINE_ACCOUNTS_CALDAV_DIALOG_TYPE_SOURCE_ROW (online_accounts_caldav_dialog_source_row_get_type ())
#define ONLINE_ACCOUNTS_CALDAV_DIALOG_SOURCE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ONLINE_ACCOUNTS_CALDAV_DIALOG_TYPE_SOURCE_ROW, OnlineAccountsCaldavDialogSourceRow))
#define ONLINE_ACCOUNTS_CALDAV_DIALOG_SOURCE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ONLINE_ACCOUNTS_CALDAV_DIALOG_TYPE_SOURCE_ROW, OnlineAccountsCaldavDialogSourceRowClass))
#define ONLINE_ACCOUNTS_CALDAV_DIALOG_IS_SOURCE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ONLINE_ACCOUNTS_CALDAV_DIALOG_TYPE_SOURCE_ROW))
#define ONLINE_ACCOUNTS_CALDAV_DIALOG_IS_SOURCE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ONLINE_ACCOUNTS_CALDAV_DIALOG_TYPE_SOURCE_ROW))
#define ONLINE_ACCOUNTS_CALDAV_DIALOG_SOURCE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ONLINE_ACCOUNTS_CALDAV_DIALOG_TYPE_SOURCE_ROW, OnlineAccountsCaldavDialogSourceRowClass))

typedef struct _OnlineAccountsCaldavDialogSourceRow OnlineAccountsCaldavDialogSourceRow;
typedef struct _OnlineAccountsCaldavDialogSourceRowClass OnlineAccountsCaldavDialogSourceRowClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
#define _g_uri_unref0(var) ((var == NULL) ? NULL : (var = (g_uri_unref (var), NULL)))
#define __vala_ENamedParameters_free0(var) ((var == NULL) ? NULL : (var = (_vala_ENamedParameters_free (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _OnlineAccountsCaldavDialogFindSourcesData OnlineAccountsCaldavDialogFindSourcesData;
typedef struct _Block3Data Block3Data;
typedef struct _OnlineAccountsCaldavDialogFindSourcesSupportingData OnlineAccountsCaldavDialogFindSourcesSupportingData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _OnlineAccountsCaldavDialogLoadConfigurationData OnlineAccountsCaldavDialogLoadConfigurationData;
typedef struct _OnlineAccountsCaldavDialogSaveConfigurationData OnlineAccountsCaldavDialogSaveConfigurationData;
typedef struct _Block4Data Block4Data;
typedef struct _OnlineAccountsCaldavDialogAwaitSourceChildrenConfigurationData OnlineAccountsCaldavDialogAwaitSourceChildrenConfigurationData;
typedef struct _OnlineAccountsCaldavDialogSourceRowPrivate OnlineAccountsCaldavDialogSourceRowPrivate;
enum  {
	ONLINE_ACCOUNTS_CALDAV_DIALOG_SOURCE_ROW_0_PROPERTY,
	ONLINE_ACCOUNTS_CALDAV_DIALOG_SOURCE_ROW_SOURCE_PROPERTY,
	ONLINE_ACCOUNTS_CALDAV_DIALOG_SOURCE_ROW_NUM_PROPERTIES
};
static GParamSpec* online_accounts_caldav_dialog_source_row_properties[ONLINE_ACCOUNTS_CALDAV_DIALOG_SOURCE_ROW_NUM_PROPERTIES];
typedef struct _Block5Data Block5Data;

struct _OnlineAccountsCaldavDialogPrivate {
	GCancellable* cancellable;
	GraniteValidatedEntry* url_entry;
	GraniteValidatedEntry* username_entry;
	GtkButton* login_button;
	GtkButton* save_configuration_button;
	GtkEntry* display_name_entry;
	GtkEntry* password_entry;
	GtkListBox* calendars_list;
	AdwNavigationPage* calendars_page;
	GListStore* calendars_store;
	ValidationMessage* url_message_revealer;
	ESourceRegistry* registry;
	ESource* source;
	guint source_children_configuration_timeout_id;
	guint source_children_configuration_count;
};

struct _Block1Data {
	int _ref_count_;
	OnlineAccountsCaldavDialog* self;
	ESource** found_calendars;
	gint found_calendars_length1;
	gint _found_calendars_size_;
	ESource** found_tasklists;
	gint found_tasklists_length1;
	gint _found_tasklists_size_;
};

struct _Block2Data {
	int _ref_count_;
	OnlineAccountsCaldavDialog* self;
	GranitePlaceholder* error_placeholder;
};

struct _OnlineAccountsCaldavDialogFindSourcesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	OnlineAccountsCaldavDialog* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GtkButton* _tmp3_;
	GtkLabel* placeholder_label;
	GtkLabel* _tmp4_;
	GtkSpinner* spinner;
	GtkSpinner* _tmp5_;
	GtkSpinner* _tmp6_;
	GtkBox* placeholder;
	GtkBox* _tmp7_;
	GtkBox* _tmp8_;
	GtkLabel* _tmp9_;
	GtkBox* _tmp10_;
	GtkSpinner* _tmp11_;
	GtkListBox* _tmp12_;
	GtkBox* _tmp13_;
	GListStore* _tmp14_;
	Block1Data* _data1_;
	ESource* source;
	ESource* _tmp15_;
	ESource* _tmp16_;
	ESourceCollection* col;
	ESource* _tmp17_;
	ESourceExtension* _tmp18_;
	ESourceCollection* _tmp19_;
	GUri* parsed_uri;
	GraniteValidatedEntry* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GUri* _tmp23_;
	GUri* _tmp24_;
	GUri* _tmp25_;
	const gchar* _tmp26_;
	GUri* _tmp27_;
	const gchar* _tmp28_;
	GUri* _tmp29_;
	const gchar* _tmp30_;
	GUri* _tmp31_;
	const gchar* _tmp32_;
	GUri* _tmp33_;
	const gchar* _tmp34_;
	GUri* _tmp35_;
	const gchar* _tmp36_;
	GUri* _tmp37_;
	ESourceWebdav* webdav;
	ESource* _tmp38_;
	ESourceExtension* _tmp39_;
	ESourceWebdav* _tmp40_;
	GUri* _tmp41_;
	ESourceWebdav* _tmp42_;
	ESourceAuthentication* auth;
	ESource* _tmp43_;
	ESourceExtension* _tmp44_;
	ESourceAuthentication* _tmp45_;
	GraniteValidatedEntry* _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	ENamedParameters* credentials;
	ENamedParameters* _tmp49_;
	ENamedParameters* _tmp50_;
	GraniteValidatedEntry* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	ENamedParameters* _tmp54_;
	GtkEntry* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	ESource* _tmp58_;
	ENamedParameters* _tmp59_;
	GCancellable* _tmp60_;
	gint _tmp61_;
	ESource** _tmp62_;
	ESource* _tmp63_;
	ENamedParameters* _tmp64_;
	GCancellable* _tmp65_;
	gint _tmp66_;
	ESource** _tmp67_;
	GError* e;
	Block2Data* _data2_;
	GError* _tmp68_;
	const gchar* _tmp69_;
	gchar* _tmp70_;
	GThemedIcon* _tmp71_;
	GranitePlaceholder* _tmp72_;
	GError* _inner_error0_;
};

struct _Block3Data {
	int _ref_count_;
	OnlineAccountsCaldavDialog* self;
	ESource** e_sources;
	gint e_sources_length1;
	gint _e_sources_size_;
	GError* discover_error;
	EWebDAVDiscoverSupports only_supports;
	ESource* source;
	gpointer _async_data_;
};

struct _OnlineAccountsCaldavDialogFindSourcesSupportingData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	OnlineAccountsCaldavDialog* self;
	EWebDAVDiscoverSupports only_supports;
	ESource* source;
	ENamedParameters* credentials;
	GCancellable* cancellable;
	ESource** result;
	gint result_length1;
	Block3Data* _data3_;
	ESource** _tmp0_;
	GError* _tmp1_;
	GError* _tmp2_;
	GError* _tmp3_;
	ESource** _tmp4_;
	gint _tmp4__length1;
	ESource** _tmp5_;
	gint _tmp5__length1;
	ESource** _tmp6_;
	gint _tmp6__length1;
	GError* _inner_error0_;
};

struct _OnlineAccountsCaldavDialogLoadConfigurationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	OnlineAccountsCaldavDialog* self;
	ESource* collection_source;
	GCancellable* cancellable;
	gboolean _tmp0_;
	ESourceExtension* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	ESourceRegistry* _tmp5_;
	ESourceRegistry* _tmp6_;
	ESourceRegistry* _tmp7_;
	ESource* _tmp8_;
	ESourceCredentialsProvider* credentials_provider;
	ESourceRegistry* _tmp9_;
	ESourceCredentialsProvider* _tmp10_;
	ENamedParameters* collection_credentials;
	ESourceCredentialsProvider* _tmp11_;
	ENamedParameters* _tmp12_;
	ENamedParameters* _tmp13_;
	GtkEntry* _tmp14_;
	ENamedParameters* _tmp15_;
	const gchar* _tmp16_;
	ESourceCollection* collection_extension;
	ESourceExtension* _tmp17_;
	GraniteValidatedEntry* _tmp18_;
	ESourceCollection* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	ESourceWebdav* webdav_extension;
	ESourceExtension* _tmp22_;
	GraniteValidatedEntry* _tmp23_;
	ESourceWebdav* _tmp24_;
	GUri* _tmp25_;
	GUri* _tmp26_;
	GUri* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* uri_user;
	ESourceWebdav* _tmp30_;
	GUri* _tmp31_;
	GUri* _tmp32_;
	GUri* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gboolean _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	GraniteValidatedEntry* _tmp39_;
	GraniteValidatedEntry* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GtkEntry* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	GError* _inner_error0_;
};

struct _OnlineAccountsCaldavDialogSaveConfigurationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	OnlineAccountsCaldavDialog* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	ESourceRegistry* _tmp3_;
	ESourceRegistry* _tmp4_;
	GCancellable* _tmp5_;
	ESourceRegistry* _tmp6_;
	ESourceRegistry* _tmp7_;
	GCancellable* _tmp8_;
	GList* new_sources;
	ESource* collection_source;
	ESource* _tmp9_;
	ESource* _tmp10_;
	ESource* _tmp11_;
	GtkEntry* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	ESourceCollection* collection_extension;
	ESource* _tmp15_;
	ESourceExtension* _tmp16_;
	ESourceCollection* _tmp17_;
	ESourceCollection* _tmp18_;
	GraniteValidatedEntry* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	ESourceCollection* _tmp22_;
	GraniteValidatedEntry* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	ESourceAuthentication* authentication_extension;
	ESource* _tmp26_;
	ESourceExtension* _tmp27_;
	ESourceAuthentication* _tmp28_;
	GraniteValidatedEntry* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	ESourceWebdav* webdav_extension;
	ESource* _tmp32_;
	ESourceExtension* _tmp33_;
	GUri* _tmp34_;
	GraniteValidatedEntry* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	GUri* _tmp38_;
	ESourceWebdav* _tmp39_;
	GError* e;
	GError* _tmp40_;
	const gchar* _tmp41_;
	ESourceWebdav* _tmp42_;
	ESourceOffline* offline_extension;
	ESource* _tmp43_;
	ESourceExtension* _tmp44_;
	ESourceOffline* _tmp45_;
	ESourceRefresh* refresh_extension;
	ESource* _tmp46_;
	ESourceExtension* _tmp47_;
	ESourceRefresh* _tmp48_;
	ESourceRefresh* _tmp49_;
	ESource* _tmp50_;
	ESource* _tmp51_;
	ESource* _tmp52_;
	GtkEntry* _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	GCancellable* _tmp56_;
	ESourceRegistry* _tmp57_;
	GList* _tmp58_;
	GCancellable* _tmp59_;
	ESourceRegistry* _tmp60_;
	ESourceRegistry* _tmp61_;
	ESource* _tmp62_;
	const gchar* _tmp63_;
	const gchar* _tmp64_;
	GCancellable* _tmp65_;
	ESourceRegistry* _tmp66_;
	guint _tmp67_;
	ESource* _tmp68_;
	ESource* _tmp69_;
	GCancellable* _tmp70_;
	GError* _inner_error0_;
};

struct _Block4Data {
	int _ref_count_;
	OnlineAccountsCaldavDialog* self;
	gint timeout_seconds;
	gint await_seconds;
	gpointer _async_data_;
};

struct _OnlineAccountsCaldavDialogAwaitSourceChildrenConfigurationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	OnlineAccountsCaldavDialog* self;
	Block4Data* _data4_;
};

struct _OnlineAccountsCaldavDialogSourceRow {
	GtkListBoxRow parent_instance;
	OnlineAccountsCaldavDialogSourceRowPrivate * priv;
};

struct _OnlineAccountsCaldavDialogSourceRowClass {
	GtkListBoxRowClass parent_class;
};

struct _OnlineAccountsCaldavDialogSourceRowPrivate {
	ESource* _source;
};

struct _Block5Data {
	int _ref_count_;
	OnlineAccountsCaldavDialog* self;
	OnlineAccountsFinalizePage* finalize_page;
};

static gint OnlineAccountsCaldavDialog_private_offset;
static gpointer online_accounts_caldav_dialog_parent_class = NULL;
static gint OnlineAccountsCaldavDialogSourceRow_private_offset;
static gpointer online_accounts_caldav_dialog_source_row_parent_class = NULL;

VALA_EXTERN GType validation_message_get_type (void) G_GNUC_CONST ;
static gint online_accounts_caldav_dialog_sort_func (OnlineAccountsCaldavDialog* self,
                                              GtkListBoxRow* row1,
                                              GtkListBoxRow* row2);
static GType online_accounts_caldav_dialog_source_row_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ESource* online_accounts_caldav_dialog_source_row_get_source (OnlineAccountsCaldavDialogSourceRow* self);
static void online_accounts_caldav_dialog_header_func (OnlineAccountsCaldavDialog* self,
                                                GtkListBoxRow* row,
                                                GtkListBoxRow* before);
static void online_accounts_caldav_dialog_validate_form (OnlineAccountsCaldavDialog* self);
static gboolean online_accounts_caldav_dialog_is_valid_url (OnlineAccountsCaldavDialog* self,
                                                     const gchar* uri);
static OnlineAccountsCaldavDialogSourceRow* online_accounts_caldav_dialog_source_row_new (ESource* source);
static OnlineAccountsCaldavDialogSourceRow* online_accounts_caldav_dialog_source_row_construct (GType object_type,
                                                                                         ESource* source);
static void online_accounts_caldav_dialog_find_sources_data_free (gpointer _data);
static void online_accounts_caldav_dialog_find_sources (OnlineAccountsCaldavDialog* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static void online_accounts_caldav_dialog_find_sources_finish (OnlineAccountsCaldavDialog* self,
                                                        GAsyncResult* _res_);
static gboolean online_accounts_caldav_dialog_find_sources_co (OnlineAccountsCaldavDialogFindSourcesData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void online_accounts_caldav_dialog_find_sources_supporting (OnlineAccountsCaldavDialog* self,
                                                            EWebDAVDiscoverSupports only_supports,
                                                            ESource* source,
                                                            ENamedParameters* credentials,
                                                            GCancellable* cancellable,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
static ESource** online_accounts_caldav_dialog_find_sources_supporting_finish (OnlineAccountsCaldavDialog* self,
                                                                        GAsyncResult* _res_,
                                                                        gint* result_length1,
                                                                        GError** error);
static void online_accounts_caldav_dialog_find_sources_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void _vala_ENamedParameters_free (ENamedParameters* self);
static gboolean ___lambda5_ (Block1Data* _data1_);
static gboolean ____lambda5__gsource_func (gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean ___lambda6_ (Block2Data* _data2_);
static gboolean ____lambda6__gsource_func (gpointer self);
static void online_accounts_caldav_dialog_find_sources_supporting_data_free (gpointer _data);
static ENamedParameters* _vala_ENamedParameters_copy (ENamedParameters* self);
static gboolean online_accounts_caldav_dialog_find_sources_supporting_co (OnlineAccountsCaldavDialogFindSourcesSupportingData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda4_ (Block3Data* _data3_,
                 GObject* obj,
                 GAsyncResult* res);
static void _vala_EWebDAVDiscoveredSource_free (EWebDAVDiscoveredSource* self);
static void __vala_EWebDAVDiscoveredSource_free0_ (gpointer var);
static inline void _g_slist_free___vala_EWebDAVDiscoveredSource_free0_ (GSList* self);
static void _g_free0_ (gpointer var);
static inline void _g_slist_free__g_free0_ (GSList* self);
static void _vala_array_add1 (ESource** * array,
                       gint* length,
                       gint* size,
                       ESource* value);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static ESource** _vala_array_dup1 (ESource** self,
                            gssize length);
static void online_accounts_caldav_dialog_load_configuration_data_free (gpointer _data);
static gboolean online_accounts_caldav_dialog_load_configuration_co (OnlineAccountsCaldavDialogLoadConfigurationData* _data_);
static void online_accounts_caldav_dialog_load_configuration_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static void online_accounts_caldav_dialog_save_configuration_data_free (gpointer _data);
static void online_accounts_caldav_dialog_save_configuration (OnlineAccountsCaldavDialog* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static void online_accounts_caldav_dialog_save_configuration_finish (OnlineAccountsCaldavDialog* self,
                                                              GAsyncResult* _res_,
                                                              GError** error);
static gboolean online_accounts_caldav_dialog_save_configuration_co (OnlineAccountsCaldavDialogSaveConfigurationData* _data_);
static void online_accounts_caldav_dialog_save_configuration_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void online_accounts_caldav_dialog_configure_source_child (OnlineAccountsCaldavDialog* self,
                                                           ESource* source);
static void _online_accounts_caldav_dialog_configure_source_child_e_source_registry_source_added (ESourceRegistry* _sender,
                                                                                           ESource* source,
                                                                                           gpointer self);
static void online_accounts_caldav_dialog_await_source_children_configuration (OnlineAccountsCaldavDialog* self,
                                                                        GAsyncReadyCallback _callback_,
                                                                        gpointer _user_data_);
static void online_accounts_caldav_dialog_await_source_children_configuration_finish (OnlineAccountsCaldavDialog* self,
                                                                               GAsyncResult* _res_);
static void online_accounts_caldav_dialog_await_source_children_configuration_data_free (gpointer _data);
static gboolean online_accounts_caldav_dialog_await_source_children_configuration_co (OnlineAccountsCaldavDialogAwaitSourceChildrenConfigurationData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean __lambda7_ (Block4Data* _data4_);
static gboolean ___lambda7__gsource_func (gpointer self);
static void online_accounts_caldav_dialog_source_row_style_calendar_color (OnlineAccountsCaldavDialogSourceRow* self,
                                                                    GtkWidget* widget,
                                                                    const gchar* color);
static void online_accounts_caldav_dialog_source_row_set_source (OnlineAccountsCaldavDialogSourceRow* self,
                                                          ESource* value);
static GObject * online_accounts_caldav_dialog_source_row_constructor (GType type,
                                                                guint n_construct_properties,
                                                                GObjectConstructParam * construct_properties);
static void online_accounts_caldav_dialog_source_row_finalize (GObject * obj);
static GType online_accounts_caldav_dialog_source_row_get_type_once (void);
static void _vala_online_accounts_caldav_dialog_source_row_get_property (GObject * object,
                                                                  guint property_id,
                                                                  GValue * value,
                                                                  GParamSpec * pspec);
static void _vala_online_accounts_caldav_dialog_source_row_set_property (GObject * object,
                                                                  guint property_id,
                                                                  const GValue * value,
                                                                  GParamSpec * pspec);
static GObject * online_accounts_caldav_dialog_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
VALA_EXTERN ValidationMessage* validation_message_new (const gchar* label);
VALA_EXTERN ValidationMessage* validation_message_construct (GType object_type,
                                                 const gchar* label);
VALA_EXTERN GtkLabel* validation_message_get_label_widget (ValidationMessage* self);
static void _online_accounts_caldav_dialog_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                                 GtkListBoxRow* before,
                                                                                 gpointer self);
static gint _online_accounts_caldav_dialog_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                      GtkListBoxRow* row2,
                                                                      gpointer self);
static GtkWidget* _online_accounts_caldav_dialog_create_item_gtk_list_box_create_widget_func (GObject* item,
                                                                                       gpointer self);
static void _online_accounts_caldav_dialog___lambda8_ (OnlineAccountsCaldavDialog* self);
static void __online_accounts_caldav_dialog___lambda8__adw_navigation_page_shown (AdwNavigationPage* _sender,
                                                                           gpointer self);
static void _online_accounts_caldav_dialog___lambda9_ (OnlineAccountsCaldavDialog* self);
static void __online_accounts_caldav_dialog___lambda9__adw_navigation_page_shown (AdwNavigationPage* _sender,
                                                                           gpointer self);
static void _online_accounts_caldav_dialog___lambda10_ (OnlineAccountsCaldavDialog* self);
static void __online_accounts_caldav_dialog___lambda10__gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self);
static void _online_accounts_caldav_dialog___lambda11_ (OnlineAccountsCaldavDialog* self);
static void __online_accounts_caldav_dialog___lambda11__gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self);
static void _online_accounts_caldav_dialog___lambda12_ (OnlineAccountsCaldavDialog* self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda16_ (Block5Data* _data5_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda16__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void __online_accounts_caldav_dialog___lambda12__gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self);
static void _online_accounts_caldav_dialog___lambda17_ (OnlineAccountsCaldavDialog* self);
static void __online_accounts_caldav_dialog___lambda17__gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self);
static void _online_accounts_caldav_dialog___lambda18_ (OnlineAccountsCaldavDialog* self);
VALA_EXTERN void validation_message_set_reveal_child (ValidationMessage* self,
                                          gboolean value);
static void __online_accounts_caldav_dialog___lambda18__gtk_editable_changed (GtkEditable* _sender,
                                                                       gpointer self);
static void _online_accounts_caldav_dialog___lambda19_ (OnlineAccountsCaldavDialog* self);
static void __online_accounts_caldav_dialog___lambda19__gtk_editable_changed (GtkEditable* _sender,
                                                                       gpointer self);
static void _online_accounts_caldav_dialog___lambda20_ (OnlineAccountsCaldavDialog* self,
                                                 guint keyval);
static void __online_accounts_caldav_dialog___lambda20__gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                                        guint keyval,
                                                                                        guint keycode,
                                                                                        GdkModifierType state,
                                                                                        gpointer self);
static void online_accounts_caldav_dialog_finalize (GObject * obj);
static GType online_accounts_caldav_dialog_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
online_accounts_caldav_dialog_get_instance_private (OnlineAccountsCaldavDialog* self)
{
	return G_STRUCT_MEMBER_P (self, OnlineAccountsCaldavDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
online_accounts_caldav_dialog_sort_func (OnlineAccountsCaldavDialog* self,
                                         GtkListBoxRow* row1,
                                         GtkListBoxRow* row2)
{
	ESource* source1 = NULL;
	ESource* _tmp0_;
	ESource* _tmp1_;
	ESource* _tmp2_;
	ESource* source2 = NULL;
	ESource* _tmp3_;
	ESource* _tmp4_;
	ESource* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ESource* _tmp7_;
	ESource* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	ESource* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = online_accounts_caldav_dialog_source_row_get_source (G_TYPE_CHECK_INSTANCE_CAST (row1, ONLINE_ACCOUNTS_CALDAV_DIALOG_TYPE_SOURCE_ROW, OnlineAccountsCaldavDialogSourceRow));
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	source1 = _tmp2_;
	_tmp3_ = online_accounts_caldav_dialog_source_row_get_source (G_TYPE_CHECK_INSTANCE_CAST (row2, ONLINE_ACCOUNTS_CALDAV_DIALOG_TYPE_SOURCE_ROW, OnlineAccountsCaldavDialogSourceRow));
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	source2 = _tmp5_;
	_tmp7_ = source1;
	if (e_source_has_extension (_tmp7_, E_SOURCE_EXTENSION_CALENDAR)) {
		ESource* _tmp8_;
		_tmp8_ = source2;
		_tmp6_ = !e_source_has_extension (_tmp8_, E_SOURCE_EXTENSION_CALENDAR);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		result = -1;
		_g_object_unref0 (source2);
		_g_object_unref0 (source1);
		return result;
	}
	_tmp9_ = source1;
	_tmp10_ = e_source_get_display_name (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = source2;
	_tmp13_ = e_source_get_display_name (_tmp12_);
	_tmp14_ = _tmp13_;
	result = g_utf8_collate (_tmp11_, _tmp14_);
	_g_object_unref0 (source2);
	_g_object_unref0 (source1);
	return result;
}

static void
online_accounts_caldav_dialog_header_func (OnlineAccountsCaldavDialog* self,
                                           GtkListBoxRow* row,
                                           GtkListBoxRow* before)
{
	OnlineAccountsCaldavDialogSourceRow* source_row = NULL;
	OnlineAccountsCaldavDialogSourceRow* _tmp0_;
	gboolean is_calendar = FALSE;
	OnlineAccountsCaldavDialogSourceRow* _tmp1_;
	ESource* _tmp2_;
	ESource* _tmp3_;
	gboolean is_tasklist = FALSE;
	OnlineAccountsCaldavDialogSourceRow* _tmp4_;
	ESource* _tmp5_;
	ESource* _tmp6_;
	GraniteHeaderLabel* header_label = NULL;
	GraniteHeaderLabel* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (row, ONLINE_ACCOUNTS_CALDAV_DIALOG_TYPE_SOURCE_ROW, OnlineAccountsCaldavDialogSourceRow));
	source_row = _tmp0_;
	_tmp1_ = source_row;
	_tmp2_ = online_accounts_caldav_dialog_source_row_get_source (_tmp1_);
	_tmp3_ = _tmp2_;
	is_calendar = e_source_has_extension (_tmp3_, E_SOURCE_EXTENSION_CALENDAR);
	_tmp4_ = source_row;
	_tmp5_ = online_accounts_caldav_dialog_source_row_get_source (_tmp4_);
	_tmp6_ = _tmp5_;
	is_tasklist = e_source_has_extension (_tmp6_, E_SOURCE_EXTENSION_TASK_LIST);
	header_label = NULL;
	if (before == NULL) {
		if (is_calendar) {
			GraniteHeaderLabel* _tmp7_;
			_tmp7_ = granite_header_label_new (_ ("Calendars"));
			g_object_ref_sink (_tmp7_);
			_g_object_unref0 (header_label);
			header_label = _tmp7_;
		} else {
			if (is_tasklist) {
				GraniteHeaderLabel* _tmp8_;
				_tmp8_ = granite_header_label_new (_ ("Task Lists"));
				g_object_ref_sink (_tmp8_);
				_g_object_unref0 (header_label);
				header_label = _tmp8_;
			}
		}
	} else {
		OnlineAccountsCaldavDialogSourceRow* before_source_row = NULL;
		OnlineAccountsCaldavDialogSourceRow* _tmp9_;
		gboolean before_is_calendar = FALSE;
		OnlineAccountsCaldavDialogSourceRow* _tmp10_;
		ESource* _tmp11_;
		ESource* _tmp12_;
		gboolean _tmp13_ = FALSE;
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (before, ONLINE_ACCOUNTS_CALDAV_DIALOG_TYPE_SOURCE_ROW, OnlineAccountsCaldavDialogSourceRow));
		before_source_row = _tmp9_;
		_tmp10_ = before_source_row;
		_tmp11_ = online_accounts_caldav_dialog_source_row_get_source (_tmp10_);
		_tmp12_ = _tmp11_;
		before_is_calendar = e_source_has_extension (_tmp12_, E_SOURCE_EXTENSION_CALENDAR);
		if (before_is_calendar) {
			_tmp13_ = is_tasklist;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			GraniteHeaderLabel* _tmp14_;
			_tmp14_ = granite_header_label_new (_ ("Task Lists"));
			g_object_ref_sink (_tmp14_);
			_g_object_unref0 (header_label);
			header_label = _tmp14_;
		}
		_g_object_unref0 (before_source_row);
	}
	_tmp15_ = header_label;
	gtk_list_box_row_set_header (row, (GtkWidget*) _tmp15_);
	_g_object_unref0 (header_label);
	_g_object_unref0 (source_row);
}

static void
online_accounts_caldav_dialog_validate_form (OnlineAccountsCaldavDialog* self)
{
	gboolean _tmp0_ = FALSE;
	GraniteValidatedEntry* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkButton* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->url_entry;
	_tmp2_ = granite_validated_entry_get_is_valid (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GraniteValidatedEntry* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->username_entry;
		_tmp5_ = granite_validated_entry_get_is_valid (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = self->priv->login_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, _tmp0_);
}

static gboolean
online_accounts_caldav_dialog_is_valid_url (OnlineAccountsCaldavDialog* self,
                                            const gchar* uri)
{
	gchar* scheme = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = g_uri_parse_scheme (uri);
	scheme = _tmp0_;
	_tmp1_ = scheme;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_free0 (scheme);
		return result;
	}
	_tmp2_ = scheme;
	result = g_str_has_prefix (_tmp2_, "http");
	_g_free0 (scheme);
	return result;
}

GtkWidget*
online_accounts_caldav_dialog_create_item (GObject* item,
                                           OnlineAccountsCaldavDialog* self)
{
	OnlineAccountsCaldavDialogSourceRow* row = NULL;
	OnlineAccountsCaldavDialogSourceRow* _tmp0_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = online_accounts_caldav_dialog_source_row_new (G_TYPE_CHECK_INSTANCE_CAST (item, e_source_get_type (), ESource));
	g_object_ref_sink (_tmp0_);
	row = _tmp0_;
	result = (GtkWidget*) row;
	return result;
}

static void
online_accounts_caldav_dialog_find_sources_data_free (gpointer _data)
{
	OnlineAccountsCaldavDialogFindSourcesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (OnlineAccountsCaldavDialogFindSourcesData, _data_);
}

static void
online_accounts_caldav_dialog_find_sources (OnlineAccountsCaldavDialog* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	OnlineAccountsCaldavDialogFindSourcesData* _data_;
	OnlineAccountsCaldavDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (OnlineAccountsCaldavDialogFindSourcesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, online_accounts_caldav_dialog_find_sources_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	online_accounts_caldav_dialog_find_sources_co (_data_);
}

static void
online_accounts_caldav_dialog_find_sources_finish (OnlineAccountsCaldavDialog* self,
                                                   GAsyncResult* _res_)
{
	OnlineAccountsCaldavDialogFindSourcesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		OnlineAccountsCaldavDialog* self;
		self = _data1_->self;
		_data1_->found_tasklists = (_vala_array_free (_data1_->found_tasklists, _data1_->found_tasklists_length1, (GDestroyNotify) g_object_unref), NULL);
		_data1_->found_calendars = (_vala_array_free (_data1_->found_calendars, _data1_->found_calendars_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
online_accounts_caldav_dialog_find_sources_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	OnlineAccountsCaldavDialogFindSourcesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	online_accounts_caldav_dialog_find_sources_co (_data_);
}

static void
_vala_ENamedParameters_free (ENamedParameters* self)
{
	g_boxed_free (e_named_parameters_get_type (), self);
}

static gboolean
___lambda5_ (Block1Data* _data1_)
{
	OnlineAccountsCaldavDialog* self;
	GListStore* _tmp0_;
	ESource** _tmp1_;
	gint _tmp1__length1;
	GListStore* _tmp2_;
	ESource** _tmp3_;
	gint _tmp3__length1;
	ESource** _tmp4_;
	gint _tmp4__length1;
	GtkButton* _tmp5_;
	gboolean result;
	self = _data1_->self;
	_tmp0_ = self->priv->calendars_store;
	_tmp1_ = _data1_->found_calendars;
	_tmp1__length1 = _data1_->found_calendars_length1;
	g_list_store_splice (_tmp0_, (guint) 0, (guint) 0, (GObject**) _tmp1_, (guint) ((_tmp1__length1 * sizeof (ESource*)) / sizeof (GObject*)));
	_tmp2_ = self->priv->calendars_store;
	_tmp3_ = _data1_->found_calendars;
	_tmp3__length1 = _data1_->found_calendars_length1;
	_tmp4_ = _data1_->found_tasklists;
	_tmp4__length1 = _data1_->found_tasklists_length1;
	g_list_store_splice (_tmp2_, (guint) _tmp3__length1, (guint) 0, (GObject**) _tmp4_, (guint) ((_tmp4__length1 * sizeof (ESource*)) / sizeof (GObject*)));
	_tmp5_ = self->priv->save_configuration_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, TRUE);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda5_ (self);
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		OnlineAccountsCaldavDialog* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->error_placeholder);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
___lambda6_ (Block2Data* _data2_)
{
	OnlineAccountsCaldavDialog* self;
	GtkListBox* _tmp0_;
	GranitePlaceholder* _tmp1_;
	gboolean result;
	self = _data2_->self;
	_tmp0_ = self->priv->calendars_list;
	_tmp1_ = _data2_->error_placeholder;
	gtk_list_box_set_placeholder (_tmp0_, (GtkWidget*) _tmp1_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda6_ (self);
	return result;
}

static gboolean
online_accounts_caldav_dialog_find_sources_co (OnlineAccountsCaldavDialogFindSourcesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->cancellable;
	if (_data_->_tmp0_ != NULL) {
		_data_->_tmp1_ = _data_->self->priv->cancellable;
		g_cancellable_cancel (_data_->_tmp1_);
	}
	_data_->_tmp2_ = g_cancellable_new ();
	_g_object_unref0 (_data_->self->priv->cancellable);
	_data_->self->priv->cancellable = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->save_configuration_button;
	gtk_widget_set_sensitive ((GtkWidget*) _data_->_tmp3_, FALSE);
	_data_->_tmp4_ = (GtkLabel*) gtk_label_new (_ ("Finding available calendars and tasks…"));
	g_object_ref_sink (_data_->_tmp4_);
	_data_->placeholder_label = _data_->_tmp4_;
	_data_->_tmp5_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_data_->_tmp5_);
	_data_->spinner = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->spinner;
	gtk_spinner_start (_data_->_tmp6_);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_halign ((GtkWidget*) _data_->_tmp7_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _data_->_tmp7_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_data_->_tmp7_);
	_data_->placeholder = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->placeholder;
	_data_->_tmp9_ = _data_->placeholder_label;
	gtk_box_append (_data_->_tmp8_, (GtkWidget*) _data_->_tmp9_);
	_data_->_tmp10_ = _data_->placeholder;
	_data_->_tmp11_ = _data_->spinner;
	gtk_box_append (_data_->_tmp10_, (GtkWidget*) _data_->_tmp11_);
	_data_->_tmp12_ = _data_->self->priv->calendars_list;
	_data_->_tmp13_ = _data_->placeholder;
	gtk_list_box_set_placeholder (_data_->_tmp12_, (GtkWidget*) _data_->_tmp13_);
	_data_->_tmp14_ = _data_->self->priv->calendars_store;
	g_list_store_remove_all (_data_->_tmp14_);
	{
		_data_->_data1_ = g_slice_new0 (Block1Data);
		_data_->_data1_->_ref_count_ = 1;
		_data_->_data1_->self = g_object_ref (_data_->self);
		_data_->_tmp15_ = e_source_new (NULL, NULL, &_data_->_inner_error0_);
		_data_->source = _data_->_tmp15_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			goto __catch0_g_error;
		}
		_data_->_tmp16_ = _data_->source;
		e_source_set_parent (_data_->_tmp16_, "caldav-stub");
		_data_->_tmp17_ = _data_->source;
		_data_->_tmp18_ = e_source_get_extension (_data_->_tmp17_, E_SOURCE_EXTENSION_COLLECTION);
		_data_->col = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp18_, e_source_collection_get_type (), ESourceCollection);
		_data_->_tmp19_ = _data_->col;
		e_source_backend_set_backend_name ((ESourceBackend*) _data_->_tmp19_, "caldav");
		_data_->_tmp20_ = _data_->self->priv->url_entry;
		_data_->_tmp21_ = gtk_editable_get_text ((GtkEditable*) _data_->_tmp20_);
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp23_ = g_uri_parse (_data_->_tmp22_, G_URI_FLAGS_PARSE_RELAXED, &_data_->_inner_error0_);
		_data_->parsed_uri = _data_->_tmp23_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->source);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			goto __catch0_g_error;
		}
		_data_->_tmp24_ = _data_->parsed_uri;
		if (g_uri_get_port (_data_->_tmp24_) == -1) {
			_data_->_tmp25_ = _data_->parsed_uri;
			_data_->_tmp26_ = g_uri_get_scheme (_data_->_tmp25_);
			_data_->_tmp27_ = _data_->parsed_uri;
			_data_->_tmp28_ = g_uri_get_userinfo (_data_->_tmp27_);
			_data_->_tmp29_ = _data_->parsed_uri;
			_data_->_tmp30_ = g_uri_get_host (_data_->_tmp29_);
			_data_->_tmp31_ = _data_->parsed_uri;
			_data_->_tmp32_ = g_uri_get_path (_data_->_tmp31_);
			_data_->_tmp33_ = _data_->parsed_uri;
			_data_->_tmp34_ = g_uri_get_query (_data_->_tmp33_);
			_data_->_tmp35_ = _data_->parsed_uri;
			_data_->_tmp36_ = g_uri_get_fragment (_data_->_tmp35_);
			_data_->_tmp37_ = g_uri_build (G_URI_FLAGS_NONE, _data_->_tmp26_, _data_->_tmp28_, _data_->_tmp30_, 443, _data_->_tmp32_, _data_->_tmp34_, _data_->_tmp36_);
			_g_uri_unref0 (_data_->parsed_uri);
			_data_->parsed_uri = _data_->_tmp37_;
		}
		_data_->_tmp38_ = _data_->source;
		_data_->_tmp39_ = e_source_get_extension (_data_->_tmp38_, E_SOURCE_EXTENSION_WEBDAV_BACKEND);
		_data_->webdav = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp39_, e_source_webdav_get_type (), ESourceWebdav);
		_data_->_tmp40_ = _data_->webdav;
		_data_->_tmp41_ = _data_->parsed_uri;
		g_object_set (_data_->_tmp40_, "uri", _data_->_tmp41_, NULL);
		_data_->_tmp42_ = _data_->webdav;
		e_source_webdav_set_calendar_auto_schedule (_data_->_tmp42_, TRUE);
		_data_->_tmp43_ = _data_->source;
		_data_->_tmp44_ = e_source_get_extension (_data_->_tmp43_, E_SOURCE_EXTENSION_AUTHENTICATION);
		_data_->auth = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp44_, e_source_authentication_get_type (), ESourceAuthentication);
		_data_->_tmp45_ = _data_->auth;
		_data_->_tmp46_ = _data_->self->priv->username_entry;
		_data_->_tmp47_ = gtk_editable_get_text ((GtkEditable*) _data_->_tmp46_);
		_data_->_tmp48_ = _data_->_tmp47_;
		e_source_authentication_set_user (_data_->_tmp45_, _data_->_tmp48_);
		_data_->_tmp49_ = e_named_parameters_new ();
		_data_->credentials = _data_->_tmp49_;
		_data_->_tmp50_ = _data_->credentials;
		_data_->_tmp51_ = _data_->self->priv->username_entry;
		_data_->_tmp52_ = gtk_editable_get_text ((GtkEditable*) _data_->_tmp51_);
		_data_->_tmp53_ = _data_->_tmp52_;
		e_named_parameters_set (_data_->_tmp50_, E_SOURCE_CREDENTIAL_USERNAME, _data_->_tmp53_);
		_data_->_tmp54_ = _data_->credentials;
		_data_->_tmp55_ = _data_->self->priv->password_entry;
		_data_->_tmp56_ = gtk_editable_get_text ((GtkEditable*) _data_->_tmp55_);
		_data_->_tmp57_ = _data_->_tmp56_;
		e_named_parameters_set (_data_->_tmp54_, E_SOURCE_CREDENTIAL_PASSWORD, _data_->_tmp57_);
		_data_->_tmp58_ = _data_->source;
		_data_->_tmp59_ = _data_->credentials;
		_data_->_tmp60_ = _data_->self->priv->cancellable;
		_data_->_tmp61_ = 0;
		_data_->_state_ = 1;
		online_accounts_caldav_dialog_find_sources_supporting (_data_->self, E_WEBDAV_DISCOVER_SUPPORTS_EVENTS, _data_->_tmp58_, _data_->_tmp59_, _data_->_tmp60_, online_accounts_caldav_dialog_find_sources_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp62_ = online_accounts_caldav_dialog_find_sources_supporting_finish (_data_->self, _data_->_res_, &_data_->_tmp61_, &_data_->_inner_error0_);
		_data_->_data1_->found_calendars = _data_->_tmp62_;
		_data_->_data1_->found_calendars_length1 = _data_->_tmp61_;
		_data_->_data1_->_found_calendars_size_ = _data_->_data1_->found_calendars_length1;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			__vala_ENamedParameters_free0 (_data_->credentials);
			_g_uri_unref0 (_data_->parsed_uri);
			_g_object_unref0 (_data_->source);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			goto __catch0_g_error;
		}
		_data_->_tmp63_ = _data_->source;
		_data_->_tmp64_ = _data_->credentials;
		_data_->_tmp65_ = _data_->self->priv->cancellable;
		_data_->_tmp66_ = 0;
		_data_->_state_ = 2;
		online_accounts_caldav_dialog_find_sources_supporting (_data_->self, E_WEBDAV_DISCOVER_SUPPORTS_TASKS, _data_->_tmp63_, _data_->_tmp64_, _data_->_tmp65_, online_accounts_caldav_dialog_find_sources_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp67_ = online_accounts_caldav_dialog_find_sources_supporting_finish (_data_->self, _data_->_res_, &_data_->_tmp66_, &_data_->_inner_error0_);
		_data_->_data1_->found_tasklists = _data_->_tmp67_;
		_data_->_data1_->found_tasklists_length1 = _data_->_tmp66_;
		_data_->_data1_->_found_tasklists_size_ = _data_->_data1_->found_tasklists_length1;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			__vala_ENamedParameters_free0 (_data_->credentials);
			_g_uri_unref0 (_data_->parsed_uri);
			_g_object_unref0 (_data_->source);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			goto __catch0_g_error;
		}
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda5__gsource_func, block1_data_ref (_data_->_data1_), block1_data_unref);
		__vala_ENamedParameters_free0 (_data_->credentials);
		_g_uri_unref0 (_data_->parsed_uri);
		_g_object_unref0 (_data_->source);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_data2_ = g_slice_new0 (Block2Data);
		_data_->_data2_->_ref_count_ = 1;
		_data_->_data2_->self = g_object_ref (_data_->self);
		_data_->_tmp68_ = _data_->e;
		_data_->_tmp69_ = _data_->_tmp68_->message;
		_data_->_tmp70_ = g_strdup (_data_->_tmp69_);
		_data_->_tmp71_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_data_->_tmp72_ = NULL;
		_data_->_tmp72_ = granite_placeholder_new (_ ("Could not fetch calendars"));
		granite_placeholder_set_description (_data_->_tmp72_, _data_->_tmp70_);
		_g_free0 (_data_->_tmp70_);
		granite_placeholder_set_icon (_data_->_tmp72_, (GIcon*) _data_->_tmp71_);
		_g_object_unref0 (_data_->_tmp71_);
		g_object_ref_sink (_data_->_tmp72_);
		_data_->_data2_->error_placeholder = _data_->_tmp72_;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda6__gsource_func, block2_data_ref (_data_->_data2_), block2_data_unref);
		_g_error_free0 (_data_->e);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->placeholder);
		_g_object_unref0 (_data_->spinner);
		_g_object_unref0 (_data_->placeholder_label);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->placeholder);
	_g_object_unref0 (_data_->spinner);
	_g_object_unref0 (_data_->placeholder_label);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
online_accounts_caldav_dialog_find_sources_supporting_data_free (gpointer _data)
{
	OnlineAccountsCaldavDialogFindSourcesSupportingData* _data_;
	_data_ = _data;
	__vala_ENamedParameters_free0 (_data_->credentials);
	_g_object_unref0 (_data_->cancellable);
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (OnlineAccountsCaldavDialogFindSourcesSupportingData, _data_);
}

static ENamedParameters*
_vala_ENamedParameters_copy (ENamedParameters* self)
{
	return g_boxed_copy (e_named_parameters_get_type (), self);
}

static gpointer
__vala_ENamedParameters_copy0 (gpointer self)
{
	return self ? _vala_ENamedParameters_copy (self) : NULL;
}

static void
online_accounts_caldav_dialog_find_sources_supporting (OnlineAccountsCaldavDialog* self,
                                                       EWebDAVDiscoverSupports only_supports,
                                                       ESource* source,
                                                       ENamedParameters* credentials,
                                                       GCancellable* cancellable,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_)
{
	OnlineAccountsCaldavDialogFindSourcesSupportingData* _data_;
	OnlineAccountsCaldavDialog* _tmp0_;
	ESource* _tmp1_;
	ENamedParameters* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (credentials != NULL);
	_data_ = g_slice_new0 (OnlineAccountsCaldavDialogFindSourcesSupportingData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, online_accounts_caldav_dialog_find_sources_supporting_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->only_supports = only_supports;
	_tmp1_ = _g_object_ref0 (source);
	_g_object_unref0 (_data_->source);
	_data_->source = _tmp1_;
	_tmp2_ = __vala_ENamedParameters_copy0 (credentials);
	__vala_ENamedParameters_free0 (_data_->credentials);
	_data_->credentials = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	online_accounts_caldav_dialog_find_sources_supporting_co (_data_);
}

static ESource**
online_accounts_caldav_dialog_find_sources_supporting_finish (OnlineAccountsCaldavDialog* self,
                                                              GAsyncResult* _res_,
                                                              gint* result_length1,
                                                              GError** error)
{
	ESource** result;
	OnlineAccountsCaldavDialogFindSourcesSupportingData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		OnlineAccountsCaldavDialog* self;
		self = _data3_->self;
		_g_error_free0 (_data3_->discover_error);
		_data3_->e_sources = (_vala_array_free (_data3_->e_sources, _data3_->e_sources_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (_data3_->source);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
_vala_EWebDAVDiscoveredSource_free (EWebDAVDiscoveredSource* self)
{
	g_boxed_free (e_webdav_discovered_source_get_type (), self);
}

static void
__vala_EWebDAVDiscoveredSource_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_EWebDAVDiscoveredSource_free (var), NULL));
}

static inline void
_g_slist_free___vala_EWebDAVDiscoveredSource_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) __vala_EWebDAVDiscoveredSource_free0_);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_slist_free__g_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
_vala_array_add1 (ESource** * array,
                  gint* length,
                  gint* size,
                  ESource* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ESource*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
__lambda4_ (Block3Data* _data3_,
            GObject* obj,
            GAsyncResult* res)
{
	OnlineAccountsCaldavDialog* self;
	gchar* certificate_pem = NULL;
	GTlsCertificateFlags certificate_errors = 0U;
	GSList* discovered_sources = NULL;
	GSList* calendar_user_addresses = NULL;
	GError* _inner_error0_ = NULL;
	self = _data3_->self;
	g_return_if_fail (res != NULL);
	{
		gchar* _tmp0_ = NULL;
		GTlsCertificateFlags _tmp1_ = 0U;
		GSList* _tmp2_ = NULL;
		GSList* _tmp3_ = NULL;
		gchar* webdav_host = NULL;
		GSList* _tmp11_;
		GSList* _tmp49_;
		e_webdav_discover_sources_finish (_data3_->source, res, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, &_inner_error0_);
		_g_free0 (certificate_pem);
		certificate_pem = _tmp0_;
		certificate_errors = _tmp1_;
		(discovered_sources == NULL) ? NULL : (discovered_sources = (_g_slist_free___vala_EWebDAVDiscoveredSource_free0_ (discovered_sources), NULL));
		discovered_sources = _tmp2_;
		(calendar_user_addresses == NULL) ? NULL : (calendar_user_addresses = (_g_slist_free__g_free0_ (calendar_user_addresses), NULL));
		calendar_user_addresses = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				goto __catch0_g_io_error_cancelled;
			}
			goto __catch0_g_error;
		}
		webdav_host = NULL;
		if (e_source_has_extension (_data3_->source, E_SOURCE_EXTENSION_WEBDAV_BACKEND)) {
			ESourceWebdav* webdav_extension = NULL;
			ESourceExtension* _tmp4_;
			ESourceWebdav* _tmp5_;
			GUri* _tmp6_;
			GUri* _tmp7_;
			GUri* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp4_ = e_source_get_extension (_data3_->source, E_SOURCE_EXTENSION_WEBDAV_BACKEND);
			webdav_extension = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, e_source_webdav_get_type (), ESourceWebdav);
			_tmp5_ = webdav_extension;
			g_object_get (_tmp5_, "uri", &_tmp6_, NULL);
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_;
			_tmp9_ = g_uri_get_host (_tmp8_);
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (webdav_host);
			webdav_host = _tmp10_;
			_g_uri_unref0 (_tmp8_);
		}
		_tmp11_ = discovered_sources;
		{
			GSList* disc_source_collection = NULL;
			GSList* disc_source_it = NULL;
			disc_source_collection = _tmp11_;
			for (disc_source_it = disc_source_collection; disc_source_it != NULL; disc_source_it = disc_source_it->next) {
				EWebDAVDiscoveredSource* disc_source = NULL;
				disc_source = (EWebDAVDiscoveredSource*) disc_source_it->data;
				{
					gboolean _tmp12_ = FALSE;
					gboolean _tmp13_ = FALSE;
					EWebDAVDiscoveredSource* _tmp14_;
					ESource* e_source = NULL;
					EWebDAVDiscoveredSource* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					ESource* _tmp24_ = NULL;
					ESourceWebdav* webdav = NULL;
					ESource* _tmp25_;
					ESourceExtension* _tmp26_;
					GUri* _tmp27_ = NULL;
					EWebDAVDiscoveredSource* _tmp28_;
					const gchar* _tmp29_;
					GUri* _tmp30_;
					ESourceWebdav* _tmp31_;
					ESourceWebdav* _tmp32_;
					EWebDAVDiscoveredSource* _tmp33_;
					const gchar* _tmp34_;
					ESource* _tmp47_;
					ESource* _tmp48_;
					_tmp14_ = disc_source;
					if (_tmp14_ == NULL) {
						_tmp13_ = TRUE;
					} else {
						EWebDAVDiscoveredSource* _tmp15_;
						_tmp15_ = disc_source;
						_tmp13_ = (_data3_->only_supports & _tmp15_->supports) == 0;
					}
					if (_tmp13_) {
						_tmp12_ = TRUE;
					} else {
						gboolean _tmp16_ = FALSE;
						const gchar* _tmp17_;
						_tmp17_ = webdav_host;
						if (_tmp17_ != NULL) {
							EWebDAVDiscoveredSource* _tmp18_;
							const gchar* _tmp19_;
							const gchar* _tmp20_;
							_tmp18_ = disc_source;
							_tmp19_ = _tmp18_->href;
							_tmp20_ = webdav_host;
							_tmp16_ = !string_contains (_tmp19_, _tmp20_);
						} else {
							_tmp16_ = FALSE;
						}
						_tmp12_ = _tmp16_;
					}
					if (_tmp12_) {
						continue;
					}
					_tmp21_ = disc_source;
					_tmp22_ = _tmp21_->display_name;
					_tmp23_ = g_strdup (_tmp22_);
					_tmp24_ = e_source_new (NULL, NULL, &_inner_error0_);
					e_source_set_display_name (_tmp24_, _tmp23_);
					_g_free0 (_tmp23_);
					e_source = _tmp24_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (webdav_host);
						if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
							goto __catch0_g_io_error_cancelled;
						}
						goto __catch0_g_error;
					}
					_tmp25_ = e_source;
					_tmp26_ = e_source_get_extension (_tmp25_, E_SOURCE_EXTENSION_WEBDAV_BACKEND);
					webdav = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, e_source_webdav_get_type (), ESourceWebdav);
					_tmp28_ = disc_source;
					_tmp29_ = _tmp28_->href;
					_tmp30_ = g_uri_parse (_tmp29_, G_URI_FLAGS_PARSE_RELAXED, &_inner_error0_);
					_tmp27_ = _tmp30_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (e_source);
						_g_free0 (webdav_host);
						if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
							goto __catch0_g_io_error_cancelled;
						}
						goto __catch0_g_error;
					}
					_tmp31_ = webdav;
					g_object_set (_tmp31_, "uri", _tmp27_, NULL);
					_tmp32_ = webdav;
					_tmp33_ = disc_source;
					_tmp34_ = _tmp33_->color;
					e_source_webdav_set_color (_tmp32_, _tmp34_);
					switch (_data3_->only_supports) {
						case E_WEBDAV_DISCOVER_SUPPORTS_EVENTS:
						{
							ESourceCalendar* calendar = NULL;
							ESource* _tmp35_;
							ESourceExtension* _tmp36_;
							ESourceCalendar* _tmp37_;
							ESourceCalendar* _tmp38_;
							EWebDAVDiscoveredSource* _tmp39_;
							const gchar* _tmp40_;
							_tmp35_ = e_source;
							_tmp36_ = e_source_get_extension (_tmp35_, E_SOURCE_EXTENSION_CALENDAR);
							calendar = G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, e_source_calendar_get_type (), ESourceCalendar);
							_tmp37_ = calendar;
							e_source_backend_set_backend_name ((ESourceBackend*) _tmp37_, "caldav");
							_tmp38_ = calendar;
							_tmp39_ = disc_source;
							_tmp40_ = _tmp39_->color;
							e_source_selectable_set_color ((ESourceSelectable*) _tmp38_, _tmp40_);
							break;
						}
						case E_WEBDAV_DISCOVER_SUPPORTS_TASKS:
						{
							ESourceTaskList* tasklist = NULL;
							ESource* _tmp41_;
							ESourceExtension* _tmp42_;
							ESourceTaskList* _tmp43_;
							ESourceTaskList* _tmp44_;
							EWebDAVDiscoveredSource* _tmp45_;
							const gchar* _tmp46_;
							_tmp41_ = e_source;
							_tmp42_ = e_source_get_extension (_tmp41_, E_SOURCE_EXTENSION_TASK_LIST);
							tasklist = G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, e_source_task_list_get_type (), ESourceTaskList);
							_tmp43_ = tasklist;
							e_source_backend_set_backend_name ((ESourceBackend*) _tmp43_, "caldav");
							_tmp44_ = tasklist;
							_tmp45_ = disc_source;
							_tmp46_ = _tmp45_->color;
							e_source_selectable_set_color ((ESourceSelectable*) _tmp44_, _tmp46_);
							break;
						}
						default:
						break;
					}
					_tmp47_ = e_source;
					_tmp48_ = _g_object_ref0 (_tmp47_);
					_vala_array_add1 (&_data3_->e_sources, &_data3_->e_sources_length1, &_data3_->_e_sources_size_, _tmp48_);
					_g_uri_unref0 (_tmp27_);
					_g_object_unref0 (e_source);
				}
			}
		}
		_tmp49_ = discovered_sources;
		discovered_sources = NULL;
		e_webdav_discover_free_discovered_sources (_tmp49_);
		_g_free0 (webdav_host);
	}
	goto __finally0;
	__catch0_g_io_error_cancelled:
	{
		g_clear_error (&_inner_error0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp50_;
		GError* _tmp51_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp50_ = e;
		_tmp51_ = _g_error_copy0 (_tmp50_);
		_g_error_free0 (_data3_->discover_error);
		_data3_->discover_error = _tmp51_;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		(calendar_user_addresses == NULL) ? NULL : (calendar_user_addresses = (_g_slist_free__g_free0_ (calendar_user_addresses), NULL));
		(discovered_sources == NULL) ? NULL : (discovered_sources = (_g_slist_free___vala_EWebDAVDiscoveredSource_free0_ (discovered_sources), NULL));
		_g_free0 (certificate_pem);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	online_accounts_caldav_dialog_find_sources_supporting_co (_data3_->_async_data_);
	(calendar_user_addresses == NULL) ? NULL : (calendar_user_addresses = (_g_slist_free__g_free0_ (calendar_user_addresses), NULL));
	(discovered_sources == NULL) ? NULL : (discovered_sources = (_g_slist_free___vala_EWebDAVDiscoveredSource_free0_ (discovered_sources), NULL));
	_g_free0 (certificate_pem);
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda4_ (self, source_object, res);
	block3_data_unref (self);
}

static ESource**
_vala_array_dup1 (ESource** self,
                  gssize length)
{
	if (length >= 0) {
		ESource** result;
		gssize i;
		result = g_new0 (ESource*, length + 1);
		for (i = 0; i < length; i++) {
			ESource* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gboolean
online_accounts_caldav_dialog_find_sources_supporting_co (OnlineAccountsCaldavDialogFindSourcesSupportingData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->self = g_object_ref (_data_->self);
	_data_->_data3_->only_supports = _data_->only_supports;
	_g_object_unref0 (_data_->_data3_->source);
	_data_->_data3_->source = _data_->source;
	_data_->_data3_->_async_data_ = _data_;
	_data_->_tmp0_ = g_new0 (ESource*, 0 + 1);
	_data_->_data3_->e_sources = _data_->_tmp0_;
	_data_->_data3_->e_sources_length1 = 0;
	_data_->_data3_->_e_sources_size_ = _data_->_data3_->e_sources_length1;
	_data_->_data3_->discover_error = NULL;
	e_webdav_discover_sources (_data_->_data3_->source, NULL, (guint32) _data_->_data3_->only_supports, _data_->credentials, _data_->cancellable, ___lambda4__gasync_ready_callback, block3_data_ref (_data_->_data3_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp1_ = _data_->_data3_->discover_error;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->_data3_->discover_error;
		_data_->_tmp3_ = _g_error_copy0 (_data_->_tmp2_);
		_data_->_inner_error0_ = _data_->_tmp3_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->_data3_->e_sources;
	_data_->_tmp4__length1 = _data_->_data3_->e_sources_length1;
	_data_->_tmp5_ = (_data_->_tmp4_ != NULL) ? _vala_array_dup1 (_data_->_tmp4_, _data_->_tmp4__length1) : _data_->_tmp4_;
	_data_->_tmp5__length1 = _data_->_tmp4__length1;
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp6__length1 = _data_->_tmp5__length1;
	_data_->result_length1 = _data_->_tmp6__length1;
	_data_->result = _data_->_tmp6_;
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
online_accounts_caldav_dialog_load_configuration_data_free (gpointer _data)
{
	OnlineAccountsCaldavDialogLoadConfigurationData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->collection_source);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (OnlineAccountsCaldavDialogLoadConfigurationData, _data_);
}

void
online_accounts_caldav_dialog_load_configuration (OnlineAccountsCaldavDialog* self,
                                                  ESource* collection_source,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	OnlineAccountsCaldavDialogLoadConfigurationData* _data_;
	OnlineAccountsCaldavDialog* _tmp0_;
	ESource* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (collection_source != NULL);
	_data_ = g_slice_new0 (OnlineAccountsCaldavDialogLoadConfigurationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, online_accounts_caldav_dialog_load_configuration_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (collection_source);
	_g_object_unref0 (_data_->collection_source);
	_data_->collection_source = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	online_accounts_caldav_dialog_load_configuration_co (_data_);
}

void
online_accounts_caldav_dialog_load_configuration_finish (OnlineAccountsCaldavDialog* self,
                                                         GAsyncResult* _res_,
                                                         GError** error)
{
	OnlineAccountsCaldavDialogLoadConfigurationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
online_accounts_caldav_dialog_load_configuration_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	OnlineAccountsCaldavDialogLoadConfigurationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	online_accounts_caldav_dialog_load_configuration_co (_data_);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
online_accounts_caldav_dialog_load_configuration_co (OnlineAccountsCaldavDialogLoadConfigurationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!e_source_has_extension (_data_->collection_source, E_SOURCE_EXTENSION_COLLECTION)) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp1_ = e_source_get_extension (_data_->collection_source, E_SOURCE_EXTENSION_COLLECTION);
		_data_->_tmp2_ = e_source_backend_get_backend_name ((ESourceBackend*) G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, e_source_collection_get_type (), ESourceCollection));
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp0_ = g_strcmp0 ("webdav", _data_->_tmp3_) != 0;
	}
	if (_data_->_tmp0_) {
		_data_->_tmp4_ = g_error_new_literal (CAMEL_ERROR, CAMEL_ERROR_GENERIC, _ ("The data provided does not seem to reflect a valid CalDAV account."));
		_data_->_inner_error0_ = _data_->_tmp4_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 1;
	e_source_registry_new (_data_->cancellable, online_accounts_caldav_dialog_load_configuration_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = e_source_registry_new_finish (_data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp5_ = _data_->_tmp6_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->_tmp5_;
	_data_->_tmp5_ = NULL;
	_g_object_unref0 (_data_->self->priv->registry);
	_data_->self->priv->registry = _data_->_tmp7_;
	if (g_cancellable_is_cancelled (_data_->cancellable)) {
		_g_object_unref0 (_data_->_tmp5_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _g_object_ref0 (_data_->collection_source);
	_g_object_unref0 (_data_->self->priv->source);
	_data_->self->priv->source = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->self->priv->registry;
	_data_->_tmp10_ = e_source_credentials_provider_new (_data_->_tmp9_);
	_data_->credentials_provider = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->credentials_provider;
	_data_->_tmp12_ = NULL;
	e_source_credentials_provider_lookup_sync (_data_->_tmp11_, _data_->collection_source, NULL, &_data_->_tmp12_, &_data_->_inner_error0_);
	__vala_ENamedParameters_free0 (_data_->collection_credentials);
	_data_->collection_credentials = _data_->_tmp12_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		__vala_ENamedParameters_free0 (_data_->collection_credentials);
		_g_object_unref0 (_data_->credentials_provider);
		_g_object_unref0 (_data_->_tmp5_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = _data_->collection_credentials;
	if (_data_->_tmp13_ != NULL) {
		_data_->_tmp14_ = _data_->self->priv->password_entry;
		_data_->_tmp15_ = _data_->collection_credentials;
		_data_->_tmp16_ = e_named_parameters_get (_data_->_tmp15_, E_SOURCE_CREDENTIAL_PASSWORD);
		gtk_editable_set_text ((GtkEditable*) _data_->_tmp14_, _data_->_tmp16_);
	}
	_data_->_tmp17_ = e_source_get_extension (_data_->collection_source, E_SOURCE_EXTENSION_COLLECTION);
	_data_->collection_extension = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp17_, e_source_collection_get_type (), ESourceCollection);
	_data_->_tmp18_ = _data_->self->priv->username_entry;
	_data_->_tmp19_ = _data_->collection_extension;
	_data_->_tmp20_ = e_source_collection_get_identity (_data_->_tmp19_);
	_data_->_tmp21_ = _data_->_tmp20_;
	gtk_editable_set_text ((GtkEditable*) _data_->_tmp18_, _data_->_tmp21_);
	if (e_source_has_extension (_data_->collection_source, E_SOURCE_EXTENSION_WEBDAV_BACKEND)) {
		_data_->_tmp22_ = e_source_get_extension (_data_->collection_source, E_SOURCE_EXTENSION_WEBDAV_BACKEND);
		_data_->webdav_extension = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp22_, e_source_webdav_get_type (), ESourceWebdav);
		_data_->_tmp23_ = _data_->self->priv->url_entry;
		_data_->_tmp24_ = _data_->webdav_extension;
		g_object_get (_data_->_tmp24_, "uri", &_data_->_tmp25_, NULL);
		_data_->_tmp26_ = _data_->_tmp25_;
		_data_->_tmp27_ = _data_->_tmp26_;
		_data_->_tmp28_ = g_uri_to_string (_data_->_tmp27_);
		_data_->_tmp29_ = _data_->_tmp28_;
		gtk_editable_set_text ((GtkEditable*) _data_->_tmp23_, _data_->_tmp29_);
		_g_free0 (_data_->_tmp29_);
		_g_uri_unref0 (_data_->_tmp27_);
		_data_->_tmp30_ = _data_->webdav_extension;
		g_object_get (_data_->_tmp30_, "uri", &_data_->_tmp31_, NULL);
		_data_->_tmp32_ = _data_->_tmp31_;
		_data_->_tmp33_ = _data_->_tmp32_;
		_data_->_tmp34_ = g_uri_get_user (_data_->_tmp33_);
		_data_->_tmp35_ = _data_->_tmp34_;
		_g_uri_unref0 (_data_->_tmp33_);
		_data_->uri_user = _data_->_tmp35_;
		_data_->_tmp37_ = _data_->uri_user;
		if (_data_->_tmp37_ != NULL) {
			_data_->_tmp38_ = _data_->uri_user;
			_data_->_tmp36_ = g_strcmp0 (_data_->_tmp38_, "") != 0;
		} else {
			_data_->_tmp36_ = FALSE;
		}
		if (_data_->_tmp36_) {
			_data_->_tmp39_ = _data_->self->priv->url_entry;
			_data_->_tmp40_ = _data_->self->priv->url_entry;
			_data_->_tmp41_ = gtk_editable_get_text ((GtkEditable*) _data_->_tmp40_);
			_data_->_tmp42_ = _data_->_tmp41_;
			_data_->_tmp43_ = _data_->uri_user;
			_data_->_tmp44_ = g_strconcat (_data_->_tmp43_, "@", NULL);
			_data_->_tmp45_ = _data_->_tmp44_;
			_data_->_tmp46_ = string_replace (_data_->_tmp42_, _data_->_tmp45_, "");
			_data_->_tmp47_ = _data_->_tmp46_;
			gtk_editable_set_text ((GtkEditable*) _data_->_tmp39_, _data_->_tmp47_);
			_g_free0 (_data_->_tmp47_);
			_g_free0 (_data_->_tmp45_);
		}
	}
	_data_->_tmp48_ = _data_->self->priv->display_name_entry;
	_data_->_tmp49_ = e_source_get_display_name (_data_->collection_source);
	_data_->_tmp50_ = _data_->_tmp49_;
	gtk_editable_set_text ((GtkEditable*) _data_->_tmp48_, _data_->_tmp50_);
	__vala_ENamedParameters_free0 (_data_->collection_credentials);
	_g_object_unref0 (_data_->credentials_provider);
	_g_object_unref0 (_data_->_tmp5_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
online_accounts_caldav_dialog_save_configuration_data_free (gpointer _data)
{
	OnlineAccountsCaldavDialogSaveConfigurationData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (OnlineAccountsCaldavDialogSaveConfigurationData, _data_);
}

static void
online_accounts_caldav_dialog_save_configuration (OnlineAccountsCaldavDialog* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	OnlineAccountsCaldavDialogSaveConfigurationData* _data_;
	OnlineAccountsCaldavDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (OnlineAccountsCaldavDialogSaveConfigurationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, online_accounts_caldav_dialog_save_configuration_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	online_accounts_caldav_dialog_save_configuration_co (_data_);
}

static void
online_accounts_caldav_dialog_save_configuration_finish (OnlineAccountsCaldavDialog* self,
                                                         GAsyncResult* _res_,
                                                         GError** error)
{
	OnlineAccountsCaldavDialogSaveConfigurationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
online_accounts_caldav_dialog_save_configuration_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	OnlineAccountsCaldavDialogSaveConfigurationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	online_accounts_caldav_dialog_save_configuration_co (_data_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_online_accounts_caldav_dialog_configure_source_child_e_source_registry_source_added (ESourceRegistry* _sender,
                                                                                      ESource* source,
                                                                                      gpointer self)
{
	online_accounts_caldav_dialog_configure_source_child ((OnlineAccountsCaldavDialog*) self, source);
}

static gboolean
online_accounts_caldav_dialog_save_configuration_co (OnlineAccountsCaldavDialogSaveConfigurationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->cancellable;
	if (_data_->_tmp0_ != NULL) {
		_data_->_tmp1_ = _data_->self->priv->cancellable;
		g_cancellable_cancel (_data_->_tmp1_);
	}
	_data_->_tmp2_ = g_cancellable_new ();
	_g_object_unref0 (_data_->self->priv->cancellable);
	_data_->self->priv->cancellable = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->registry;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp5_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		e_source_registry_new (_data_->_tmp5_, online_accounts_caldav_dialog_save_configuration_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp6_ = e_source_registry_new_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp4_ = _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp7_ = _data_->_tmp4_;
		_data_->_tmp4_ = NULL;
		_g_object_unref0 (_data_->self->priv->registry);
		_data_->self->priv->registry = _data_->_tmp7_;
		_g_object_unref0 (_data_->_tmp4_);
	}
	_data_->_tmp8_ = _data_->self->priv->cancellable;
	if (g_cancellable_is_cancelled (_data_->_tmp8_)) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->new_sources = NULL;
	_data_->_tmp9_ = e_source_new (NULL, NULL, &_data_->_inner_error0_);
	_data_->collection_source = _data_->_tmp9_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		(_data_->new_sources == NULL) ? NULL : (_data_->new_sources = (_g_list_free__g_object_unref0_ (_data_->new_sources), NULL));
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->collection_source;
	e_source_set_parent (_data_->_tmp10_, "");
	_data_->_tmp11_ = _data_->collection_source;
	_data_->_tmp12_ = _data_->self->priv->display_name_entry;
	_data_->_tmp13_ = gtk_editable_get_text ((GtkEditable*) _data_->_tmp12_);
	_data_->_tmp14_ = _data_->_tmp13_;
	e_source_set_display_name (_data_->_tmp11_, _data_->_tmp14_);
	_data_->_tmp15_ = _data_->collection_source;
	_data_->_tmp16_ = e_source_get_extension (_data_->_tmp15_, E_SOURCE_EXTENSION_COLLECTION);
	_data_->collection_extension = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp16_, e_source_collection_get_type (), ESourceCollection);
	_data_->_tmp17_ = _data_->collection_extension;
	e_source_backend_set_backend_name ((ESourceBackend*) _data_->_tmp17_, "webdav");
	_data_->_tmp18_ = _data_->collection_extension;
	_data_->_tmp19_ = _data_->self->priv->url_entry;
	_data_->_tmp20_ = gtk_editable_get_text ((GtkEditable*) _data_->_tmp19_);
	_data_->_tmp21_ = _data_->_tmp20_;
	e_source_collection_set_calendar_url (_data_->_tmp18_, _data_->_tmp21_);
	_data_->_tmp22_ = _data_->collection_extension;
	_data_->_tmp23_ = _data_->self->priv->username_entry;
	_data_->_tmp24_ = gtk_editable_get_text ((GtkEditable*) _data_->_tmp23_);
	_data_->_tmp25_ = _data_->_tmp24_;
	e_source_collection_set_identity (_data_->_tmp22_, _data_->_tmp25_);
	_data_->_tmp26_ = _data_->collection_source;
	_data_->_tmp27_ = e_source_get_extension (_data_->_tmp26_, E_SOURCE_EXTENSION_AUTHENTICATION);
	_data_->authentication_extension = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp27_, e_source_authentication_get_type (), ESourceAuthentication);
	_data_->_tmp28_ = _data_->authentication_extension;
	_data_->_tmp29_ = _data_->self->priv->username_entry;
	_data_->_tmp30_ = gtk_editable_get_text ((GtkEditable*) _data_->_tmp29_);
	_data_->_tmp31_ = _data_->_tmp30_;
	e_source_authentication_set_user (_data_->_tmp28_, _data_->_tmp31_);
	_data_->_tmp32_ = _data_->collection_source;
	_data_->_tmp33_ = e_source_get_extension (_data_->_tmp32_, E_SOURCE_EXTENSION_WEBDAV_BACKEND);
	_data_->webdav_extension = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp33_, e_source_webdav_get_type (), ESourceWebdav);
	{
		_data_->_tmp35_ = _data_->self->priv->url_entry;
		_data_->_tmp36_ = gtk_editable_get_text ((GtkEditable*) _data_->_tmp35_);
		_data_->_tmp37_ = _data_->_tmp36_;
		_data_->_tmp38_ = g_uri_parse (_data_->_tmp37_, G_URI_FLAGS_PARSE_RELAXED, &_data_->_inner_error0_);
		_data_->_tmp34_ = _data_->_tmp38_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp39_ = _data_->webdav_extension;
		g_object_set (_data_->_tmp39_, "uri", _data_->_tmp34_, NULL);
		_g_uri_unref0 (_data_->_tmp34_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp40_ = _data_->e;
		_data_->_tmp41_ = _data_->_tmp40_->message;
		g_warning ("CaldavDialog.vala:518: Unable to save webdav extension: %s", _data_->_tmp41_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->collection_source);
		(_data_->new_sources == NULL) ? NULL : (_data_->new_sources = (_g_list_free__g_object_unref0_ (_data_->new_sources), NULL));
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp42_ = _data_->webdav_extension;
	e_source_webdav_set_calendar_auto_schedule (_data_->_tmp42_, TRUE);
	_data_->_tmp43_ = _data_->collection_source;
	_data_->_tmp44_ = e_source_get_extension (_data_->_tmp43_, E_SOURCE_EXTENSION_OFFLINE);
	_data_->offline_extension = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp44_, e_source_offline_get_type (), ESourceOffline);
	_data_->_tmp45_ = _data_->offline_extension;
	e_source_offline_set_stay_synchronized (_data_->_tmp45_, TRUE);
	_data_->_tmp46_ = _data_->collection_source;
	_data_->_tmp47_ = e_source_get_extension (_data_->_tmp46_, E_SOURCE_EXTENSION_REFRESH);
	_data_->refresh_extension = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp47_, e_source_refresh_get_type (), ESourceRefresh);
	_data_->_tmp48_ = _data_->refresh_extension;
	e_source_refresh_set_enabled (_data_->_tmp48_, TRUE);
	_data_->_tmp49_ = _data_->refresh_extension;
	e_source_refresh_set_interval_minutes (_data_->_tmp49_, (guint) 10);
	_data_->_tmp50_ = _data_->collection_source;
	_data_->_tmp51_ = _g_object_ref0 (_data_->_tmp50_);
	_data_->new_sources = g_list_append (_data_->new_sources, _data_->_tmp51_);
	_data_->_tmp52_ = _data_->collection_source;
	_data_->_tmp53_ = _data_->self->priv->password_entry;
	_data_->_tmp54_ = gtk_editable_get_text ((GtkEditable*) _data_->_tmp53_);
	_data_->_tmp55_ = _data_->_tmp54_;
	_data_->_tmp56_ = _data_->self->priv->cancellable;
	_data_->_state_ = 2;
	e_source_store_password (_data_->_tmp52_, _data_->_tmp55_, TRUE, _data_->_tmp56_, online_accounts_caldav_dialog_save_configuration_ready, _data_);
	return FALSE;
	_state_2:
	e_source_store_password_finish (_data_->_tmp52_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->collection_source);
		(_data_->new_sources == NULL) ? NULL : (_data_->new_sources = (_g_list_free__g_object_unref0_ (_data_->new_sources), NULL));
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp57_ = _data_->self->priv->registry;
	_data_->_tmp58_ = _data_->new_sources;
	_data_->_tmp59_ = _data_->self->priv->cancellable;
	_data_->_state_ = 3;
	e_source_registry_create_sources (_data_->_tmp57_, _data_->_tmp58_, _data_->_tmp59_, online_accounts_caldav_dialog_save_configuration_ready, _data_);
	return FALSE;
	_state_3:
	e_source_registry_create_sources_finish (_data_->_tmp57_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->collection_source);
		(_data_->new_sources == NULL) ? NULL : (_data_->new_sources = (_g_list_free__g_object_unref0_ (_data_->new_sources), NULL));
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->source_children_configuration_count = (guint) 0;
	_data_->_tmp60_ = _data_->self->priv->registry;
	g_signal_connect_object (_data_->_tmp60_, "source-added", (GCallback) _online_accounts_caldav_dialog_configure_source_child_e_source_registry_source_added, _data_->self, 0);
	_data_->_tmp61_ = _data_->self->priv->registry;
	_data_->_tmp62_ = _data_->collection_source;
	_data_->_tmp63_ = e_source_get_uid (_data_->_tmp62_);
	_data_->_tmp64_ = _data_->_tmp63_;
	_data_->_tmp65_ = _data_->self->priv->cancellable;
	_data_->_state_ = 4;
	e_source_registry_refresh_backend (_data_->_tmp61_, _data_->_tmp64_, _data_->_tmp65_, online_accounts_caldav_dialog_save_configuration_ready, _data_);
	return FALSE;
	_state_4:
	e_source_registry_refresh_backend_finish (_data_->_tmp61_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->collection_source);
		(_data_->new_sources == NULL) ? NULL : (_data_->new_sources = (_g_list_free__g_object_unref0_ (_data_->new_sources), NULL));
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 5;
	online_accounts_caldav_dialog_await_source_children_configuration (_data_->self, online_accounts_caldav_dialog_save_configuration_ready, _data_);
	return FALSE;
	_state_5:
	online_accounts_caldav_dialog_await_source_children_configuration_finish (_data_->self, _data_->_res_);
	_data_->_tmp66_ = _data_->self->priv->registry;
	g_signal_parse_name ("source-added", e_source_registry_get_type (), &_data_->_tmp67_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_data_->_tmp66_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _data_->_tmp67_, 0, NULL, (GCallback) _online_accounts_caldav_dialog_configure_source_child_e_source_registry_source_added, _data_->self);
	_data_->_tmp68_ = _data_->self->priv->source;
	if (_data_->_tmp68_ != NULL) {
		_data_->_tmp69_ = _data_->self->priv->source;
		_data_->_tmp70_ = _data_->self->priv->cancellable;
		_data_->_state_ = 6;
		e_source_remove (_data_->_tmp69_, _data_->_tmp70_, online_accounts_caldav_dialog_save_configuration_ready, _data_);
		return FALSE;
		_state_6:
		e_source_remove_finish (_data_->_tmp69_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->collection_source);
			(_data_->new_sources == NULL) ? NULL : (_data_->new_sources = (_g_list_free__g_object_unref0_ (_data_->new_sources), NULL));
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->collection_source);
	(_data_->new_sources == NULL) ? NULL : (_data_->new_sources = (_g_list_free__g_object_unref0_ (_data_->new_sources), NULL));
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
online_accounts_caldav_dialog_configure_source_child (OnlineAccountsCaldavDialog* self,
                                                      ESource* source)
{
	ESourceRegistry* _tmp0_;
	ESource* collection_source = NULL;
	ESourceRegistry* _tmp1_;
	ESource* _tmp2_;
	ESource* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->registry;
	g_assert_nonnull (_tmp0_);
	_tmp1_ = self->priv->registry;
	_tmp2_ = e_source_registry_find_extension (_tmp1_, source, E_SOURCE_EXTENSION_COLLECTION);
	collection_source = _tmp2_;
	_tmp3_ = collection_source;
	if (_tmp3_ != NULL) {
		ESource* _tmp4_;
		ESource* _tmp12_;
		_tmp4_ = collection_source;
		if (e_source_has_extension (_tmp4_, E_SOURCE_EXTENSION_OFFLINE)) {
			ESourceOffline* collection_offline_extension = NULL;
			ESource* _tmp5_;
			ESourceExtension* _tmp6_;
			ESourceOffline* source_offline_extension = NULL;
			ESourceExtension* _tmp7_;
			ESourceOffline* _tmp8_;
			ESourceOffline* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp5_ = collection_source;
			_tmp6_ = e_source_get_extension (_tmp5_, E_SOURCE_EXTENSION_OFFLINE);
			collection_offline_extension = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, e_source_offline_get_type (), ESourceOffline);
			_tmp7_ = e_source_get_extension (source, E_SOURCE_EXTENSION_OFFLINE);
			source_offline_extension = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, e_source_offline_get_type (), ESourceOffline);
			_tmp8_ = source_offline_extension;
			_tmp9_ = collection_offline_extension;
			_tmp10_ = e_source_offline_get_stay_synchronized (_tmp9_);
			_tmp11_ = _tmp10_;
			e_source_offline_set_stay_synchronized (_tmp8_, _tmp11_);
		}
		_tmp12_ = collection_source;
		if (e_source_has_extension (_tmp12_, E_SOURCE_EXTENSION_REFRESH)) {
			ESourceRefresh* collection_refresh_extension = NULL;
			ESource* _tmp13_;
			ESourceExtension* _tmp14_;
			ESourceRefresh* source_refresh_extension = NULL;
			ESourceExtension* _tmp15_;
			ESourceRefresh* _tmp16_;
			ESourceRefresh* _tmp17_;
			gboolean _tmp18_;
			gboolean _tmp19_;
			ESourceRefresh* _tmp20_;
			ESourceRefresh* _tmp21_;
			guint _tmp22_;
			guint _tmp23_;
			_tmp13_ = collection_source;
			_tmp14_ = e_source_get_extension (_tmp13_, E_SOURCE_EXTENSION_REFRESH);
			collection_refresh_extension = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, e_source_refresh_get_type (), ESourceRefresh);
			_tmp15_ = e_source_get_extension (source, E_SOURCE_EXTENSION_REFRESH);
			source_refresh_extension = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, e_source_refresh_get_type (), ESourceRefresh);
			_tmp16_ = source_refresh_extension;
			_tmp17_ = collection_refresh_extension;
			_tmp18_ = e_source_refresh_get_enabled (_tmp17_);
			_tmp19_ = _tmp18_;
			e_source_refresh_set_enabled (_tmp16_, _tmp19_);
			_tmp20_ = source_refresh_extension;
			_tmp21_ = collection_refresh_extension;
			_tmp22_ = e_source_refresh_get_interval_minutes (_tmp21_);
			_tmp23_ = _tmp22_;
			e_source_refresh_set_interval_minutes (_tmp20_, _tmp23_);
		}
		{
			ESourceRegistry* _tmp24_;
			GCancellable* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			_tmp24_ = self->priv->registry;
			_tmp25_ = self->priv->cancellable;
			e_source_registry_commit_source_sync (_tmp24_, source, _tmp25_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp26_ = e_source_get_display_name (source);
			_tmp27_ = _tmp26_;
			g_debug ("CaldavDialog.vala:576: Configured child source '%s'", _tmp27_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			GError* _tmp30_;
			const gchar* _tmp31_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp28_ = e_source_get_display_name (source);
			_tmp29_ = _tmp28_;
			_tmp30_ = e;
			_tmp31_ = _tmp30_->message;
			g_warning ("CaldavDialog.vala:579: Configure child source '%s' failed: %s", _tmp29_, _tmp31_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (collection_source);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	self->priv->source_children_configuration_count = self->priv->source_children_configuration_count + 1;
	_g_object_unref0 (collection_source);
}

static void
online_accounts_caldav_dialog_await_source_children_configuration_data_free (gpointer _data)
{
	OnlineAccountsCaldavDialogAwaitSourceChildrenConfigurationData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (OnlineAccountsCaldavDialogAwaitSourceChildrenConfigurationData, _data_);
}

static void
online_accounts_caldav_dialog_await_source_children_configuration (OnlineAccountsCaldavDialog* self,
                                                                   GAsyncReadyCallback _callback_,
                                                                   gpointer _user_data_)
{
	OnlineAccountsCaldavDialogAwaitSourceChildrenConfigurationData* _data_;
	OnlineAccountsCaldavDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (OnlineAccountsCaldavDialogAwaitSourceChildrenConfigurationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, online_accounts_caldav_dialog_await_source_children_configuration_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	online_accounts_caldav_dialog_await_source_children_configuration_co (_data_);
}

static void
online_accounts_caldav_dialog_await_source_children_configuration_finish (OnlineAccountsCaldavDialog* self,
                                                                          GAsyncResult* _res_)
{
	OnlineAccountsCaldavDialogAwaitSourceChildrenConfigurationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		OnlineAccountsCaldavDialog* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gboolean
__lambda7_ (Block4Data* _data4_)
{
	OnlineAccountsCaldavDialog* self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = _data4_->self;
	_data4_->await_seconds += 1;
	if (_data4_->await_seconds > _data4_->timeout_seconds) {
		_tmp0_ = TRUE;
	} else {
		GListStore* _tmp1_;
		_tmp1_ = self->priv->calendars_store;
		_tmp0_ = self->priv->source_children_configuration_count >= g_list_model_get_n_items ((GListModel*) _tmp1_);
	}
	if (_tmp0_) {
		if (self->priv->source_children_configuration_timeout_id > ((guint) 0)) {
			g_source_remove (self->priv->source_children_configuration_timeout_id);
		}
		if (_data4_->await_seconds > _data4_->timeout_seconds) {
			g_warning ("CaldavDialog.vala:602: Timeout while waiting for the source children t" \
"o be configured.");
		}
		online_accounts_caldav_dialog_await_source_children_configuration_co (_data4_->_async_data_);
		result = G_SOURCE_REMOVE;
		return result;
	}
	result = G_SOURCE_CONTINUE;
	return result;
}

static gboolean
___lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda7_ (self);
	return result;
}

static gboolean
online_accounts_caldav_dialog_await_source_children_configuration_co (OnlineAccountsCaldavDialogAwaitSourceChildrenConfigurationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data4_ = g_slice_new0 (Block4Data);
	_data_->_data4_->_ref_count_ = 1;
	_data_->_data4_->self = g_object_ref (_data_->self);
	_data_->_data4_->_async_data_ = _data_;
	_data_->_data4_->timeout_seconds = 15;
	_data_->_data4_->await_seconds = 0;
	_data_->self->priv->source_children_configuration_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda7__gsource_func, block4_data_ref (_data_->_data4_), block4_data_unref);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block4_data_unref (_data_->_data4_);
	_data_->_data4_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

OnlineAccountsCaldavDialog*
online_accounts_caldav_dialog_construct (GType object_type)
{
	OnlineAccountsCaldavDialog * self = NULL;
	self = (OnlineAccountsCaldavDialog*) online_accounts_paged_dialog_construct (object_type);
	return self;
}

OnlineAccountsCaldavDialog*
online_accounts_caldav_dialog_new (void)
{
	return online_accounts_caldav_dialog_construct (ONLINE_ACCOUNTS_TYPE_CALDAV_DIALOG);
}

static inline gpointer
online_accounts_caldav_dialog_source_row_get_instance_private (OnlineAccountsCaldavDialogSourceRow* self)
{
	return G_STRUCT_MEMBER_P (self, OnlineAccountsCaldavDialogSourceRow_private_offset);
}

static OnlineAccountsCaldavDialogSourceRow*
online_accounts_caldav_dialog_source_row_construct (GType object_type,
                                                    ESource* source)
{
	OnlineAccountsCaldavDialogSourceRow * self = NULL;
	g_return_val_if_fail (source != NULL, NULL);
	self = (OnlineAccountsCaldavDialogSourceRow*) g_object_new (object_type, "source", source, NULL);
	return self;
}

static OnlineAccountsCaldavDialogSourceRow*
online_accounts_caldav_dialog_source_row_new (ESource* source)
{
	return online_accounts_caldav_dialog_source_row_construct (ONLINE_ACCOUNTS_CALDAV_DIALOG_TYPE_SOURCE_ROW, source);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
online_accounts_caldav_dialog_source_row_style_calendar_color (OnlineAccountsCaldavDialogSourceRow* self,
                                                               GtkWidget* widget,
                                                               const gchar* color)
{
	gchar* css_color = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkCssProvider* style_provider = NULL;
	GtkCssProvider* _tmp4_;
	GtkStyleContext* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = string_slice (color, (glong) 0, (glong) 7);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("@define-color accent_color %s;", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	css_color = _tmp3_;
	_tmp4_ = gtk_css_provider_new ();
	style_provider = _tmp4_;
	gtk_css_provider_load_from_data (style_provider, (const char*) ((guint8*) css_color), (gssize) -1);
	_tmp5_ = gtk_widget_get_style_context (widget);
	gtk_style_context_add_provider (_tmp5_, (GtkStyleProvider*) style_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (style_provider);
	_g_free0 (css_color);
}

static ESource*
online_accounts_caldav_dialog_source_row_get_source (OnlineAccountsCaldavDialogSourceRow* self)
{
	ESource* result;
	ESource* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source;
	result = _tmp0_;
	return result;
}

static void
online_accounts_caldav_dialog_source_row_set_source (OnlineAccountsCaldavDialogSourceRow* self,
                                                     ESource* value)
{
	ESource* old_value;
	g_return_if_fail (self != NULL);
	old_value = online_accounts_caldav_dialog_source_row_get_source (self);
	if (old_value != value) {
		ESource* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_source);
		self->priv->_source = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, online_accounts_caldav_dialog_source_row_properties[ONLINE_ACCOUNTS_CALDAV_DIALOG_SOURCE_ROW_SOURCE_PROPERTY]);
	}
}

static GObject *
online_accounts_caldav_dialog_source_row_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	OnlineAccountsCaldavDialogSourceRow * self;
	GtkLabel* name_entry = NULL;
	ESource* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkBox* box = NULL;
	GtkBox* _tmp5_ = NULL;
	GtkBox* _tmp6_;
	GtkLabel* _tmp7_;
	GtkBox* _tmp8_;
	ESourceWebdav* webdav_source = NULL;
	ESource* _tmp9_;
	ESourceExtension* _tmp10_;
	GtkLabel* _tmp11_;
	ESourceWebdav* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	parent_class = G_OBJECT_CLASS (online_accounts_caldav_dialog_source_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ONLINE_ACCOUNTS_CALDAV_DIALOG_TYPE_SOURCE_ROW, OnlineAccountsCaldavDialogSourceRow);
	_tmp0_ = self->priv->_source;
	_tmp1_ = e_source_get_display_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	name_entry = _tmp3_;
	_tmp4_ = name_entry;
	gtk_widget_add_css_class ((GtkWidget*) _tmp4_, GRANITE_STYLE_CLASS_ACCENT);
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp5_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp5_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp5_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp5_, 6);
	g_object_ref_sink (_tmp5_);
	box = _tmp5_;
	_tmp6_ = box;
	_tmp7_ = name_entry;
	gtk_box_append (_tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = box;
	gtk_list_box_row_set_child ((GtkListBoxRow*) self, (GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->_source;
	_tmp10_ = e_source_get_extension (_tmp9_, E_SOURCE_EXTENSION_WEBDAV_BACKEND);
	webdav_source = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, e_source_webdav_get_type (), ESourceWebdav);
	_tmp11_ = name_entry;
	_tmp12_ = webdav_source;
	_tmp13_ = e_source_webdav_get_color (_tmp12_);
	_tmp14_ = _tmp13_;
	online_accounts_caldav_dialog_source_row_style_calendar_color (self, (GtkWidget*) _tmp11_, _tmp14_);
	_g_object_unref0 (box);
	_g_object_unref0 (name_entry);
	return obj;
}

static void
online_accounts_caldav_dialog_source_row_class_init (OnlineAccountsCaldavDialogSourceRowClass * klass,
                                                     gpointer klass_data)
{
	online_accounts_caldav_dialog_source_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &OnlineAccountsCaldavDialogSourceRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_online_accounts_caldav_dialog_source_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_online_accounts_caldav_dialog_source_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = online_accounts_caldav_dialog_source_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = online_accounts_caldav_dialog_source_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ONLINE_ACCOUNTS_CALDAV_DIALOG_SOURCE_ROW_SOURCE_PROPERTY, online_accounts_caldav_dialog_source_row_properties[ONLINE_ACCOUNTS_CALDAV_DIALOG_SOURCE_ROW_SOURCE_PROPERTY] = g_param_spec_object ("source", "source", "source", e_source_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
online_accounts_caldav_dialog_source_row_instance_init (OnlineAccountsCaldavDialogSourceRow * self,
                                                        gpointer klass)
{
	self->priv = online_accounts_caldav_dialog_source_row_get_instance_private (self);
}

static void
online_accounts_caldav_dialog_source_row_finalize (GObject * obj)
{
	OnlineAccountsCaldavDialogSourceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ONLINE_ACCOUNTS_CALDAV_DIALOG_TYPE_SOURCE_ROW, OnlineAccountsCaldavDialogSourceRow);
	_g_object_unref0 (self->priv->_source);
	G_OBJECT_CLASS (online_accounts_caldav_dialog_source_row_parent_class)->finalize (obj);
}

static GType
online_accounts_caldav_dialog_source_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (OnlineAccountsCaldavDialogSourceRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) online_accounts_caldav_dialog_source_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OnlineAccountsCaldavDialogSourceRow), 0, (GInstanceInitFunc) online_accounts_caldav_dialog_source_row_instance_init, NULL };
	GType online_accounts_caldav_dialog_source_row_type_id;
	online_accounts_caldav_dialog_source_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "OnlineAccountsCaldavDialogSourceRow", &g_define_type_info, 0);
	OnlineAccountsCaldavDialogSourceRow_private_offset = g_type_add_instance_private (online_accounts_caldav_dialog_source_row_type_id, sizeof (OnlineAccountsCaldavDialogSourceRowPrivate));
	return online_accounts_caldav_dialog_source_row_type_id;
}

static GType
online_accounts_caldav_dialog_source_row_get_type (void)
{
	static volatile gsize online_accounts_caldav_dialog_source_row_type_id__once = 0;
	if (g_once_init_enter (&online_accounts_caldav_dialog_source_row_type_id__once)) {
		GType online_accounts_caldav_dialog_source_row_type_id;
		online_accounts_caldav_dialog_source_row_type_id = online_accounts_caldav_dialog_source_row_get_type_once ();
		g_once_init_leave (&online_accounts_caldav_dialog_source_row_type_id__once, online_accounts_caldav_dialog_source_row_type_id);
	}
	return online_accounts_caldav_dialog_source_row_type_id__once;
}

static void
_vala_online_accounts_caldav_dialog_source_row_get_property (GObject * object,
                                                             guint property_id,
                                                             GValue * value,
                                                             GParamSpec * pspec)
{
	OnlineAccountsCaldavDialogSourceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ONLINE_ACCOUNTS_CALDAV_DIALOG_TYPE_SOURCE_ROW, OnlineAccountsCaldavDialogSourceRow);
	switch (property_id) {
		case ONLINE_ACCOUNTS_CALDAV_DIALOG_SOURCE_ROW_SOURCE_PROPERTY:
		g_value_set_object (value, online_accounts_caldav_dialog_source_row_get_source (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_online_accounts_caldav_dialog_source_row_set_property (GObject * object,
                                                             guint property_id,
                                                             const GValue * value,
                                                             GParamSpec * pspec)
{
	OnlineAccountsCaldavDialogSourceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ONLINE_ACCOUNTS_CALDAV_DIALOG_TYPE_SOURCE_ROW, OnlineAccountsCaldavDialogSourceRow);
	switch (property_id) {
		case ONLINE_ACCOUNTS_CALDAV_DIALOG_SOURCE_ROW_SOURCE_PROPERTY:
		online_accounts_caldav_dialog_source_row_set_source (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_online_accounts_caldav_dialog_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                            GtkListBoxRow* before,
                                                                            gpointer self)
{
	online_accounts_caldav_dialog_header_func ((OnlineAccountsCaldavDialog*) self, row, before);
}

static gint
_online_accounts_caldav_dialog_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                 GtkListBoxRow* row2,
                                                                 gpointer self)
{
	gint result;
	result = online_accounts_caldav_dialog_sort_func ((OnlineAccountsCaldavDialog*) self, row1, row2);
	return result;
}

static GtkWidget*
_online_accounts_caldav_dialog_create_item_gtk_list_box_create_widget_func (GObject* item,
                                                                            gpointer self)
{
	GtkWidget* result;
	result = online_accounts_caldav_dialog_create_item (item, (OnlineAccountsCaldavDialog*) self);
	return result;
}

static void
_online_accounts_caldav_dialog___lambda8_ (OnlineAccountsCaldavDialog* self)
{
	GtkButton* _tmp0_;
	_tmp0_ = self->priv->save_configuration_button;
	gtk_window_set_default_widget ((GtkWindow*) self, (GtkWidget*) _tmp0_);
}

static void
__online_accounts_caldav_dialog___lambda8__adw_navigation_page_shown (AdwNavigationPage* _sender,
                                                                      gpointer self)
{
	_online_accounts_caldav_dialog___lambda8_ ((OnlineAccountsCaldavDialog*) self);
}

static void
_online_accounts_caldav_dialog___lambda9_ (OnlineAccountsCaldavDialog* self)
{
	GtkButton* _tmp0_;
	_tmp0_ = self->priv->login_button;
	gtk_window_set_default_widget ((GtkWindow*) self, (GtkWidget*) _tmp0_);
}

static void
__online_accounts_caldav_dialog___lambda9__adw_navigation_page_shown (AdwNavigationPage* _sender,
                                                                      gpointer self)
{
	_online_accounts_caldav_dialog___lambda9_ ((OnlineAccountsCaldavDialog*) self);
}

static void
_online_accounts_caldav_dialog___lambda10_ (OnlineAccountsCaldavDialog* self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static void
__online_accounts_caldav_dialog___lambda10__gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self)
{
	_online_accounts_caldav_dialog___lambda10_ ((OnlineAccountsCaldavDialog*) self);
}

static void
_online_accounts_caldav_dialog___lambda11_ (OnlineAccountsCaldavDialog* self)
{
	AdwNavigationPage* _tmp0_;
	online_accounts_caldav_dialog_find_sources (self, NULL, NULL);
	_tmp0_ = self->priv->calendars_page;
	online_accounts_paged_dialog_push_page ((OnlineAccountsPagedDialog*) self, _tmp0_);
}

static void
__online_accounts_caldav_dialog___lambda11__gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self)
{
	_online_accounts_caldav_dialog___lambda11_ ((OnlineAccountsCaldavDialog*) self);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		OnlineAccountsCaldavDialog* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->finalize_page);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda16_ (Block5Data* _data5_,
             GObject* obj,
             GAsyncResult* res)
{
	OnlineAccountsCaldavDialog* self;
	GError* _inner_error0_ = NULL;
	self = _data5_->self;
	g_return_if_fail (res != NULL);
	{
		OnlineAccountsFinalizePage* _tmp0_;
		online_accounts_caldav_dialog_save_configuration_finish (self, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp0_ = _data5_->finalize_page;
		online_accounts_finalize_page_show_success (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		OnlineAccountsFinalizePage* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _data5_->finalize_page;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		online_accounts_finalize_page_show_error (_tmp1_, _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda16__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda16_ (self, source_object, res);
	block5_data_unref (self);
}

static void
_online_accounts_caldav_dialog___lambda12_ (OnlineAccountsCaldavDialog* self)
{
	Block5Data* _data5_;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	GCancellable* _tmp2_;
	OnlineAccountsFinalizePage* _tmp3_;
	OnlineAccountsFinalizePage* _tmp4_;
	OnlineAccountsFinalizePage* _tmp5_;
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("x-office-calendar");
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->cancellable;
	_tmp3_ = online_accounts_finalize_page_new ((GIcon*) _tmp1_, _tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	_data5_->finalize_page = _tmp4_;
	_tmp5_ = _data5_->finalize_page;
	online_accounts_paged_dialog_push_page ((OnlineAccountsPagedDialog*) self, (AdwNavigationPage*) _tmp5_);
	online_accounts_caldav_dialog_save_configuration (self, ___lambda16__gasync_ready_callback, block5_data_ref (_data5_));
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
__online_accounts_caldav_dialog___lambda12__gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self)
{
	_online_accounts_caldav_dialog___lambda12_ ((OnlineAccountsCaldavDialog*) self);
}

static void
_online_accounts_caldav_dialog___lambda17_ (OnlineAccountsCaldavDialog* self)
{
	GCancellable* _tmp0_;
	_tmp0_ = self->priv->cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
	}
	online_accounts_paged_dialog_pop_page ((OnlineAccountsPagedDialog*) self);
}

static void
__online_accounts_caldav_dialog___lambda17__gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self)
{
	_online_accounts_caldav_dialog___lambda17_ ((OnlineAccountsCaldavDialog*) self);
}

static void
_online_accounts_caldav_dialog___lambda18_ (OnlineAccountsCaldavDialog* self)
{
	gboolean _tmp0_ = FALSE;
	GraniteValidatedEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	_tmp1_ = self->priv->url_entry;
	_tmp2_ = gtk_editable_get_text ((GtkEditable*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		GraniteValidatedEntry* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = self->priv->url_entry;
		_tmp5_ = gtk_editable_get_text ((GtkEditable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = g_strcmp0 (_tmp6_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean is_valid_url = FALSE;
		GraniteValidatedEntry* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		GraniteValidatedEntry* _tmp10_;
		ValidationMessage* _tmp11_;
		_tmp7_ = self->priv->url_entry;
		_tmp8_ = gtk_editable_get_text ((GtkEditable*) _tmp7_);
		_tmp9_ = _tmp8_;
		is_valid_url = online_accounts_caldav_dialog_is_valid_url (self, _tmp9_);
		_tmp10_ = self->priv->url_entry;
		granite_validated_entry_set_is_valid (_tmp10_, is_valid_url);
		_tmp11_ = self->priv->url_message_revealer;
		validation_message_set_reveal_child (_tmp11_, !is_valid_url);
	} else {
		GraniteValidatedEntry* _tmp12_;
		ValidationMessage* _tmp13_;
		_tmp12_ = self->priv->url_entry;
		granite_validated_entry_set_is_valid (_tmp12_, FALSE);
		_tmp13_ = self->priv->url_message_revealer;
		validation_message_set_reveal_child (_tmp13_, FALSE);
	}
	online_accounts_caldav_dialog_validate_form (self);
}

static void
__online_accounts_caldav_dialog___lambda18__gtk_editable_changed (GtkEditable* _sender,
                                                                  gpointer self)
{
	_online_accounts_caldav_dialog___lambda18_ ((OnlineAccountsCaldavDialog*) self);
}

static void
_online_accounts_caldav_dialog___lambda19_ (OnlineAccountsCaldavDialog* self)
{
	gboolean _tmp0_ = FALSE;
	GraniteValidatedEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GraniteValidatedEntry* _tmp7_;
	GtkEntry* _tmp8_;
	GraniteValidatedEntry* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	_tmp1_ = self->priv->username_entry;
	_tmp2_ = gtk_editable_get_text ((GtkEditable*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		GraniteValidatedEntry* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = self->priv->username_entry;
		_tmp5_ = gtk_editable_get_text ((GtkEditable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = g_strcmp0 (_tmp6_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = self->priv->username_entry;
	granite_validated_entry_set_is_valid (_tmp7_, _tmp0_);
	_tmp8_ = self->priv->display_name_entry;
	_tmp9_ = self->priv->username_entry;
	_tmp10_ = gtk_editable_get_text ((GtkEditable*) _tmp9_);
	_tmp11_ = _tmp10_;
	gtk_editable_set_text ((GtkEditable*) _tmp8_, _tmp11_);
	online_accounts_caldav_dialog_validate_form (self);
}

static void
__online_accounts_caldav_dialog___lambda19__gtk_editable_changed (GtkEditable* _sender,
                                                                  gpointer self)
{
	_online_accounts_caldav_dialog___lambda19_ ((OnlineAccountsCaldavDialog*) self);
}

static void
_online_accounts_caldav_dialog___lambda20_ (OnlineAccountsCaldavDialog* self,
                                            guint keyval)
{
	GCancellable* _tmp0_;
	if (keyval != GDK_KEY_Escape) {
		return;
	}
	_tmp0_ = self->priv->cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
	}
	gtk_window_destroy ((GtkWindow*) self);
}

static void
__online_accounts_caldav_dialog___lambda20__gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                                   guint keyval,
                                                                                   guint keycode,
                                                                                   GdkModifierType state,
                                                                                   gpointer self)
{
	_online_accounts_caldav_dialog___lambda20_ ((OnlineAccountsCaldavDialog*) self, keyval);
}

static GObject *
online_accounts_caldav_dialog_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	OnlineAccountsCaldavDialog * self;
	GraniteValidatedEntry* _tmp0_ = NULL;
	GraniteValidatedEntry* _tmp1_;
	GraniteHeaderLabel* url_label = NULL;
	GraniteValidatedEntry* _tmp2_;
	GtkWidget* _tmp3_;
	GraniteHeaderLabel* _tmp4_ = NULL;
	ValidationMessage* _tmp5_;
	ValidationMessage* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GraniteValidatedEntry* _tmp9_;
	GraniteValidatedEntry* _tmp10_;
	GraniteHeaderLabel* username_label = NULL;
	GraniteValidatedEntry* _tmp11_;
	GtkWidget* _tmp12_;
	GraniteHeaderLabel* _tmp13_ = NULL;
	GtkEntry* _tmp14_ = NULL;
	GraniteHeaderLabel* password_label = NULL;
	GtkEntry* _tmp15_;
	GtkWidget* _tmp16_;
	GraniteHeaderLabel* _tmp17_ = NULL;
	GtkButton* login_cancel_button = NULL;
	GtkButton* _tmp18_;
	GtkButton* _tmp19_ = NULL;
	GtkButton* _tmp20_;
	GtkBox* action_area = NULL;
	GtkBox* _tmp21_ = NULL;
	GtkBox* _tmp22_;
	GtkBox* _tmp23_;
	GtkButton* _tmp24_;
	GtkBox* _tmp25_;
	GtkButton* _tmp26_;
	GtkBox* login_box = NULL;
	GtkBox* _tmp27_;
	GtkBox* _tmp28_;
	GraniteHeaderLabel* _tmp29_;
	GtkBox* _tmp30_;
	GraniteValidatedEntry* _tmp31_;
	GtkBox* _tmp32_;
	ValidationMessage* _tmp33_;
	GtkBox* _tmp34_;
	GraniteHeaderLabel* _tmp35_;
	GtkBox* _tmp36_;
	GraniteValidatedEntry* _tmp37_;
	GtkBox* _tmp38_;
	GraniteHeaderLabel* _tmp39_;
	GtkBox* _tmp40_;
	GtkEntry* _tmp41_;
	GtkBox* _tmp42_;
	GtkBox* _tmp43_;
	AdwNavigationPage* login_page = NULL;
	GtkBox* _tmp44_;
	AdwNavigationPage* _tmp45_;
	GtkEntry* _tmp46_ = NULL;
	GraniteHeaderLabel* display_name_label = NULL;
	GtkEntry* _tmp47_;
	GtkWidget* _tmp48_;
	gchar* _tmp49_;
	GraniteHeaderLabel* _tmp50_ = NULL;
	GListStore* _tmp51_;
	GtkListBox* _tmp52_ = NULL;
	GtkListBox* _tmp53_;
	GtkListBox* _tmp54_;
	GtkListBox* _tmp55_;
	GListStore* _tmp56_;
	GtkScrolledWindow* calendars_scroll_window = NULL;
	GtkListBox* _tmp57_;
	GtkWidget* _tmp58_;
	GtkScrolledWindow* _tmp59_ = NULL;
	GtkFrame* calendar_list_frame = NULL;
	GtkScrolledWindow* _tmp60_;
	GtkWidget* _tmp61_;
	GtkFrame* _tmp62_ = NULL;
	GtkButton* calendar_page_back_button = NULL;
	GtkButton* _tmp63_;
	GtkButton* _tmp64_;
	GtkButton* _tmp65_;
	GtkBox* calendar_page_action_area = NULL;
	GtkBox* _tmp66_ = NULL;
	GtkBox* _tmp67_;
	GtkBox* _tmp68_;
	GtkButton* _tmp69_;
	GtkBox* _tmp70_;
	GtkButton* _tmp71_;
	GtkBox* calendars_box = NULL;
	GtkBox* _tmp72_;
	GtkBox* _tmp73_;
	GraniteHeaderLabel* _tmp74_;
	GtkBox* _tmp75_;
	GtkEntry* _tmp76_;
	GtkBox* _tmp77_;
	GtkFrame* _tmp78_;
	GtkBox* _tmp79_;
	GtkBox* _tmp80_;
	GtkBox* _tmp81_;
	AdwNavigationPage* _tmp82_;
	AdwNavigationPage* _tmp83_;
	GtkButton* _tmp84_;
	AdwNavigationPage* _tmp85_;
	AdwNavigationPage* _tmp86_;
	GtkButton* _tmp87_;
	GtkButton* _tmp88_;
	GtkButton* _tmp89_;
	GtkButton* _tmp90_;
	GraniteValidatedEntry* _tmp91_;
	GraniteValidatedEntry* _tmp92_;
	GtkEventControllerKey* key_controller = NULL;
	GtkEventControllerKey* _tmp93_;
	GtkEventControllerKey* _tmp94_;
	GtkEventController* _tmp95_;
	GtkEventControllerKey* _tmp96_;
	parent_class = G_OBJECT_CLASS (online_accounts_caldav_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ONLINE_ACCOUNTS_TYPE_CALDAV_DIALOG, OnlineAccountsCaldavDialog);
	_tmp0_ = granite_validated_entry_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp0_, TRUE);
	gtk_entry_set_input_purpose ((GtkEntry*) _tmp0_, GTK_INPUT_PURPOSE_URL);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->url_entry);
	self->priv->url_entry = _tmp0_;
	_tmp1_ = self->priv->url_entry;
	gtk_accessible_update_property ((GtkAccessible*) _tmp1_, GTK_ACCESSIBLE_PROPERTY_REQUIRED, TRUE, -1, -1);
	_tmp2_ = self->priv->url_entry;
	_tmp3_ = _g_object_ref0 ((GtkWidget*) _tmp2_);
	_tmp4_ = granite_header_label_new (_ ("Server URL"));
	granite_header_label_set_mnemonic_widget (_tmp4_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	g_object_ref_sink (_tmp4_);
	url_label = _tmp4_;
	_tmp5_ = validation_message_new (_ ("Invalid URL"));
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->url_message_revealer);
	self->priv->url_message_revealer = _tmp5_;
	_tmp6_ = self->priv->url_message_revealer;
	_tmp7_ = validation_message_get_label_widget (_tmp6_);
	_tmp8_ = _tmp7_;
	gtk_widget_add_css_class ((GtkWidget*) _tmp8_, GRANITE_STYLE_CLASS_ERROR);
	_tmp9_ = granite_validated_entry_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->username_entry);
	self->priv->username_entry = _tmp9_;
	_tmp10_ = self->priv->username_entry;
	gtk_accessible_update_property ((GtkAccessible*) _tmp10_, GTK_ACCESSIBLE_PROPERTY_REQUIRED, TRUE, -1, -1);
	_tmp11_ = self->priv->username_entry;
	_tmp12_ = _g_object_ref0 ((GtkWidget*) _tmp11_);
	_tmp13_ = granite_header_label_new (_ ("User Name"));
	granite_header_label_set_mnemonic_widget (_tmp13_, _tmp12_);
	_g_object_unref0 (_tmp12_);
	g_object_ref_sink (_tmp13_);
	username_label = _tmp13_;
	_tmp14_ = (GtkEntry*) gtk_entry_new ();
	gtk_entry_set_activates_default (_tmp14_, TRUE);
	gtk_entry_set_input_purpose (_tmp14_, GTK_INPUT_PURPOSE_PASSWORD);
	gtk_entry_set_visibility (_tmp14_, FALSE);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->password_entry);
	self->priv->password_entry = _tmp14_;
	_tmp15_ = self->priv->password_entry;
	_tmp16_ = _g_object_ref0 ((GtkWidget*) _tmp15_);
	_tmp17_ = granite_header_label_new (_ ("Password"));
	granite_header_label_set_mnemonic_widget (_tmp17_, _tmp16_);
	_g_object_unref0 (_tmp16_);
	g_object_ref_sink (_tmp17_);
	password_label = _tmp17_;
	_tmp18_ = (GtkButton*) gtk_button_new_with_label (_ ("Cancel"));
	g_object_ref_sink (_tmp18_);
	login_cancel_button = _tmp18_;
	_tmp19_ = (GtkButton*) gtk_button_new_with_label (_ ("Log In"));
	gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, FALSE);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->login_button);
	self->priv->login_button = _tmp19_;
	_tmp20_ = self->priv->login_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp20_, GRANITE_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp21_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp21_, 24);
	gtk_widget_set_halign ((GtkWidget*) _tmp21_, GTK_ALIGN_END);
	gtk_widget_set_valign ((GtkWidget*) _tmp21_, GTK_ALIGN_END);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp21_, TRUE);
	gtk_box_set_homogeneous (_tmp21_, TRUE);
	g_object_ref_sink (_tmp21_);
	action_area = _tmp21_;
	_tmp22_ = action_area;
	gtk_widget_add_css_class ((GtkWidget*) _tmp22_, "action-area");
	_tmp23_ = action_area;
	_tmp24_ = login_cancel_button;
	gtk_box_append (_tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = action_area;
	_tmp26_ = self->priv->login_button;
	gtk_box_append (_tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp27_);
	login_box = _tmp27_;
	_tmp28_ = login_box;
	_tmp29_ = url_label;
	gtk_box_append (_tmp28_, (GtkWidget*) _tmp29_);
	_tmp30_ = login_box;
	_tmp31_ = self->priv->url_entry;
	gtk_box_append (_tmp30_, (GtkWidget*) _tmp31_);
	_tmp32_ = login_box;
	_tmp33_ = self->priv->url_message_revealer;
	gtk_box_append (_tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = login_box;
	_tmp35_ = username_label;
	gtk_box_append (_tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = login_box;
	_tmp37_ = self->priv->username_entry;
	gtk_box_append (_tmp36_, (GtkWidget*) _tmp37_);
	_tmp38_ = login_box;
	_tmp39_ = password_label;
	gtk_box_append (_tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = login_box;
	_tmp41_ = self->priv->password_entry;
	gtk_box_append (_tmp40_, (GtkWidget*) _tmp41_);
	_tmp42_ = login_box;
	_tmp43_ = action_area;
	gtk_box_append (_tmp42_, (GtkWidget*) _tmp43_);
	_tmp44_ = login_box;
	_tmp45_ = adw_navigation_page_new ((GtkWidget*) _tmp44_, _ ("Log In"));
	g_object_ref_sink (_tmp45_);
	login_page = _tmp45_;
	_tmp46_ = (GtkEntry*) gtk_entry_new ();
	gtk_entry_set_activates_default (_tmp46_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp46_, TRUE);
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->priv->display_name_entry);
	self->priv->display_name_entry = _tmp46_;
	_tmp47_ = self->priv->display_name_entry;
	_tmp48_ = _g_object_ref0 ((GtkWidget*) _tmp47_);
	_tmp49_ = g_strdup (_ ("Pick a name like “Work” or “Personal” for the account."));
	_tmp50_ = granite_header_label_new (_ ("Account Display Name"));
	granite_header_label_set_mnemonic_widget (_tmp50_, _tmp48_);
	_g_object_unref0 (_tmp48_);
	granite_header_label_set_secondary_text (_tmp50_, _tmp49_);
	_g_free0 (_tmp49_);
	g_object_ref_sink (_tmp50_);
	display_name_label = _tmp50_;
	_tmp51_ = g_list_store_new (e_source_get_type ());
	_g_object_unref0 (self->priv->calendars_store);
	self->priv->calendars_store = _tmp51_;
	_tmp52_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp52_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp52_, TRUE);
	g_object_ref_sink (_tmp52_);
	_g_object_unref0 (self->priv->calendars_list);
	self->priv->calendars_list = _tmp52_;
	_tmp53_ = self->priv->calendars_list;
	gtk_list_box_set_header_func (_tmp53_, _online_accounts_caldav_dialog_header_func_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp54_ = self->priv->calendars_list;
	gtk_list_box_set_sort_func (_tmp54_, _online_accounts_caldav_dialog_sort_func_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp55_ = self->priv->calendars_list;
	_tmp56_ = self->priv->calendars_store;
	gtk_list_box_bind_model (_tmp55_, (GListModel*) _tmp56_, _online_accounts_caldav_dialog_create_item_gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
	_tmp57_ = self->priv->calendars_list;
	_tmp58_ = _g_object_ref0 ((GtkWidget*) _tmp57_);
	_tmp59_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	g_object_set (_tmp59_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	gtk_scrolled_window_set_child (_tmp59_, _tmp58_);
	_g_object_unref0 (_tmp58_);
	g_object_ref_sink (_tmp59_);
	calendars_scroll_window = _tmp59_;
	_tmp60_ = calendars_scroll_window;
	_tmp61_ = _g_object_ref0 ((GtkWidget*) _tmp60_);
	_tmp62_ = (GtkFrame*) gtk_frame_new (NULL);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp62_, 18);
	gtk_frame_set_child (_tmp62_, _tmp61_);
	_g_object_unref0 (_tmp61_);
	g_object_ref_sink (_tmp62_);
	calendar_list_frame = _tmp62_;
	_tmp63_ = (GtkButton*) gtk_button_new_with_label (_ ("Back"));
	g_object_ref_sink (_tmp63_);
	calendar_page_back_button = _tmp63_;
	_tmp64_ = (GtkButton*) gtk_button_new_with_label (_ ("Save"));
	g_object_ref_sink (_tmp64_);
	_g_object_unref0 (self->priv->save_configuration_button);
	self->priv->save_configuration_button = _tmp64_;
	_tmp65_ = self->priv->save_configuration_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp65_, GRANITE_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp66_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp66_, 24);
	gtk_widget_set_halign ((GtkWidget*) _tmp66_, GTK_ALIGN_END);
	gtk_box_set_homogeneous (_tmp66_, TRUE);
	g_object_ref_sink (_tmp66_);
	calendar_page_action_area = _tmp66_;
	_tmp67_ = calendar_page_action_area;
	gtk_widget_add_css_class ((GtkWidget*) _tmp67_, "action-area");
	_tmp68_ = calendar_page_action_area;
	_tmp69_ = calendar_page_back_button;
	gtk_box_append (_tmp68_, (GtkWidget*) _tmp69_);
	_tmp70_ = calendar_page_action_area;
	_tmp71_ = self->priv->save_configuration_button;
	gtk_box_append (_tmp70_, (GtkWidget*) _tmp71_);
	_tmp72_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp72_);
	calendars_box = _tmp72_;
	_tmp73_ = calendars_box;
	_tmp74_ = display_name_label;
	gtk_box_append (_tmp73_, (GtkWidget*) _tmp74_);
	_tmp75_ = calendars_box;
	_tmp76_ = self->priv->display_name_entry;
	gtk_box_append (_tmp75_, (GtkWidget*) _tmp76_);
	_tmp77_ = calendars_box;
	_tmp78_ = calendar_list_frame;
	gtk_box_append (_tmp77_, (GtkWidget*) _tmp78_);
	_tmp79_ = calendars_box;
	_tmp80_ = calendar_page_action_area;
	gtk_box_append (_tmp79_, (GtkWidget*) _tmp80_);
	_tmp81_ = calendars_box;
	_tmp82_ = adw_navigation_page_new ((GtkWidget*) _tmp81_, _ ("Calendars"));
	g_object_ref_sink (_tmp82_);
	_g_object_unref0 (self->priv->calendars_page);
	self->priv->calendars_page = _tmp82_;
	_tmp83_ = login_page;
	online_accounts_paged_dialog_push_page ((OnlineAccountsPagedDialog*) self, _tmp83_);
	_tmp84_ = self->priv->login_button;
	gtk_window_set_default_widget ((GtkWindow*) self, (GtkWidget*) _tmp84_);
	_tmp85_ = self->priv->calendars_page;
	g_signal_connect_object (_tmp85_, "shown", (GCallback) __online_accounts_caldav_dialog___lambda8__adw_navigation_page_shown, self, 0);
	_tmp86_ = login_page;
	g_signal_connect_object (_tmp86_, "shown", (GCallback) __online_accounts_caldav_dialog___lambda9__adw_navigation_page_shown, self, 0);
	_tmp87_ = login_cancel_button;
	g_signal_connect_object (_tmp87_, "clicked", (GCallback) __online_accounts_caldav_dialog___lambda10__gtk_button_clicked, self, 0);
	_tmp88_ = self->priv->login_button;
	g_signal_connect_object (_tmp88_, "clicked", (GCallback) __online_accounts_caldav_dialog___lambda11__gtk_button_clicked, self, 0);
	_tmp89_ = self->priv->save_configuration_button;
	g_signal_connect_object (_tmp89_, "clicked", (GCallback) __online_accounts_caldav_dialog___lambda12__gtk_button_clicked, self, 0);
	_tmp90_ = calendar_page_back_button;
	g_signal_connect_object (_tmp90_, "clicked", (GCallback) __online_accounts_caldav_dialog___lambda17__gtk_button_clicked, self, 0);
	_tmp91_ = self->priv->url_entry;
	g_signal_connect_object ((GtkEditable*) _tmp91_, "changed", (GCallback) __online_accounts_caldav_dialog___lambda18__gtk_editable_changed, self, 0);
	_tmp92_ = self->priv->username_entry;
	g_signal_connect_object ((GtkEditable*) _tmp92_, "changed", (GCallback) __online_accounts_caldav_dialog___lambda19__gtk_editable_changed, self, 0);
	_tmp93_ = (GtkEventControllerKey*) gtk_event_controller_key_new ();
	key_controller = _tmp93_;
	_tmp94_ = key_controller;
	_tmp95_ = _g_object_ref0 ((GtkEventController*) _tmp94_);
	gtk_widget_add_controller (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp95_);
	_tmp96_ = key_controller;
	g_signal_connect_object (_tmp96_, "key-released", (GCallback) __online_accounts_caldav_dialog___lambda20__gtk_event_controller_key_key_released, self, 0);
	_g_object_unref0 (key_controller);
	_g_object_unref0 (calendars_box);
	_g_object_unref0 (calendar_page_action_area);
	_g_object_unref0 (calendar_page_back_button);
	_g_object_unref0 (calendar_list_frame);
	_g_object_unref0 (calendars_scroll_window);
	_g_object_unref0 (display_name_label);
	_g_object_unref0 (login_page);
	_g_object_unref0 (login_box);
	_g_object_unref0 (action_area);
	_g_object_unref0 (login_cancel_button);
	_g_object_unref0 (password_label);
	_g_object_unref0 (username_label);
	_g_object_unref0 (url_label);
	return obj;
}

static void
online_accounts_caldav_dialog_class_init (OnlineAccountsCaldavDialogClass * klass,
                                          gpointer klass_data)
{
	online_accounts_caldav_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &OnlineAccountsCaldavDialog_private_offset);
	G_OBJECT_CLASS (klass)->constructor = online_accounts_caldav_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = online_accounts_caldav_dialog_finalize;
}

static void
online_accounts_caldav_dialog_instance_init (OnlineAccountsCaldavDialog * self,
                                             gpointer klass)
{
	self->priv = online_accounts_caldav_dialog_get_instance_private (self);
	self->priv->registry = NULL;
	self->priv->source = NULL;
	self->priv->source_children_configuration_timeout_id = (guint) 0;
	self->priv->source_children_configuration_count = (guint) 0;
}

static void
online_accounts_caldav_dialog_finalize (GObject * obj)
{
	OnlineAccountsCaldavDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ONLINE_ACCOUNTS_TYPE_CALDAV_DIALOG, OnlineAccountsCaldavDialog);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->url_entry);
	_g_object_unref0 (self->priv->username_entry);
	_g_object_unref0 (self->priv->login_button);
	_g_object_unref0 (self->priv->save_configuration_button);
	_g_object_unref0 (self->priv->display_name_entry);
	_g_object_unref0 (self->priv->password_entry);
	_g_object_unref0 (self->priv->calendars_list);
	_g_object_unref0 (self->priv->calendars_page);
	_g_object_unref0 (self->priv->calendars_store);
	_g_object_unref0 (self->priv->url_message_revealer);
	_g_object_unref0 (self->priv->registry);
	_g_object_unref0 (self->priv->source);
	G_OBJECT_CLASS (online_accounts_caldav_dialog_parent_class)->finalize (obj);
}

static GType
online_accounts_caldav_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (OnlineAccountsCaldavDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) online_accounts_caldav_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OnlineAccountsCaldavDialog), 0, (GInstanceInitFunc) online_accounts_caldav_dialog_instance_init, NULL };
	GType online_accounts_caldav_dialog_type_id;
	online_accounts_caldav_dialog_type_id = g_type_register_static (ONLINE_ACCOUNTS_TYPE_PAGED_DIALOG, "OnlineAccountsCaldavDialog", &g_define_type_info, 0);
	OnlineAccountsCaldavDialog_private_offset = g_type_add_instance_private (online_accounts_caldav_dialog_type_id, sizeof (OnlineAccountsCaldavDialogPrivate));
	return online_accounts_caldav_dialog_type_id;
}

GType
online_accounts_caldav_dialog_get_type (void)
{
	static volatile gsize online_accounts_caldav_dialog_type_id__once = 0;
	if (g_once_init_enter (&online_accounts_caldav_dialog_type_id__once)) {
		GType online_accounts_caldav_dialog_type_id;
		online_accounts_caldav_dialog_type_id = online_accounts_caldav_dialog_get_type_once ();
		g_once_init_leave (&online_accounts_caldav_dialog_type_id__once, online_accounts_caldav_dialog_type_id);
	}
	return online_accounts_caldav_dialog_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

