/* drivers-dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from drivers-dialog.vala, do not modify */

/*
 * Copyright (C) 2023 Bartłomiej Maryńczak
 * Author: Bartłomiej Maryńczak <marynczakbartlomiej@gmail.com>,
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DRIVERS_DIALOG (drivers_dialog_get_type ())
#define DRIVERS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRIVERS_DIALOG, DriversDialog))
#define DRIVERS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRIVERS_DIALOG, DriversDialogClass))
#define IS_DRIVERS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRIVERS_DIALOG))
#define IS_DRIVERS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRIVERS_DIALOG))
#define DRIVERS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRIVERS_DIALOG, DriversDialogClass))

typedef struct _DriversDialog DriversDialog;
typedef struct _DriversDialogClass DriversDialogClass;
typedef struct _DriversDialogPrivate DriversDialogPrivate;
enum  {
	DRIVERS_DIALOG_0_PROPERTY,
	DRIVERS_DIALOG_NUM_PROPERTIES
};
static GParamSpec* drivers_dialog_properties[DRIVERS_DIALOG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DriversDialogOpenData DriversDialogOpenData;

struct _DriversDialog {
	GtkWindow parent_instance;
	DriversDialogPrivate * priv;
};

struct _DriversDialogClass {
	GtkWindowClass parent_class;
};

struct _DriversDialogPrivate {
	GtkRevealer* header_revealer;
	GtkLabel* main_label;
	GtkLabel* main_sublabel;
	GtkRevealer* progress_revealer;
	GtkProgressBar* progress_bar;
	GtkLabel* result_label;
	GtkLabel* result_sublabel;
	GtkImage* result_icon;
	GtkStack* stack;
	guint pulse_timer;
	gchar* missing_driver;
};

struct _DriversDialogOpenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DriversDialog* self;
	gchar* message;
	gchar* _tmp0_;
	gchar* instructions;
	gchar* _tmp1_;
	gchar** packages_to_install;
	gchar** _tmp2_;
	gint packages_to_install_length1;
	gint _packages_to_install_size_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GtkLabel* _tmp22_;
	const gchar* _tmp23_;
	GtkLabel* _tmp24_;
	const gchar* _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	GtkLabel* _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	gchar** _tmp29_;
	gint _tmp29__length1;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
};

static gint DriversDialog_private_offset;
static gpointer drivers_dialog_parent_class = NULL;

VALA_EXTERN GType drivers_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DriversDialog, g_object_unref)
static void drivers_dialog_pulse_stop (DriversDialog* self);
VALA_EXTERN DriversDialog* drivers_dialog_new (GtkWindow* parent,
                                   const gchar* missing_driver);
VALA_EXTERN DriversDialog* drivers_dialog_construct (GType object_type,
                                         GtkWindow* parent,
                                         const gchar* missing_driver);
static void drivers_dialog_pulse_start (DriversDialog* self);
static gboolean __lambda44_ (DriversDialog* self);
static gboolean ___lambda44__gsource_func (gpointer self);
static void drivers_dialog_open_data_free (gpointer _data);
VALA_EXTERN void drivers_dialog_open (DriversDialog* self,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_);
VALA_EXTERN void drivers_dialog_open_finish (DriversDialog* self,
                                 GAsyncResult* _res_);
static gboolean drivers_dialog_open_co (DriversDialogOpenData* _data_);
static void drivers_dialog_finalize (GObject * obj);
static GType drivers_dialog_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
drivers_dialog_get_instance_private (DriversDialog* self)
{
	return G_STRUCT_MEMBER_P (self, DriversDialog_private_offset);
}

DriversDialog*
drivers_dialog_construct (GType object_type,
                          GtkWindow* parent,
                          const gchar* missing_driver)
{
	DriversDialog * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (parent != NULL, NULL);
	self = (DriversDialog*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (missing_driver);
	_g_free0 (self->priv->missing_driver);
	self->priv->missing_driver = _tmp0_;
	gtk_window_set_transient_for ((GtkWindow*) self, parent);
	return self;
}

DriversDialog*
drivers_dialog_new (GtkWindow* parent,
                    const gchar* missing_driver)
{
	return drivers_dialog_construct (TYPE_DRIVERS_DIALOG, parent, missing_driver);
}

static gboolean
__lambda44_ (DriversDialog* self)
{
	GtkProgressBar* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->progress_bar;
	gtk_progress_bar_pulse (_tmp0_);
	result = G_SOURCE_CONTINUE;
	return result;
}

static gboolean
___lambda44__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda44_ ((DriversDialog*) self);
	return result;
}

static void
drivers_dialog_pulse_start (DriversDialog* self)
{
	g_return_if_fail (self != NULL);
	drivers_dialog_pulse_stop (self);
	self->priv->pulse_timer = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda44__gsource_func, g_object_ref (self), g_object_unref);
}

static void
drivers_dialog_pulse_stop (DriversDialog* self)
{
	g_return_if_fail (self != NULL);
	g_source_remove (self->priv->pulse_timer);
}

static void
drivers_dialog_open_data_free (gpointer _data)
{
	DriversDialogOpenData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DriversDialogOpenData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
drivers_dialog_open (DriversDialog* self,
                     GAsyncReadyCallback _callback_,
                     gpointer _user_data_)
{
	DriversDialogOpenData* _data_;
	DriversDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (DriversDialogOpenData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, drivers_dialog_open_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	drivers_dialog_open_co (_data_);
}

void
drivers_dialog_open_finish (DriversDialog* self,
                            GAsyncResult* _res_)
{
	DriversDialogOpenData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static gboolean
drivers_dialog_open_co (DriversDialogOpenData* _data_)
{
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	static GQuark _tmp5_label3 = 0;
	static GQuark _tmp5_label4 = 0;
	static GQuark _tmp5_label5 = 0;
	static GQuark _tmp5_label6 = 0;
	static GQuark _tmp5_label7 = 0;
	static GQuark _tmp5_label8 = 0;
	static GQuark _tmp5_label9 = 0;
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("");
	_data_->message = _data_->_tmp0_;
	_data_->_tmp1_ = g_strdup ("");
	_data_->instructions = _data_->_tmp1_;
	_data_->_tmp2_ = g_new0 (gchar*, 0 + 1);
	_data_->packages_to_install = _data_->_tmp2_;
	_data_->packages_to_install_length1 = 0;
	_data_->_packages_to_install_size_ = _data_->packages_to_install_length1;
	_data_->_tmp3_ = _data_->self->priv->missing_driver;
	_data_->_tmp6_ = 0U;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp6_ = (NULL == _data_->_tmp4_) ? 0 : g_quark_from_string (_data_->_tmp4_);
	if ((((_data_->_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("brscan")))) || (_data_->_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("brscan2"))))) || (_data_->_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("brscan3"))))) || (_data_->_tmp6_ == ((0 != _tmp5_label3) ? _tmp5_label3 : (_tmp5_label3 = g_quark_from_static_string ("brscan4"))))) {
		switch (0) {
			default:
			{
				_data_->_tmp7_ = g_strdup (_ ("You appear to have a Brother scanner."));
				_g_free0 (_data_->message);
				_data_->message = _data_->_tmp7_;
				_data_->_tmp8_ = g_strdup (_ ("Drivers for this are available on the <a href=\"http://support.brother" \
".com\">Brother website</a>."));
				_g_free0 (_data_->instructions);
				_data_->instructions = _data_->_tmp8_;
				break;
			}
		}
	} else if (_data_->_tmp6_ == ((0 != _tmp5_label4) ? _tmp5_label4 : (_tmp5_label4 = g_quark_from_static_string ("pixma")))) {
		switch (0) {
			default:
			{
				_data_->_tmp9_ = g_strdup (_ ("You appear to have a Canon scanner, which is supported by the <a href=" \
"\"http://www.sane-project.org/man/sane-pixma.5.html\">Pixma SANE backe" \
"nd</a>."));
				_g_free0 (_data_->message);
				_data_->message = _data_->_tmp9_;
				_data_->_tmp10_ = g_strdup (_ ("Please check if your <a href=\"http://www.sane-project.org/sane-suppor" \
"ted-devices.html\">scanner is supported by SANE</a>, otherwise report " \
"the issue to the <a href=\"https://alioth-lists.debian.net/cgi-bin/mai" \
"lman/listinfo/sane-devel\">SANE mailing list</a>."));
				_g_free0 (_data_->instructions);
				_data_->instructions = _data_->_tmp10_;
				break;
			}
		}
	} else if (_data_->_tmp6_ == ((0 != _tmp5_label5) ? _tmp5_label5 : (_tmp5_label5 = g_quark_from_static_string ("samsung")))) {
		switch (0) {
			default:
			{
				_data_->_tmp11_ = g_strdup (_ ("You appear to have a Samsung scanner."));
				_g_free0 (_data_->message);
				_data_->message = _data_->_tmp11_;
				_data_->_tmp12_ = g_strdup (_ ("Drivers for this are available on the <a href=\"https://support.hp.com" \
"\">HP website</a> (HP acquired Samsung's printing business)."));
				_g_free0 (_data_->instructions);
				_data_->instructions = _data_->_tmp12_;
				break;
			}
		}
	} else if ((_data_->_tmp6_ == ((0 != _tmp5_label6) ? _tmp5_label6 : (_tmp5_label6 = g_quark_from_static_string ("hpaio")))) || (_data_->_tmp6_ == ((0 != _tmp5_label7) ? _tmp5_label7 : (_tmp5_label7 = g_quark_from_static_string ("smfp"))))) {
		switch (0) {
			default:
			{
				_data_->_tmp13_ = g_strdup (_ ("You appear to have an HP scanner."));
				_g_free0 (_data_->message);
				_data_->message = _data_->_tmp13_;
				_data_->_tmp14_ = _data_->self->priv->missing_driver;
				if (g_strcmp0 (_data_->_tmp14_, "hpaio") == 0) {
					_data_->_tmp15_ = g_strdup ("libsane-hpaio");
					_data_->_tmp16_ = g_new0 (gchar*, 1 + 1);
					_data_->_tmp16_[0] = _data_->_tmp15_;
					_data_->packages_to_install = (_vala_array_free (_data_->packages_to_install, _data_->packages_to_install_length1, (GDestroyNotify) g_free), NULL);
					_data_->packages_to_install = _data_->_tmp16_;
					_data_->packages_to_install_length1 = 1;
					_data_->_packages_to_install_size_ = _data_->packages_to_install_length1;
				} else {
					_data_->_tmp17_ = g_strdup (_ ("Drivers for this are available on the <a href=\"https://support.hp.com" \
"\">HP website</a>."));
					_g_free0 (_data_->instructions);
					_data_->instructions = _data_->_tmp17_;
				}
				break;
			}
		}
	} else if (_data_->_tmp6_ == ((0 != _tmp5_label8) ? _tmp5_label8 : (_tmp5_label8 = g_quark_from_static_string ("epkowa")))) {
		switch (0) {
			default:
			{
				_data_->_tmp18_ = g_strdup (_ ("You appear to have an Epson scanner."));
				_g_free0 (_data_->message);
				_data_->message = _data_->_tmp18_;
				_data_->_tmp19_ = g_strdup (_ ("Drivers for this are available on the <a href=\"http://support.epson.c" \
"om\">Epson website</a>."));
				_g_free0 (_data_->instructions);
				_data_->instructions = _data_->_tmp19_;
				break;
			}
		}
	} else if (_data_->_tmp6_ == ((0 != _tmp5_label9) ? _tmp5_label9 : (_tmp5_label9 = g_quark_from_static_string ("lexmark_nscan")))) {
		switch (0) {
			default:
			{
				_data_->_tmp20_ = g_strdup (_ ("You appear to have a Lexmark scanner."));
				_g_free0 (_data_->message);
				_data_->message = _data_->_tmp20_;
				_data_->_tmp21_ = g_strdup (_ ("Drivers for this are available on the <a href=\"http://support.lexmark" \
".com\">Lexmark website</a>."));
				_g_free0 (_data_->instructions);
				_data_->instructions = _data_->_tmp21_;
				break;
			}
		}
	}
	_data_->_tmp22_ = _data_->self->priv->main_label;
	_data_->_tmp23_ = _data_->message;
	gtk_label_set_label (_data_->_tmp22_, _data_->_tmp23_);
	_data_->_tmp24_ = _data_->self->priv->main_sublabel;
	_data_->_tmp25_ = _data_->instructions;
	gtk_label_set_label (_data_->_tmp24_, _data_->_tmp25_);
	_data_->_tmp26_ = _data_->packages_to_install;
	_data_->_tmp26__length1 = _data_->packages_to_install_length1;
	if (_data_->_tmp26__length1 > 0) {
		_data_->_tmp27_ = _data_->self->priv->main_sublabel;
		_data_->_tmp28_ = _data_->packages_to_install;
		_data_->_tmp28__length1 = _data_->packages_to_install_length1;
		_data_->_tmp29_ = _data_->packages_to_install;
		_data_->_tmp29__length1 = _data_->packages_to_install_length1;
		_data_->_tmp30_ = _vala_g_strjoinv (", ", _data_->_tmp29_, (gint) _data_->_tmp29__length1);
		_data_->_tmp31_ = _data_->_tmp30_;
		_data_->_tmp32_ = g_strdup_printf (ngettext ("You need to install the %s package.", "You need to install the %s packages.", (gulong) _data_->_tmp28__length1), _data_->_tmp31_);
		_data_->_tmp33_ = _data_->_tmp32_;
		gtk_label_set_text (_data_->_tmp27_, _data_->_tmp33_);
		_g_free0 (_data_->_tmp33_);
		_g_free0 (_data_->_tmp31_);
		gtk_window_present ((GtkWindow*) _data_->self);
	}
	_data_->packages_to_install = (_vala_array_free (_data_->packages_to_install, _data_->packages_to_install_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_data_->instructions);
	_g_free0 (_data_->message);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
drivers_dialog_class_init (DriversDialogClass * klass,
                           gpointer klass_data)
{
	drivers_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DriversDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = drivers_dialog_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/SimpleScan/ui/drivers-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "header_revealer", FALSE, DriversDialog_private_offset + G_STRUCT_OFFSET (DriversDialogPrivate, header_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_label", FALSE, DriversDialog_private_offset + G_STRUCT_OFFSET (DriversDialogPrivate, main_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_sublabel", FALSE, DriversDialog_private_offset + G_STRUCT_OFFSET (DriversDialogPrivate, main_sublabel));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "progress_revealer", FALSE, DriversDialog_private_offset + G_STRUCT_OFFSET (DriversDialogPrivate, progress_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "progress_bar", FALSE, DriversDialog_private_offset + G_STRUCT_OFFSET (DriversDialogPrivate, progress_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "result_label", FALSE, DriversDialog_private_offset + G_STRUCT_OFFSET (DriversDialogPrivate, result_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "result_sublabel", FALSE, DriversDialog_private_offset + G_STRUCT_OFFSET (DriversDialogPrivate, result_sublabel));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "result_icon", FALSE, DriversDialog_private_offset + G_STRUCT_OFFSET (DriversDialogPrivate, result_icon));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, DriversDialog_private_offset + G_STRUCT_OFFSET (DriversDialogPrivate, stack));
}

static void
drivers_dialog_instance_init (DriversDialog * self,
                              gpointer klass)
{
	self->priv = drivers_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
drivers_dialog_finalize (GObject * obj)
{
	DriversDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DRIVERS_DIALOG, DriversDialog);
	drivers_dialog_pulse_stop (self);
	_g_free0 (self->priv->missing_driver);
	G_OBJECT_CLASS (drivers_dialog_parent_class)->finalize (obj);
}

static GType
drivers_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DriversDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) drivers_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DriversDialog), 0, (GInstanceInitFunc) drivers_dialog_instance_init, NULL };
	GType drivers_dialog_type_id;
	drivers_dialog_type_id = g_type_register_static (gtk_window_get_type (), "DriversDialog", &g_define_type_info, 0);
	DriversDialog_private_offset = g_type_add_instance_private (drivers_dialog_type_id, sizeof (DriversDialogPrivate));
	return drivers_dialog_type_id;
}

GType
drivers_dialog_get_type (void)
{
	static volatile gsize drivers_dialog_type_id__once = 0;
	if (g_once_init_enter (&drivers_dialog_type_id__once)) {
		GType drivers_dialog_type_id;
		drivers_dialog_type_id = drivers_dialog_get_type_once ();
		g_once_init_leave (&drivers_dialog_type_id__once, drivers_dialog_type_id);
	}
	return drivers_dialog_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

