/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/librpc/gen_ndr/ndr_frstrans.h"

#include "librpc/gen_ndr/ndr_misc.h"
static enum ndr_err_code ndr_push_frstrans_ProtocolVersion(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum frstrans_ProtocolVersion r)
{
	{
		libndr_flags _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_ProtocolVersion(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum frstrans_ProtocolVersion *r)
{
	uint32_t v;
	{
		libndr_flags _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
		*r = v;
		ndr->flags = _flags_save_ENUM;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_ProtocolVersion(struct ndr_print *ndr, const char *name, enum frstrans_ProtocolVersion r)
{
	const char *val = NULL;

	{
		libndr_flags _flags_save_ENUM = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		switch (r) {
			case FRSTRANS_PROTOCOL_VERSION_W2K3R2: val = "FRSTRANS_PROTOCOL_VERSION_W2K3R2"; break;
			case FRSTRANS_PROTOCOL_VERSION_LONGHORN_SERVER: val = "FRSTRANS_PROTOCOL_VERSION_LONGHORN_SERVER"; break;
		}
		ndr_print_enum(ndr, name, "ENUM", val, r);
		ndr->flags = _flags_save_ENUM;
	}
}

static enum ndr_err_code ndr_push_frstrans_TransportFlags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_TransportFlags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_TransportFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "FRSTRANS_TRANSPORT_SUPPORTS_RDC_SIMILARITY", FRSTRANS_TRANSPORT_SUPPORTS_RDC_SIMILARITY, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frstrans_UpdateRequestType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum frstrans_UpdateRequestType r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_UpdateRequestType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum frstrans_UpdateRequestType *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_UpdateRequestType(struct ndr_print *ndr, const char *name, enum frstrans_UpdateRequestType r)
{
	const char *val = NULL;

	switch (r) {
		case FRSTRANS_UPDATE_REQUEST_ALL: val = "FRSTRANS_UPDATE_REQUEST_ALL"; break;
		case FRSTRANS_UPDATE_REQUEST_TOMBSTONES: val = "FRSTRANS_UPDATE_REQUEST_TOMBSTONES"; break;
		case FRSTRANS_UPDATE_REQUEST_LIVE: val = "FRSTRANS_UPDATE_REQUEST_LIVE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_frstrans_UpdateStatus(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum frstrans_UpdateStatus r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_UpdateStatus(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum frstrans_UpdateStatus *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_UpdateStatus(struct ndr_print *ndr, const char *name, enum frstrans_UpdateStatus r)
{
	const char *val = NULL;

	switch (r) {
		case FRSTRANS_UPDATE_STATUS_DONE: val = "FRSTRANS_UPDATE_STATUS_DONE"; break;
		case FRSTRANS_UPDATE_STATUS_MORE: val = "FRSTRANS_UPDATE_STATUS_MORE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_frstrans_VersionVector(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct frstrans_VersionVector *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->db_guid));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->low));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->high));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_frstrans_VersionVector(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct frstrans_VersionVector *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->db_guid));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->low));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->high));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_frstrans_VersionVector(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct frstrans_VersionVector *r)
{
	ndr_print_frstrans_VersionVector(ndr, name, r);
}

_PUBLIC_ void ndr_print_frstrans_VersionVector(struct ndr_print *ndr, const char *name, const struct frstrans_VersionVector *r)
{
	ndr_print_struct(ndr, name, "frstrans_VersionVector");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_GUID(ndr, "db_guid", &r->db_guid);
	ndr_print_hyper(ndr, "low", r->low);
	ndr_print_hyper(ndr, "high", r->high);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frstrans_Update(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct frstrans_Update *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 8));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->present));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->name_conflict));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->attributes));
			NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->fence));
			NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->clock));
			NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->create_time));
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->content_set_guid));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->sha1_hash, 20));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->rdc_similarity, 16));
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->uid_db_guid));
			NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->uid_version));
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->gsvn_db_guid));
			NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->gsvn_version));
			NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->parent_db_guid));
			NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->parent_version));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 261));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->name, 261, sizeof(uint16_t), CH_UTF16));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
			NDR_CHECK(ndr_push_trailer_align(ndr, 8));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_Update(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct frstrans_Update *r)
{
	uint32_t size_sha1_hash_0 = 0;
	uint32_t size_rdc_similarity_0 = 0;
	uint32_t size_name_0 = 0;
	uint32_t length_name_0 = 0;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 8));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->present));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->name_conflict));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->attributes));
			NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->fence));
			NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->clock));
			NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->create_time));
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->content_set_guid));
			size_sha1_hash_0 = 20;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->sha1_hash, size_sha1_hash_0));
			size_rdc_similarity_0 = 16;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->rdc_similarity, size_rdc_similarity_0));
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->uid_db_guid));
			NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->uid_version));
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->gsvn_db_guid));
			NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->gsvn_version));
			NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->parent_db_guid));
			NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->parent_version));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->name));
			size_name_0 = 261;
			NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->name, &length_name_0));
			if (length_name_0 > size_name_0) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_name_0, length_name_0);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_name_0, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->name, length_name_0, sizeof(uint16_t), CH_UTF16));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
			if (r->name) {
				NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->name, 261));
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_Update(struct ndr_print *ndr, const char *name, const struct frstrans_Update *r)
{
	ndr_print_struct(ndr, name, "frstrans_Update");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_uint32(ndr, "present", r->present);
		ndr_print_uint32(ndr, "name_conflict", r->name_conflict);
		ndr_print_uint32(ndr, "attributes", r->attributes);
		ndr_print_NTTIME(ndr, "fence", r->fence);
		ndr_print_NTTIME(ndr, "clock", r->clock);
		ndr_print_NTTIME(ndr, "create_time", r->create_time);
		ndr_print_GUID(ndr, "content_set_guid", &r->content_set_guid);
		ndr_print_array_uint8(ndr, "sha1_hash", r->sha1_hash, 20);
		ndr_print_array_uint8(ndr, "rdc_similarity", r->rdc_similarity, 16);
		ndr_print_GUID(ndr, "uid_db_guid", &r->uid_db_guid);
		ndr_print_hyper(ndr, "uid_version", r->uid_version);
		ndr_print_GUID(ndr, "gsvn_db_guid", &r->gsvn_db_guid);
		ndr_print_hyper(ndr, "gsvn_version", r->gsvn_version);
		ndr_print_GUID(ndr, "parent_db_guid", &r->parent_db_guid);
		ndr_print_hyper(ndr, "parent_version", r->parent_version);
		ndr_print_string(ndr, "name", r->name);
		ndr_print_uint32(ndr, "flags", r->flags);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_frstrans_VersionRequestType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum frstrans_VersionRequestType r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_VersionRequestType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum frstrans_VersionRequestType *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_VersionRequestType(struct ndr_print *ndr, const char *name, enum frstrans_VersionRequestType r)
{
	const char *val = NULL;

	switch (r) {
		case FRSTRANS_VERSION_REQUEST_NORNAL_SYNC: val = "FRSTRANS_VERSION_REQUEST_NORNAL_SYNC"; break;
		case FRSTRANS_VERSION_REQUEST_SLOW_SYNC: val = "FRSTRANS_VERSION_REQUEST_SLOW_SYNC"; break;
		case FRSTRANS_VERSION_REQUEST_SLAVE_SYNC: val = "FRSTRANS_VERSION_REQUEST_SLAVE_SYNC"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_frstrans_VersionChangeType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum frstrans_VersionChangeType r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_VersionChangeType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum frstrans_VersionChangeType *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_VersionChangeType(struct ndr_print *ndr, const char *name, enum frstrans_VersionChangeType r)
{
	const char *val = NULL;

	switch (r) {
		case FRSTRANS_VERSION_CHANGE_NOTIFY: val = "FRSTRANS_VERSION_CHANGE_NOTIFY"; break;
		case FRSTRANS_VERSION_CHANGE_ALL: val = "FRSTRANS_VERSION_CHANGE_ALL"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_frstrans_EpoqueVector(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct frstrans_EpoqueVector *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->machine_guid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->year));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->month));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->day_of_week));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->day));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->hour));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->minute));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->second));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->milli_seconds));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_EpoqueVector(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct frstrans_EpoqueVector *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->machine_guid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->year));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->month));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->day_of_week));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->day));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->hour));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->minute));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->second));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->milli_seconds));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_EpoqueVector(struct ndr_print *ndr, const char *name, const struct frstrans_EpoqueVector *r)
{
	ndr_print_struct(ndr, name, "frstrans_EpoqueVector");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_GUID(ndr, "machine_guid", &r->machine_guid);
	ndr_print_uint32(ndr, "year", r->year);
	ndr_print_uint32(ndr, "month", r->month);
	ndr_print_uint32(ndr, "day_of_week", r->day_of_week);
	ndr_print_uint32(ndr, "day", r->day);
	ndr_print_uint32(ndr, "hour", r->hour);
	ndr_print_uint32(ndr, "minute", r->minute);
	ndr_print_uint32(ndr, "second", r->second);
	ndr_print_uint32(ndr, "milli_seconds", r->milli_seconds);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frstrans_AsyncVersionVectorResponse(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct frstrans_AsyncVersionVectorResponse *r)
{
	uint32_t cntr_version_vector_1;
	uint32_t cntr_epoque_vector_1;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->vv_generation));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->version_vector_count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->version_vector));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->epoque_vector_count));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->epoque_vector));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->version_vector) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->version_vector_count));
			for (cntr_version_vector_1 = 0; cntr_version_vector_1 < (r->version_vector_count); cntr_version_vector_1++) {
				NDR_CHECK(ndr_push_frstrans_VersionVector(ndr, NDR_SCALARS, &r->version_vector[cntr_version_vector_1]));
			}
		}
		if (r->epoque_vector) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->epoque_vector_count));
			for (cntr_epoque_vector_1 = 0; cntr_epoque_vector_1 < (r->epoque_vector_count); cntr_epoque_vector_1++) {
				NDR_CHECK(ndr_push_frstrans_EpoqueVector(ndr, NDR_SCALARS, &r->epoque_vector[cntr_epoque_vector_1]));
			}
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_AsyncVersionVectorResponse(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct frstrans_AsyncVersionVectorResponse *r)
{
	uint32_t _ptr_version_vector;
	uint32_t size_version_vector_1 = 0;
	uint32_t cntr_version_vector_1;
	TALLOC_CTX *_mem_save_version_vector_0 = NULL;
	TALLOC_CTX *_mem_save_version_vector_1 = NULL;
	uint32_t _ptr_epoque_vector;
	uint32_t size_epoque_vector_1 = 0;
	uint32_t cntr_epoque_vector_1;
	TALLOC_CTX *_mem_save_epoque_vector_0 = NULL;
	TALLOC_CTX *_mem_save_epoque_vector_1 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->vv_generation));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->version_vector_count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_version_vector));
		if (_ptr_version_vector) {
			NDR_PULL_ALLOC(ndr, r->version_vector);
		} else {
			r->version_vector = NULL;
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->epoque_vector_count));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_epoque_vector));
		if (_ptr_epoque_vector) {
			NDR_PULL_ALLOC(ndr, r->epoque_vector);
		} else {
			r->epoque_vector = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->version_vector) {
			_mem_save_version_vector_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->version_vector, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->version_vector));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->version_vector, &size_version_vector_1));
			NDR_PULL_ALLOC_N(ndr, r->version_vector, size_version_vector_1);
			_mem_save_version_vector_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->version_vector, 0);
			for (cntr_version_vector_1 = 0; cntr_version_vector_1 < (size_version_vector_1); cntr_version_vector_1++) {
				NDR_CHECK(ndr_pull_frstrans_VersionVector(ndr, NDR_SCALARS, &r->version_vector[cntr_version_vector_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_version_vector_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_version_vector_0, 0);
		}
		if (r->epoque_vector) {
			_mem_save_epoque_vector_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->epoque_vector, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->epoque_vector));
			NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->epoque_vector, &size_epoque_vector_1));
			NDR_PULL_ALLOC_N(ndr, r->epoque_vector, size_epoque_vector_1);
			_mem_save_epoque_vector_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->epoque_vector, 0);
			for (cntr_epoque_vector_1 = 0; cntr_epoque_vector_1 < (size_epoque_vector_1); cntr_epoque_vector_1++) {
				NDR_CHECK(ndr_pull_frstrans_EpoqueVector(ndr, NDR_SCALARS, &r->epoque_vector[cntr_epoque_vector_1]));
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_epoque_vector_1, 0);
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_epoque_vector_0, 0);
		}
		if (r->version_vector) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->version_vector, r->version_vector_count));
		}
		if (r->epoque_vector) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->epoque_vector, r->epoque_vector_count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_AsyncVersionVectorResponse(struct ndr_print *ndr, const char *name, const struct frstrans_AsyncVersionVectorResponse *r)
{
	uint32_t cntr_version_vector_1;
	uint32_t cntr_epoque_vector_1;
	ndr_print_struct(ndr, name, "frstrans_AsyncVersionVectorResponse");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "vv_generation", r->vv_generation);
	ndr_print_uint32(ndr, "version_vector_count", r->version_vector_count);
	ndr_print_ptr(ndr, "version_vector", r->version_vector);
	ndr->depth++;
	if (r->version_vector) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "version_vector", (uint32_t)(r->version_vector_count));
		ndr->depth++;
		for (cntr_version_vector_1 = 0; cntr_version_vector_1 < (r->version_vector_count); cntr_version_vector_1++) {
			ndr_print_frstrans_VersionVector(ndr, "version_vector", &r->version_vector[cntr_version_vector_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "epoque_vector_count", r->epoque_vector_count);
	ndr_print_ptr(ndr, "epoque_vector", r->epoque_vector);
	ndr->depth++;
	if (r->epoque_vector) {
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "epoque_vector", (uint32_t)(r->epoque_vector_count));
		ndr->depth++;
		for (cntr_epoque_vector_1 = 0; cntr_epoque_vector_1 < (r->epoque_vector_count); cntr_epoque_vector_1++) {
			ndr_print_frstrans_EpoqueVector(ndr, "epoque_vector", &r->epoque_vector[cntr_epoque_vector_1]);
		}
		ndr->depth--;
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frstrans_AsyncResponseContext(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct frstrans_AsyncResponseContext *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->sequence_number));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->status));
		NDR_CHECK(ndr_push_frstrans_AsyncVersionVectorResponse(ndr, NDR_SCALARS, &r->response));
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_push_frstrans_AsyncVersionVectorResponse(ndr, NDR_BUFFERS, &r->response));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_AsyncResponseContext(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct frstrans_AsyncResponseContext *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->sequence_number));
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->status));
		NDR_CHECK(ndr_pull_frstrans_AsyncVersionVectorResponse(ndr, NDR_SCALARS, &r->response));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		NDR_CHECK(ndr_pull_frstrans_AsyncVersionVectorResponse(ndr, NDR_BUFFERS, &r->response));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_AsyncResponseContext(struct ndr_print *ndr, const char *name, const struct frstrans_AsyncResponseContext *r)
{
	ndr_print_struct(ndr, name, "frstrans_AsyncResponseContext");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "sequence_number", r->sequence_number);
	ndr_print_WERROR(ndr, "status", r->status);
	ndr_print_frstrans_AsyncVersionVectorResponse(ndr, "response", &r->response);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frstrans_RequestedStagingPolicy(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum frstrans_RequestedStagingPolicy r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_RequestedStagingPolicy(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum frstrans_RequestedStagingPolicy *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_RequestedStagingPolicy(struct ndr_print *ndr, const char *name, enum frstrans_RequestedStagingPolicy r)
{
	const char *val = NULL;

	switch (r) {
		case FRSTRANS_STAGING_POLICY_SERVER_DEFAULTY: val = "FRSTRANS_STAGING_POLICY_SERVER_DEFAULTY"; break;
		case FRSTRANS_STAGING_POLICY_STATGING_REQUIRED: val = "FRSTRANS_STAGING_POLICY_STATGING_REQUIRED"; break;
		case FRSTRANS_STAGING_POLICY_RESTATGING_REQUIRED: val = "FRSTRANS_STAGING_POLICY_RESTATGING_REQUIRED"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_frstrans_RdcChunckerAlgorithm(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum frstrans_RdcChunckerAlgorithm r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_RdcChunckerAlgorithm(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum frstrans_RdcChunckerAlgorithm *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_RdcChunckerAlgorithm(struct ndr_print *ndr, const char *name, enum frstrans_RdcChunckerAlgorithm r)
{
	const char *val = NULL;

	switch (r) {
		case FRSTRANS_RDC_FILTER_GENERIC: val = "FRSTRANS_RDC_FILTER_GENERIC"; break;
		case FRSTRANS_RDC_FILTER_MAX: val = "FRSTRANS_RDC_FILTER_MAX"; break;
		case FRSTRANS_RDC_FILTER_POINT: val = "FRSTRANS_RDC_FILTER_POINT"; break;
		case FRSTRANS_RDC_MAX_ALGORITHM: val = "FRSTRANS_RDC_MAX_ALGORITHM"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_frstrans_RdcParameterGeneric(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct frstrans_RdcParameterGeneric *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 3));
		NDR_CHECK(ndr_push_frstrans_RdcChunckerAlgorithm(ndr, NDR_SCALARS, r->chunker_type));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->chunker_parameters, 64));
		NDR_CHECK(ndr_push_trailer_align(ndr, 3));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_RdcParameterGeneric(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct frstrans_RdcParameterGeneric *r)
{
	uint32_t size_chunker_parameters_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 3));
		NDR_CHECK(ndr_pull_frstrans_RdcChunckerAlgorithm(ndr, NDR_SCALARS, &r->chunker_type));
		size_chunker_parameters_0 = 64;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->chunker_parameters, size_chunker_parameters_0));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 3));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_RdcParameterGeneric(struct ndr_print *ndr, const char *name, const struct frstrans_RdcParameterGeneric *r)
{
	ndr_print_struct(ndr, name, "frstrans_RdcParameterGeneric");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_frstrans_RdcChunckerAlgorithm(ndr, "chunker_type", r->chunker_type);
	ndr_print_array_uint8(ndr, "chunker_parameters", r->chunker_parameters, 64);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frstrans_RdcParameterFilterMax(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct frstrans_RdcParameterFilterMax *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->min_horizon_size));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->max_window_size));
		NDR_CHECK(ndr_push_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_RdcParameterFilterMax(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct frstrans_RdcParameterFilterMax *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->min_horizon_size));
		if (r->min_horizon_size < 128 || r->min_horizon_size > 1024*16) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu16") out of range (%"PRIu16" - %"PRIu16")", (uint16_t)(r->min_horizon_size), (uint16_t)(128), (uint16_t)(1024*16));
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->max_window_size));
		if (r->max_window_size < 2 || r->max_window_size > 96) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu16") out of range (%"PRIu16" - %"PRIu16")", (uint16_t)(r->max_window_size), (uint16_t)(2), (uint16_t)(96));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_RdcParameterFilterMax(struct ndr_print *ndr, const char *name, const struct frstrans_RdcParameterFilterMax *r)
{
	ndr_print_struct(ndr, name, "frstrans_RdcParameterFilterMax");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "min_horizon_size", r->min_horizon_size);
	ndr_print_uint16(ndr, "max_window_size", r->max_window_size);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frstrans_RdcParameterFilterPoint(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct frstrans_RdcParameterFilterPoint *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->min_chunk_size));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->max_chunk_size));
		NDR_CHECK(ndr_push_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_RdcParameterFilterPoint(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct frstrans_RdcParameterFilterPoint *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->min_chunk_size));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->max_chunk_size));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_RdcParameterFilterPoint(struct ndr_print *ndr, const char *name, const struct frstrans_RdcParameterFilterPoint *r)
{
	ndr_print_struct(ndr, name, "frstrans_RdcParameterFilterPoint");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint16(ndr, "min_chunk_size", r->min_chunk_size);
	ndr_print_uint16(ndr, "max_chunk_size", r->max_chunk_size);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frstrans_RdcParameterUnion(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union frstrans_RdcParameterUnion *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 3));
		NDR_CHECK(ndr_push_frstrans_RdcChunckerAlgorithm(ndr, NDR_SCALARS, level));
		NDR_CHECK(ndr_push_union_align(ndr, 3));
		switch (level) {
			case FRSTRANS_RDC_FILTER_GENERIC: {
				NDR_CHECK(ndr_push_frstrans_RdcParameterGeneric(ndr, NDR_SCALARS, &r->filter_generic));
			break; }

			case FRSTRANS_RDC_FILTER_MAX: {
				NDR_CHECK(ndr_push_frstrans_RdcParameterFilterMax(ndr, NDR_SCALARS, &r->filter_max));
			break; }

			case FRSTRANS_RDC_FILTER_POINT: {
				NDR_CHECK(ndr_push_frstrans_RdcParameterFilterPoint(ndr, NDR_SCALARS, &r->filter_point));
			break; }

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case FRSTRANS_RDC_FILTER_GENERIC:
			break;

			case FRSTRANS_RDC_FILTER_MAX:
			break;

			case FRSTRANS_RDC_FILTER_POINT:
			break;

			default:
				return ndr_push_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32, level);
		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_RdcParameterUnion(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union frstrans_RdcParameterUnion *r)
{
	uint32_t level;
	uint16_t _level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 3));
		NDR_CHECK(ndr_pull_uint1632(ndr, NDR_SCALARS, &_level));
		if (_level != level) {
			return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu16" for r at %s", (uint16_t)_level, __location__);
		}
		NDR_CHECK(ndr_pull_union_align(ndr, 3));
		switch (level) {
			case FRSTRANS_RDC_FILTER_GENERIC: {
				NDR_CHECK(ndr_pull_frstrans_RdcParameterGeneric(ndr, NDR_SCALARS, &r->filter_generic));
			break; }

			case FRSTRANS_RDC_FILTER_MAX: {
				NDR_CHECK(ndr_pull_frstrans_RdcParameterFilterMax(ndr, NDR_SCALARS, &r->filter_max));
			break; }

			case FRSTRANS_RDC_FILTER_POINT: {
				NDR_CHECK(ndr_pull_frstrans_RdcParameterFilterPoint(ndr, NDR_SCALARS, &r->filter_point));
			break; }

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case FRSTRANS_RDC_FILTER_GENERIC:
			break;

			case FRSTRANS_RDC_FILTER_MAX:
			break;

			case FRSTRANS_RDC_FILTER_POINT:
			break;

			default:
				return ndr_pull_error(ndr, NDR_ERR_BAD_SWITCH, "Bad switch value %"PRIu32" at %s", level, __location__);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_RdcParameterUnion(struct ndr_print *ndr, const char *name, const union frstrans_RdcParameterUnion *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "frstrans_RdcParameterUnion");
	switch (level) {
		case FRSTRANS_RDC_FILTER_GENERIC:
			ndr_print_frstrans_RdcParameterGeneric(ndr, "filter_generic", &r->filter_generic);
		break;

		case FRSTRANS_RDC_FILTER_MAX:
			ndr_print_frstrans_RdcParameterFilterMax(ndr, "filter_max", &r->filter_max);
		break;

		case FRSTRANS_RDC_FILTER_POINT:
			ndr_print_frstrans_RdcParameterFilterPoint(ndr, "filter_point", &r->filter_point);
		break;

		default:
			ndr_print_bad_level(ndr, name, level);
	}
}

static enum ndr_err_code ndr_push_frstrans_RdcParameters(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct frstrans_RdcParameters *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 3));
		NDR_CHECK(ndr_push_frstrans_RdcChunckerAlgorithm(ndr, NDR_SCALARS, r->rdc_chunker_algorithm));
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->u, r->rdc_chunker_algorithm));
		NDR_CHECK(ndr_push_frstrans_RdcParameterUnion(ndr, NDR_SCALARS, &r->u));
		NDR_CHECK(ndr_push_trailer_align(ndr, 3));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_RdcParameters(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct frstrans_RdcParameters *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 3));
		NDR_CHECK(ndr_pull_frstrans_RdcChunckerAlgorithm(ndr, NDR_SCALARS, &r->rdc_chunker_algorithm));
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->u, r->rdc_chunker_algorithm));
		NDR_CHECK(ndr_pull_frstrans_RdcParameterUnion(ndr, NDR_SCALARS, &r->u));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 3));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_RdcParameters(struct ndr_print *ndr, const char *name, const struct frstrans_RdcParameters *r)
{
	ndr_print_struct(ndr, name, "frstrans_RdcParameters");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_frstrans_RdcChunckerAlgorithm(ndr, "rdc_chunker_algorithm", r->rdc_chunker_algorithm);
	ndr_print_set_switch_value(ndr, &r->u, r->rdc_chunker_algorithm);
	ndr_print_frstrans_RdcParameterUnion(ndr, "u", &r->u);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frstrans_RdcVersion(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum frstrans_RdcVersion r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_RdcVersion(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum frstrans_RdcVersion *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_RdcVersion(struct ndr_print *ndr, const char *name, enum frstrans_RdcVersion r)
{
	const char *val = NULL;

	switch (r) {
		case FRSTRANS_RDC_VERSION: val = "FRSTRANS_RDC_VERSION"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_frstrans_RdcVersionCompatible(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum frstrans_RdcVersionCompatible r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_RdcVersionCompatible(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum frstrans_RdcVersionCompatible *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_RdcVersionCompatible(struct ndr_print *ndr, const char *name, enum frstrans_RdcVersionCompatible r)
{
	const char *val = NULL;

	switch (r) {
		case FRSTRANS_RDC_VERSION_COMPATIBLE: val = "FRSTRANS_RDC_VERSION_COMPATIBLE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_frstrans_RdcCompressionAlgorithm(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum frstrans_RdcCompressionAlgorithm r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_RdcCompressionAlgorithm(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum frstrans_RdcCompressionAlgorithm *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_RdcCompressionAlgorithm(struct ndr_print *ndr, const char *name, enum frstrans_RdcCompressionAlgorithm r)
{
	const char *val = NULL;

	switch (r) {
		case FRSTRANS_RDC_UNCOMPRESSED: val = "FRSTRANS_RDC_UNCOMPRESSED"; break;
		case FRSTRANS_RDC_XPRESS: val = "FRSTRANS_RDC_XPRESS"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_frstrans_RdcFileInfo(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct frstrans_RdcFileInfo *r)
{
	uint32_t cntr_rdc_filter_parameters_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->rdc_signature_levels));
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->on_disk_file_size));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->file_size_estimate));
		NDR_CHECK(ndr_push_frstrans_RdcVersion(ndr, NDR_SCALARS, r->rdc_version));
		NDR_CHECK(ndr_push_frstrans_RdcVersionCompatible(ndr, NDR_SCALARS, r->rdc_minimum_compatible_version));
		NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, r->rdc_signature_levels));
		NDR_CHECK(ndr_push_frstrans_RdcCompressionAlgorithm(ndr, NDR_SCALARS, r->compression_algorithm));
		for (cntr_rdc_filter_parameters_0 = 0; cntr_rdc_filter_parameters_0 < (r->rdc_signature_levels); cntr_rdc_filter_parameters_0++) {
			NDR_CHECK(ndr_push_frstrans_RdcParameters(ndr, NDR_SCALARS, &r->rdc_filter_parameters[cntr_rdc_filter_parameters_0]));
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_RdcFileInfo(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct frstrans_RdcFileInfo *r)
{
	uint32_t size_rdc_filter_parameters_0 = 0;
	uint32_t cntr_rdc_filter_parameters_0;
	TALLOC_CTX *_mem_save_rdc_filter_parameters_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->rdc_filter_parameters));
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->on_disk_file_size));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->file_size_estimate));
		NDR_CHECK(ndr_pull_frstrans_RdcVersion(ndr, NDR_SCALARS, &r->rdc_version));
		NDR_CHECK(ndr_pull_frstrans_RdcVersionCompatible(ndr, NDR_SCALARS, &r->rdc_minimum_compatible_version));
		NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->rdc_signature_levels));
		if (r->rdc_signature_levels > 8) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu8") out of range (%"PRIu8" - %"PRIu8")", (uint8_t)(r->rdc_signature_levels), (uint8_t)(0), (uint8_t)(8));
		}
		NDR_CHECK(ndr_pull_frstrans_RdcCompressionAlgorithm(ndr, NDR_SCALARS, &r->compression_algorithm));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->rdc_filter_parameters, &size_rdc_filter_parameters_0));
		NDR_PULL_ALLOC_N(ndr, r->rdc_filter_parameters, size_rdc_filter_parameters_0);
		_mem_save_rdc_filter_parameters_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->rdc_filter_parameters, 0);
		for (cntr_rdc_filter_parameters_0 = 0; cntr_rdc_filter_parameters_0 < (size_rdc_filter_parameters_0); cntr_rdc_filter_parameters_0++) {
			NDR_CHECK(ndr_pull_frstrans_RdcParameters(ndr, NDR_SCALARS, &r->rdc_filter_parameters[cntr_rdc_filter_parameters_0]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rdc_filter_parameters_0, 0);
		if (r->rdc_filter_parameters) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->rdc_filter_parameters, r->rdc_signature_levels));
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_RdcFileInfo(struct ndr_print *ndr, const char *name, const struct frstrans_RdcFileInfo *r)
{
	uint32_t cntr_rdc_filter_parameters_0;
	ndr_print_struct(ndr, name, "frstrans_RdcFileInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_hyper(ndr, "on_disk_file_size", r->on_disk_file_size);
	ndr_print_hyper(ndr, "file_size_estimate", r->file_size_estimate);
	ndr_print_frstrans_RdcVersion(ndr, "rdc_version", r->rdc_version);
	ndr_print_frstrans_RdcVersionCompatible(ndr, "rdc_minimum_compatible_version", r->rdc_minimum_compatible_version);
	ndr_print_uint8(ndr, "rdc_signature_levels", r->rdc_signature_levels);
	ndr_print_frstrans_RdcCompressionAlgorithm(ndr, "compression_algorithm", r->compression_algorithm);
	ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "rdc_filter_parameters", (uint32_t)(r->rdc_signature_levels));
	ndr->depth++;
	for (cntr_rdc_filter_parameters_0 = 0; cntr_rdc_filter_parameters_0 < (r->rdc_signature_levels); cntr_rdc_filter_parameters_0++) {
		ndr_print_frstrans_RdcParameters(ndr, "rdc_filter_parameters", &r->rdc_filter_parameters[cntr_rdc_filter_parameters_0]);
	}
	ndr->depth--;
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frstrans_BytePipe_chunk(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct frstrans_BytePipe_chunk *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 5));
			{
				libndr_flags _flags_save_uint3264 = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->count));
				ndr->flags = _flags_save_uint3264;
			}
			{
				libndr_flags _flags_save_uint8 = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
				NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->array, r->count));
				ndr->flags = _flags_save_uint8;
			}
			NDR_CHECK(ndr_push_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}

	NDR_CHECK(ndr_push_pipe_chunk_trailer(ndr, ndr_flags, r->count));

	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_BytePipe_chunk(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct frstrans_BytePipe_chunk *r)
{
	uint32_t size_array_0 = 0;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 5));
			{
				libndr_flags _flags_save_uint3264 = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
				NDR_CHECK(ndr_pull_uint3264(ndr, NDR_SCALARS, &r->count));
				ndr->flags = _flags_save_uint3264;
			}
			{
				libndr_flags _flags_save_uint8 = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
				size_array_0 = r->count;
				NDR_PULL_ALLOC_N(ndr, r->array, size_array_0);
				NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->array, size_array_0));
				ndr->flags = _flags_save_uint8;
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}

	NDR_CHECK(ndr_check_pipe_chunk_trailer(ndr, ndr_flags, r->count));

	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_BytePipe_chunk(struct ndr_print *ndr, const char *name, const struct frstrans_BytePipe_chunk *r)
{
	ndr_print_struct(ndr, name, "frstrans_BytePipe_chunk");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		{
			libndr_flags _flags_save_uint3264 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
			ndr_print_uint3264(ndr, "count", r->count);
			ndr->flags = _flags_save_uint3264;
		}
		{
			libndr_flags _flags_save_uint8 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
			ndr_print_array_uint8(ndr, "array", r->array, r->count);
			ndr->flags = _flags_save_uint8;
		}
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_frstrans_CheckConnectivity(struct ndr_push *ndr, ndr_flags_type flags, const struct frstrans_CheckConnectivity *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->in.replica_set_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->in.connection_guid));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_CheckConnectivity(struct ndr_pull *ndr, ndr_flags_type flags, struct frstrans_CheckConnectivity *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->in.replica_set_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->in.connection_guid));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_CheckConnectivity(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct frstrans_CheckConnectivity *r)
{
	ndr_print_struct(ndr, name, "frstrans_CheckConnectivity");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "frstrans_CheckConnectivity");
		ndr->depth++;
		ndr_print_GUID(ndr, "replica_set_guid", &r->in.replica_set_guid);
		ndr_print_GUID(ndr, "connection_guid", &r->in.connection_guid);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "frstrans_CheckConnectivity");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frstrans_EstablishConnection(struct ndr_push *ndr, ndr_flags_type flags, const struct frstrans_EstablishConnection *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->in.replica_set_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->in.connection_guid));
		NDR_CHECK(ndr_push_frstrans_ProtocolVersion(ndr, NDR_SCALARS, r->in.downstream_protocol_version));
		NDR_CHECK(ndr_push_frstrans_TransportFlags(ndr, NDR_SCALARS, r->in.downstream_flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.upstream_protocol_version == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.upstream_flags == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_frstrans_ProtocolVersion(ndr, NDR_SCALARS, *r->out.upstream_protocol_version));
		NDR_CHECK(ndr_push_frstrans_TransportFlags(ndr, NDR_SCALARS, *r->out.upstream_flags));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_EstablishConnection(struct ndr_pull *ndr, ndr_flags_type flags, struct frstrans_EstablishConnection *r)
{
	TALLOC_CTX *_mem_save_upstream_protocol_version_0 = NULL;
	TALLOC_CTX *_mem_save_upstream_flags_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->in.replica_set_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->in.connection_guid));
		NDR_CHECK(ndr_pull_frstrans_ProtocolVersion(ndr, NDR_SCALARS, &r->in.downstream_protocol_version));
		NDR_CHECK(ndr_pull_frstrans_TransportFlags(ndr, NDR_SCALARS, &r->in.downstream_flags));
		NDR_PULL_ALLOC(ndr, r->out.upstream_protocol_version);
		NDR_ZERO_STRUCTP(r->out.upstream_protocol_version);
		NDR_PULL_ALLOC(ndr, r->out.upstream_flags);
		NDR_ZERO_STRUCTP(r->out.upstream_flags);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.upstream_protocol_version);
		}
		_mem_save_upstream_protocol_version_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.upstream_protocol_version, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_frstrans_ProtocolVersion(ndr, NDR_SCALARS, r->out.upstream_protocol_version));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_upstream_protocol_version_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.upstream_flags);
		}
		_mem_save_upstream_flags_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.upstream_flags, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_frstrans_TransportFlags(ndr, NDR_SCALARS, r->out.upstream_flags));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_upstream_flags_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_EstablishConnection(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct frstrans_EstablishConnection *r)
{
	ndr_print_struct(ndr, name, "frstrans_EstablishConnection");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "frstrans_EstablishConnection");
		ndr->depth++;
		ndr_print_GUID(ndr, "replica_set_guid", &r->in.replica_set_guid);
		ndr_print_GUID(ndr, "connection_guid", &r->in.connection_guid);
		ndr_print_frstrans_ProtocolVersion(ndr, "downstream_protocol_version", r->in.downstream_protocol_version);
		ndr_print_frstrans_TransportFlags(ndr, "downstream_flags", r->in.downstream_flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "frstrans_EstablishConnection");
		ndr->depth++;
		ndr_print_ptr(ndr, "upstream_protocol_version", r->out.upstream_protocol_version);
		ndr->depth++;
		ndr_print_frstrans_ProtocolVersion(ndr, "upstream_protocol_version", *r->out.upstream_protocol_version);
		ndr->depth--;
		ndr_print_ptr(ndr, "upstream_flags", r->out.upstream_flags);
		ndr->depth++;
		ndr_print_frstrans_TransportFlags(ndr, "upstream_flags", *r->out.upstream_flags);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frstrans_EstablishSession(struct ndr_push *ndr, ndr_flags_type flags, const struct frstrans_EstablishSession *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->in.connection_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->in.content_set_guid));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_EstablishSession(struct ndr_pull *ndr, ndr_flags_type flags, struct frstrans_EstablishSession *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->in.connection_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->in.content_set_guid));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_EstablishSession(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct frstrans_EstablishSession *r)
{
	ndr_print_struct(ndr, name, "frstrans_EstablishSession");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "frstrans_EstablishSession");
		ndr->depth++;
		ndr_print_GUID(ndr, "connection_guid", &r->in.connection_guid);
		ndr_print_GUID(ndr, "content_set_guid", &r->in.content_set_guid);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "frstrans_EstablishSession");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frstrans_RequestUpdates(struct ndr_push *ndr, ndr_flags_type flags, const struct frstrans_RequestUpdates *r)
{
	uint32_t cntr_version_vector_diff_1;
	uint32_t cntr_frs_update_1;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.version_vector_diff == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->in.connection_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->in.content_set_guid));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.credits_available));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.hash_requested));
		NDR_CHECK(ndr_push_frstrans_UpdateRequestType(ndr, NDR_SCALARS, r->in.update_request_type));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.version_vector_diff_count));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.version_vector_diff_count));
		for (cntr_version_vector_diff_1 = 0; cntr_version_vector_diff_1 < (r->in.version_vector_diff_count); cntr_version_vector_diff_1++) {
			NDR_CHECK(ndr_push_frstrans_VersionVector(ndr, NDR_SCALARS, &r->in.version_vector_diff[cntr_version_vector_diff_1]));
		}
	}
	if (flags & NDR_OUT) {
		if (r->out.frs_update == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.update_count == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.update_status == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.gvsn_db_guid == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.gvsn_version == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.credits_available));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.update_count));
		for (cntr_frs_update_1 = 0; cntr_frs_update_1 < (*r->out.update_count); cntr_frs_update_1++) {
			NDR_CHECK(ndr_push_frstrans_Update(ndr, NDR_SCALARS, &r->out.frs_update[cntr_frs_update_1]));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.update_count));
		NDR_CHECK(ndr_push_frstrans_UpdateStatus(ndr, NDR_SCALARS, *r->out.update_status));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, r->out.gvsn_db_guid));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, *r->out.gvsn_version));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_RequestUpdates(struct ndr_pull *ndr, ndr_flags_type flags, struct frstrans_RequestUpdates *r)
{
	uint32_t size_version_vector_diff_1 = 0;
	uint32_t cntr_version_vector_diff_1;
	uint32_t size_frs_update_1 = 0;
	uint32_t length_frs_update_1 = 0;
	uint32_t cntr_frs_update_1;
	TALLOC_CTX *_mem_save_version_vector_diff_1 = NULL;
	TALLOC_CTX *_mem_save_frs_update_1 = NULL;
	TALLOC_CTX *_mem_save_update_count_0 = NULL;
	TALLOC_CTX *_mem_save_update_status_0 = NULL;
	TALLOC_CTX *_mem_save_gvsn_db_guid_0 = NULL;
	TALLOC_CTX *_mem_save_gvsn_version_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->in.connection_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->in.content_set_guid));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.credits_available));
		if (r->in.credits_available > 256) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.credits_available), (uint32_t)(0), (uint32_t)(256));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.hash_requested));
		if (r->in.hash_requested > 1) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.hash_requested), (uint32_t)(0), (uint32_t)(1));
		}
		NDR_CHECK(ndr_pull_frstrans_UpdateRequestType(ndr, NDR_SCALARS, &r->in.update_request_type));
		if (r->in.update_request_type > 2) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%d) out of range (%d - %d)", (int)(r->in.update_request_type), (int)(0), (int)(2));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.version_vector_diff_count));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.version_vector_diff));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->in.version_vector_diff, &size_version_vector_diff_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->in.version_vector_diff, size_version_vector_diff_1);
		}
		_mem_save_version_vector_diff_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.version_vector_diff, 0);
		for (cntr_version_vector_diff_1 = 0; cntr_version_vector_diff_1 < (size_version_vector_diff_1); cntr_version_vector_diff_1++) {
			NDR_CHECK(ndr_pull_frstrans_VersionVector(ndr, NDR_SCALARS, &r->in.version_vector_diff[cntr_version_vector_diff_1]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_version_vector_diff_1, 0);
		NDR_PULL_ALLOC_N(ndr, r->out.frs_update, r->in.credits_available);
		memset(r->out.frs_update, 0, (r->in.credits_available) * sizeof(*r->out.frs_update));
		NDR_PULL_ALLOC(ndr, r->out.update_count);
		NDR_ZERO_STRUCTP(r->out.update_count);
		NDR_PULL_ALLOC(ndr, r->out.update_status);
		NDR_ZERO_STRUCTP(r->out.update_status);
		NDR_PULL_ALLOC(ndr, r->out.gvsn_db_guid);
		NDR_ZERO_STRUCTP(r->out.gvsn_db_guid);
		NDR_PULL_ALLOC(ndr, r->out.gvsn_version);
		NDR_ZERO_STRUCTP(r->out.gvsn_version);
		if (r->in.version_vector_diff) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->in.version_vector_diff, r->in.version_vector_diff_count));
		}
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.frs_update));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.frs_update));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.frs_update, &size_frs_update_1));
		NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->out.frs_update, &length_frs_update_1));
		if (length_frs_update_1 > size_frs_update_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_frs_update_1, length_frs_update_1);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.frs_update, size_frs_update_1);
		}
		_mem_save_frs_update_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.frs_update, 0);
		for (cntr_frs_update_1 = 0; cntr_frs_update_1 < (length_frs_update_1); cntr_frs_update_1++) {
			NDR_CHECK(ndr_pull_frstrans_Update(ndr, NDR_SCALARS, &r->out.frs_update[cntr_frs_update_1]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_frs_update_1, 0);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.update_count);
		}
		_mem_save_update_count_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.update_count, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.update_count));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_update_count_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.update_status);
		}
		_mem_save_update_status_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.update_status, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_frstrans_UpdateStatus(ndr, NDR_SCALARS, r->out.update_status));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_update_status_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.gvsn_db_guid);
		}
		_mem_save_gvsn_db_guid_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.gvsn_db_guid, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, r->out.gvsn_db_guid));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_gvsn_db_guid_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.gvsn_version);
		}
		_mem_save_gvsn_version_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.gvsn_version, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, r->out.gvsn_version));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_gvsn_version_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.frs_update) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.frs_update, r->in.credits_available));
		}
		if (r->out.frs_update) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->out.frs_update, *r->out.update_count));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_RequestUpdates(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct frstrans_RequestUpdates *r)
{
	uint32_t cntr_version_vector_diff_1;
	uint32_t cntr_frs_update_1;
	ndr_print_struct(ndr, name, "frstrans_RequestUpdates");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "frstrans_RequestUpdates");
		ndr->depth++;
		ndr_print_GUID(ndr, "connection_guid", &r->in.connection_guid);
		ndr_print_GUID(ndr, "content_set_guid", &r->in.content_set_guid);
		ndr_print_uint32(ndr, "credits_available", r->in.credits_available);
		ndr_print_uint32(ndr, "hash_requested", r->in.hash_requested);
		ndr_print_frstrans_UpdateRequestType(ndr, "update_request_type", r->in.update_request_type);
		ndr_print_uint32(ndr, "version_vector_diff_count", r->in.version_vector_diff_count);
		ndr_print_ptr(ndr, "version_vector_diff", r->in.version_vector_diff);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "version_vector_diff", (uint32_t)(r->in.version_vector_diff_count));
		ndr->depth++;
		for (cntr_version_vector_diff_1 = 0; cntr_version_vector_diff_1 < (r->in.version_vector_diff_count); cntr_version_vector_diff_1++) {
			ndr_print_frstrans_VersionVector(ndr, "version_vector_diff", &r->in.version_vector_diff[cntr_version_vector_diff_1]);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "frstrans_RequestUpdates");
		ndr->depth++;
		ndr_print_ptr(ndr, "frs_update", r->out.frs_update);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "frs_update", (uint32_t)(*r->out.update_count));
		ndr->depth++;
		for (cntr_frs_update_1 = 0; cntr_frs_update_1 < (*r->out.update_count); cntr_frs_update_1++) {
			ndr_print_frstrans_Update(ndr, "frs_update", &r->out.frs_update[cntr_frs_update_1]);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "update_count", r->out.update_count);
		ndr->depth++;
		ndr_print_uint32(ndr, "update_count", *r->out.update_count);
		ndr->depth--;
		ndr_print_ptr(ndr, "update_status", r->out.update_status);
		ndr->depth++;
		ndr_print_frstrans_UpdateStatus(ndr, "update_status", *r->out.update_status);
		ndr->depth--;
		ndr_print_ptr(ndr, "gvsn_db_guid", r->out.gvsn_db_guid);
		ndr->depth++;
		ndr_print_GUID(ndr, "gvsn_db_guid", r->out.gvsn_db_guid);
		ndr->depth--;
		ndr_print_ptr(ndr, "gvsn_version", r->out.gvsn_version);
		ndr->depth++;
		ndr_print_hyper(ndr, "gvsn_version", *r->out.gvsn_version);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frstrans_RequestVersionVector(struct ndr_push *ndr, ndr_flags_type flags, const struct frstrans_RequestVersionVector *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.sequence_number));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->in.connection_guid));
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->in.content_set_guid));
		NDR_CHECK(ndr_push_frstrans_VersionRequestType(ndr, NDR_SCALARS, r->in.request_type));
		NDR_CHECK(ndr_push_frstrans_VersionChangeType(ndr, NDR_SCALARS, r->in.change_type));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->in.vv_generation));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_RequestVersionVector(struct ndr_pull *ndr, ndr_flags_type flags, struct frstrans_RequestVersionVector *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.sequence_number));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->in.connection_guid));
		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->in.content_set_guid));
		NDR_CHECK(ndr_pull_frstrans_VersionRequestType(ndr, NDR_SCALARS, &r->in.request_type));
		if (r->in.request_type > 2) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%d) out of range (%d - %d)", (int)(r->in.request_type), (int)(0), (int)(2));
		}
		NDR_CHECK(ndr_pull_frstrans_VersionChangeType(ndr, NDR_SCALARS, &r->in.change_type));
		if (r->in.change_type > 2) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%d) out of range (%d - %d)", (int)(r->in.change_type), (int)(0), (int)(2));
		}
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->in.vv_generation));
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_RequestVersionVector(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct frstrans_RequestVersionVector *r)
{
	ndr_print_struct(ndr, name, "frstrans_RequestVersionVector");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "frstrans_RequestVersionVector");
		ndr->depth++;
		ndr_print_uint32(ndr, "sequence_number", r->in.sequence_number);
		ndr_print_GUID(ndr, "connection_guid", &r->in.connection_guid);
		ndr_print_GUID(ndr, "content_set_guid", &r->in.content_set_guid);
		ndr_print_frstrans_VersionRequestType(ndr, "request_type", r->in.request_type);
		ndr_print_frstrans_VersionChangeType(ndr, "change_type", r->in.change_type);
		ndr_print_hyper(ndr, "vv_generation", r->in.vv_generation);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "frstrans_RequestVersionVector");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frstrans_AsyncPoll(struct ndr_push *ndr, ndr_flags_type flags, const struct frstrans_AsyncPoll *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->in.connection_guid));
	}
	if (flags & NDR_OUT) {
		if (r->out.response == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_frstrans_AsyncResponseContext(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.response));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_AsyncPoll(struct ndr_pull *ndr, ndr_flags_type flags, struct frstrans_AsyncPoll *r)
{
	TALLOC_CTX *_mem_save_response_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->in.connection_guid));
		NDR_PULL_ALLOC(ndr, r->out.response);
		NDR_ZERO_STRUCTP(r->out.response);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.response);
		}
		_mem_save_response_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.response, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_frstrans_AsyncResponseContext(ndr, NDR_SCALARS|NDR_BUFFERS, r->out.response));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_response_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_AsyncPoll(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct frstrans_AsyncPoll *r)
{
	ndr_print_struct(ndr, name, "frstrans_AsyncPoll");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "frstrans_AsyncPoll");
		ndr->depth++;
		ndr_print_GUID(ndr, "connection_guid", &r->in.connection_guid);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "frstrans_AsyncPoll");
		ndr->depth++;
		ndr_print_ptr(ndr, "response", r->out.response);
		ndr->depth++;
		ndr_print_frstrans_AsyncResponseContext(ndr, "response", r->out.response);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_FRSTRANS_REQUEST_RECORDS(struct ndr_push *ndr, ndr_flags_type flags, const struct FRSTRANS_REQUEST_RECORDS *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_FRSTRANS_REQUEST_RECORDS(struct ndr_pull *ndr, ndr_flags_type flags, struct FRSTRANS_REQUEST_RECORDS *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_FRSTRANS_REQUEST_RECORDS(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct FRSTRANS_REQUEST_RECORDS *r)
{
	ndr_print_struct(ndr, name, "FRSTRANS_REQUEST_RECORDS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "FRSTRANS_REQUEST_RECORDS");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "FRSTRANS_REQUEST_RECORDS");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_FRSTRANS_UPDATE_CANCEL(struct ndr_push *ndr, ndr_flags_type flags, const struct FRSTRANS_UPDATE_CANCEL *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_FRSTRANS_UPDATE_CANCEL(struct ndr_pull *ndr, ndr_flags_type flags, struct FRSTRANS_UPDATE_CANCEL *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_FRSTRANS_UPDATE_CANCEL(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct FRSTRANS_UPDATE_CANCEL *r)
{
	ndr_print_struct(ndr, name, "FRSTRANS_UPDATE_CANCEL");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "FRSTRANS_UPDATE_CANCEL");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "FRSTRANS_UPDATE_CANCEL");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_FRSTRANS_RAW_GET_FILE_DATA(struct ndr_push *ndr, ndr_flags_type flags, const struct FRSTRANS_RAW_GET_FILE_DATA *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_FRSTRANS_RAW_GET_FILE_DATA(struct ndr_pull *ndr, ndr_flags_type flags, struct FRSTRANS_RAW_GET_FILE_DATA *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_FRSTRANS_RAW_GET_FILE_DATA(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct FRSTRANS_RAW_GET_FILE_DATA *r)
{
	ndr_print_struct(ndr, name, "FRSTRANS_RAW_GET_FILE_DATA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "FRSTRANS_RAW_GET_FILE_DATA");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "FRSTRANS_RAW_GET_FILE_DATA");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_FRSTRANS_RDC_GET_SIGNATURES(struct ndr_push *ndr, ndr_flags_type flags, const struct FRSTRANS_RDC_GET_SIGNATURES *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_FRSTRANS_RDC_GET_SIGNATURES(struct ndr_pull *ndr, ndr_flags_type flags, struct FRSTRANS_RDC_GET_SIGNATURES *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_FRSTRANS_RDC_GET_SIGNATURES(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct FRSTRANS_RDC_GET_SIGNATURES *r)
{
	ndr_print_struct(ndr, name, "FRSTRANS_RDC_GET_SIGNATURES");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "FRSTRANS_RDC_GET_SIGNATURES");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "FRSTRANS_RDC_GET_SIGNATURES");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_FRSTRANS_RDC_PUSH_SOURCE_NEEDS(struct ndr_push *ndr, ndr_flags_type flags, const struct FRSTRANS_RDC_PUSH_SOURCE_NEEDS *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_FRSTRANS_RDC_PUSH_SOURCE_NEEDS(struct ndr_pull *ndr, ndr_flags_type flags, struct FRSTRANS_RDC_PUSH_SOURCE_NEEDS *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_FRSTRANS_RDC_PUSH_SOURCE_NEEDS(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct FRSTRANS_RDC_PUSH_SOURCE_NEEDS *r)
{
	ndr_print_struct(ndr, name, "FRSTRANS_RDC_PUSH_SOURCE_NEEDS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "FRSTRANS_RDC_PUSH_SOURCE_NEEDS");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "FRSTRANS_RDC_PUSH_SOURCE_NEEDS");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_FRSTRANS_RDC_GET_FILE_DATA(struct ndr_push *ndr, ndr_flags_type flags, const struct FRSTRANS_RDC_GET_FILE_DATA *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_FRSTRANS_RDC_GET_FILE_DATA(struct ndr_pull *ndr, ndr_flags_type flags, struct FRSTRANS_RDC_GET_FILE_DATA *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_FRSTRANS_RDC_GET_FILE_DATA(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct FRSTRANS_RDC_GET_FILE_DATA *r)
{
	ndr_print_struct(ndr, name, "FRSTRANS_RDC_GET_FILE_DATA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "FRSTRANS_RDC_GET_FILE_DATA");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "FRSTRANS_RDC_GET_FILE_DATA");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frstrans_RdcClose(struct ndr_push *ndr, ndr_flags_type flags, const struct frstrans_RdcClose *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.server_context == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.server_context));
	}
	if (flags & NDR_OUT) {
		if (r->out.server_context == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.server_context));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_RdcClose(struct ndr_pull *ndr, ndr_flags_type flags, struct frstrans_RdcClose *r)
{
	TALLOC_CTX *_mem_save_server_context_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.server_context);
		}
		_mem_save_server_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.server_context, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.server_context));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_context_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_PULL_ALLOC(ndr, r->out.server_context);
		*r->out.server_context = *r->in.server_context;
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.server_context == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.server_context);
			NDR_ZERO_STRUCTP(r->in.server_context);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.server_context);
		}
		_mem_save_server_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.server_context, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.server_context));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_context_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_RdcClose(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct frstrans_RdcClose *r)
{
	ndr_print_struct(ndr, name, "frstrans_RdcClose");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "frstrans_RdcClose");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_context", r->in.server_context);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "server_context", r->in.server_context);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "frstrans_RdcClose");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_context", r->out.server_context);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "server_context", r->out.server_context);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frstrans_InitializeFileTransferAsync(struct ndr_push *ndr, ndr_flags_type flags, const struct frstrans_InitializeFileTransferAsync *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.frs_update == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->in.staging_policy == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_GUID(ndr, NDR_SCALARS, &r->in.connection_guid));
		NDR_CHECK(ndr_push_frstrans_Update(ndr, NDR_SCALARS, r->in.frs_update));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.rdc_desired));
		NDR_CHECK(ndr_push_frstrans_RequestedStagingPolicy(ndr, NDR_SCALARS, *r->in.staging_policy));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.buffer_size));
	}
	if (flags & NDR_OUT) {
		if (r->out.frs_update == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.staging_policy == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.server_context == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.rdc_file_info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.data_buffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.size_read == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		if (r->out.is_end_of_file == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_frstrans_Update(ndr, NDR_SCALARS, r->out.frs_update));
		NDR_CHECK(ndr_push_frstrans_RequestedStagingPolicy(ndr, NDR_SCALARS, *r->out.staging_policy));
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->out.server_context));
		NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.rdc_file_info));
		if (*r->out.rdc_file_info) {
			NDR_CHECK(ndr_push_frstrans_RdcFileInfo(ndr, NDR_SCALARS, *r->out.rdc_file_info));
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, r->in.buffer_size));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.size_read));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.data_buffer, *r->out.size_read));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.size_read));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.is_end_of_file));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_InitializeFileTransferAsync(struct ndr_pull *ndr, ndr_flags_type flags, struct frstrans_InitializeFileTransferAsync *r)
{
	uint32_t _ptr_rdc_file_info;
	uint32_t size_data_buffer_1 = 0;
	uint32_t length_data_buffer_1 = 0;
	TALLOC_CTX *_mem_save_frs_update_0 = NULL;
	TALLOC_CTX *_mem_save_staging_policy_0 = NULL;
	TALLOC_CTX *_mem_save_server_context_0 = NULL;
	TALLOC_CTX *_mem_save_rdc_file_info_0 = NULL;
	TALLOC_CTX *_mem_save_rdc_file_info_1 = NULL;
	TALLOC_CTX *_mem_save_size_read_0 = NULL;
	TALLOC_CTX *_mem_save_is_end_of_file_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_GUID(ndr, NDR_SCALARS, &r->in.connection_guid));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.frs_update);
		}
		_mem_save_frs_update_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.frs_update, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_frstrans_Update(ndr, NDR_SCALARS, r->in.frs_update));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_frs_update_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.rdc_desired));
		if (r->in.rdc_desired > 1) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.rdc_desired), (uint32_t)(0), (uint32_t)(1));
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.staging_policy);
		}
		_mem_save_staging_policy_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.staging_policy, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_frstrans_RequestedStagingPolicy(ndr, NDR_SCALARS, r->in.staging_policy));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_staging_policy_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.buffer_size));
		if (r->in.buffer_size > 262144) {
			return ndr_pull_error(ndr, NDR_ERR_RANGE, "value (%"PRIu32") out of range (%"PRIu32" - %"PRIu32")", (uint32_t)(r->in.buffer_size), (uint32_t)(0), (uint32_t)(262144));
		}
		NDR_PULL_ALLOC(ndr, r->out.frs_update);
		*r->out.frs_update = *r->in.frs_update;
		NDR_PULL_ALLOC(ndr, r->out.staging_policy);
		*r->out.staging_policy = *r->in.staging_policy;
		NDR_PULL_ALLOC(ndr, r->out.server_context);
		NDR_ZERO_STRUCTP(r->out.server_context);
		NDR_PULL_ALLOC(ndr, r->out.rdc_file_info);
		NDR_ZERO_STRUCTP(r->out.rdc_file_info);
		NDR_PULL_ALLOC_N(ndr, r->out.data_buffer, r->in.buffer_size);
		memset(r->out.data_buffer, 0, (r->in.buffer_size) * sizeof(*r->out.data_buffer));
		NDR_PULL_ALLOC(ndr, r->out.size_read);
		NDR_ZERO_STRUCTP(r->out.size_read);
		NDR_PULL_ALLOC(ndr, r->out.is_end_of_file);
		NDR_ZERO_STRUCTP(r->out.is_end_of_file);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.frs_update == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.frs_update);
			NDR_ZERO_STRUCTP(r->in.frs_update);
		}
		if (r->in.staging_policy == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.staging_policy);
			NDR_ZERO_STRUCTP(r->in.staging_policy);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.frs_update);
		}
		_mem_save_frs_update_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.frs_update, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_frstrans_Update(ndr, NDR_SCALARS, r->out.frs_update));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_frs_update_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.staging_policy);
		}
		_mem_save_staging_policy_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.staging_policy, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_frstrans_RequestedStagingPolicy(ndr, NDR_SCALARS, r->out.staging_policy));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_staging_policy_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.server_context);
		}
		_mem_save_server_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.server_context, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->out.server_context));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_context_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.rdc_file_info);
		}
		_mem_save_rdc_file_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.rdc_file_info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_rdc_file_info));
		if (_ptr_rdc_file_info) {
			NDR_PULL_ALLOC(ndr, *r->out.rdc_file_info);
		} else {
			*r->out.rdc_file_info = NULL;
		}
		if (*r->out.rdc_file_info) {
			_mem_save_rdc_file_info_1 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, *r->out.rdc_file_info, 0);
			NDR_CHECK(ndr_pull_frstrans_RdcFileInfo(ndr, NDR_SCALARS, *r->out.rdc_file_info));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rdc_file_info_1, 0);
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_rdc_file_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.data_buffer));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.data_buffer));
		NDR_CHECK(ndr_get_array_size(ndr, (void*)&r->out.data_buffer, &size_data_buffer_1));
		NDR_CHECK(ndr_get_array_length(ndr, (void*)&r->out.data_buffer, &length_data_buffer_1));
		if (length_data_buffer_1 > size_data_buffer_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %"PRIu32": should exceed array length %"PRIu32"", size_data_buffer_1, length_data_buffer_1);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.data_buffer, size_data_buffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.data_buffer, length_data_buffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.size_read);
		}
		_mem_save_size_read_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.size_read, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.size_read));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_size_read_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.is_end_of_file);
		}
		_mem_save_is_end_of_file_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.is_end_of_file, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.is_end_of_file));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_is_end_of_file_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.data_buffer) {
			NDR_CHECK(ndr_check_steal_array_size(ndr, (void*)&r->out.data_buffer, r->in.buffer_size));
		}
		if (r->out.data_buffer) {
			NDR_CHECK(ndr_check_steal_array_length(ndr, (void*)&r->out.data_buffer, *r->out.size_read));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_InitializeFileTransferAsync(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct frstrans_InitializeFileTransferAsync *r)
{
	ndr_print_struct(ndr, name, "frstrans_InitializeFileTransferAsync");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "frstrans_InitializeFileTransferAsync");
		ndr->depth++;
		ndr_print_GUID(ndr, "connection_guid", &r->in.connection_guid);
		ndr_print_ptr(ndr, "frs_update", r->in.frs_update);
		ndr->depth++;
		ndr_print_frstrans_Update(ndr, "frs_update", r->in.frs_update);
		ndr->depth--;
		ndr_print_uint32(ndr, "rdc_desired", r->in.rdc_desired);
		ndr_print_ptr(ndr, "staging_policy", r->in.staging_policy);
		ndr->depth++;
		ndr_print_frstrans_RequestedStagingPolicy(ndr, "staging_policy", *r->in.staging_policy);
		ndr->depth--;
		ndr_print_uint32(ndr, "buffer_size", r->in.buffer_size);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "frstrans_InitializeFileTransferAsync");
		ndr->depth++;
		ndr_print_ptr(ndr, "frs_update", r->out.frs_update);
		ndr->depth++;
		ndr_print_frstrans_Update(ndr, "frs_update", r->out.frs_update);
		ndr->depth--;
		ndr_print_ptr(ndr, "staging_policy", r->out.staging_policy);
		ndr->depth++;
		ndr_print_frstrans_RequestedStagingPolicy(ndr, "staging_policy", *r->out.staging_policy);
		ndr->depth--;
		ndr_print_ptr(ndr, "server_context", r->out.server_context);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "server_context", r->out.server_context);
		ndr->depth--;
		ndr_print_ptr(ndr, "rdc_file_info", r->out.rdc_file_info);
		ndr->depth++;
		ndr_print_ptr(ndr, "rdc_file_info", *r->out.rdc_file_info);
		ndr->depth++;
		if (*r->out.rdc_file_info) {
			ndr_print_frstrans_RdcFileInfo(ndr, "rdc_file_info", *r->out.rdc_file_info);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "data_buffer", r->out.data_buffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "data_buffer", r->out.data_buffer, *r->out.size_read);
		ndr->depth--;
		ndr_print_ptr(ndr, "size_read", r->out.size_read);
		ndr->depth++;
		ndr_print_uint32(ndr, "size_read", *r->out.size_read);
		ndr->depth--;
		ndr_print_ptr(ndr, "is_end_of_file", r->out.is_end_of_file);
		ndr->depth++;
		ndr_print_uint32(ndr, "is_end_of_file", *r->out.is_end_of_file);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE(struct ndr_push *ndr, ndr_flags_type flags, const struct FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE(struct ndr_pull *ndr, ndr_flags_type flags, struct FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE *r)
{
	ndr_print_struct(ndr, name, "FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE");
		ndr->depth++;
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frstrans_RawGetFileDataAsync(struct ndr_push *ndr, ndr_flags_type flags, const struct frstrans_RawGetFileDataAsync *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.server_context == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.server_context));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_RawGetFileDataAsync(struct ndr_pull *ndr, ndr_flags_type flags, struct frstrans_RawGetFileDataAsync *r)
{
	TALLOC_CTX *_mem_save_server_context_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.server_context);
		}
		_mem_save_server_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.server_context, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.server_context));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_context_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.server_context == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.server_context);
			NDR_ZERO_STRUCTP(r->in.server_context);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_RawGetFileDataAsync(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct frstrans_RawGetFileDataAsync *r)
{
	ndr_print_struct(ndr, name, "frstrans_RawGetFileDataAsync");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "frstrans_RawGetFileDataAsync");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_context", r->in.server_context);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "server_context", r->in.server_context);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "frstrans_RawGetFileDataAsync");
		ndr->depth++;
		ndr_print_ptr(ndr, "byte_pipe", r->out.byte_pipe);
		ndr->depth++;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_frstrans_RdcGetFileDataAsync(struct ndr_push *ndr, ndr_flags_type flags, const struct frstrans_RdcGetFileDataAsync *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.server_context == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_policy_handle(ndr, NDR_SCALARS, r->in.server_context));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_frstrans_RdcGetFileDataAsync(struct ndr_pull *ndr, ndr_flags_type flags, struct frstrans_RdcGetFileDataAsync *r)
{
	TALLOC_CTX *_mem_save_server_context_0 = NULL;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_ZERO_STRUCT(r->out);

		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.server_context);
		}
		_mem_save_server_context_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.server_context, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_policy_handle(ndr, NDR_SCALARS, r->in.server_context));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_server_context_0, LIBNDR_FLAG_REF_ALLOC);
	}
	if (flags & NDR_OUT) {
#ifdef FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION
		if (r->in.server_context == NULL) {
			NDR_PULL_ALLOC(ndr, r->in.server_context);
			NDR_ZERO_STRUCTP(r->in.server_context);
		}
#endif /* FUZZING_BUILD_MODE_UNSAFE_FOR_PRODUCTION */
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_frstrans_RdcGetFileDataAsync(struct ndr_print *ndr, const char *name, ndr_flags_type flags, const struct frstrans_RdcGetFileDataAsync *r)
{
	ndr_print_struct(ndr, name, "frstrans_RdcGetFileDataAsync");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "frstrans_RdcGetFileDataAsync");
		ndr->depth++;
		ndr_print_ptr(ndr, "server_context", r->in.server_context);
		ndr->depth++;
		ndr_print_policy_handle(ndr, "server_context", r->in.server_context);
		ndr->depth--;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "frstrans_RdcGetFileDataAsync");
		ndr->depth++;
		ndr_print_ptr(ndr, "byte_pipe", r->out.byte_pipe);
		ndr->depth++;
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

#ifndef SKIP_NDR_TABLE_frstrans
static const struct ndr_interface_call_pipe frstrans_RawGetFileDataAsync_out_pipes[] = {
	{
		"out.byte_pipe",
		"frstrans_BytePipe_chunk",
		sizeof(struct frstrans_BytePipe_chunk),
		(ndr_push_flags_fn_t) ndr_push_frstrans_BytePipe_chunk,
		(ndr_pull_flags_fn_t) ndr_pull_frstrans_BytePipe_chunk,
		(ndr_print_fn_t) ndr_print_frstrans_BytePipe_chunk,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call_pipe frstrans_RdcGetFileDataAsync_out_pipes[] = {
	{
		"out.byte_pipe",
		"frstrans_BytePipe_chunk",
		sizeof(struct frstrans_BytePipe_chunk),
		(ndr_push_flags_fn_t) ndr_push_frstrans_BytePipe_chunk,
		(ndr_pull_flags_fn_t) ndr_pull_frstrans_BytePipe_chunk,
		(ndr_print_fn_t) ndr_print_frstrans_BytePipe_chunk,
	},
	{ .name = NULL }
};

static const struct ndr_interface_public_struct frstrans_public_structs[] = {
	{
		.name = "frstrans_VersionVector",
		.struct_size = sizeof(struct frstrans_VersionVector ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_frstrans_VersionVector,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_frstrans_VersionVector,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_frstrans_VersionVector,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call frstrans_calls[] = {
	{
		"frstrans_CheckConnectivity",
		sizeof(struct frstrans_CheckConnectivity),
		(ndr_push_flags_fn_t) ndr_push_frstrans_CheckConnectivity,
		(ndr_pull_flags_fn_t) ndr_pull_frstrans_CheckConnectivity,
		(ndr_print_function_t) ndr_print_frstrans_CheckConnectivity,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"frstrans_EstablishConnection",
		sizeof(struct frstrans_EstablishConnection),
		(ndr_push_flags_fn_t) ndr_push_frstrans_EstablishConnection,
		(ndr_pull_flags_fn_t) ndr_pull_frstrans_EstablishConnection,
		(ndr_print_function_t) ndr_print_frstrans_EstablishConnection,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"frstrans_EstablishSession",
		sizeof(struct frstrans_EstablishSession),
		(ndr_push_flags_fn_t) ndr_push_frstrans_EstablishSession,
		(ndr_pull_flags_fn_t) ndr_pull_frstrans_EstablishSession,
		(ndr_print_function_t) ndr_print_frstrans_EstablishSession,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"frstrans_RequestUpdates",
		sizeof(struct frstrans_RequestUpdates),
		(ndr_push_flags_fn_t) ndr_push_frstrans_RequestUpdates,
		(ndr_pull_flags_fn_t) ndr_pull_frstrans_RequestUpdates,
		(ndr_print_function_t) ndr_print_frstrans_RequestUpdates,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"frstrans_RequestVersionVector",
		sizeof(struct frstrans_RequestVersionVector),
		(ndr_push_flags_fn_t) ndr_push_frstrans_RequestVersionVector,
		(ndr_pull_flags_fn_t) ndr_pull_frstrans_RequestVersionVector,
		(ndr_print_function_t) ndr_print_frstrans_RequestVersionVector,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"frstrans_AsyncPoll",
		sizeof(struct frstrans_AsyncPoll),
		(ndr_push_flags_fn_t) ndr_push_frstrans_AsyncPoll,
		(ndr_pull_flags_fn_t) ndr_pull_frstrans_AsyncPoll,
		(ndr_print_function_t) ndr_print_frstrans_AsyncPoll,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"FRSTRANS_REQUEST_RECORDS",
		sizeof(struct FRSTRANS_REQUEST_RECORDS),
		(ndr_push_flags_fn_t) ndr_push_FRSTRANS_REQUEST_RECORDS,
		(ndr_pull_flags_fn_t) ndr_pull_FRSTRANS_REQUEST_RECORDS,
		(ndr_print_function_t) ndr_print_FRSTRANS_REQUEST_RECORDS,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"FRSTRANS_UPDATE_CANCEL",
		sizeof(struct FRSTRANS_UPDATE_CANCEL),
		(ndr_push_flags_fn_t) ndr_push_FRSTRANS_UPDATE_CANCEL,
		(ndr_pull_flags_fn_t) ndr_pull_FRSTRANS_UPDATE_CANCEL,
		(ndr_print_function_t) ndr_print_FRSTRANS_UPDATE_CANCEL,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"FRSTRANS_RAW_GET_FILE_DATA",
		sizeof(struct FRSTRANS_RAW_GET_FILE_DATA),
		(ndr_push_flags_fn_t) ndr_push_FRSTRANS_RAW_GET_FILE_DATA,
		(ndr_pull_flags_fn_t) ndr_pull_FRSTRANS_RAW_GET_FILE_DATA,
		(ndr_print_function_t) ndr_print_FRSTRANS_RAW_GET_FILE_DATA,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"FRSTRANS_RDC_GET_SIGNATURES",
		sizeof(struct FRSTRANS_RDC_GET_SIGNATURES),
		(ndr_push_flags_fn_t) ndr_push_FRSTRANS_RDC_GET_SIGNATURES,
		(ndr_pull_flags_fn_t) ndr_pull_FRSTRANS_RDC_GET_SIGNATURES,
		(ndr_print_function_t) ndr_print_FRSTRANS_RDC_GET_SIGNATURES,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"FRSTRANS_RDC_PUSH_SOURCE_NEEDS",
		sizeof(struct FRSTRANS_RDC_PUSH_SOURCE_NEEDS),
		(ndr_push_flags_fn_t) ndr_push_FRSTRANS_RDC_PUSH_SOURCE_NEEDS,
		(ndr_pull_flags_fn_t) ndr_pull_FRSTRANS_RDC_PUSH_SOURCE_NEEDS,
		(ndr_print_function_t) ndr_print_FRSTRANS_RDC_PUSH_SOURCE_NEEDS,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"FRSTRANS_RDC_GET_FILE_DATA",
		sizeof(struct FRSTRANS_RDC_GET_FILE_DATA),
		(ndr_push_flags_fn_t) ndr_push_FRSTRANS_RDC_GET_FILE_DATA,
		(ndr_pull_flags_fn_t) ndr_pull_FRSTRANS_RDC_GET_FILE_DATA,
		(ndr_print_function_t) ndr_print_FRSTRANS_RDC_GET_FILE_DATA,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"frstrans_RdcClose",
		sizeof(struct frstrans_RdcClose),
		(ndr_push_flags_fn_t) ndr_push_frstrans_RdcClose,
		(ndr_pull_flags_fn_t) ndr_pull_frstrans_RdcClose,
		(ndr_print_function_t) ndr_print_frstrans_RdcClose,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"frstrans_InitializeFileTransferAsync",
		sizeof(struct frstrans_InitializeFileTransferAsync),
		(ndr_push_flags_fn_t) ndr_push_frstrans_InitializeFileTransferAsync,
		(ndr_pull_flags_fn_t) ndr_pull_frstrans_InitializeFileTransferAsync,
		(ndr_print_function_t) ndr_print_frstrans_InitializeFileTransferAsync,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE",
		sizeof(struct FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE),
		(ndr_push_flags_fn_t) ndr_push_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE,
		(ndr_pull_flags_fn_t) ndr_pull_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE,
		(ndr_print_function_t) ndr_print_FRSTRANS_OPNUM_0E_NOT_USED_ON_THE_WIRE,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"frstrans_RawGetFileDataAsync",
		sizeof(struct frstrans_RawGetFileDataAsync),
		(ndr_push_flags_fn_t) ndr_push_frstrans_RawGetFileDataAsync,
		(ndr_pull_flags_fn_t) ndr_pull_frstrans_RawGetFileDataAsync,
		(ndr_print_function_t) ndr_print_frstrans_RawGetFileDataAsync,
		{ 0, NULL },
		{ 1, frstrans_RawGetFileDataAsync_out_pipes },
	},
	{
		"frstrans_RdcGetFileDataAsync",
		sizeof(struct frstrans_RdcGetFileDataAsync),
		(ndr_push_flags_fn_t) ndr_push_frstrans_RdcGetFileDataAsync,
		(ndr_pull_flags_fn_t) ndr_pull_frstrans_RdcGetFileDataAsync,
		(ndr_print_function_t) ndr_print_frstrans_RdcGetFileDataAsync,
		{ 0, NULL },
		{ 1, frstrans_RdcGetFileDataAsync_out_pipes },
	},
	{ .name = NULL }
};

static const char * const frstrans_endpoint_strings[] = {
	"ncacn_ip_tcp:", 
	"ncalrpc:", 
};

static const struct ndr_interface_string_array frstrans_endpoints = {
	.count	= 2,
	.names	= frstrans_endpoint_strings
};

static const char * const frstrans_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array frstrans_authservices = {
	.count	= 1,
	.names	= frstrans_authservice_strings
};


const struct ndr_interface_table ndr_table_frstrans = {
	.name		= "frstrans",
	.syntax_id	= {
		{0x897e2e5f,0x93f3,0x4376,{0x9c,0x9c},{0xfd,0x22,0x77,0x49,0x5c,0x27}},
		NDR_FRSTRANS_VERSION
	},
	.helpstring	= NDR_FRSTRANS_HELPSTRING,
	.num_calls	= 17,
	.calls		= frstrans_calls,
	.num_public_structs	= 1,
	.public_structs		= frstrans_public_structs,
	.endpoints	= &frstrans_endpoints,
	.authservices	= &frstrans_authservices
};

#endif /* SKIP_NDR_TABLE_frstrans */
