#ifndef __SOURCE4_WINBIND_IDMAP_PROTO_H__
#define __SOURCE4_WINBIND_IDMAP_PROTO_H__

#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2) PRINTF_ATTRIBUTE(a1, a2)
/* This file was automatically generated by mkproto.pl. DO NOT EDIT */

/* this file contains prototypes for functions that are private 
 * to this subsystem or library. These functions should not be 
 * used outside this particular subsystem! */


/* The following definitions come from ../../source4/winbind/idmap.c  */


/**
 * Initialize idmap context
 *
 * talloc_free to close.
 *
 * \param mem_ctx talloc context to use.
 * \return allocated idmap_context on success, NULL on error
 */
struct idmap_context *idmap_init(TALLOC_CTX *mem_ctx,
				 struct tevent_context *ev_ctx,
				 struct loadparm_context *lp_ctx);

/**
 * Convert an array of unixids to the corresponding array of SIDs
 *
 * \param idmap_ctx idmap context to use
 * \param mem_ctx talloc context the memory for the dom_sids is allocated
 * from.
 * \param count length of id_mapping array.
 * \param id array of id_mappings.
 * \return NT_STATUS_OK on success, NT_STATUS_NONE_MAPPED if mapping is not
 * possible at all, NT_STATUS_SOME_UNMAPPED if some mappings worked and some
 * did not.
 */
NTSTATUS idmap_xids_to_sids(struct idmap_context *idmap_ctx,
			    TALLOC_CTX *mem_ctx,
			    struct id_map **id);

/**
 * Convert an array of SIDs to the corresponding array of unixids
 *
 * \param idmap_ctx idmap context to use
 * \param mem_ctx talloc context the memory for the unixids is allocated
 * from.
 * \param count length of id_mapping array.
 * \param id array of id_mappings.
 * \return NT_STATUS_OK on success, NT_STATUS_NONE_MAPPED if mapping is not
 * possible at all, NT_STATUS_SOME_UNMAPPED if some mappings worked and some
 * did not.
 */
NTSTATUS idmap_sids_to_xids(struct idmap_context *idmap_ctx,
			    TALLOC_CTX *mem_ctx,
			    struct id_map **id);
#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2)

#endif /* __SOURCE4_WINBIND_IDMAP_PROTO_H__ */

