
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "cutterbindings_python.h"

// main header
#include "configuration_wrapper.h"

// Wrappers providing overrides
#include "mainwindow_wrapper.h"
#include "cutterdockwidget_wrapper.h"

// Argument includes
#include <Configuration.h>
#include <QString>
#include <QStringList>
#include <qcolor.h>
#include <qfont.h>
#include <qlocale.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpoint.h>
#include <qvariant.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_Configuration_Type = nullptr;
static PyTypeObject *Sbk_Configuration_TypeF(void)
{
    return _Sbk_Configuration_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void ConfigurationWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

void ConfigurationWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Configuration_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    MainWindowWrapper::sbk_o_childEvent("Configuration", funcName, gil, pyOverride, event);
}

void ConfigurationWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Configuration_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    MainWindowWrapper::sbk_o_connectNotify("Configuration", funcName, gil, pyOverride, signal);
}

void ConfigurationWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Configuration_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    MainWindowWrapper::sbk_o_customEvent("Configuration", funcName, gil, pyOverride, event);
}

void ConfigurationWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Configuration_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    MainWindowWrapper::sbk_o_connectNotify("Configuration", funcName, gil, pyOverride, signal);
}

bool ConfigurationWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Configuration_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return CutterDockWidgetWrapper::sbk_o_event("Configuration", funcName, gil, pyOverride, event);
}

bool ConfigurationWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Configuration_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return CutterDockWidgetWrapper::sbk_o_eventFilter("Configuration", funcName, gil, pyOverride, watched, event);
}

void ConfigurationWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Configuration_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    MainWindowWrapper::sbk_o_timerEvent("Configuration", funcName, gil, pyOverride, event);
}

const QMetaObject *ConfigurationWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Configuration::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int ConfigurationWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Configuration::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *ConfigurationWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< ConfigurationWrapper *>(this));
    }
    return Configuration::qt_metacast(_clname);
}

ConfigurationWrapper::~ConfigurationWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_Configuration_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int Sbk_Configuration_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNonConstructible("Configuration");
    return -1;
}

static PyObject *Sbk_ConfigurationFunc_addRecentProject(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::addRecentProject(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // addRecentProject(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addRecentProject", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addRecentProject(QString)
            cppSelf->addRecentProject(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_adjustColorThemeDarkness(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // adjustColorThemeDarkness()
        cppSelf->adjustColorThemeDarkness();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_colorThemeDarkness(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::colorThemeDarkness(QString)const->int
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // colorThemeDarkness(QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "colorThemeDarkness", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // colorThemeDarkness(QString)const
            int cppResult = const_cast<const ::Configuration *>(cppSelf)->colorThemeDarkness(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_createSyntaxHighlighter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::createSyntaxHighlighter(QTextDocument*)->QSyntaxHighlighter*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QTextDocument_IDX]), (pyArg)))) {
        overloadId = 0; // createSyntaxHighlighter(QTextDocument*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "createSyntaxHighlighter", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextDocument *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // createSyntaxHighlighter(QTextDocument*)
            QSyntaxHighlighter * cppResult = cppSelf->createSyntaxHighlighter(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QSyntaxHighlighter_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_enableDecompilerAnnotationHighlighter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::enableDecompilerAnnotationHighlighter(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // enableDecompilerAnnotationHighlighter(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "enableDecompilerAnnotationHighlighter", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // enableDecompilerAnnotationHighlighter(bool)
            cppSelf->enableDecompilerAnnotationHighlighter(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_getAutoUpdateEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getAutoUpdateEnabled()const
        bool cppResult = const_cast<const ::Configuration *>(cppSelf)->getAutoUpdateEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getAvailableTranslations(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getAvailableTranslations()
        QStringList cppResult = cppSelf->getAvailableTranslations();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getBaseFont(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getBaseFont()const
        const QFont cppResult = const_cast<const ::Configuration *>(cppSelf)->getBaseFont();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFont_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getBitmapExportScaleFactor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getBitmapExportScaleFactor()
        double cppResult = cppSelf->getBitmapExportScaleFactor();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getBitmapTransparentState(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getBitmapTransparentState()
        bool cppResult = cppSelf->getBitmapTransparentState();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::getColor(QString)const->const QColor
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // getColor(QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getColor", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getColor(QString)const
            const QColor cppResult = const_cast<const ::Configuration *>(cppSelf)->getColor(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getColorTheme(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getColorTheme()const
        QString cppResult = const_cast<const ::Configuration *>(cppSelf)->getColorTheme();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getConfigBool(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::getConfigBool(QString)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // getConfigBool(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getConfigBool", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getConfigBool(QString)
            bool cppResult = cppSelf->getConfigBool(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getConfigInt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::getConfigInt(QString)->int
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // getConfigInt(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getConfigInt", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getConfigInt(QString)
            int cppResult = cppSelf->getConfigInt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getConfigString(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::getConfigString(QString)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // getConfigString(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getConfigString", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getConfigString(QString)
            QString cppResult = cppSelf->getConfigString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getConfigVar(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::getConfigVar(QString)->QVariant
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // getConfigVar(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getConfigVar", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getConfigVar(QString)
            QVariant cppResult = cppSelf->getConfigVar(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getCurrLocale(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getCurrLocale()const
        QLocale cppResult = const_cast<const ::Configuration *>(cppSelf)->getCurrLocale();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QLocale_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getDecompilerAutoRefreshEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getDecompilerAutoRefreshEnabled()
        bool cppResult = cppSelf->getDecompilerAutoRefreshEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getFont(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getFont()const
        const QFont cppResult = const_cast<const ::Configuration *>(cppSelf)->getFont();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFont_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getFunctionsWidgetLayout(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getFunctionsWidgetLayout()
        QString cppResult = cppSelf->getFunctionsWidgetLayout();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getGraphBlockEntryOffset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getGraphBlockEntryOffset()
        bool cppResult = cppSelf->getGraphBlockEntryOffset();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getGraphBlockMaxChars(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getGraphBlockMaxChars()const
        int cppResult = const_cast<const ::Configuration *>(cppSelf)->getGraphBlockMaxChars();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getGraphBlockSpacing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getGraphBlockSpacing()
        QPoint cppResult = cppSelf->getGraphBlockSpacing();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPoint_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getGraphEdgeSpacing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getGraphEdgeSpacing()
        QPoint cppResult = cppSelf->getGraphEdgeSpacing();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPoint_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getGraphMinFontSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getGraphMinFontSize()const
        int cppResult = const_cast<const ::Configuration *>(cppSelf)->getGraphMinFontSize();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getGraphPreview(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getGraphPreview()
        bool cppResult = cppSelf->getGraphPreview();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getInterfaceTheme(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getInterfaceTheme()
        int cppResult = cppSelf->getInterfaceTheme();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getLogoFile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getLogoFile()
        QString cppResult = cppSelf->getLogoFile();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getNewFileLastClicked(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getNewFileLastClicked()
        int cppResult = cppSelf->getNewFileLastClicked();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getOutputRedirectionEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getOutputRedirectionEnabled()const
        bool cppResult = const_cast<const ::Configuration *>(cppSelf)->getOutputRedirectionEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getPreviewValue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getPreviewValue()const
        bool cppResult = const_cast<const ::Configuration *>(cppSelf)->getPreviewValue();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getRecentFiles(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getRecentFiles()const
        QStringList cppResult = const_cast<const ::Configuration *>(cppSelf)->getRecentFiles();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getRecentFolder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getRecentFolder()
        QString cppResult = cppSelf->getRecentFolder();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getRecentProjects(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getRecentProjects()const
        QStringList cppResult = const_cast<const ::Configuration *>(cppSelf)->getRecentProjects();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getSelectedDecompiler(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getSelectedDecompiler()
        QString cppResult = cppSelf->getSelectedDecompiler();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getShowVarTooltips(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getShowVarTooltips()const
        bool cppResult = const_cast<const ::Configuration *>(cppSelf)->getShowVarTooltips();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_getZoomFactor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getZoomFactor()const
        qreal cppResult = const_cast<const ::Configuration *>(cppSelf)->getZoomFactor();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_instance(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // instance()
        Configuration * cppResult = ::Configuration::instance();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_isDecompilerAnnotationHighlighterEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isDecompilerAnnotationHighlighterEnabled()
        bool cppResult = cppSelf->isDecompilerAnnotationHighlighterEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_isFirstExecution(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isFirstExecution()
        bool cppResult = cppSelf->isFirstExecution();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_loadInitial(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // loadInitial()
        cppSelf->loadInitial();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_nativeWindowIsDark(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // nativeWindowIsDark()
        bool cppResult = ::Configuration::nativeWindowIsDark();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_refreshFont(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // refreshFont()
        cppSelf->refreshFont();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_resetAll(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // resetAll()
        cppSelf->resetAll();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_resetToDefaultAsmOptions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // resetToDefaultAsmOptions()
        cppSelf->resetToDefaultAsmOptions();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setAutoUpdateEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setAutoUpdateEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAutoUpdateEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAutoUpdateEnabled", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAutoUpdateEnabled(bool)
            cppSelf->setAutoUpdateEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setBitmapExportScaleFactor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setBitmapExportScaleFactor(double)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // setBitmapExportScaleFactor(double)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setBitmapExportScaleFactor", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setBitmapExportScaleFactor(double)
            cppSelf->setBitmapExportScaleFactor(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setBitmapTransparentState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setBitmapTransparentState(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setBitmapTransparentState(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setBitmapTransparentState", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setBitmapTransparentState(bool)
            cppSelf->setBitmapTransparentState(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setColor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setColor", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: Configuration::setColor(QString,QColor)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QColor_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setColor(QString,QColor)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setColor", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QColor cppArg1_local;
        ::QColor *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setColor(QString,QColor)
            cppSelf->setColor(cppArg0, *cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setColorTheme(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setColorTheme(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setColorTheme(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setColorTheme", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setColorTheme(QString)
            cppSelf->setColorTheme(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setConfig(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setConfig", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: Configuration::setConfig(QString,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], (pyArgs[1])))) {
        overloadId = 0; // setConfig(QString,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setConfig", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setConfig(QString,QVariant)
            cppSelf->setConfig(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setDecompilerAutoRefreshEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setDecompilerAutoRefreshEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDecompilerAutoRefreshEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDecompilerAutoRefreshEnabled", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDecompilerAutoRefreshEnabled(bool)
            cppSelf->setDecompilerAutoRefreshEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setFont(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setFont(QFont)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFont_IDX]), (pyArg)))) {
        overloadId = 0; // setFont(QFont)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setFont", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFont cppArg0_local;
        ::QFont *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setFont(QFont)
            cppSelf->setFont(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setFunctionsWidgetLayout(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setFunctionsWidgetLayout(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setFunctionsWidgetLayout(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setFunctionsWidgetLayout", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setFunctionsWidgetLayout(QString)
            cppSelf->setFunctionsWidgetLayout(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setGraphBlockEntryOffset(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setGraphBlockEntryOffset(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setGraphBlockEntryOffset(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setGraphBlockEntryOffset", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setGraphBlockEntryOffset(bool)
            cppSelf->setGraphBlockEntryOffset(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setGraphBlockMaxChars(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setGraphBlockMaxChars(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setGraphBlockMaxChars(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setGraphBlockMaxChars", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setGraphBlockMaxChars(int)
            cppSelf->setGraphBlockMaxChars(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setGraphMinFontSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setGraphMinFontSize(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setGraphMinFontSize(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setGraphMinFontSize", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setGraphMinFontSize(int)
            cppSelf->setGraphMinFontSize(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setGraphPreview(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setGraphPreview(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setGraphPreview(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setGraphPreview", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setGraphPreview(bool)
            cppSelf->setGraphPreview(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setGraphSpacing(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setGraphSpacing", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: Configuration::setGraphSpacing(QPoint,QPoint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPoint_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPoint_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setGraphSpacing(QPoint,QPoint)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setGraphSpacing", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPoint cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QPoint cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setGraphSpacing(QPoint,QPoint)
            cppSelf->setGraphSpacing(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setInterfaceTheme(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setInterfaceTheme(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setInterfaceTheme(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setInterfaceTheme", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setInterfaceTheme(int)
            cppSelf->setInterfaceTheme(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setLocale(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setLocale(QLocale)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QLocale_IDX]), (pyArg)))) {
        overloadId = 0; // setLocale(QLocale)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setLocale", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLocale cppArg0_local;
        ::QLocale *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setLocale(QLocale)
            cppSelf->setLocale(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setLocaleByName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setLocaleByName(QString)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setLocaleByName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setLocaleByName", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setLocaleByName(QString)
            bool cppResult = cppSelf->setLocaleByName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ConfigurationFunc_setNewFileLastClicked(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setNewFileLastClicked(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setNewFileLastClicked(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setNewFileLastClicked", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setNewFileLastClicked(int)
            cppSelf->setNewFileLastClicked(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setOutputRedirectionEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setOutputRedirectionEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setOutputRedirectionEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setOutputRedirectionEnabled", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setOutputRedirectionEnabled(bool)
            cppSelf->setOutputRedirectionEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setPreviewValue(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setPreviewValue(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setPreviewValue(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPreviewValue", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPreviewValue(bool)
            cppSelf->setPreviewValue(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setRecentFiles(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setRecentFiles(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArg)))) {
        overloadId = 0; // setRecentFiles(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setRecentFiles", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setRecentFiles(QStringList)
            cppSelf->setRecentFiles(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setRecentFolder(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setRecentFolder(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setRecentFolder(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setRecentFolder", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setRecentFolder(QString)
            cppSelf->setRecentFolder(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setRecentProjects(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setRecentProjects(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArg)))) {
        overloadId = 0; // setRecentProjects(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setRecentProjects", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setRecentProjects(QStringList)
            cppSelf->setRecentProjects(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setSelectedDecompiler(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setSelectedDecompiler(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setSelectedDecompiler(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSelectedDecompiler", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setSelectedDecompiler(QString)
            cppSelf->setSelectedDecompiler(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setShowVarTooltips(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setShowVarTooltips(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setShowVarTooltips(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setShowVarTooltips", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setShowVarTooltips(bool)
            cppSelf->setShowVarTooltips(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_setZoomFactor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Configuration::setZoomFactor(qreal)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setZoomFactor(qreal)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setZoomFactor", errInfo, SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]);

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setZoomFactor(qreal)
            cppSelf->setZoomFactor(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ConfigurationFunc_windowColorIsDark(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // windowColorIsDark()
        bool cppResult = cppSelf->windowColorIsDark();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_Configuration_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Configuration_methods[] = {
    {"addRecentProject", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_addRecentProject), METH_O, nullptr},
    {"adjustColorThemeDarkness", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_adjustColorThemeDarkness), METH_NOARGS, nullptr},
    {"colorThemeDarkness", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_colorThemeDarkness), METH_O, nullptr},
    {"createSyntaxHighlighter", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_createSyntaxHighlighter), METH_O, nullptr},
    {"enableDecompilerAnnotationHighlighter", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_enableDecompilerAnnotationHighlighter), METH_O, nullptr},
    {"getAutoUpdateEnabled", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getAutoUpdateEnabled), METH_NOARGS, nullptr},
    {"getAvailableTranslations", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getAvailableTranslations), METH_NOARGS, nullptr},
    {"getBaseFont", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getBaseFont), METH_NOARGS, nullptr},
    {"getBitmapExportScaleFactor", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getBitmapExportScaleFactor), METH_NOARGS, nullptr},
    {"getBitmapTransparentState", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getBitmapTransparentState), METH_NOARGS, nullptr},
    {"getColor", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getColor), METH_O, nullptr},
    {"getColorTheme", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getColorTheme), METH_NOARGS, nullptr},
    {"getConfigBool", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getConfigBool), METH_O, nullptr},
    {"getConfigInt", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getConfigInt), METH_O, nullptr},
    {"getConfigString", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getConfigString), METH_O, nullptr},
    {"getConfigVar", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getConfigVar), METH_O, nullptr},
    {"getCurrLocale", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getCurrLocale), METH_NOARGS, nullptr},
    {"getDecompilerAutoRefreshEnabled", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getDecompilerAutoRefreshEnabled), METH_NOARGS, nullptr},
    {"getFont", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getFont), METH_NOARGS, nullptr},
    {"getFunctionsWidgetLayout", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getFunctionsWidgetLayout), METH_NOARGS, nullptr},
    {"getGraphBlockEntryOffset", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getGraphBlockEntryOffset), METH_NOARGS, nullptr},
    {"getGraphBlockMaxChars", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getGraphBlockMaxChars), METH_NOARGS, nullptr},
    {"getGraphBlockSpacing", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getGraphBlockSpacing), METH_NOARGS, nullptr},
    {"getGraphEdgeSpacing", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getGraphEdgeSpacing), METH_NOARGS, nullptr},
    {"getGraphMinFontSize", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getGraphMinFontSize), METH_NOARGS, nullptr},
    {"getGraphPreview", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getGraphPreview), METH_NOARGS, nullptr},
    {"getInterfaceTheme", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getInterfaceTheme), METH_NOARGS, nullptr},
    {"getLogoFile", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getLogoFile), METH_NOARGS, nullptr},
    {"getNewFileLastClicked", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getNewFileLastClicked), METH_NOARGS, nullptr},
    {"getOutputRedirectionEnabled", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getOutputRedirectionEnabled), METH_NOARGS, nullptr},
    {"getPreviewValue", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getPreviewValue), METH_NOARGS, nullptr},
    {"getRecentFiles", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getRecentFiles), METH_NOARGS, nullptr},
    {"getRecentFolder", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getRecentFolder), METH_NOARGS, nullptr},
    {"getRecentProjects", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getRecentProjects), METH_NOARGS, nullptr},
    {"getSelectedDecompiler", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getSelectedDecompiler), METH_NOARGS, nullptr},
    {"getShowVarTooltips", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getShowVarTooltips), METH_NOARGS, nullptr},
    {"getZoomFactor", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_getZoomFactor), METH_NOARGS, nullptr},
    {"instance", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_instance), METH_NOARGS|METH_STATIC, nullptr},
    {"isDecompilerAnnotationHighlighterEnabled", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_isDecompilerAnnotationHighlighterEnabled), METH_NOARGS, nullptr},
    {"isFirstExecution", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_isFirstExecution), METH_NOARGS, nullptr},
    {"loadInitial", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_loadInitial), METH_NOARGS, nullptr},
    {"nativeWindowIsDark", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_nativeWindowIsDark), METH_NOARGS|METH_STATIC, nullptr},
    {"refreshFont", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_refreshFont), METH_NOARGS, nullptr},
    {"resetAll", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_resetAll), METH_NOARGS, nullptr},
    {"resetToDefaultAsmOptions", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_resetToDefaultAsmOptions), METH_NOARGS, nullptr},
    {"setAutoUpdateEnabled", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setAutoUpdateEnabled), METH_O, nullptr},
    {"setBitmapExportScaleFactor", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setBitmapExportScaleFactor), METH_O, nullptr},
    {"setBitmapTransparentState", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setBitmapTransparentState), METH_O, nullptr},
    {"setColor", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setColor), METH_VARARGS, nullptr},
    {"setColorTheme", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setColorTheme), METH_O, nullptr},
    {"setConfig", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setConfig), METH_VARARGS, nullptr},
    {"setDecompilerAutoRefreshEnabled", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setDecompilerAutoRefreshEnabled), METH_O, nullptr},
    {"setFont", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setFont), METH_O, nullptr},
    {"setFunctionsWidgetLayout", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setFunctionsWidgetLayout), METH_O, nullptr},
    {"setGraphBlockEntryOffset", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setGraphBlockEntryOffset), METH_O, nullptr},
    {"setGraphBlockMaxChars", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setGraphBlockMaxChars), METH_O, nullptr},
    {"setGraphMinFontSize", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setGraphMinFontSize), METH_O, nullptr},
    {"setGraphPreview", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setGraphPreview), METH_O, nullptr},
    {"setGraphSpacing", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setGraphSpacing), METH_VARARGS, nullptr},
    {"setInterfaceTheme", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setInterfaceTheme), METH_O, nullptr},
    {"setLocale", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setLocale), METH_O, nullptr},
    {"setLocaleByName", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setLocaleByName), METH_O, nullptr},
    {"setNewFileLastClicked", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setNewFileLastClicked), METH_O, nullptr},
    {"setOutputRedirectionEnabled", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setOutputRedirectionEnabled), METH_O, nullptr},
    {"setPreviewValue", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setPreviewValue), METH_O, nullptr},
    {"setRecentFiles", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setRecentFiles), METH_O, nullptr},
    {"setRecentFolder", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setRecentFolder), METH_O, nullptr},
    {"setRecentProjects", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setRecentProjects), METH_O, nullptr},
    {"setSelectedDecompiler", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setSelectedDecompiler), METH_O, nullptr},
    {"setShowVarTooltips", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setShowVarTooltips), METH_O, nullptr},
    {"setZoomFactor", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_setZoomFactor), METH_O, nullptr},
    {"windowColorIsDark", reinterpret_cast<PyCFunction>(Sbk_ConfigurationFunc_windowColorIsDark), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_Configuration_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::Configuration *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_Configuration_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<ConfigurationWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Configuration_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_Configuration_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_Configuration_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Configuration_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Configuration_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Configuration_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Configuration_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Configuration_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_Configuration_spec = {
    "1:CutterBindings.Configuration",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_Configuration_slots
};

} //extern "C"

static void *Sbk_Configuration_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::Configuration *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Configuration_PythonToCpp_Configuration_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_Configuration_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Configuration_PythonToCpp_Configuration_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_Configuration_TypeF()))
        return Configuration_PythonToCpp_Configuration_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Configuration_PTR_CppToPython_Configuration(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::Configuration *>(const_cast<void *>(cppIn)), Sbk_Configuration_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *Configuration_SignatureStrings[] = {
    "CutterBindings.Configuration.addRecentProject(self,file:QString)",
    "CutterBindings.Configuration.adjustColorThemeDarkness(self)",
    "CutterBindings.Configuration.colorThemeDarkness(self,colorTheme:QString)->int",
    "CutterBindings.Configuration.createSyntaxHighlighter(self,document:PySide6.QtGui.QTextDocument)->PySide6.QtGui.QSyntaxHighlighter",
    "CutterBindings.Configuration.enableDecompilerAnnotationHighlighter(self,useDecompilerHighlighter:bool)",
    "CutterBindings.Configuration.getAutoUpdateEnabled(self)->bool",
    "CutterBindings.Configuration.getAvailableTranslations(self)->QStringList",
    "CutterBindings.Configuration.getBaseFont(self)->PySide6.QtGui.QFont",
    "CutterBindings.Configuration.getBitmapExportScaleFactor(self)->double",
    "CutterBindings.Configuration.getBitmapTransparentState(self)->bool",
    "CutterBindings.Configuration.getColor(self,name:QString)->PySide6.QtGui.QColor",
    "CutterBindings.Configuration.getColorTheme(self)->QString",
    "CutterBindings.Configuration.getConfigBool(self,key:QString)->bool",
    "CutterBindings.Configuration.getConfigInt(self,key:QString)->int",
    "CutterBindings.Configuration.getConfigString(self,key:QString)->QString",
    "CutterBindings.Configuration.getConfigVar(self,key:QString)->QVariant",
    "CutterBindings.Configuration.getCurrLocale(self)->PySide6.QtCore.QLocale",
    "CutterBindings.Configuration.getDecompilerAutoRefreshEnabled(self)->bool",
    "CutterBindings.Configuration.getFont(self)->PySide6.QtGui.QFont",
    "CutterBindings.Configuration.getFunctionsWidgetLayout(self)->QString",
    "CutterBindings.Configuration.getGraphBlockEntryOffset(self)->bool",
    "CutterBindings.Configuration.getGraphBlockMaxChars(self)->int",
    "CutterBindings.Configuration.getGraphBlockSpacing(self)->PySide6.QtCore.QPoint",
    "CutterBindings.Configuration.getGraphEdgeSpacing(self)->PySide6.QtCore.QPoint",
    "CutterBindings.Configuration.getGraphMinFontSize(self)->int",
    "CutterBindings.Configuration.getGraphPreview(self)->bool",
    "CutterBindings.Configuration.getInterfaceTheme(self)->int",
    "CutterBindings.Configuration.getLogoFile(self)->QString",
    "CutterBindings.Configuration.getNewFileLastClicked(self)->int",
    "CutterBindings.Configuration.getOutputRedirectionEnabled(self)->bool",
    "CutterBindings.Configuration.getPreviewValue(self)->bool",
    "CutterBindings.Configuration.getRecentFiles(self)->QStringList",
    "CutterBindings.Configuration.getRecentFolder(self)->QString",
    "CutterBindings.Configuration.getRecentProjects(self)->QStringList",
    "CutterBindings.Configuration.getSelectedDecompiler(self)->QString",
    "CutterBindings.Configuration.getShowVarTooltips(self)->bool",
    "CutterBindings.Configuration.getZoomFactor(self)->qreal",
    "CutterBindings.Configuration.instance()->CutterBindings.Configuration",
    "CutterBindings.Configuration.isDecompilerAnnotationHighlighterEnabled(self)->bool",
    "CutterBindings.Configuration.isFirstExecution(self)->bool",
    "CutterBindings.Configuration.loadInitial(self)",
    "CutterBindings.Configuration.nativeWindowIsDark()->bool",
    "CutterBindings.Configuration.refreshFont(self)",
    "CutterBindings.Configuration.resetAll(self)",
    "CutterBindings.Configuration.resetToDefaultAsmOptions(self)",
    "CutterBindings.Configuration.setAutoUpdateEnabled(self,au:bool)",
    "CutterBindings.Configuration.setBitmapExportScaleFactor(self,inputValueGraph:double)",
    "CutterBindings.Configuration.setBitmapTransparentState(self,inputValueGraph:bool)",
    "CutterBindings.Configuration.setColor(self,name:QString,color:typing.Union[PySide6.QtGui.QColor, QLatin1String, PySide6.QtGui.QRgba64, QVariant, PySide6.QtCore.Qt.GlobalColor, QString, unsigned int])",
    "CutterBindings.Configuration.setColorTheme(self,theme:QString)",
    "CutterBindings.Configuration.setConfig(self,key:QString,value:QVariant)",
    "CutterBindings.Configuration.setDecompilerAutoRefreshEnabled(self,enabled:bool)",
    "CutterBindings.Configuration.setFont(self,font:typing.Union[PySide6.QtGui.QFont, QString, QStringList])",
    "CutterBindings.Configuration.setFunctionsWidgetLayout(self,layout:QString)",
    "CutterBindings.Configuration.setGraphBlockEntryOffset(self,enabled:bool)",
    "CutterBindings.Configuration.setGraphBlockMaxChars(self,ch:int)",
    "CutterBindings.Configuration.setGraphMinFontSize(self,sz:int)",
    "CutterBindings.Configuration.setGraphPreview(self,checked:bool)",
    "CutterBindings.Configuration.setGraphSpacing(self,blockSpacing:PySide6.QtCore.QPoint,edgeSpacing:PySide6.QtCore.QPoint)",
    "CutterBindings.Configuration.setInterfaceTheme(self,theme:int)",
    "CutterBindings.Configuration.setLocale(self,l:typing.Union[PySide6.QtCore.QLocale, PySide6.QtCore.QLocale.Language])",
    "CutterBindings.Configuration.setLocaleByName(self,language:QString)->bool",
    "CutterBindings.Configuration.setNewFileLastClicked(self,lastClicked:int)",
    "CutterBindings.Configuration.setOutputRedirectionEnabled(self,enabled:bool)",
    "CutterBindings.Configuration.setPreviewValue(self,checked:bool)",
    "CutterBindings.Configuration.setRecentFiles(self,list:QStringList)",
    "CutterBindings.Configuration.setRecentFolder(self,dir:QString)",
    "CutterBindings.Configuration.setRecentProjects(self,list:QStringList)",
    "CutterBindings.Configuration.setSelectedDecompiler(self,id:QString)",
    "CutterBindings.Configuration.setShowVarTooltips(self,enabled:bool)",
    "CutterBindings.Configuration.setZoomFactor(self,zoom:qreal)",
    "CutterBindings.Configuration.windowColorIsDark(self)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t Configuration_SignatureByteSize = 997;
static constexpr uint8_t Configuration_SignatureBytes[997] = {
    0x78, 0xda, 0xad, 0x57, 0x4d, 0x6f, 0xdb, 0x38, 0x10, 0xbd, 0xef, 0xaf, 0xc8, 0x31, 0x0b, 0xb0,
    0x06, 0x16, 0x58, 0xf4, 0xa0, 0x43, 0x81, 0xd8, 0xb1, 0xb3, 0x01, 0xdc, 0x26, 0x8e, 0xdd, 0x16,
    0xe8, 0xa2, 0x87, 0xb1, 0x34, 0x92, 0xd9, 0xd0, 0xa4, 0x96, 0x1f, 0x89, 0x9d, 0x5f, 0xbf, 0xa3,
    0x0f, 0x47, 0xb2, 0x2d, 0x5b, 0xa4, 0x77, 0x0f, 0x41, 0x2c, 0x72, 0xde, 0xe3, 0xcc, 0x70, 0x86,
    0x7c, 0x1c, 0x39, 0x6b, 0x51, 0x0f, 0xb9, 0x4c, 0xb8, 0xcc, 0xcc, 0x60, 0xa4, 0x64, 0xca, 0x33,
    0xa7, 0xc1, 0x72, 0x25, 0x07, 0x90, 0x24, 0x4f, 0x18, 0xa3, 0xb4, 0x8f, 0x5a, 0xfd, 0xc2, 0xd8,
    0x5e, 0x1b, 0x14, 0x29, 0x4b, 0xb9, 0xc0, 0x68, 0x36, 0xb7, 0x9a, 0x10, 0xbf, 0xff, 0x36, 0x3a,
    0x4f, 0xf0, 0xcb, 0x19, 0x3b, 0x52, 0x42, 0xe9, 0xc5, 0x0a, 0xd7, 0x78, 0x0b, 0xfa, 0x59, 0xa2,
    0x31, 0x25, 0x51, 0x0f, 0x36, 0xee, 0x46, 0xb1, 0x66, 0xfc, 0xdd, 0x89, 0x0f, 0x9f, 0xb8, 0xb4,
    0x3d, 0x6c, 0x1a, 0xc1, 0xe2, 0x7c, 0x2b, 0x2d, 0x6c, 0xfe, 0xe2, 0xd9, 0x4a, 0xd0, 0x1f, 0x59,
    0x57, 0x94, 0x89, 0x8a, 0xdd, 0x9a, 0xc2, 0x8c, 0x1e, 0xb7, 0x73, 0x9e, 0xe0, 0xc7, 0xc1, 0xcc,
    0xde, 0x39, 0x3e, 0x98, 0x2d, 0x70, 0x63, 0x6f, 0xeb, 0x39, 0x5a, 0xe4, 0x60, 0xf6, 0x88, 0xec,
    0xbc, 0x07, 0x28, 0x61, 0x29, 0xf0, 0x16, 0x63, 0xb5, 0xce, 0x29, 0x83, 0xfa, 0x46, 0x4a, 0x65,
    0xcb, 0xa9, 0x23, 0x7f, 0x9c, 0x69, 0xd9, 0xb5, 0x66, 0xa3, 0xa5, 0x52, 0xa2, 0x27, 0x6d, 0x19,
    0xda, 0x1b, 0x67, 0xd5, 0xd7, 0x3c, 0xa1, 0x78, 0xc7, 0xe5, 0x9a, 0x49, 0x95, 0xee, 0x0f, 0x9f,
    0x0a, 0x78, 0x3f, 0xfa, 0x05, 0xb8, 0x28, 0x60, 0x0b, 0x0d, 0xd2, 0x88, 0x72, 0xdc, 0xec, 0x18,
    0xea, 0x8c, 0x4f, 0xb9, 0xb1, 0xbd, 0x44, 0x43, 0x30, 0x38, 0x51, 0xd2, 0xee, 0xb0, 0x07, 0xe9,
    0x2b, 0xa6, 0xfa, 0x39, 0xb8, 0x5d, 0x43, 0x3e, 0xde, 0xe4, 0x4a, 0xdb, 0x79, 0x0c, 0x02, 0x27,
    0x10, 0x5b, 0xa5, 0x77, 0x94, 0x89, 0x72, 0xe4, 0xa8, 0x27, 0x4b, 0x19, 0x4f, 0x0e, 0x9a, 0x36,
    0x73, 0x4e, 0x89, 0xc7, 0xa0, 0xac, 0x94, 0x35, 0x5c, 0xed, 0x8e, 0x84, 0xbd, 0xd2, 0x3b, 0x08,
    0xab, 0x34, 0xf4, 0xa3, 0x2b, 0x8b, 0xf8, 0x20, 0xb3, 0x1e, 0xc8, 0x62, 0x60, 0x48, 0x3e, 0x57,
    0xde, 0x3c, 0xe3, 0xb6, 0xe5, 0x8c, 0x67, 0x2c, 0xc5, 0xc0, 0x7d, 0xbd, 0x33, 0x07, 0x0c, 0xdc,
    0x63, 0x57, 0xaa, 0x81, 0x0a, 0xd2, 0xc5, 0x11, 0x16, 0xcb, 0x37, 0xd0, 0x9d, 0x24, 0x34, 0xce,
    0xc1, 0xc7, 0x1b, 0xa7, 0xf5, 0x54, 0x15, 0xc5, 0x71, 0x5c, 0x69, 0x23, 0xa5, 0x71, 0x30, 0xab,
    0x66, 0x7b, 0x89, 0x5a, 0xbd, 0x49, 0x1d, 0xf4, 0x84, 0xa9, 0x46, 0xb3, 0xba, 0xa4, 0x85, 0xfe,
    0x6b, 0xd5, 0x4f, 0x9c, 0x8c, 0xcb, 0xb6, 0xfb, 0xce, 0x13, 0xfa, 0x9c, 0xc2, 0x56, 0x39, 0x1b,
    0x5a, 0x28, 0x77, 0x1a, 0xf2, 0xd5, 0x50, 0xa8, 0xf8, 0x79, 0x2c, 0xad, 0xde, 0x3e, 0xa4, 0xa9,
    0x41, 0x1b, 0x14, 0x46, 0xc3, 0xf0, 0x19, 0x36, 0xa3, 0x15, 0xe8, 0xf7, 0x63, 0xc0, 0xa7, 0x48,
    0x1a, 0xf4, 0x3c, 0x87, 0x78, 0x57, 0x29, 0x1d, 0xbb, 0xf3, 0xa8, 0xbc, 0xe9, 0xc6, 0x94, 0x8e,
    0xff, 0x8f, 0xed, 0x33, 0x97, 0xc5, 0x76, 0xcc, 0xf9, 0x1b, 0x06, 0x07, 0xf6, 0xa8, 0xf1, 0x85,
    0xe3, 0x6b, 0x50, 0x3e, 0xa9, 0xe3, 0x50, 0xa7, 0x10, 0xe3, 0x5e, 0xe3, 0xfb, 0x2c, 0x39, 0x55,
    0x99, 0x9a, 0x70, 0x11, 0x7c, 0x58, 0x7c, 0xc1, 0xd7, 0x02, 0x36, 0x05, 0xba, 0x84, 0x05, 0x8f,
    0x9f, 0x9b, 0x3a, 0xf6, 0x59, 0xf5, 0xc1, 0xd9, 0xdc, 0xd9, 0x27, 0x4c, 0xb8, 0xc6, 0xb2, 0x1e,
    0x2f, 0xe9, 0x85, 0x3a, 0x51, 0xdf, 0x40, 0xb8, 0xb0, 0x13, 0xb7, 0x52, 0x1e, 0x85, 0xfb, 0x17,
    0xdd, 0x3e, 0x35, 0x5c, 0x89, 0x04, 0x75, 0x68, 0xda, 0xf6, 0x44, 0xcf, 0x45, 0xab, 0xcf, 0x51,
    0x10, 0x14, 0x93, 0xe6, 0x48, 0x09, 0xf5, 0x61, 0xbe, 0x52, 0x94, 0x34, 0xbd, 0xa0, 0x54, 0x59,
    0x9e, 0x9b, 0xa0, 0xd4, 0xfd, 0x50, 0x6a, 0xbd, 0x7f, 0x51, 0xfe, 0x43, 0xf2, 0xa7, 0x07, 0xc7,
    0xa5, 0xb1, 0x20, 0x63, 0xbc, 0x26, 0xf3, 0x73, 0x86, 0x3d, 0x2c, 0xa6, 0x47, 0xe1, 0x04, 0xd7,
    0x10, 0x37, 0x13, 0xae, 0x8d, 0x1d, 0x6f, 0x30, 0x76, 0xc5, 0x80, 0x3f, 0x52, 0x28, 0x48, 0xee,
    0x25, 0xb7, 0x1c, 0x84, 0x8f, 0xe0, 0x94, 0xf4, 0xef, 0x05, 0xbf, 0xd3, 0xa4, 0x7a, 0xbd, 0x37,
    0x85, 0xe8, 0xbc, 0xf6, 0x5a, 0x46, 0x57, 0x17, 0x45, 0x73, 0xe8, 0xf7, 0x99, 0xd3, 0x39, 0x7c,
    0x23, 0x84, 0xb7, 0xed, 0x42, 0xdd, 0x62, 0x0a, 0x4e, 0xd8, 0x1b, 0xb3, 0x7e, 0xc8, 0x5b, 0x72,
    0xec, 0x3c, 0xd6, 0x9c, 0x12, 0x82, 0x0c, 0x9c, 0x8f, 0x90, 0x34, 0xe7, 0xd5, 0x17, 0xe3, 0x92,
    0x0e, 0x87, 0xb2, 0xad, 0xcb, 0x03, 0x31, 0xaa, 0xb4, 0x98, 0x2f, 0x69, 0xa7, 0x18, 0x3b, 0xe2,
    0xf4, 0x73, 0xf3, 0x84, 0x36, 0xab, 0x5e, 0x0a, 0x91, 0xdd, 0xe6, 0xf4, 0x31, 0xf8, 0x2a, 0xc9,
    0xfa, 0xef, 0x2e, 0xb1, 0xc6, 0xae, 0x66, 0x53, 0xe2, 0x92, 0x7f, 0xd4, 0xb0, 0xab, 0x03, 0xa3,
    0xa7, 0x6c, 0x09, 0x1f, 0xff, 0x24, 0xab, 0x5a, 0x90, 0xb4, 0x0d, 0xaa, 0x3b, 0xc7, 0x0e, 0xee,
    0x84, 0x5a, 0x82, 0xd8, 0xd1, 0xed, 0x88, 0x9c, 0x34, 0x3c, 0x93, 0x98, 0x5c, 0xd1, 0x69, 0xfb,
    0xd3, 0x33, 0x8e, 0xe6, 0x6e, 0x60, 0x76, 0xef, 0x91, 0xe3, 0x01, 0x2f, 0x06, 0x8e, 0xa4, 0x14,
    0x7b, 0x29, 0xf2, 0x19, 0xed, 0xbc, 0xef, 0xe7, 0xe9, 0x95, 0x41, 0xac, 0x7a, 0xca, 0x24, 0x9e,
    0xdb, 0xf3, 0xde, 0x18, 0x2c, 0xa5, 0x5f, 0x67, 0xf7, 0xa3, 0x30, 0x6d, 0xe5, 0xaf, 0x75, 0xe2,
    0x7a, 0xa4, 0xef, 0xb4, 0x6a, 0x62, 0xa2, 0xfc, 0xed, 0x9f, 0xca, 0xd3, 0xda, 0x29, 0x30, 0xf6,
    0x13, 0x12, 0x8a, 0xc5, 0xab, 0x88, 0xfb, 0xec, 0x45, 0xa7, 0x4e, 0x61, 0xe6, 0x2d, 0x00, 0xdd,
    0x56, 0x2a, 0xb4, 0x2e, 0x16, 0x2a, 0x20, 0xc4, 0xfb, 0xb6, 0xde, 0x62, 0xcb, 0x96, 0x9e, 0x8b,
    0x3a, 0xa5, 0x17, 0xc3, 0x46, 0xa3, 0x75, 0x5b, 0xf4, 0xaf, 0xdb, 0x21, 0x94, 0xea, 0x66, 0xf0,
    0x82, 0xb7, 0x1e, 0x03, 0x4c, 0x9c, 0xaa, 0xb7, 0xf6, 0xcb, 0xe0, 0xb8, 0xa3, 0xab, 0xf1, 0xc1,
    0x14, 0x64, 0xe6, 0x20, 0xc3, 0x9f, 0xbe, 0x8b, 0x0e, 0xb7, 0x5f, 0x60, 0xe7, 0xb1, 0xa8, 0xc1,
    0x41, 0xcf, 0x33, 0x73, 0x52, 0xb4, 0x11, 0xdf, 0xfb, 0x80, 0x5f, 0x1e, 0xce, 0xea, 0xb7, 0xc0,
    0x42, 0x3e, 0x92, 0x71, 0x81, 0xa5, 0x74, 0xa8, 0xe6, 0x98, 0xa0, 0xa6, 0x8e, 0x5a, 0x0d, 0xee,
    0x4d, 0xd1, 0x28, 0x3a, 0x46, 0x81, 0xf9, 0xf7, 0x74, 0x87, 0xa8, 0xbb, 0xc0, 0x89, 0x13, 0xc2,
    0x8e, 0xf1, 0xc4, 0xdf, 0x93, 0x2e, 0x69, 0x17, 0xb8, 0x1d, 0x07, 0x0a, 0x8f, 0xbd, 0xd1, 0x77,
    0x54, 0x8a, 0xbc, 0x1e, 0xec, 0x6b, 0x29, 0x6f, 0xca, 0x9b, 0xa6, 0xd6, 0x38, 0x6d, 0x39, 0xf5,
    0x2f, 0x45, 0xa7, 0x90, 0x57
};
#endif

PyTypeObject *init_Configuration(PyObject *module)
{
    if (SbkCutterBindingsTypeStructs[SBK_Configuration_IDX].type != nullptr)
        return SbkCutterBindingsTypeStructs[SBK_Configuration_IDX].type;

    Shiboken::AutoDecRef Sbk_Configuration_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_Configuration_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "Configuration",
        "Configuration*",
        &Sbk_Configuration_spec,
        &Shiboken::callCppDestructor< Configuration >,
        Sbk_Configuration_Type_bases.object(),
        0);
    auto *pyType = Sbk_Configuration_TypeF(); // references _Sbk_Configuration_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, Configuration_SignatureStrings);
#else
    InitSignatureBytes(pyType, Configuration_SignatureBytes, Configuration_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_Configuration_PropertyStrings);
    SbkCutterBindingsTypeStructs[SBK_Configuration_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        Configuration_PythonToCpp_Configuration_PTR,
        is_Configuration_PythonToCpp_Configuration_PTR_Convertible,
        Configuration_PTR_CppToPython_Configuration);

    Shiboken::Conversions::registerConverterName(converter, "Configuration");
    Shiboken::Conversions::registerConverterName(converter, "Configuration*");
    Shiboken::Conversions::registerConverterName(converter, "Configuration&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Configuration).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(ConfigurationWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_Configuration_TypeF(), &Sbk_Configuration_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::Configuration::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::Configuration::staticMetaObject, sizeof(ConfigurationWrapper));

    return pyType;
}
