/* rygel-ruih-protocol-elem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-ruih-protocol-elem.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Neha Shanbhag <N.Shanbhag@cablelabs.com>
 * Contact: http://www.cablelabs.com/
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-ruih.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include "rygel-core.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _ui_listing_unref0(var) ((var == NULL) ? NULL : (var = (ui_listing_unref (var), NULL)))
#define _rygel_xml_utils_iterator_unref0(var) ((var == NULL) ? NULL : (var = (rygel_xml_utils_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ProtocolElemPrivate {
	gchar* short_name;
	gchar* protocol_info;
	GeeArrayList* uris;
};

static gint ProtocolElem_private_offset;
static gpointer protocol_elem_parent_class = NULL;

static gboolean protocol_elem_real_match (UIListing* base,
                                   GeeArrayList* protocols,
                                   GeeArrayList* filters);
static gchar* protocol_elem_real_to_ui_listing (UIListing* base,
                                         GeeArrayList* filters);
static void protocol_elem_finalize (UIListing * obj);
static GType protocol_elem_get_type_once (void);

static inline gpointer
protocol_elem_get_instance_private (ProtocolElem* self)
{
	return G_STRUCT_MEMBER_P (self, ProtocolElem_private_offset);
}

ProtocolElem*
protocol_elem_construct (GType object_type,
                         xmlNode* node,
                         GError** error)
{
	ProtocolElem* self = NULL;
	GeeArrayList* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (ProtocolElem*) ui_listing_construct (object_type);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->uris);
	self->priv->uris = _tmp0_;
	{
		xmlAttr* prop = NULL;
		xmlAttr* _tmp1_;
		_tmp1_ = node->properties;
		prop = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				xmlAttr* _tmp5_;
				gchar* attr_name = NULL;
				xmlAttr* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				GQuark _tmp12_ = 0U;
				static GQuark _tmp11_label0 = 0;
				if (!_tmp2_) {
					xmlAttr* _tmp3_;
					xmlAttr* _tmp4_;
					_tmp3_ = prop;
					_tmp4_ = _tmp3_->next;
					prop = _tmp4_;
				}
				_tmp2_ = FALSE;
				_tmp5_ = prop;
				if (!(_tmp5_ != NULL)) {
					break;
				}
				_tmp6_ = prop;
				_tmp7_ = _tmp6_->name;
				_tmp8_ = g_strdup (_tmp7_);
				attr_name = _tmp8_;
				_tmp9_ = attr_name;
				_tmp10_ = _tmp9_;
				_tmp12_ = (NULL == _tmp10_) ? 0 : g_quark_from_string (_tmp10_);
				if (_tmp12_ == ((0 != _tmp11_label0) ? _tmp11_label0 : (_tmp11_label0 = g_quark_from_static_string (UI_LISTING_SHORT_NAME)))) {
					switch (0) {
						default:
						{
							xmlAttr* _tmp13_;
							xmlNode* _tmp14_;
							const gchar* _tmp15_;
							gchar* _tmp16_;
							_tmp13_ = prop;
							_tmp14_ = _tmp13_->children;
							_tmp15_ = _tmp14_->content;
							_tmp16_ = g_strdup (_tmp15_);
							_g_free0 (self->priv->short_name);
							self->priv->short_name = _tmp16_;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							gchar* msg = NULL;
							gchar* _tmp17_;
							const gchar* _tmp18_;
							const gchar* _tmp19_;
							gchar* _tmp20_;
							gchar* _tmp21_;
							GError* _tmp22_;
							GError* _tmp23_;
							_tmp17_ = g_strdup (_ ("Unable to parse Protocol data — unexpected attribute: %s"));
							msg = _tmp17_;
							_tmp18_ = msg;
							_tmp19_ = attr_name;
							_tmp20_ = g_strdup_printf (_tmp18_, _tmp19_);
							_tmp21_ = _tmp20_;
							_tmp22_ = g_error_new_literal (RYGEL_RUIH_SERVICE_ERROR, RYGEL_RUIH_SERVICE_ERROR_OPERATION_REJECTED, _tmp21_);
							_tmp23_ = _tmp22_;
							_g_free0 (_tmp21_);
							_inner_error0_ = _tmp23_;
							if (_inner_error0_->domain == RYGEL_RUIH_SERVICE_ERROR) {
								g_propagate_error (error, _inner_error0_);
								_g_free0 (msg);
								_g_free0 (attr_name);
								_ui_listing_unref0 (self);
								return NULL;
							} else {
								_g_free0 (msg);
								_g_free0 (attr_name);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
							_g_free0 (msg);
						}
					}
				}
				_g_free0 (attr_name);
			}
		}
	}
	{
		RygelXMLUtilsIterator* _child_node_it = NULL;
		RygelXMLUtilsChildIterator* _tmp24_;
		RygelXMLUtilsChildIterator* _tmp25_;
		RygelXMLUtilsIterator* _tmp26_;
		RygelXMLUtilsIterator* _tmp27_;
		_tmp24_ = rygel_xml_utils_child_iterator_new (node);
		_tmp25_ = _tmp24_;
		_tmp26_ = rygel_xml_utils_iterator_iterator ((RygelXMLUtilsIterator*) _tmp25_);
		_tmp27_ = _tmp26_;
		_rygel_xml_utils_iterator_unref0 (_tmp25_);
		_child_node_it = _tmp27_;
		while (TRUE) {
			RygelXMLUtilsIterator* _tmp28_;
			xmlNode* child_node = NULL;
			RygelXMLUtilsIterator* _tmp29_;
			xmlNode* _tmp30_;
			xmlNode* _tmp31_;
			gchar* node_name = NULL;
			xmlNode* _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			GQuark _tmp38_ = 0U;
			static GQuark _tmp37_label0 = 0;
			static GQuark _tmp37_label1 = 0;
			_tmp28_ = _child_node_it;
			if (!rygel_xml_utils_iterator_next (_tmp28_)) {
				break;
			}
			_tmp29_ = _child_node_it;
			_tmp30_ = rygel_xml_utils_iterator_get (_tmp29_);
			child_node = _tmp30_;
			_tmp31_ = child_node;
			if (_tmp31_->type == XML_TEXT_NODE) {
				continue;
			}
			_tmp32_ = child_node;
			_tmp33_ = _tmp32_->name;
			_tmp34_ = g_strdup (_tmp33_);
			node_name = _tmp34_;
			_tmp35_ = node_name;
			_tmp36_ = _tmp35_;
			_tmp38_ = (NULL == _tmp36_) ? 0 : g_quark_from_string (_tmp36_);
			if (_tmp38_ == ((0 != _tmp37_label0) ? _tmp37_label0 : (_tmp37_label0 = g_quark_from_static_string (UI_LISTING_URI)))) {
				switch (0) {
					default:
					{
						GeeArrayList* _tmp39_;
						xmlNode* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						_tmp39_ = self->priv->uris;
						_tmp40_ = child_node;
						_tmp41_ = (gchar*) xmlNodeGetContent (_tmp40_);
						_tmp42_ = _tmp41_;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, _tmp42_);
						_g_free0 (_tmp42_);
						break;
					}
				}
			} else if (_tmp38_ == ((0 != _tmp37_label1) ? _tmp37_label1 : (_tmp37_label1 = g_quark_from_static_string (UI_LISTING_PROTOCOL_INFO)))) {
				switch (0) {
					default:
					{
						xmlNode* _tmp43_;
						gchar* _tmp44_;
						_tmp43_ = child_node;
						_tmp44_ = (gchar*) xmlNodeGetContent (_tmp43_);
						_g_free0 (self->priv->protocol_info);
						self->priv->protocol_info = _tmp44_;
						break;
					}
				}
			} else {
				switch (0) {
					default:
					{
						gchar* msg = NULL;
						gchar* _tmp45_;
						const gchar* _tmp46_;
						const gchar* _tmp47_;
						gchar* _tmp48_;
						gchar* _tmp49_;
						GError* _tmp50_;
						GError* _tmp51_;
						_tmp45_ = g_strdup (_ ("Unable to parse Protocol data — unexpected node: %s"));
						msg = _tmp45_;
						_tmp46_ = msg;
						_tmp47_ = node_name;
						_tmp48_ = g_strdup_printf (_tmp46_, _tmp47_);
						_tmp49_ = _tmp48_;
						_tmp50_ = g_error_new_literal (RYGEL_RUIH_SERVICE_ERROR, RYGEL_RUIH_SERVICE_ERROR_OPERATION_REJECTED, _tmp49_);
						_tmp51_ = _tmp50_;
						_g_free0 (_tmp49_);
						_inner_error0_ = _tmp51_;
						if (_inner_error0_->domain == RYGEL_RUIH_SERVICE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_free0 (msg);
							_g_free0 (node_name);
							_rygel_xml_utils_iterator_unref0 (_child_node_it);
							_ui_listing_unref0 (self);
							return NULL;
						} else {
							_g_free0 (msg);
							_g_free0 (node_name);
							_rygel_xml_utils_iterator_unref0 (_child_node_it);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
						_g_free0 (msg);
					}
				}
			}
			_g_free0 (node_name);
		}
		_rygel_xml_utils_iterator_unref0 (_child_node_it);
	}
	return self;
}

ProtocolElem*
protocol_elem_new (xmlNode* node,
                   GError** error)
{
	return protocol_elem_construct (TYPE_PROTOCOL_ELEM, node, error);
}

gchar*
protocol_elem_get_short_name (ProtocolElem* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->short_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
protocol_elem_get_protocol_info (ProtocolElem* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->protocol_info;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
protocol_elem_real_match (UIListing* base,
                          GeeArrayList* protocols,
                          GeeArrayList* filters)
{
	ProtocolElem * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = (ProtocolElem*) base;
	g_return_val_if_fail (filters != NULL, FALSE);
	if (protocols == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) protocols);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == 0;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	{
		GeeArrayList* _proto_list = NULL;
		gint _proto_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _proto_index = 0;
		_proto_list = protocols;
		_tmp3_ = _proto_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_proto_size = _tmp5_;
		_proto_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ProtocolElem* proto = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			const gchar* _tmp10_;
			ProtocolElem* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gboolean _tmp14_;
			_proto_index = _proto_index + 1;
			_tmp6_ = _proto_index;
			_tmp7_ = _proto_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _proto_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _proto_index);
			proto = (ProtocolElem*) _tmp9_;
			_tmp10_ = self->priv->short_name;
			_tmp11_ = proto;
			_tmp12_ = protocol_elem_get_short_name (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strcmp0 (_tmp10_, _tmp13_) == 0;
			_g_free0 (_tmp13_);
			if (_tmp14_) {
				gboolean _tmp15_ = FALSE;
				ProtocolElem* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gboolean _tmp19_;
				_tmp16_ = proto;
				_tmp17_ = protocol_elem_get_protocol_info (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = _tmp18_ != NULL;
				_g_free0 (_tmp18_);
				if (_tmp19_) {
					ProtocolElem* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					const gchar* _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
					_tmp20_ = proto;
					_tmp21_ = protocol_elem_get_protocol_info (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = g_strstrip (_tmp22_);
					_tmp24_ = strlen (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp15_ = _tmp25_ > 0;
					_g_free0 (_tmp22_);
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					ProtocolElem* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					const gchar* _tmp29_;
					gboolean _tmp30_;
					_tmp26_ = proto;
					_tmp27_ = protocol_elem_get_protocol_info (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = self->priv->protocol_info;
					_tmp30_ = g_strcmp0 (_tmp28_, _tmp29_) == 0;
					_g_free0 (_tmp28_);
					if (_tmp30_) {
						result = TRUE;
						_ui_listing_unref0 (proto);
						return result;
					}
				} else {
					result = TRUE;
					_ui_listing_unref0 (proto);
					return result;
				}
			}
			_ui_listing_unref0 (proto);
		}
	}
	result = FALSE;
	return result;
}

static gchar*
protocol_elem_real_to_ui_listing (UIListing* base,
                                  GeeArrayList* filters)
{
	ProtocolElem * self;
	gboolean matches = FALSE;
	GeeHashMap* elements = NULL;
	GeeHashMap* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	GString* sb = NULL;
	GString* _tmp9_;
	GString* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* result;
	self = (ProtocolElem*) base;
	g_return_val_if_fail (filters != NULL, NULL);
	matches = FALSE;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	elements = _tmp0_;
	_tmp2_ = self->priv->short_name;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->short_name;
		_tmp1_ = ui_listing_filters_match ((UIListing*) self, filters, UI_LISTING_SHORT_NAME, _tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		matches = TRUE;
	}
	_tmp5_ = self->priv->protocol_info;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = self->priv->protocol_info;
		_tmp4_ = ui_listing_filters_match ((UIListing*) self, filters, UI_LISTING_PROTOCOL_INFO, _tmp6_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GeeHashMap* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = elements;
		_tmp8_ = self->priv->protocol_info;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp7_, UI_LISTING_PROTOCOL_INFO, _tmp8_);
		matches = TRUE;
	}
	_tmp9_ = g_string_new ("");
	sb = _tmp9_;
	if (matches) {
		GString* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GeeArrayList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		GString* _tmp35_;
		GeeHashMap* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		GString* _tmp39_;
		_tmp10_ = sb;
		_tmp11_ = self->priv->short_name;
		_tmp12_ = g_strconcat ("<" UI_LISTING_PROTOCOL " " UI_LISTING_SHORT_NAME "=\"", _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp13_, "\">\n", NULL);
		_tmp15_ = _tmp14_;
		g_string_append (_tmp10_, _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_tmp16_ = self->priv->uris;
		_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp18_ > 0) {
			{
				GeeArrayList* _uri_list = NULL;
				GeeArrayList* _tmp19_;
				gint _uri_size = 0;
				GeeArrayList* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				gint _uri_index = 0;
				_tmp19_ = self->priv->uris;
				_uri_list = _tmp19_;
				_tmp20_ = _uri_list;
				_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
				_tmp22_ = _tmp21_;
				_uri_size = _tmp22_;
				_uri_index = -1;
				while (TRUE) {
					gint _tmp23_;
					gint _tmp24_;
					gchar* uri = NULL;
					GeeArrayList* _tmp25_;
					gpointer _tmp26_;
					GString* _tmp27_;
					GString* _tmp28_;
					GString* _tmp29_;
					GString* _tmp30_;
					const gchar* _tmp31_;
					GString* _tmp32_;
					GString* _tmp33_;
					GString* _tmp34_;
					_uri_index = _uri_index + 1;
					_tmp23_ = _uri_index;
					_tmp24_ = _uri_size;
					if (!(_tmp23_ < _tmp24_)) {
						break;
					}
					_tmp25_ = _uri_list;
					_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _uri_index);
					uri = (gchar*) _tmp26_;
					_tmp27_ = sb;
					_tmp28_ = g_string_append (_tmp27_, "<");
					_tmp29_ = g_string_append (_tmp28_, UI_LISTING_URI);
					_tmp30_ = g_string_append (_tmp29_, ">");
					_tmp31_ = uri;
					_tmp32_ = g_string_append (_tmp30_, _tmp31_);
					_tmp33_ = g_string_append (_tmp32_, "</");
					_tmp34_ = g_string_append (_tmp33_, UI_LISTING_URI);
					g_string_append (_tmp34_, ">\n");
					_g_free0 (uri);
				}
			}
		}
		_tmp35_ = sb;
		_tmp36_ = elements;
		_tmp37_ = ui_listing_to_xml ((UIListing*) self, _tmp36_);
		_tmp38_ = _tmp37_;
		g_string_append (_tmp35_, _tmp38_);
		_g_free0 (_tmp38_);
		_tmp39_ = sb;
		g_string_append (_tmp39_, "</" UI_LISTING_PROTOCOL ">\n");
	}
	_tmp40_ = sb;
	_tmp41_ = _tmp40_->str;
	_tmp42_ = g_strdup (_tmp41_);
	result = _tmp42_;
	_g_string_free0 (sb);
	_g_object_unref0 (elements);
	return result;
}

static void
protocol_elem_class_init (ProtocolElemClass * klass,
                          gpointer klass_data)
{
	protocol_elem_parent_class = g_type_class_peek_parent (klass);
	((UIListingClass *) klass)->finalize = protocol_elem_finalize;
	g_type_class_adjust_private_offset (klass, &ProtocolElem_private_offset);
	((UIListingClass *) klass)->match = (gboolean (*) (UIListing*, GeeArrayList*, GeeArrayList*)) protocol_elem_real_match;
	((UIListingClass *) klass)->to_ui_listing = (gchar* (*) (UIListing*, GeeArrayList*)) protocol_elem_real_to_ui_listing;
}

static void
protocol_elem_instance_init (ProtocolElem * self,
                             gpointer klass)
{
	self->priv = protocol_elem_get_instance_private (self);
	self->priv->short_name = NULL;
	self->priv->protocol_info = NULL;
}

static void
protocol_elem_finalize (UIListing * obj)
{
	ProtocolElem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROTOCOL_ELEM, ProtocolElem);
	_g_free0 (self->priv->short_name);
	_g_free0 (self->priv->protocol_info);
	_g_object_unref0 (self->priv->uris);
	UI_LISTING_CLASS (protocol_elem_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
protocol_elem_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ProtocolElemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) protocol_elem_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ProtocolElem), 0, (GInstanceInitFunc) protocol_elem_instance_init, NULL };
	GType protocol_elem_type_id;
	protocol_elem_type_id = g_type_register_static (TYPE_UI_LISTING, "ProtocolElem", &g_define_type_info, 0);
	ProtocolElem_private_offset = g_type_add_instance_private (protocol_elem_type_id, sizeof (ProtocolElemPrivate));
	return protocol_elem_type_id;
}

GType
protocol_elem_get_type (void)
{
	static volatile gsize protocol_elem_type_id__once = 0;
	if (g_once_init_enter (&protocol_elem_type_id__once)) {
		GType protocol_elem_type_id;
		protocol_elem_type_id = protocol_elem_get_type_once ();
		g_once_init_leave (&protocol_elem_type_id__once, protocol_elem_type_id);
	}
	return protocol_elem_type_id__once;
}

