/* rygel-plugin.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-plugin.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-core.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include "config.h"
#include <libgupnp/gupnp.h>

#define RYGEL_PLUGIN_PNG_EXT "png"
#define RYGEL_PLUGIN_JPG_EXT "jpg"
#define RYGEL_PLUGIN_ICON_BIG "file://" BIG_ICON_DIR "/rygel"
#define RYGEL_PLUGIN_ICON_PNG_BIG RYGEL_PLUGIN_ICON_BIG "." RYGEL_PLUGIN_PNG_EXT
#define RYGEL_PLUGIN_ICON_JPG_BIG RYGEL_PLUGIN_ICON_BIG "." RYGEL_PLUGIN_JPG_EXT
#define RYGEL_PLUGIN_ICON_SMALL "file://" SMALL_ICON_DIR "/rygel"
#define RYGEL_PLUGIN_ICON_PNG_SMALL RYGEL_PLUGIN_ICON_SMALL "." RYGEL_PLUGIN_PNG_EXT
#define RYGEL_PLUGIN_ICON_JPG_SMALL RYGEL_PLUGIN_ICON_SMALL "." RYGEL_PLUGIN_JPG_EXT
#define RYGEL_PLUGIN_ICON_PNG_MIME "image/png"
#define RYGEL_PLUGIN_ICON_JPG_MIME "image/jpeg"
#define RYGEL_PLUGIN_ICON_PNG_DEPTH 24
#define RYGEL_PLUGIN_ICON_JPG_DEPTH 24
#define RYGEL_PLUGIN_ICON_BIG_WIDTH 120
#define RYGEL_PLUGIN_ICON_BIG_HEIGHT 120
#define RYGEL_PLUGIN_ICON_SMALL_WIDTH 48
#define RYGEL_PLUGIN_ICON_SMALL_HEIGHT 48
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RYGEL_PLUGIN_0_PROPERTY,
	RYGEL_PLUGIN_CAPABILITIES_PROPERTY,
	RYGEL_PLUGIN_NAME_PROPERTY,
	RYGEL_PLUGIN_TITLE_PROPERTY,
	RYGEL_PLUGIN_DESCRIPTION_PROPERTY,
	RYGEL_PLUGIN_DESC_PATH_PROPERTY,
	RYGEL_PLUGIN_ACTIVE_PROPERTY,
	RYGEL_PLUGIN_RESOURCE_INFOS_PROPERTY,
	RYGEL_PLUGIN_ICON_INFOS_PROPERTY,
	RYGEL_PLUGIN_DEFAULT_ICONS_PROPERTY,
	RYGEL_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* rygel_plugin_properties[RYGEL_PLUGIN_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_resource_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_resource_info_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

struct _RygelPluginPrivate {
	RygelPluginCapabilities _capabilities;
	gchar* _name;
	gchar* _title;
	gchar* _description;
	gchar* _desc_path;
	gboolean _active;
	GeeArrayList* _resource_infos;
	GeeArrayList* _icon_infos;
	GeeArrayList* _default_icons;
};

static gint RygelPlugin_private_offset;
static gpointer rygel_plugin_parent_class = NULL;

static void rygel_plugin_real_constructed (GObject* base);
static void rygel_plugin_set_resource_infos (RygelPlugin* self,
                                      GeeArrayList* value);
static void rygel_plugin_set_icon_infos (RygelPlugin* self,
                                  GeeArrayList* value);
static void rygel_plugin_set_default_icons (RygelPlugin* self,
                                     GeeArrayList* value);
static void rygel_plugin_add_default_icon (RygelPlugin* self,
                                    const gchar* mime_type,
                                    const gchar* file_extension,
                                    const gchar* uri,
                                    gint width,
                                    gint height,
                                    gint depth);
static void rygel_plugin_real_apply_hacks (RygelPlugin* self,
                                    RygelRootDevice* device,
                                    const gchar* description_path,
                                    GError** error);
static void rygel_plugin_finalize (GObject * obj);
static GType rygel_plugin_get_type_once (void);
static void _vala_rygel_plugin_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_rygel_plugin_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

/**
 * RygelPluginCapabilities is a set of flags that represent various
 * capabilities of plugins.
 */
 G_GNUC_NO_INLINE static GType
rygel_plugin_capabilities_get_type_once (void)
{
	static const GFlagsValue values[] = {{RYGEL_PLUGIN_CAPABILITIES_NONE, "RYGEL_PLUGIN_CAPABILITIES_NONE", "none"}, {RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD, "RYGEL_PLUGIN_CAPABILITIES_IMAGE_UPLOAD", "image-upload"}, {RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD, "RYGEL_PLUGIN_CAPABILITIES_VIDEO_UPLOAD", "video-upload"}, {RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD, "RYGEL_PLUGIN_CAPABILITIES_AUDIO_UPLOAD", "audio-upload"}, {RYGEL_PLUGIN_CAPABILITIES_UPLOAD, "RYGEL_PLUGIN_CAPABILITIES_UPLOAD", "upload"}, {RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES, "RYGEL_PLUGIN_CAPABILITIES_TRACK_CHANGES", "track-changes"}, {RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS, "RYGEL_PLUGIN_CAPABILITIES_CREATE_CONTAINERS", "create-containers"}, {RYGEL_PLUGIN_CAPABILITIES_DIAGNOSTICS, "RYGEL_PLUGIN_CAPABILITIES_DIAGNOSTICS", "diagnostics"}, {RYGEL_PLUGIN_CAPABILITIES_ENERGY_MANAGEMENT, "RYGEL_PLUGIN_CAPABILITIES_ENERGY_MANAGEMENT", "energy-management"}, {0, NULL, NULL}};
	GType rygel_plugin_capabilities_type_id;
	rygel_plugin_capabilities_type_id = g_flags_register_static ("RygelPluginCapabilities", values);
	return rygel_plugin_capabilities_type_id;
}

GType
rygel_plugin_capabilities_get_type (void)
{
	static volatile gsize rygel_plugin_capabilities_type_id__once = 0;
	if (g_once_init_enter (&rygel_plugin_capabilities_type_id__once)) {
		GType rygel_plugin_capabilities_type_id;
		rygel_plugin_capabilities_type_id = rygel_plugin_capabilities_get_type_once ();
		g_once_init_leave (&rygel_plugin_capabilities_type_id__once, rygel_plugin_capabilities_type_id);
	}
	return rygel_plugin_capabilities_type_id__once;
}

static inline gpointer
rygel_plugin_get_instance_private (RygelPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, RygelPlugin_private_offset);
}

/** 
     * Create an instance of the plugin.
     *
     * @param desc_path The path of a template file for an XML description of the UPnP service.
     * @param name The non-human-readable name for the plugin and its service, used in UPnP messages and in the Rygel configuration file.
     * @param title An optional human-readable name (friendlyName) of the UPnP service provided by the plugin. If the title is empty then the name will be used.
     * @param description An optional human-readable description (modelDescription) of the UPnP service provided by the plugin.
     */
RygelPlugin*
rygel_plugin_construct (GType object_type,
                        const gchar* desc_path,
                        const gchar* name,
                        const gchar* title,
                        const gchar* description,
                        RygelPluginCapabilities capabilities)
{
	RygelPlugin * self = NULL;
	g_return_val_if_fail (desc_path != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (RygelPlugin*) g_object_new (object_type, "desc-path", desc_path, "name", name, "title", title, "description", description, "capabilities", capabilities, NULL);
	return self;
}

RygelPlugin*
rygel_plugin_new (const gchar* desc_path,
                  const gchar* name,
                  const gchar* title,
                  const gchar* description,
                  RygelPluginCapabilities capabilities)
{
	return rygel_plugin_construct (RYGEL_TYPE_PLUGIN, desc_path, name, title, description, capabilities);
}

static void
rygel_plugin_real_constructed (GObject* base)
{
	RygelPlugin * self;
	const gchar* _tmp0_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp4_;
	RygelMetaConfig* _tmp14_;
	GeeArrayList* _tmp24_;
	GeeArrayList* _tmp25_;
	GeeArrayList* _tmp26_;
	GeeArrayList* _tmp27_;
	GError* _inner_error0_ = NULL;
	self = (RygelPlugin*) base;
	G_OBJECT_CLASS (rygel_plugin_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gupnp_resource_factory_get_type (), GUPnPResourceFactory));
	rygel_plugin_set_active (self, TRUE);
	_tmp0_ = self->priv->_title;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->_name;
		rygel_plugin_set_title (self, _tmp1_);
	}
	_tmp2_ = gee_array_list_new (RYGEL_TYPE_RESOURCE_INFO, (GBoxedCopyFunc) rygel_resource_info_ref, (GDestroyNotify) rygel_resource_info_unref, NULL, NULL, NULL);
	_tmp3_ = _tmp2_;
	rygel_plugin_set_resource_infos (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = rygel_meta_config_get_default ();
	config = _tmp4_;
	{
		gboolean _tmp5_ = FALSE;
		RygelMetaConfig* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = config;
		_tmp7_ = self->priv->_name;
		_tmp5_ = rygel_configuration_get_bool ((RygelConfiguration*) _tmp6_, _tmp7_, "diagnostics", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_tmp5_) {
			RygelResourceInfo* resource = NULL;
			RygelResourceInfo* _tmp8_;
			RygelResourceInfo* _tmp9_;
			RygelPluginCapabilities _tmp10_;
			_tmp8_ = rygel_resource_info_new (RYGEL_BASIC_MANAGEMENT_UPNP_ID, RYGEL_BASIC_MANAGEMENT_UPNP_TYPE, RYGEL_BASIC_MANAGEMENT_DESCRIPTION_PATH, RYGEL_TYPE_BASIC_MANAGEMENT);
			resource = _tmp8_;
			_tmp9_ = resource;
			rygel_plugin_add_resource (self, _tmp9_);
			_tmp10_ = self->priv->_capabilities;
			rygel_plugin_set_capabilities (self, _tmp10_ | RYGEL_PLUGIN_CAPABILITIES_DIAGNOSTICS);
			_rygel_resource_info_unref0 (resource);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp11_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = _error_;
		if (!g_error_matches (_tmp11_, RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET)) {
			GError* _tmp12_;
			const gchar* _tmp13_;
			_tmp12_ = _error_;
			_tmp13_ = _tmp12_->message;
			g_warning ("rygel-plugin.vala:172: Failed to read configuration: %s", _tmp13_);
		}
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp14_ = rygel_meta_config_get_default ();
	_g_object_unref0 (config);
	config = _tmp14_;
	{
		gboolean _tmp15_ = FALSE;
		RygelMetaConfig* _tmp16_;
		const gchar* _tmp17_;
		_tmp16_ = config;
		_tmp17_ = self->priv->_name;
		_tmp15_ = rygel_configuration_get_bool ((RygelConfiguration*) _tmp16_, _tmp17_, "energy-management", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		if (_tmp15_) {
			RygelResourceInfo* resource = NULL;
			RygelResourceInfo* _tmp18_;
			RygelResourceInfo* _tmp19_;
			RygelPluginCapabilities _tmp20_;
			_tmp18_ = rygel_resource_info_new (RYGEL_ENERGY_MANAGEMENT_UPNP_ID, RYGEL_ENERGY_MANAGEMENT_UPNP_TYPE, RYGEL_ENERGY_MANAGEMENT_DESCRIPTION_PATH, RYGEL_TYPE_ENERGY_MANAGEMENT);
			resource = _tmp18_;
			_tmp19_ = resource;
			rygel_plugin_add_resource (self, _tmp19_);
			_tmp20_ = self->priv->_capabilities;
			rygel_plugin_set_capabilities (self, _tmp20_ | RYGEL_PLUGIN_CAPABILITIES_ENERGY_MANAGEMENT);
			_rygel_resource_info_unref0 (resource);
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp21_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = _error_;
		if (!g_error_matches (_tmp21_, RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET)) {
			GError* _tmp22_;
			const gchar* _tmp23_;
			_tmp22_ = _error_;
			_tmp23_ = _tmp22_->message;
			g_warning ("rygel-plugin.vala:190: Failed to read configuration: %s", _tmp23_);
		}
		_g_error_free0 (_error_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp24_ = gee_array_list_new (RYGEL_TYPE_ICON_INFO, (GBoxedCopyFunc) rygel_icon_info_ref, (GDestroyNotify) rygel_icon_info_unref, NULL, NULL, NULL);
	_tmp25_ = _tmp24_;
	rygel_plugin_set_icon_infos (self, _tmp25_);
	_g_object_unref0 (_tmp25_);
	_tmp26_ = gee_array_list_new (RYGEL_TYPE_ICON_INFO, (GBoxedCopyFunc) rygel_icon_info_ref, (GDestroyNotify) rygel_icon_info_unref, NULL, NULL, NULL);
	_tmp27_ = _tmp26_;
	rygel_plugin_set_default_icons (self, _tmp27_);
	_g_object_unref0 (_tmp27_);
	rygel_plugin_add_default_icon (self, RYGEL_PLUGIN_ICON_PNG_MIME, RYGEL_PLUGIN_PNG_EXT, RYGEL_PLUGIN_ICON_PNG_BIG, RYGEL_PLUGIN_ICON_BIG_WIDTH, RYGEL_PLUGIN_ICON_BIG_HEIGHT, RYGEL_PLUGIN_ICON_PNG_DEPTH);
	rygel_plugin_add_default_icon (self, RYGEL_PLUGIN_ICON_PNG_MIME, RYGEL_PLUGIN_PNG_EXT, RYGEL_PLUGIN_ICON_PNG_SMALL, RYGEL_PLUGIN_ICON_SMALL_WIDTH, RYGEL_PLUGIN_ICON_SMALL_HEIGHT, RYGEL_PLUGIN_ICON_PNG_DEPTH);
	rygel_plugin_add_default_icon (self, RYGEL_PLUGIN_ICON_JPG_MIME, RYGEL_PLUGIN_JPG_EXT, RYGEL_PLUGIN_ICON_JPG_BIG, RYGEL_PLUGIN_ICON_BIG_WIDTH, RYGEL_PLUGIN_ICON_BIG_HEIGHT, RYGEL_PLUGIN_ICON_JPG_DEPTH);
	rygel_plugin_add_default_icon (self, RYGEL_PLUGIN_ICON_JPG_MIME, RYGEL_PLUGIN_JPG_EXT, RYGEL_PLUGIN_ICON_JPG_SMALL, RYGEL_PLUGIN_ICON_SMALL_WIDTH, RYGEL_PLUGIN_ICON_SMALL_HEIGHT, RYGEL_PLUGIN_ICON_JPG_DEPTH);
	_g_object_unref0 (config);
}

void
rygel_plugin_add_resource (RygelPlugin* self,
                           RygelResourceInfo* resource_info)
{
	GeeArrayList* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (resource_info != NULL);
	_tmp0_ = self->priv->_resource_infos;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, resource_info);
	_tmp1_ = resource_info->upnp_type;
	gupnp_resource_factory_register_resource_type ((GUPnPResourceFactory*) self, _tmp1_, resource_info->type);
}

void
rygel_plugin_add_icon (RygelPlugin* self,
                       RygelIconInfo* icon_info)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_info != NULL);
	_tmp0_ = self->priv->_icon_infos;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, icon_info);
}

static void
rygel_plugin_real_apply_hacks (RygelPlugin* self,
                               RygelRootDevice* device,
                               const gchar* description_path,
                               GError** error)
{
	g_return_if_fail (device != NULL);
	g_return_if_fail (description_path != NULL);
}

void
rygel_plugin_apply_hacks (RygelPlugin* self,
                          RygelRootDevice* device,
                          const gchar* description_path,
                          GError** error)
{
	RygelPluginClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = RYGEL_PLUGIN_GET_CLASS (self);
	if (_klass_->apply_hacks) {
		_klass_->apply_hacks (self, device, description_path, error);
	}
}

static void
rygel_plugin_add_default_icon (RygelPlugin* self,
                               const gchar* mime_type,
                               const gchar* file_extension,
                               const gchar* uri,
                               gint width,
                               gint height,
                               gint depth)
{
	RygelIconInfo* icon = NULL;
	RygelIconInfo* _tmp0_;
	gchar* _tmp1_;
	GeeArrayList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mime_type != NULL);
	g_return_if_fail (file_extension != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = rygel_icon_info_new (mime_type, file_extension);
	icon = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (icon->uri);
	icon->uri = _tmp1_;
	icon->width = width;
	icon->height = height;
	icon->depth = depth;
	_tmp2_ = self->priv->_default_icons;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, icon);
	_rygel_icon_info_unref0 (icon);
}

RygelPluginCapabilities
rygel_plugin_get_capabilities (RygelPlugin* self)
{
	RygelPluginCapabilities result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_capabilities;
	return result;
}

void
rygel_plugin_set_capabilities (RygelPlugin* self,
                               RygelPluginCapabilities value)
{
	RygelPluginCapabilities old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_plugin_get_capabilities (self);
	if (old_value != value) {
		self->priv->_capabilities = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_properties[RYGEL_PLUGIN_CAPABILITIES_PROPERTY]);
	}
}

const gchar*
rygel_plugin_get_name (RygelPlugin* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
rygel_plugin_set_name (RygelPlugin* self,
                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_plugin_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_properties[RYGEL_PLUGIN_NAME_PROPERTY]);
	}
}

const gchar*
rygel_plugin_get_title (RygelPlugin* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

void
rygel_plugin_set_title (RygelPlugin* self,
                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_plugin_get_title (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_properties[RYGEL_PLUGIN_TITLE_PROPERTY]);
	}
}

const gchar*
rygel_plugin_get_description (RygelPlugin* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

static void
rygel_plugin_set_description (RygelPlugin* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_plugin_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_properties[RYGEL_PLUGIN_DESCRIPTION_PROPERTY]);
	}
}

const gchar*
rygel_plugin_get_desc_path (RygelPlugin* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_desc_path;
	result = _tmp0_;
	return result;
}

static void
rygel_plugin_set_desc_path (RygelPlugin* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_plugin_get_desc_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_desc_path);
		self->priv->_desc_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_properties[RYGEL_PLUGIN_DESC_PATH_PROPERTY]);
	}
}

gboolean
rygel_plugin_get_active (RygelPlugin* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}

void
rygel_plugin_set_active (RygelPlugin* self,
                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_plugin_get_active (self);
	if (old_value != value) {
		self->priv->_active = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_properties[RYGEL_PLUGIN_ACTIVE_PROPERTY]);
	}
}

GeeArrayList*
rygel_plugin_get_resource_infos (RygelPlugin* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_resource_infos;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_plugin_set_resource_infos (RygelPlugin* self,
                                 GeeArrayList* value)
{
	GeeArrayList* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_plugin_get_resource_infos (self);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_resource_infos);
		self->priv->_resource_infos = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_properties[RYGEL_PLUGIN_RESOURCE_INFOS_PROPERTY]);
	}
}

GeeArrayList*
rygel_plugin_get_icon_infos (RygelPlugin* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_infos;
	result = _tmp0_;
	return result;
}

static void
rygel_plugin_set_icon_infos (RygelPlugin* self,
                             GeeArrayList* value)
{
	GeeArrayList* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_plugin_get_icon_infos (self);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon_infos);
		self->priv->_icon_infos = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_properties[RYGEL_PLUGIN_ICON_INFOS_PROPERTY]);
	}
}

GeeArrayList*
rygel_plugin_get_default_icons (RygelPlugin* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_icons;
	result = _tmp0_;
	return result;
}

static void
rygel_plugin_set_default_icons (RygelPlugin* self,
                                GeeArrayList* value)
{
	GeeArrayList* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_plugin_get_default_icons (self);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_default_icons);
		self->priv->_default_icons = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_plugin_properties[RYGEL_PLUGIN_DEFAULT_ICONS_PROPERTY]);
	}
}

static void
rygel_plugin_class_init (RygelPluginClass * klass,
                         gpointer klass_data)
{
	rygel_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelPlugin_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) rygel_plugin_real_constructed;
	((RygelPluginClass *) klass)->apply_hacks = (void (*) (RygelPlugin*, RygelRootDevice*, const gchar*, GError**)) rygel_plugin_real_apply_hacks;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_plugin_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_CAPABILITIES_PROPERTY, rygel_plugin_properties[RYGEL_PLUGIN_CAPABILITIES_PROPERTY] = g_param_spec_flags ("capabilities", "capabilities", "capabilities", RYGEL_TYPE_PLUGIN_CAPABILITIES, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_NAME_PROPERTY, rygel_plugin_properties[RYGEL_PLUGIN_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_TITLE_PROPERTY, rygel_plugin_properties[RYGEL_PLUGIN_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_DESCRIPTION_PROPERTY, rygel_plugin_properties[RYGEL_PLUGIN_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_DESC_PATH_PROPERTY, rygel_plugin_properties[RYGEL_PLUGIN_DESC_PATH_PROPERTY] = g_param_spec_string ("desc-path", "desc-path", "desc-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_ACTIVE_PROPERTY, rygel_plugin_properties[RYGEL_PLUGIN_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_RESOURCE_INFOS_PROPERTY, rygel_plugin_properties[RYGEL_PLUGIN_RESOURCE_INFOS_PROPERTY] = g_param_spec_object ("resource-infos", "resource-infos", "resource-infos", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_ICON_INFOS_PROPERTY, rygel_plugin_properties[RYGEL_PLUGIN_ICON_INFOS_PROPERTY] = g_param_spec_object ("icon-infos", "icon-infos", "icon-infos", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLUGIN_DEFAULT_ICONS_PROPERTY, rygel_plugin_properties[RYGEL_PLUGIN_DEFAULT_ICONS_PROPERTY] = g_param_spec_object ("default-icons", "default-icons", "default-icons", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
rygel_plugin_instance_init (RygelPlugin * self,
                            gpointer klass)
{
	self->priv = rygel_plugin_get_instance_private (self);
}

static void
rygel_plugin_finalize (GObject * obj)
{
	RygelPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_PLUGIN, RygelPlugin);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_free0 (self->priv->_desc_path);
	_g_object_unref0 (self->priv->_resource_infos);
	_g_object_unref0 (self->priv->_icon_infos);
	_g_object_unref0 (self->priv->_default_icons);
	G_OBJECT_CLASS (rygel_plugin_parent_class)->finalize (obj);
}

/**
 * This represents a Rygel plugin.
 *
 * Plugin libraries should provide an object of this
 * class or a subclass in their module_init() function.
 *
 * It is generally convenient to derive from 
 * #RygelMediaRendererPlugin from librygel-renderer,
 * or from #RygelMediaServerPlugin from librygel-server.
 *
 * Plugins may change their behaviour based on their
 * configuration. See rygel_meta_config_get_default().
 */
 G_GNUC_NO_INLINE static GType
rygel_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlugin), 0, (GInstanceInitFunc) rygel_plugin_instance_init, NULL };
	GType rygel_plugin_type_id;
	rygel_plugin_type_id = g_type_register_static (gupnp_resource_factory_get_type (), "RygelPlugin", &g_define_type_info, 0);
	RygelPlugin_private_offset = g_type_add_instance_private (rygel_plugin_type_id, sizeof (RygelPluginPrivate));
	return rygel_plugin_type_id;
}

GType
rygel_plugin_get_type (void)
{
	static volatile gsize rygel_plugin_type_id__once = 0;
	if (g_once_init_enter (&rygel_plugin_type_id__once)) {
		GType rygel_plugin_type_id;
		rygel_plugin_type_id = rygel_plugin_get_type_once ();
		g_once_init_leave (&rygel_plugin_type_id__once, rygel_plugin_type_id);
	}
	return rygel_plugin_type_id__once;
}

static void
_vala_rygel_plugin_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	RygelPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLUGIN, RygelPlugin);
	switch (property_id) {
		case RYGEL_PLUGIN_CAPABILITIES_PROPERTY:
		g_value_set_flags (value, rygel_plugin_get_capabilities (self));
		break;
		case RYGEL_PLUGIN_NAME_PROPERTY:
		g_value_set_string (value, rygel_plugin_get_name (self));
		break;
		case RYGEL_PLUGIN_TITLE_PROPERTY:
		g_value_set_string (value, rygel_plugin_get_title (self));
		break;
		case RYGEL_PLUGIN_DESCRIPTION_PROPERTY:
		g_value_set_string (value, rygel_plugin_get_description (self));
		break;
		case RYGEL_PLUGIN_DESC_PATH_PROPERTY:
		g_value_set_string (value, rygel_plugin_get_desc_path (self));
		break;
		case RYGEL_PLUGIN_ACTIVE_PROPERTY:
		g_value_set_boolean (value, rygel_plugin_get_active (self));
		break;
		case RYGEL_PLUGIN_RESOURCE_INFOS_PROPERTY:
		g_value_set_object (value, rygel_plugin_get_resource_infos (self));
		break;
		case RYGEL_PLUGIN_ICON_INFOS_PROPERTY:
		g_value_set_object (value, rygel_plugin_get_icon_infos (self));
		break;
		case RYGEL_PLUGIN_DEFAULT_ICONS_PROPERTY:
		g_value_set_object (value, rygel_plugin_get_default_icons (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_plugin_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	RygelPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLUGIN, RygelPlugin);
	switch (property_id) {
		case RYGEL_PLUGIN_CAPABILITIES_PROPERTY:
		rygel_plugin_set_capabilities (self, g_value_get_flags (value));
		break;
		case RYGEL_PLUGIN_NAME_PROPERTY:
		rygel_plugin_set_name (self, g_value_get_string (value));
		break;
		case RYGEL_PLUGIN_TITLE_PROPERTY:
		rygel_plugin_set_title (self, g_value_get_string (value));
		break;
		case RYGEL_PLUGIN_DESCRIPTION_PROPERTY:
		rygel_plugin_set_description (self, g_value_get_string (value));
		break;
		case RYGEL_PLUGIN_DESC_PATH_PROPERTY:
		rygel_plugin_set_desc_path (self, g_value_get_string (value));
		break;
		case RYGEL_PLUGIN_ACTIVE_PROPERTY:
		rygel_plugin_set_active (self, g_value_get_boolean (value));
		break;
		case RYGEL_PLUGIN_RESOURCE_INFOS_PROPERTY:
		rygel_plugin_set_resource_infos (self, g_value_get_object (value));
		break;
		case RYGEL_PLUGIN_ICON_INFOS_PROPERTY:
		rygel_plugin_set_icon_infos (self, g_value_get_object (value));
		break;
		case RYGEL_PLUGIN_DEFAULT_ICONS_PROPERTY:
		rygel_plugin_set_default_icons (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

