// @(#)root/main:$Id$
// Author: Enric Tejedor   07/10/15

/*************************************************************************
 * Copyright (C) 1995-2000, Rene Brun and Fons Rademakers.               *
 * All rights reserved.                                                  *
 *                                                                       *
 * For the licensing terms see $ROOTSYS/LICENSE.                         *
 * For the list of contributors see $ROOTSYS/README/CREDITS.             *
 *************************************************************************/

//////////////////////////////////////////////////////////////////////////
//                                                                      //
// NBMain                                                               //
//                                                                      //
// Main program used to spawn a ROOT notebook                           //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#include "RConfigure.h"

#include "TCollection.h"
#include "TList.h"
#include "TROOT.h"
#include "TSystem.h"
#include "TSystemDirectory.h"
#include "TSystemFile.h"

#include <fstream>
#include <string>
#include <memory>

#ifdef WIN32
#include <algorithm> // for std::replace
#endif

#define JUPYTER_CMD        "jupyter"
#define NB_OPT             "notebook"
#define JUPYTER_CONF_PATH_V "JUPYTER_CONFIG_PATH"
#define JUPYTER_PATH_V     "JUPYTER_PATH"

using std::string, std::ifstream, std::ofstream, std::ios, std::endl;

#ifdef WIN32
#include <process.h>
constexpr const char *pathsep = "\\";
#define execlp _execlp
#else
constexpr const char *pathsep = "/";
#endif

////////////////////////////////////////////////////////////////////////////////
/// Spawn a Jupyter notebook customised by ROOT.

int main(int argc, char **argv)
{
   // Set IPython directory for the ROOT notebook flavour
   string rootnbpath = pathsep + string("etc") + pathsep + string("root") + pathsep + string("notebook");
   string jupyconfpathdir(JUPYTER_CONF_PATH_V + ("=" + rootnbpath));
   string jupypathdir(JUPYTER_PATH_V + ("=" + rootnbpath));
   putenv((char *)jupyconfpathdir.c_str());
   putenv((char *)jupypathdir.c_str());

   char **jargv = new char* [argc + 2];
   jargv[0] = (char *) JUPYTER_CMD;
   jargv[1] = (char *) NB_OPT;
   for (int n=1;n<argc;++n)
      jargv[n+1] = argv[n];
   jargv[argc+1] = nullptr;

   // Execute IPython notebook
   execvp(JUPYTER_CMD, jargv);

   // Exec failed
   fprintf(stderr,
           "Error starting ROOT notebook -- please check that Jupyter is installed\n");

   delete [] jargv;
   return 1;
}
