/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __KMEM_READER_BPF_SKEL_H__
#define __KMEM_READER_BPF_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

#define BPF_SKEL_SUPPORTS_MAP_AUTO_ATTACH 1

struct kmem_reader_bpf {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *bss;
	} maps;
	struct {
		struct bpf_program *kmem_read;
	} progs;
	struct {
		struct bpf_link *kmem_read;
	} links;
	struct kmem_reader_bpf__bss {
		long value;
		long addr;
		int read_err;
	} *bss;

#ifdef __cplusplus
	static inline struct kmem_reader_bpf *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct kmem_reader_bpf *open_and_load();
	static inline int load(struct kmem_reader_bpf *skel);
	static inline int attach(struct kmem_reader_bpf *skel);
	static inline void detach(struct kmem_reader_bpf *skel);
	static inline void destroy(struct kmem_reader_bpf *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
kmem_reader_bpf__destroy(struct kmem_reader_bpf *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
kmem_reader_bpf__create_skeleton(struct kmem_reader_bpf *obj);

static inline struct kmem_reader_bpf *
kmem_reader_bpf__open_opts(const struct bpf_object_open_opts *opts)
{
	struct kmem_reader_bpf *obj;
	int err;

	obj = (struct kmem_reader_bpf *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = kmem_reader_bpf__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	kmem_reader_bpf__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct kmem_reader_bpf *
kmem_reader_bpf__open(void)
{
	return kmem_reader_bpf__open_opts(NULL);
}

static inline int
kmem_reader_bpf__load(struct kmem_reader_bpf *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct kmem_reader_bpf *
kmem_reader_bpf__open_and_load(void)
{
	struct kmem_reader_bpf *obj;
	int err;

	obj = kmem_reader_bpf__open();
	if (!obj)
		return NULL;
	err = kmem_reader_bpf__load(obj);
	if (err) {
		kmem_reader_bpf__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
kmem_reader_bpf__attach(struct kmem_reader_bpf *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
kmem_reader_bpf__detach(struct kmem_reader_bpf *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *kmem_reader_bpf__elf_bytes(size_t *sz);

static inline int
kmem_reader_bpf__create_skeleton(struct kmem_reader_bpf *obj)
{
	struct bpf_object_skeleton *s;
	struct bpf_map_skeleton *map __attribute__((unused));
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "kmem_reader_bpf";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 1;
	s->map_skel_sz = 24;
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt,
			sizeof(*s->maps) > 24 ? sizeof(*s->maps) : 24);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	map = (struct bpf_map_skeleton *)((char *)s->maps + 0 * s->map_skel_sz);
	map->name = "kmem_rea.bss";
	map->map = &obj->maps.bss;
	map->mmaped = (void **)&obj->bss;

	/* programs */
	s->prog_cnt = 1;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "kmem_read";
	s->progs[0].prog = &obj->progs.kmem_read;
	s->progs[0].link = &obj->links.kmem_read;

	s->data = kmem_reader_bpf__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *kmem_reader_bpf__elf_bytes(size_t *sz)
{
	static const char data[] __attribute__((__aligned__(8))) = "\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x98\x04\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x09\0\
\x01\0\0\x2e\x73\x74\x72\x74\x61\x62\0\x2e\x73\x79\x6d\x74\x61\x62\0\x72\x61\
\x77\x5f\x74\x70\0\x6c\x69\x63\x65\x6e\x73\x65\0\x2e\x62\x73\x73\0\x6b\x6d\x65\
\x6d\x5f\x72\x65\x61\x64\x65\x72\x2e\x62\x70\x66\x2e\x63\0\x6b\x6d\x65\x6d\x5f\
\x72\x65\x61\x64\0\x61\x64\x64\x72\0\x76\x61\x6c\x75\x65\0\x72\x65\x61\x64\x5f\
\x65\x72\x72\0\x4c\x49\x43\x45\x4e\x53\x45\0\x2e\x72\x65\x6c\x72\x61\x77\x5f\
\x74\x70\0\x2e\x42\x54\x46\0\x2e\x42\x54\x46\x2e\x65\x78\x74\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x25\0\0\0\x04\0\xf1\xff\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x03\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x37\0\0\0\
\x12\0\x03\0\0\0\0\0\0\0\0\0\x60\0\0\0\0\0\0\0\x41\0\0\0\x11\0\x05\0\x08\0\0\0\
\0\0\0\0\x08\0\0\0\0\0\0\0\x46\0\0\0\x11\0\x05\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\
\0\0\x4c\0\0\0\x11\0\x05\0\x10\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\x55\0\0\0\x11\0\
\x04\0\0\0\0\0\0\0\0\0\x0d\0\0\0\0\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x79\x13\0\0\0\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb4\x02\0\0\x08\0\0\0\
\x85\0\0\0\x71\0\0\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x63\x01\0\0\0\0\0\0\
\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\x44\x75\x61\x6c\x20\x42\x53\x44\x2f\x47\
\x50\x4c\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\x04\0\0\0\x18\0\0\0\0\0\0\0\x01\0\0\
\0\x05\0\0\0\x38\0\0\0\0\0\0\0\x01\0\0\0\x06\0\0\0\x9f\xeb\x01\0\x18\0\0\0\0\0\
\0\0\x0c\x01\0\0\x0c\x01\0\0\xdb\0\0\0\0\0\0\0\0\0\0\x02\0\0\0\0\0\0\0\0\x01\0\
\0\x0d\x03\0\0\0\x01\0\0\0\x01\0\0\0\x05\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\x01\
\x09\0\0\0\x01\0\0\x0c\x02\0\0\0\x13\0\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\x01\0\0\
\0\0\0\0\0\x03\0\0\0\0\x05\0\0\0\x07\0\0\0\x0d\0\0\0\x18\0\0\0\0\0\0\x01\x04\0\
\0\0\x20\0\0\0\x2c\0\0\0\0\0\0\x0e\x06\0\0\0\x01\0\0\0\x34\0\0\0\0\0\0\x01\x08\
\0\0\0\x40\0\0\x01\x39\0\0\0\0\0\0\x0e\x09\0\0\0\x01\0\0\0\x3f\0\0\0\0\0\0\x0e\
\x09\0\0\0\x01\0\0\0\x44\0\0\0\0\0\0\x0e\x03\0\0\0\x01\0\0\0\xc7\0\0\0\x01\0\0\
\x0f\x0d\0\0\0\x08\0\0\0\0\0\0\0\x0d\0\0\0\xcf\0\0\0\x03\0\0\x0f\x14\0\0\0\x0a\
\0\0\0\0\0\0\0\x08\0\0\0\x0b\0\0\0\x08\0\0\0\x08\0\0\0\x0c\0\0\0\x10\0\0\0\x04\
\0\0\0\0\x63\x74\x78\0\x69\x6e\x74\0\x6b\x6d\x65\x6d\x5f\x72\x65\x61\x64\0\x63\
\x68\x61\x72\0\x5f\x5f\x41\x52\x52\x41\x59\x5f\x53\x49\x5a\x45\x5f\x54\x59\x50\
\x45\x5f\x5f\0\x4c\x49\x43\x45\x4e\x53\x45\0\x6c\x6f\x6e\x67\0\x76\x61\x6c\x75\
\x65\0\x61\x64\x64\x72\0\x72\x65\x61\x64\x5f\x65\x72\x72\0\x2f\x62\x75\x69\x6c\
\x64\x2f\x72\x65\x74\x73\x6e\x6f\x6f\x70\x2f\x73\x72\x63\x2f\x72\x65\x74\x73\
\x6e\x6f\x6f\x70\x2f\x73\x72\x63\x2f\x6b\x6d\x65\x6d\x5f\x72\x65\x61\x64\x65\
\x72\x2e\x62\x70\x66\x2e\x63\0\x09\x72\x65\x61\x64\x5f\x65\x72\x72\x20\x3d\x20\
\x62\x70\x66\x5f\x70\x72\x6f\x62\x65\x5f\x72\x65\x61\x64\x5f\x6b\x65\x72\x6e\
\x65\x6c\x28\x26\x76\x61\x6c\x75\x65\x2c\x20\x38\x2c\x20\x28\x76\x6f\x69\x64\
\x20\x2a\x29\x61\x64\x64\x72\x29\x3b\0\x09\x72\x65\x74\x75\x72\x6e\x20\x30\x3b\
\0\x6c\x69\x63\x65\x6e\x73\x65\0\x2e\x62\x73\x73\0\x72\x61\x77\x5f\x74\x70\0\0\
\x9f\xeb\x01\0\x20\0\0\0\0\0\0\0\x14\0\0\0\x14\0\0\0\x4c\0\0\0\x60\0\0\0\0\0\0\
\0\x08\0\0\0\xd4\0\0\0\x01\0\0\0\0\0\0\0\x04\0\0\0\x10\0\0\0\xd4\0\0\0\x04\0\0\
\0\0\0\0\0\x4d\0\0\0\x80\0\0\0\x36\x44\0\0\x18\0\0\0\x4d\0\0\0\x80\0\0\0\x0d\
\x44\0\0\x38\0\0\0\x4d\0\0\0\x80\0\0\0\x0b\x44\0\0\x50\0\0\0\x4d\0\0\0\xbc\0\0\
\0\x02\x48\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\x03\
\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\x76\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x09\0\0\0\x02\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\xb8\0\0\0\0\0\0\0\xc0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\
\x08\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\0\x11\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x78\x01\0\0\0\0\0\0\x60\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x18\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\xd8\x01\0\0\0\0\0\0\x0d\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x20\0\0\0\x08\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xe8\x01\0\0\0\
\0\0\0\x14\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x5d\
\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xe8\x01\0\0\0\0\0\0\x30\0\0\
\0\0\0\0\0\x02\0\0\0\x03\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x68\0\0\0\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x18\x02\0\0\0\0\0\0\xff\x01\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x6d\0\0\0\x01\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x18\x04\0\0\0\0\0\0\x80\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0";

	*sz = sizeof(data) - 1;
	return (const void *)data;
}

#ifdef __cplusplus
struct kmem_reader_bpf *kmem_reader_bpf::open(const struct bpf_object_open_opts *opts) { return kmem_reader_bpf__open_opts(opts); }
struct kmem_reader_bpf *kmem_reader_bpf::open_and_load() { return kmem_reader_bpf__open_and_load(); }
int kmem_reader_bpf::load(struct kmem_reader_bpf *skel) { return kmem_reader_bpf__load(skel); }
int kmem_reader_bpf::attach(struct kmem_reader_bpf *skel) { return kmem_reader_bpf__attach(skel); }
void kmem_reader_bpf::detach(struct kmem_reader_bpf *skel) { kmem_reader_bpf__detach(skel); }
void kmem_reader_bpf::destroy(struct kmem_reader_bpf *skel) { kmem_reader_bpf__destroy(skel); }
const void *kmem_reader_bpf::elf_bytes(size_t *sz) { return kmem_reader_bpf__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
kmem_reader_bpf__assert(struct kmem_reader_bpf *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
	_Static_assert(sizeof(s->bss->value) == 8, "unexpected size of 'value'");
	_Static_assert(sizeof(s->bss->addr) == 8, "unexpected size of 'addr'");
	_Static_assert(sizeof(s->bss->read_err) == 4, "unexpected size of 'read_err'");
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __KMEM_READER_BPF_SKEL_H__ */
