/* Generated by wayland-scanner 1.24.0 */

#ifndef HYPRLAND_TOPLEVEL_MAPPING_V1_CLIENT_PROTOCOL_H
#define HYPRLAND_TOPLEVEL_MAPPING_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_hyprland_toplevel_mapping_v1 The hyprland_toplevel_mapping_v1 protocol
 * mapping of toplevels to windows
 *
 * @section page_desc_hyprland_toplevel_mapping_v1 Description
 *
 * This protocol allows clients to retrieve the mapping of toplevels to hyprland window addresses.
 *
 * @section page_ifaces_hyprland_toplevel_mapping_v1 Interfaces
 * - @subpage page_iface_hyprland_toplevel_mapping_manager_v1 - manager to request toplevel mappings
 * - @subpage page_iface_hyprland_toplevel_window_mapping_handle_v1 - toplevel to window mapping
 * @section page_copyright_hyprland_toplevel_mapping_v1 Copyright
 * <pre>
 *
 * Copyright © 2025 WhySoBad
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * </pre>
 */
struct hyprland_toplevel_mapping_manager_v1;
struct hyprland_toplevel_window_mapping_handle_v1;
struct zwlr_foreign_toplevel_handle_v1;

#ifndef HYPRLAND_TOPLEVEL_MAPPING_MANAGER_V1_INTERFACE
#define HYPRLAND_TOPLEVEL_MAPPING_MANAGER_V1_INTERFACE
/**
 * @page page_iface_hyprland_toplevel_mapping_manager_v1 hyprland_toplevel_mapping_manager_v1
 * @section page_iface_hyprland_toplevel_mapping_manager_v1_desc Description
 *
 * This object is a manager which offers requests to retrieve a window address
 * for a toplevel.
 * @section page_iface_hyprland_toplevel_mapping_manager_v1_api API
 * See @ref iface_hyprland_toplevel_mapping_manager_v1.
 */
/**
 * @defgroup iface_hyprland_toplevel_mapping_manager_v1 The hyprland_toplevel_mapping_manager_v1 interface
 *
 * This object is a manager which offers requests to retrieve a window address
 * for a toplevel.
 */
extern const struct wl_interface hyprland_toplevel_mapping_manager_v1_interface;
#endif
#ifndef HYPRLAND_TOPLEVEL_WINDOW_MAPPING_HANDLE_V1_INTERFACE
#define HYPRLAND_TOPLEVEL_WINDOW_MAPPING_HANDLE_V1_INTERFACE
/**
 * @page page_iface_hyprland_toplevel_window_mapping_handle_v1 hyprland_toplevel_window_mapping_handle_v1
 * @section page_iface_hyprland_toplevel_window_mapping_handle_v1_desc Description
 *
 * This object represents a mapping of a (wlr) toplevel to a window address.
 *
 * Once created, the `window_address` event will be sent containing the address of the window
 * associated with the toplevel.
 * Should the mapping fail, the `failed` event will be sent.
 * @section page_iface_hyprland_toplevel_window_mapping_handle_v1_api API
 * See @ref iface_hyprland_toplevel_window_mapping_handle_v1.
 */
/**
 * @defgroup iface_hyprland_toplevel_window_mapping_handle_v1 The hyprland_toplevel_window_mapping_handle_v1 interface
 *
 * This object represents a mapping of a (wlr) toplevel to a window address.
 *
 * Once created, the `window_address` event will be sent containing the address of the window
 * associated with the toplevel.
 * Should the mapping fail, the `failed` event will be sent.
 */
extern const struct wl_interface hyprland_toplevel_window_mapping_handle_v1_interface;
#endif

#define HYPRLAND_TOPLEVEL_MAPPING_MANAGER_V1_GET_WINDOW_FOR_TOPLEVEL 0
#define HYPRLAND_TOPLEVEL_MAPPING_MANAGER_V1_GET_WINDOW_FOR_TOPLEVEL_WLR 1
#define HYPRLAND_TOPLEVEL_MAPPING_MANAGER_V1_DESTROY 2


/**
 * @ingroup iface_hyprland_toplevel_mapping_manager_v1
 */
#define HYPRLAND_TOPLEVEL_MAPPING_MANAGER_V1_GET_WINDOW_FOR_TOPLEVEL_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_toplevel_mapping_manager_v1
 */
#define HYPRLAND_TOPLEVEL_MAPPING_MANAGER_V1_GET_WINDOW_FOR_TOPLEVEL_WLR_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_toplevel_mapping_manager_v1
 */
#define HYPRLAND_TOPLEVEL_MAPPING_MANAGER_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_hyprland_toplevel_mapping_manager_v1 */
static inline void
hyprland_toplevel_mapping_manager_v1_set_user_data(struct hyprland_toplevel_mapping_manager_v1 *hyprland_toplevel_mapping_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) hyprland_toplevel_mapping_manager_v1, user_data);
}

/** @ingroup iface_hyprland_toplevel_mapping_manager_v1 */
static inline void *
hyprland_toplevel_mapping_manager_v1_get_user_data(struct hyprland_toplevel_mapping_manager_v1 *hyprland_toplevel_mapping_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) hyprland_toplevel_mapping_manager_v1);
}

static inline uint32_t
hyprland_toplevel_mapping_manager_v1_get_version(struct hyprland_toplevel_mapping_manager_v1 *hyprland_toplevel_mapping_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) hyprland_toplevel_mapping_manager_v1);
}

/**
 * @ingroup iface_hyprland_toplevel_mapping_manager_v1
 *
 * This request has been edited to remove a compile dep.
 */
static inline void
hyprland_toplevel_mapping_manager_v1_get_window_for_toplevel(struct hyprland_toplevel_mapping_manager_v1 *hyprland_toplevel_mapping_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) hyprland_toplevel_mapping_manager_v1,
			 HYPRLAND_TOPLEVEL_MAPPING_MANAGER_V1_GET_WINDOW_FOR_TOPLEVEL, NULL, wl_proxy_get_version((struct wl_proxy *) hyprland_toplevel_mapping_manager_v1), 0);
}

/**
 * @ingroup iface_hyprland_toplevel_mapping_manager_v1
 *
 * Get the window address for a wlr toplevel.
 */
static inline struct hyprland_toplevel_window_mapping_handle_v1 *
hyprland_toplevel_mapping_manager_v1_get_window_for_toplevel_wlr(struct hyprland_toplevel_mapping_manager_v1 *hyprland_toplevel_mapping_manager_v1, struct zwlr_foreign_toplevel_handle_v1 *toplevel)
{
	struct wl_proxy *handle;

	handle = wl_proxy_marshal_flags((struct wl_proxy *) hyprland_toplevel_mapping_manager_v1,
			 HYPRLAND_TOPLEVEL_MAPPING_MANAGER_V1_GET_WINDOW_FOR_TOPLEVEL_WLR, &hyprland_toplevel_window_mapping_handle_v1_interface, wl_proxy_get_version((struct wl_proxy *) hyprland_toplevel_mapping_manager_v1), 0, NULL, toplevel);

	return (struct hyprland_toplevel_window_mapping_handle_v1 *) handle;
}

/**
 * @ingroup iface_hyprland_toplevel_mapping_manager_v1
 *
 * All objects created by the manager will still remain valid, until their appropriate destroy
 * request has been called.
 */
static inline void
hyprland_toplevel_mapping_manager_v1_destroy(struct hyprland_toplevel_mapping_manager_v1 *hyprland_toplevel_mapping_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) hyprland_toplevel_mapping_manager_v1,
			 HYPRLAND_TOPLEVEL_MAPPING_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) hyprland_toplevel_mapping_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_hyprland_toplevel_window_mapping_handle_v1
 * @struct hyprland_toplevel_window_mapping_handle_v1_listener
 */
struct hyprland_toplevel_window_mapping_handle_v1_listener {
	/**
	 * address of the window
	 *
	 * The full 64bit window address. The `address` field contains
	 * the lower 32 bits whilst the `address_hi` contains the upper 32
	 * bits
	 * @param address_hi upper 32 bits of the window address
	 * @param address lower 32 bits of the window address
	 */
	void (*window_address)(void *data,
			       struct hyprland_toplevel_window_mapping_handle_v1 *hyprland_toplevel_window_mapping_handle_v1,
			       uint32_t address_hi,
			       uint32_t address);
	/**
	 * mapping failed
	 *
	 * The mapping of the toplevel to a window address failed. Most
	 * likely the window does not exist (anymore).
	 */
	void (*failed)(void *data,
		       struct hyprland_toplevel_window_mapping_handle_v1 *hyprland_toplevel_window_mapping_handle_v1);
};

/**
 * @ingroup iface_hyprland_toplevel_window_mapping_handle_v1
 */
static inline int
hyprland_toplevel_window_mapping_handle_v1_add_listener(struct hyprland_toplevel_window_mapping_handle_v1 *hyprland_toplevel_window_mapping_handle_v1,
							const struct hyprland_toplevel_window_mapping_handle_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) hyprland_toplevel_window_mapping_handle_v1,
				     (void (**)(void)) listener, data);
}

#define HYPRLAND_TOPLEVEL_WINDOW_MAPPING_HANDLE_V1_DESTROY 0

/**
 * @ingroup iface_hyprland_toplevel_window_mapping_handle_v1
 */
#define HYPRLAND_TOPLEVEL_WINDOW_MAPPING_HANDLE_V1_WINDOW_ADDRESS_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_toplevel_window_mapping_handle_v1
 */
#define HYPRLAND_TOPLEVEL_WINDOW_MAPPING_HANDLE_V1_FAILED_SINCE_VERSION 1

/**
 * @ingroup iface_hyprland_toplevel_window_mapping_handle_v1
 */
#define HYPRLAND_TOPLEVEL_WINDOW_MAPPING_HANDLE_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_hyprland_toplevel_window_mapping_handle_v1 */
static inline void
hyprland_toplevel_window_mapping_handle_v1_set_user_data(struct hyprland_toplevel_window_mapping_handle_v1 *hyprland_toplevel_window_mapping_handle_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) hyprland_toplevel_window_mapping_handle_v1, user_data);
}

/** @ingroup iface_hyprland_toplevel_window_mapping_handle_v1 */
static inline void *
hyprland_toplevel_window_mapping_handle_v1_get_user_data(struct hyprland_toplevel_window_mapping_handle_v1 *hyprland_toplevel_window_mapping_handle_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) hyprland_toplevel_window_mapping_handle_v1);
}

static inline uint32_t
hyprland_toplevel_window_mapping_handle_v1_get_version(struct hyprland_toplevel_window_mapping_handle_v1 *hyprland_toplevel_window_mapping_handle_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) hyprland_toplevel_window_mapping_handle_v1);
}

/**
 * @ingroup iface_hyprland_toplevel_window_mapping_handle_v1
 *
 * Destroy the handle. This request can be sent at any time by the client.
 */
static inline void
hyprland_toplevel_window_mapping_handle_v1_destroy(struct hyprland_toplevel_window_mapping_handle_v1 *hyprland_toplevel_window_mapping_handle_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) hyprland_toplevel_window_mapping_handle_v1,
			 HYPRLAND_TOPLEVEL_WINDOW_MAPPING_HANDLE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) hyprland_toplevel_window_mapping_handle_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
