// ui/events/mojom/event.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/events/mojom/event.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "ui/events/mojom/event.mojom-params-data.h"
#include "ui/events/mojom/event.mojom-shared-message-ids.h"

#include "ui/events/mojom/event.mojom-import-headers.h"


#ifndef UI_EVENTS_MOJOM_EVENT_MOJOM_JUMBO_H_
#define UI_EVENTS_MOJOM_EVENT_MOJOM_JUMBO_H_
#include "ui/events/mojom/event_mojom_traits.h"
#endif
namespace ui {
namespace mojom {
KeyData::KeyData()
    : key_code(),
      dom_code(),
      dom_key(),
      is_char() {}

KeyData::KeyData(
    int32_t key_code_in,
    uint32_t dom_code_in,
    int32_t dom_key_in,
    bool is_char_in)
    : key_code(std::move(key_code_in)),
      dom_code(std::move(dom_code_in)),
      dom_key(std::move(dom_key_in)),
      is_char(std::move(is_char_in)) {}

KeyData::~KeyData() = default;
size_t KeyData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->key_code);
  seed = mojo::internal::Hash(seed, this->dom_code);
  seed = mojo::internal::Hash(seed, this->dom_key);
  seed = mojo::internal::Hash(seed, this->is_char);
  return seed;
}

void KeyData::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("key_code", this->key_code);
  value->SetString("dom_code", base::NumberToString(this->dom_code));
  value->SetInteger("dom_key", this->dom_key);
  value->SetBoolean("is_char", this->is_char);
}

bool KeyData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LocationData::LocationData()
    : relative_location(),
      root_location() {}

LocationData::LocationData(
    const ::gfx::PointF& relative_location_in,
    const ::gfx::PointF& root_location_in)
    : relative_location(std::move(relative_location_in)),
      root_location(std::move(root_location_in)) {}

LocationData::~LocationData() = default;

void LocationData::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("relative_location", base::trace_event::ValueToString(this->relative_location, "<value of type const ::gfx::PointF&>"));
  value->SetString("root_location", base::trace_event::ValueToString(this->root_location, "<value of type const ::gfx::PointF&>"));
}

bool LocationData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GestureData::GestureData()
    : location(),
      device_type(),
      scale() {}

GestureData::GestureData(
    LocationDataPtr location_in,
    ::ui::GestureDeviceType device_type_in,
    float scale_in)
    : location(std::move(location_in)),
      device_type(std::move(device_type_in)),
      scale(std::move(scale_in)) {}

GestureData::~GestureData() = default;

void GestureData::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->location.is_null()) {
    value->SetString("location", "nullptr");
  } else {
    value->BeginDictionary("location");
    this->location->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetInteger("device_type", static_cast<int>(this->device_type));
  value->SetDouble("scale", this->scale);
}

bool GestureData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ScrollData::ScrollData()
    : location(),
      x_offset(),
      y_offset(),
      x_offset_ordinal(),
      y_offset_ordinal(),
      finger_count(),
      momentum_phase(),
      scroll_event_phase() {}

ScrollData::ScrollData(
    LocationDataPtr location_in,
    float x_offset_in,
    float y_offset_in,
    float x_offset_ordinal_in,
    float y_offset_ordinal_in,
    int32_t finger_count_in,
    ::ui::EventMomentumPhase momentum_phase_in,
    ::ui::ScrollEventPhase scroll_event_phase_in)
    : location(std::move(location_in)),
      x_offset(std::move(x_offset_in)),
      y_offset(std::move(y_offset_in)),
      x_offset_ordinal(std::move(x_offset_ordinal_in)),
      y_offset_ordinal(std::move(y_offset_ordinal_in)),
      finger_count(std::move(finger_count_in)),
      momentum_phase(std::move(momentum_phase_in)),
      scroll_event_phase(std::move(scroll_event_phase_in)) {}

ScrollData::~ScrollData() = default;

void ScrollData::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->location.is_null()) {
    value->SetString("location", "nullptr");
  } else {
    value->BeginDictionary("location");
    this->location->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetDouble("x_offset", this->x_offset);
  value->SetDouble("y_offset", this->y_offset);
  value->SetDouble("x_offset_ordinal", this->x_offset_ordinal);
  value->SetDouble("y_offset_ordinal", this->y_offset_ordinal);
  value->SetInteger("finger_count", this->finger_count);
  value->SetInteger("momentum_phase", static_cast<int>(this->momentum_phase));
  value->SetInteger("scroll_event_phase", static_cast<int>(this->scroll_event_phase));
}

bool ScrollData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PointerDetails::PointerDetails()
    : pointer_type(),
      radius_x(),
      radius_y(),
      force(),
      tilt_x(),
      tilt_y(),
      tangential_pressure(),
      twist(),
      id(),
      offset_x(),
      offset_y() {}

PointerDetails::PointerDetails(
    ::ui::EventPointerType pointer_type_in,
    float radius_x_in,
    float radius_y_in,
    float force_in,
    float tilt_x_in,
    float tilt_y_in,
    float tangential_pressure_in,
    float twist_in,
    int32_t id_in,
    int32_t offset_x_in,
    int32_t offset_y_in)
    : pointer_type(std::move(pointer_type_in)),
      radius_x(std::move(radius_x_in)),
      radius_y(std::move(radius_y_in)),
      force(std::move(force_in)),
      tilt_x(std::move(tilt_x_in)),
      tilt_y(std::move(tilt_y_in)),
      tangential_pressure(std::move(tangential_pressure_in)),
      twist(std::move(twist_in)),
      id(std::move(id_in)),
      offset_x(std::move(offset_x_in)),
      offset_y(std::move(offset_y_in)) {}

PointerDetails::~PointerDetails() = default;

void PointerDetails::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("pointer_type", static_cast<int>(this->pointer_type));
  value->SetDouble("radius_x", this->radius_x);
  value->SetDouble("radius_y", this->radius_y);
  value->SetDouble("force", this->force);
  value->SetDouble("tilt_x", this->tilt_x);
  value->SetDouble("tilt_y", this->tilt_y);
  value->SetDouble("tangential_pressure", this->tangential_pressure);
  value->SetDouble("twist", this->twist);
  value->SetInteger("id", this->id);
  value->SetInteger("offset_x", this->offset_x);
  value->SetInteger("offset_y", this->offset_y);
}

bool PointerDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MouseData::MouseData()
    : changed_button_flags(),
      location(),
      pointer_details(),
      wheel_offset(),
      tick_120ths() {}

MouseData::MouseData(
    int32_t changed_button_flags_in,
    LocationDataPtr location_in,
    const ::ui::PointerDetails& pointer_details_in,
    const ::gfx::Vector2d& wheel_offset_in,
    const ::gfx::Vector2d& tick_120ths_in)
    : changed_button_flags(std::move(changed_button_flags_in)),
      location(std::move(location_in)),
      pointer_details(std::move(pointer_details_in)),
      wheel_offset(std::move(wheel_offset_in)),
      tick_120ths(std::move(tick_120ths_in)) {}

MouseData::~MouseData() = default;

void MouseData::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("changed_button_flags", this->changed_button_flags);
  if (this->location.is_null()) {
    value->SetString("location", "nullptr");
  } else {
    value->BeginDictionary("location");
    this->location->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("pointer_details", base::trace_event::ValueToString(this->pointer_details, "<value of type const ::ui::PointerDetails&>"));
  value->SetString("wheel_offset", base::trace_event::ValueToString(this->wheel_offset, "<value of type const ::gfx::Vector2d&>"));
  value->SetString("tick_120ths", base::trace_event::ValueToString(this->tick_120ths, "<value of type const ::gfx::Vector2d&>"));
}

bool MouseData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TouchData::TouchData()
    : may_cause_scrolling(),
      hovering(),
      location(),
      pointer_details() {}

TouchData::TouchData(
    bool may_cause_scrolling_in,
    bool hovering_in,
    LocationDataPtr location_in,
    const ::ui::PointerDetails& pointer_details_in)
    : may_cause_scrolling(std::move(may_cause_scrolling_in)),
      hovering(std::move(hovering_in)),
      location(std::move(location_in)),
      pointer_details(std::move(pointer_details_in)) {}

TouchData::~TouchData() = default;

void TouchData::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("may_cause_scrolling", this->may_cause_scrolling);
  value->SetBoolean("hovering", this->hovering);
  if (this->location.is_null()) {
    value->SetString("location", "nullptr");
  } else {
    value->BeginDictionary("location");
    this->location->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("pointer_details", base::trace_event::ValueToString(this->pointer_details, "<value of type const ::ui::PointerDetails&>"));
}

bool TouchData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Event::Event()
    : action(),
      flags(),
      time_stamp(),
      latency(),
      key_data(),
      gesture_data(),
      scroll_data(),
      touch_data(),
      mouse_data(),
      properties() {}

Event::Event(
    ::ui::mojom::EventType action_in,
    int32_t flags_in,
    ::base::TimeTicks time_stamp_in,
    const ::ui::LatencyInfo& latency_in,
    KeyDataPtr key_data_in,
    GestureDataPtr gesture_data_in,
    ScrollDataPtr scroll_data_in,
    TouchDataPtr touch_data_in,
    MouseDataPtr mouse_data_in,
    const base::Optional<base::flat_map<std::string, std::vector<uint8_t>>>& properties_in)
    : action(std::move(action_in)),
      flags(std::move(flags_in)),
      time_stamp(std::move(time_stamp_in)),
      latency(std::move(latency_in)),
      key_data(std::move(key_data_in)),
      gesture_data(std::move(gesture_data_in)),
      scroll_data(std::move(scroll_data_in)),
      touch_data(std::move(touch_data_in)),
      mouse_data(std::move(mouse_data_in)),
      properties(std::move(properties_in)) {}

Event::~Event() = default;

void Event::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("action", base::trace_event::ValueToString(this->action));
  value->SetInteger("flags", this->flags);
  value->SetString("time_stamp", base::trace_event::ValueToString(this->time_stamp, "<value of type ::base::TimeTicks>"));
  value->SetString("latency", base::trace_event::ValueToString(this->latency, "<value of type const ::ui::LatencyInfo&>"));
  if (this->key_data.is_null()) {
    value->SetString("key_data", "nullptr");
  } else {
    value->BeginDictionary("key_data");
    this->key_data->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->gesture_data.is_null()) {
    value->SetString("gesture_data", "nullptr");
  } else {
    value->BeginDictionary("gesture_data");
    this->gesture_data->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->scroll_data.is_null()) {
    value->SetString("scroll_data", "nullptr");
  } else {
    value->BeginDictionary("scroll_data");
    this->scroll_data->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->touch_data.is_null()) {
    value->SetString("touch_data", "nullptr");
  } else {
    value->BeginDictionary("touch_data");
    this->touch_data->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->mouse_data.is_null()) {
    value->SetString("mouse_data", "nullptr");
  } else {
    value->BeginDictionary("mouse_data");
    this->mouse_data->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->properties.has_value()) {
    value->BeginDictionary("properties");
    for (const auto& item0 : this->properties.value()) {
      value->BeginArrayWithCopiedName(base::trace_event::ValueToString(item0.first, "<value of type const std::string&>"));
      for (const auto& item1 : item0.second) {
        value->AppendInteger(item1);
      }
      value->EndArray();
    }
    value->EndDictionary();
  } else {
    value->SetString("properties", "base::nullopt");
  }
}

bool Event::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace ui

namespace mojo {


// static
bool StructTraits<::ui::mojom::KeyData::DataView, ::ui::mojom::KeyDataPtr>::Read(
    ::ui::mojom::KeyData::DataView input,
    ::ui::mojom::KeyDataPtr* output) {
  bool success = true;
  ::ui::mojom::KeyDataPtr result(::ui::mojom::KeyData::New());
  
      if (success)
        result->key_code = input.key_code();
      if (success)
        result->dom_code = input.dom_code();
      if (success)
        result->dom_key = input.dom_key();
      if (success)
        result->is_char = input.is_char();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ui::mojom::LocationData::DataView, ::ui::mojom::LocationDataPtr>::Read(
    ::ui::mojom::LocationData::DataView input,
    ::ui::mojom::LocationDataPtr* output) {
  bool success = true;
  ::ui::mojom::LocationDataPtr result(::ui::mojom::LocationData::New());
  
      if (success && !input.ReadRelativeLocation(&result->relative_location))
        success = false;
      if (success && !input.ReadRootLocation(&result->root_location))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ui::mojom::GestureData::DataView, ::ui::mojom::GestureDataPtr>::Read(
    ::ui::mojom::GestureData::DataView input,
    ::ui::mojom::GestureDataPtr* output) {
  bool success = true;
  ::ui::mojom::GestureDataPtr result(::ui::mojom::GestureData::New());
  
      if (success && !input.ReadLocation(&result->location))
        success = false;
      if (success && !input.ReadDeviceType(&result->device_type))
        success = false;
      if (success)
        result->scale = input.scale();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ui::mojom::ScrollData::DataView, ::ui::mojom::ScrollDataPtr>::Read(
    ::ui::mojom::ScrollData::DataView input,
    ::ui::mojom::ScrollDataPtr* output) {
  bool success = true;
  ::ui::mojom::ScrollDataPtr result(::ui::mojom::ScrollData::New());
  
      if (success && !input.ReadLocation(&result->location))
        success = false;
      if (success)
        result->x_offset = input.x_offset();
      if (success)
        result->y_offset = input.y_offset();
      if (success)
        result->x_offset_ordinal = input.x_offset_ordinal();
      if (success)
        result->y_offset_ordinal = input.y_offset_ordinal();
      if (success)
        result->finger_count = input.finger_count();
      if (success && !input.ReadMomentumPhase(&result->momentum_phase))
        success = false;
      if (success && !input.ReadScrollEventPhase(&result->scroll_event_phase))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ui::mojom::PointerDetails::DataView, ::ui::mojom::PointerDetailsPtr>::Read(
    ::ui::mojom::PointerDetails::DataView input,
    ::ui::mojom::PointerDetailsPtr* output) {
  bool success = true;
  ::ui::mojom::PointerDetailsPtr result(::ui::mojom::PointerDetails::New());
  
      if (success && !input.ReadPointerType(&result->pointer_type))
        success = false;
      if (success)
        result->radius_x = input.radius_x();
      if (success)
        result->radius_y = input.radius_y();
      if (success)
        result->force = input.force();
      if (success)
        result->tilt_x = input.tilt_x();
      if (success)
        result->tilt_y = input.tilt_y();
      if (success)
        result->tangential_pressure = input.tangential_pressure();
      if (success)
        result->twist = input.twist();
      if (success)
        result->id = input.id();
      if (success)
        result->offset_x = input.offset_x();
      if (success)
        result->offset_y = input.offset_y();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ui::mojom::MouseData::DataView, ::ui::mojom::MouseDataPtr>::Read(
    ::ui::mojom::MouseData::DataView input,
    ::ui::mojom::MouseDataPtr* output) {
  bool success = true;
  ::ui::mojom::MouseDataPtr result(::ui::mojom::MouseData::New());
  
      if (success)
        result->changed_button_flags = input.changed_button_flags();
      if (success && !input.ReadLocation(&result->location))
        success = false;
      if (success && !input.ReadPointerDetails(&result->pointer_details))
        success = false;
      if (success && !input.ReadWheelOffset(&result->wheel_offset))
        success = false;
      if (success && !input.ReadTick120ths(&result->tick_120ths))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ui::mojom::TouchData::DataView, ::ui::mojom::TouchDataPtr>::Read(
    ::ui::mojom::TouchData::DataView input,
    ::ui::mojom::TouchDataPtr* output) {
  bool success = true;
  ::ui::mojom::TouchDataPtr result(::ui::mojom::TouchData::New());
  
      if (success)
        result->may_cause_scrolling = input.may_cause_scrolling();
      if (success)
        result->hovering = input.hovering();
      if (success && !input.ReadLocation(&result->location))
        success = false;
      if (success && !input.ReadPointerDetails(&result->pointer_details))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ui::mojom::Event::DataView, ::ui::mojom::EventPtr>::Read(
    ::ui::mojom::Event::DataView input,
    ::ui::mojom::EventPtr* output) {
  bool success = true;
  ::ui::mojom::EventPtr result(::ui::mojom::Event::New());
  
      if (success && !input.ReadAction(&result->action))
        success = false;
      if (success)
        result->flags = input.flags();
      if (success && !input.ReadTimeStamp(&result->time_stamp))
        success = false;
      if (success && !input.ReadLatency(&result->latency))
        success = false;
      if (success && !input.ReadKeyData(&result->key_data))
        success = false;
      if (success && !input.ReadGestureData(&result->gesture_data))
        success = false;
      if (success && !input.ReadScrollData(&result->scroll_data))
        success = false;
      if (success && !input.ReadTouchData(&result->touch_data))
        success = false;
      if (success && !input.ReadMouseData(&result->mouse_data))
        success = false;
      if (success && !input.ReadProperties(&result->properties))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif