// ui/accessibility/mojom/ax_relative_bounds.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_RELATIVE_BOUNDS_MOJOM_BLINK_H_
#define UI_ACCESSIBILITY_MOJOM_AX_RELATIVE_BOUNDS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "ui/accessibility/mojom/ax_relative_bounds.mojom-shared.h"
#include "ui/accessibility/mojom/ax_relative_bounds.mojom-blink-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"
#include "ui/gfx/mojom/transform.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"







// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace ax {
namespace mojom {
namespace blink {








class  AXRelativeBounds {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AXRelativeBounds, T>::value>;
  using DataView = AXRelativeBoundsDataView;
  using Data_ = internal::AXRelativeBounds_Data;

  template <typename... Args>
  static AXRelativeBoundsPtr New(Args&&... args) {
    return AXRelativeBoundsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AXRelativeBoundsPtr From(const U& u) {
    return mojo::TypeConverter<AXRelativeBoundsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AXRelativeBounds>::Convert(*this);
  }


  AXRelativeBounds();

  AXRelativeBounds(
      int32_t offset_container_id,
      const ::gfx::RectF& bounds,
      const ::gfx::Transform& transform);

  ~AXRelativeBounds();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AXRelativeBoundsPtr>
  AXRelativeBoundsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AXRelativeBounds::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AXRelativeBounds::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AXRelativeBounds::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AXRelativeBounds_UnserializedMessageContext<
            UserType, AXRelativeBounds::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<AXRelativeBounds::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return AXRelativeBounds::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AXRelativeBounds_UnserializedMessageContext<
            UserType, AXRelativeBounds::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AXRelativeBounds::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t offset_container_id;
  
  ::gfx::RectF bounds;
  
  ::gfx::Transform transform;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AXRelativeBounds::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AXRelativeBounds::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AXRelativeBounds::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AXRelativeBounds::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AXRelativeBoundsPtr AXRelativeBounds::Clone() const {
  return New(
      mojo::Clone(offset_container_id),
      mojo::Clone(bounds),
      mojo::Clone(transform)
  );
}

template <typename T, AXRelativeBounds::EnableIfSame<T>*>
bool AXRelativeBounds::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->offset_container_id, other_struct.offset_container_id))
    return false;
  if (!mojo::Equals(this->bounds, other_struct.bounds))
    return false;
  if (!mojo::Equals(this->transform, other_struct.transform))
    return false;
  return true;
}

template <typename T, AXRelativeBounds::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.offset_container_id, rhs.offset_container_id))
    return true;
  if (std::less<>{}(rhs.offset_container_id, lhs.offset_container_id))
    return false;
  if (std::less<>{}(lhs.bounds, rhs.bounds))
    return true;
  if (std::less<>{}(rhs.bounds, lhs.bounds))
    return false;
  if (std::less<>{}(lhs.transform, rhs.transform))
    return true;
  if (std::less<>{}(rhs.transform, lhs.transform))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace ax

namespace mojo {


template <>
struct  StructTraits<::ax::mojom::blink::AXRelativeBounds::DataView,
                                         ::ax::mojom::blink::AXRelativeBoundsPtr> {
  static bool IsNull(const ::ax::mojom::blink::AXRelativeBoundsPtr& input) { return !input; }
  static void SetToNull(::ax::mojom::blink::AXRelativeBoundsPtr* output) { output->reset(); }

  static decltype(::ax::mojom::blink::AXRelativeBounds::offset_container_id) offset_container_id(
      const ::ax::mojom::blink::AXRelativeBoundsPtr& input) {
    return input->offset_container_id;
  }

  static const decltype(::ax::mojom::blink::AXRelativeBounds::bounds)& bounds(
      const ::ax::mojom::blink::AXRelativeBoundsPtr& input) {
    return input->bounds;
  }

  static const decltype(::ax::mojom::blink::AXRelativeBounds::transform)& transform(
      const ::ax::mojom::blink::AXRelativeBoundsPtr& input) {
    return input->transform;
  }

  static bool Read(::ax::mojom::blink::AXRelativeBounds::DataView input, ::ax::mojom::blink::AXRelativeBoundsPtr* output);
};

}  // namespace mojo

#endif  // UI_ACCESSIBILITY_MOJOM_AX_RELATIVE_BOUNDS_MOJOM_BLINK_H_