// ui/accessibility/mojom/ax_node_data.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/accessibility/mojom/ax_node_data.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "ui/accessibility/mojom/ax_node_data.mojom-params-data.h"
#include "ui/accessibility/mojom/ax_node_data.mojom-shared-message-ids.h"

#include "ui/accessibility/mojom/ax_node_data.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef UI_ACCESSIBILITY_MOJOM_AX_NODE_DATA_MOJOM_BLINK_JUMBO_H_
#define UI_ACCESSIBILITY_MOJOM_AX_NODE_DATA_MOJOM_BLINK_JUMBO_H_
#endif
namespace ax {
namespace mojom {
namespace blink {
AXNodeData::AXNodeData()
    : id(),
      role(),
      state(),
      actions(),
      string_attributes(),
      int_attributes(),
      float_attributes(),
      bool_attributes(),
      intlist_attributes(),
      stringlist_attributes(),
      html_attributes(),
      child_ids(),
      relative_bounds() {}

AXNodeData::AXNodeData(
    int32_t id_in,
    ::ax::mojom::blink::Role role_in,
    uint32_t state_in,
    uint64_t actions_in,
    const WTF::HashMap<::ax::mojom::blink::StringAttribute, WTF::String>& string_attributes_in,
    const WTF::HashMap<::ax::mojom::blink::IntAttribute, int32_t>& int_attributes_in,
    const WTF::HashMap<::ax::mojom::blink::FloatAttribute, float>& float_attributes_in,
    const WTF::HashMap<::ax::mojom::blink::BoolAttribute, bool>& bool_attributes_in,
    const WTF::HashMap<::ax::mojom::blink::IntListAttribute, WTF::Vector<int32_t>>& intlist_attributes_in,
    const WTF::HashMap<::ax::mojom::blink::StringListAttribute, WTF::Vector<WTF::String>>& stringlist_attributes_in,
    const WTF::HashMap<WTF::String, WTF::String>& html_attributes_in,
    WTF::Vector<int32_t> child_ids_in,
    ::ax::mojom::blink::AXRelativeBoundsPtr relative_bounds_in)
    : id(std::move(id_in)),
      role(std::move(role_in)),
      state(std::move(state_in)),
      actions(std::move(actions_in)),
      string_attributes(std::move(string_attributes_in)),
      int_attributes(std::move(int_attributes_in)),
      float_attributes(std::move(float_attributes_in)),
      bool_attributes(std::move(bool_attributes_in)),
      intlist_attributes(std::move(intlist_attributes_in)),
      stringlist_attributes(std::move(stringlist_attributes_in)),
      html_attributes(std::move(html_attributes_in)),
      child_ids(std::move(child_ids_in)),
      relative_bounds(std::move(relative_bounds_in)) {}

AXNodeData::~AXNodeData() = default;

void AXNodeData::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("id", this->id);
  value->SetString("role", base::trace_event::ValueToString(this->role));
  value->SetString("state", base::NumberToString(this->state));
  value->SetString("actions", base::NumberToString(this->actions));
  value->BeginDictionary("string_attributes");
  for (const auto& item0 : this->string_attributes) {
    value->SetStringWithCopiedName(base::trace_event::ValueToString(item0.key, "<value of type ::ax::mojom::blink::StringAttribute>"), item0.value.Utf8());
  }
  value->EndDictionary();
  value->BeginDictionary("int_attributes");
  for (const auto& item0 : this->int_attributes) {
    value->SetIntegerWithCopiedName(base::trace_event::ValueToString(item0.key, "<value of type ::ax::mojom::blink::IntAttribute>"), item0.value);
  }
  value->EndDictionary();
  value->BeginDictionary("float_attributes");
  for (const auto& item0 : this->float_attributes) {
    value->SetDoubleWithCopiedName(base::trace_event::ValueToString(item0.key, "<value of type ::ax::mojom::blink::FloatAttribute>"), item0.value);
  }
  value->EndDictionary();
  value->BeginDictionary("bool_attributes");
  for (const auto& item0 : this->bool_attributes) {
    value->SetBooleanWithCopiedName(base::trace_event::ValueToString(item0.key, "<value of type ::ax::mojom::blink::BoolAttribute>"), item0.value);
  }
  value->EndDictionary();
  value->BeginDictionary("intlist_attributes");
  for (const auto& item0 : this->intlist_attributes) {
    value->BeginArrayWithCopiedName(base::trace_event::ValueToString(item0.key, "<value of type ::ax::mojom::blink::IntListAttribute>"));
    for (const auto& item1 : item0.value) {
      value->AppendInteger(item1);
    }
    value->EndArray();
  }
  value->EndDictionary();
  value->BeginDictionary("stringlist_attributes");
  for (const auto& item0 : this->stringlist_attributes) {
    value->BeginArrayWithCopiedName(base::trace_event::ValueToString(item0.key, "<value of type ::ax::mojom::blink::StringListAttribute>"));
    for (const auto& item1 : item0.value) {
      value->AppendString(item1.Utf8());
    }
    value->EndArray();
  }
  value->EndDictionary();
  value->BeginDictionary("html_attributes");
  for (const auto& item0 : this->html_attributes) {
    value->SetStringWithCopiedName(base::trace_event::ValueToString(item0.key, "<value of type const WTF::String&>"), item0.value.Utf8());
  }
  value->EndDictionary();
  value->BeginArray("child_ids");
  for (const auto& item0 : this->child_ids) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  if (this->relative_bounds.is_null()) {
    value->SetString("relative_bounds", "nullptr");
  } else {
    value->BeginDictionary("relative_bounds");
    this->relative_bounds->AsValueInto(value);
    value->EndDictionary();
  }
}

bool AXNodeData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace blink
}  // namespace mojom
}  // namespace ax

namespace mojo {


// static
bool StructTraits<::ax::mojom::blink::AXNodeData::DataView, ::ax::mojom::blink::AXNodeDataPtr>::Read(
    ::ax::mojom::blink::AXNodeData::DataView input,
    ::ax::mojom::blink::AXNodeDataPtr* output) {
  bool success = true;
  ::ax::mojom::blink::AXNodeDataPtr result(::ax::mojom::blink::AXNodeData::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadRole(&result->role))
        success = false;
      if (success)
        result->state = input.state();
      if (success)
        result->actions = input.actions();
      if (success && !input.ReadStringAttributes(&result->string_attributes))
        success = false;
      if (success && !input.ReadIntAttributes(&result->int_attributes))
        success = false;
      if (success && !input.ReadFloatAttributes(&result->float_attributes))
        success = false;
      if (success && !input.ReadBoolAttributes(&result->bool_attributes))
        success = false;
      if (success && !input.ReadIntlistAttributes(&result->intlist_attributes))
        success = false;
      if (success && !input.ReadStringlistAttributes(&result->stringlist_attributes))
        success = false;
      if (success && !input.ReadHtmlAttributes(&result->html_attributes))
        success = false;
      if (success && !input.ReadChildIds(&result->child_ids))
        success = false;
      if (success && !input.ReadRelativeBounds(&result->relative_bounds))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif