// third_party/blink/public/mojom/worker/shared_worker_info.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_INFO_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_INFO_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/worker/shared_worker_info.mojom-shared.h"
#include "third_party/blink/public/mojom/worker/shared_worker_info.mojom-blink-forward.h"
#include "services/network/public/mojom/content_security_policy.mojom-blink.h"
#include "services/network/public/mojom/ip_address_space.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-blink.h"
#include "third_party/blink/public/mojom/worker/worker_options.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {








class PLATFORM_EXPORT SharedWorkerInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SharedWorkerInfo, T>::value>;
  using DataView = SharedWorkerInfoDataView;
  using Data_ = internal::SharedWorkerInfo_Data;

  template <typename... Args>
  static SharedWorkerInfoPtr New(Args&&... args) {
    return SharedWorkerInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SharedWorkerInfoPtr From(const U& u) {
    return mojo::TypeConverter<SharedWorkerInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SharedWorkerInfo>::Convert(*this);
  }


  SharedWorkerInfo();

  SharedWorkerInfo(
      const ::blink::KURL& url,
      ::blink::mojom::blink::WorkerOptionsPtr options,
      const WTF::String& content_security_policy,
      ::network::mojom::blink::ContentSecurityPolicyType content_security_policy_type,
      ::network::mojom::blink::IPAddressSpace creation_address_space,
      ::blink::mojom::blink::FetchClientSettingsObjectPtr outside_fetch_client_settings_object);

  ~SharedWorkerInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SharedWorkerInfoPtr>
  SharedWorkerInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SharedWorkerInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SharedWorkerInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SharedWorkerInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SharedWorkerInfo_UnserializedMessageContext<
            UserType, SharedWorkerInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SharedWorkerInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return SharedWorkerInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SharedWorkerInfo_UnserializedMessageContext<
            UserType, SharedWorkerInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SharedWorkerInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::blink::KURL url;
  
  ::blink::mojom::blink::WorkerOptionsPtr options;
  
  WTF::String content_security_policy;
  
  ::network::mojom::blink::ContentSecurityPolicyType content_security_policy_type;
  
  ::network::mojom::blink::IPAddressSpace creation_address_space;
  
  ::blink::mojom::blink::FetchClientSettingsObjectPtr outside_fetch_client_settings_object;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(SharedWorkerInfo);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SharedWorkerInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SharedWorkerInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SharedWorkerInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SharedWorkerInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SharedWorkerInfoPtr SharedWorkerInfo::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(options),
      mojo::Clone(content_security_policy),
      mojo::Clone(content_security_policy_type),
      mojo::Clone(creation_address_space),
      mojo::Clone(outside_fetch_client_settings_object)
  );
}

template <typename T, SharedWorkerInfo::EnableIfSame<T>*>
bool SharedWorkerInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->options, other_struct.options))
    return false;
  if (!mojo::Equals(this->content_security_policy, other_struct.content_security_policy))
    return false;
  if (!mojo::Equals(this->content_security_policy_type, other_struct.content_security_policy_type))
    return false;
  if (!mojo::Equals(this->creation_address_space, other_struct.creation_address_space))
    return false;
  if (!mojo::Equals(this->outside_fetch_client_settings_object, other_struct.outside_fetch_client_settings_object))
    return false;
  return true;
}

template <typename T, SharedWorkerInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.url, rhs.url))
    return true;
  if (std::less<>{}(rhs.url, lhs.url))
    return false;
  if (std::less<>{}(lhs.options, rhs.options))
    return true;
  if (std::less<>{}(rhs.options, lhs.options))
    return false;
  if (std::less<>{}(lhs.content_security_policy, rhs.content_security_policy))
    return true;
  if (std::less<>{}(rhs.content_security_policy, lhs.content_security_policy))
    return false;
  if (std::less<>{}(lhs.content_security_policy_type, rhs.content_security_policy_type))
    return true;
  if (std::less<>{}(rhs.content_security_policy_type, lhs.content_security_policy_type))
    return false;
  if (std::less<>{}(lhs.creation_address_space, rhs.creation_address_space))
    return true;
  if (std::less<>{}(rhs.creation_address_space, lhs.creation_address_space))
    return false;
  if (std::less<>{}(lhs.outside_fetch_client_settings_object, rhs.outside_fetch_client_settings_object))
    return true;
  if (std::less<>{}(rhs.outside_fetch_client_settings_object, lhs.outside_fetch_client_settings_object))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SharedWorkerInfo::DataView,
                                         ::blink::mojom::blink::SharedWorkerInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::SharedWorkerInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SharedWorkerInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::SharedWorkerInfo::url)& url(
      const ::blink::mojom::blink::SharedWorkerInfoPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::blink::SharedWorkerInfo::options)& options(
      const ::blink::mojom::blink::SharedWorkerInfoPtr& input) {
    return input->options;
  }

  static const decltype(::blink::mojom::blink::SharedWorkerInfo::content_security_policy)& content_security_policy(
      const ::blink::mojom::blink::SharedWorkerInfoPtr& input) {
    return input->content_security_policy;
  }

  static decltype(::blink::mojom::blink::SharedWorkerInfo::content_security_policy_type) content_security_policy_type(
      const ::blink::mojom::blink::SharedWorkerInfoPtr& input) {
    return input->content_security_policy_type;
  }

  static decltype(::blink::mojom::blink::SharedWorkerInfo::creation_address_space) creation_address_space(
      const ::blink::mojom::blink::SharedWorkerInfoPtr& input) {
    return input->creation_address_space;
  }

  static const decltype(::blink::mojom::blink::SharedWorkerInfo::outside_fetch_client_settings_object)& outside_fetch_client_settings_object(
      const ::blink::mojom::blink::SharedWorkerInfoPtr& input) {
    return input->outside_fetch_client_settings_object;
  }

  static bool Read(::blink::mojom::blink::SharedWorkerInfo::DataView input, ::blink::mojom::blink::SharedWorkerInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_SHARED_WORKER_INFO_MOJOM_BLINK_H_