// third_party/blink/public/mojom/widget/screen_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_SCREEN_INFO_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_SCREEN_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/widget/screen_info.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/widget/screen_orientation.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-shared.h"



#include "base/component_export.h"




namespace blink {
namespace mojom {
class ScreenInfoDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ScreenInfoDataView> {
  using Data = ::blink::mojom::internal::ScreenInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


class ScreenInfoDataView {
 public:
  ScreenInfoDataView() {}

  ScreenInfoDataView(
      internal::ScreenInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  float device_scale_factor() const {
    return data_->device_scale_factor;
  }
  inline void GetDisplayColorSpacesDataView(
      ::gfx::mojom::DisplayColorSpacesDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDisplayColorSpaces(UserType* output) {
    
    auto* pointer = data_->display_color_spaces.Get();
    return mojo::internal::Deserialize<::gfx::mojom::DisplayColorSpacesDataView>(
        pointer, output, context_);
  }
  uint32_t depth() const {
    return data_->depth;
  }
  uint32_t depth_per_component() const {
    return data_->depth_per_component;
  }
  bool is_monochrome() const {
    return data_->is_monochrome;
  }
  uint32_t display_frequency() const {
    return data_->display_frequency;
  }
  inline void GetRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRect(UserType* output) {
    
    auto* pointer = data_->rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, context_);
  }
  inline void GetAvailableRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAvailableRect(UserType* output) {
    
    auto* pointer = data_->available_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOrientationType(UserType* output) const {
    auto data_value = data_->orientation_type;
    return mojo::internal::Deserialize<::blink::mojom::ScreenOrientation>(
        data_value, output);
  }

  ::blink::mojom::ScreenOrientation orientation_type() const {
    return static_cast<::blink::mojom::ScreenOrientation>(data_->orientation_type);
  }
  uint16_t orientation_angle() const {
    return data_->orientation_angle;
  }
 private:
  internal::ScreenInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ScreenInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ScreenInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::ScreenInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->device_scale_factor = Traits::device_scale_factor(input);
    decltype(Traits::display_color_spaces(input)) in_display_color_spaces = Traits::display_color_spaces(input);
    typename decltype((*output)->display_color_spaces)::BaseType::BufferWriter
        display_color_spaces_writer;
    mojo::internal::Serialize<::gfx::mojom::DisplayColorSpacesDataView>(
        in_display_color_spaces, buffer, &display_color_spaces_writer, context);
    (*output)->display_color_spaces.Set(
        display_color_spaces_writer.is_null() ? nullptr : display_color_spaces_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->display_color_spaces.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_color_spaces in ScreenInfo struct");
    (*output)->depth = Traits::depth(input);
    (*output)->depth_per_component = Traits::depth_per_component(input);
    (*output)->is_monochrome = Traits::is_monochrome(input);
    (*output)->display_frequency = Traits::display_frequency(input);
    decltype(Traits::rect(input)) in_rect = Traits::rect(input);
    typename decltype((*output)->rect)::BaseType::BufferWriter
        rect_writer;
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_rect, buffer, &rect_writer, context);
    (*output)->rect.Set(
        rect_writer.is_null() ? nullptr : rect_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rect in ScreenInfo struct");
    decltype(Traits::available_rect(input)) in_available_rect = Traits::available_rect(input);
    typename decltype((*output)->available_rect)::BaseType::BufferWriter
        available_rect_writer;
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_available_rect, buffer, &available_rect_writer, context);
    (*output)->available_rect.Set(
        available_rect_writer.is_null() ? nullptr : available_rect_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->available_rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null available_rect in ScreenInfo struct");
    mojo::internal::Serialize<::blink::mojom::ScreenOrientation>(
        Traits::orientation_type(input), &(*output)->orientation_type);
    (*output)->orientation_angle = Traits::orientation_angle(input);
  }

  static bool Deserialize(::blink::mojom::internal::ScreenInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ScreenInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void ScreenInfoDataView::GetDisplayColorSpacesDataView(
    ::gfx::mojom::DisplayColorSpacesDataView* output) {
  auto pointer = data_->display_color_spaces.Get();
  *output = ::gfx::mojom::DisplayColorSpacesDataView(pointer, context_);
}
inline void ScreenInfoDataView::GetRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, context_);
}
inline void ScreenInfoDataView::GetAvailableRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->available_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WIDGET_SCREEN_INFO_MOJOM_SHARED_H_