// third_party/blink/public/mojom/webtransport/quic_transport_connector.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/webtransport/quic_transport_connector.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/webtransport/quic_transport_connector.mojom-params-data.h"
#include "third_party/blink/public/mojom/webtransport/quic_transport_connector.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/webtransport/quic_transport_connector.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBTRANSPORT_QUIC_TRANSPORT_CONNECTOR_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBTRANSPORT_QUIC_TRANSPORT_CONNECTOR_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char QuicTransportConnector::Name_[] = "blink.mojom.QuicTransportConnector";

QuicTransportConnectorProxy::QuicTransportConnectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void QuicTransportConnectorProxy::Connect(
    const ::GURL& in_url, std::vector<::network::mojom::QuicTransportCertificateFingerprintPtr> in_fingerprints, ::mojo::PendingRemote<::network::mojom::QuicTransportHandshakeClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::QuicTransportConnector::Connect", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->BeginArray("fingerprints");
      for (const auto& item0 : in_fingerprints) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      raw_value->SetBoolean("client", in_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kQuicTransportConnector_Connect_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::QuicTransportConnector_Connect_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in QuicTransportConnector.Connect request");
  typename decltype(params->fingerprints)::BaseType::BufferWriter
      fingerprints_writer;
  const mojo::internal::ContainerValidateParams fingerprints_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::QuicTransportCertificateFingerprintDataView>>(
      in_fingerprints, buffer, &fingerprints_writer, &fingerprints_validate_params,
      &serialization_context);
  params->fingerprints.Set(
      fingerprints_writer.is_null() ? nullptr : fingerprints_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->fingerprints.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null fingerprints in QuicTransportConnector.Connect request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::QuicTransportHandshakeClientInterfaceBase>>(
      in_client, &params->client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in QuicTransportConnector.Connect request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuicTransportConnector::Name_);
  message.set_method_name("Connect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool QuicTransportConnectorStubDispatch::Accept(
    QuicTransportConnector* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kQuicTransportConnector_Connect_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::QuicTransportConnector::Connect",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::QuicTransportConnector::Connect");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::QuicTransportConnector_Connect_Params_Data* params =
          reinterpret_cast<internal::QuicTransportConnector_Connect_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      std::vector<::network::mojom::QuicTransportCertificateFingerprintPtr> p_fingerprints{};
      ::mojo::PendingRemote<::network::mojom::QuicTransportHandshakeClient> p_client{};
      QuicTransportConnector_Connect_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadFingerprints(&p_fingerprints))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuicTransportConnector::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Connect(
std::move(p_url), 
std::move(p_fingerprints), 
std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool QuicTransportConnectorStubDispatch::AcceptWithResponder(
    QuicTransportConnector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kQuicTransportConnector_Connect_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kQuicTransportConnectorValidationInfo[] = {
    {&internal::QuicTransportConnector_Connect_Params_Data::Validate,
     nullptr /* no response */},
};

bool QuicTransportConnectorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::QuicTransportConnector::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kQuicTransportConnectorValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif