// third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-params-data.h"
namespace blink {
namespace mojom {

std::ostream& operator<<(std::ostream& os, PointerType value) {
  switch(value) {
    case PointerType::kPointerFirstType:
      return os << "PointerType::kPointerFirstType";
    case PointerType::kPointerCoarseType:
      return os << "PointerType::kPointerCoarseType";
    case PointerType::kPointerFineType:
      return os << "PointerType::kPointerFineType";
    default:
      return os << "Unknown PointerType value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, HoverType value) {
  switch(value) {
    case HoverType::kHoverFirstType:
      return os << "HoverType::kHoverFirstType";
    case HoverType::kHoverHoverType:
      return os << "HoverType::kHoverHoverType";
    default:
      return os << "Unknown HoverType value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, PreferredColorScheme value) {
  switch(value) {
    case PreferredColorScheme::kDark:
      return os << "PreferredColorScheme::kDark";
    case PreferredColorScheme::kLight:
      return os << "PreferredColorScheme::kLight";
    default:
      return os << "Unknown PreferredColorScheme value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, EditingBehavior value) {
  switch(value) {
    case EditingBehavior::kEditingMacBehavior:
      return os << "EditingBehavior::kEditingMacBehavior";
    case EditingBehavior::kEditingWindowsBehavior:
      return os << "EditingBehavior::kEditingWindowsBehavior";
    case EditingBehavior::kEditingUnixBehavior:
      return os << "EditingBehavior::kEditingUnixBehavior";
    case EditingBehavior::kEditingAndroidBehavior:
      return os << "EditingBehavior::kEditingAndroidBehavior";
    case EditingBehavior::kEditingChromeOSBehavior:
      return os << "EditingBehavior::kEditingChromeOSBehavior";
    default:
      return os << "Unknown EditingBehavior value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, ImageAnimationPolicy value) {
  switch(value) {
    case ImageAnimationPolicy::kImageAnimationPolicyAllowed:
      return os << "ImageAnimationPolicy::kImageAnimationPolicyAllowed";
    case ImageAnimationPolicy::kImageAnimationPolicyAnimateOnce:
      return os << "ImageAnimationPolicy::kImageAnimationPolicyAnimateOnce";
    case ImageAnimationPolicy::kImageAnimationPolicyNoAnimation:
      return os << "ImageAnimationPolicy::kImageAnimationPolicyNoAnimation";
    default:
      return os << "Unknown ImageAnimationPolicy value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, ViewportStyle value) {
  switch(value) {
    case ViewportStyle::kDefault:
      return os << "ViewportStyle::kDefault";
    case ViewportStyle::kMobile:
      return os << "ViewportStyle::kMobile";
    case ViewportStyle::kTelevision:
      return os << "ViewportStyle::{kTelevision, kLast}";
    default:
      return os << "Unknown ViewportStyle value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, AutoplayPolicy value) {
  switch(value) {
    case AutoplayPolicy::kNoUserGestureRequired:
      return os << "AutoplayPolicy::kNoUserGestureRequired";
    case AutoplayPolicy::kUserGestureRequired:
      return os << "AutoplayPolicy::kUserGestureRequired";
    case AutoplayPolicy::kDocumentUserActivationRequired:
      return os << "AutoplayPolicy::kDocumentUserActivationRequired";
    default:
      return os << "Unknown AutoplayPolicy value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, EffectiveConnectionType value) {
  switch(value) {
    case EffectiveConnectionType::kEffectiveConnectionUnknownType:
      return os << "EffectiveConnectionType::kEffectiveConnectionUnknownType";
    case EffectiveConnectionType::kEffectiveConnectionOfflineType:
      return os << "EffectiveConnectionType::kEffectiveConnectionOfflineType";
    case EffectiveConnectionType::kEffectiveConnectionSlow2GType:
      return os << "EffectiveConnectionType::kEffectiveConnectionSlow2GType";
    case EffectiveConnectionType::kEffectiveConnection2GType:
      return os << "EffectiveConnectionType::kEffectiveConnection2GType";
    case EffectiveConnectionType::kEffectiveConnection3GType:
      return os << "EffectiveConnectionType::kEffectiveConnection3GType";
    case EffectiveConnectionType::kEffectiveConnection4GType:
      return os << "EffectiveConnectionType::kEffectiveConnection4GType";
    default:
      return os << "Unknown EffectiveConnectionType value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool WebPreferences_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const WebPreferences_Data* object = static_cast<const WebPreferences_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 280 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->standard_font_family_map, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams standard_font_family_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->standard_font_family_map, validation_context,
                                         &standard_font_family_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fixed_font_family_map, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams fixed_font_family_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->fixed_font_family_map, validation_context,
                                         &fixed_font_family_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->serif_font_family_map, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams serif_font_family_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->serif_font_family_map, validation_context,
                                         &serif_font_family_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sans_serif_font_family_map, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams sans_serif_font_family_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->sans_serif_font_family_map, validation_context,
                                         &sans_serif_font_family_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cursive_font_family_map, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams cursive_font_family_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->cursive_font_family_map, validation_context,
                                         &cursive_font_family_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fantasy_font_family_map, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams fantasy_font_family_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->fantasy_font_family_map, validation_context,
                                         &fantasy_font_family_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pictograph_font_family_map, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams pictograph_font_family_map_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->pictograph_font_family_map, validation_context,
                                         &pictograph_font_family_map_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_encoding, 12, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams default_encoding_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->default_encoding, validation_context,
                                         &default_encoding_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::PointerType_Data
        ::Validate(object->primary_pointer_type, validation_context))
    return false;


  if (!::blink::mojom::internal::HoverType_Data
        ::Validate(object->primary_hover_type, validation_context))
    return false;


  if (!::blink::mojom::internal::EditingBehavior_Data
        ::Validate(object->editing_behavior, validation_context))
    return false;


  if (!::blink::mojom::internal::ViewportStyle_Data
        ::Validate(object->viewport_style, validation_context))
    return false;


  if (!::blink::mojom::internal::V8CacheOptions_Data
        ::Validate(object->v8_cache_options, validation_context))
    return false;


  if (!::blink::mojom::internal::ImageAnimationPolicy_Data
        ::Validate(object->animation_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_background_color, 94, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_background_color_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_background_color, validation_context,
                                         &text_track_background_color_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_text_color, 95, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_text_color_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_text_color, validation_context,
                                         &text_track_text_color_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_text_size, 96, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_text_size_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_text_size, validation_context,
                                         &text_track_text_size_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_text_shadow, 97, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_text_shadow_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_text_shadow, validation_context,
                                         &text_track_text_shadow_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_font_family, 98, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_font_family_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_font_family, validation_context,
                                         &text_track_font_family_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_font_style, 99, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_font_style_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_font_style, validation_context,
                                         &text_track_font_style_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_font_variant, 100, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_font_variant_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_font_variant, validation_context,
                                         &text_track_font_variant_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_window_color, 101, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_window_color_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_window_color, validation_context,
                                         &text_track_window_color_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_window_padding, 102, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_window_padding_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_window_padding, validation_context,
                                         &text_track_window_padding_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_track_window_radius, 103, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams text_track_window_radius_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->text_track_window_radius, validation_context,
                                         &text_track_window_radius_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->web_app_scope, 109, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->web_app_scope, validation_context))
    return false;


  if (!::blink::mojom::internal::AutoplayPolicy_Data
        ::Validate(object->autoplay_policy, validation_context))
    return false;


  if (!::blink::mojom::internal::PreferredColorScheme_Data
        ::Validate(object->preferred_color_scheme, validation_context))
    return false;


  if (!::blink::mojom::internal::EffectiveConnectionType_Data
        ::Validate(object->low_priority_iframes_threshold, validation_context))
    return false;


  if (!::blink::mojom::internal::EffectiveConnectionType_Data
        ::Validate(object->network_quality_estimator_web_holdback, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lazy_frame_loading_distance_thresholds_px, 124, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams lazy_frame_loading_distance_thresholds_px_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::blink::mojom::internal::EffectiveConnectionType_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->lazy_frame_loading_distance_thresholds_px, validation_context,
                                         &lazy_frame_loading_distance_thresholds_px_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lazy_image_loading_distance_thresholds_px, 125, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams lazy_image_loading_distance_thresholds_px_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::blink::mojom::internal::EffectiveConnectionType_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->lazy_image_loading_distance_thresholds_px, validation_context,
                                         &lazy_image_loading_distance_thresholds_px_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lazy_image_first_k_fully_load, 126, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams lazy_image_first_k_fully_load_validate_params(
      new mojo::internal::ContainerValidateParams(0, ::blink::mojom::internal::EffectiveConnectionType_Data::Validate), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->lazy_image_first_k_fully_load, validation_context,
                                         &lazy_image_first_k_fully_load_validate_params)) {
    return false;
  }

  return true;
}

WebPreferences_Data::WebPreferences_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink