// third_party/blink/public/mojom/speech/speech_synthesis.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPEECH_SPEECH_SYNTHESIS_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPEECH_SPEECH_SYNTHESIS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/speech/speech_synthesis.mojom-shared.h"
#include "third_party/blink/public/mojom/speech/speech_synthesis.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/platform_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {

class SpeechSynthesisVoiceListObserverProxy;

template <typename ImplRefTraits>
class SpeechSynthesisVoiceListObserverStub;

class SpeechSynthesisVoiceListObserverRequestValidator;


class PLATFORM_EXPORT SpeechSynthesisVoiceListObserver
    : public SpeechSynthesisVoiceListObserverInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = SpeechSynthesisVoiceListObserverInterfaceBase;
  using Proxy_ = SpeechSynthesisVoiceListObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechSynthesisVoiceListObserverStub<ImplRefTraits>;

  using RequestValidator_ = SpeechSynthesisVoiceListObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnSetVoiceListMinVersion = 0,
  };
  virtual ~SpeechSynthesisVoiceListObserver() {}

  
  virtual void OnSetVoiceList(WTF::Vector<SpeechSynthesisVoicePtr> voice_list) = 0;
};

class SpeechSynthesisClientProxy;

template <typename ImplRefTraits>
class SpeechSynthesisClientStub;

class SpeechSynthesisClientRequestValidator;


class PLATFORM_EXPORT SpeechSynthesisClient
    : public SpeechSynthesisClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = SpeechSynthesisClientInterfaceBase;
  using Proxy_ = SpeechSynthesisClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechSynthesisClientStub<ImplRefTraits>;

  using RequestValidator_ = SpeechSynthesisClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnStartedSpeakingMinVersion = 0,
    kOnFinishedSpeakingMinVersion = 0,
    kOnPausedSpeakingMinVersion = 0,
    kOnResumedSpeakingMinVersion = 0,
    kOnEncounteredWordBoundaryMinVersion = 0,
    kOnEncounteredSentenceBoundaryMinVersion = 0,
    kOnEncounteredSpeakingErrorMinVersion = 0,
  };
  virtual ~SpeechSynthesisClient() {}

  
  virtual void OnStartedSpeaking() = 0;

  
  virtual void OnFinishedSpeaking() = 0;

  
  virtual void OnPausedSpeaking() = 0;

  
  virtual void OnResumedSpeaking() = 0;

  
  virtual void OnEncounteredWordBoundary(uint32_t char_index, uint32_t char_length) = 0;

  
  virtual void OnEncounteredSentenceBoundary(uint32_t char_index, uint32_t char_length) = 0;

  
  virtual void OnEncounteredSpeakingError() = 0;
};

class SpeechSynthesisProxy;

template <typename ImplRefTraits>
class SpeechSynthesisStub;

class SpeechSynthesisRequestValidator;


class PLATFORM_EXPORT SpeechSynthesis
    : public SpeechSynthesisInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = SpeechSynthesisInterfaceBase;
  using Proxy_ = SpeechSynthesisProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeechSynthesisStub<ImplRefTraits>;

  using RequestValidator_ = SpeechSynthesisRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAddVoiceListObserverMinVersion = 0,
    kSpeakMinVersion = 0,
    kPauseMinVersion = 0,
    kResumeMinVersion = 0,
    kCancelMinVersion = 0,
  };
  virtual ~SpeechSynthesis() {}

  
  virtual void AddVoiceListObserver(::mojo::PendingRemote<SpeechSynthesisVoiceListObserver> observer) = 0;

  
  virtual void Speak(SpeechSynthesisUtterancePtr utterance, ::mojo::PendingRemote<SpeechSynthesisClient> client) = 0;

  
  virtual void Pause() = 0;

  
  virtual void Resume() = 0;

  
  virtual void Cancel() = 0;
};



class PLATFORM_EXPORT SpeechSynthesisVoiceListObserverProxy
    : public SpeechSynthesisVoiceListObserver {
 public:
  using InterfaceType = SpeechSynthesisVoiceListObserver;

  explicit SpeechSynthesisVoiceListObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnSetVoiceList(WTF::Vector<SpeechSynthesisVoicePtr> voice_list) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT SpeechSynthesisClientProxy
    : public SpeechSynthesisClient {
 public:
  using InterfaceType = SpeechSynthesisClient;

  explicit SpeechSynthesisClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnStartedSpeaking() final;
  
  void OnFinishedSpeaking() final;
  
  void OnPausedSpeaking() final;
  
  void OnResumedSpeaking() final;
  
  void OnEncounteredWordBoundary(uint32_t char_index, uint32_t char_length) final;
  
  void OnEncounteredSentenceBoundary(uint32_t char_index, uint32_t char_length) final;
  
  void OnEncounteredSpeakingError() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class PLATFORM_EXPORT SpeechSynthesisProxy
    : public SpeechSynthesis {
 public:
  using InterfaceType = SpeechSynthesis;

  explicit SpeechSynthesisProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddVoiceListObserver(::mojo::PendingRemote<SpeechSynthesisVoiceListObserver> observer) final;
  
  void Speak(SpeechSynthesisUtterancePtr utterance, ::mojo::PendingRemote<SpeechSynthesisClient> client) final;
  
  void Pause() final;
  
  void Resume() final;
  
  void Cancel() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT SpeechSynthesisVoiceListObserverStubDispatch {
 public:
  static bool Accept(SpeechSynthesisVoiceListObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechSynthesisVoiceListObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechSynthesisVoiceListObserver>>
class SpeechSynthesisVoiceListObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechSynthesisVoiceListObserverStub() {}
  ~SpeechSynthesisVoiceListObserverStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechSynthesisVoiceListObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechSynthesisVoiceListObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT SpeechSynthesisClientStubDispatch {
 public:
  static bool Accept(SpeechSynthesisClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechSynthesisClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechSynthesisClient>>
class SpeechSynthesisClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechSynthesisClientStub() {}
  ~SpeechSynthesisClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechSynthesisClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechSynthesisClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT SpeechSynthesisStubDispatch {
 public:
  static bool Accept(SpeechSynthesis* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeechSynthesis* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeechSynthesis>>
class SpeechSynthesisStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeechSynthesisStub() {}
  ~SpeechSynthesisStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechSynthesisStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeechSynthesisStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT SpeechSynthesisVoiceListObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT SpeechSynthesisClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT SpeechSynthesisRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class PLATFORM_EXPORT SpeechSynthesisUtterance {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpeechSynthesisUtterance, T>::value>;
  using DataView = SpeechSynthesisUtteranceDataView;
  using Data_ = internal::SpeechSynthesisUtterance_Data;

  template <typename... Args>
  static SpeechSynthesisUtterancePtr New(Args&&... args) {
    return SpeechSynthesisUtterancePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpeechSynthesisUtterancePtr From(const U& u) {
    return mojo::TypeConverter<SpeechSynthesisUtterancePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpeechSynthesisUtterance>::Convert(*this);
  }


  SpeechSynthesisUtterance();

  SpeechSynthesisUtterance(
      const WTF::String& text,
      const WTF::String& lang,
      const WTF::String& voice,
      double volume,
      double rate,
      double pitch);

  ~SpeechSynthesisUtterance();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpeechSynthesisUtterancePtr>
  SpeechSynthesisUtterancePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpeechSynthesisUtterance::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeechSynthesisUtterance::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpeechSynthesisUtterance::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpeechSynthesisUtterance_UnserializedMessageContext<
            UserType, SpeechSynthesisUtterance::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SpeechSynthesisUtterance::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return SpeechSynthesisUtterance::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpeechSynthesisUtterance_UnserializedMessageContext<
            UserType, SpeechSynthesisUtterance::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpeechSynthesisUtterance::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String text;
  
  WTF::String lang;
  
  WTF::String voice;
  
  double volume;
  
  double rate;
  
  double pitch;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpeechSynthesisUtterance::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpeechSynthesisUtterance::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpeechSynthesisUtterance::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpeechSynthesisUtterance::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT SpeechSynthesisVoice {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpeechSynthesisVoice, T>::value>;
  using DataView = SpeechSynthesisVoiceDataView;
  using Data_ = internal::SpeechSynthesisVoice_Data;

  template <typename... Args>
  static SpeechSynthesisVoicePtr New(Args&&... args) {
    return SpeechSynthesisVoicePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpeechSynthesisVoicePtr From(const U& u) {
    return mojo::TypeConverter<SpeechSynthesisVoicePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpeechSynthesisVoice>::Convert(*this);
  }


  SpeechSynthesisVoice();

  SpeechSynthesisVoice(
      const WTF::String& voice_uri,
      const WTF::String& name,
      const WTF::String& lang,
      bool is_local_service,
      bool is_default);

  ~SpeechSynthesisVoice();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpeechSynthesisVoicePtr>
  SpeechSynthesisVoicePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpeechSynthesisVoice::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeechSynthesisVoice::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpeechSynthesisVoice::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpeechSynthesisVoice_UnserializedMessageContext<
            UserType, SpeechSynthesisVoice::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SpeechSynthesisVoice::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return SpeechSynthesisVoice::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpeechSynthesisVoice_UnserializedMessageContext<
            UserType, SpeechSynthesisVoice::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpeechSynthesisVoice::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String voice_uri;
  
  WTF::String name;
  
  WTF::String lang;
  
  bool is_local_service;
  
  bool is_default;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpeechSynthesisVoice::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpeechSynthesisVoice::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpeechSynthesisVoice::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpeechSynthesisVoice::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SpeechSynthesisUtterancePtr SpeechSynthesisUtterance::Clone() const {
  return New(
      mojo::Clone(text),
      mojo::Clone(lang),
      mojo::Clone(voice),
      mojo::Clone(volume),
      mojo::Clone(rate),
      mojo::Clone(pitch)
  );
}

template <typename T, SpeechSynthesisUtterance::EnableIfSame<T>*>
bool SpeechSynthesisUtterance::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  if (!mojo::Equals(this->lang, other_struct.lang))
    return false;
  if (!mojo::Equals(this->voice, other_struct.voice))
    return false;
  if (!mojo::Equals(this->volume, other_struct.volume))
    return false;
  if (!mojo::Equals(this->rate, other_struct.rate))
    return false;
  if (!mojo::Equals(this->pitch, other_struct.pitch))
    return false;
  return true;
}

template <typename T, SpeechSynthesisUtterance::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.text, rhs.text))
    return true;
  if (std::less<>{}(rhs.text, lhs.text))
    return false;
  if (std::less<>{}(lhs.lang, rhs.lang))
    return true;
  if (std::less<>{}(rhs.lang, lhs.lang))
    return false;
  if (std::less<>{}(lhs.voice, rhs.voice))
    return true;
  if (std::less<>{}(rhs.voice, lhs.voice))
    return false;
  if (std::less<>{}(lhs.volume, rhs.volume))
    return true;
  if (std::less<>{}(rhs.volume, lhs.volume))
    return false;
  if (std::less<>{}(lhs.rate, rhs.rate))
    return true;
  if (std::less<>{}(rhs.rate, lhs.rate))
    return false;
  if (std::less<>{}(lhs.pitch, rhs.pitch))
    return true;
  if (std::less<>{}(rhs.pitch, lhs.pitch))
    return false;
  return false;
}
template <typename StructPtrType>
SpeechSynthesisVoicePtr SpeechSynthesisVoice::Clone() const {
  return New(
      mojo::Clone(voice_uri),
      mojo::Clone(name),
      mojo::Clone(lang),
      mojo::Clone(is_local_service),
      mojo::Clone(is_default)
  );
}

template <typename T, SpeechSynthesisVoice::EnableIfSame<T>*>
bool SpeechSynthesisVoice::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->voice_uri, other_struct.voice_uri))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->lang, other_struct.lang))
    return false;
  if (!mojo::Equals(this->is_local_service, other_struct.is_local_service))
    return false;
  if (!mojo::Equals(this->is_default, other_struct.is_default))
    return false;
  return true;
}

template <typename T, SpeechSynthesisVoice::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.voice_uri, rhs.voice_uri))
    return true;
  if (std::less<>{}(rhs.voice_uri, lhs.voice_uri))
    return false;
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.lang, rhs.lang))
    return true;
  if (std::less<>{}(rhs.lang, lhs.lang))
    return false;
  if (std::less<>{}(lhs.is_local_service, rhs.is_local_service))
    return true;
  if (std::less<>{}(rhs.is_local_service, lhs.is_local_service))
    return false;
  if (std::less<>{}(lhs.is_default, rhs.is_default))
    return true;
  if (std::less<>{}(rhs.is_default, lhs.is_default))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SpeechSynthesisUtterance::DataView,
                                         ::blink::mojom::blink::SpeechSynthesisUtterancePtr> {
  static bool IsNull(const ::blink::mojom::blink::SpeechSynthesisUtterancePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SpeechSynthesisUtterancePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::SpeechSynthesisUtterance::text)& text(
      const ::blink::mojom::blink::SpeechSynthesisUtterancePtr& input) {
    return input->text;
  }

  static const decltype(::blink::mojom::blink::SpeechSynthesisUtterance::lang)& lang(
      const ::blink::mojom::blink::SpeechSynthesisUtterancePtr& input) {
    return input->lang;
  }

  static const decltype(::blink::mojom::blink::SpeechSynthesisUtterance::voice)& voice(
      const ::blink::mojom::blink::SpeechSynthesisUtterancePtr& input) {
    return input->voice;
  }

  static decltype(::blink::mojom::blink::SpeechSynthesisUtterance::volume) volume(
      const ::blink::mojom::blink::SpeechSynthesisUtterancePtr& input) {
    return input->volume;
  }

  static decltype(::blink::mojom::blink::SpeechSynthesisUtterance::rate) rate(
      const ::blink::mojom::blink::SpeechSynthesisUtterancePtr& input) {
    return input->rate;
  }

  static decltype(::blink::mojom::blink::SpeechSynthesisUtterance::pitch) pitch(
      const ::blink::mojom::blink::SpeechSynthesisUtterancePtr& input) {
    return input->pitch;
  }

  static bool Read(::blink::mojom::blink::SpeechSynthesisUtterance::DataView input, ::blink::mojom::blink::SpeechSynthesisUtterancePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SpeechSynthesisVoice::DataView,
                                         ::blink::mojom::blink::SpeechSynthesisVoicePtr> {
  static bool IsNull(const ::blink::mojom::blink::SpeechSynthesisVoicePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SpeechSynthesisVoicePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::SpeechSynthesisVoice::voice_uri)& voice_uri(
      const ::blink::mojom::blink::SpeechSynthesisVoicePtr& input) {
    return input->voice_uri;
  }

  static const decltype(::blink::mojom::blink::SpeechSynthesisVoice::name)& name(
      const ::blink::mojom::blink::SpeechSynthesisVoicePtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::blink::SpeechSynthesisVoice::lang)& lang(
      const ::blink::mojom::blink::SpeechSynthesisVoicePtr& input) {
    return input->lang;
  }

  static decltype(::blink::mojom::blink::SpeechSynthesisVoice::is_local_service) is_local_service(
      const ::blink::mojom::blink::SpeechSynthesisVoicePtr& input) {
    return input->is_local_service;
  }

  static decltype(::blink::mojom::blink::SpeechSynthesisVoice::is_default) is_default(
      const ::blink::mojom::blink::SpeechSynthesisVoicePtr& input) {
    return input->is_default;
  }

  static bool Read(::blink::mojom::blink::SpeechSynthesisVoice::DataView input, ::blink::mojom::blink::SpeechSynthesisVoicePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPEECH_SPEECH_SYNTHESIS_MOJOM_BLINK_H_