// third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_REGISTRATION_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_REGISTRATION_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-blink.h"
#include "third_party/blink/public/mojom/service_worker/navigation_preload_state.mojom-blink.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_database.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_error_type.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_object.mojom-blink.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration_options.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/core/core_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {

class ServiceWorkerRegistrationObjectHostProxy;

template <typename ImplRefTraits>
class ServiceWorkerRegistrationObjectHostStub;

class ServiceWorkerRegistrationObjectHostRequestValidator;
class ServiceWorkerRegistrationObjectHostResponseValidator;


class CORE_EXPORT ServiceWorkerRegistrationObjectHost
    : public ServiceWorkerRegistrationObjectHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ServiceWorkerRegistrationObjectHostInterfaceBase;
  using Proxy_ = ServiceWorkerRegistrationObjectHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerRegistrationObjectHostStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerRegistrationObjectHostRequestValidator;
  using ResponseValidator_ = ServiceWorkerRegistrationObjectHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kUpdateMinVersion = 0,
    kUnregisterMinVersion = 0,
    kEnableNavigationPreloadMinVersion = 0,
    kGetNavigationPreloadStateMinVersion = 0,
    kSetNavigationPreloadHeaderMinVersion = 0,
  };
  virtual ~ServiceWorkerRegistrationObjectHost() {}


  using UpdateCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerErrorType, const WTF::String&)>;
  
  virtual void Update(::blink::mojom::blink::FetchClientSettingsObjectPtr outside_fetch_client_settings_object, UpdateCallback callback) = 0;


  using UnregisterCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerErrorType, const WTF::String&)>;
  
  virtual void Unregister(UnregisterCallback callback) = 0;


  using EnableNavigationPreloadCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerErrorType, const WTF::String&)>;
  
  virtual void EnableNavigationPreload(bool enable, EnableNavigationPreloadCallback callback) = 0;


  using GetNavigationPreloadStateCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerErrorType, const WTF::String&, ::blink::mojom::blink::NavigationPreloadStatePtr)>;
  
  virtual void GetNavigationPreloadState(GetNavigationPreloadStateCallback callback) = 0;


  using SetNavigationPreloadHeaderCallback = base::OnceCallback<void(::blink::mojom::blink::ServiceWorkerErrorType, const WTF::String&)>;
  
  virtual void SetNavigationPreloadHeader(const WTF::String& value, SetNavigationPreloadHeaderCallback callback) = 0;
};

class ServiceWorkerRegistrationObjectProxy;

template <typename ImplRefTraits>
class ServiceWorkerRegistrationObjectStub;

class ServiceWorkerRegistrationObjectRequestValidator;


class CORE_EXPORT ServiceWorkerRegistrationObject
    : public ServiceWorkerRegistrationObjectInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ServiceWorkerRegistrationObjectInterfaceBase;
  using Proxy_ = ServiceWorkerRegistrationObjectProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerRegistrationObjectStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerRegistrationObjectRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetServiceWorkerObjectsMinVersion = 0,
    kSetUpdateViaCacheMinVersion = 0,
    kUpdateFoundMinVersion = 0,
  };
  virtual ~ServiceWorkerRegistrationObject() {}

  
  virtual void SetServiceWorkerObjects(ChangedServiceWorkerObjectsMaskPtr changed_mask, ::blink::mojom::blink::ServiceWorkerObjectInfoPtr installing, ::blink::mojom::blink::ServiceWorkerObjectInfoPtr waiting, ::blink::mojom::blink::ServiceWorkerObjectInfoPtr active) = 0;

  
  virtual void SetUpdateViaCache(::blink::mojom::blink::ServiceWorkerUpdateViaCache update_via_cache) = 0;

  
  virtual void UpdateFound() = 0;
};



class CORE_EXPORT ServiceWorkerRegistrationObjectHostProxy
    : public ServiceWorkerRegistrationObjectHost {
 public:
  using InterfaceType = ServiceWorkerRegistrationObjectHost;

  explicit ServiceWorkerRegistrationObjectHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Update(::blink::mojom::blink::FetchClientSettingsObjectPtr outside_fetch_client_settings_object, UpdateCallback callback) final;
  
  void Unregister(UnregisterCallback callback) final;
  
  void EnableNavigationPreload(bool enable, EnableNavigationPreloadCallback callback) final;
  
  void GetNavigationPreloadState(GetNavigationPreloadStateCallback callback) final;
  
  void SetNavigationPreloadHeader(const WTF::String& value, SetNavigationPreloadHeaderCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CORE_EXPORT ServiceWorkerRegistrationObjectProxy
    : public ServiceWorkerRegistrationObject {
 public:
  using InterfaceType = ServiceWorkerRegistrationObject;

  explicit ServiceWorkerRegistrationObjectProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetServiceWorkerObjects(ChangedServiceWorkerObjectsMaskPtr changed_mask, ::blink::mojom::blink::ServiceWorkerObjectInfoPtr installing, ::blink::mojom::blink::ServiceWorkerObjectInfoPtr waiting, ::blink::mojom::blink::ServiceWorkerObjectInfoPtr active) final;
  
  void SetUpdateViaCache(::blink::mojom::blink::ServiceWorkerUpdateViaCache update_via_cache) final;
  
  void UpdateFound() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CORE_EXPORT ServiceWorkerRegistrationObjectHostStubDispatch {
 public:
  static bool Accept(ServiceWorkerRegistrationObjectHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerRegistrationObjectHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerRegistrationObjectHost>>
class ServiceWorkerRegistrationObjectHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerRegistrationObjectHostStub() {}
  ~ServiceWorkerRegistrationObjectHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerRegistrationObjectHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerRegistrationObjectHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CORE_EXPORT ServiceWorkerRegistrationObjectStubDispatch {
 public:
  static bool Accept(ServiceWorkerRegistrationObject* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerRegistrationObject* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerRegistrationObject>>
class ServiceWorkerRegistrationObjectStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerRegistrationObjectStub() {}
  ~ServiceWorkerRegistrationObjectStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerRegistrationObjectStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerRegistrationObjectStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CORE_EXPORT ServiceWorkerRegistrationObjectHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CORE_EXPORT ServiceWorkerRegistrationObjectRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CORE_EXPORT ServiceWorkerRegistrationObjectHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class CORE_EXPORT ChangedServiceWorkerObjectsMask {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ChangedServiceWorkerObjectsMask, T>::value>;
  using DataView = ChangedServiceWorkerObjectsMaskDataView;
  using Data_ = internal::ChangedServiceWorkerObjectsMask_Data;

  template <typename... Args>
  static ChangedServiceWorkerObjectsMaskPtr New(Args&&... args) {
    return ChangedServiceWorkerObjectsMaskPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ChangedServiceWorkerObjectsMaskPtr From(const U& u) {
    return mojo::TypeConverter<ChangedServiceWorkerObjectsMaskPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ChangedServiceWorkerObjectsMask>::Convert(*this);
  }


  ChangedServiceWorkerObjectsMask();

  ChangedServiceWorkerObjectsMask(
      bool installing,
      bool waiting,
      bool active);

  ~ChangedServiceWorkerObjectsMask();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ChangedServiceWorkerObjectsMaskPtr>
  ChangedServiceWorkerObjectsMaskPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ChangedServiceWorkerObjectsMask::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChangedServiceWorkerObjectsMask::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ChangedServiceWorkerObjectsMask::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ChangedServiceWorkerObjectsMask_UnserializedMessageContext<
            UserType, ChangedServiceWorkerObjectsMask::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ChangedServiceWorkerObjectsMask::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ChangedServiceWorkerObjectsMask::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ChangedServiceWorkerObjectsMask_UnserializedMessageContext<
            UserType, ChangedServiceWorkerObjectsMask::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ChangedServiceWorkerObjectsMask::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool installing;
  
  bool waiting;
  
  bool active;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ChangedServiceWorkerObjectsMask::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ChangedServiceWorkerObjectsMask::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ChangedServiceWorkerObjectsMask::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ChangedServiceWorkerObjectsMask::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class CORE_EXPORT ServiceWorkerRegistrationObjectInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerRegistrationObjectInfo, T>::value>;
  using DataView = ServiceWorkerRegistrationObjectInfoDataView;
  using Data_ = internal::ServiceWorkerRegistrationObjectInfo_Data;

  template <typename... Args>
  static ServiceWorkerRegistrationObjectInfoPtr New(Args&&... args) {
    return ServiceWorkerRegistrationObjectInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerRegistrationObjectInfoPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerRegistrationObjectInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerRegistrationObjectInfo>::Convert(*this);
  }


  ServiceWorkerRegistrationObjectInfo();

  ServiceWorkerRegistrationObjectInfo(
      int64_t registration_id,
      const ::blink::KURL& scope,
      ::blink::mojom::blink::ServiceWorkerUpdateViaCache update_via_cache,
      ::mojo::PendingAssociatedRemote<ServiceWorkerRegistrationObjectHost> host_remote,
      ::mojo::PendingAssociatedReceiver<ServiceWorkerRegistrationObject> receiver,
      ::blink::mojom::blink::ServiceWorkerObjectInfoPtr installing,
      ::blink::mojom::blink::ServiceWorkerObjectInfoPtr waiting,
      ::blink::mojom::blink::ServiceWorkerObjectInfoPtr active);

  ~ServiceWorkerRegistrationObjectInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerRegistrationObjectInfoPtr>
  ServiceWorkerRegistrationObjectInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerRegistrationObjectInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceWorkerRegistrationObjectInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerRegistrationObjectInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerRegistrationObjectInfo_UnserializedMessageContext<
            UserType, ServiceWorkerRegistrationObjectInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ServiceWorkerRegistrationObjectInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ServiceWorkerRegistrationObjectInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerRegistrationObjectInfo_UnserializedMessageContext<
            UserType, ServiceWorkerRegistrationObjectInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerRegistrationObjectInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int64_t registration_id;
  
  ::blink::KURL scope;
  
  ::blink::mojom::blink::ServiceWorkerUpdateViaCache update_via_cache;
  
  ::mojo::PendingAssociatedRemote<ServiceWorkerRegistrationObjectHost> host_remote;
  
  ::mojo::PendingAssociatedReceiver<ServiceWorkerRegistrationObject> receiver;
  
  ::blink::mojom::blink::ServiceWorkerObjectInfoPtr installing;
  
  ::blink::mojom::blink::ServiceWorkerObjectInfoPtr waiting;
  
  ::blink::mojom::blink::ServiceWorkerObjectInfoPtr active;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ServiceWorkerRegistrationObjectInfo);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerRegistrationObjectInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerRegistrationObjectInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerRegistrationObjectInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerRegistrationObjectInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ChangedServiceWorkerObjectsMaskPtr ChangedServiceWorkerObjectsMask::Clone() const {
  return New(
      mojo::Clone(installing),
      mojo::Clone(waiting),
      mojo::Clone(active)
  );
}

template <typename T, ChangedServiceWorkerObjectsMask::EnableIfSame<T>*>
bool ChangedServiceWorkerObjectsMask::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->installing, other_struct.installing))
    return false;
  if (!mojo::Equals(this->waiting, other_struct.waiting))
    return false;
  if (!mojo::Equals(this->active, other_struct.active))
    return false;
  return true;
}

template <typename T, ChangedServiceWorkerObjectsMask::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.installing, rhs.installing))
    return true;
  if (std::less<>{}(rhs.installing, lhs.installing))
    return false;
  if (std::less<>{}(lhs.waiting, rhs.waiting))
    return true;
  if (std::less<>{}(rhs.waiting, lhs.waiting))
    return false;
  if (std::less<>{}(lhs.active, rhs.active))
    return true;
  if (std::less<>{}(rhs.active, lhs.active))
    return false;
  return false;
}
template <typename StructPtrType>
ServiceWorkerRegistrationObjectInfoPtr ServiceWorkerRegistrationObjectInfo::Clone() const {
  return New(
      mojo::Clone(registration_id),
      mojo::Clone(scope),
      mojo::Clone(update_via_cache),
      mojo::Clone(host_remote),
      mojo::Clone(receiver),
      mojo::Clone(installing),
      mojo::Clone(waiting),
      mojo::Clone(active)
  );
}

template <typename T, ServiceWorkerRegistrationObjectInfo::EnableIfSame<T>*>
bool ServiceWorkerRegistrationObjectInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->registration_id, other_struct.registration_id))
    return false;
  if (!mojo::Equals(this->scope, other_struct.scope))
    return false;
  if (!mojo::Equals(this->update_via_cache, other_struct.update_via_cache))
    return false;
  if (!mojo::Equals(this->host_remote, other_struct.host_remote))
    return false;
  if (!mojo::Equals(this->receiver, other_struct.receiver))
    return false;
  if (!mojo::Equals(this->installing, other_struct.installing))
    return false;
  if (!mojo::Equals(this->waiting, other_struct.waiting))
    return false;
  if (!mojo::Equals(this->active, other_struct.active))
    return false;
  return true;
}

template <typename T, ServiceWorkerRegistrationObjectInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.registration_id, rhs.registration_id))
    return true;
  if (std::less<>{}(rhs.registration_id, lhs.registration_id))
    return false;
  if (std::less<>{}(lhs.scope, rhs.scope))
    return true;
  if (std::less<>{}(rhs.scope, lhs.scope))
    return false;
  if (std::less<>{}(lhs.update_via_cache, rhs.update_via_cache))
    return true;
  if (std::less<>{}(rhs.update_via_cache, lhs.update_via_cache))
    return false;
  if (std::less<>{}(lhs.host_remote, rhs.host_remote))
    return true;
  if (std::less<>{}(rhs.host_remote, lhs.host_remote))
    return false;
  if (std::less<>{}(lhs.receiver, rhs.receiver))
    return true;
  if (std::less<>{}(rhs.receiver, lhs.receiver))
    return false;
  if (std::less<>{}(lhs.installing, rhs.installing))
    return true;
  if (std::less<>{}(rhs.installing, lhs.installing))
    return false;
  if (std::less<>{}(lhs.waiting, rhs.waiting))
    return true;
  if (std::less<>{}(rhs.waiting, lhs.waiting))
    return false;
  if (std::less<>{}(lhs.active, rhs.active))
    return true;
  if (std::less<>{}(rhs.active, lhs.active))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::ChangedServiceWorkerObjectsMask::DataView,
                                         ::blink::mojom::blink::ChangedServiceWorkerObjectsMaskPtr> {
  static bool IsNull(const ::blink::mojom::blink::ChangedServiceWorkerObjectsMaskPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ChangedServiceWorkerObjectsMaskPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::ChangedServiceWorkerObjectsMask::installing) installing(
      const ::blink::mojom::blink::ChangedServiceWorkerObjectsMaskPtr& input) {
    return input->installing;
  }

  static decltype(::blink::mojom::blink::ChangedServiceWorkerObjectsMask::waiting) waiting(
      const ::blink::mojom::blink::ChangedServiceWorkerObjectsMaskPtr& input) {
    return input->waiting;
  }

  static decltype(::blink::mojom::blink::ChangedServiceWorkerObjectsMask::active) active(
      const ::blink::mojom::blink::ChangedServiceWorkerObjectsMaskPtr& input) {
    return input->active;
  }

  static bool Read(::blink::mojom::blink::ChangedServiceWorkerObjectsMask::DataView input, ::blink::mojom::blink::ChangedServiceWorkerObjectsMaskPtr* output);
};


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::ServiceWorkerRegistrationObjectInfo::DataView,
                                         ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::ServiceWorkerRegistrationObjectInfo::registration_id) registration_id(
      const ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr& input) {
    return input->registration_id;
  }

  static const decltype(::blink::mojom::blink::ServiceWorkerRegistrationObjectInfo::scope)& scope(
      const ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr& input) {
    return input->scope;
  }

  static decltype(::blink::mojom::blink::ServiceWorkerRegistrationObjectInfo::update_via_cache) update_via_cache(
      const ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr& input) {
    return input->update_via_cache;
  }

  static  decltype(::blink::mojom::blink::ServiceWorkerRegistrationObjectInfo::host_remote)& host_remote(
       ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr& input) {
    return input->host_remote;
  }

  static  decltype(::blink::mojom::blink::ServiceWorkerRegistrationObjectInfo::receiver)& receiver(
       ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr& input) {
    return input->receiver;
  }

  static  decltype(::blink::mojom::blink::ServiceWorkerRegistrationObjectInfo::installing)& installing(
       ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr& input) {
    return input->installing;
  }

  static  decltype(::blink::mojom::blink::ServiceWorkerRegistrationObjectInfo::waiting)& waiting(
       ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr& input) {
    return input->waiting;
  }

  static  decltype(::blink::mojom::blink::ServiceWorkerRegistrationObjectInfo::active)& active(
       ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr& input) {
    return input->active;
  }

  static bool Read(::blink::mojom::blink::ServiceWorkerRegistrationObjectInfo::DataView input, ::blink::mojom::blink::ServiceWorkerRegistrationObjectInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_REGISTRATION_MOJOM_BLINK_H_