// third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCROLL_SCROLL_INTO_VIEW_PARAMS_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCROLL_SCROLL_INTO_VIEW_PARAMS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/scroll/scroll_enums.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"



#include "base/component_export.h"




namespace blink {
namespace mojom {
class ScrollAlignmentDataView;

class ScrollIntoViewParamsDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ScrollAlignmentDataView> {
  using Data = ::blink::mojom::internal::ScrollAlignment_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ScrollIntoViewParamsDataView> {
  using Data = ::blink::mojom::internal::ScrollIntoViewParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class ScrollAlignment_Behavior : int32_t {
  
  kNoScroll = 0,
  
  kCenter = 1,
  
  kTop = 2,
  
  kBottom = 3,
  
  kLeft = 4,
  
  kRight = 5,
  
  kClosestEdge = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ScrollAlignment_Behavior value);
inline bool IsKnownEnumValue(ScrollAlignment_Behavior value) {
  return internal::ScrollAlignment_Behavior_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ScrollAlignmentDataView {
 public:
  ScrollAlignmentDataView() {}

  ScrollAlignmentDataView(
      internal::ScrollAlignment_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRectVisible(UserType* output) const {
    auto data_value = data_->rect_visible;
    return mojo::internal::Deserialize<::blink::mojom::ScrollAlignment_Behavior>(
        data_value, output);
  }

  ScrollAlignment_Behavior rect_visible() const {
    return static_cast<ScrollAlignment_Behavior>(data_->rect_visible);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRectHidden(UserType* output) const {
    auto data_value = data_->rect_hidden;
    return mojo::internal::Deserialize<::blink::mojom::ScrollAlignment_Behavior>(
        data_value, output);
  }

  ScrollAlignment_Behavior rect_hidden() const {
    return static_cast<ScrollAlignment_Behavior>(data_->rect_hidden);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRectPartial(UserType* output) const {
    auto data_value = data_->rect_partial;
    return mojo::internal::Deserialize<::blink::mojom::ScrollAlignment_Behavior>(
        data_value, output);
  }

  ScrollAlignment_Behavior rect_partial() const {
    return static_cast<ScrollAlignment_Behavior>(data_->rect_partial);
  }
 private:
  internal::ScrollAlignment_Data* data_ = nullptr;
};



class ScrollIntoViewParamsDataView {
 public:
  ScrollIntoViewParamsDataView() {}

  ScrollIntoViewParamsDataView(
      internal::ScrollIntoViewParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetAlignXDataView(
      ScrollAlignmentDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAlignX(UserType* output) {
    
    auto* pointer = data_->align_x.Get();
    return mojo::internal::Deserialize<::blink::mojom::ScrollAlignmentDataView>(
        pointer, output, context_);
  }
  inline void GetAlignYDataView(
      ScrollAlignmentDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAlignY(UserType* output) {
    
    auto* pointer = data_->align_y.Get();
    return mojo::internal::Deserialize<::blink::mojom::ScrollAlignmentDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::ScrollType>(
        data_value, output);
  }

  ::blink::mojom::ScrollType type() const {
    return static_cast<::blink::mojom::ScrollType>(data_->type);
  }
  bool make_visible_in_visual_viewport() const {
    return data_->make_visible_in_visual_viewport;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBehavior(UserType* output) const {
    auto data_value = data_->behavior;
    return mojo::internal::Deserialize<::blink::mojom::ScrollBehavior>(
        data_value, output);
  }

  ::blink::mojom::ScrollBehavior behavior() const {
    return static_cast<::blink::mojom::ScrollBehavior>(data_->behavior);
  }
  bool is_for_scroll_sequence() const {
    return data_->is_for_scroll_sequence;
  }
  bool zoom_into_rect() const {
    return data_->zoom_into_rect;
  }
  inline void GetRelativeElementBoundsDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRelativeElementBounds(UserType* output) {
    
    auto* pointer = data_->relative_element_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, context_);
  }
  inline void GetRelativeCaretBoundsDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRelativeCaretBounds(UserType* output) {
    
    auto* pointer = data_->relative_caret_bounds.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, context_);
  }
  bool stop_at_main_frame_layout_viewport() const {
    return data_->stop_at_main_frame_layout_viewport;
  }
 private:
  internal::ScrollIntoViewParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::ScrollAlignment_Behavior>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ScrollAlignment_Behavior> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::ScrollAlignment_Behavior, ::blink::mojom::ScrollAlignment_Behavior> {
  static ::blink::mojom::ScrollAlignment_Behavior ToMojom(::blink::mojom::ScrollAlignment_Behavior input) { return input; }
  static bool FromMojom(::blink::mojom::ScrollAlignment_Behavior input, ::blink::mojom::ScrollAlignment_Behavior* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ScrollAlignment_Behavior, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ScrollAlignment_Behavior, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::ScrollAlignment_Behavior>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ScrollAlignmentDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ScrollAlignmentDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::ScrollAlignment_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::blink::mojom::ScrollAlignment_Behavior>(
        Traits::rect_visible(input), &(*output)->rect_visible);
    mojo::internal::Serialize<::blink::mojom::ScrollAlignment_Behavior>(
        Traits::rect_hidden(input), &(*output)->rect_hidden);
    mojo::internal::Serialize<::blink::mojom::ScrollAlignment_Behavior>(
        Traits::rect_partial(input), &(*output)->rect_partial);
  }

  static bool Deserialize(::blink::mojom::internal::ScrollAlignment_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ScrollAlignmentDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ScrollIntoViewParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ScrollIntoViewParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::ScrollIntoViewParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::align_x(input)) in_align_x = Traits::align_x(input);
    typename decltype((*output)->align_x)::BaseType::BufferWriter
        align_x_writer;
    mojo::internal::Serialize<::blink::mojom::ScrollAlignmentDataView>(
        in_align_x, buffer, &align_x_writer, context);
    (*output)->align_x.Set(
        align_x_writer.is_null() ? nullptr : align_x_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->align_x.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null align_x in ScrollIntoViewParams struct");
    decltype(Traits::align_y(input)) in_align_y = Traits::align_y(input);
    typename decltype((*output)->align_y)::BaseType::BufferWriter
        align_y_writer;
    mojo::internal::Serialize<::blink::mojom::ScrollAlignmentDataView>(
        in_align_y, buffer, &align_y_writer, context);
    (*output)->align_y.Set(
        align_y_writer.is_null() ? nullptr : align_y_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->align_y.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null align_y in ScrollIntoViewParams struct");
    mojo::internal::Serialize<::blink::mojom::ScrollType>(
        Traits::type(input), &(*output)->type);
    (*output)->make_visible_in_visual_viewport = Traits::make_visible_in_visual_viewport(input);
    mojo::internal::Serialize<::blink::mojom::ScrollBehavior>(
        Traits::behavior(input), &(*output)->behavior);
    (*output)->is_for_scroll_sequence = Traits::is_for_scroll_sequence(input);
    (*output)->zoom_into_rect = Traits::zoom_into_rect(input);
    decltype(Traits::relative_element_bounds(input)) in_relative_element_bounds = Traits::relative_element_bounds(input);
    typename decltype((*output)->relative_element_bounds)::BaseType::BufferWriter
        relative_element_bounds_writer;
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
        in_relative_element_bounds, buffer, &relative_element_bounds_writer, context);
    (*output)->relative_element_bounds.Set(
        relative_element_bounds_writer.is_null() ? nullptr : relative_element_bounds_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->relative_element_bounds.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null relative_element_bounds in ScrollIntoViewParams struct");
    decltype(Traits::relative_caret_bounds(input)) in_relative_caret_bounds = Traits::relative_caret_bounds(input);
    typename decltype((*output)->relative_caret_bounds)::BaseType::BufferWriter
        relative_caret_bounds_writer;
    mojo::internal::Serialize<::gfx::mojom::RectFDataView>(
        in_relative_caret_bounds, buffer, &relative_caret_bounds_writer, context);
    (*output)->relative_caret_bounds.Set(
        relative_caret_bounds_writer.is_null() ? nullptr : relative_caret_bounds_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->relative_caret_bounds.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null relative_caret_bounds in ScrollIntoViewParams struct");
    (*output)->stop_at_main_frame_layout_viewport = Traits::stop_at_main_frame_layout_viewport(input);
  }

  static bool Deserialize(::blink::mojom::internal::ScrollIntoViewParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ScrollIntoViewParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {



inline void ScrollIntoViewParamsDataView::GetAlignXDataView(
    ScrollAlignmentDataView* output) {
  auto pointer = data_->align_x.Get();
  *output = ScrollAlignmentDataView(pointer, context_);
}
inline void ScrollIntoViewParamsDataView::GetAlignYDataView(
    ScrollAlignmentDataView* output) {
  auto pointer = data_->align_y.Get();
  *output = ScrollAlignmentDataView(pointer, context_);
}
inline void ScrollIntoViewParamsDataView::GetRelativeElementBoundsDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->relative_element_bounds.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, context_);
}
inline void ScrollIntoViewParamsDataView::GetRelativeCaretBoundsDataView(
    ::gfx::mojom::RectFDataView* output) {
  auto pointer = data_->relative_caret_bounds.Get();
  *output = ::gfx::mojom::RectFDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCROLL_SCROLL_INTO_VIEW_PARAMS_MOJOM_SHARED_H_