// third_party/blink/public/mojom/renderer_preferences.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDERER_PREFERENCES_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDERER_PREFERENCES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/renderer_preferences.mojom-shared.h"
#include "third_party/blink/public/mojom/renderer_preferences.mojom-forward.h"
#include "mojo/public/mojom/base/string16.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "ui/gfx/mojom/font_render_params.mojom.h"
#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {








class BLINK_COMMON_EXPORT RendererPreferences {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RendererPreferences, T>::value>;
  using DataView = RendererPreferencesDataView;
  using Data_ = internal::RendererPreferences_Data;

  template <typename... Args>
  static RendererPreferencesPtr New(Args&&... args) {
    return RendererPreferencesPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RendererPreferencesPtr From(const U& u) {
    return mojo::TypeConverter<RendererPreferencesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RendererPreferences>::Convert(*this);
  }


  RendererPreferences();

  RendererPreferences(
      bool can_accept_load_drops,
      bool should_antialias_text,
      ::gfx::FontRenderParams::Hinting hinting,
      bool use_autohinter,
      bool use_bitmaps,
      ::gfx::FontRenderParams::SubpixelRendering subpixel_rendering,
      bool use_subpixel_positioning,
      uint32_t focus_ring_color,
      uint32_t active_selection_bg_color,
      uint32_t active_selection_fg_color,
      uint32_t inactive_selection_bg_color,
      uint32_t inactive_selection_fg_color,
      bool browser_handles_all_top_level_requests,
      base::Optional<::base::TimeDelta> caret_blink_interval,
      bool use_custom_colors,
      bool enable_referrers,
      bool allow_cross_origin_auth_prompt,
      bool enable_do_not_track,
      bool enable_encrypted_media,
      const std::string& webrtc_ip_handling_policy,
      uint16_t webrtc_udp_min_port,
      uint16_t webrtc_udp_max_port,
      std::vector<std::string> webrtc_local_ips_allowed_urls,
      bool webrtc_allow_legacy_tls_protocols,
      const ::blink::UserAgentOverride& user_agent_override,
      const std::string& accept_languages,
      bool plugin_fullscreen_allowed,
      bool caret_browsing_enabled,
      const std::string& system_font_family_name,
      bool selection_clipboard_buffer_available);

  ~RendererPreferences();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RendererPreferencesPtr>
  RendererPreferencesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RendererPreferences::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RendererPreferences::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RendererPreferences::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RendererPreferences_UnserializedMessageContext<
            UserType, RendererPreferences::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<RendererPreferences::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return RendererPreferences::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RendererPreferences_UnserializedMessageContext<
            UserType, RendererPreferences::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RendererPreferences::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool can_accept_load_drops;
  
  bool should_antialias_text;
  
  ::gfx::FontRenderParams::Hinting hinting;
  
  bool use_autohinter;
  
  bool use_bitmaps;
  
  ::gfx::FontRenderParams::SubpixelRendering subpixel_rendering;
  
  bool use_subpixel_positioning;
  
  uint32_t focus_ring_color;
  
  uint32_t active_selection_bg_color;
  
  uint32_t active_selection_fg_color;
  
  uint32_t inactive_selection_bg_color;
  
  uint32_t inactive_selection_fg_color;
  
  bool browser_handles_all_top_level_requests;
  
  base::Optional<::base::TimeDelta> caret_blink_interval;
  
  bool use_custom_colors;
  
  bool enable_referrers;
  
  bool allow_cross_origin_auth_prompt;
  
  bool enable_do_not_track;
  
  bool enable_encrypted_media;
  
  std::string webrtc_ip_handling_policy;
  
  uint16_t webrtc_udp_min_port;
  
  uint16_t webrtc_udp_max_port;
  
  std::vector<std::string> webrtc_local_ips_allowed_urls;
  
  bool webrtc_allow_legacy_tls_protocols;
  
  ::blink::UserAgentOverride user_agent_override;
  
  std::string accept_languages;
  
  bool plugin_fullscreen_allowed;
  
  bool caret_browsing_enabled;
  
  std::string system_font_family_name;
  
  bool selection_clipboard_buffer_available;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RendererPreferences::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RendererPreferences::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RendererPreferences::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RendererPreferences::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
RendererPreferencesPtr RendererPreferences::Clone() const {
  return New(
      mojo::Clone(can_accept_load_drops),
      mojo::Clone(should_antialias_text),
      mojo::Clone(hinting),
      mojo::Clone(use_autohinter),
      mojo::Clone(use_bitmaps),
      mojo::Clone(subpixel_rendering),
      mojo::Clone(use_subpixel_positioning),
      mojo::Clone(focus_ring_color),
      mojo::Clone(active_selection_bg_color),
      mojo::Clone(active_selection_fg_color),
      mojo::Clone(inactive_selection_bg_color),
      mojo::Clone(inactive_selection_fg_color),
      mojo::Clone(browser_handles_all_top_level_requests),
      mojo::Clone(caret_blink_interval),
      mojo::Clone(use_custom_colors),
      mojo::Clone(enable_referrers),
      mojo::Clone(allow_cross_origin_auth_prompt),
      mojo::Clone(enable_do_not_track),
      mojo::Clone(enable_encrypted_media),
      mojo::Clone(webrtc_ip_handling_policy),
      mojo::Clone(webrtc_udp_min_port),
      mojo::Clone(webrtc_udp_max_port),
      mojo::Clone(webrtc_local_ips_allowed_urls),
      mojo::Clone(webrtc_allow_legacy_tls_protocols),
      mojo::Clone(user_agent_override),
      mojo::Clone(accept_languages),
      mojo::Clone(plugin_fullscreen_allowed),
      mojo::Clone(caret_browsing_enabled),
      mojo::Clone(system_font_family_name),
      mojo::Clone(selection_clipboard_buffer_available)
  );
}

template <typename T, RendererPreferences::EnableIfSame<T>*>
bool RendererPreferences::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->can_accept_load_drops, other_struct.can_accept_load_drops))
    return false;
  if (!mojo::Equals(this->should_antialias_text, other_struct.should_antialias_text))
    return false;
  if (!mojo::Equals(this->hinting, other_struct.hinting))
    return false;
  if (!mojo::Equals(this->use_autohinter, other_struct.use_autohinter))
    return false;
  if (!mojo::Equals(this->use_bitmaps, other_struct.use_bitmaps))
    return false;
  if (!mojo::Equals(this->subpixel_rendering, other_struct.subpixel_rendering))
    return false;
  if (!mojo::Equals(this->use_subpixel_positioning, other_struct.use_subpixel_positioning))
    return false;
  if (!mojo::Equals(this->focus_ring_color, other_struct.focus_ring_color))
    return false;
  if (!mojo::Equals(this->active_selection_bg_color, other_struct.active_selection_bg_color))
    return false;
  if (!mojo::Equals(this->active_selection_fg_color, other_struct.active_selection_fg_color))
    return false;
  if (!mojo::Equals(this->inactive_selection_bg_color, other_struct.inactive_selection_bg_color))
    return false;
  if (!mojo::Equals(this->inactive_selection_fg_color, other_struct.inactive_selection_fg_color))
    return false;
  if (!mojo::Equals(this->browser_handles_all_top_level_requests, other_struct.browser_handles_all_top_level_requests))
    return false;
  if (!mojo::Equals(this->caret_blink_interval, other_struct.caret_blink_interval))
    return false;
  if (!mojo::Equals(this->use_custom_colors, other_struct.use_custom_colors))
    return false;
  if (!mojo::Equals(this->enable_referrers, other_struct.enable_referrers))
    return false;
  if (!mojo::Equals(this->allow_cross_origin_auth_prompt, other_struct.allow_cross_origin_auth_prompt))
    return false;
  if (!mojo::Equals(this->enable_do_not_track, other_struct.enable_do_not_track))
    return false;
  if (!mojo::Equals(this->enable_encrypted_media, other_struct.enable_encrypted_media))
    return false;
  if (!mojo::Equals(this->webrtc_ip_handling_policy, other_struct.webrtc_ip_handling_policy))
    return false;
  if (!mojo::Equals(this->webrtc_udp_min_port, other_struct.webrtc_udp_min_port))
    return false;
  if (!mojo::Equals(this->webrtc_udp_max_port, other_struct.webrtc_udp_max_port))
    return false;
  if (!mojo::Equals(this->webrtc_local_ips_allowed_urls, other_struct.webrtc_local_ips_allowed_urls))
    return false;
  if (!mojo::Equals(this->webrtc_allow_legacy_tls_protocols, other_struct.webrtc_allow_legacy_tls_protocols))
    return false;
  if (!mojo::Equals(this->user_agent_override, other_struct.user_agent_override))
    return false;
  if (!mojo::Equals(this->accept_languages, other_struct.accept_languages))
    return false;
  if (!mojo::Equals(this->plugin_fullscreen_allowed, other_struct.plugin_fullscreen_allowed))
    return false;
  if (!mojo::Equals(this->caret_browsing_enabled, other_struct.caret_browsing_enabled))
    return false;
  if (!mojo::Equals(this->system_font_family_name, other_struct.system_font_family_name))
    return false;
  if (!mojo::Equals(this->selection_clipboard_buffer_available, other_struct.selection_clipboard_buffer_available))
    return false;
  return true;
}

template <typename T, RendererPreferences::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.can_accept_load_drops, rhs.can_accept_load_drops))
    return true;
  if (std::less<>{}(rhs.can_accept_load_drops, lhs.can_accept_load_drops))
    return false;
  if (std::less<>{}(lhs.should_antialias_text, rhs.should_antialias_text))
    return true;
  if (std::less<>{}(rhs.should_antialias_text, lhs.should_antialias_text))
    return false;
  if (std::less<>{}(lhs.hinting, rhs.hinting))
    return true;
  if (std::less<>{}(rhs.hinting, lhs.hinting))
    return false;
  if (std::less<>{}(lhs.use_autohinter, rhs.use_autohinter))
    return true;
  if (std::less<>{}(rhs.use_autohinter, lhs.use_autohinter))
    return false;
  if (std::less<>{}(lhs.use_bitmaps, rhs.use_bitmaps))
    return true;
  if (std::less<>{}(rhs.use_bitmaps, lhs.use_bitmaps))
    return false;
  if (std::less<>{}(lhs.subpixel_rendering, rhs.subpixel_rendering))
    return true;
  if (std::less<>{}(rhs.subpixel_rendering, lhs.subpixel_rendering))
    return false;
  if (std::less<>{}(lhs.use_subpixel_positioning, rhs.use_subpixel_positioning))
    return true;
  if (std::less<>{}(rhs.use_subpixel_positioning, lhs.use_subpixel_positioning))
    return false;
  if (std::less<>{}(lhs.focus_ring_color, rhs.focus_ring_color))
    return true;
  if (std::less<>{}(rhs.focus_ring_color, lhs.focus_ring_color))
    return false;
  if (std::less<>{}(lhs.active_selection_bg_color, rhs.active_selection_bg_color))
    return true;
  if (std::less<>{}(rhs.active_selection_bg_color, lhs.active_selection_bg_color))
    return false;
  if (std::less<>{}(lhs.active_selection_fg_color, rhs.active_selection_fg_color))
    return true;
  if (std::less<>{}(rhs.active_selection_fg_color, lhs.active_selection_fg_color))
    return false;
  if (std::less<>{}(lhs.inactive_selection_bg_color, rhs.inactive_selection_bg_color))
    return true;
  if (std::less<>{}(rhs.inactive_selection_bg_color, lhs.inactive_selection_bg_color))
    return false;
  if (std::less<>{}(lhs.inactive_selection_fg_color, rhs.inactive_selection_fg_color))
    return true;
  if (std::less<>{}(rhs.inactive_selection_fg_color, lhs.inactive_selection_fg_color))
    return false;
  if (std::less<>{}(lhs.browser_handles_all_top_level_requests, rhs.browser_handles_all_top_level_requests))
    return true;
  if (std::less<>{}(rhs.browser_handles_all_top_level_requests, lhs.browser_handles_all_top_level_requests))
    return false;
  if (std::less<>{}(lhs.caret_blink_interval, rhs.caret_blink_interval))
    return true;
  if (std::less<>{}(rhs.caret_blink_interval, lhs.caret_blink_interval))
    return false;
  if (std::less<>{}(lhs.use_custom_colors, rhs.use_custom_colors))
    return true;
  if (std::less<>{}(rhs.use_custom_colors, lhs.use_custom_colors))
    return false;
  if (std::less<>{}(lhs.enable_referrers, rhs.enable_referrers))
    return true;
  if (std::less<>{}(rhs.enable_referrers, lhs.enable_referrers))
    return false;
  if (std::less<>{}(lhs.allow_cross_origin_auth_prompt, rhs.allow_cross_origin_auth_prompt))
    return true;
  if (std::less<>{}(rhs.allow_cross_origin_auth_prompt, lhs.allow_cross_origin_auth_prompt))
    return false;
  if (std::less<>{}(lhs.enable_do_not_track, rhs.enable_do_not_track))
    return true;
  if (std::less<>{}(rhs.enable_do_not_track, lhs.enable_do_not_track))
    return false;
  if (std::less<>{}(lhs.enable_encrypted_media, rhs.enable_encrypted_media))
    return true;
  if (std::less<>{}(rhs.enable_encrypted_media, lhs.enable_encrypted_media))
    return false;
  if (std::less<>{}(lhs.webrtc_ip_handling_policy, rhs.webrtc_ip_handling_policy))
    return true;
  if (std::less<>{}(rhs.webrtc_ip_handling_policy, lhs.webrtc_ip_handling_policy))
    return false;
  if (std::less<>{}(lhs.webrtc_udp_min_port, rhs.webrtc_udp_min_port))
    return true;
  if (std::less<>{}(rhs.webrtc_udp_min_port, lhs.webrtc_udp_min_port))
    return false;
  if (std::less<>{}(lhs.webrtc_udp_max_port, rhs.webrtc_udp_max_port))
    return true;
  if (std::less<>{}(rhs.webrtc_udp_max_port, lhs.webrtc_udp_max_port))
    return false;
  if (std::less<>{}(lhs.webrtc_local_ips_allowed_urls, rhs.webrtc_local_ips_allowed_urls))
    return true;
  if (std::less<>{}(rhs.webrtc_local_ips_allowed_urls, lhs.webrtc_local_ips_allowed_urls))
    return false;
  if (std::less<>{}(lhs.webrtc_allow_legacy_tls_protocols, rhs.webrtc_allow_legacy_tls_protocols))
    return true;
  if (std::less<>{}(rhs.webrtc_allow_legacy_tls_protocols, lhs.webrtc_allow_legacy_tls_protocols))
    return false;
  if (std::less<>{}(lhs.user_agent_override, rhs.user_agent_override))
    return true;
  if (std::less<>{}(rhs.user_agent_override, lhs.user_agent_override))
    return false;
  if (std::less<>{}(lhs.accept_languages, rhs.accept_languages))
    return true;
  if (std::less<>{}(rhs.accept_languages, lhs.accept_languages))
    return false;
  if (std::less<>{}(lhs.plugin_fullscreen_allowed, rhs.plugin_fullscreen_allowed))
    return true;
  if (std::less<>{}(rhs.plugin_fullscreen_allowed, lhs.plugin_fullscreen_allowed))
    return false;
  if (std::less<>{}(lhs.caret_browsing_enabled, rhs.caret_browsing_enabled))
    return true;
  if (std::less<>{}(rhs.caret_browsing_enabled, lhs.caret_browsing_enabled))
    return false;
  if (std::less<>{}(lhs.system_font_family_name, rhs.system_font_family_name))
    return true;
  if (std::less<>{}(rhs.system_font_family_name, lhs.system_font_family_name))
    return false;
  if (std::less<>{}(lhs.selection_clipboard_buffer_available, rhs.selection_clipboard_buffer_available))
    return true;
  if (std::less<>{}(rhs.selection_clipboard_buffer_available, lhs.selection_clipboard_buffer_available))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::RendererPreferences::DataView,
                                         ::blink::mojom::RendererPreferencesPtr> {
  static bool IsNull(const ::blink::mojom::RendererPreferencesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::RendererPreferencesPtr* output) { output->reset(); }

  static decltype(::blink::mojom::RendererPreferences::can_accept_load_drops) can_accept_load_drops(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->can_accept_load_drops;
  }

  static decltype(::blink::mojom::RendererPreferences::should_antialias_text) should_antialias_text(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->should_antialias_text;
  }

  static decltype(::blink::mojom::RendererPreferences::hinting) hinting(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->hinting;
  }

  static decltype(::blink::mojom::RendererPreferences::use_autohinter) use_autohinter(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->use_autohinter;
  }

  static decltype(::blink::mojom::RendererPreferences::use_bitmaps) use_bitmaps(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->use_bitmaps;
  }

  static decltype(::blink::mojom::RendererPreferences::subpixel_rendering) subpixel_rendering(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->subpixel_rendering;
  }

  static decltype(::blink::mojom::RendererPreferences::use_subpixel_positioning) use_subpixel_positioning(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->use_subpixel_positioning;
  }

  static decltype(::blink::mojom::RendererPreferences::focus_ring_color) focus_ring_color(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->focus_ring_color;
  }

  static decltype(::blink::mojom::RendererPreferences::active_selection_bg_color) active_selection_bg_color(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->active_selection_bg_color;
  }

  static decltype(::blink::mojom::RendererPreferences::active_selection_fg_color) active_selection_fg_color(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->active_selection_fg_color;
  }

  static decltype(::blink::mojom::RendererPreferences::inactive_selection_bg_color) inactive_selection_bg_color(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->inactive_selection_bg_color;
  }

  static decltype(::blink::mojom::RendererPreferences::inactive_selection_fg_color) inactive_selection_fg_color(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->inactive_selection_fg_color;
  }

  static decltype(::blink::mojom::RendererPreferences::browser_handles_all_top_level_requests) browser_handles_all_top_level_requests(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->browser_handles_all_top_level_requests;
  }

  static const decltype(::blink::mojom::RendererPreferences::caret_blink_interval)& caret_blink_interval(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->caret_blink_interval;
  }

  static decltype(::blink::mojom::RendererPreferences::use_custom_colors) use_custom_colors(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->use_custom_colors;
  }

  static decltype(::blink::mojom::RendererPreferences::enable_referrers) enable_referrers(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->enable_referrers;
  }

  static decltype(::blink::mojom::RendererPreferences::allow_cross_origin_auth_prompt) allow_cross_origin_auth_prompt(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->allow_cross_origin_auth_prompt;
  }

  static decltype(::blink::mojom::RendererPreferences::enable_do_not_track) enable_do_not_track(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->enable_do_not_track;
  }

  static decltype(::blink::mojom::RendererPreferences::enable_encrypted_media) enable_encrypted_media(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->enable_encrypted_media;
  }

  static const decltype(::blink::mojom::RendererPreferences::webrtc_ip_handling_policy)& webrtc_ip_handling_policy(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->webrtc_ip_handling_policy;
  }

  static decltype(::blink::mojom::RendererPreferences::webrtc_udp_min_port) webrtc_udp_min_port(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->webrtc_udp_min_port;
  }

  static decltype(::blink::mojom::RendererPreferences::webrtc_udp_max_port) webrtc_udp_max_port(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->webrtc_udp_max_port;
  }

  static const decltype(::blink::mojom::RendererPreferences::webrtc_local_ips_allowed_urls)& webrtc_local_ips_allowed_urls(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->webrtc_local_ips_allowed_urls;
  }

  static decltype(::blink::mojom::RendererPreferences::webrtc_allow_legacy_tls_protocols) webrtc_allow_legacy_tls_protocols(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->webrtc_allow_legacy_tls_protocols;
  }

  static const decltype(::blink::mojom::RendererPreferences::user_agent_override)& user_agent_override(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->user_agent_override;
  }

  static const decltype(::blink::mojom::RendererPreferences::accept_languages)& accept_languages(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->accept_languages;
  }

  static decltype(::blink::mojom::RendererPreferences::plugin_fullscreen_allowed) plugin_fullscreen_allowed(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->plugin_fullscreen_allowed;
  }

  static decltype(::blink::mojom::RendererPreferences::caret_browsing_enabled) caret_browsing_enabled(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->caret_browsing_enabled;
  }

  static const decltype(::blink::mojom::RendererPreferences::system_font_family_name)& system_font_family_name(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->system_font_family_name;
  }

  static decltype(::blink::mojom::RendererPreferences::selection_clipboard_buffer_available) selection_clipboard_buffer_available(
      const ::blink::mojom::RendererPreferencesPtr& input) {
    return input->selection_clipboard_buffer_available;
  }

  static bool Read(::blink::mojom::RendererPreferences::DataView input, ::blink::mojom::RendererPreferencesPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDERER_PREFERENCES_MOJOM_H_