// third_party/blink/public/mojom/push_messaging/push_messaging.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PUSH_MESSAGING_PUSH_MESSAGING_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PUSH_MESSAGING_PUSH_MESSAGING_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-shared.h"
#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-forward.h"
#include "third_party/blink/public/mojom/push_messaging/push_messaging_status.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {

class PushMessagingProxy;

template <typename ImplRefTraits>
class PushMessagingStub;

class PushMessagingRequestValidator;
class PushMessagingResponseValidator;


class BLINK_COMMON_EXPORT PushMessaging
    : public PushMessagingInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = PushMessagingInterfaceBase;
  using Proxy_ = PushMessagingProxy;

  template <typename ImplRefTraits>
  using Stub_ = PushMessagingStub<ImplRefTraits>;

  using RequestValidator_ = PushMessagingRequestValidator;
  using ResponseValidator_ = PushMessagingResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSubscribeMinVersion = 0,
    kUnsubscribeMinVersion = 0,
    kGetSubscriptionMinVersion = 0,
  };
  virtual ~PushMessaging() {}


  using SubscribeCallback = base::OnceCallback<void(::blink::mojom::PushRegistrationStatus, PushSubscriptionPtr)>;
  
  virtual void Subscribe(int64_t service_worker_registration_id, PushSubscriptionOptionsPtr options, bool user_gesture, SubscribeCallback callback) = 0;


  using UnsubscribeCallback = base::OnceCallback<void(PushErrorType, bool, const base::Optional<std::string>&)>;
  
  virtual void Unsubscribe(int64_t service_worker_registration_id, UnsubscribeCallback callback) = 0;


  using GetSubscriptionCallback = base::OnceCallback<void(::blink::mojom::PushGetRegistrationStatus, PushSubscriptionPtr)>;
  
  virtual void GetSubscription(int64_t service_worker_registration_id, GetSubscriptionCallback callback) = 0;
};



class BLINK_COMMON_EXPORT PushMessagingProxy
    : public PushMessaging {
 public:
  using InterfaceType = PushMessaging;

  explicit PushMessagingProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Subscribe(int64_t service_worker_registration_id, PushSubscriptionOptionsPtr options, bool user_gesture, SubscribeCallback callback) final;
  
  void Unsubscribe(int64_t service_worker_registration_id, UnsubscribeCallback callback) final;
  
  void GetSubscription(int64_t service_worker_registration_id, GetSubscriptionCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT PushMessagingStubDispatch {
 public:
  static bool Accept(PushMessaging* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PushMessaging* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PushMessaging>>
class PushMessagingStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PushMessagingStub() {}
  ~PushMessagingStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PushMessagingStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PushMessagingStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT PushMessagingRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT PushMessagingResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class BLINK_COMMON_EXPORT PushSubscriptionOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PushSubscriptionOptions, T>::value>;
  using DataView = PushSubscriptionOptionsDataView;
  using Data_ = internal::PushSubscriptionOptions_Data;

  template <typename... Args>
  static PushSubscriptionOptionsPtr New(Args&&... args) {
    return PushSubscriptionOptionsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PushSubscriptionOptionsPtr From(const U& u) {
    return mojo::TypeConverter<PushSubscriptionOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PushSubscriptionOptions>::Convert(*this);
  }


  PushSubscriptionOptions();

  PushSubscriptionOptions(
      bool user_visible_only,
      std::vector<uint8_t> application_server_key);

  ~PushSubscriptionOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PushSubscriptionOptionsPtr>
  PushSubscriptionOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PushSubscriptionOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PushSubscriptionOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PushSubscriptionOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PushSubscriptionOptions_UnserializedMessageContext<
            UserType, PushSubscriptionOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PushSubscriptionOptions::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return PushSubscriptionOptions::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PushSubscriptionOptions_UnserializedMessageContext<
            UserType, PushSubscriptionOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PushSubscriptionOptions::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool user_visible_only;
  
  std::vector<uint8_t> application_server_key;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PushSubscriptionOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PushSubscriptionOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PushSubscriptionOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PushSubscriptionOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT PushSubscription {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PushSubscription, T>::value>;
  using DataView = PushSubscriptionDataView;
  using Data_ = internal::PushSubscription_Data;

  template <typename... Args>
  static PushSubscriptionPtr New(Args&&... args) {
    return PushSubscriptionPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PushSubscriptionPtr From(const U& u) {
    return mojo::TypeConverter<PushSubscriptionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PushSubscription>::Convert(*this);
  }


  PushSubscription();

  PushSubscription(
      const ::GURL& endpoint,
      base::Optional<::base::Time> expirationTime,
      PushSubscriptionOptionsPtr options,
      std::vector<uint8_t> p256dh,
      std::vector<uint8_t> auth);

  ~PushSubscription();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PushSubscriptionPtr>
  PushSubscriptionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PushSubscription::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PushSubscription::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PushSubscription::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PushSubscription_UnserializedMessageContext<
            UserType, PushSubscription::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PushSubscription::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return PushSubscription::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PushSubscription_UnserializedMessageContext<
            UserType, PushSubscription::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PushSubscription::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::GURL endpoint;
  
  base::Optional<::base::Time> expirationTime;
  
  PushSubscriptionOptionsPtr options;
  
  std::vector<uint8_t> p256dh;
  
  std::vector<uint8_t> auth;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(PushSubscription);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PushSubscription::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PushSubscription::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PushSubscription::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PushSubscription::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PushSubscriptionOptionsPtr PushSubscriptionOptions::Clone() const {
  return New(
      mojo::Clone(user_visible_only),
      mojo::Clone(application_server_key)
  );
}

template <typename T, PushSubscriptionOptions::EnableIfSame<T>*>
bool PushSubscriptionOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->user_visible_only, other_struct.user_visible_only))
    return false;
  if (!mojo::Equals(this->application_server_key, other_struct.application_server_key))
    return false;
  return true;
}

template <typename T, PushSubscriptionOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.user_visible_only, rhs.user_visible_only))
    return true;
  if (std::less<>{}(rhs.user_visible_only, lhs.user_visible_only))
    return false;
  if (std::less<>{}(lhs.application_server_key, rhs.application_server_key))
    return true;
  if (std::less<>{}(rhs.application_server_key, lhs.application_server_key))
    return false;
  return false;
}
template <typename StructPtrType>
PushSubscriptionPtr PushSubscription::Clone() const {
  return New(
      mojo::Clone(endpoint),
      mojo::Clone(expirationTime),
      mojo::Clone(options),
      mojo::Clone(p256dh),
      mojo::Clone(auth)
  );
}

template <typename T, PushSubscription::EnableIfSame<T>*>
bool PushSubscription::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->endpoint, other_struct.endpoint))
    return false;
  if (!mojo::Equals(this->expirationTime, other_struct.expirationTime))
    return false;
  if (!mojo::Equals(this->options, other_struct.options))
    return false;
  if (!mojo::Equals(this->p256dh, other_struct.p256dh))
    return false;
  if (!mojo::Equals(this->auth, other_struct.auth))
    return false;
  return true;
}

template <typename T, PushSubscription::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.endpoint, rhs.endpoint))
    return true;
  if (std::less<>{}(rhs.endpoint, lhs.endpoint))
    return false;
  if (std::less<>{}(lhs.expirationTime, rhs.expirationTime))
    return true;
  if (std::less<>{}(rhs.expirationTime, lhs.expirationTime))
    return false;
  if (std::less<>{}(lhs.options, rhs.options))
    return true;
  if (std::less<>{}(rhs.options, lhs.options))
    return false;
  if (std::less<>{}(lhs.p256dh, rhs.p256dh))
    return true;
  if (std::less<>{}(rhs.p256dh, lhs.p256dh))
    return false;
  if (std::less<>{}(lhs.auth, rhs.auth))
    return true;
  if (std::less<>{}(rhs.auth, lhs.auth))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PushSubscriptionOptions::DataView,
                                         ::blink::mojom::PushSubscriptionOptionsPtr> {
  static bool IsNull(const ::blink::mojom::PushSubscriptionOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PushSubscriptionOptionsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::PushSubscriptionOptions::user_visible_only) user_visible_only(
      const ::blink::mojom::PushSubscriptionOptionsPtr& input) {
    return input->user_visible_only;
  }

  static const decltype(::blink::mojom::PushSubscriptionOptions::application_server_key)& application_server_key(
      const ::blink::mojom::PushSubscriptionOptionsPtr& input) {
    return input->application_server_key;
  }

  static bool Read(::blink::mojom::PushSubscriptionOptions::DataView input, ::blink::mojom::PushSubscriptionOptionsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::PushSubscription::DataView,
                                         ::blink::mojom::PushSubscriptionPtr> {
  static bool IsNull(const ::blink::mojom::PushSubscriptionPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::PushSubscriptionPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::PushSubscription::endpoint)& endpoint(
      const ::blink::mojom::PushSubscriptionPtr& input) {
    return input->endpoint;
  }

  static const decltype(::blink::mojom::PushSubscription::expirationTime)& expirationTime(
      const ::blink::mojom::PushSubscriptionPtr& input) {
    return input->expirationTime;
  }

  static const decltype(::blink::mojom::PushSubscription::options)& options(
      const ::blink::mojom::PushSubscriptionPtr& input) {
    return input->options;
  }

  static const decltype(::blink::mojom::PushSubscription::p256dh)& p256dh(
      const ::blink::mojom::PushSubscriptionPtr& input) {
    return input->p256dh;
  }

  static const decltype(::blink::mojom::PushSubscription::auth)& auth(
      const ::blink::mojom::PushSubscriptionPtr& input) {
    return input->auth;
  }

  static bool Read(::blink::mojom::PushSubscription::DataView input, ::blink::mojom::PushSubscriptionPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PUSH_MESSAGING_PUSH_MESSAGING_MOJOM_H_