// third_party/blink/public/mojom/portal/portal.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/portal/portal.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/portal/portal.mojom-params-data.h"
#include "third_party/blink/public/mojom/portal/portal.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/portal/portal.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PORTAL_PORTAL_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PORTAL_PORTAL_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char Portal::Name_[] = "blink.mojom.Portal";

class Portal_Navigate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Portal_Navigate_ForwardToCallback(
      Portal::NavigateCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Portal::NavigateCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Portal_Navigate_ForwardToCallback);
};

class Portal_Activate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Portal_Activate_ForwardToCallback(
      Portal::ActivateCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Portal::ActivateCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Portal_Activate_ForwardToCallback);
};

PortalProxy::PortalProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PortalProxy::Navigate(
    const ::blink::KURL& in_url, ::blink::mojom::blink::ReferrerPtr in_referrer, NavigateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::Portal::Navigate", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::blink::KURL&>"));
      if (in_referrer.is_null()) {
        raw_value->SetString("referrer", "nullptr");
      } else {
        raw_value->BeginDictionary("referrer");
        in_referrer->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPortal_Navigate_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::Portal_Navigate_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in Portal.Navigate request");
  typename decltype(params->referrer)::BaseType::BufferWriter
      referrer_writer;
  mojo::internal::Serialize<::blink::mojom::ReferrerDataView>(
      in_referrer, buffer, &referrer_writer, &serialization_context);
  params->referrer.Set(
      referrer_writer.is_null() ? nullptr : referrer_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->referrer.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null referrer in Portal.Navigate request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Portal::Name_);
  message.set_method_name("Navigate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Portal_Navigate_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PortalProxy::Activate(
    ::blink::BlinkTransferableMessage in_data, ::base::TimeTicks in_activation_time, ActivateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::Portal::Activate", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("data", base::trace_event::ValueToString(in_data, "<value of type ::blink::BlinkTransferableMessage>"));
      raw_value->SetString("activation_time", base::trace_event::ValueToString(in_activation_time, "<value of type ::base::TimeTicks>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPortal_Activate_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::Portal_Activate_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->data)::BaseType::BufferWriter
      data_writer;
  mojo::internal::Serialize<::blink::mojom::TransferableMessageDataView>(
      in_data, buffer, &data_writer, &serialization_context);
  params->data.Set(
      data_writer.is_null() ? nullptr : data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in Portal.Activate request");
  typename decltype(params->activation_time)::BaseType::BufferWriter
      activation_time_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_activation_time, buffer, &activation_time_writer, &serialization_context);
  params->activation_time.Set(
      activation_time_writer.is_null() ? nullptr : activation_time_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->activation_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null activation_time in Portal.Activate request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Portal::Name_);
  message.set_method_name("Activate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Portal_Activate_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void PortalProxy::PostMessageToGuest(
    ::blink::BlinkTransferableMessage in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::Portal::PostMessageToGuest", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("message", base::trace_event::ValueToString(in_message, "<value of type ::blink::BlinkTransferableMessage>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPortal_PostMessageToGuest_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::Portal_PostMessageToGuest_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->message)::BaseType::BufferWriter
      message_writer;
  mojo::internal::Serialize<::blink::mojom::TransferableMessageDataView>(
      in_message, buffer, &message_writer, &serialization_context);
  params->message.Set(
      message_writer.is_null() ? nullptr : message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in Portal.PostMessageToGuest request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Portal::Name_);
  message.set_method_name("PostMessageToGuest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class Portal_Navigate_ProxyToResponder {
 public:
  static Portal::NavigateCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Portal_Navigate_ProxyToResponder> proxy(
        new Portal_Navigate_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Portal_Navigate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Portal_Navigate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Portal_Navigate_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Portal::NavigateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Portal_Navigate_ProxyToResponder);
};

bool Portal_Navigate_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::Portal::NavigateCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::Portal_Navigate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Portal_Navigate_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  Portal_Navigate_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Portal::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void Portal_Navigate_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::Portal::NavigateCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPortal_Navigate_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::Portal_Navigate_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::Portal::NavigateCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Portal::Name_);
  message.set_method_name("Navigate");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Portal_Activate_ProxyToResponder {
 public:
  static Portal::ActivateCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Portal_Activate_ProxyToResponder> proxy(
        new Portal_Activate_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Portal_Activate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Portal_Activate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Portal_Activate_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Portal::ActivateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PortalActivateResult in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Portal_Activate_ProxyToResponder);
};

bool Portal_Activate_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::Portal::ActivateCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::Portal_Activate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Portal_Activate_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  PortalActivateResult p_result{};
  Portal_Activate_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Portal::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void Portal_Activate_ProxyToResponder::Run(
    PortalActivateResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::Portal::ActivateCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPortal_Activate_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::Portal_Activate_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::PortalActivateResult>(
      in_result, &params->result);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::Portal::ActivateCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Portal::Name_);
  message.set_method_name("Activate");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PortalStubDispatch::Accept(
    Portal* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kPortal_Navigate_Name: {
      break;
    }
    case internal::kPortal_Activate_Name: {
      break;
    }
    case internal::kPortal_PostMessageToGuest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Portal::PostMessageToGuest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Portal::PostMessageToGuest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Portal_PostMessageToGuest_Params_Data* params =
          reinterpret_cast<internal::Portal_PostMessageToGuest_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::BlinkTransferableMessage p_message{};
      Portal_PostMessageToGuest_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Portal::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PostMessageToGuest(
std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool PortalStubDispatch::AcceptWithResponder(
    Portal* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPortal_Navigate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Portal::Navigate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Portal::Navigate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Portal_Navigate_Params_Data* params =
          reinterpret_cast<
              internal::Portal_Navigate_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::KURL p_url{};
      ::blink::mojom::blink::ReferrerPtr p_referrer{};
      Portal_Navigate_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadReferrer(&p_referrer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Portal::Name_, 0, false);
        return false;
      }
      Portal::NavigateCallback callback =
          Portal_Navigate_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Navigate(
std::move(p_url), 
std::move(p_referrer), std::move(callback));
      return true;
    }
    case internal::kPortal_Activate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Portal::Activate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Portal::Activate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Portal_Activate_Params_Data* params =
          reinterpret_cast<
              internal::Portal_Activate_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::BlinkTransferableMessage p_data{};
      ::base::TimeTicks p_activation_time{};
      Portal_Activate_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success && !input_data_view.ReadActivationTime(&p_activation_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Portal::Name_, 1, false);
        return false;
      }
      Portal::ActivateCallback callback =
          Portal_Activate_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Activate(
std::move(p_data), 
std::move(p_activation_time), std::move(callback));
      return true;
    }
    case internal::kPortal_PostMessageToGuest_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPortalValidationInfo[] = {
    {internal::kPortal_Navigate_Name,
     {&internal::Portal_Navigate_Params_Data::Validate,
      &internal::Portal_Navigate_ResponseParams_Data::Validate}},
    {internal::kPortal_Activate_Name,
     {&internal::Portal_Activate_Params_Data::Validate,
      &internal::Portal_Activate_ResponseParams_Data::Validate}},
    {internal::kPortal_PostMessageToGuest_Name,
     {&internal::Portal_PostMessageToGuest_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PortalRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::Portal::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPortalValidationInfo);
}

bool PortalResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::Portal::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kPortalValidationInfo);

}
const char PortalClient::Name_[] = "blink.mojom.PortalClient";

PortalClientProxy::PortalClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PortalClientProxy::ForwardMessageFromGuest(
    ::blink::BlinkTransferableMessage in_message, const ::scoped_refptr<const ::blink::SecurityOrigin>& in_source_origin) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PortalClient::ForwardMessageFromGuest", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("message", base::trace_event::ValueToString(in_message, "<value of type ::blink::BlinkTransferableMessage>"));
      raw_value->SetString("source_origin", base::trace_event::ValueToString(in_source_origin, "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPortalClient_ForwardMessageFromGuest_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PortalClient_ForwardMessageFromGuest_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->message)::BaseType::BufferWriter
      message_writer;
  mojo::internal::Serialize<::blink::mojom::TransferableMessageDataView>(
      in_message, buffer, &message_writer, &serialization_context);
  params->message.Set(
      message_writer.is_null() ? nullptr : message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in PortalClient.ForwardMessageFromGuest request");
  typename decltype(params->source_origin)::BaseType::BufferWriter
      source_origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_source_origin, buffer, &source_origin_writer, &serialization_context);
  params->source_origin.Set(
      source_origin_writer.is_null() ? nullptr : source_origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_origin in PortalClient.ForwardMessageFromGuest request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PortalClient::Name_);
  message.set_method_name("ForwardMessageFromGuest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PortalClientProxy::DispatchLoadEvent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::PortalClient::DispatchLoadEvent");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPortalClient_DispatchLoadEvent_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PortalClient_DispatchLoadEvent_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PortalClient::Name_);
  message.set_method_name("DispatchLoadEvent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PortalClientStubDispatch::Accept(
    PortalClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kPortalClient_ForwardMessageFromGuest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PortalClient::ForwardMessageFromGuest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PortalClient::ForwardMessageFromGuest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PortalClient_ForwardMessageFromGuest_Params_Data* params =
          reinterpret_cast<internal::PortalClient_ForwardMessageFromGuest_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::BlinkTransferableMessage p_message{};
      ::scoped_refptr<const ::blink::SecurityOrigin> p_source_origin{};
      PortalClient_ForwardMessageFromGuest_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadSourceOrigin(&p_source_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PortalClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForwardMessageFromGuest(
std::move(p_message), 
std::move(p_source_origin));
      return true;
    }
    case internal::kPortalClient_DispatchLoadEvent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PortalClient::DispatchLoadEvent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PortalClient::DispatchLoadEvent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PortalClient_DispatchLoadEvent_Params_Data* params =
          reinterpret_cast<internal::PortalClient_DispatchLoadEvent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PortalClient_DispatchLoadEvent_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PortalClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DispatchLoadEvent();
      return true;
    }
  }
  return false;
}

// static
bool PortalClientStubDispatch::AcceptWithResponder(
    PortalClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPortalClient_ForwardMessageFromGuest_Name: {
      break;
    }
    case internal::kPortalClient_DispatchLoadEvent_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPortalClientValidationInfo[] = {
    {internal::kPortalClient_ForwardMessageFromGuest_Name,
     {&internal::PortalClient_ForwardMessageFromGuest_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kPortalClient_DispatchLoadEvent_Name,
     {&internal::PortalClient_DispatchLoadEvent_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PortalClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::PortalClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPortalClientValidationInfo);
}

const char PortalHost::Name_[] = "blink.mojom.PortalHost";

PortalHostProxy::PortalHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PortalHostProxy::PostMessageToHost(
    ::blink::BlinkTransferableMessage in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PortalHost::PostMessageToHost", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("message", base::trace_event::ValueToString(in_message, "<value of type ::blink::BlinkTransferableMessage>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPortalHost_PostMessageToHost_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PortalHost_PostMessageToHost_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->message)::BaseType::BufferWriter
      message_writer;
  mojo::internal::Serialize<::blink::mojom::TransferableMessageDataView>(
      in_message, buffer, &message_writer, &serialization_context);
  params->message.Set(
      message_writer.is_null() ? nullptr : message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in PortalHost.PostMessageToHost request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PortalHost::Name_);
  message.set_method_name("PostMessageToHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PortalHostStubDispatch::Accept(
    PortalHost* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kPortalHost_PostMessageToHost_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PortalHost::PostMessageToHost",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PortalHost::PostMessageToHost");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PortalHost_PostMessageToHost_Params_Data* params =
          reinterpret_cast<internal::PortalHost_PostMessageToHost_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::BlinkTransferableMessage p_message{};
      PortalHost_PostMessageToHost_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PortalHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PostMessageToHost(
std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool PortalHostStubDispatch::AcceptWithResponder(
    PortalHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPortalHost_PostMessageToHost_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPortalHostValidationInfo[] = {
    {internal::kPortalHost_PostMessageToHost_Name,
     {&internal::PortalHost_PostMessageToHost_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PortalHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::PortalHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPortalHostValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif