// third_party/blink/public/mojom/picture_in_picture/picture_in_picture.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/picture_in_picture/picture_in_picture.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/picture_in_picture/picture_in_picture.mojom-params-data.h"
#include "third_party/blink/public/mojom/picture_in_picture/picture_in_picture.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/picture_in_picture/picture_in_picture.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PICTURE_IN_PICTURE_PICTURE_IN_PICTURE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PICTURE_IN_PICTURE_PICTURE_IN_PICTURE_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char PictureInPictureSessionObserver::Name_[] = "blink.mojom.PictureInPictureSessionObserver";

PictureInPictureSessionObserverProxy::PictureInPictureSessionObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PictureInPictureSessionObserverProxy::OnWindowSizeChanged(
    const ::gfx::Size& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PictureInPictureSessionObserver::OnWindowSizeChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("size", base::trace_event::ValueToString(in_size, "<value of type const ::gfx::Size&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPictureInPictureSessionObserver_OnWindowSizeChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PictureInPictureSessionObserver_OnWindowSizeChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->size)::BaseType::BufferWriter
      size_writer;
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size, buffer, &size_writer, &serialization_context);
  params->size.Set(
      size_writer.is_null() ? nullptr : size_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size in PictureInPictureSessionObserver.OnWindowSizeChanged request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PictureInPictureSessionObserver::Name_);
  message.set_method_name("OnWindowSizeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PictureInPictureSessionObserverProxy::OnStopped(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::PictureInPictureSessionObserver::OnStopped");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPictureInPictureSessionObserver_OnStopped_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PictureInPictureSessionObserver_OnStopped_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PictureInPictureSessionObserver::Name_);
  message.set_method_name("OnStopped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PictureInPictureSessionObserverStubDispatch::Accept(
    PictureInPictureSessionObserver* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kPictureInPictureSessionObserver_OnWindowSizeChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PictureInPictureSessionObserver::OnWindowSizeChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PictureInPictureSessionObserver::OnWindowSizeChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PictureInPictureSessionObserver_OnWindowSizeChanged_Params_Data* params =
          reinterpret_cast<internal::PictureInPictureSessionObserver_OnWindowSizeChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Size p_size{};
      PictureInPictureSessionObserver_OnWindowSizeChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PictureInPictureSessionObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWindowSizeChanged(
std::move(p_size));
      return true;
    }
    case internal::kPictureInPictureSessionObserver_OnStopped_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PictureInPictureSessionObserver::OnStopped",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PictureInPictureSessionObserver::OnStopped");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PictureInPictureSessionObserver_OnStopped_Params_Data* params =
          reinterpret_cast<internal::PictureInPictureSessionObserver_OnStopped_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PictureInPictureSessionObserver_OnStopped_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PictureInPictureSessionObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStopped();
      return true;
    }
  }
  return false;
}

// static
bool PictureInPictureSessionObserverStubDispatch::AcceptWithResponder(
    PictureInPictureSessionObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPictureInPictureSessionObserver_OnWindowSizeChanged_Name: {
      break;
    }
    case internal::kPictureInPictureSessionObserver_OnStopped_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPictureInPictureSessionObserverValidationInfo[] = {
    {&internal::PictureInPictureSessionObserver_OnWindowSizeChanged_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PictureInPictureSessionObserver_OnStopped_Params_Data::Validate,
     nullptr /* no response */},
};

bool PictureInPictureSessionObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::PictureInPictureSessionObserver::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPictureInPictureSessionObserverValidationInfo);
}

const char PictureInPictureSession::Name_[] = "blink.mojom.PictureInPictureSession";

class PictureInPictureSession_Stop_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PictureInPictureSession_Stop_ForwardToCallback(
      PictureInPictureSession::StopCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PictureInPictureSession::StopCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PictureInPictureSession_Stop_ForwardToCallback);
};

PictureInPictureSessionProxy::PictureInPictureSessionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PictureInPictureSessionProxy::Update(
    uint32_t in_player_id, const base::Optional<::viz::SurfaceId>& in_surface_id, const ::gfx::Size& in_natural_size, bool in_show_play_pause_button) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PictureInPictureSession::Update", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("player_id", base::NumberToString(in_player_id));
      raw_value->SetString("surface_id", base::trace_event::ValueToString(in_surface_id, "<value of type const base::Optional<::viz::SurfaceId>&>"));
      raw_value->SetString("natural_size", base::trace_event::ValueToString(in_natural_size, "<value of type const ::gfx::Size&>"));
      raw_value->SetBoolean("show_play_pause_button", in_show_play_pause_button);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPictureInPictureSession_Update_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PictureInPictureSession_Update_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->player_id = in_player_id;
  typename decltype(params->surface_id)::BaseType::BufferWriter
      surface_id_writer;
  mojo::internal::Serialize<::viz::mojom::SurfaceIdDataView>(
      in_surface_id, buffer, &surface_id_writer, &serialization_context);
  params->surface_id.Set(
      surface_id_writer.is_null() ? nullptr : surface_id_writer.data());
  typename decltype(params->natural_size)::BaseType::BufferWriter
      natural_size_writer;
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_natural_size, buffer, &natural_size_writer, &serialization_context);
  params->natural_size.Set(
      natural_size_writer.is_null() ? nullptr : natural_size_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->natural_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null natural_size in PictureInPictureSession.Update request");
  params->show_play_pause_button = in_show_play_pause_button;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PictureInPictureSession::Name_);
  message.set_method_name("Update");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PictureInPictureSessionProxy::Stop(
    StopCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::PictureInPictureSession::Stop");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPictureInPictureSession_Stop_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PictureInPictureSession_Stop_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PictureInPictureSession::Name_);
  message.set_method_name("Stop");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PictureInPictureSession_Stop_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class PictureInPictureSession_Stop_ProxyToResponder {
 public:
  static PictureInPictureSession::StopCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PictureInPictureSession_Stop_ProxyToResponder> proxy(
        new PictureInPictureSession_Stop_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PictureInPictureSession_Stop_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PictureInPictureSession_Stop_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PictureInPictureSession_Stop_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PictureInPictureSession::StopCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PictureInPictureSession_Stop_ProxyToResponder);
};

bool PictureInPictureSession_Stop_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::PictureInPictureSession::StopCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::PictureInPictureSession_Stop_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PictureInPictureSession_Stop_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  PictureInPictureSession_Stop_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PictureInPictureSession::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void PictureInPictureSession_Stop_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::PictureInPictureSession::StopCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPictureInPictureSession_Stop_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PictureInPictureSession_Stop_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::PictureInPictureSession::StopCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PictureInPictureSession::Name_);
  message.set_method_name("Stop");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PictureInPictureSessionStubDispatch::Accept(
    PictureInPictureSession* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kPictureInPictureSession_Update_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PictureInPictureSession::Update",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PictureInPictureSession::Update");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PictureInPictureSession_Update_Params_Data* params =
          reinterpret_cast<internal::PictureInPictureSession_Update_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_player_id{};
      base::Optional<::viz::SurfaceId> p_surface_id{};
      ::gfx::Size p_natural_size{};
      bool p_show_play_pause_button{};
      PictureInPictureSession_Update_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_player_id = input_data_view.player_id();
      if (success && !input_data_view.ReadSurfaceId(&p_surface_id))
        success = false;
      if (success && !input_data_view.ReadNaturalSize(&p_natural_size))
        success = false;
      if (success)
        p_show_play_pause_button = input_data_view.show_play_pause_button();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PictureInPictureSession::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Update(
std::move(p_player_id), 
std::move(p_surface_id), 
std::move(p_natural_size), 
std::move(p_show_play_pause_button));
      return true;
    }
    case internal::kPictureInPictureSession_Stop_Name: {
      break;
    }
  }
  return false;
}

// static
bool PictureInPictureSessionStubDispatch::AcceptWithResponder(
    PictureInPictureSession* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPictureInPictureSession_Update_Name: {
      break;
    }
    case internal::kPictureInPictureSession_Stop_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PictureInPictureSession::Stop",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PictureInPictureSession::Stop");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PictureInPictureSession_Stop_Params_Data* params =
          reinterpret_cast<
              internal::PictureInPictureSession_Stop_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      PictureInPictureSession_Stop_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PictureInPictureSession::Name_, 1, false);
        return false;
      }
      PictureInPictureSession::StopCallback callback =
          PictureInPictureSession_Stop_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPictureInPictureSessionValidationInfo[] = {
    {&internal::PictureInPictureSession_Update_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PictureInPictureSession_Stop_Params_Data::Validate,
     &internal::PictureInPictureSession_Stop_ResponseParams_Data::Validate},
};

bool PictureInPictureSessionRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::PictureInPictureSession::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPictureInPictureSessionValidationInfo);
}

bool PictureInPictureSessionResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::PictureInPictureSession::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kPictureInPictureSessionValidationInfo);
}
const char PictureInPictureService::Name_[] = "blink.mojom.PictureInPictureService";

class PictureInPictureService_StartSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PictureInPictureService_StartSession_ForwardToCallback(
      PictureInPictureService::StartSessionCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  PictureInPictureService::StartSessionCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(PictureInPictureService_StartSession_ForwardToCallback);
};

PictureInPictureServiceProxy::PictureInPictureServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PictureInPictureServiceProxy::StartSession(
    uint32_t in_player_id, const base::Optional<::viz::SurfaceId>& in_surface_id, const ::gfx::Size& in_natural_size, bool in_show_play_pause_button, ::mojo::PendingRemote<PictureInPictureSessionObserver> in_observer, StartSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PictureInPictureService::StartSession", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("player_id", base::NumberToString(in_player_id));
      raw_value->SetString("surface_id", base::trace_event::ValueToString(in_surface_id, "<value of type const base::Optional<::viz::SurfaceId>&>"));
      raw_value->SetString("natural_size", base::trace_event::ValueToString(in_natural_size, "<value of type const ::gfx::Size&>"));
      raw_value->SetBoolean("show_play_pause_button", in_show_play_pause_button);
      raw_value->SetBoolean("observer", in_observer.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPictureInPictureService_StartSession_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PictureInPictureService_StartSession_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->player_id = in_player_id;
  typename decltype(params->surface_id)::BaseType::BufferWriter
      surface_id_writer;
  mojo::internal::Serialize<::viz::mojom::SurfaceIdDataView>(
      in_surface_id, buffer, &surface_id_writer, &serialization_context);
  params->surface_id.Set(
      surface_id_writer.is_null() ? nullptr : surface_id_writer.data());
  typename decltype(params->natural_size)::BaseType::BufferWriter
      natural_size_writer;
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_natural_size, buffer, &natural_size_writer, &serialization_context);
  params->natural_size.Set(
      natural_size_writer.is_null() ? nullptr : natural_size_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->natural_size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null natural_size in PictureInPictureService.StartSession request");
  params->show_play_pause_button = in_show_play_pause_button;
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PictureInPictureSessionObserverInterfaceBase>>(
      in_observer, &params->observer, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in PictureInPictureService.StartSession request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PictureInPictureService::Name_);
  message.set_method_name("StartSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PictureInPictureService_StartSession_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class PictureInPictureService_StartSession_ProxyToResponder {
 public:
  static PictureInPictureService::StartSessionCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<PictureInPictureService_StartSession_ProxyToResponder> proxy(
        new PictureInPictureService_StartSession_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&PictureInPictureService_StartSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PictureInPictureService_StartSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  PictureInPictureService_StartSession_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PictureInPictureService::StartSessionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<PictureInPictureSession> in_session, const ::gfx::Size& in_size);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(PictureInPictureService_StartSession_ProxyToResponder);
};

bool PictureInPictureService_StartSession_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::PictureInPictureService::StartSessionCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::PictureInPictureService_StartSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PictureInPictureService_StartSession_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::mojo::PendingRemote<PictureInPictureSession> p_session{};
  ::gfx::Size p_size{};
  PictureInPictureService_StartSession_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success) {
    p_session =
        input_data_view.TakeSession<decltype(p_session)>();
  }
  if (success && !input_data_view.ReadSize(&p_size))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PictureInPictureService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_session), 
std::move(p_size));
  return true;
}

void PictureInPictureService_StartSession_ProxyToResponder::Run(
    ::mojo::PendingRemote<PictureInPictureSession> in_session, const ::gfx::Size& in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::PictureInPictureService::StartSessionCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("session", in_session.is_valid());
      raw_value->SetString("size", base::trace_event::ValueToString(in_size, "<value of type const ::gfx::Size&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPictureInPictureService_StartSession_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PictureInPictureService_StartSession_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PictureInPictureSessionInterfaceBase>>(
      in_session, &params->session, &serialization_context);
  typename decltype(params->size)::BaseType::BufferWriter
      size_writer;
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size, buffer, &size_writer, &serialization_context);
  params->size.Set(
      size_writer.is_null() ? nullptr : size_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::PictureInPictureService::StartSessionCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PictureInPictureService::Name_);
  message.set_method_name("StartSession");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PictureInPictureServiceStubDispatch::Accept(
    PictureInPictureService* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kPictureInPictureService_StartSession_Name: {
      break;
    }
  }
  return false;
}

// static
bool PictureInPictureServiceStubDispatch::AcceptWithResponder(
    PictureInPictureService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPictureInPictureService_StartSession_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PictureInPictureService::StartSession",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PictureInPictureService::StartSession");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::PictureInPictureService_StartSession_Params_Data* params =
          reinterpret_cast<
              internal::PictureInPictureService_StartSession_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint32_t p_player_id{};
      base::Optional<::viz::SurfaceId> p_surface_id{};
      ::gfx::Size p_natural_size{};
      bool p_show_play_pause_button{};
      ::mojo::PendingRemote<PictureInPictureSessionObserver> p_observer{};
      PictureInPictureService_StartSession_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_player_id = input_data_view.player_id();
      if (success && !input_data_view.ReadSurfaceId(&p_surface_id))
        success = false;
      if (success && !input_data_view.ReadNaturalSize(&p_natural_size))
        success = false;
      if (success)
        p_show_play_pause_button = input_data_view.show_play_pause_button();
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PictureInPictureService::Name_, 0, false);
        return false;
      }
      PictureInPictureService::StartSessionCallback callback =
          PictureInPictureService_StartSession_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartSession(
std::move(p_player_id), 
std::move(p_surface_id), 
std::move(p_natural_size), 
std::move(p_show_play_pause_button), 
std::move(p_observer), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPictureInPictureServiceValidationInfo[] = {
    {&internal::PictureInPictureService_StartSession_Params_Data::Validate,
     &internal::PictureInPictureService_StartSession_ResponseParams_Data::Validate},
};

bool PictureInPictureServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::PictureInPictureService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPictureInPictureServiceValidationInfo);
}

bool PictureInPictureServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::PictureInPictureService::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kPictureInPictureServiceValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif