// third_party/blink/public/mojom/payments/payment_request.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/payments/payment_request.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/payments/payment_request.mojom-params-data.h"
#include "third_party/blink/public/mojom/payments/payment_request.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/payments/payment_request.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_REQUEST_MOJOM_JUMBO_H_
#endif
namespace payments {
namespace mojom {
PaymentResponse::PaymentResponse()
    : method_name(),
      stringified_details(),
      shipping_address(),
      shipping_option(),
      payer() {}

PaymentResponse::PaymentResponse(
    const std::string& method_name_in,
    const std::string& stringified_details_in,
    ::payments::mojom::PaymentAddressPtr shipping_address_in,
    const base::Optional<std::string>& shipping_option_in,
    PayerDetailPtr payer_in)
    : method_name(std::move(method_name_in)),
      stringified_details(std::move(stringified_details_in)),
      shipping_address(std::move(shipping_address_in)),
      shipping_option(std::move(shipping_option_in)),
      payer(std::move(payer_in)) {}

PaymentResponse::~PaymentResponse() = default;

void PaymentResponse::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("method_name", this->method_name);
  value->SetString("stringified_details", this->stringified_details);
  if (this->shipping_address.is_null()) {
    value->SetString("shipping_address", "nullptr");
  } else {
    value->BeginDictionary("shipping_address");
    this->shipping_address->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->shipping_option.has_value()) {
    value->SetString("shipping_option", this->shipping_option.value());
  } else {
    value->SetString("shipping_option", "base::nullopt");
  }
  if (this->payer.is_null()) {
    value->SetString("payer", "nullptr");
  } else {
    value->BeginDictionary("payer");
    this->payer->AsValueInto(value);
    value->EndDictionary();
  }
}

bool PaymentResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PayerDetail::PayerDetail()
    : email(),
      name(),
      phone() {}

PayerDetail::PayerDetail(
    const base::Optional<std::string>& email_in,
    const base::Optional<std::string>& name_in,
    const base::Optional<std::string>& phone_in)
    : email(std::move(email_in)),
      name(std::move(name_in)),
      phone(std::move(phone_in)) {}

PayerDetail::~PayerDetail() = default;

void PayerDetail::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->email.has_value()) {
    value->SetString("email", this->email.value());
  } else {
    value->SetString("email", "base::nullopt");
  }
  if (this->name.has_value()) {
    value->SetString("name", this->name.value());
  } else {
    value->SetString("name", "base::nullopt");
  }
  if (this->phone.has_value()) {
    value->SetString("phone", this->phone.value());
  } else {
    value->SetString("phone", "base::nullopt");
  }
}

bool PayerDetail::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentItem::PaymentItem()
    : label(),
      amount(),
      pending() {}

PaymentItem::PaymentItem(
    const std::string& label_in,
    ::payments::mojom::PaymentCurrencyAmountPtr amount_in,
    bool pending_in)
    : label(std::move(label_in)),
      amount(std::move(amount_in)),
      pending(std::move(pending_in)) {}

PaymentItem::~PaymentItem() = default;
size_t PaymentItem::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->label);
  seed = mojo::internal::Hash(seed, this->amount);
  seed = mojo::internal::Hash(seed, this->pending);
  return seed;
}

void PaymentItem::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("label", this->label);
  if (this->amount.is_null()) {
    value->SetString("amount", "nullptr");
  } else {
    value->BeginDictionary("amount");
    this->amount->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetBoolean("pending", this->pending);
}

bool PaymentItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentShippingOption::PaymentShippingOption()
    : id(),
      label(),
      amount(),
      selected() {}

PaymentShippingOption::PaymentShippingOption(
    const std::string& id_in,
    const std::string& label_in,
    ::payments::mojom::PaymentCurrencyAmountPtr amount_in,
    bool selected_in)
    : id(std::move(id_in)),
      label(std::move(label_in)),
      amount(std::move(amount_in)),
      selected(std::move(selected_in)) {}

PaymentShippingOption::~PaymentShippingOption() = default;
size_t PaymentShippingOption::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  seed = mojo::internal::Hash(seed, this->label);
  seed = mojo::internal::Hash(seed, this->amount);
  seed = mojo::internal::Hash(seed, this->selected);
  return seed;
}

void PaymentShippingOption::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("id", this->id);
  value->SetString("label", this->label);
  if (this->amount.is_null()) {
    value->SetString("amount", "nullptr");
  } else {
    value->BeginDictionary("amount");
    this->amount->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetBoolean("selected", this->selected);
}

bool PaymentShippingOption::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GooglePaymentMethodData::GooglePaymentMethodData()
    : stringified_data(),
      phone_requested(),
      name_requested(),
      email_requested(),
      shipping_requested() {}

GooglePaymentMethodData::GooglePaymentMethodData(
    const std::string& stringified_data_in,
    bool phone_requested_in,
    bool name_requested_in,
    bool email_requested_in,
    bool shipping_requested_in)
    : stringified_data(std::move(stringified_data_in)),
      phone_requested(std::move(phone_requested_in)),
      name_requested(std::move(name_requested_in)),
      email_requested(std::move(email_requested_in)),
      shipping_requested(std::move(shipping_requested_in)) {}

GooglePaymentMethodData::~GooglePaymentMethodData() = default;
size_t GooglePaymentMethodData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->stringified_data);
  seed = mojo::internal::Hash(seed, this->phone_requested);
  seed = mojo::internal::Hash(seed, this->name_requested);
  seed = mojo::internal::Hash(seed, this->email_requested);
  seed = mojo::internal::Hash(seed, this->shipping_requested);
  return seed;
}

void GooglePaymentMethodData::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("stringified_data", this->stringified_data);
  value->SetBoolean("phone_requested", this->phone_requested);
  value->SetBoolean("name_requested", this->name_requested);
  value->SetBoolean("email_requested", this->email_requested);
  value->SetBoolean("shipping_requested", this->shipping_requested);
}

bool GooglePaymentMethodData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SecurePaymentConfirmationRequest::SecurePaymentConfirmationRequest()
    : credential_ids(),
      network_data(),
      timeout() {}

SecurePaymentConfirmationRequest::SecurePaymentConfirmationRequest(
    std::vector<std::vector<uint8_t>> credential_ids_in,
    std::vector<uint8_t> network_data_in,
    base::Optional<::base::TimeDelta> timeout_in)
    : credential_ids(std::move(credential_ids_in)),
      network_data(std::move(network_data_in)),
      timeout(std::move(timeout_in)) {}

SecurePaymentConfirmationRequest::~SecurePaymentConfirmationRequest() = default;

void SecurePaymentConfirmationRequest::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("credential_ids");
  for (const auto& item0 : this->credential_ids) {
    value->BeginArray();
    for (const auto& item1 : item0) {
      value->AppendInteger(item1);
    }
    value->EndArray();
  }
  value->EndArray();
  value->BeginArray("network_data");
  for (const auto& item0 : this->network_data) {
    value->AppendInteger(item0);
  }
  value->EndArray();
  value->SetString("timeout", base::trace_event::ValueToString(this->timeout, "<value of type base::Optional<::base::TimeDelta>>"));
}

bool SecurePaymentConfirmationRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentMethodData::PaymentMethodData()
    : supported_method(),
      stringified_data(),
      environment(),
      min_google_play_services_version(),
      api_version(),
      supported_networks(),
      secure_payment_confirmation() {}

PaymentMethodData::PaymentMethodData(
    const std::string& supported_method_in,
    const std::string& stringified_data_in,
    AndroidPayEnvironment environment_in,
    int32_t min_google_play_services_version_in,
    int32_t api_version_in,
    std::vector<BasicCardNetwork> supported_networks_in,
    SecurePaymentConfirmationRequestPtr secure_payment_confirmation_in)
    : supported_method(std::move(supported_method_in)),
      stringified_data(std::move(stringified_data_in)),
      environment(std::move(environment_in)),
      min_google_play_services_version(std::move(min_google_play_services_version_in)),
      api_version(std::move(api_version_in)),
      supported_networks(std::move(supported_networks_in)),
      secure_payment_confirmation(std::move(secure_payment_confirmation_in)) {}

PaymentMethodData::~PaymentMethodData() = default;

void PaymentMethodData::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("supported_method", this->supported_method);
  value->SetString("stringified_data", this->stringified_data);
  value->SetString("environment", base::trace_event::ValueToString(this->environment));
  value->SetInteger("min_google_play_services_version", this->min_google_play_services_version);
  value->SetInteger("api_version", this->api_version);
  value->BeginArray("supported_networks");
  for (const auto& item0 : this->supported_networks) {
    value->AppendString(base::trace_event::ValueToString(item0));
  }
  value->EndArray();
  if (this->secure_payment_confirmation.is_null()) {
    value->SetString("secure_payment_confirmation", "nullptr");
  } else {
    value->BeginDictionary("secure_payment_confirmation");
    this->secure_payment_confirmation->AsValueInto(value);
    value->EndDictionary();
  }
}

bool PaymentMethodData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentDetailsModifier::PaymentDetailsModifier()
    : total(),
      additional_display_items(),
      method_data() {}

PaymentDetailsModifier::PaymentDetailsModifier(
    PaymentItemPtr total_in,
    std::vector<PaymentItemPtr> additional_display_items_in,
    PaymentMethodDataPtr method_data_in)
    : total(std::move(total_in)),
      additional_display_items(std::move(additional_display_items_in)),
      method_data(std::move(method_data_in)) {}

PaymentDetailsModifier::~PaymentDetailsModifier() = default;

void PaymentDetailsModifier::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->total.is_null()) {
    value->SetString("total", "nullptr");
  } else {
    value->BeginDictionary("total");
    this->total->AsValueInto(value);
    value->EndDictionary();
  }
  value->BeginArray("additional_display_items");
  for (const auto& item0 : this->additional_display_items) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
  if (this->method_data.is_null()) {
    value->SetString("method_data", "nullptr");
  } else {
    value->BeginDictionary("method_data");
    this->method_data->AsValueInto(value);
    value->EndDictionary();
  }
}

bool PaymentDetailsModifier::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentDetails::PaymentDetails()
    : total(),
      display_items(),
      shipping_options(),
      modifiers(),
      error(""),
      shipping_address_errors(),
      id(),
      stringified_payment_method_errors() {}

PaymentDetails::PaymentDetails(
    PaymentItemPtr total_in,
    base::Optional<std::vector<PaymentItemPtr>> display_items_in,
    base::Optional<std::vector<PaymentShippingOptionPtr>> shipping_options_in,
    base::Optional<std::vector<PaymentDetailsModifierPtr>> modifiers_in,
    const std::string& error_in,
    ::payments::mojom::AddressErrorsPtr shipping_address_errors_in,
    const base::Optional<std::string>& id_in,
    const base::Optional<std::string>& stringified_payment_method_errors_in)
    : total(std::move(total_in)),
      display_items(std::move(display_items_in)),
      shipping_options(std::move(shipping_options_in)),
      modifiers(std::move(modifiers_in)),
      error(std::move(error_in)),
      shipping_address_errors(std::move(shipping_address_errors_in)),
      id(std::move(id_in)),
      stringified_payment_method_errors(std::move(stringified_payment_method_errors_in)) {}

PaymentDetails::~PaymentDetails() = default;

void PaymentDetails::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->total.is_null()) {
    value->SetString("total", "nullptr");
  } else {
    value->BeginDictionary("total");
    this->total->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->display_items.has_value()) {
    value->BeginArray("display_items");
    for (const auto& item0 : this->display_items.value()) {
      if (item0.is_null()) {
        value->AppendString("nullptr");
      } else {
        value->BeginDictionary();
        item0->AsValueInto(value);
        value->EndDictionary();
      }
    }
    value->EndArray();
  } else {
    value->SetString("display_items", "base::nullopt");
  }
  if (this->shipping_options.has_value()) {
    value->BeginArray("shipping_options");
    for (const auto& item0 : this->shipping_options.value()) {
      if (item0.is_null()) {
        value->AppendString("nullptr");
      } else {
        value->BeginDictionary();
        item0->AsValueInto(value);
        value->EndDictionary();
      }
    }
    value->EndArray();
  } else {
    value->SetString("shipping_options", "base::nullopt");
  }
  if (this->modifiers.has_value()) {
    value->BeginArray("modifiers");
    for (const auto& item0 : this->modifiers.value()) {
      if (item0.is_null()) {
        value->AppendString("nullptr");
      } else {
        value->BeginDictionary();
        item0->AsValueInto(value);
        value->EndDictionary();
      }
    }
    value->EndArray();
  } else {
    value->SetString("modifiers", "base::nullopt");
  }
  value->SetString("error", this->error);
  if (this->shipping_address_errors.is_null()) {
    value->SetString("shipping_address_errors", "nullptr");
  } else {
    value->BeginDictionary("shipping_address_errors");
    this->shipping_address_errors->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->id.has_value()) {
    value->SetString("id", this->id.value());
  } else {
    value->SetString("id", "base::nullopt");
  }
  if (this->stringified_payment_method_errors.has_value()) {
    value->SetString("stringified_payment_method_errors", this->stringified_payment_method_errors.value());
  } else {
    value->SetString("stringified_payment_method_errors", "base::nullopt");
  }
}

bool PaymentDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentOptions::PaymentOptions()
    : request_payer_name(),
      request_payer_email(),
      request_payer_phone(),
      request_shipping(),
      shipping_type() {}

PaymentOptions::PaymentOptions(
    bool request_payer_name_in,
    bool request_payer_email_in,
    bool request_payer_phone_in,
    bool request_shipping_in,
    PaymentShippingType shipping_type_in)
    : request_payer_name(std::move(request_payer_name_in)),
      request_payer_email(std::move(request_payer_email_in)),
      request_payer_phone(std::move(request_payer_phone_in)),
      request_shipping(std::move(request_shipping_in)),
      shipping_type(std::move(shipping_type_in)) {}

PaymentOptions::~PaymentOptions() = default;
size_t PaymentOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->request_payer_name);
  seed = mojo::internal::Hash(seed, this->request_payer_email);
  seed = mojo::internal::Hash(seed, this->request_payer_phone);
  seed = mojo::internal::Hash(seed, this->request_shipping);
  seed = mojo::internal::Hash(seed, this->shipping_type);
  return seed;
}

void PaymentOptions::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("request_payer_name", this->request_payer_name);
  value->SetBoolean("request_payer_email", this->request_payer_email);
  value->SetBoolean("request_payer_phone", this->request_payer_phone);
  value->SetBoolean("request_shipping", this->request_shipping);
  value->SetString("shipping_type", base::trace_event::ValueToString(this->shipping_type));
}

bool PaymentOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char PaymentRequestClient::Name_[] = "payments.mojom.PaymentRequestClient";

PaymentRequestClientProxy::PaymentRequestClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PaymentRequestClientProxy::OnPaymentMethodChange(
    const std::string& in_method_name, const std::string& in_stringified_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequestClient::OnPaymentMethodChange", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("method_name", in_method_name);
      raw_value->SetString("stringified_details", in_stringified_details);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_OnPaymentMethodChange_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentRequestClient_OnPaymentMethodChange_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->method_name)::BaseType::BufferWriter
      method_name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_method_name, buffer, &method_name_writer, &serialization_context);
  params->method_name.Set(
      method_name_writer.is_null() ? nullptr : method_name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->method_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method_name in PaymentRequestClient.OnPaymentMethodChange request");
  typename decltype(params->stringified_details)::BaseType::BufferWriter
      stringified_details_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_stringified_details, buffer, &stringified_details_writer, &serialization_context);
  params->stringified_details.Set(
      stringified_details_writer.is_null() ? nullptr : stringified_details_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->stringified_details.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null stringified_details in PaymentRequestClient.OnPaymentMethodChange request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnPaymentMethodChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestClientProxy::OnShippingAddressChange(
    ::payments::mojom::PaymentAddressPtr in_address) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequestClient::OnShippingAddressChange", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_address.is_null()) {
        raw_value->SetString("address", "nullptr");
      } else {
        raw_value->BeginDictionary("address");
        in_address->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_OnShippingAddressChange_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentRequestClient_OnShippingAddressChange_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->address)::BaseType::BufferWriter
      address_writer;
  mojo::internal::Serialize<::payments::mojom::PaymentAddressDataView>(
      in_address, buffer, &address_writer, &serialization_context);
  params->address.Set(
      address_writer.is_null() ? nullptr : address_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->address.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null address in PaymentRequestClient.OnShippingAddressChange request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnShippingAddressChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestClientProxy::OnShippingOptionChange(
    const std::string& in_shipping_option_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequestClient::OnShippingOptionChange", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("shipping_option_id", in_shipping_option_id);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_OnShippingOptionChange_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentRequestClient_OnShippingOptionChange_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->shipping_option_id)::BaseType::BufferWriter
      shipping_option_id_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_shipping_option_id, buffer, &shipping_option_id_writer, &serialization_context);
  params->shipping_option_id.Set(
      shipping_option_id_writer.is_null() ? nullptr : shipping_option_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->shipping_option_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shipping_option_id in PaymentRequestClient.OnShippingOptionChange request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnShippingOptionChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestClientProxy::OnPayerDetailChange(
    PayerDetailPtr in_detail) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequestClient::OnPayerDetailChange", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_detail.is_null()) {
        raw_value->SetString("detail", "nullptr");
      } else {
        raw_value->BeginDictionary("detail");
        in_detail->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_OnPayerDetailChange_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentRequestClient_OnPayerDetailChange_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->detail)::BaseType::BufferWriter
      detail_writer;
  mojo::internal::Serialize<::payments::mojom::PayerDetailDataView>(
      in_detail, buffer, &detail_writer, &serialization_context);
  params->detail.Set(
      detail_writer.is_null() ? nullptr : detail_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->detail.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null detail in PaymentRequestClient.OnPayerDetailChange request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnPayerDetailChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestClientProxy::OnPaymentResponse(
    PaymentResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequestClient::OnPaymentResponse", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_response.is_null()) {
        raw_value->SetString("response", "nullptr");
      } else {
        raw_value->BeginDictionary("response");
        in_response->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_OnPaymentResponse_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentRequestClient_OnPaymentResponse_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->response)::BaseType::BufferWriter
      response_writer;
  mojo::internal::Serialize<::payments::mojom::PaymentResponseDataView>(
      in_response, buffer, &response_writer, &serialization_context);
  params->response.Set(
      response_writer.is_null() ? nullptr : response_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->response.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null response in PaymentRequestClient.OnPaymentResponse request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnPaymentResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestClientProxy::OnError(
    PaymentErrorReason in_error, const std::string& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequestClient::OnError", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("error", base::trace_event::ValueToString(in_error));
      raw_value->SetString("error_message", in_error_message);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_OnError_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentRequestClient_OnError_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::payments::mojom::PaymentErrorReason>(
      in_error, &params->error);
  typename decltype(params->error_message)::BaseType::BufferWriter
      error_message_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_error_message, buffer, &error_message_writer, &serialization_context);
  params->error_message.Set(
      error_message_writer.is_null() ? nullptr : error_message_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->error_message.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in PaymentRequestClient.OnError request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestClientProxy::OnComplete(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "payments::mojom::PaymentRequestClient::OnComplete");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_OnComplete_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentRequestClient_OnComplete_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestClientProxy::OnAbort(
    bool in_aborted_successfully) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequestClient::OnAbort", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("aborted_successfully", in_aborted_successfully);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_OnAbort_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentRequestClient_OnAbort_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->aborted_successfully = in_aborted_successfully;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnAbort");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestClientProxy::OnCanMakePayment(
    CanMakePaymentQueryResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequestClient::OnCanMakePayment", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_OnCanMakePayment_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentRequestClient_OnCanMakePayment_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::payments::mojom::CanMakePaymentQueryResult>(
      in_result, &params->result);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnCanMakePayment");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestClientProxy::OnHasEnrolledInstrument(
    HasEnrolledInstrumentQueryResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequestClient::OnHasEnrolledInstrument", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_OnHasEnrolledInstrument_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentRequestClient_OnHasEnrolledInstrument_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::payments::mojom::HasEnrolledInstrumentQueryResult>(
      in_result, &params->result);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("OnHasEnrolledInstrument");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestClientProxy::WarnNoFavicon(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "payments::mojom::PaymentRequestClient::WarnNoFavicon");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequestClient_WarnNoFavicon_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentRequestClient_WarnNoFavicon_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequestClient::Name_);
  message.set_method_name("WarnNoFavicon");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PaymentRequestClientStubDispatch::Accept(
    PaymentRequestClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kPaymentRequestClient_OnPaymentMethodChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::OnPaymentMethodChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::OnPaymentMethodChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnPaymentMethodChange_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnPaymentMethodChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_method_name{};
      std::string p_stringified_details{};
      PaymentRequestClient_OnPaymentMethodChange_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadMethodName(&p_method_name))
        success = false;
      if (success && !input_data_view.ReadStringifiedDetails(&p_stringified_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPaymentMethodChange(
std::move(p_method_name), 
std::move(p_stringified_details));
      return true;
    }
    case internal::kPaymentRequestClient_OnShippingAddressChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::OnShippingAddressChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::OnShippingAddressChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnShippingAddressChange_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnShippingAddressChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::payments::mojom::PaymentAddressPtr p_address{};
      PaymentRequestClient_OnShippingAddressChange_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadAddress(&p_address))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnShippingAddressChange(
std::move(p_address));
      return true;
    }
    case internal::kPaymentRequestClient_OnShippingOptionChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::OnShippingOptionChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::OnShippingOptionChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnShippingOptionChange_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnShippingOptionChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_shipping_option_id{};
      PaymentRequestClient_OnShippingOptionChange_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadShippingOptionId(&p_shipping_option_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnShippingOptionChange(
std::move(p_shipping_option_id));
      return true;
    }
    case internal::kPaymentRequestClient_OnPayerDetailChange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::OnPayerDetailChange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::OnPayerDetailChange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnPayerDetailChange_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnPayerDetailChange_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PayerDetailPtr p_detail{};
      PaymentRequestClient_OnPayerDetailChange_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDetail(&p_detail))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPayerDetailChange(
std::move(p_detail));
      return true;
    }
    case internal::kPaymentRequestClient_OnPaymentResponse_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::OnPaymentResponse",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::OnPaymentResponse");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnPaymentResponse_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnPaymentResponse_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PaymentResponsePtr p_response{};
      PaymentRequestClient_OnPaymentResponse_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadResponse(&p_response))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPaymentResponse(
std::move(p_response));
      return true;
    }
    case internal::kPaymentRequestClient_OnError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::OnError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::OnError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnError_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnError_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PaymentErrorReason p_error{};
      std::string p_error_message{};
      PaymentRequestClient_OnError_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (success && !input_data_view.ReadErrorMessage(&p_error_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(
std::move(p_error), 
std::move(p_error_message));
      return true;
    }
    case internal::kPaymentRequestClient_OnComplete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::OnComplete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::OnComplete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnComplete_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnComplete_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PaymentRequestClient_OnComplete_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnComplete();
      return true;
    }
    case internal::kPaymentRequestClient_OnAbort_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::OnAbort",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::OnAbort");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnAbort_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnAbort_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_aborted_successfully{};
      PaymentRequestClient_OnAbort_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_aborted_successfully = input_data_view.aborted_successfully();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAbort(
std::move(p_aborted_successfully));
      return true;
    }
    case internal::kPaymentRequestClient_OnCanMakePayment_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::OnCanMakePayment",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::OnCanMakePayment");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnCanMakePayment_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnCanMakePayment_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CanMakePaymentQueryResult p_result{};
      PaymentRequestClient_OnCanMakePayment_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCanMakePayment(
std::move(p_result));
      return true;
    }
    case internal::kPaymentRequestClient_OnHasEnrolledInstrument_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::OnHasEnrolledInstrument",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::OnHasEnrolledInstrument");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_OnHasEnrolledInstrument_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_OnHasEnrolledInstrument_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      HasEnrolledInstrumentQueryResult p_result{};
      PaymentRequestClient_OnHasEnrolledInstrument_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHasEnrolledInstrument(
std::move(p_result));
      return true;
    }
    case internal::kPaymentRequestClient_WarnNoFavicon_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequestClient::WarnNoFavicon",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequestClient::WarnNoFavicon");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequestClient_WarnNoFavicon_Params_Data* params =
          reinterpret_cast<internal::PaymentRequestClient_WarnNoFavicon_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PaymentRequestClient_WarnNoFavicon_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequestClient::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WarnNoFavicon();
      return true;
    }
  }
  return false;
}

// static
bool PaymentRequestClientStubDispatch::AcceptWithResponder(
    PaymentRequestClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPaymentRequestClient_OnPaymentMethodChange_Name: {
      break;
    }
    case internal::kPaymentRequestClient_OnShippingAddressChange_Name: {
      break;
    }
    case internal::kPaymentRequestClient_OnShippingOptionChange_Name: {
      break;
    }
    case internal::kPaymentRequestClient_OnPayerDetailChange_Name: {
      break;
    }
    case internal::kPaymentRequestClient_OnPaymentResponse_Name: {
      break;
    }
    case internal::kPaymentRequestClient_OnError_Name: {
      break;
    }
    case internal::kPaymentRequestClient_OnComplete_Name: {
      break;
    }
    case internal::kPaymentRequestClient_OnAbort_Name: {
      break;
    }
    case internal::kPaymentRequestClient_OnCanMakePayment_Name: {
      break;
    }
    case internal::kPaymentRequestClient_OnHasEnrolledInstrument_Name: {
      break;
    }
    case internal::kPaymentRequestClient_WarnNoFavicon_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPaymentRequestClientValidationInfo[] = {
    {&internal::PaymentRequestClient_OnPaymentMethodChange_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequestClient_OnShippingAddressChange_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequestClient_OnShippingOptionChange_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequestClient_OnPayerDetailChange_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequestClient_OnPaymentResponse_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequestClient_OnError_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequestClient_OnComplete_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequestClient_OnAbort_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequestClient_OnCanMakePayment_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequestClient_OnHasEnrolledInstrument_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequestClient_WarnNoFavicon_Params_Data::Validate,
     nullptr /* no response */},
};

bool PaymentRequestClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::PaymentRequestClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPaymentRequestClientValidationInfo);
}

const char PaymentRequest::Name_[] = "payments.mojom.PaymentRequest";

PaymentRequestProxy::PaymentRequestProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PaymentRequestProxy::Init(
    ::mojo::PendingRemote<PaymentRequestClient> in_client, std::vector<PaymentMethodDataPtr> in_method_data, PaymentDetailsPtr in_details, PaymentOptionsPtr in_options) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequest::Init", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("client", in_client.is_valid());
      raw_value->BeginArray("method_data");
      for (const auto& item0 : in_method_data) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      if (in_details.is_null()) {
        raw_value->SetString("details", "nullptr");
      } else {
        raw_value->BeginDictionary("details");
        in_details->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      if (in_options.is_null()) {
        raw_value->SetString("options", "nullptr");
      } else {
        raw_value->BeginDictionary("options");
        in_options->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequest_Init_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentRequest_Init_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::payments::mojom::PaymentRequestClientInterfaceBase>>(
      in_client, &params->client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in PaymentRequest.Init request");
  typename decltype(params->method_data)::BaseType::BufferWriter
      method_data_writer;
  const mojo::internal::ContainerValidateParams method_data_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::payments::mojom::PaymentMethodDataDataView>>(
      in_method_data, buffer, &method_data_writer, &method_data_validate_params,
      &serialization_context);
  params->method_data.Set(
      method_data_writer.is_null() ? nullptr : method_data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->method_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method_data in PaymentRequest.Init request");
  typename decltype(params->details)::BaseType::BufferWriter
      details_writer;
  mojo::internal::Serialize<::payments::mojom::PaymentDetailsDataView>(
      in_details, buffer, &details_writer, &serialization_context);
  params->details.Set(
      details_writer.is_null() ? nullptr : details_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->details.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in PaymentRequest.Init request");
  typename decltype(params->options)::BaseType::BufferWriter
      options_writer;
  mojo::internal::Serialize<::payments::mojom::PaymentOptionsDataView>(
      in_options, buffer, &options_writer, &serialization_context);
  params->options.Set(
      options_writer.is_null() ? nullptr : options_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in PaymentRequest.Init request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("Init");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestProxy::Show(
    bool in_is_user_gesture, bool in_wait_for_updated_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequest::Show", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("is_user_gesture", in_is_user_gesture);
      raw_value->SetBoolean("wait_for_updated_details", in_wait_for_updated_details);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequest_Show_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentRequest_Show_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->is_user_gesture = in_is_user_gesture;
  params->wait_for_updated_details = in_wait_for_updated_details;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("Show");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestProxy::UpdateWith(
    PaymentDetailsPtr in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequest::UpdateWith", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_details.is_null()) {
        raw_value->SetString("details", "nullptr");
      } else {
        raw_value->BeginDictionary("details");
        in_details->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequest_UpdateWith_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentRequest_UpdateWith_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->details)::BaseType::BufferWriter
      details_writer;
  mojo::internal::Serialize<::payments::mojom::PaymentDetailsDataView>(
      in_details, buffer, &details_writer, &serialization_context);
  params->details.Set(
      details_writer.is_null() ? nullptr : details_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->details.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in PaymentRequest.UpdateWith request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("UpdateWith");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestProxy::OnPaymentDetailsNotUpdated(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "payments::mojom::PaymentRequest::OnPaymentDetailsNotUpdated");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequest_OnPaymentDetailsNotUpdated_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentRequest_OnPaymentDetailsNotUpdated_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("OnPaymentDetailsNotUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestProxy::Abort(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "payments::mojom::PaymentRequest::Abort");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequest_Abort_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentRequest_Abort_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("Abort");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestProxy::Complete(
    PaymentComplete in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequest::Complete", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequest_Complete_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentRequest_Complete_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::payments::mojom::PaymentComplete>(
      in_result, &params->result);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("Complete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestProxy::Retry(
    ::payments::mojom::PaymentValidationErrorsPtr in_errors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "payments::mojom::PaymentRequest::Retry", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_errors.is_null()) {
        raw_value->SetString("errors", "nullptr");
      } else {
        raw_value->BeginDictionary("errors");
        in_errors->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequest_Retry_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentRequest_Retry_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->errors)::BaseType::BufferWriter
      errors_writer;
  mojo::internal::Serialize<::payments::mojom::PaymentValidationErrorsDataView>(
      in_errors, buffer, &errors_writer, &serialization_context);
  params->errors.Set(
      errors_writer.is_null() ? nullptr : errors_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->errors.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null errors in PaymentRequest.Retry request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("Retry");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestProxy::CanMakePayment(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "payments::mojom::PaymentRequest::CanMakePayment");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequest_CanMakePayment_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentRequest_CanMakePayment_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("CanMakePayment");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PaymentRequestProxy::HasEnrolledInstrument(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "payments::mojom::PaymentRequest::HasEnrolledInstrument");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPaymentRequest_HasEnrolledInstrument_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::payments::mojom::internal::PaymentRequest_HasEnrolledInstrument_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PaymentRequest::Name_);
  message.set_method_name("HasEnrolledInstrument");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PaymentRequestStubDispatch::Accept(
    PaymentRequest* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kPaymentRequest_Init_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequest::Init",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequest::Init");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequest_Init_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_Init_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<PaymentRequestClient> p_client{};
      std::vector<PaymentMethodDataPtr> p_method_data{};
      PaymentDetailsPtr p_details{};
      PaymentOptionsPtr p_options{};
      PaymentRequest_Init_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadMethodData(&p_method_data))
        success = false;
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Init(
std::move(p_client), 
std::move(p_method_data), 
std::move(p_details), 
std::move(p_options));
      return true;
    }
    case internal::kPaymentRequest_Show_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequest::Show",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequest::Show");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequest_Show_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_Show_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_user_gesture{};
      bool p_wait_for_updated_details{};
      PaymentRequest_Show_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_is_user_gesture = input_data_view.is_user_gesture();
      if (success)
        p_wait_for_updated_details = input_data_view.wait_for_updated_details();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Show(
std::move(p_is_user_gesture), 
std::move(p_wait_for_updated_details));
      return true;
    }
    case internal::kPaymentRequest_UpdateWith_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequest::UpdateWith",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequest::UpdateWith");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequest_UpdateWith_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_UpdateWith_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PaymentDetailsPtr p_details{};
      PaymentRequest_UpdateWith_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateWith(
std::move(p_details));
      return true;
    }
    case internal::kPaymentRequest_OnPaymentDetailsNotUpdated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequest::OnPaymentDetailsNotUpdated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequest::OnPaymentDetailsNotUpdated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequest_OnPaymentDetailsNotUpdated_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_OnPaymentDetailsNotUpdated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PaymentRequest_OnPaymentDetailsNotUpdated_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPaymentDetailsNotUpdated();
      return true;
    }
    case internal::kPaymentRequest_Abort_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequest::Abort",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequest::Abort");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequest_Abort_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_Abort_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PaymentRequest_Abort_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Abort();
      return true;
    }
    case internal::kPaymentRequest_Complete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequest::Complete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequest::Complete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequest_Complete_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_Complete_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PaymentComplete p_result{};
      PaymentRequest_Complete_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Complete(
std::move(p_result));
      return true;
    }
    case internal::kPaymentRequest_Retry_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequest::Retry",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequest::Retry");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequest_Retry_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_Retry_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::payments::mojom::PaymentValidationErrorsPtr p_errors{};
      PaymentRequest_Retry_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadErrors(&p_errors))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Retry(
std::move(p_errors));
      return true;
    }
    case internal::kPaymentRequest_CanMakePayment_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequest::CanMakePayment",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequest::CanMakePayment");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequest_CanMakePayment_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_CanMakePayment_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PaymentRequest_CanMakePayment_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CanMakePayment();
      return true;
    }
    case internal::kPaymentRequest_HasEnrolledInstrument_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)payments::mojom::PaymentRequest::HasEnrolledInstrument",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)payments::mojom::PaymentRequest::HasEnrolledInstrument");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PaymentRequest_HasEnrolledInstrument_Params_Data* params =
          reinterpret_cast<internal::PaymentRequest_HasEnrolledInstrument_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PaymentRequest_HasEnrolledInstrument_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PaymentRequest::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasEnrolledInstrument();
      return true;
    }
  }
  return false;
}

// static
bool PaymentRequestStubDispatch::AcceptWithResponder(
    PaymentRequest* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPaymentRequest_Init_Name: {
      break;
    }
    case internal::kPaymentRequest_Show_Name: {
      break;
    }
    case internal::kPaymentRequest_UpdateWith_Name: {
      break;
    }
    case internal::kPaymentRequest_OnPaymentDetailsNotUpdated_Name: {
      break;
    }
    case internal::kPaymentRequest_Abort_Name: {
      break;
    }
    case internal::kPaymentRequest_Complete_Name: {
      break;
    }
    case internal::kPaymentRequest_Retry_Name: {
      break;
    }
    case internal::kPaymentRequest_CanMakePayment_Name: {
      break;
    }
    case internal::kPaymentRequest_HasEnrolledInstrument_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPaymentRequestValidationInfo[] = {
    {&internal::PaymentRequest_Init_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequest_Show_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequest_UpdateWith_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequest_OnPaymentDetailsNotUpdated_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequest_Abort_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequest_Complete_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequest_Retry_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequest_CanMakePayment_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PaymentRequest_HasEnrolledInstrument_Params_Data::Validate,
     nullptr /* no response */},
};

bool PaymentRequestRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::payments::mojom::PaymentRequest::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPaymentRequestValidationInfo);
}

}  // namespace mojom
}  // namespace payments

namespace mojo {


// static
bool StructTraits<::payments::mojom::PaymentResponse::DataView, ::payments::mojom::PaymentResponsePtr>::Read(
    ::payments::mojom::PaymentResponse::DataView input,
    ::payments::mojom::PaymentResponsePtr* output) {
  bool success = true;
  ::payments::mojom::PaymentResponsePtr result(::payments::mojom::PaymentResponse::New());
  
      if (success && !input.ReadMethodName(&result->method_name))
        success = false;
      if (success && !input.ReadStringifiedDetails(&result->stringified_details))
        success = false;
      if (success && !input.ReadShippingAddress(&result->shipping_address))
        success = false;
      if (success && !input.ReadShippingOption(&result->shipping_option))
        success = false;
      if (success && !input.ReadPayer(&result->payer))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::PayerDetail::DataView, ::payments::mojom::PayerDetailPtr>::Read(
    ::payments::mojom::PayerDetail::DataView input,
    ::payments::mojom::PayerDetailPtr* output) {
  bool success = true;
  ::payments::mojom::PayerDetailPtr result(::payments::mojom::PayerDetail::New());
  
      if (success && !input.ReadEmail(&result->email))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadPhone(&result->phone))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::PaymentItem::DataView, ::payments::mojom::PaymentItemPtr>::Read(
    ::payments::mojom::PaymentItem::DataView input,
    ::payments::mojom::PaymentItemPtr* output) {
  bool success = true;
  ::payments::mojom::PaymentItemPtr result(::payments::mojom::PaymentItem::New());
  
      if (success && !input.ReadLabel(&result->label))
        success = false;
      if (success && !input.ReadAmount(&result->amount))
        success = false;
      if (success)
        result->pending = input.pending();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::PaymentShippingOption::DataView, ::payments::mojom::PaymentShippingOptionPtr>::Read(
    ::payments::mojom::PaymentShippingOption::DataView input,
    ::payments::mojom::PaymentShippingOptionPtr* output) {
  bool success = true;
  ::payments::mojom::PaymentShippingOptionPtr result(::payments::mojom::PaymentShippingOption::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
      if (success && !input.ReadAmount(&result->amount))
        success = false;
      if (success)
        result->selected = input.selected();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::GooglePaymentMethodData::DataView, ::payments::mojom::GooglePaymentMethodDataPtr>::Read(
    ::payments::mojom::GooglePaymentMethodData::DataView input,
    ::payments::mojom::GooglePaymentMethodDataPtr* output) {
  bool success = true;
  ::payments::mojom::GooglePaymentMethodDataPtr result(::payments::mojom::GooglePaymentMethodData::New());
  
      if (success && !input.ReadStringifiedData(&result->stringified_data))
        success = false;
      if (success)
        result->phone_requested = input.phone_requested();
      if (success)
        result->name_requested = input.name_requested();
      if (success)
        result->email_requested = input.email_requested();
      if (success)
        result->shipping_requested = input.shipping_requested();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::SecurePaymentConfirmationRequest::DataView, ::payments::mojom::SecurePaymentConfirmationRequestPtr>::Read(
    ::payments::mojom::SecurePaymentConfirmationRequest::DataView input,
    ::payments::mojom::SecurePaymentConfirmationRequestPtr* output) {
  bool success = true;
  ::payments::mojom::SecurePaymentConfirmationRequestPtr result(::payments::mojom::SecurePaymentConfirmationRequest::New());
  
      if (success && !input.ReadCredentialIds(&result->credential_ids))
        success = false;
      if (success && !input.ReadNetworkData(&result->network_data))
        success = false;
      if (success && !input.ReadTimeout(&result->timeout))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::PaymentMethodData::DataView, ::payments::mojom::PaymentMethodDataPtr>::Read(
    ::payments::mojom::PaymentMethodData::DataView input,
    ::payments::mojom::PaymentMethodDataPtr* output) {
  bool success = true;
  ::payments::mojom::PaymentMethodDataPtr result(::payments::mojom::PaymentMethodData::New());
  
      if (success && !input.ReadSupportedMethod(&result->supported_method))
        success = false;
      if (success && !input.ReadStringifiedData(&result->stringified_data))
        success = false;
      if (success && !input.ReadEnvironment(&result->environment))
        success = false;
      if (success)
        result->min_google_play_services_version = input.min_google_play_services_version();
      if (success)
        result->api_version = input.api_version();
      if (success && !input.ReadSupportedNetworks(&result->supported_networks))
        success = false;
      if (success && !input.ReadSecurePaymentConfirmation(&result->secure_payment_confirmation))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::PaymentDetailsModifier::DataView, ::payments::mojom::PaymentDetailsModifierPtr>::Read(
    ::payments::mojom::PaymentDetailsModifier::DataView input,
    ::payments::mojom::PaymentDetailsModifierPtr* output) {
  bool success = true;
  ::payments::mojom::PaymentDetailsModifierPtr result(::payments::mojom::PaymentDetailsModifier::New());
  
      if (success && !input.ReadTotal(&result->total))
        success = false;
      if (success && !input.ReadAdditionalDisplayItems(&result->additional_display_items))
        success = false;
      if (success && !input.ReadMethodData(&result->method_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::PaymentDetails::DataView, ::payments::mojom::PaymentDetailsPtr>::Read(
    ::payments::mojom::PaymentDetails::DataView input,
    ::payments::mojom::PaymentDetailsPtr* output) {
  bool success = true;
  ::payments::mojom::PaymentDetailsPtr result(::payments::mojom::PaymentDetails::New());
  
      if (success && !input.ReadTotal(&result->total))
        success = false;
      if (success && !input.ReadDisplayItems(&result->display_items))
        success = false;
      if (success && !input.ReadShippingOptions(&result->shipping_options))
        success = false;
      if (success && !input.ReadModifiers(&result->modifiers))
        success = false;
      if (success && !input.ReadError(&result->error))
        success = false;
      if (success && !input.ReadShippingAddressErrors(&result->shipping_address_errors))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadStringifiedPaymentMethodErrors(&result->stringified_payment_method_errors))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::payments::mojom::PaymentOptions::DataView, ::payments::mojom::PaymentOptionsPtr>::Read(
    ::payments::mojom::PaymentOptions::DataView input,
    ::payments::mojom::PaymentOptionsPtr* output) {
  bool success = true;
  ::payments::mojom::PaymentOptionsPtr result(::payments::mojom::PaymentOptions::New());
  
      if (success)
        result->request_payer_name = input.request_payer_name();
      if (success)
        result->request_payer_email = input.request_payer_email();
      if (success)
        result->request_payer_phone = input.request_payer_phone();
      if (success)
        result->request_shipping = input.request_shipping();
      if (success && !input.ReadShippingType(&result->shipping_type))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif