// third_party/blink/public/mojom/payments/payment_credential.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_CREDENTIAL_MOJOM_PARAMS_DATA_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_CREDENTIAL_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace payments {
namespace mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) PaymentCredential_StorePaymentCredential_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PaymentCredential_StorePaymentCredential_Params_Data));
      new (data()) PaymentCredential_StorePaymentCredential_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PaymentCredential_StorePaymentCredential_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PaymentCredential_StorePaymentCredential_Params_Data>(index_);
    }
    PaymentCredential_StorePaymentCredential_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::PaymentCredentialInstrument_Data> instrument;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> credential_id;
  mojo::internal::Pointer<mojo::internal::String_Data> rp_id;

 private:
  PaymentCredential_StorePaymentCredential_Params_Data();
  ~PaymentCredential_StorePaymentCredential_Params_Data() = delete;
};
static_assert(sizeof(PaymentCredential_StorePaymentCredential_Params_Data) == 32,
              "Bad sizeof(PaymentCredential_StorePaymentCredential_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) PaymentCredential_StorePaymentCredential_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(PaymentCredential_StorePaymentCredential_ResponseParams_Data));
      new (data()) PaymentCredential_StorePaymentCredential_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    PaymentCredential_StorePaymentCredential_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<PaymentCredential_StorePaymentCredential_ResponseParams_Data>(index_);
    }
    PaymentCredential_StorePaymentCredential_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t padfinal_[4];

 private:
  PaymentCredential_StorePaymentCredential_ResponseParams_Data();
  ~PaymentCredential_StorePaymentCredential_ResponseParams_Data() = delete;
};
static_assert(sizeof(PaymentCredential_StorePaymentCredential_ResponseParams_Data) == 16,
              "Bad sizeof(PaymentCredential_StorePaymentCredential_ResponseParams_Data)");

}  // namespace internal


class PaymentCredential_StorePaymentCredential_ParamsDataView {
 public:
  PaymentCredential_StorePaymentCredential_ParamsDataView() {}

  PaymentCredential_StorePaymentCredential_ParamsDataView(
      internal::PaymentCredential_StorePaymentCredential_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetInstrumentDataView(
      PaymentCredentialInstrumentDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInstrument(UserType* output) {
    
    auto* pointer = data_->instrument.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentCredentialInstrumentDataView>(
        pointer, output, context_);
  }
  inline void GetCredentialIdDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCredentialId(UserType* output) {
    
    auto* pointer = data_->credential_id.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
  inline void GetRpIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRpId(UserType* output) {
    
    auto* pointer = data_->rp_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::PaymentCredential_StorePaymentCredential_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class PaymentCredential_StorePaymentCredential_ResponseParamsDataView {
 public:
  PaymentCredential_StorePaymentCredential_ResponseParamsDataView() {}

  PaymentCredential_StorePaymentCredential_ResponseParamsDataView(
      internal::PaymentCredential_StorePaymentCredential_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::payments::mojom::PaymentCredentialCreationStatus>(
        data_value, output);
  }

  PaymentCredentialCreationStatus status() const {
    return static_cast<PaymentCredentialCreationStatus>(data_->status);
  }
 private:
  internal::PaymentCredential_StorePaymentCredential_ResponseParams_Data* data_ = nullptr;
};


inline void PaymentCredential_StorePaymentCredential_ParamsDataView::GetInstrumentDataView(
    PaymentCredentialInstrumentDataView* output) {
  auto pointer = data_->instrument.Get();
  *output = PaymentCredentialInstrumentDataView(pointer, context_);
}
inline void PaymentCredential_StorePaymentCredential_ParamsDataView::GetCredentialIdDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->credential_id.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}
inline void PaymentCredential_StorePaymentCredential_ParamsDataView::GetRpIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->rp_id.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace payments

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_CREDENTIAL_MOJOM_PARAMS_DATA_H_