// third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_INTRINSIC_SIZING_INFO_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_INTRINSIC_SIZING_INFO_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom-blink-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {








class PLATFORM_EXPORT IntrinsicSizingInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IntrinsicSizingInfo, T>::value>;
  using DataView = IntrinsicSizingInfoDataView;
  using Data_ = internal::IntrinsicSizingInfo_Data;

  template <typename... Args>
  static IntrinsicSizingInfoPtr New(Args&&... args) {
    return IntrinsicSizingInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IntrinsicSizingInfoPtr From(const U& u) {
    return mojo::TypeConverter<IntrinsicSizingInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IntrinsicSizingInfo>::Convert(*this);
  }


  IntrinsicSizingInfo();

  IntrinsicSizingInfo(
      const ::gfx::SizeF& size,
      const ::gfx::SizeF& aspect_ratio,
      bool has_width,
      bool has_height);

  ~IntrinsicSizingInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IntrinsicSizingInfoPtr>
  IntrinsicSizingInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IntrinsicSizingInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IntrinsicSizingInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IntrinsicSizingInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IntrinsicSizingInfo_UnserializedMessageContext<
            UserType, IntrinsicSizingInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<IntrinsicSizingInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return IntrinsicSizingInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IntrinsicSizingInfo_UnserializedMessageContext<
            UserType, IntrinsicSizingInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IntrinsicSizingInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::gfx::SizeF size;
  
  ::gfx::SizeF aspect_ratio;
  
  bool has_width;
  
  bool has_height;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IntrinsicSizingInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IntrinsicSizingInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IntrinsicSizingInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IntrinsicSizingInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
IntrinsicSizingInfoPtr IntrinsicSizingInfo::Clone() const {
  return New(
      mojo::Clone(size),
      mojo::Clone(aspect_ratio),
      mojo::Clone(has_width),
      mojo::Clone(has_height)
  );
}

template <typename T, IntrinsicSizingInfo::EnableIfSame<T>*>
bool IntrinsicSizingInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->aspect_ratio, other_struct.aspect_ratio))
    return false;
  if (!mojo::Equals(this->has_width, other_struct.has_width))
    return false;
  if (!mojo::Equals(this->has_height, other_struct.has_height))
    return false;
  return true;
}

template <typename T, IntrinsicSizingInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.size, rhs.size))
    return true;
  if (std::less<>{}(rhs.size, lhs.size))
    return false;
  if (std::less<>{}(lhs.aspect_ratio, rhs.aspect_ratio))
    return true;
  if (std::less<>{}(rhs.aspect_ratio, lhs.aspect_ratio))
    return false;
  if (std::less<>{}(lhs.has_width, rhs.has_width))
    return true;
  if (std::less<>{}(rhs.has_width, lhs.has_width))
    return false;
  if (std::less<>{}(lhs.has_height, rhs.has_height))
    return true;
  if (std::less<>{}(rhs.has_height, lhs.has_height))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::IntrinsicSizingInfo::DataView,
                                         ::blink::mojom::blink::IntrinsicSizingInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::IntrinsicSizingInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::IntrinsicSizingInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::IntrinsicSizingInfo::size)& size(
      const ::blink::mojom::blink::IntrinsicSizingInfoPtr& input) {
    return input->size;
  }

  static const decltype(::blink::mojom::blink::IntrinsicSizingInfo::aspect_ratio)& aspect_ratio(
      const ::blink::mojom::blink::IntrinsicSizingInfoPtr& input) {
    return input->aspect_ratio;
  }

  static decltype(::blink::mojom::blink::IntrinsicSizingInfo::has_width) has_width(
      const ::blink::mojom::blink::IntrinsicSizingInfoPtr& input) {
    return input->has_width;
  }

  static decltype(::blink::mojom::blink::IntrinsicSizingInfo::has_height) has_height(
      const ::blink::mojom::blink::IntrinsicSizingInfoPtr& input) {
    return input->has_height;
  }

  static bool Read(::blink::mojom::blink::IntrinsicSizingInfo::DataView input, ::blink::mojom::blink::IntrinsicSizingInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_INTRINSIC_SIZING_INFO_MOJOM_BLINK_H_