// third_party/blink/public/mojom/frame/frame.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/frame/frame.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame.mojom-forward.h"
#include "cc/mojom/touch_action.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "mojo/public/mojom/base/text_direction.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/data_decoder/public/mojom/resource_snapshot_for_web_bundle.mojom.h"
#include "services/network/public/mojom/content_security_policy.mojom.h"
#include "services/network/public/mojom/fetch_api.mojom-forward.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-forward.h"
#include "services/network/public/mojom/cross_origin_opener_policy.mojom.h"
#include "skia/public/mojom/skcolor.mojom.h"
#include "third_party/blink/public/mojom/ad_tagging/ad_frame.mojom-forward.h"
#include "third_party/blink/public/mojom/blob/blob.mojom.h"
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom.h"
#include "third_party/blink/public/mojom/choosers/popup_menu.mojom.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-forward.h"
#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom.h"
#include "third_party/blink/public/mojom/feature_policy/feature_policy.mojom.h"
#include "third_party/blink/public/mojom/favicon/favicon_url.mojom.h"
#include "third_party/blink/public/mojom/frame/blocked_navigation_types.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom.h"
#include "third_party/blink/public/mojom/frame/fullscreen.mojom.h"
#include "third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom.h"
#include "third_party/blink/public/mojom/frame/lifecycle.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/media_player_action.mojom.h"
#include "third_party/blink/public/mojom/frame/reporting_observer.mojom.h"
#include "third_party/blink/public/mojom/frame/sudden_termination_disabler_type.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/user_activation_notification_type.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/user_activation_update_types.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom.h"
#include "third_party/blink/public/mojom/input/focus_type.mojom-forward.h"
#include "third_party/blink/public/mojom/input/scroll_direction.mojom-forward.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom.h"
#include "third_party/blink/public/mojom/portal/portal.mojom.h"
#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom.h"
#include "third_party/blink/public/mojom/security_context/insecure_request_policy.mojom-forward.h"
#include "third_party/blink/public/mojom/timing/resource_timing.mojom.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom.h"
#include "third_party/blink/public/mojom/web_feature/web_feature.mojom-forward.h"
#include "ui/events/mojom/scroll_granularity.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/range/mojom/range.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {

class LocalFrameHostProxy;

template <typename ImplRefTraits>
class LocalFrameHostStub;

class LocalFrameHostRequestValidator;
class LocalFrameHostResponseValidator;


class BLINK_COMMON_EXPORT LocalFrameHost
    : public LocalFrameHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = true;

  using Base_ = LocalFrameHostInterfaceBase;
  using Proxy_ = LocalFrameHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = LocalFrameHostStub<ImplRefTraits>;

  using RequestValidator_ = LocalFrameHostRequestValidator;
  using ResponseValidator_ = LocalFrameHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kEnterFullscreenMinVersion = 0,
    kExitFullscreenMinVersion = 0,
    kFullscreenStateChangedMinVersion = 0,
    kRegisterProtocolHandlerMinVersion = 0,
    kUnregisterProtocolHandlerMinVersion = 0,
    kDidDisplayInsecureContentMinVersion = 0,
    kDidContainInsecureFormActionMinVersion = 0,
    kDocumentAvailableInMainFrameMinVersion = 0,
    kSetNeedsOcclusionTrackingMinVersion = 0,
    kSetVirtualKeyboardOverlayPolicyMinVersion = 0,
    kVisibilityChangedMinVersion = 0,
    kDidChangeThemeColorMinVersion = 0,
    kDidChangeBackgroundColorMinVersion = 0,
    kDidFailLoadWithErrorMinVersion = 0,
    kDidFocusFrameMinVersion = 0,
    kDidCallFocusMinVersion = 0,
    kDidAddContentSecurityPoliciesMinVersion = 0,
    kEnforceInsecureRequestPolicyMinVersion = 0,
    kEnforceInsecureNavigationsSetMinVersion = 0,
    kDidChangeActiveSchedulerTrackedFeaturesMinVersion = 0,
    kSuddenTerminationDisablerChangedMinVersion = 0,
    kHadStickyUserActivationBeforeNavigationChangedMinVersion = 0,
    kScrollRectToVisibleInParentFrameMinVersion = 0,
    kBubbleLogicalScrollInParentFrameMinVersion = 0,
    kDidAccessInitialDocumentMinVersion = 0,
    kDidBlockNavigationMinVersion = 0,
    kDidChangeLoadProgressMinVersion = 0,
    kDidFinishLoadMinVersion = 0,
    kDispatchLoadMinVersion = 0,
    kGoToEntryAtOffsetMinVersion = 0,
    kRenderFallbackContentInParentProcessMinVersion = 0,
    kUpdateTitleMinVersion = 0,
    kUpdateUserActivationStateMinVersion = 0,
    kHandleAccessibilityFindInPageResultMinVersion = 0,
    kHandleAccessibilityFindInPageTerminationMinVersion = 0,
    kDocumentOnLoadCompletedMinVersion = 0,
    kForwardResourceTimingToParentMinVersion = 0,
    kDidFinishDocumentLoadMinVersion = 0,
    kRunModalAlertDialogMinVersion = 0,
    kRunModalConfirmDialogMinVersion = 0,
    kRunModalPromptDialogMinVersion = 0,
    kRunBeforeUnloadConfirmMinVersion = 0,
    kUpdateFaviconURLMinVersion = 0,
    kDownloadURLMinVersion = 0,
    kFocusedElementChangedMinVersion = 0,
    kTextSelectionChangedMinVersion = 0,
    kShowPopupMenuMinVersion = 0,
    kDidLoadResourceFromMemoryCacheMinVersion = 0,
    kDidChangeFrameOwnerPropertiesMinVersion = 0,
    kDidChangeOpenerMinVersion = 0,
    kDidChangeFramePolicyMinVersion = 0,
    kDidChangeCSPAttributeMinVersion = 0,
    kCapturePaintPreviewOfSubframeMinVersion = 0,
    kDetachMinVersion = 0,
  };
  virtual ~LocalFrameHost() {}


  using EnterFullscreenCallback = base::OnceCallback<void(bool)>;
  
  virtual void EnterFullscreen(::blink::mojom::FullscreenOptionsPtr options, EnterFullscreenCallback callback) = 0;

  
  virtual void ExitFullscreen() = 0;

  
  virtual void FullscreenStateChanged(bool is_fullscreen) = 0;

  
  virtual void RegisterProtocolHandler(const std::string& scheme, const ::GURL& url, const ::base::string16& title, bool user_gesture) = 0;

  
  virtual void UnregisterProtocolHandler(const std::string& scheme, const ::GURL& url, bool user_gesture) = 0;

  
  virtual void DidDisplayInsecureContent() = 0;

  
  virtual void DidContainInsecureFormAction() = 0;

  
  virtual void DocumentAvailableInMainFrame(bool uses_temporary_zoom_level) = 0;

  
  virtual void SetNeedsOcclusionTracking(bool needs_tracking) = 0;

  
  virtual void SetVirtualKeyboardOverlayPolicy(bool vk_overlays_content) = 0;

  
  virtual void VisibilityChanged(::blink::mojom::FrameVisibility visibility) = 0;

  
  virtual void DidChangeThemeColor(const base::Optional<::SkColor>& theme_color) = 0;

  
  virtual void DidChangeBackgroundColor(const ::SkColor& background_color) = 0;

  
  virtual void DidFailLoadWithError(const ::GURL& url, int32_t error_code) = 0;

  
  virtual void DidFocusFrame() = 0;

  
  virtual void DidCallFocus() = 0;

  
  virtual void DidAddContentSecurityPolicies(std::vector<::network::mojom::ContentSecurityPolicyPtr> policies) = 0;

  
  virtual void EnforceInsecureRequestPolicy(::blink::mojom::InsecureRequestPolicy policy_bitmap) = 0;

  
  virtual void EnforceInsecureNavigationsSet(const std::vector<uint32_t>& set) = 0;

  
  virtual void DidChangeActiveSchedulerTrackedFeatures(uint64_t features_mask) = 0;

  
  virtual void SuddenTerminationDisablerChanged(bool present, ::blink::mojom::SuddenTerminationDisablerType disabler_type) = 0;

  
  virtual void HadStickyUserActivationBeforeNavigationChanged(bool has_gesture) = 0;

  
  virtual void ScrollRectToVisibleInParentFrame(const ::gfx::Rect& rect_to_scroll, ::blink::mojom::ScrollIntoViewParamsPtr params) = 0;

  
  virtual void BubbleLogicalScrollInParentFrame(::blink::mojom::ScrollDirection direction, ::ui::ScrollGranularity granularity) = 0;

  
  virtual void DidAccessInitialDocument() = 0;

  
  virtual void DidBlockNavigation(const ::GURL& blocked_url, const ::GURL& initiator_url, ::blink::mojom::NavigationBlockedReason reason) = 0;

  
  virtual void DidChangeLoadProgress(double load_progress) = 0;

  
  virtual void DidFinishLoad(const ::GURL& validated_url) = 0;

  
  virtual void DispatchLoad() = 0;

  
  virtual void GoToEntryAtOffset(int32_t offset, bool has_user_gesture) = 0;

  
  virtual void RenderFallbackContentInParentProcess() = 0;

  
  virtual void UpdateTitle(const base::Optional<::base::string16>& title, ::base::i18n::TextDirection title_direction) = 0;

  
  virtual void UpdateUserActivationState(::blink::mojom::UserActivationUpdateType update_type, ::blink::mojom::UserActivationNotificationType notification_type) = 0;

  
  virtual void HandleAccessibilityFindInPageResult(FindInPageResultAXParamsPtr params) = 0;

  
  virtual void HandleAccessibilityFindInPageTermination() = 0;

  
  virtual void DocumentOnLoadCompleted() = 0;

  
  virtual void ForwardResourceTimingToParent(::blink::mojom::ResourceTimingInfoPtr timing) = 0;

  
  virtual void DidFinishDocumentLoad() = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool RunModalAlertDialog(const ::base::string16& alert_message);

  using RunModalAlertDialogCallback = base::OnceCallback<void()>;
  
  virtual void RunModalAlertDialog(const ::base::string16& alert_message, RunModalAlertDialogCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool RunModalConfirmDialog(const ::base::string16& alert_message, bool* out_success);

  using RunModalConfirmDialogCallback = base::OnceCallback<void(bool)>;
  
  virtual void RunModalConfirmDialog(const ::base::string16& alert_message, RunModalConfirmDialogCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool RunModalPromptDialog(const ::base::string16& alert_message, const ::base::string16& default_value, bool* out_success, ::base::string16* out_result);

  using RunModalPromptDialogCallback = base::OnceCallback<void(bool, const ::base::string16&)>;
  
  virtual void RunModalPromptDialog(const ::base::string16& alert_message, const ::base::string16& default_value, RunModalPromptDialogCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool RunBeforeUnloadConfirm(bool is_reload, bool* out_success);

  using RunBeforeUnloadConfirmCallback = base::OnceCallback<void(bool)>;
  
  virtual void RunBeforeUnloadConfirm(bool is_reload, RunBeforeUnloadConfirmCallback callback) = 0;

  
  virtual void UpdateFaviconURL(std::vector<::blink::mojom::FaviconURLPtr> favicon_urls) = 0;

  
  virtual void DownloadURL(DownloadURLParamsPtr params) = 0;

  
  virtual void FocusedElementChanged(bool is_editable_element, const ::gfx::Rect& bounds_in_frame_widget, ::blink::mojom::FocusType focus_type) = 0;

  
  virtual void TextSelectionChanged(const ::base::string16& text, uint32_t offset, const ::gfx::Range& range, bool user_initiated) = 0;

  
  virtual void ShowPopupMenu(::mojo::PendingRemote<::blink::mojom::PopupMenuClient> popup_client, const ::gfx::Rect& bounds, int32_t item_height, double font_size, int32_t selected_item, std::vector<::blink::mojom::MenuItemPtr> menu_items, bool right_aligned, bool allow_multiple_selection) = 0;

  
  virtual void DidLoadResourceFromMemoryCache(const ::GURL& url, const std::string& http_method, const std::string& mime_type, ::network::mojom::RequestDestination request_destination) = 0;

  
  virtual void DidChangeFrameOwnerProperties(const ::base::UnguessableToken& child_frame_token, ::blink::mojom::FrameOwnerPropertiesPtr frame_owner_properties) = 0;

  
  virtual void DidChangeOpener(const base::Optional<::base::UnguessableToken>& opener_frame) = 0;

  
  virtual void DidChangeFramePolicy(const ::base::UnguessableToken& child_frame_token, const ::blink::FramePolicy& frame_policy) = 0;

  
  virtual void DidChangeCSPAttribute(const ::base::UnguessableToken& child_frame_token, ::network::mojom::ContentSecurityPolicyPtr parsed_csp_attribute) = 0;

  
  virtual void CapturePaintPreviewOfSubframe(const ::gfx::Rect& clip_rect, const ::base::UnguessableToken& guid) = 0;

  
  virtual void Detach() = 0;
};

class LocalFrameProxy;

template <typename ImplRefTraits>
class LocalFrameStub;

class LocalFrameRequestValidator;
class LocalFrameResponseValidator;


class BLINK_COMMON_EXPORT LocalFrame
    : public LocalFrameInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = LocalFrameInterfaceBase;
  using Proxy_ = LocalFrameProxy;

  template <typename ImplRefTraits>
  using Stub_ = LocalFrameStub<ImplRefTraits>;

  using RequestValidator_ = LocalFrameRequestValidator;
  using ResponseValidator_ = LocalFrameResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetTextSurroundingSelectionMinVersion = 0,
    kSendInterventionReportMinVersion = 0,
    kSetFrameOwnerPropertiesMinVersion = 0,
    kNotifyUserActivationMinVersion = 0,
    kNotifyVirtualKeyboardOverlayRectMinVersion = 0,
    kAddMessageToConsoleMinVersion = 0,
    kAddInspectorIssueMinVersion = 0,
    kCheckCompletedMinVersion = 0,
    kStopLoadingMinVersion = 0,
    kCollapseMinVersion = 0,
    kEnableViewSourceModeMinVersion = 0,
    kFocusMinVersion = 0,
    kClearFocusedElementMinVersion = 0,
    kGetResourceSnapshotForWebBundleMinVersion = 0,
    kCopyImageAtMinVersion = 0,
    kSaveImageAtMinVersion = 0,
    kReportBlinkFeatureUsageMinVersion = 0,
    kRenderFallbackContentMinVersion = 0,
    kBeforeUnloadMinVersion = 0,
    kMediaPlayerActionAtMinVersion = 0,
    kAdvanceFocusInFrameMinVersion = 0,
    kAdvanceFocusInFormMinVersion = 0,
    kReportContentSecurityPolicyViolationMinVersion = 0,
    kDidUpdateFramePolicyMinVersion = 0,
    kOnScreensChangeMinVersion = 0,
    kPostMessageEventMinVersion = 0,
    kBindReportingObserverMinVersion = 0,
    kUpdateOpenerMinVersion = 0,
    kGetSavableResourceLinksMinVersion = 0,
  };
  virtual ~LocalFrame() {}


  using GetTextSurroundingSelectionCallback = base::OnceCallback<void(const ::base::string16&, uint32_t, uint32_t)>;
  
  virtual void GetTextSurroundingSelection(uint32_t max_length, GetTextSurroundingSelectionCallback callback) = 0;

  
  virtual void SendInterventionReport(const std::string& id, const std::string& message) = 0;

  
  virtual void SetFrameOwnerProperties(::blink::mojom::FrameOwnerPropertiesPtr properties) = 0;

  
  virtual void NotifyUserActivation(::blink::mojom::UserActivationNotificationType notification_type) = 0;

  
  virtual void NotifyVirtualKeyboardOverlayRect(const ::gfx::Rect& keyboard_rect) = 0;

  
  virtual void AddMessageToConsole(::blink::mojom::ConsoleMessageLevel level, const std::string& message, bool discard_duplicates) = 0;

  
  virtual void AddInspectorIssue(::blink::mojom::InspectorIssueInfoPtr info) = 0;

  
  virtual void CheckCompleted() = 0;

  
  virtual void StopLoading() = 0;

  
  virtual void Collapse(bool collapsed) = 0;

  
  virtual void EnableViewSourceMode() = 0;

  
  virtual void Focus() = 0;

  
  virtual void ClearFocusedElement() = 0;

  
  virtual void GetResourceSnapshotForWebBundle(::mojo::PendingReceiver<::data_decoder::mojom::ResourceSnapshotForWebBundle> receiver) = 0;

  
  virtual void CopyImageAt(const ::gfx::Point& window_point) = 0;

  
  virtual void SaveImageAt(const ::gfx::Point& window_point) = 0;

  
  virtual void ReportBlinkFeatureUsage(const std::vector<::blink::mojom::WebFeature>& features) = 0;

  
  virtual void RenderFallbackContent() = 0;


  using BeforeUnloadCallback = base::OnceCallback<void(bool, ::base::TimeTicks, ::base::TimeTicks)>;
  
  virtual void BeforeUnload(bool is_reload, BeforeUnloadCallback callback) = 0;

  
  virtual void MediaPlayerActionAt(const ::gfx::Point& location, ::blink::mojom::MediaPlayerActionPtr action) = 0;

  
  virtual void AdvanceFocusInFrame(::blink::mojom::FocusType focus_type, const base::Optional<::base::UnguessableToken>& source_frame_token) = 0;

  
  virtual void AdvanceFocusInForm(::blink::mojom::FocusType focus_type) = 0;

  
  virtual void ReportContentSecurityPolicyViolation(::network::mojom::CSPViolationPtr violation) = 0;

  
  virtual void DidUpdateFramePolicy(const ::blink::FramePolicy& frame_policy) = 0;

  
  virtual void OnScreensChange() = 0;

  
  virtual void PostMessageEvent(const base::Optional<::base::UnguessableToken>& source_frame_token, const ::base::string16& source_origin, const ::base::string16& target_origin, ::blink::TransferableMessage message) = 0;

  
  virtual void BindReportingObserver(::mojo::PendingReceiver<::blink::mojom::ReportingObserver> receiver) = 0;

  
  virtual void UpdateOpener(const base::Optional<::base::UnguessableToken>& opener_frame_token) = 0;


  using GetSavableResourceLinksCallback = base::OnceCallback<void(GetSavableResourceLinksReplyPtr)>;
  
  virtual void GetSavableResourceLinks(GetSavableResourceLinksCallback callback) = 0;
};

class HighPriorityLocalFrameProxy;

template <typename ImplRefTraits>
class HighPriorityLocalFrameStub;

class HighPriorityLocalFrameRequestValidator;
class HighPriorityLocalFrameResponseValidator;


class BLINK_COMMON_EXPORT HighPriorityLocalFrame
    : public HighPriorityLocalFrameInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = HighPriorityLocalFrameInterfaceBase;
  using Proxy_ = HighPriorityLocalFrameProxy;

  template <typename ImplRefTraits>
  using Stub_ = HighPriorityLocalFrameStub<ImplRefTraits>;

  using RequestValidator_ = HighPriorityLocalFrameRequestValidator;
  using ResponseValidator_ = HighPriorityLocalFrameResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDispatchBeforeUnloadMinVersion = 0,
  };
  virtual ~HighPriorityLocalFrame() {}


  using DispatchBeforeUnloadCallback = base::OnceCallback<void(bool, ::base::TimeTicks, ::base::TimeTicks)>;
  
  virtual void DispatchBeforeUnload(bool is_reload, DispatchBeforeUnloadCallback callback) = 0;
};

class RemoteFrameHostProxy;

template <typename ImplRefTraits>
class RemoteFrameHostStub;

class RemoteFrameHostRequestValidator;


class BLINK_COMMON_EXPORT RemoteFrameHost
    : public RemoteFrameHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = RemoteFrameHostInterfaceBase;
  using Proxy_ = RemoteFrameHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = RemoteFrameHostStub<ImplRefTraits>;

  using RequestValidator_ = RemoteFrameHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetInheritedEffectiveTouchActionMinVersion = 0,
    kUpdateRenderThrottlingStatusMinVersion = 0,
    kVisibilityChangedMinVersion = 0,
    kDidFocusFrameMinVersion = 0,
    kCheckCompletedMinVersion = 0,
    kCapturePaintPreviewOfCrossProcessSubframeMinVersion = 0,
    kSetIsInertMinVersion = 0,
    kDidChangeOpenerMinVersion = 0,
    kAdvanceFocusMinVersion = 0,
    kRouteMessageEventMinVersion = 0,
    kPrintCrossProcessSubframeMinVersion = 0,
    kDetachMinVersion = 0,
  };
  virtual ~RemoteFrameHost() {}

  
  virtual void SetInheritedEffectiveTouchAction(::cc::TouchAction touch_action) = 0;

  
  virtual void UpdateRenderThrottlingStatus(bool is_throttled, bool subtree_throttled) = 0;

  
  virtual void VisibilityChanged(::blink::mojom::FrameVisibility visibility) = 0;

  
  virtual void DidFocusFrame() = 0;

  
  virtual void CheckCompleted() = 0;

  
  virtual void CapturePaintPreviewOfCrossProcessSubframe(const ::gfx::Rect& clip_rect, const ::base::UnguessableToken& guid) = 0;

  
  virtual void SetIsInert(bool inert) = 0;

  
  virtual void DidChangeOpener(const base::Optional<::base::UnguessableToken>& opener_frame) = 0;

  
  virtual void AdvanceFocus(::blink::mojom::FocusType focus_type, const ::base::UnguessableToken& source_frame_token) = 0;

  
  virtual void RouteMessageEvent(const base::Optional<::base::UnguessableToken>& source_frame_token, const ::base::string16& source_origin, const ::base::string16& target_origin, ::blink::TransferableMessage message) = 0;

  
  virtual void PrintCrossProcessSubframe(const ::gfx::Rect& frame_content_rect, int32_t document_cookie) = 0;

  
  virtual void Detach() = 0;
};

class RemoteFrameProxy;

template <typename ImplRefTraits>
class RemoteFrameStub;

class RemoteFrameRequestValidator;


class BLINK_COMMON_EXPORT RemoteFrame
    : public RemoteFrameInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = RemoteFrameInterfaceBase;
  using Proxy_ = RemoteFrameProxy;

  template <typename ImplRefTraits>
  using Stub_ = RemoteFrameStub<ImplRefTraits>;

  using RequestValidator_ = RemoteFrameRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kWillEnterFullscreenMinVersion = 0,
    kAddReplicatedContentSecurityPoliciesMinVersion = 0,
    kResetReplicatedContentSecurityPolicyMinVersion = 0,
    kEnforceInsecureNavigationsSetMinVersion = 0,
    kSetFrameOwnerPropertiesMinVersion = 0,
    kEnforceInsecureRequestPolicyMinVersion = 0,
    kSetReplicatedOriginMinVersion = 0,
    kSetReplicatedAdFrameTypeMinVersion = 0,
    kSetReplicatedNameMinVersion = 0,
    kDispatchLoadEventForFrameOwnerMinVersion = 0,
    kSetNeedsOcclusionTrackingMinVersion = 0,
    kCollapseMinVersion = 0,
    kFocusMinVersion = 0,
    kSetHadStickyUserActivationBeforeNavigationMinVersion = 0,
    kBubbleLogicalScrollMinVersion = 0,
    kUpdateUserActivationStateMinVersion = 0,
    kSetEmbeddingTokenMinVersion = 0,
    kSetPageFocusMinVersion = 0,
    kRenderFallbackContentMinVersion = 0,
    kAddResourceTimingFromChildMinVersion = 0,
    kScrollRectToVisibleMinVersion = 0,
    kDidStartLoadingMinVersion = 0,
    kDidStopLoadingMinVersion = 0,
    kIntrinsicSizingInfoOfChildChangedMinVersion = 0,
    kDidSetFramePolicyHeadersMinVersion = 0,
    kDidUpdateFramePolicyMinVersion = 0,
    kUpdateOpenerMinVersion = 0,
  };
  virtual ~RemoteFrame() {}

  
  virtual void WillEnterFullscreen(::blink::mojom::FullscreenOptionsPtr options) = 0;

  
  virtual void AddReplicatedContentSecurityPolicies(std::vector<::network::mojom::ContentSecurityPolicyHeaderPtr> headers) = 0;

  
  virtual void ResetReplicatedContentSecurityPolicy() = 0;

  
  virtual void EnforceInsecureNavigationsSet(const std::vector<uint32_t>& set) = 0;

  
  virtual void SetFrameOwnerProperties(::blink::mojom::FrameOwnerPropertiesPtr properties) = 0;

  
  virtual void EnforceInsecureRequestPolicy(::blink::mojom::InsecureRequestPolicy policy) = 0;

  
  virtual void SetReplicatedOrigin(const ::url::Origin& origin, bool is_potentially_trustworthy_unique_origin) = 0;

  
  virtual void SetReplicatedAdFrameType(::blink::mojom::AdFrameType ad_frame_type) = 0;

  
  virtual void SetReplicatedName(const std::string& name, const std::string& unique_name) = 0;

  
  virtual void DispatchLoadEventForFrameOwner() = 0;

  
  virtual void SetNeedsOcclusionTracking(bool needs_tracking) = 0;

  
  virtual void Collapse(bool collapsed) = 0;

  
  virtual void Focus() = 0;

  
  virtual void SetHadStickyUserActivationBeforeNavigation(bool has_gesture) = 0;

  
  virtual void BubbleLogicalScroll(::blink::mojom::ScrollDirection direction, ::ui::ScrollGranularity granularity) = 0;

  
  virtual void UpdateUserActivationState(::blink::mojom::UserActivationUpdateType state_update_type, ::blink::mojom::UserActivationNotificationType notification_type) = 0;

  
  virtual void SetEmbeddingToken(const ::base::UnguessableToken& embedding_token) = 0;

  
  virtual void SetPageFocus(bool is_focused) = 0;

  
  virtual void RenderFallbackContent() = 0;

  
  virtual void AddResourceTimingFromChild(::blink::mojom::ResourceTimingInfoPtr timing) = 0;

  
  virtual void ScrollRectToVisible(const ::gfx::Rect& rect, ::blink::mojom::ScrollIntoViewParamsPtr params) = 0;

  
  virtual void DidStartLoading() = 0;

  
  virtual void DidStopLoading() = 0;

  
  virtual void IntrinsicSizingInfoOfChildChanged(::blink::mojom::IntrinsicSizingInfoPtr sizing_info) = 0;

  
  virtual void DidSetFramePolicyHeaders(::network::mojom::WebSandboxFlags sandbox_flags, const std::vector<::blink::ParsedFeaturePolicyDeclaration>& parsed_feature_policy) = 0;

  
  virtual void DidUpdateFramePolicy(const ::blink::FramePolicy& frame_policy) = 0;

  
  virtual void UpdateOpener(const base::Optional<::base::UnguessableToken>& opener_frame_token) = 0;
};

class LocalMainFrameProxy;

template <typename ImplRefTraits>
class LocalMainFrameStub;

class LocalMainFrameRequestValidator;
class LocalMainFrameResponseValidator;


class BLINK_COMMON_EXPORT LocalMainFrame
    : public LocalMainFrameInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = LocalMainFrameInterfaceBase;
  using Proxy_ = LocalMainFrameProxy;

  template <typename ImplRefTraits>
  using Stub_ = LocalMainFrameStub<ImplRefTraits>;

  using RequestValidator_ = LocalMainFrameRequestValidator;
  using ResponseValidator_ = LocalMainFrameResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAnimateDoubleTapZoomMinVersion = 0,
    kSetScaleFactorMinVersion = 0,
    kClosePageMinVersion = 0,
    kPluginActionAtMinVersion = 0,
    kSetInitialFocusMinVersion = 0,
    kEnablePreferredSizeChangedModeMinVersion = 0,
    kZoomToFindInPageRectMinVersion = 0,
    kInstallCoopAccessMonitorMinVersion = 0,
    kOnPortalActivatedMinVersion = 0,
    kForwardMessageFromHostMinVersion = 0,
  };
  virtual ~LocalMainFrame() {}

  
  virtual void AnimateDoubleTapZoom(const ::gfx::Point& point, const ::gfx::Rect& rect) = 0;

  
  virtual void SetScaleFactor(float scale) = 0;


  using ClosePageCallback = base::OnceCallback<void()>;
  
  virtual void ClosePage(ClosePageCallback callback) = 0;

  
  virtual void PluginActionAt(const ::gfx::Point& location, PluginActionType action) = 0;

  
  virtual void SetInitialFocus(bool reverse) = 0;

  
  virtual void EnablePreferredSizeChangedMode() = 0;

  
  virtual void ZoomToFindInPageRect(const ::gfx::Rect& rect_in_root_frame) = 0;

  
  virtual void InstallCoopAccessMonitor(::network::mojom::CoopAccessReportType report_type, const ::base::UnguessableToken& accessed_window, ::mojo::PendingRemote<::network::mojom::CrossOriginOpenerPolicyReporter> reporter, bool endpoint_defined, const std::string& reported_window_url) = 0;


  using OnPortalActivatedCallback = base::OnceCallback<void(::blink::mojom::PortalActivateResult)>;
  
  virtual void OnPortalActivated(const ::blink::PortalToken& portal_token, ::mojo::PendingAssociatedRemote<::blink::mojom::Portal> portal, ::mojo::PendingAssociatedReceiver<::blink::mojom::PortalClient> portal_client, ::blink::TransferableMessage data, OnPortalActivatedCallback callback) = 0;

  
  virtual void ForwardMessageFromHost(::blink::TransferableMessage message, const ::url::Origin& source_origin) = 0;
};

class RemoteMainFrameProxy;

template <typename ImplRefTraits>
class RemoteMainFrameStub;

class RemoteMainFrameRequestValidator;


class BLINK_COMMON_EXPORT RemoteMainFrame
    : public RemoteMainFrameInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = RemoteMainFrameInterfaceBase;
  using Proxy_ = RemoteMainFrameProxy;

  template <typename ImplRefTraits>
  using Stub_ = RemoteMainFrameStub<ImplRefTraits>;

  using RequestValidator_ = RemoteMainFrameRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kUpdateTextAutosizerPageInfoMinVersion = 0,
  };
  virtual ~RemoteMainFrame() {}

  
  virtual void UpdateTextAutosizerPageInfo(TextAutosizerPageInfoPtr page_info) = 0;
};

class LocalMainFrameHostProxy;

template <typename ImplRefTraits>
class LocalMainFrameHostStub;

class LocalMainFrameHostRequestValidator;
class LocalMainFrameHostResponseValidator;


class BLINK_COMMON_EXPORT LocalMainFrameHost
    : public LocalMainFrameHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = LocalMainFrameHostInterfaceBase;
  using Proxy_ = LocalMainFrameHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = LocalMainFrameHostStub<ImplRefTraits>;

  using RequestValidator_ = LocalMainFrameHostRequestValidator;
  using ResponseValidator_ = LocalMainFrameHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kScaleFactorChangedMinVersion = 0,
    kContentsPreferredSizeChangedMinVersion = 0,
    kTextAutosizerPageInfoChangedMinVersion = 0,
    kFocusPageMinVersion = 0,
    kUpdateTargetURLMinVersion = 0,
  };
  virtual ~LocalMainFrameHost() {}

  
  virtual void ScaleFactorChanged(float scale) = 0;

  
  virtual void ContentsPreferredSizeChanged(const ::gfx::Size& pref_size) = 0;

  
  virtual void TextAutosizerPageInfoChanged(TextAutosizerPageInfoPtr page_info) = 0;

  
  virtual void FocusPage() = 0;


  using UpdateTargetURLCallback = base::OnceCallback<void()>;
  
  virtual void UpdateTargetURL(const ::GURL& url, UpdateTargetURLCallback callback) = 0;
};

class RemoteMainFrameHostProxy;

template <typename ImplRefTraits>
class RemoteMainFrameHostStub;

class RemoteMainFrameHostRequestValidator;
class RemoteMainFrameHostResponseValidator;


class BLINK_COMMON_EXPORT RemoteMainFrameHost
    : public RemoteMainFrameHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = RemoteMainFrameHostInterfaceBase;
  using Proxy_ = RemoteMainFrameHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = RemoteMainFrameHostStub<ImplRefTraits>;

  using RequestValidator_ = RemoteMainFrameHostRequestValidator;
  using ResponseValidator_ = RemoteMainFrameHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kFocusPageMinVersion = 0,
    kUpdateTargetURLMinVersion = 0,
    kRouteCloseEventMinVersion = 0,
  };
  virtual ~RemoteMainFrameHost() {}

  
  virtual void FocusPage() = 0;


  using UpdateTargetURLCallback = base::OnceCallback<void()>;
  
  virtual void UpdateTargetURL(const ::GURL& url, UpdateTargetURLCallback callback) = 0;

  
  virtual void RouteCloseEvent() = 0;
};



class BLINK_COMMON_EXPORT LocalFrameHostProxy
    : public LocalFrameHost {
 public:
  using InterfaceType = LocalFrameHost;

  explicit LocalFrameHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void EnterFullscreen(::blink::mojom::FullscreenOptionsPtr options, EnterFullscreenCallback callback) final;
  
  void ExitFullscreen() final;
  
  void FullscreenStateChanged(bool is_fullscreen) final;
  
  void RegisterProtocolHandler(const std::string& scheme, const ::GURL& url, const ::base::string16& title, bool user_gesture) final;
  
  void UnregisterProtocolHandler(const std::string& scheme, const ::GURL& url, bool user_gesture) final;
  
  void DidDisplayInsecureContent() final;
  
  void DidContainInsecureFormAction() final;
  
  void DocumentAvailableInMainFrame(bool uses_temporary_zoom_level) final;
  
  void SetNeedsOcclusionTracking(bool needs_tracking) final;
  
  void SetVirtualKeyboardOverlayPolicy(bool vk_overlays_content) final;
  
  void VisibilityChanged(::blink::mojom::FrameVisibility visibility) final;
  
  void DidChangeThemeColor(const base::Optional<::SkColor>& theme_color) final;
  
  void DidChangeBackgroundColor(const ::SkColor& background_color) final;
  
  void DidFailLoadWithError(const ::GURL& url, int32_t error_code) final;
  
  void DidFocusFrame() final;
  
  void DidCallFocus() final;
  
  void DidAddContentSecurityPolicies(std::vector<::network::mojom::ContentSecurityPolicyPtr> policies) final;
  
  void EnforceInsecureRequestPolicy(::blink::mojom::InsecureRequestPolicy policy_bitmap) final;
  
  void EnforceInsecureNavigationsSet(const std::vector<uint32_t>& set) final;
  
  void DidChangeActiveSchedulerTrackedFeatures(uint64_t features_mask) final;
  
  void SuddenTerminationDisablerChanged(bool present, ::blink::mojom::SuddenTerminationDisablerType disabler_type) final;
  
  void HadStickyUserActivationBeforeNavigationChanged(bool has_gesture) final;
  
  void ScrollRectToVisibleInParentFrame(const ::gfx::Rect& rect_to_scroll, ::blink::mojom::ScrollIntoViewParamsPtr params) final;
  
  void BubbleLogicalScrollInParentFrame(::blink::mojom::ScrollDirection direction, ::ui::ScrollGranularity granularity) final;
  
  void DidAccessInitialDocument() final;
  
  void DidBlockNavigation(const ::GURL& blocked_url, const ::GURL& initiator_url, ::blink::mojom::NavigationBlockedReason reason) final;
  
  void DidChangeLoadProgress(double load_progress) final;
  
  void DidFinishLoad(const ::GURL& validated_url) final;
  
  void DispatchLoad() final;
  
  void GoToEntryAtOffset(int32_t offset, bool has_user_gesture) final;
  
  void RenderFallbackContentInParentProcess() final;
  
  void UpdateTitle(const base::Optional<::base::string16>& title, ::base::i18n::TextDirection title_direction) final;
  
  void UpdateUserActivationState(::blink::mojom::UserActivationUpdateType update_type, ::blink::mojom::UserActivationNotificationType notification_type) final;
  
  void HandleAccessibilityFindInPageResult(FindInPageResultAXParamsPtr params) final;
  
  void HandleAccessibilityFindInPageTermination() final;
  
  void DocumentOnLoadCompleted() final;
  
  void ForwardResourceTimingToParent(::blink::mojom::ResourceTimingInfoPtr timing) final;
  
  void DidFinishDocumentLoad() final;
  
  bool RunModalAlertDialog(const ::base::string16& alert_message) final;
  
  void RunModalAlertDialog(const ::base::string16& alert_message, RunModalAlertDialogCallback callback) final;
  
  bool RunModalConfirmDialog(const ::base::string16& alert_message, bool* out_success) final;
  
  void RunModalConfirmDialog(const ::base::string16& alert_message, RunModalConfirmDialogCallback callback) final;
  
  bool RunModalPromptDialog(const ::base::string16& alert_message, const ::base::string16& default_value, bool* out_success, ::base::string16* out_result) final;
  
  void RunModalPromptDialog(const ::base::string16& alert_message, const ::base::string16& default_value, RunModalPromptDialogCallback callback) final;
  
  bool RunBeforeUnloadConfirm(bool is_reload, bool* out_success) final;
  
  void RunBeforeUnloadConfirm(bool is_reload, RunBeforeUnloadConfirmCallback callback) final;
  
  void UpdateFaviconURL(std::vector<::blink::mojom::FaviconURLPtr> favicon_urls) final;
  
  void DownloadURL(DownloadURLParamsPtr params) final;
  
  void FocusedElementChanged(bool is_editable_element, const ::gfx::Rect& bounds_in_frame_widget, ::blink::mojom::FocusType focus_type) final;
  
  void TextSelectionChanged(const ::base::string16& text, uint32_t offset, const ::gfx::Range& range, bool user_initiated) final;
  
  void ShowPopupMenu(::mojo::PendingRemote<::blink::mojom::PopupMenuClient> popup_client, const ::gfx::Rect& bounds, int32_t item_height, double font_size, int32_t selected_item, std::vector<::blink::mojom::MenuItemPtr> menu_items, bool right_aligned, bool allow_multiple_selection) final;
  
  void DidLoadResourceFromMemoryCache(const ::GURL& url, const std::string& http_method, const std::string& mime_type, ::network::mojom::RequestDestination request_destination) final;
  
  void DidChangeFrameOwnerProperties(const ::base::UnguessableToken& child_frame_token, ::blink::mojom::FrameOwnerPropertiesPtr frame_owner_properties) final;
  
  void DidChangeOpener(const base::Optional<::base::UnguessableToken>& opener_frame) final;
  
  void DidChangeFramePolicy(const ::base::UnguessableToken& child_frame_token, const ::blink::FramePolicy& frame_policy) final;
  
  void DidChangeCSPAttribute(const ::base::UnguessableToken& child_frame_token, ::network::mojom::ContentSecurityPolicyPtr parsed_csp_attribute) final;
  
  void CapturePaintPreviewOfSubframe(const ::gfx::Rect& clip_rect, const ::base::UnguessableToken& guid) final;
  
  void Detach() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT LocalFrameProxy
    : public LocalFrame {
 public:
  using InterfaceType = LocalFrame;

  explicit LocalFrameProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetTextSurroundingSelection(uint32_t max_length, GetTextSurroundingSelectionCallback callback) final;
  
  void SendInterventionReport(const std::string& id, const std::string& message) final;
  
  void SetFrameOwnerProperties(::blink::mojom::FrameOwnerPropertiesPtr properties) final;
  
  void NotifyUserActivation(::blink::mojom::UserActivationNotificationType notification_type) final;
  
  void NotifyVirtualKeyboardOverlayRect(const ::gfx::Rect& keyboard_rect) final;
  
  void AddMessageToConsole(::blink::mojom::ConsoleMessageLevel level, const std::string& message, bool discard_duplicates) final;
  
  void AddInspectorIssue(::blink::mojom::InspectorIssueInfoPtr info) final;
  
  void CheckCompleted() final;
  
  void StopLoading() final;
  
  void Collapse(bool collapsed) final;
  
  void EnableViewSourceMode() final;
  
  void Focus() final;
  
  void ClearFocusedElement() final;
  
  void GetResourceSnapshotForWebBundle(::mojo::PendingReceiver<::data_decoder::mojom::ResourceSnapshotForWebBundle> receiver) final;
  
  void CopyImageAt(const ::gfx::Point& window_point) final;
  
  void SaveImageAt(const ::gfx::Point& window_point) final;
  
  void ReportBlinkFeatureUsage(const std::vector<::blink::mojom::WebFeature>& features) final;
  
  void RenderFallbackContent() final;
  
  void BeforeUnload(bool is_reload, BeforeUnloadCallback callback) final;
  
  void MediaPlayerActionAt(const ::gfx::Point& location, ::blink::mojom::MediaPlayerActionPtr action) final;
  
  void AdvanceFocusInFrame(::blink::mojom::FocusType focus_type, const base::Optional<::base::UnguessableToken>& source_frame_token) final;
  
  void AdvanceFocusInForm(::blink::mojom::FocusType focus_type) final;
  
  void ReportContentSecurityPolicyViolation(::network::mojom::CSPViolationPtr violation) final;
  
  void DidUpdateFramePolicy(const ::blink::FramePolicy& frame_policy) final;
  
  void OnScreensChange() final;
  
  void PostMessageEvent(const base::Optional<::base::UnguessableToken>& source_frame_token, const ::base::string16& source_origin, const ::base::string16& target_origin, ::blink::TransferableMessage message) final;
  
  void BindReportingObserver(::mojo::PendingReceiver<::blink::mojom::ReportingObserver> receiver) final;
  
  void UpdateOpener(const base::Optional<::base::UnguessableToken>& opener_frame_token) final;
  
  void GetSavableResourceLinks(GetSavableResourceLinksCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT HighPriorityLocalFrameProxy
    : public HighPriorityLocalFrame {
 public:
  using InterfaceType = HighPriorityLocalFrame;

  explicit HighPriorityLocalFrameProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DispatchBeforeUnload(bool is_reload, DispatchBeforeUnloadCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT RemoteFrameHostProxy
    : public RemoteFrameHost {
 public:
  using InterfaceType = RemoteFrameHost;

  explicit RemoteFrameHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetInheritedEffectiveTouchAction(::cc::TouchAction touch_action) final;
  
  void UpdateRenderThrottlingStatus(bool is_throttled, bool subtree_throttled) final;
  
  void VisibilityChanged(::blink::mojom::FrameVisibility visibility) final;
  
  void DidFocusFrame() final;
  
  void CheckCompleted() final;
  
  void CapturePaintPreviewOfCrossProcessSubframe(const ::gfx::Rect& clip_rect, const ::base::UnguessableToken& guid) final;
  
  void SetIsInert(bool inert) final;
  
  void DidChangeOpener(const base::Optional<::base::UnguessableToken>& opener_frame) final;
  
  void AdvanceFocus(::blink::mojom::FocusType focus_type, const ::base::UnguessableToken& source_frame_token) final;
  
  void RouteMessageEvent(const base::Optional<::base::UnguessableToken>& source_frame_token, const ::base::string16& source_origin, const ::base::string16& target_origin, ::blink::TransferableMessage message) final;
  
  void PrintCrossProcessSubframe(const ::gfx::Rect& frame_content_rect, int32_t document_cookie) final;
  
  void Detach() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT RemoteFrameProxy
    : public RemoteFrame {
 public:
  using InterfaceType = RemoteFrame;

  explicit RemoteFrameProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void WillEnterFullscreen(::blink::mojom::FullscreenOptionsPtr options) final;
  
  void AddReplicatedContentSecurityPolicies(std::vector<::network::mojom::ContentSecurityPolicyHeaderPtr> headers) final;
  
  void ResetReplicatedContentSecurityPolicy() final;
  
  void EnforceInsecureNavigationsSet(const std::vector<uint32_t>& set) final;
  
  void SetFrameOwnerProperties(::blink::mojom::FrameOwnerPropertiesPtr properties) final;
  
  void EnforceInsecureRequestPolicy(::blink::mojom::InsecureRequestPolicy policy) final;
  
  void SetReplicatedOrigin(const ::url::Origin& origin, bool is_potentially_trustworthy_unique_origin) final;
  
  void SetReplicatedAdFrameType(::blink::mojom::AdFrameType ad_frame_type) final;
  
  void SetReplicatedName(const std::string& name, const std::string& unique_name) final;
  
  void DispatchLoadEventForFrameOwner() final;
  
  void SetNeedsOcclusionTracking(bool needs_tracking) final;
  
  void Collapse(bool collapsed) final;
  
  void Focus() final;
  
  void SetHadStickyUserActivationBeforeNavigation(bool has_gesture) final;
  
  void BubbleLogicalScroll(::blink::mojom::ScrollDirection direction, ::ui::ScrollGranularity granularity) final;
  
  void UpdateUserActivationState(::blink::mojom::UserActivationUpdateType state_update_type, ::blink::mojom::UserActivationNotificationType notification_type) final;
  
  void SetEmbeddingToken(const ::base::UnguessableToken& embedding_token) final;
  
  void SetPageFocus(bool is_focused) final;
  
  void RenderFallbackContent() final;
  
  void AddResourceTimingFromChild(::blink::mojom::ResourceTimingInfoPtr timing) final;
  
  void ScrollRectToVisible(const ::gfx::Rect& rect, ::blink::mojom::ScrollIntoViewParamsPtr params) final;
  
  void DidStartLoading() final;
  
  void DidStopLoading() final;
  
  void IntrinsicSizingInfoOfChildChanged(::blink::mojom::IntrinsicSizingInfoPtr sizing_info) final;
  
  void DidSetFramePolicyHeaders(::network::mojom::WebSandboxFlags sandbox_flags, const std::vector<::blink::ParsedFeaturePolicyDeclaration>& parsed_feature_policy) final;
  
  void DidUpdateFramePolicy(const ::blink::FramePolicy& frame_policy) final;
  
  void UpdateOpener(const base::Optional<::base::UnguessableToken>& opener_frame_token) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT LocalMainFrameProxy
    : public LocalMainFrame {
 public:
  using InterfaceType = LocalMainFrame;

  explicit LocalMainFrameProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AnimateDoubleTapZoom(const ::gfx::Point& point, const ::gfx::Rect& rect) final;
  
  void SetScaleFactor(float scale) final;
  
  void ClosePage(ClosePageCallback callback) final;
  
  void PluginActionAt(const ::gfx::Point& location, PluginActionType action) final;
  
  void SetInitialFocus(bool reverse) final;
  
  void EnablePreferredSizeChangedMode() final;
  
  void ZoomToFindInPageRect(const ::gfx::Rect& rect_in_root_frame) final;
  
  void InstallCoopAccessMonitor(::network::mojom::CoopAccessReportType report_type, const ::base::UnguessableToken& accessed_window, ::mojo::PendingRemote<::network::mojom::CrossOriginOpenerPolicyReporter> reporter, bool endpoint_defined, const std::string& reported_window_url) final;
  
  void OnPortalActivated(const ::blink::PortalToken& portal_token, ::mojo::PendingAssociatedRemote<::blink::mojom::Portal> portal, ::mojo::PendingAssociatedReceiver<::blink::mojom::PortalClient> portal_client, ::blink::TransferableMessage data, OnPortalActivatedCallback callback) final;
  
  void ForwardMessageFromHost(::blink::TransferableMessage message, const ::url::Origin& source_origin) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT RemoteMainFrameProxy
    : public RemoteMainFrame {
 public:
  using InterfaceType = RemoteMainFrame;

  explicit RemoteMainFrameProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdateTextAutosizerPageInfo(TextAutosizerPageInfoPtr page_info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT LocalMainFrameHostProxy
    : public LocalMainFrameHost {
 public:
  using InterfaceType = LocalMainFrameHost;

  explicit LocalMainFrameHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ScaleFactorChanged(float scale) final;
  
  void ContentsPreferredSizeChanged(const ::gfx::Size& pref_size) final;
  
  void TextAutosizerPageInfoChanged(TextAutosizerPageInfoPtr page_info) final;
  
  void FocusPage() final;
  
  void UpdateTargetURL(const ::GURL& url, UpdateTargetURLCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT RemoteMainFrameHostProxy
    : public RemoteMainFrameHost {
 public:
  using InterfaceType = RemoteMainFrameHost;

  explicit RemoteMainFrameHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void FocusPage() final;
  
  void UpdateTargetURL(const ::GURL& url, UpdateTargetURLCallback callback) final;
  
  void RouteCloseEvent() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT LocalFrameHostStubDispatch {
 public:
  static bool Accept(LocalFrameHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LocalFrameHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LocalFrameHost>>
class LocalFrameHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LocalFrameHostStub() {}
  ~LocalFrameHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalFrameHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalFrameHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT LocalFrameStubDispatch {
 public:
  static bool Accept(LocalFrame* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LocalFrame* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LocalFrame>>
class LocalFrameStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LocalFrameStub() {}
  ~LocalFrameStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalFrameStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalFrameStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT HighPriorityLocalFrameStubDispatch {
 public:
  static bool Accept(HighPriorityLocalFrame* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HighPriorityLocalFrame* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HighPriorityLocalFrame>>
class HighPriorityLocalFrameStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HighPriorityLocalFrameStub() {}
  ~HighPriorityLocalFrameStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HighPriorityLocalFrameStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HighPriorityLocalFrameStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT RemoteFrameHostStubDispatch {
 public:
  static bool Accept(RemoteFrameHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RemoteFrameHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RemoteFrameHost>>
class RemoteFrameHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RemoteFrameHostStub() {}
  ~RemoteFrameHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RemoteFrameHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RemoteFrameHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT RemoteFrameStubDispatch {
 public:
  static bool Accept(RemoteFrame* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RemoteFrame* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RemoteFrame>>
class RemoteFrameStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RemoteFrameStub() {}
  ~RemoteFrameStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RemoteFrameStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RemoteFrameStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT LocalMainFrameStubDispatch {
 public:
  static bool Accept(LocalMainFrame* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LocalMainFrame* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LocalMainFrame>>
class LocalMainFrameStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LocalMainFrameStub() {}
  ~LocalMainFrameStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalMainFrameStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalMainFrameStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT RemoteMainFrameStubDispatch {
 public:
  static bool Accept(RemoteMainFrame* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RemoteMainFrame* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RemoteMainFrame>>
class RemoteMainFrameStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RemoteMainFrameStub() {}
  ~RemoteMainFrameStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RemoteMainFrameStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RemoteMainFrameStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT LocalMainFrameHostStubDispatch {
 public:
  static bool Accept(LocalMainFrameHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LocalMainFrameHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LocalMainFrameHost>>
class LocalMainFrameHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LocalMainFrameHostStub() {}
  ~LocalMainFrameHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalMainFrameHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LocalMainFrameHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT RemoteMainFrameHostStubDispatch {
 public:
  static bool Accept(RemoteMainFrameHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RemoteMainFrameHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RemoteMainFrameHost>>
class RemoteMainFrameHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RemoteMainFrameHostStub() {}
  ~RemoteMainFrameHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RemoteMainFrameHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RemoteMainFrameHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT LocalFrameHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT LocalFrameRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT HighPriorityLocalFrameRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT RemoteFrameHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT RemoteFrameRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT LocalMainFrameRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT RemoteMainFrameRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT LocalMainFrameHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT RemoteMainFrameHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT LocalFrameHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT LocalFrameResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT HighPriorityLocalFrameResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT LocalMainFrameResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT LocalMainFrameHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT RemoteMainFrameHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class BLINK_COMMON_EXPORT TextAutosizerPageInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TextAutosizerPageInfo, T>::value>;
  using DataView = TextAutosizerPageInfoDataView;
  using Data_ = internal::TextAutosizerPageInfo_Data;

  template <typename... Args>
  static TextAutosizerPageInfoPtr New(Args&&... args) {
    return TextAutosizerPageInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TextAutosizerPageInfoPtr From(const U& u) {
    return mojo::TypeConverter<TextAutosizerPageInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TextAutosizerPageInfo>::Convert(*this);
  }


  TextAutosizerPageInfo();

  TextAutosizerPageInfo(
      int32_t main_frame_width,
      int32_t main_frame_layout_width,
      float device_scale_adjustment);

  ~TextAutosizerPageInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TextAutosizerPageInfoPtr>
  TextAutosizerPageInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TextAutosizerPageInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TextAutosizerPageInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TextAutosizerPageInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TextAutosizerPageInfo_UnserializedMessageContext<
            UserType, TextAutosizerPageInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<TextAutosizerPageInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return TextAutosizerPageInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TextAutosizerPageInfo_UnserializedMessageContext<
            UserType, TextAutosizerPageInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TextAutosizerPageInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t main_frame_width;
  
  int32_t main_frame_layout_width;
  
  float device_scale_adjustment;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TextAutosizerPageInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TextAutosizerPageInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TextAutosizerPageInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TextAutosizerPageInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class BLINK_COMMON_EXPORT SavableSubframe {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SavableSubframe, T>::value>;
  using DataView = SavableSubframeDataView;
  using Data_ = internal::SavableSubframe_Data;

  template <typename... Args>
  static SavableSubframePtr New(Args&&... args) {
    return SavableSubframePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SavableSubframePtr From(const U& u) {
    return mojo::TypeConverter<SavableSubframePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SavableSubframe>::Convert(*this);
  }


  SavableSubframe();

  SavableSubframe(
      const ::GURL& original_url,
      const ::base::UnguessableToken& subframe_token);

  ~SavableSubframe();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SavableSubframePtr>
  SavableSubframePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SavableSubframe::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SavableSubframe::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SavableSubframe::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SavableSubframe_UnserializedMessageContext<
            UserType, SavableSubframe::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SavableSubframe::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return SavableSubframe::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SavableSubframe_UnserializedMessageContext<
            UserType, SavableSubframe::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SavableSubframe::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::GURL original_url;
  
  ::base::UnguessableToken subframe_token;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SavableSubframe::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SavableSubframe::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SavableSubframe::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SavableSubframe::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT GetSavableResourceLinksReply {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GetSavableResourceLinksReply, T>::value>;
  using DataView = GetSavableResourceLinksReplyDataView;
  using Data_ = internal::GetSavableResourceLinksReply_Data;

  template <typename... Args>
  static GetSavableResourceLinksReplyPtr New(Args&&... args) {
    return GetSavableResourceLinksReplyPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GetSavableResourceLinksReplyPtr From(const U& u) {
    return mojo::TypeConverter<GetSavableResourceLinksReplyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetSavableResourceLinksReply>::Convert(*this);
  }


  GetSavableResourceLinksReply();

  GetSavableResourceLinksReply(
      std::vector<::GURL> resources_list,
      ::blink::mojom::ReferrerPtr referrer,
      std::vector<SavableSubframePtr> subframes);

  ~GetSavableResourceLinksReply();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GetSavableResourceLinksReplyPtr>
  GetSavableResourceLinksReplyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GetSavableResourceLinksReply::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetSavableResourceLinksReply::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GetSavableResourceLinksReply_UnserializedMessageContext<
            UserType, GetSavableResourceLinksReply::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<GetSavableResourceLinksReply::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return GetSavableResourceLinksReply::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GetSavableResourceLinksReply_UnserializedMessageContext<
            UserType, GetSavableResourceLinksReply::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GetSavableResourceLinksReply::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::vector<::GURL> resources_list;
  
  ::blink::mojom::ReferrerPtr referrer;
  
  std::vector<SavableSubframePtr> subframes;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(GetSavableResourceLinksReply);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT FindInPageResultAXParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FindInPageResultAXParams, T>::value>;
  using DataView = FindInPageResultAXParamsDataView;
  using Data_ = internal::FindInPageResultAXParams_Data;

  template <typename... Args>
  static FindInPageResultAXParamsPtr New(Args&&... args) {
    return FindInPageResultAXParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FindInPageResultAXParamsPtr From(const U& u) {
    return mojo::TypeConverter<FindInPageResultAXParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FindInPageResultAXParams>::Convert(*this);
  }


  FindInPageResultAXParams();

  FindInPageResultAXParams(
      int32_t request_id,
      int32_t match_index,
      int32_t start_id,
      int32_t start_offset,
      int32_t end_id,
      int32_t end_offset);

  ~FindInPageResultAXParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FindInPageResultAXParamsPtr>
  FindInPageResultAXParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FindInPageResultAXParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FindInPageResultAXParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FindInPageResultAXParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FindInPageResultAXParams_UnserializedMessageContext<
            UserType, FindInPageResultAXParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<FindInPageResultAXParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return FindInPageResultAXParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FindInPageResultAXParams_UnserializedMessageContext<
            UserType, FindInPageResultAXParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FindInPageResultAXParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t request_id;
  
  int32_t match_index;
  
  int32_t start_id;
  
  int32_t start_offset;
  
  int32_t end_id;
  
  int32_t end_offset;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FindInPageResultAXParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FindInPageResultAXParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FindInPageResultAXParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FindInPageResultAXParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT DownloadURLParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DownloadURLParams, T>::value>;
  using DataView = DownloadURLParamsDataView;
  using Data_ = internal::DownloadURLParams_Data;

  template <typename... Args>
  static DownloadURLParamsPtr New(Args&&... args) {
    return DownloadURLParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DownloadURLParamsPtr From(const U& u) {
    return mojo::TypeConverter<DownloadURLParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DownloadURLParams>::Convert(*this);
  }


  DownloadURLParams();

  DownloadURLParams(
      const ::GURL& url,
      ::blink::mojom::ReferrerPtr referrer,
      const base::Optional<::url::Origin>& initiator_origin,
      const base::Optional<::base::string16>& suggested_name,
      ::network::mojom::RedirectMode cross_origin_redirects,
      ::mojo::PendingRemote<::blink::mojom::BlobURLToken> blob_url_token,
      ::mojo::PendingRemote<::blink::mojom::Blob> data_url_blob);

  ~DownloadURLParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DownloadURLParamsPtr>
  DownloadURLParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DownloadURLParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DownloadURLParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DownloadURLParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DownloadURLParams_UnserializedMessageContext<
            UserType, DownloadURLParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DownloadURLParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return DownloadURLParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DownloadURLParams_UnserializedMessageContext<
            UserType, DownloadURLParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DownloadURLParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::GURL url;
  
  ::blink::mojom::ReferrerPtr referrer;
  
  base::Optional<::url::Origin> initiator_origin;
  
  base::Optional<::base::string16> suggested_name;
  
  ::network::mojom::RedirectMode cross_origin_redirects;
  
  ::mojo::PendingRemote<::blink::mojom::BlobURLToken> blob_url_token;
  
  ::mojo::PendingRemote<::blink::mojom::Blob> data_url_blob;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(DownloadURLParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DownloadURLParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DownloadURLParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DownloadURLParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DownloadURLParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
SavableSubframePtr SavableSubframe::Clone() const {
  return New(
      mojo::Clone(original_url),
      mojo::Clone(subframe_token)
  );
}

template <typename T, SavableSubframe::EnableIfSame<T>*>
bool SavableSubframe::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->original_url, other_struct.original_url))
    return false;
  if (!mojo::Equals(this->subframe_token, other_struct.subframe_token))
    return false;
  return true;
}

template <typename T, SavableSubframe::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.original_url, rhs.original_url))
    return true;
  if (std::less<>{}(rhs.original_url, lhs.original_url))
    return false;
  if (std::less<>{}(lhs.subframe_token, rhs.subframe_token))
    return true;
  if (std::less<>{}(rhs.subframe_token, lhs.subframe_token))
    return false;
  return false;
}
template <typename StructPtrType>
GetSavableResourceLinksReplyPtr GetSavableResourceLinksReply::Clone() const {
  return New(
      mojo::Clone(resources_list),
      mojo::Clone(referrer),
      mojo::Clone(subframes)
  );
}

template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>*>
bool GetSavableResourceLinksReply::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->resources_list, other_struct.resources_list))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->subframes, other_struct.subframes))
    return false;
  return true;
}

template <typename T, GetSavableResourceLinksReply::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.resources_list, rhs.resources_list))
    return true;
  if (std::less<>{}(rhs.resources_list, lhs.resources_list))
    return false;
  if (std::less<>{}(lhs.referrer, rhs.referrer))
    return true;
  if (std::less<>{}(rhs.referrer, lhs.referrer))
    return false;
  if (std::less<>{}(lhs.subframes, rhs.subframes))
    return true;
  if (std::less<>{}(rhs.subframes, lhs.subframes))
    return false;
  return false;
}
template <typename StructPtrType>
FindInPageResultAXParamsPtr FindInPageResultAXParams::Clone() const {
  return New(
      mojo::Clone(request_id),
      mojo::Clone(match_index),
      mojo::Clone(start_id),
      mojo::Clone(start_offset),
      mojo::Clone(end_id),
      mojo::Clone(end_offset)
  );
}

template <typename T, FindInPageResultAXParams::EnableIfSame<T>*>
bool FindInPageResultAXParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request_id, other_struct.request_id))
    return false;
  if (!mojo::Equals(this->match_index, other_struct.match_index))
    return false;
  if (!mojo::Equals(this->start_id, other_struct.start_id))
    return false;
  if (!mojo::Equals(this->start_offset, other_struct.start_offset))
    return false;
  if (!mojo::Equals(this->end_id, other_struct.end_id))
    return false;
  if (!mojo::Equals(this->end_offset, other_struct.end_offset))
    return false;
  return true;
}

template <typename T, FindInPageResultAXParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.request_id, rhs.request_id))
    return true;
  if (std::less<>{}(rhs.request_id, lhs.request_id))
    return false;
  if (std::less<>{}(lhs.match_index, rhs.match_index))
    return true;
  if (std::less<>{}(rhs.match_index, lhs.match_index))
    return false;
  if (std::less<>{}(lhs.start_id, rhs.start_id))
    return true;
  if (std::less<>{}(rhs.start_id, lhs.start_id))
    return false;
  if (std::less<>{}(lhs.start_offset, rhs.start_offset))
    return true;
  if (std::less<>{}(rhs.start_offset, lhs.start_offset))
    return false;
  if (std::less<>{}(lhs.end_id, rhs.end_id))
    return true;
  if (std::less<>{}(rhs.end_id, lhs.end_id))
    return false;
  if (std::less<>{}(lhs.end_offset, rhs.end_offset))
    return true;
  if (std::less<>{}(rhs.end_offset, lhs.end_offset))
    return false;
  return false;
}
template <typename StructPtrType>
DownloadURLParamsPtr DownloadURLParams::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(referrer),
      mojo::Clone(initiator_origin),
      mojo::Clone(suggested_name),
      mojo::Clone(cross_origin_redirects),
      mojo::Clone(blob_url_token),
      mojo::Clone(data_url_blob)
  );
}

template <typename T, DownloadURLParams::EnableIfSame<T>*>
bool DownloadURLParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->initiator_origin, other_struct.initiator_origin))
    return false;
  if (!mojo::Equals(this->suggested_name, other_struct.suggested_name))
    return false;
  if (!mojo::Equals(this->cross_origin_redirects, other_struct.cross_origin_redirects))
    return false;
  if (!mojo::Equals(this->blob_url_token, other_struct.blob_url_token))
    return false;
  if (!mojo::Equals(this->data_url_blob, other_struct.data_url_blob))
    return false;
  return true;
}

template <typename T, DownloadURLParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.url, rhs.url))
    return true;
  if (std::less<>{}(rhs.url, lhs.url))
    return false;
  if (std::less<>{}(lhs.referrer, rhs.referrer))
    return true;
  if (std::less<>{}(rhs.referrer, lhs.referrer))
    return false;
  if (std::less<>{}(lhs.initiator_origin, rhs.initiator_origin))
    return true;
  if (std::less<>{}(rhs.initiator_origin, lhs.initiator_origin))
    return false;
  if (std::less<>{}(lhs.suggested_name, rhs.suggested_name))
    return true;
  if (std::less<>{}(rhs.suggested_name, lhs.suggested_name))
    return false;
  if (std::less<>{}(lhs.cross_origin_redirects, rhs.cross_origin_redirects))
    return true;
  if (std::less<>{}(rhs.cross_origin_redirects, lhs.cross_origin_redirects))
    return false;
  if (std::less<>{}(lhs.blob_url_token, rhs.blob_url_token))
    return true;
  if (std::less<>{}(rhs.blob_url_token, lhs.blob_url_token))
    return false;
  if (std::less<>{}(lhs.data_url_blob, rhs.data_url_blob))
    return true;
  if (std::less<>{}(rhs.data_url_blob, lhs.data_url_blob))
    return false;
  return false;
}
template <typename StructPtrType>
TextAutosizerPageInfoPtr TextAutosizerPageInfo::Clone() const {
  return New(
      mojo::Clone(main_frame_width),
      mojo::Clone(main_frame_layout_width),
      mojo::Clone(device_scale_adjustment)
  );
}

template <typename T, TextAutosizerPageInfo::EnableIfSame<T>*>
bool TextAutosizerPageInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->main_frame_width, other_struct.main_frame_width))
    return false;
  if (!mojo::Equals(this->main_frame_layout_width, other_struct.main_frame_layout_width))
    return false;
  if (!mojo::Equals(this->device_scale_adjustment, other_struct.device_scale_adjustment))
    return false;
  return true;
}

template <typename T, TextAutosizerPageInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.main_frame_width, rhs.main_frame_width))
    return true;
  if (std::less<>{}(rhs.main_frame_width, lhs.main_frame_width))
    return false;
  if (std::less<>{}(lhs.main_frame_layout_width, rhs.main_frame_layout_width))
    return true;
  if (std::less<>{}(rhs.main_frame_layout_width, lhs.main_frame_layout_width))
    return false;
  if (std::less<>{}(lhs.device_scale_adjustment, rhs.device_scale_adjustment))
    return true;
  if (std::less<>{}(rhs.device_scale_adjustment, lhs.device_scale_adjustment))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SavableSubframe::DataView,
                                         ::blink::mojom::SavableSubframePtr> {
  static bool IsNull(const ::blink::mojom::SavableSubframePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SavableSubframePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::SavableSubframe::original_url)& original_url(
      const ::blink::mojom::SavableSubframePtr& input) {
    return input->original_url;
  }

  static const decltype(::blink::mojom::SavableSubframe::subframe_token)& subframe_token(
      const ::blink::mojom::SavableSubframePtr& input) {
    return input->subframe_token;
  }

  static bool Read(::blink::mojom::SavableSubframe::DataView input, ::blink::mojom::SavableSubframePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::GetSavableResourceLinksReply::DataView,
                                         ::blink::mojom::GetSavableResourceLinksReplyPtr> {
  static bool IsNull(const ::blink::mojom::GetSavableResourceLinksReplyPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::GetSavableResourceLinksReplyPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::GetSavableResourceLinksReply::resources_list)& resources_list(
      const ::blink::mojom::GetSavableResourceLinksReplyPtr& input) {
    return input->resources_list;
  }

  static const decltype(::blink::mojom::GetSavableResourceLinksReply::referrer)& referrer(
      const ::blink::mojom::GetSavableResourceLinksReplyPtr& input) {
    return input->referrer;
  }

  static const decltype(::blink::mojom::GetSavableResourceLinksReply::subframes)& subframes(
      const ::blink::mojom::GetSavableResourceLinksReplyPtr& input) {
    return input->subframes;
  }

  static bool Read(::blink::mojom::GetSavableResourceLinksReply::DataView input, ::blink::mojom::GetSavableResourceLinksReplyPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::FindInPageResultAXParams::DataView,
                                         ::blink::mojom::FindInPageResultAXParamsPtr> {
  static bool IsNull(const ::blink::mojom::FindInPageResultAXParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::FindInPageResultAXParamsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::FindInPageResultAXParams::request_id) request_id(
      const ::blink::mojom::FindInPageResultAXParamsPtr& input) {
    return input->request_id;
  }

  static decltype(::blink::mojom::FindInPageResultAXParams::match_index) match_index(
      const ::blink::mojom::FindInPageResultAXParamsPtr& input) {
    return input->match_index;
  }

  static decltype(::blink::mojom::FindInPageResultAXParams::start_id) start_id(
      const ::blink::mojom::FindInPageResultAXParamsPtr& input) {
    return input->start_id;
  }

  static decltype(::blink::mojom::FindInPageResultAXParams::start_offset) start_offset(
      const ::blink::mojom::FindInPageResultAXParamsPtr& input) {
    return input->start_offset;
  }

  static decltype(::blink::mojom::FindInPageResultAXParams::end_id) end_id(
      const ::blink::mojom::FindInPageResultAXParamsPtr& input) {
    return input->end_id;
  }

  static decltype(::blink::mojom::FindInPageResultAXParams::end_offset) end_offset(
      const ::blink::mojom::FindInPageResultAXParamsPtr& input) {
    return input->end_offset;
  }

  static bool Read(::blink::mojom::FindInPageResultAXParams::DataView input, ::blink::mojom::FindInPageResultAXParamsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::DownloadURLParams::DataView,
                                         ::blink::mojom::DownloadURLParamsPtr> {
  static bool IsNull(const ::blink::mojom::DownloadURLParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::DownloadURLParamsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::DownloadURLParams::url)& url(
      const ::blink::mojom::DownloadURLParamsPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::DownloadURLParams::referrer)& referrer(
      const ::blink::mojom::DownloadURLParamsPtr& input) {
    return input->referrer;
  }

  static const decltype(::blink::mojom::DownloadURLParams::initiator_origin)& initiator_origin(
      const ::blink::mojom::DownloadURLParamsPtr& input) {
    return input->initiator_origin;
  }

  static const decltype(::blink::mojom::DownloadURLParams::suggested_name)& suggested_name(
      const ::blink::mojom::DownloadURLParamsPtr& input) {
    return input->suggested_name;
  }

  static decltype(::blink::mojom::DownloadURLParams::cross_origin_redirects) cross_origin_redirects(
      const ::blink::mojom::DownloadURLParamsPtr& input) {
    return input->cross_origin_redirects;
  }

  static  decltype(::blink::mojom::DownloadURLParams::blob_url_token)& blob_url_token(
       ::blink::mojom::DownloadURLParamsPtr& input) {
    return input->blob_url_token;
  }

  static  decltype(::blink::mojom::DownloadURLParams::data_url_blob)& data_url_blob(
       ::blink::mojom::DownloadURLParamsPtr& input) {
    return input->data_url_blob;
  }

  static bool Read(::blink::mojom::DownloadURLParams::DataView input, ::blink::mojom::DownloadURLParamsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::TextAutosizerPageInfo::DataView,
                                         ::blink::mojom::TextAutosizerPageInfoPtr> {
  static bool IsNull(const ::blink::mojom::TextAutosizerPageInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::TextAutosizerPageInfoPtr* output) { output->reset(); }

  static decltype(::blink::mojom::TextAutosizerPageInfo::main_frame_width) main_frame_width(
      const ::blink::mojom::TextAutosizerPageInfoPtr& input) {
    return input->main_frame_width;
  }

  static decltype(::blink::mojom::TextAutosizerPageInfo::main_frame_layout_width) main_frame_layout_width(
      const ::blink::mojom::TextAutosizerPageInfoPtr& input) {
    return input->main_frame_layout_width;
  }

  static decltype(::blink::mojom::TextAutosizerPageInfo::device_scale_adjustment) device_scale_adjustment(
      const ::blink::mojom::TextAutosizerPageInfoPtr& input) {
    return input->device_scale_adjustment;
  }

  static bool Read(::blink::mojom::TextAutosizerPageInfo::DataView input, ::blink::mojom::TextAutosizerPageInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_FRAME_MOJOM_H_