// third_party/blink/public/mojom/fetch/fetch_api_response.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/fetch/fetch_api_response.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/fetch/fetch_api_response.mojom-params-data.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_response.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/fetch/fetch_api_response.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_RESPONSE_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FETCH_FETCH_API_RESPONSE_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
FetchAPIResponse::FetchAPIResponse()
    : url_list(),
      status_code(0U),
      status_text(),
      response_type(::network::mojom::FetchResponseType::kDefault),
      padding(0),
      response_source(::network::mojom::FetchResponseSource::kUnspecified),
      headers(),
      mime_type(),
      request_method(),
      blob(),
      error(::blink::mojom::ServiceWorkerResponseError::kUnknown),
      response_time(),
      cache_storage_cache_name(),
      cors_exposed_header_names(),
      side_data_blob(),
      side_data_blob_for_cache_put(),
      parsed_headers(),
      connection_info(),
      alpn_negotiated_protocol("unknown"),
      was_fetched_via_spdy(false),
      has_range_requested(false) {}

FetchAPIResponse::FetchAPIResponse(
    std::vector<::GURL> url_list_in,
    uint16_t status_code_in,
    const std::string& status_text_in,
    ::network::mojom::FetchResponseType response_type_in,
    int64_t padding_in,
    ::network::mojom::FetchResponseSource response_source_in,
    const base::flat_map<std::string, std::string>& headers_in,
    const base::Optional<std::string>& mime_type_in,
    const base::Optional<std::string>& request_method_in,
    ::blink::mojom::SerializedBlobPtr blob_in,
    ::blink::mojom::ServiceWorkerResponseError error_in,
    ::base::Time response_time_in,
    const base::Optional<std::string>& cache_storage_cache_name_in,
    std::vector<std::string> cors_exposed_header_names_in,
    ::blink::mojom::SerializedBlobPtr side_data_blob_in,
    ::blink::mojom::SerializedBlobPtr side_data_blob_for_cache_put_in,
    ::network::mojom::ParsedHeadersPtr parsed_headers_in,
    ::net::HttpResponseInfo::ConnectionInfo connection_info_in,
    const std::string& alpn_negotiated_protocol_in,
    bool was_fetched_via_spdy_in,
    bool has_range_requested_in)
    : url_list(std::move(url_list_in)),
      status_code(std::move(status_code_in)),
      status_text(std::move(status_text_in)),
      response_type(std::move(response_type_in)),
      padding(std::move(padding_in)),
      response_source(std::move(response_source_in)),
      headers(std::move(headers_in)),
      mime_type(std::move(mime_type_in)),
      request_method(std::move(request_method_in)),
      blob(std::move(blob_in)),
      error(std::move(error_in)),
      response_time(std::move(response_time_in)),
      cache_storage_cache_name(std::move(cache_storage_cache_name_in)),
      cors_exposed_header_names(std::move(cors_exposed_header_names_in)),
      side_data_blob(std::move(side_data_blob_in)),
      side_data_blob_for_cache_put(std::move(side_data_blob_for_cache_put_in)),
      parsed_headers(std::move(parsed_headers_in)),
      connection_info(std::move(connection_info_in)),
      alpn_negotiated_protocol(std::move(alpn_negotiated_protocol_in)),
      was_fetched_via_spdy(std::move(was_fetched_via_spdy_in)),
      has_range_requested(std::move(has_range_requested_in)) {}

FetchAPIResponse::~FetchAPIResponse() = default;

void FetchAPIResponse::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("url_list");
  for (const auto& item0 : this->url_list) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::GURL&>"));
  }
  value->EndArray();
  value->SetInteger("status_code", this->status_code);
  value->SetString("status_text", this->status_text);
  value->SetString("response_type", base::trace_event::ValueToString(this->response_type));
  value->SetString("padding", base::NumberToString(this->padding));
  value->SetString("response_source", base::trace_event::ValueToString(this->response_source));
  value->BeginDictionary("headers");
  for (const auto& item0 : this->headers) {
    value->SetStringWithCopiedName(base::trace_event::ValueToString(item0.first, "<value of type const std::string&>"), item0.second);
  }
  value->EndDictionary();
  if (this->mime_type.has_value()) {
    value->SetString("mime_type", this->mime_type.value());
  } else {
    value->SetString("mime_type", "base::nullopt");
  }
  if (this->request_method.has_value()) {
    value->SetString("request_method", this->request_method.value());
  } else {
    value->SetString("request_method", "base::nullopt");
  }
  if (this->blob.is_null()) {
    value->SetString("blob", "nullptr");
  } else {
    value->BeginDictionary("blob");
    this->blob->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("error", base::trace_event::ValueToString(this->error));
  value->SetString("response_time", base::trace_event::ValueToString(this->response_time, "<value of type ::base::Time>"));
  if (this->cache_storage_cache_name.has_value()) {
    value->SetString("cache_storage_cache_name", this->cache_storage_cache_name.value());
  } else {
    value->SetString("cache_storage_cache_name", "base::nullopt");
  }
  value->BeginArray("cors_exposed_header_names");
  for (const auto& item0 : this->cors_exposed_header_names) {
    value->AppendString(item0);
  }
  value->EndArray();
  if (this->side_data_blob.is_null()) {
    value->SetString("side_data_blob", "nullptr");
  } else {
    value->BeginDictionary("side_data_blob");
    this->side_data_blob->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->side_data_blob_for_cache_put.is_null()) {
    value->SetString("side_data_blob_for_cache_put", "nullptr");
  } else {
    value->BeginDictionary("side_data_blob_for_cache_put");
    this->side_data_blob_for_cache_put->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->parsed_headers.is_null()) {
    value->SetString("parsed_headers", "nullptr");
  } else {
    value->BeginDictionary("parsed_headers");
    this->parsed_headers->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetInteger("connection_info", static_cast<int>(this->connection_info));
  value->SetString("alpn_negotiated_protocol", this->alpn_negotiated_protocol);
  value->SetBoolean("was_fetched_via_spdy", this->was_fetched_via_spdy);
  value->SetBoolean("has_range_requested", this->has_range_requested);
}

bool FetchAPIResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::FetchAPIResponse::DataView, ::blink::mojom::FetchAPIResponsePtr>::Read(
    ::blink::mojom::FetchAPIResponse::DataView input,
    ::blink::mojom::FetchAPIResponsePtr* output) {
  bool success = true;
  ::blink::mojom::FetchAPIResponsePtr result(::blink::mojom::FetchAPIResponse::New());
  
      if (success && !input.ReadUrlList(&result->url_list))
        success = false;
      if (success)
        result->status_code = input.status_code();
      if (success && !input.ReadStatusText(&result->status_text))
        success = false;
      if (success && !input.ReadResponseType(&result->response_type))
        success = false;
      if (success)
        result->padding = input.padding();
      if (success && !input.ReadResponseSource(&result->response_source))
        success = false;
      if (success && !input.ReadHeaders(&result->headers))
        success = false;
      if (success && !input.ReadMimeType(&result->mime_type))
        success = false;
      if (success && !input.ReadRequestMethod(&result->request_method))
        success = false;
      if (success && !input.ReadBlob(&result->blob))
        success = false;
      if (success && !input.ReadError(&result->error))
        success = false;
      if (success && !input.ReadResponseTime(&result->response_time))
        success = false;
      if (success && !input.ReadCacheStorageCacheName(&result->cache_storage_cache_name))
        success = false;
      if (success && !input.ReadCorsExposedHeaderNames(&result->cors_exposed_header_names))
        success = false;
      if (success && !input.ReadSideDataBlob(&result->side_data_blob))
        success = false;
      if (success && !input.ReadSideDataBlobForCachePut(&result->side_data_blob_for_cache_put))
        success = false;
      if (success && !input.ReadParsedHeaders(&result->parsed_headers))
        success = false;
      if (success && !input.ReadConnectionInfo(&result->connection_info))
        success = false;
      if (success && !input.ReadAlpnNegotiatedProtocol(&result->alpn_negotiated_protocol))
        success = false;
      if (success)
        result->was_fetched_via_spdy = input.was_fetched_via_spdy();
      if (success)
        result->has_range_requested = input.has_range_requested();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif