// third_party/blink/public/mojom/feature_policy/feature_policy.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FEATURE_POLICY_FEATURE_POLICY_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FEATURE_POLICY_FEATURE_POLICY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/feature_policy/feature_policy.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"
#include "third_party/blink/public/mojom/feature_policy/feature_policy_feature.mojom-shared.h"



#include "base/component_export.h"




namespace blink {
namespace mojom {
class ParsedFeaturePolicyDeclarationDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ParsedFeaturePolicyDeclarationDataView> {
  using Data = ::blink::mojom::internal::ParsedFeaturePolicyDeclaration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


class ParsedFeaturePolicyDeclarationDataView {
 public:
  ParsedFeaturePolicyDeclarationDataView() {}

  ParsedFeaturePolicyDeclarationDataView(
      internal::ParsedFeaturePolicyDeclaration_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFeature(UserType* output) const {
    auto data_value = data_->feature;
    return mojo::internal::Deserialize<::blink::mojom::FeaturePolicyFeature>(
        data_value, output);
  }

  ::blink::mojom::FeaturePolicyFeature feature() const {
    return static_cast<::blink::mojom::FeaturePolicyFeature>(data_->feature);
  }
  inline void GetAllowedOriginsDataView(
      mojo::ArrayDataView<::url::mojom::OriginDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAllowedOrigins(UserType* output) {
    
    auto* pointer = data_->allowed_origins.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
        pointer, output, context_);
  }
  bool matches_all_origins() const {
    return data_->matches_all_origins;
  }
  bool matches_opaque_src() const {
    return data_->matches_opaque_src;
  }
 private:
  internal::ParsedFeaturePolicyDeclaration_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ParsedFeaturePolicyDeclarationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ParsedFeaturePolicyDeclarationDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::ParsedFeaturePolicyDeclaration_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::blink::mojom::FeaturePolicyFeature>(
        Traits::feature(input), &(*output)->feature);
    decltype(Traits::allowed_origins(input)) in_allowed_origins = Traits::allowed_origins(input);
    typename decltype((*output)->allowed_origins)::BaseType::BufferWriter
        allowed_origins_writer;
    const mojo::internal::ContainerValidateParams allowed_origins_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
        in_allowed_origins, buffer, &allowed_origins_writer, &allowed_origins_validate_params,
        context);
    (*output)->allowed_origins.Set(
        allowed_origins_writer.is_null() ? nullptr : allowed_origins_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->allowed_origins.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null allowed_origins in ParsedFeaturePolicyDeclaration struct");
    (*output)->matches_all_origins = Traits::matches_all_origins(input);
    (*output)->matches_opaque_src = Traits::matches_opaque_src(input);
  }

  static bool Deserialize(::blink::mojom::internal::ParsedFeaturePolicyDeclaration_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ParsedFeaturePolicyDeclarationDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void ParsedFeaturePolicyDeclarationDataView::GetAllowedOriginsDataView(
    mojo::ArrayDataView<::url::mojom::OriginDataView>* output) {
  auto pointer = data_->allowed_origins.Get();
  *output = mojo::ArrayDataView<::url::mojom::OriginDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FEATURE_POLICY_FEATURE_POLICY_MOJOM_SHARED_H_