// third_party/blink/public/mojom/digital_goods/digital_goods.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIGITAL_GOODS_DIGITAL_GOODS_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIGITAL_GOODS_DIGITAL_GOODS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/digital_goods/digital_goods.mojom-shared-internal.h"
#include "components/payments/mojom/payment_request_data.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace payments {
namespace mojom {
class ItemDetailsDataView;



}  // namespace mojom
}  // namespace payments

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::payments::mojom::ItemDetailsDataView> {
  using Data = ::payments::mojom::internal::ItemDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace payments {
namespace mojom {


enum class BillingResponseCode : int32_t {
  
  kOk = 0,
  
  kError = 1,
  
  kItemAlreadyOwned = 2,
  
  kItemNotOwned = 3,
  
  kItemUnavailable = 4,
  
  kClientAppUnavailable = 5,
  
  kClientAppError = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, BillingResponseCode value);
inline bool IsKnownEnumValue(BillingResponseCode value) {
  return internal::BillingResponseCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CreateDigitalGoodsResponseCode : int32_t {
  
  kOk = 0,
  
  kError = 1,
  
  kUnsupportedPaymentMethod = 2,
  
  kUnsupportedContext = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, CreateDigitalGoodsResponseCode value);
inline bool IsKnownEnumValue(CreateDigitalGoodsResponseCode value) {
  return internal::CreateDigitalGoodsResponseCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class DigitalGoodsInterfaceBase {};

using DigitalGoodsPtrDataView =
    mojo::InterfacePtrDataView<DigitalGoodsInterfaceBase>;
using DigitalGoodsRequestDataView =
    mojo::InterfaceRequestDataView<DigitalGoodsInterfaceBase>;
using DigitalGoodsAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DigitalGoodsInterfaceBase>;
using DigitalGoodsAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DigitalGoodsInterfaceBase>;
class DigitalGoodsFactoryInterfaceBase {};

using DigitalGoodsFactoryPtrDataView =
    mojo::InterfacePtrDataView<DigitalGoodsFactoryInterfaceBase>;
using DigitalGoodsFactoryRequestDataView =
    mojo::InterfaceRequestDataView<DigitalGoodsFactoryInterfaceBase>;
using DigitalGoodsFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DigitalGoodsFactoryInterfaceBase>;
using DigitalGoodsFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DigitalGoodsFactoryInterfaceBase>;


class ItemDetailsDataView {
 public:
  ItemDetailsDataView() {}

  ItemDetailsDataView(
      internal::ItemDetails_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetItemIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadItemId(UserType* output) {
    
    auto* pointer = data_->item_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetPriceDataView(
      ::payments::mojom::PaymentCurrencyAmountDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPrice(UserType* output) {
    
    auto* pointer = data_->price.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentCurrencyAmountDataView>(
        pointer, output, context_);
  }
 private:
  internal::ItemDetails_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace payments

namespace std {

template <>
struct hash<::payments::mojom::BillingResponseCode>
    : public mojo::internal::EnumHashImpl<::payments::mojom::BillingResponseCode> {};

template <>
struct hash<::payments::mojom::CreateDigitalGoodsResponseCode>
    : public mojo::internal::EnumHashImpl<::payments::mojom::CreateDigitalGoodsResponseCode> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::payments::mojom::BillingResponseCode, ::payments::mojom::BillingResponseCode> {
  static ::payments::mojom::BillingResponseCode ToMojom(::payments::mojom::BillingResponseCode input) { return input; }
  static bool FromMojom(::payments::mojom::BillingResponseCode input, ::payments::mojom::BillingResponseCode* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::BillingResponseCode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::BillingResponseCode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::payments::mojom::BillingResponseCode>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::payments::mojom::CreateDigitalGoodsResponseCode, ::payments::mojom::CreateDigitalGoodsResponseCode> {
  static ::payments::mojom::CreateDigitalGoodsResponseCode ToMojom(::payments::mojom::CreateDigitalGoodsResponseCode input) { return input; }
  static bool FromMojom(::payments::mojom::CreateDigitalGoodsResponseCode input, ::payments::mojom::CreateDigitalGoodsResponseCode* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::CreateDigitalGoodsResponseCode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::CreateDigitalGoodsResponseCode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::payments::mojom::CreateDigitalGoodsResponseCode>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::ItemDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::ItemDetailsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::payments::mojom::internal::ItemDetails_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::item_id(input)) in_item_id = Traits::item_id(input);
    typename decltype((*output)->item_id)::BaseType::BufferWriter
        item_id_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_item_id, buffer, &item_id_writer, context);
    (*output)->item_id.Set(
        item_id_writer.is_null() ? nullptr : item_id_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->item_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null item_id in ItemDetails struct");
    decltype(Traits::title(input)) in_title = Traits::title(input);
    typename decltype((*output)->title)::BaseType::BufferWriter
        title_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_title, buffer, &title_writer, context);
    (*output)->title.Set(
        title_writer.is_null() ? nullptr : title_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->title.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in ItemDetails struct");
    decltype(Traits::description(input)) in_description = Traits::description(input);
    typename decltype((*output)->description)::BaseType::BufferWriter
        description_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_description, buffer, &description_writer, context);
    (*output)->description.Set(
        description_writer.is_null() ? nullptr : description_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->description.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null description in ItemDetails struct");
    decltype(Traits::price(input)) in_price = Traits::price(input);
    typename decltype((*output)->price)::BaseType::BufferWriter
        price_writer;
    mojo::internal::Serialize<::payments::mojom::PaymentCurrencyAmountDataView>(
        in_price, buffer, &price_writer, context);
    (*output)->price.Set(
        price_writer.is_null() ? nullptr : price_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->price.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null price in ItemDetails struct");
  }

  static bool Deserialize(::payments::mojom::internal::ItemDetails_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::ItemDetailsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace payments {
namespace mojom {

inline void ItemDetailsDataView::GetItemIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->item_id.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void ItemDetailsDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void ItemDetailsDataView::GetDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void ItemDetailsDataView::GetPriceDataView(
    ::payments::mojom::PaymentCurrencyAmountDataView* output) {
  auto pointer = data_->price.Get();
  *output = ::payments::mojom::PaymentCurrencyAmountDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace payments

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIGITAL_GOODS_DIGITAL_GOODS_MOJOM_SHARED_H_