// third_party/blink/public/mojom/devtools/inspector_issue.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_INSPECTOR_ISSUE_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_INSPECTOR_ISSUE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-blink-forward.h"
#include "url/mojom/url.mojom-blink.h"
#include "services/network/public/mojom/cookie_manager.mojom-blink.h"
#include "services/network/public/mojom/blocked_by_response_reason.mojom-blink-forward.h"
#include "services/network/public/mojom/source_location.mojom-blink.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"




namespace WTF {
struct blink_mojom_internal_InspectorIssueCode_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::InspectorIssueCode& value) {
    using utype = std::underlying_type<::blink::mojom::InspectorIssueCode>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::InspectorIssueCode& left, const ::blink::mojom::InspectorIssueCode& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::InspectorIssueCode>
    : public GenericHashTraits<::blink::mojom::InspectorIssueCode> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::InspectorIssueCode& value) {
    return value == static_cast<::blink::mojom::InspectorIssueCode>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::InspectorIssueCode& slot, bool) {
    slot = static_cast<::blink::mojom::InspectorIssueCode>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::InspectorIssueCode& value) {
    return value == static_cast<::blink::mojom::InspectorIssueCode>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct blink_mojom_internal_HeavyAdResolutionStatus_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::HeavyAdResolutionStatus& value) {
    using utype = std::underlying_type<::blink::mojom::HeavyAdResolutionStatus>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::HeavyAdResolutionStatus& left, const ::blink::mojom::HeavyAdResolutionStatus& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::HeavyAdResolutionStatus>
    : public GenericHashTraits<::blink::mojom::HeavyAdResolutionStatus> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::HeavyAdResolutionStatus& value) {
    return value == static_cast<::blink::mojom::HeavyAdResolutionStatus>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::HeavyAdResolutionStatus& slot, bool) {
    slot = static_cast<::blink::mojom::HeavyAdResolutionStatus>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::HeavyAdResolutionStatus& value) {
    return value == static_cast<::blink::mojom::HeavyAdResolutionStatus>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct blink_mojom_internal_HeavyAdReason_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::HeavyAdReason& value) {
    using utype = std::underlying_type<::blink::mojom::HeavyAdReason>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::HeavyAdReason& left, const ::blink::mojom::HeavyAdReason& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::HeavyAdReason>
    : public GenericHashTraits<::blink::mojom::HeavyAdReason> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::HeavyAdReason& value) {
    return value == static_cast<::blink::mojom::HeavyAdReason>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::HeavyAdReason& slot, bool) {
    slot = static_cast<::blink::mojom::HeavyAdReason>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::HeavyAdReason& value) {
    return value == static_cast<::blink::mojom::HeavyAdReason>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct blink_mojom_internal_MixedContentResolutionStatus_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::MixedContentResolutionStatus& value) {
    using utype = std::underlying_type<::blink::mojom::MixedContentResolutionStatus>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::MixedContentResolutionStatus& left, const ::blink::mojom::MixedContentResolutionStatus& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::MixedContentResolutionStatus>
    : public GenericHashTraits<::blink::mojom::MixedContentResolutionStatus> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::MixedContentResolutionStatus& value) {
    return value == static_cast<::blink::mojom::MixedContentResolutionStatus>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::MixedContentResolutionStatus& slot, bool) {
    slot = static_cast<::blink::mojom::MixedContentResolutionStatus>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::MixedContentResolutionStatus& value) {
    return value == static_cast<::blink::mojom::MixedContentResolutionStatus>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct blink_mojom_internal_ContentSecurityPolicyViolationType_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::ContentSecurityPolicyViolationType& value) {
    using utype = std::underlying_type<::blink::mojom::ContentSecurityPolicyViolationType>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::ContentSecurityPolicyViolationType& left, const ::blink::mojom::ContentSecurityPolicyViolationType& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::ContentSecurityPolicyViolationType>
    : public GenericHashTraits<::blink::mojom::ContentSecurityPolicyViolationType> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::ContentSecurityPolicyViolationType& value) {
    return value == static_cast<::blink::mojom::ContentSecurityPolicyViolationType>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::ContentSecurityPolicyViolationType& slot, bool) {
    slot = static_cast<::blink::mojom::ContentSecurityPolicyViolationType>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::ContentSecurityPolicyViolationType& value) {
    return value == static_cast<::blink::mojom::ContentSecurityPolicyViolationType>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct blink_mojom_internal_SameSiteCookieOperation_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::SameSiteCookieOperation& value) {
    using utype = std::underlying_type<::blink::mojom::SameSiteCookieOperation>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::SameSiteCookieOperation& left, const ::blink::mojom::SameSiteCookieOperation& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::SameSiteCookieOperation>
    : public GenericHashTraits<::blink::mojom::SameSiteCookieOperation> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::SameSiteCookieOperation& value) {
    return value == static_cast<::blink::mojom::SameSiteCookieOperation>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::SameSiteCookieOperation& slot, bool) {
    slot = static_cast<::blink::mojom::SameSiteCookieOperation>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::SameSiteCookieOperation& value) {
    return value == static_cast<::blink::mojom::SameSiteCookieOperation>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct blink_mojom_internal_SameSiteCookieExclusionReason_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::SameSiteCookieExclusionReason& value) {
    using utype = std::underlying_type<::blink::mojom::SameSiteCookieExclusionReason>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::SameSiteCookieExclusionReason& left, const ::blink::mojom::SameSiteCookieExclusionReason& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::SameSiteCookieExclusionReason>
    : public GenericHashTraits<::blink::mojom::SameSiteCookieExclusionReason> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::SameSiteCookieExclusionReason& value) {
    return value == static_cast<::blink::mojom::SameSiteCookieExclusionReason>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::SameSiteCookieExclusionReason& slot, bool) {
    slot = static_cast<::blink::mojom::SameSiteCookieExclusionReason>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::SameSiteCookieExclusionReason& value) {
    return value == static_cast<::blink::mojom::SameSiteCookieExclusionReason>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct blink_mojom_internal_SameSiteCookieWarningReason_DataHashFn {
  static unsigned GetHash(const ::blink::mojom::SameSiteCookieWarningReason& value) {
    using utype = std::underlying_type<::blink::mojom::SameSiteCookieWarningReason>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::blink::mojom::SameSiteCookieWarningReason& left, const ::blink::mojom::SameSiteCookieWarningReason& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::blink::mojom::SameSiteCookieWarningReason>
    : public GenericHashTraits<::blink::mojom::SameSiteCookieWarningReason> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::blink::mojom::SameSiteCookieWarningReason& value) {
    return value == static_cast<::blink::mojom::SameSiteCookieWarningReason>(-1000000);
  }
  static void ConstructDeletedValue(::blink::mojom::SameSiteCookieWarningReason& slot, bool) {
    slot = static_cast<::blink::mojom::SameSiteCookieWarningReason>(-1000001);
  }
  static bool IsDeletedValue(const ::blink::mojom::SameSiteCookieWarningReason& value) {
    return value == static_cast<::blink::mojom::SameSiteCookieWarningReason>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {





class PLATFORM_EXPORT AffectedCookie {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AffectedCookie, T>::value>;
  using DataView = AffectedCookieDataView;
  using Data_ = internal::AffectedCookie_Data;

  template <typename... Args>
  static AffectedCookiePtr New(Args&&... args) {
    return AffectedCookiePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AffectedCookiePtr From(const U& u) {
    return mojo::TypeConverter<AffectedCookiePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AffectedCookie>::Convert(*this);
  }


  AffectedCookie();

  AffectedCookie(
      const WTF::String& name,
      const WTF::String& path,
      const WTF::String& domain);

  ~AffectedCookie();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AffectedCookiePtr>
  AffectedCookiePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AffectedCookie::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AffectedCookie::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AffectedCookie::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AffectedCookie_UnserializedMessageContext<
            UserType, AffectedCookie::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<AffectedCookie::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return AffectedCookie::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AffectedCookie_UnserializedMessageContext<
            UserType, AffectedCookie::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AffectedCookie::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String name;
  
  WTF::String path;
  
  WTF::String domain;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AffectedCookie::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AffectedCookie::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AffectedCookie::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AffectedCookie::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AffectedRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AffectedRequest, T>::value>;
  using DataView = AffectedRequestDataView;
  using Data_ = internal::AffectedRequest_Data;

  template <typename... Args>
  static AffectedRequestPtr New(Args&&... args) {
    return AffectedRequestPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AffectedRequestPtr From(const U& u) {
    return mojo::TypeConverter<AffectedRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AffectedRequest>::Convert(*this);
  }


  AffectedRequest();

  AffectedRequest(
      const WTF::String& request_id,
      const WTF::String& url);

  ~AffectedRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AffectedRequestPtr>
  AffectedRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AffectedRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AffectedRequest::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AffectedRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AffectedRequest_UnserializedMessageContext<
            UserType, AffectedRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<AffectedRequest::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return AffectedRequest::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AffectedRequest_UnserializedMessageContext<
            UserType, AffectedRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AffectedRequest::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String request_id;
  
  WTF::String url;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AffectedRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AffectedRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AffectedRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AffectedRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT AffectedFrame {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AffectedFrame, T>::value>;
  using DataView = AffectedFrameDataView;
  using Data_ = internal::AffectedFrame_Data;

  template <typename... Args>
  static AffectedFramePtr New(Args&&... args) {
    return AffectedFramePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AffectedFramePtr From(const U& u) {
    return mojo::TypeConverter<AffectedFramePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AffectedFrame>::Convert(*this);
  }


  AffectedFrame();

  explicit AffectedFrame(
      const WTF::String& frame_id);

  ~AffectedFrame();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AffectedFramePtr>
  AffectedFramePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AffectedFrame::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AffectedFrame::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AffectedFrame::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AffectedFrame_UnserializedMessageContext<
            UserType, AffectedFrame::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<AffectedFrame::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return AffectedFrame::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AffectedFrame_UnserializedMessageContext<
            UserType, AffectedFrame::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AffectedFrame::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String frame_id;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AffectedFrame::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AffectedFrame::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AffectedFrame::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AffectedFrame::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}
















class PLATFORM_EXPORT BlockedByResponseIssueDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BlockedByResponseIssueDetails, T>::value>;
  using DataView = BlockedByResponseIssueDetailsDataView;
  using Data_ = internal::BlockedByResponseIssueDetails_Data;

  template <typename... Args>
  static BlockedByResponseIssueDetailsPtr New(Args&&... args) {
    return BlockedByResponseIssueDetailsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BlockedByResponseIssueDetailsPtr From(const U& u) {
    return mojo::TypeConverter<BlockedByResponseIssueDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BlockedByResponseIssueDetails>::Convert(*this);
  }


  BlockedByResponseIssueDetails();

  BlockedByResponseIssueDetails(
      AffectedRequestPtr request,
      AffectedFramePtr parentFrame,
      AffectedFramePtr blockedFrame,
      ::network::mojom::blink::BlockedByResponseReason reason);

  ~BlockedByResponseIssueDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BlockedByResponseIssueDetailsPtr>
  BlockedByResponseIssueDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BlockedByResponseIssueDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BlockedByResponseIssueDetails::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BlockedByResponseIssueDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BlockedByResponseIssueDetails_UnserializedMessageContext<
            UserType, BlockedByResponseIssueDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<BlockedByResponseIssueDetails::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return BlockedByResponseIssueDetails::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BlockedByResponseIssueDetails_UnserializedMessageContext<
            UserType, BlockedByResponseIssueDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BlockedByResponseIssueDetails::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  AffectedRequestPtr request;
  
  AffectedFramePtr parentFrame;
  
  AffectedFramePtr blockedFrame;
  
  ::network::mojom::blink::BlockedByResponseReason reason;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(BlockedByResponseIssueDetails);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BlockedByResponseIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BlockedByResponseIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BlockedByResponseIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BlockedByResponseIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT MixedContentIssueDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MixedContentIssueDetails, T>::value>;
  using DataView = MixedContentIssueDetailsDataView;
  using Data_ = internal::MixedContentIssueDetails_Data;

  template <typename... Args>
  static MixedContentIssueDetailsPtr New(Args&&... args) {
    return MixedContentIssueDetailsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MixedContentIssueDetailsPtr From(const U& u) {
    return mojo::TypeConverter<MixedContentIssueDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MixedContentIssueDetails>::Convert(*this);
  }


  MixedContentIssueDetails();

  MixedContentIssueDetails(
      ::blink::mojom::blink::RequestContextType request_context,
      MixedContentResolutionStatus resolution_status,
      const WTF::String& insecure_url,
      const WTF::String& main_resource_url,
      AffectedRequestPtr request,
      AffectedFramePtr frame);

  ~MixedContentIssueDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MixedContentIssueDetailsPtr>
  MixedContentIssueDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MixedContentIssueDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MixedContentIssueDetails::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MixedContentIssueDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MixedContentIssueDetails_UnserializedMessageContext<
            UserType, MixedContentIssueDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<MixedContentIssueDetails::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return MixedContentIssueDetails::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MixedContentIssueDetails_UnserializedMessageContext<
            UserType, MixedContentIssueDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MixedContentIssueDetails::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::blink::mojom::blink::RequestContextType request_context;
  
  MixedContentResolutionStatus resolution_status;
  
  WTF::String insecure_url;
  
  WTF::String main_resource_url;
  
  AffectedRequestPtr request;
  
  AffectedFramePtr frame;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(MixedContentIssueDetails);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MixedContentIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MixedContentIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MixedContentIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MixedContentIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT ContentSecurityPolicyIssueDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ContentSecurityPolicyIssueDetails, T>::value>;
  using DataView = ContentSecurityPolicyIssueDetailsDataView;
  using Data_ = internal::ContentSecurityPolicyIssueDetails_Data;

  template <typename... Args>
  static ContentSecurityPolicyIssueDetailsPtr New(Args&&... args) {
    return ContentSecurityPolicyIssueDetailsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ContentSecurityPolicyIssueDetailsPtr From(const U& u) {
    return mojo::TypeConverter<ContentSecurityPolicyIssueDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ContentSecurityPolicyIssueDetails>::Convert(*this);
  }


  ContentSecurityPolicyIssueDetails();

  ContentSecurityPolicyIssueDetails(
      const base::Optional<::blink::KURL>& blocked_url,
      const WTF::String& violated_directive,
      ContentSecurityPolicyViolationType content_security_policy_violation_type,
      AffectedFramePtr frame_ancestor,
      ::network::mojom::blink::SourceLocationPtr source_location,
      int32_t violating_node_id);

  ~ContentSecurityPolicyIssueDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ContentSecurityPolicyIssueDetailsPtr>
  ContentSecurityPolicyIssueDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ContentSecurityPolicyIssueDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContentSecurityPolicyIssueDetails::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ContentSecurityPolicyIssueDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ContentSecurityPolicyIssueDetails_UnserializedMessageContext<
            UserType, ContentSecurityPolicyIssueDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ContentSecurityPolicyIssueDetails::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return ContentSecurityPolicyIssueDetails::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ContentSecurityPolicyIssueDetails_UnserializedMessageContext<
            UserType, ContentSecurityPolicyIssueDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ContentSecurityPolicyIssueDetails::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  base::Optional<::blink::KURL> blocked_url;
  
  WTF::String violated_directive;
  
  ContentSecurityPolicyViolationType content_security_policy_violation_type;
  
  AffectedFramePtr frame_ancestor;
  
  ::network::mojom::blink::SourceLocationPtr source_location;
  
  int32_t violating_node_id;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(ContentSecurityPolicyIssueDetails);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ContentSecurityPolicyIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ContentSecurityPolicyIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ContentSecurityPolicyIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ContentSecurityPolicyIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT SameSiteCookieIssueDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SameSiteCookieIssueDetails, T>::value>;
  using DataView = SameSiteCookieIssueDetailsDataView;
  using Data_ = internal::SameSiteCookieIssueDetails_Data;

  template <typename... Args>
  static SameSiteCookieIssueDetailsPtr New(Args&&... args) {
    return SameSiteCookieIssueDetailsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SameSiteCookieIssueDetailsPtr From(const U& u) {
    return mojo::TypeConverter<SameSiteCookieIssueDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SameSiteCookieIssueDetails>::Convert(*this);
  }


  SameSiteCookieIssueDetails();

  SameSiteCookieIssueDetails(
      AffectedCookiePtr cookie,
      WTF::Vector<SameSiteCookieExclusionReason> exclusion_reason,
      WTF::Vector<SameSiteCookieWarningReason> warning_reason,
      SameSiteCookieOperation operation,
      const base::Optional<::blink::KURL>& site_for_cookies,
      const base::Optional<::blink::KURL>& cookie_url,
      AffectedRequestPtr request);

  ~SameSiteCookieIssueDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SameSiteCookieIssueDetailsPtr>
  SameSiteCookieIssueDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SameSiteCookieIssueDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SameSiteCookieIssueDetails::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SameSiteCookieIssueDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SameSiteCookieIssueDetails_UnserializedMessageContext<
            UserType, SameSiteCookieIssueDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SameSiteCookieIssueDetails::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return SameSiteCookieIssueDetails::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SameSiteCookieIssueDetails_UnserializedMessageContext<
            UserType, SameSiteCookieIssueDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SameSiteCookieIssueDetails::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  AffectedCookiePtr cookie;
  
  WTF::Vector<SameSiteCookieExclusionReason> exclusion_reason;
  
  WTF::Vector<SameSiteCookieWarningReason> warning_reason;
  
  SameSiteCookieOperation operation;
  
  base::Optional<::blink::KURL> site_for_cookies;
  
  base::Optional<::blink::KURL> cookie_url;
  
  AffectedRequestPtr request;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(SameSiteCookieIssueDetails);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SameSiteCookieIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SameSiteCookieIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SameSiteCookieIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SameSiteCookieIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT InspectorIssueDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InspectorIssueDetails, T>::value>;
  using DataView = InspectorIssueDetailsDataView;
  using Data_ = internal::InspectorIssueDetails_Data;

  template <typename... Args>
  static InspectorIssueDetailsPtr New(Args&&... args) {
    return InspectorIssueDetailsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InspectorIssueDetailsPtr From(const U& u) {
    return mojo::TypeConverter<InspectorIssueDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InspectorIssueDetails>::Convert(*this);
  }


  InspectorIssueDetails();

  InspectorIssueDetails(
      SameSiteCookieIssueDetailsPtr samesite_cookie_issue_details,
      MixedContentIssueDetailsPtr mixed_content_issue_details,
      BlockedByResponseIssueDetailsPtr blocked_by_response_issue_details,
      ContentSecurityPolicyIssueDetailsPtr csp_issue_details);

  ~InspectorIssueDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InspectorIssueDetailsPtr>
  InspectorIssueDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InspectorIssueDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InspectorIssueDetails::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InspectorIssueDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InspectorIssueDetails_UnserializedMessageContext<
            UserType, InspectorIssueDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<InspectorIssueDetails::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return InspectorIssueDetails::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InspectorIssueDetails_UnserializedMessageContext<
            UserType, InspectorIssueDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InspectorIssueDetails::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  SameSiteCookieIssueDetailsPtr samesite_cookie_issue_details;
  
  MixedContentIssueDetailsPtr mixed_content_issue_details;
  
  BlockedByResponseIssueDetailsPtr blocked_by_response_issue_details;
  
  ContentSecurityPolicyIssueDetailsPtr csp_issue_details;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(InspectorIssueDetails);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InspectorIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InspectorIssueDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InspectorIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InspectorIssueDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT InspectorIssueInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InspectorIssueInfo, T>::value>;
  using DataView = InspectorIssueInfoDataView;
  using Data_ = internal::InspectorIssueInfo_Data;

  template <typename... Args>
  static InspectorIssueInfoPtr New(Args&&... args) {
    return InspectorIssueInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InspectorIssueInfoPtr From(const U& u) {
    return mojo::TypeConverter<InspectorIssueInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InspectorIssueInfo>::Convert(*this);
  }


  InspectorIssueInfo();

  InspectorIssueInfo(
      InspectorIssueCode code,
      InspectorIssueDetailsPtr details);

  ~InspectorIssueInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InspectorIssueInfoPtr>
  InspectorIssueInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InspectorIssueInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InspectorIssueInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InspectorIssueInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InspectorIssueInfo_UnserializedMessageContext<
            UserType, InspectorIssueInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<InspectorIssueInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return InspectorIssueInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InspectorIssueInfo_UnserializedMessageContext<
            UserType, InspectorIssueInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InspectorIssueInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  InspectorIssueCode code;
  
  InspectorIssueDetailsPtr details;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(InspectorIssueInfo);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InspectorIssueInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InspectorIssueInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InspectorIssueInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InspectorIssueInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AffectedCookiePtr AffectedCookie::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(path),
      mojo::Clone(domain)
  );
}

template <typename T, AffectedCookie::EnableIfSame<T>*>
bool AffectedCookie::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->domain, other_struct.domain))
    return false;
  return true;
}

template <typename T, AffectedCookie::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.path, rhs.path))
    return true;
  if (std::less<>{}(rhs.path, lhs.path))
    return false;
  if (std::less<>{}(lhs.domain, rhs.domain))
    return true;
  if (std::less<>{}(rhs.domain, lhs.domain))
    return false;
  return false;
}
template <typename StructPtrType>
AffectedRequestPtr AffectedRequest::Clone() const {
  return New(
      mojo::Clone(request_id),
      mojo::Clone(url)
  );
}

template <typename T, AffectedRequest::EnableIfSame<T>*>
bool AffectedRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request_id, other_struct.request_id))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  return true;
}

template <typename T, AffectedRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.request_id, rhs.request_id))
    return true;
  if (std::less<>{}(rhs.request_id, lhs.request_id))
    return false;
  if (std::less<>{}(lhs.url, rhs.url))
    return true;
  if (std::less<>{}(rhs.url, lhs.url))
    return false;
  return false;
}
template <typename StructPtrType>
AffectedFramePtr AffectedFrame::Clone() const {
  return New(
      mojo::Clone(frame_id)
  );
}

template <typename T, AffectedFrame::EnableIfSame<T>*>
bool AffectedFrame::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_id, other_struct.frame_id))
    return false;
  return true;
}

template <typename T, AffectedFrame::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.frame_id, rhs.frame_id))
    return true;
  if (std::less<>{}(rhs.frame_id, lhs.frame_id))
    return false;
  return false;
}
template <typename StructPtrType>
BlockedByResponseIssueDetailsPtr BlockedByResponseIssueDetails::Clone() const {
  return New(
      mojo::Clone(request),
      mojo::Clone(parentFrame),
      mojo::Clone(blockedFrame),
      mojo::Clone(reason)
  );
}

template <typename T, BlockedByResponseIssueDetails::EnableIfSame<T>*>
bool BlockedByResponseIssueDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request, other_struct.request))
    return false;
  if (!mojo::Equals(this->parentFrame, other_struct.parentFrame))
    return false;
  if (!mojo::Equals(this->blockedFrame, other_struct.blockedFrame))
    return false;
  if (!mojo::Equals(this->reason, other_struct.reason))
    return false;
  return true;
}

template <typename T, BlockedByResponseIssueDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.request, rhs.request))
    return true;
  if (std::less<>{}(rhs.request, lhs.request))
    return false;
  if (std::less<>{}(lhs.parentFrame, rhs.parentFrame))
    return true;
  if (std::less<>{}(rhs.parentFrame, lhs.parentFrame))
    return false;
  if (std::less<>{}(lhs.blockedFrame, rhs.blockedFrame))
    return true;
  if (std::less<>{}(rhs.blockedFrame, lhs.blockedFrame))
    return false;
  if (std::less<>{}(lhs.reason, rhs.reason))
    return true;
  if (std::less<>{}(rhs.reason, lhs.reason))
    return false;
  return false;
}
template <typename StructPtrType>
MixedContentIssueDetailsPtr MixedContentIssueDetails::Clone() const {
  return New(
      mojo::Clone(request_context),
      mojo::Clone(resolution_status),
      mojo::Clone(insecure_url),
      mojo::Clone(main_resource_url),
      mojo::Clone(request),
      mojo::Clone(frame)
  );
}

template <typename T, MixedContentIssueDetails::EnableIfSame<T>*>
bool MixedContentIssueDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request_context, other_struct.request_context))
    return false;
  if (!mojo::Equals(this->resolution_status, other_struct.resolution_status))
    return false;
  if (!mojo::Equals(this->insecure_url, other_struct.insecure_url))
    return false;
  if (!mojo::Equals(this->main_resource_url, other_struct.main_resource_url))
    return false;
  if (!mojo::Equals(this->request, other_struct.request))
    return false;
  if (!mojo::Equals(this->frame, other_struct.frame))
    return false;
  return true;
}

template <typename T, MixedContentIssueDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.request_context, rhs.request_context))
    return true;
  if (std::less<>{}(rhs.request_context, lhs.request_context))
    return false;
  if (std::less<>{}(lhs.resolution_status, rhs.resolution_status))
    return true;
  if (std::less<>{}(rhs.resolution_status, lhs.resolution_status))
    return false;
  if (std::less<>{}(lhs.insecure_url, rhs.insecure_url))
    return true;
  if (std::less<>{}(rhs.insecure_url, lhs.insecure_url))
    return false;
  if (std::less<>{}(lhs.main_resource_url, rhs.main_resource_url))
    return true;
  if (std::less<>{}(rhs.main_resource_url, lhs.main_resource_url))
    return false;
  if (std::less<>{}(lhs.request, rhs.request))
    return true;
  if (std::less<>{}(rhs.request, lhs.request))
    return false;
  if (std::less<>{}(lhs.frame, rhs.frame))
    return true;
  if (std::less<>{}(rhs.frame, lhs.frame))
    return false;
  return false;
}
template <typename StructPtrType>
ContentSecurityPolicyIssueDetailsPtr ContentSecurityPolicyIssueDetails::Clone() const {
  return New(
      mojo::Clone(blocked_url),
      mojo::Clone(violated_directive),
      mojo::Clone(content_security_policy_violation_type),
      mojo::Clone(frame_ancestor),
      mojo::Clone(source_location),
      mojo::Clone(violating_node_id)
  );
}

template <typename T, ContentSecurityPolicyIssueDetails::EnableIfSame<T>*>
bool ContentSecurityPolicyIssueDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->blocked_url, other_struct.blocked_url))
    return false;
  if (!mojo::Equals(this->violated_directive, other_struct.violated_directive))
    return false;
  if (!mojo::Equals(this->content_security_policy_violation_type, other_struct.content_security_policy_violation_type))
    return false;
  if (!mojo::Equals(this->frame_ancestor, other_struct.frame_ancestor))
    return false;
  if (!mojo::Equals(this->source_location, other_struct.source_location))
    return false;
  if (!mojo::Equals(this->violating_node_id, other_struct.violating_node_id))
    return false;
  return true;
}

template <typename T, ContentSecurityPolicyIssueDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.blocked_url, rhs.blocked_url))
    return true;
  if (std::less<>{}(rhs.blocked_url, lhs.blocked_url))
    return false;
  if (std::less<>{}(lhs.violated_directive, rhs.violated_directive))
    return true;
  if (std::less<>{}(rhs.violated_directive, lhs.violated_directive))
    return false;
  if (std::less<>{}(lhs.content_security_policy_violation_type, rhs.content_security_policy_violation_type))
    return true;
  if (std::less<>{}(rhs.content_security_policy_violation_type, lhs.content_security_policy_violation_type))
    return false;
  if (std::less<>{}(lhs.frame_ancestor, rhs.frame_ancestor))
    return true;
  if (std::less<>{}(rhs.frame_ancestor, lhs.frame_ancestor))
    return false;
  if (std::less<>{}(lhs.source_location, rhs.source_location))
    return true;
  if (std::less<>{}(rhs.source_location, lhs.source_location))
    return false;
  if (std::less<>{}(lhs.violating_node_id, rhs.violating_node_id))
    return true;
  if (std::less<>{}(rhs.violating_node_id, lhs.violating_node_id))
    return false;
  return false;
}
template <typename StructPtrType>
SameSiteCookieIssueDetailsPtr SameSiteCookieIssueDetails::Clone() const {
  return New(
      mojo::Clone(cookie),
      mojo::Clone(exclusion_reason),
      mojo::Clone(warning_reason),
      mojo::Clone(operation),
      mojo::Clone(site_for_cookies),
      mojo::Clone(cookie_url),
      mojo::Clone(request)
  );
}

template <typename T, SameSiteCookieIssueDetails::EnableIfSame<T>*>
bool SameSiteCookieIssueDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cookie, other_struct.cookie))
    return false;
  if (!mojo::Equals(this->exclusion_reason, other_struct.exclusion_reason))
    return false;
  if (!mojo::Equals(this->warning_reason, other_struct.warning_reason))
    return false;
  if (!mojo::Equals(this->operation, other_struct.operation))
    return false;
  if (!mojo::Equals(this->site_for_cookies, other_struct.site_for_cookies))
    return false;
  if (!mojo::Equals(this->cookie_url, other_struct.cookie_url))
    return false;
  if (!mojo::Equals(this->request, other_struct.request))
    return false;
  return true;
}

template <typename T, SameSiteCookieIssueDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.cookie, rhs.cookie))
    return true;
  if (std::less<>{}(rhs.cookie, lhs.cookie))
    return false;
  if (std::less<>{}(lhs.exclusion_reason, rhs.exclusion_reason))
    return true;
  if (std::less<>{}(rhs.exclusion_reason, lhs.exclusion_reason))
    return false;
  if (std::less<>{}(lhs.warning_reason, rhs.warning_reason))
    return true;
  if (std::less<>{}(rhs.warning_reason, lhs.warning_reason))
    return false;
  if (std::less<>{}(lhs.operation, rhs.operation))
    return true;
  if (std::less<>{}(rhs.operation, lhs.operation))
    return false;
  if (std::less<>{}(lhs.site_for_cookies, rhs.site_for_cookies))
    return true;
  if (std::less<>{}(rhs.site_for_cookies, lhs.site_for_cookies))
    return false;
  if (std::less<>{}(lhs.cookie_url, rhs.cookie_url))
    return true;
  if (std::less<>{}(rhs.cookie_url, lhs.cookie_url))
    return false;
  if (std::less<>{}(lhs.request, rhs.request))
    return true;
  if (std::less<>{}(rhs.request, lhs.request))
    return false;
  return false;
}
template <typename StructPtrType>
InspectorIssueDetailsPtr InspectorIssueDetails::Clone() const {
  return New(
      mojo::Clone(samesite_cookie_issue_details),
      mojo::Clone(mixed_content_issue_details),
      mojo::Clone(blocked_by_response_issue_details),
      mojo::Clone(csp_issue_details)
  );
}

template <typename T, InspectorIssueDetails::EnableIfSame<T>*>
bool InspectorIssueDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->samesite_cookie_issue_details, other_struct.samesite_cookie_issue_details))
    return false;
  if (!mojo::Equals(this->mixed_content_issue_details, other_struct.mixed_content_issue_details))
    return false;
  if (!mojo::Equals(this->blocked_by_response_issue_details, other_struct.blocked_by_response_issue_details))
    return false;
  if (!mojo::Equals(this->csp_issue_details, other_struct.csp_issue_details))
    return false;
  return true;
}

template <typename T, InspectorIssueDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.samesite_cookie_issue_details, rhs.samesite_cookie_issue_details))
    return true;
  if (std::less<>{}(rhs.samesite_cookie_issue_details, lhs.samesite_cookie_issue_details))
    return false;
  if (std::less<>{}(lhs.mixed_content_issue_details, rhs.mixed_content_issue_details))
    return true;
  if (std::less<>{}(rhs.mixed_content_issue_details, lhs.mixed_content_issue_details))
    return false;
  if (std::less<>{}(lhs.blocked_by_response_issue_details, rhs.blocked_by_response_issue_details))
    return true;
  if (std::less<>{}(rhs.blocked_by_response_issue_details, lhs.blocked_by_response_issue_details))
    return false;
  if (std::less<>{}(lhs.csp_issue_details, rhs.csp_issue_details))
    return true;
  if (std::less<>{}(rhs.csp_issue_details, lhs.csp_issue_details))
    return false;
  return false;
}
template <typename StructPtrType>
InspectorIssueInfoPtr InspectorIssueInfo::Clone() const {
  return New(
      mojo::Clone(code),
      mojo::Clone(details)
  );
}

template <typename T, InspectorIssueInfo::EnableIfSame<T>*>
bool InspectorIssueInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->code, other_struct.code))
    return false;
  if (!mojo::Equals(this->details, other_struct.details))
    return false;
  return true;
}

template <typename T, InspectorIssueInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.code, rhs.code))
    return true;
  if (std::less<>{}(rhs.code, lhs.code))
    return false;
  if (std::less<>{}(lhs.details, rhs.details))
    return true;
  if (std::less<>{}(rhs.details, lhs.details))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AffectedCookie::DataView,
                                         ::blink::mojom::blink::AffectedCookiePtr> {
  static bool IsNull(const ::blink::mojom::blink::AffectedCookiePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AffectedCookiePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AffectedCookie::name)& name(
      const ::blink::mojom::blink::AffectedCookiePtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::blink::AffectedCookie::path)& path(
      const ::blink::mojom::blink::AffectedCookiePtr& input) {
    return input->path;
  }

  static const decltype(::blink::mojom::blink::AffectedCookie::domain)& domain(
      const ::blink::mojom::blink::AffectedCookiePtr& input) {
    return input->domain;
  }

  static bool Read(::blink::mojom::blink::AffectedCookie::DataView input, ::blink::mojom::blink::AffectedCookiePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AffectedRequest::DataView,
                                         ::blink::mojom::blink::AffectedRequestPtr> {
  static bool IsNull(const ::blink::mojom::blink::AffectedRequestPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AffectedRequestPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AffectedRequest::request_id)& request_id(
      const ::blink::mojom::blink::AffectedRequestPtr& input) {
    return input->request_id;
  }

  static const decltype(::blink::mojom::blink::AffectedRequest::url)& url(
      const ::blink::mojom::blink::AffectedRequestPtr& input) {
    return input->url;
  }

  static bool Read(::blink::mojom::blink::AffectedRequest::DataView input, ::blink::mojom::blink::AffectedRequestPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AffectedFrame::DataView,
                                         ::blink::mojom::blink::AffectedFramePtr> {
  static bool IsNull(const ::blink::mojom::blink::AffectedFramePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AffectedFramePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::AffectedFrame::frame_id)& frame_id(
      const ::blink::mojom::blink::AffectedFramePtr& input) {
    return input->frame_id;
  }

  static bool Read(::blink::mojom::blink::AffectedFrame::DataView input, ::blink::mojom::blink::AffectedFramePtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::BlockedByResponseIssueDetails::DataView,
                                         ::blink::mojom::blink::BlockedByResponseIssueDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::BlockedByResponseIssueDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::BlockedByResponseIssueDetailsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::BlockedByResponseIssueDetails::request)& request(
      const ::blink::mojom::blink::BlockedByResponseIssueDetailsPtr& input) {
    return input->request;
  }

  static const decltype(::blink::mojom::blink::BlockedByResponseIssueDetails::parentFrame)& parentFrame(
      const ::blink::mojom::blink::BlockedByResponseIssueDetailsPtr& input) {
    return input->parentFrame;
  }

  static const decltype(::blink::mojom::blink::BlockedByResponseIssueDetails::blockedFrame)& blockedFrame(
      const ::blink::mojom::blink::BlockedByResponseIssueDetailsPtr& input) {
    return input->blockedFrame;
  }

  static decltype(::blink::mojom::blink::BlockedByResponseIssueDetails::reason) reason(
      const ::blink::mojom::blink::BlockedByResponseIssueDetailsPtr& input) {
    return input->reason;
  }

  static bool Read(::blink::mojom::blink::BlockedByResponseIssueDetails::DataView input, ::blink::mojom::blink::BlockedByResponseIssueDetailsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::MixedContentIssueDetails::DataView,
                                         ::blink::mojom::blink::MixedContentIssueDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::MixedContentIssueDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::MixedContentIssueDetailsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::MixedContentIssueDetails::request_context) request_context(
      const ::blink::mojom::blink::MixedContentIssueDetailsPtr& input) {
    return input->request_context;
  }

  static decltype(::blink::mojom::blink::MixedContentIssueDetails::resolution_status) resolution_status(
      const ::blink::mojom::blink::MixedContentIssueDetailsPtr& input) {
    return input->resolution_status;
  }

  static const decltype(::blink::mojom::blink::MixedContentIssueDetails::insecure_url)& insecure_url(
      const ::blink::mojom::blink::MixedContentIssueDetailsPtr& input) {
    return input->insecure_url;
  }

  static const decltype(::blink::mojom::blink::MixedContentIssueDetails::main_resource_url)& main_resource_url(
      const ::blink::mojom::blink::MixedContentIssueDetailsPtr& input) {
    return input->main_resource_url;
  }

  static const decltype(::blink::mojom::blink::MixedContentIssueDetails::request)& request(
      const ::blink::mojom::blink::MixedContentIssueDetailsPtr& input) {
    return input->request;
  }

  static const decltype(::blink::mojom::blink::MixedContentIssueDetails::frame)& frame(
      const ::blink::mojom::blink::MixedContentIssueDetailsPtr& input) {
    return input->frame;
  }

  static bool Read(::blink::mojom::blink::MixedContentIssueDetails::DataView input, ::blink::mojom::blink::MixedContentIssueDetailsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::ContentSecurityPolicyIssueDetails::DataView,
                                         ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::ContentSecurityPolicyIssueDetails::blocked_url)& blocked_url(
      const ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr& input) {
    return input->blocked_url;
  }

  static const decltype(::blink::mojom::blink::ContentSecurityPolicyIssueDetails::violated_directive)& violated_directive(
      const ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr& input) {
    return input->violated_directive;
  }

  static decltype(::blink::mojom::blink::ContentSecurityPolicyIssueDetails::content_security_policy_violation_type) content_security_policy_violation_type(
      const ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr& input) {
    return input->content_security_policy_violation_type;
  }

  static const decltype(::blink::mojom::blink::ContentSecurityPolicyIssueDetails::frame_ancestor)& frame_ancestor(
      const ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr& input) {
    return input->frame_ancestor;
  }

  static const decltype(::blink::mojom::blink::ContentSecurityPolicyIssueDetails::source_location)& source_location(
      const ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr& input) {
    return input->source_location;
  }

  static decltype(::blink::mojom::blink::ContentSecurityPolicyIssueDetails::violating_node_id) violating_node_id(
      const ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr& input) {
    return input->violating_node_id;
  }

  static bool Read(::blink::mojom::blink::ContentSecurityPolicyIssueDetails::DataView input, ::blink::mojom::blink::ContentSecurityPolicyIssueDetailsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SameSiteCookieIssueDetails::DataView,
                                         ::blink::mojom::blink::SameSiteCookieIssueDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::SameSiteCookieIssueDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SameSiteCookieIssueDetailsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::SameSiteCookieIssueDetails::cookie)& cookie(
      const ::blink::mojom::blink::SameSiteCookieIssueDetailsPtr& input) {
    return input->cookie;
  }

  static const decltype(::blink::mojom::blink::SameSiteCookieIssueDetails::exclusion_reason)& exclusion_reason(
      const ::blink::mojom::blink::SameSiteCookieIssueDetailsPtr& input) {
    return input->exclusion_reason;
  }

  static const decltype(::blink::mojom::blink::SameSiteCookieIssueDetails::warning_reason)& warning_reason(
      const ::blink::mojom::blink::SameSiteCookieIssueDetailsPtr& input) {
    return input->warning_reason;
  }

  static decltype(::blink::mojom::blink::SameSiteCookieIssueDetails::operation) operation(
      const ::blink::mojom::blink::SameSiteCookieIssueDetailsPtr& input) {
    return input->operation;
  }

  static const decltype(::blink::mojom::blink::SameSiteCookieIssueDetails::site_for_cookies)& site_for_cookies(
      const ::blink::mojom::blink::SameSiteCookieIssueDetailsPtr& input) {
    return input->site_for_cookies;
  }

  static const decltype(::blink::mojom::blink::SameSiteCookieIssueDetails::cookie_url)& cookie_url(
      const ::blink::mojom::blink::SameSiteCookieIssueDetailsPtr& input) {
    return input->cookie_url;
  }

  static const decltype(::blink::mojom::blink::SameSiteCookieIssueDetails::request)& request(
      const ::blink::mojom::blink::SameSiteCookieIssueDetailsPtr& input) {
    return input->request;
  }

  static bool Read(::blink::mojom::blink::SameSiteCookieIssueDetails::DataView input, ::blink::mojom::blink::SameSiteCookieIssueDetailsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::InspectorIssueDetails::DataView,
                                         ::blink::mojom::blink::InspectorIssueDetailsPtr> {
  static bool IsNull(const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::InspectorIssueDetailsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::InspectorIssueDetails::samesite_cookie_issue_details)& samesite_cookie_issue_details(
      const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) {
    return input->samesite_cookie_issue_details;
  }

  static const decltype(::blink::mojom::blink::InspectorIssueDetails::mixed_content_issue_details)& mixed_content_issue_details(
      const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) {
    return input->mixed_content_issue_details;
  }

  static const decltype(::blink::mojom::blink::InspectorIssueDetails::blocked_by_response_issue_details)& blocked_by_response_issue_details(
      const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) {
    return input->blocked_by_response_issue_details;
  }

  static const decltype(::blink::mojom::blink::InspectorIssueDetails::csp_issue_details)& csp_issue_details(
      const ::blink::mojom::blink::InspectorIssueDetailsPtr& input) {
    return input->csp_issue_details;
  }

  static bool Read(::blink::mojom::blink::InspectorIssueDetails::DataView input, ::blink::mojom::blink::InspectorIssueDetailsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::InspectorIssueInfo::DataView,
                                         ::blink::mojom::blink::InspectorIssueInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::InspectorIssueInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::InspectorIssueInfoPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::InspectorIssueInfo::code) code(
      const ::blink::mojom::blink::InspectorIssueInfoPtr& input) {
    return input->code;
  }

  static const decltype(::blink::mojom::blink::InspectorIssueInfo::details)& details(
      const ::blink::mojom::blink::InspectorIssueInfoPtr& input) {
    return input->details;
  }

  static bool Read(::blink::mojom::blink::InspectorIssueInfo::DataView input, ::blink::mojom::blink::InspectorIssueInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_INSPECTOR_ISSUE_MOJOM_BLINK_H_