// services/viz/public/mojom/compositing/quads.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_QUADS_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_QUADS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/viz/public/mojom/compositing/quads.mojom-shared.h"
#include "services/viz/public/mojom/compositing/quads.mojom-forward.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "services/viz/public/mojom/compositing/compositor_render_pass_id.mojom.h"
#include "services/viz/public/mojom/compositing/shared_quad_state.mojom.h"
#include "services/viz/public/mojom/compositing/surface_range.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/color_space.mojom.h"
#include "ui/gfx/mojom/transform.mojom-forward.h"
#include "ui/gl/mojom/hdr_metadata.mojom.h"
#include <string>
#include <vector>




#include "services/viz/public/cpp/compositing/compositor_render_pass_mojom_traits.h"
#include "services/viz/public/cpp/compositing/quads_mojom_traits.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace viz {
namespace mojom {





class  DebugBorderQuadState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DebugBorderQuadState, T>::value>;
  using DataView = DebugBorderQuadStateDataView;
  using Data_ = internal::DebugBorderQuadState_Data;

  template <typename... Args>
  static DebugBorderQuadStatePtr New(Args&&... args) {
    return DebugBorderQuadStatePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DebugBorderQuadStatePtr From(const U& u) {
    return mojo::TypeConverter<DebugBorderQuadStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DebugBorderQuadState>::Convert(*this);
  }


  DebugBorderQuadState();

  DebugBorderQuadState(
      uint32_t color,
      int32_t width);

  ~DebugBorderQuadState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DebugBorderQuadStatePtr>
  DebugBorderQuadStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DebugBorderQuadState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DebugBorderQuadState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DebugBorderQuadState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DebugBorderQuadState_UnserializedMessageContext<
            UserType, DebugBorderQuadState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DebugBorderQuadState::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return DebugBorderQuadState::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DebugBorderQuadState_UnserializedMessageContext<
            UserType, DebugBorderQuadState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DebugBorderQuadState::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t color;
  
  int32_t width;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DebugBorderQuadState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DebugBorderQuadState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DebugBorderQuadState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DebugBorderQuadState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  SolidColorQuadState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SolidColorQuadState, T>::value>;
  using DataView = SolidColorQuadStateDataView;
  using Data_ = internal::SolidColorQuadState_Data;

  template <typename... Args>
  static SolidColorQuadStatePtr New(Args&&... args) {
    return SolidColorQuadStatePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SolidColorQuadStatePtr From(const U& u) {
    return mojo::TypeConverter<SolidColorQuadStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SolidColorQuadState>::Convert(*this);
  }


  SolidColorQuadState();

  SolidColorQuadState(
      uint32_t color,
      bool force_anti_aliasing_off);

  ~SolidColorQuadState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SolidColorQuadStatePtr>
  SolidColorQuadStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SolidColorQuadState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SolidColorQuadState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SolidColorQuadState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SolidColorQuadState_UnserializedMessageContext<
            UserType, SolidColorQuadState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SolidColorQuadState::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return SolidColorQuadState::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SolidColorQuadState_UnserializedMessageContext<
            UserType, SolidColorQuadState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SolidColorQuadState::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t color;
  
  bool force_anti_aliasing_off;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SolidColorQuadState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SolidColorQuadState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SolidColorQuadState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SolidColorQuadState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}












class  DrawQuadState {
 public:
  using DataView = DrawQuadStateDataView;
  using Data_ = internal::DrawQuadState_Data;
  using Tag = Data_::DrawQuadState_Tag;

  static DrawQuadStatePtr New() {
    return DrawQuadStatePtr(base::in_place);
  }
  // Construct an instance holding |debug_border_quad_state|.
  static DrawQuadStatePtr
  NewDebugBorderQuadState(
      DebugBorderQuadStatePtr debug_border_quad_state) {
    auto result = DrawQuadStatePtr(base::in_place);
    result->set_debug_border_quad_state(std::move(debug_border_quad_state));
    return result;
  }
  // Construct an instance holding |render_pass_quad_state|.
  static DrawQuadStatePtr
  NewRenderPassQuadState(
      CompositorRenderPassQuadStatePtr render_pass_quad_state) {
    auto result = DrawQuadStatePtr(base::in_place);
    result->set_render_pass_quad_state(std::move(render_pass_quad_state));
    return result;
  }
  // Construct an instance holding |solid_color_quad_state|.
  static DrawQuadStatePtr
  NewSolidColorQuadState(
      SolidColorQuadStatePtr solid_color_quad_state) {
    auto result = DrawQuadStatePtr(base::in_place);
    result->set_solid_color_quad_state(std::move(solid_color_quad_state));
    return result;
  }
  // Construct an instance holding |stream_video_quad_state|.
  static DrawQuadStatePtr
  NewStreamVideoQuadState(
      StreamVideoQuadStatePtr stream_video_quad_state) {
    auto result = DrawQuadStatePtr(base::in_place);
    result->set_stream_video_quad_state(std::move(stream_video_quad_state));
    return result;
  }
  // Construct an instance holding |surface_quad_state|.
  static DrawQuadStatePtr
  NewSurfaceQuadState(
      SurfaceQuadStatePtr surface_quad_state) {
    auto result = DrawQuadStatePtr(base::in_place);
    result->set_surface_quad_state(std::move(surface_quad_state));
    return result;
  }
  // Construct an instance holding |texture_quad_state|.
  static DrawQuadStatePtr
  NewTextureQuadState(
      TextureQuadStatePtr texture_quad_state) {
    auto result = DrawQuadStatePtr(base::in_place);
    result->set_texture_quad_state(std::move(texture_quad_state));
    return result;
  }
  // Construct an instance holding |tile_quad_state|.
  static DrawQuadStatePtr
  NewTileQuadState(
      TileQuadStatePtr tile_quad_state) {
    auto result = DrawQuadStatePtr(base::in_place);
    result->set_tile_quad_state(std::move(tile_quad_state));
    return result;
  }
  // Construct an instance holding |yuv_video_quad_state|.
  static DrawQuadStatePtr
  NewYuvVideoQuadState(
      YUVVideoQuadStatePtr yuv_video_quad_state) {
    auto result = DrawQuadStatePtr(base::in_place);
    result->set_yuv_video_quad_state(std::move(yuv_video_quad_state));
    return result;
  }
  // Construct an instance holding |video_hole_quad_state|.
  static DrawQuadStatePtr
  NewVideoHoleQuadState(
      VideoHoleQuadStatePtr video_hole_quad_state) {
    auto result = DrawQuadStatePtr(base::in_place);
    result->set_video_hole_quad_state(std::move(video_hole_quad_state));
    return result;
  }

  template <typename U>
  static DrawQuadStatePtr From(const U& u) {
    return mojo::TypeConverter<DrawQuadStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DrawQuadState>::Convert(*this);
  }

  DrawQuadState();
  ~DrawQuadState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = DrawQuadStatePtr>
  DrawQuadStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, DrawQuadState>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_debug_border_quad_state() const { return tag_ == Tag::DEBUG_BORDER_QUAD_STATE; }

  
  DebugBorderQuadStatePtr& get_debug_border_quad_state() const {
    DCHECK(tag_ == Tag::DEBUG_BORDER_QUAD_STATE);
    return *(data_.debug_border_quad_state);
  }

  
  void set_debug_border_quad_state(
      DebugBorderQuadStatePtr debug_border_quad_state);
  
  bool is_render_pass_quad_state() const { return tag_ == Tag::RENDER_PASS_QUAD_STATE; }

  
  CompositorRenderPassQuadStatePtr& get_render_pass_quad_state() const {
    DCHECK(tag_ == Tag::RENDER_PASS_QUAD_STATE);
    return *(data_.render_pass_quad_state);
  }

  
  void set_render_pass_quad_state(
      CompositorRenderPassQuadStatePtr render_pass_quad_state);
  
  bool is_solid_color_quad_state() const { return tag_ == Tag::SOLID_COLOR_QUAD_STATE; }

  
  SolidColorQuadStatePtr& get_solid_color_quad_state() const {
    DCHECK(tag_ == Tag::SOLID_COLOR_QUAD_STATE);
    return *(data_.solid_color_quad_state);
  }

  
  void set_solid_color_quad_state(
      SolidColorQuadStatePtr solid_color_quad_state);
  
  bool is_stream_video_quad_state() const { return tag_ == Tag::STREAM_VIDEO_QUAD_STATE; }

  
  StreamVideoQuadStatePtr& get_stream_video_quad_state() const {
    DCHECK(tag_ == Tag::STREAM_VIDEO_QUAD_STATE);
    return *(data_.stream_video_quad_state);
  }

  
  void set_stream_video_quad_state(
      StreamVideoQuadStatePtr stream_video_quad_state);
  
  bool is_surface_quad_state() const { return tag_ == Tag::SURFACE_QUAD_STATE; }

  
  SurfaceQuadStatePtr& get_surface_quad_state() const {
    DCHECK(tag_ == Tag::SURFACE_QUAD_STATE);
    return *(data_.surface_quad_state);
  }

  
  void set_surface_quad_state(
      SurfaceQuadStatePtr surface_quad_state);
  
  bool is_texture_quad_state() const { return tag_ == Tag::TEXTURE_QUAD_STATE; }

  
  TextureQuadStatePtr& get_texture_quad_state() const {
    DCHECK(tag_ == Tag::TEXTURE_QUAD_STATE);
    return *(data_.texture_quad_state);
  }

  
  void set_texture_quad_state(
      TextureQuadStatePtr texture_quad_state);
  
  bool is_tile_quad_state() const { return tag_ == Tag::TILE_QUAD_STATE; }

  
  TileQuadStatePtr& get_tile_quad_state() const {
    DCHECK(tag_ == Tag::TILE_QUAD_STATE);
    return *(data_.tile_quad_state);
  }

  
  void set_tile_quad_state(
      TileQuadStatePtr tile_quad_state);
  
  bool is_yuv_video_quad_state() const { return tag_ == Tag::YUV_VIDEO_QUAD_STATE; }

  
  YUVVideoQuadStatePtr& get_yuv_video_quad_state() const {
    DCHECK(tag_ == Tag::YUV_VIDEO_QUAD_STATE);
    return *(data_.yuv_video_quad_state);
  }

  
  void set_yuv_video_quad_state(
      YUVVideoQuadStatePtr yuv_video_quad_state);
  
  bool is_video_hole_quad_state() const { return tag_ == Tag::VIDEO_HOLE_QUAD_STATE; }

  
  VideoHoleQuadStatePtr& get_video_hole_quad_state() const {
    DCHECK(tag_ == Tag::VIDEO_HOLE_QUAD_STATE);
    return *(data_.video_hole_quad_state);
  }

  
  void set_video_hole_quad_state(
      VideoHoleQuadStatePtr video_hole_quad_state);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DrawQuadState::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<DrawQuadState::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    DebugBorderQuadStatePtr* debug_border_quad_state;
    CompositorRenderPassQuadStatePtr* render_pass_quad_state;
    SolidColorQuadStatePtr* solid_color_quad_state;
    StreamVideoQuadStatePtr* stream_video_quad_state;
    SurfaceQuadStatePtr* surface_quad_state;
    TextureQuadStatePtr* texture_quad_state;
    TileQuadStatePtr* tile_quad_state;
    YUVVideoQuadStatePtr* yuv_video_quad_state;
    VideoHoleQuadStatePtr* video_hole_quad_state;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class  CompositorRenderPassQuadState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CompositorRenderPassQuadState, T>::value>;
  using DataView = CompositorRenderPassQuadStateDataView;
  using Data_ = internal::CompositorRenderPassQuadState_Data;

  template <typename... Args>
  static CompositorRenderPassQuadStatePtr New(Args&&... args) {
    return CompositorRenderPassQuadStatePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CompositorRenderPassQuadStatePtr From(const U& u) {
    return mojo::TypeConverter<CompositorRenderPassQuadStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CompositorRenderPassQuadState>::Convert(*this);
  }


  CompositorRenderPassQuadState();

  CompositorRenderPassQuadState(
      const ::viz::CompositorRenderPassId& render_pass_id,
      uint32_t mask_resource_id,
      const ::gfx::RectF& mask_uv_rect,
      const ::gfx::Size& mask_texture_size,
      const ::gfx::Vector2dF& filters_scale,
      const ::gfx::PointF& filters_origin,
      const ::gfx::RectF& tex_coord_rect,
      bool force_anti_aliasing_off,
      float backdrop_filter_quality,
      bool can_use_backdrop_filter_cache);

  ~CompositorRenderPassQuadState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CompositorRenderPassQuadStatePtr>
  CompositorRenderPassQuadStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CompositorRenderPassQuadState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CompositorRenderPassQuadState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CompositorRenderPassQuadState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CompositorRenderPassQuadState_UnserializedMessageContext<
            UserType, CompositorRenderPassQuadState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CompositorRenderPassQuadState::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CompositorRenderPassQuadState::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CompositorRenderPassQuadState_UnserializedMessageContext<
            UserType, CompositorRenderPassQuadState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CompositorRenderPassQuadState::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::viz::CompositorRenderPassId render_pass_id;
  
  uint32_t mask_resource_id;
  
  ::gfx::RectF mask_uv_rect;
  
  ::gfx::Size mask_texture_size;
  
  ::gfx::Vector2dF filters_scale;
  
  ::gfx::PointF filters_origin;
  
  ::gfx::RectF tex_coord_rect;
  
  bool force_anti_aliasing_off;
  
  float backdrop_filter_quality;
  
  bool can_use_backdrop_filter_cache;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CompositorRenderPassQuadState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CompositorRenderPassQuadState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CompositorRenderPassQuadState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CompositorRenderPassQuadState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  StreamVideoQuadState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StreamVideoQuadState, T>::value>;
  using DataView = StreamVideoQuadStateDataView;
  using Data_ = internal::StreamVideoQuadState_Data;

  template <typename... Args>
  static StreamVideoQuadStatePtr New(Args&&... args) {
    return StreamVideoQuadStatePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StreamVideoQuadStatePtr From(const U& u) {
    return mojo::TypeConverter<StreamVideoQuadStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StreamVideoQuadState>::Convert(*this);
  }


  StreamVideoQuadState();

  StreamVideoQuadState(
      uint32_t resource_id,
      const ::gfx::Size& resource_size_in_pixels,
      const ::gfx::PointF& uv_top_left,
      const ::gfx::PointF& uv_bottom_right);

  ~StreamVideoQuadState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StreamVideoQuadStatePtr>
  StreamVideoQuadStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StreamVideoQuadState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StreamVideoQuadState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StreamVideoQuadState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StreamVideoQuadState_UnserializedMessageContext<
            UserType, StreamVideoQuadState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<StreamVideoQuadState::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return StreamVideoQuadState::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StreamVideoQuadState_UnserializedMessageContext<
            UserType, StreamVideoQuadState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StreamVideoQuadState::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t resource_id;
  
  ::gfx::Size resource_size_in_pixels;
  
  ::gfx::PointF uv_top_left;
  
  ::gfx::PointF uv_bottom_right;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StreamVideoQuadState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StreamVideoQuadState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StreamVideoQuadState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StreamVideoQuadState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SurfaceQuadState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SurfaceQuadState, T>::value>;
  using DataView = SurfaceQuadStateDataView;
  using Data_ = internal::SurfaceQuadState_Data;

  template <typename... Args>
  static SurfaceQuadStatePtr New(Args&&... args) {
    return SurfaceQuadStatePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SurfaceQuadStatePtr From(const U& u) {
    return mojo::TypeConverter<SurfaceQuadStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SurfaceQuadState>::Convert(*this);
  }


  SurfaceQuadState();

  SurfaceQuadState(
      const ::viz::SurfaceRange& surface_range,
      uint32_t default_background_color,
      bool stretch_content_to_fill_bounds,
      bool is_reflection,
      bool allow_merge);

  ~SurfaceQuadState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SurfaceQuadStatePtr>
  SurfaceQuadStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SurfaceQuadState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SurfaceQuadState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SurfaceQuadState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SurfaceQuadState_UnserializedMessageContext<
            UserType, SurfaceQuadState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SurfaceQuadState::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return SurfaceQuadState::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SurfaceQuadState_UnserializedMessageContext<
            UserType, SurfaceQuadState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SurfaceQuadState::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::viz::SurfaceRange surface_range;
  
  uint32_t default_background_color;
  
  bool stretch_content_to_fill_bounds;
  
  bool is_reflection;
  
  bool allow_merge;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SurfaceQuadState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SurfaceQuadState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SurfaceQuadState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SurfaceQuadState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TextureQuadState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TextureQuadState, T>::value>;
  using DataView = TextureQuadStateDataView;
  using Data_ = internal::TextureQuadState_Data;

  template <typename... Args>
  static TextureQuadStatePtr New(Args&&... args) {
    return TextureQuadStatePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TextureQuadStatePtr From(const U& u) {
    return mojo::TypeConverter<TextureQuadStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TextureQuadState>::Convert(*this);
  }


  TextureQuadState();

  TextureQuadState(
      uint32_t resource_id,
      const ::gfx::Size& resource_size_in_pixels,
      bool premultiplied_alpha,
      const ::gfx::PointF& uv_top_left,
      const ::gfx::PointF& uv_bottom_right,
      uint32_t background_color,
      std::vector<float> vertex_opacity,
      bool y_flipped,
      bool nearest_neighbor,
      bool secure_output_only,
      bool is_video_frame,
      ::gfx::ProtectedVideoType protected_video_type);

  ~TextureQuadState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TextureQuadStatePtr>
  TextureQuadStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TextureQuadState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TextureQuadState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TextureQuadState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TextureQuadState_UnserializedMessageContext<
            UserType, TextureQuadState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<TextureQuadState::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return TextureQuadState::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TextureQuadState_UnserializedMessageContext<
            UserType, TextureQuadState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TextureQuadState::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  uint32_t resource_id;
  
  ::gfx::Size resource_size_in_pixels;
  
  bool premultiplied_alpha;
  
  ::gfx::PointF uv_top_left;
  
  ::gfx::PointF uv_bottom_right;
  
  uint32_t background_color;
  
  std::vector<float> vertex_opacity;
  
  bool y_flipped;
  
  bool nearest_neighbor;
  
  bool secure_output_only;
  
  bool is_video_frame;
  
  ::gfx::ProtectedVideoType protected_video_type;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TextureQuadState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TextureQuadState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TextureQuadState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TextureQuadState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  TileQuadState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TileQuadState, T>::value>;
  using DataView = TileQuadStateDataView;
  using Data_ = internal::TileQuadState_Data;

  template <typename... Args>
  static TileQuadStatePtr New(Args&&... args) {
    return TileQuadStatePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TileQuadStatePtr From(const U& u) {
    return mojo::TypeConverter<TileQuadStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TileQuadState>::Convert(*this);
  }


  TileQuadState();

  TileQuadState(
      const ::gfx::RectF& tex_coord_rect,
      const ::gfx::Size& texture_size,
      bool is_premultiplied,
      uint32_t resource_id,
      bool nearest_neighbor,
      bool force_anti_aliasing_off);

  ~TileQuadState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TileQuadStatePtr>
  TileQuadStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TileQuadState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TileQuadState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TileQuadState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TileQuadState_UnserializedMessageContext<
            UserType, TileQuadState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<TileQuadState::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return TileQuadState::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TileQuadState_UnserializedMessageContext<
            UserType, TileQuadState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TileQuadState::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::gfx::RectF tex_coord_rect;
  
  ::gfx::Size texture_size;
  
  bool is_premultiplied;
  
  uint32_t resource_id;
  
  bool nearest_neighbor;
  
  bool force_anti_aliasing_off;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TileQuadState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TileQuadState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TileQuadState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TileQuadState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  YUVVideoQuadState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<YUVVideoQuadState, T>::value>;
  using DataView = YUVVideoQuadStateDataView;
  using Data_ = internal::YUVVideoQuadState_Data;

  template <typename... Args>
  static YUVVideoQuadStatePtr New(Args&&... args) {
    return YUVVideoQuadStatePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static YUVVideoQuadStatePtr From(const U& u) {
    return mojo::TypeConverter<YUVVideoQuadStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, YUVVideoQuadState>::Convert(*this);
  }


  YUVVideoQuadState();

  YUVVideoQuadState(
      const ::gfx::RectF& ya_tex_coord_rect,
      const ::gfx::RectF& uv_tex_coord_rect,
      const ::gfx::Size& ya_tex_size,
      const ::gfx::Size& uv_tex_size,
      uint32_t y_plane_resource_id,
      uint32_t u_plane_resource_id,
      uint32_t v_plane_resource_id,
      uint32_t a_plane_resource_id,
      float resource_offset,
      float resource_multiplier,
      uint32_t bits_per_channel,
      const ::gfx::ColorSpace& video_color_space,
      ::gfx::ProtectedVideoType protected_video_type,
      const ::gl::HDRMetadata& hdr_metadata);

  ~YUVVideoQuadState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = YUVVideoQuadStatePtr>
  YUVVideoQuadStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, YUVVideoQuadState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        YUVVideoQuadState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        YUVVideoQuadState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::YUVVideoQuadState_UnserializedMessageContext<
            UserType, YUVVideoQuadState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<YUVVideoQuadState::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return YUVVideoQuadState::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::YUVVideoQuadState_UnserializedMessageContext<
            UserType, YUVVideoQuadState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<YUVVideoQuadState::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::gfx::RectF ya_tex_coord_rect;
  
  ::gfx::RectF uv_tex_coord_rect;
  
  ::gfx::Size ya_tex_size;
  
  ::gfx::Size uv_tex_size;
  
  uint32_t y_plane_resource_id;
  
  uint32_t u_plane_resource_id;
  
  uint32_t v_plane_resource_id;
  
  uint32_t a_plane_resource_id;
  
  float resource_offset;
  
  float resource_multiplier;
  
  uint32_t bits_per_channel;
  
  ::gfx::ColorSpace video_color_space;
  
  ::gfx::ProtectedVideoType protected_video_type;
  
  ::gl::HDRMetadata hdr_metadata;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, YUVVideoQuadState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, YUVVideoQuadState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, YUVVideoQuadState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, YUVVideoQuadState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  VideoHoleQuadState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoHoleQuadState, T>::value>;
  using DataView = VideoHoleQuadStateDataView;
  using Data_ = internal::VideoHoleQuadState_Data;

  template <typename... Args>
  static VideoHoleQuadStatePtr New(Args&&... args) {
    return VideoHoleQuadStatePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoHoleQuadStatePtr From(const U& u) {
    return mojo::TypeConverter<VideoHoleQuadStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoHoleQuadState>::Convert(*this);
  }


  VideoHoleQuadState();

  explicit VideoHoleQuadState(
      const ::base::UnguessableToken& overlay_plane_id);

  ~VideoHoleQuadState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoHoleQuadStatePtr>
  VideoHoleQuadStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoHoleQuadState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoHoleQuadState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoHoleQuadState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoHoleQuadState_UnserializedMessageContext<
            UserType, VideoHoleQuadState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<VideoHoleQuadState::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return VideoHoleQuadState::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoHoleQuadState_UnserializedMessageContext<
            UserType, VideoHoleQuadState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoHoleQuadState::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::base::UnguessableToken overlay_plane_id;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoHoleQuadState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoHoleQuadState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoHoleQuadState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoHoleQuadState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DrawQuad {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DrawQuad, T>::value>;
  using DataView = DrawQuadDataView;
  using Data_ = internal::DrawQuad_Data;

  template <typename... Args>
  static DrawQuadPtr New(Args&&... args) {
    return DrawQuadPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DrawQuadPtr From(const U& u) {
    return mojo::TypeConverter<DrawQuadPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DrawQuad>::Convert(*this);
  }


  DrawQuad();

  DrawQuad(
      const ::gfx::Rect& rect,
      const ::gfx::Rect& visible_rect,
      bool needs_blending,
      const base::Optional<::viz::SharedQuadState>& sqs,
      DrawQuadStatePtr draw_quad_state);

  ~DrawQuad();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DrawQuadPtr>
  DrawQuadPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DrawQuad::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DrawQuad::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DrawQuad::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DrawQuad_UnserializedMessageContext<
            UserType, DrawQuad::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DrawQuad::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return DrawQuad::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DrawQuad_UnserializedMessageContext<
            UserType, DrawQuad::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DrawQuad::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::gfx::Rect rect;
  
  ::gfx::Rect visible_rect;
  
  bool needs_blending;
  
  base::Optional<::viz::SharedQuadState> sqs;
  
  DrawQuadStatePtr draw_quad_state;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(DrawQuad);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DrawQuad::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DrawQuad::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DrawQuad::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DrawQuad::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
DrawQuadStatePtr DrawQuadState::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::DEBUG_BORDER_QUAD_STATE:
      rv->set_debug_border_quad_state(mojo::Clone(*data_.debug_border_quad_state));
      break;
    case Tag::RENDER_PASS_QUAD_STATE:
      rv->set_render_pass_quad_state(mojo::Clone(*data_.render_pass_quad_state));
      break;
    case Tag::SOLID_COLOR_QUAD_STATE:
      rv->set_solid_color_quad_state(mojo::Clone(*data_.solid_color_quad_state));
      break;
    case Tag::STREAM_VIDEO_QUAD_STATE:
      rv->set_stream_video_quad_state(mojo::Clone(*data_.stream_video_quad_state));
      break;
    case Tag::SURFACE_QUAD_STATE:
      rv->set_surface_quad_state(mojo::Clone(*data_.surface_quad_state));
      break;
    case Tag::TEXTURE_QUAD_STATE:
      rv->set_texture_quad_state(mojo::Clone(*data_.texture_quad_state));
      break;
    case Tag::TILE_QUAD_STATE:
      rv->set_tile_quad_state(mojo::Clone(*data_.tile_quad_state));
      break;
    case Tag::YUV_VIDEO_QUAD_STATE:
      rv->set_yuv_video_quad_state(mojo::Clone(*data_.yuv_video_quad_state));
      break;
    case Tag::VIDEO_HOLE_QUAD_STATE:
      rv->set_video_hole_quad_state(mojo::Clone(*data_.video_hole_quad_state));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, DrawQuadState>::value>::type*>
bool DrawQuadState::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::DEBUG_BORDER_QUAD_STATE:
      return mojo::Equals(*(data_.debug_border_quad_state), *(other.data_.debug_border_quad_state));
    case Tag::RENDER_PASS_QUAD_STATE:
      return mojo::Equals(*(data_.render_pass_quad_state), *(other.data_.render_pass_quad_state));
    case Tag::SOLID_COLOR_QUAD_STATE:
      return mojo::Equals(*(data_.solid_color_quad_state), *(other.data_.solid_color_quad_state));
    case Tag::STREAM_VIDEO_QUAD_STATE:
      return mojo::Equals(*(data_.stream_video_quad_state), *(other.data_.stream_video_quad_state));
    case Tag::SURFACE_QUAD_STATE:
      return mojo::Equals(*(data_.surface_quad_state), *(other.data_.surface_quad_state));
    case Tag::TEXTURE_QUAD_STATE:
      return mojo::Equals(*(data_.texture_quad_state), *(other.data_.texture_quad_state));
    case Tag::TILE_QUAD_STATE:
      return mojo::Equals(*(data_.tile_quad_state), *(other.data_.tile_quad_state));
    case Tag::YUV_VIDEO_QUAD_STATE:
      return mojo::Equals(*(data_.yuv_video_quad_state), *(other.data_.yuv_video_quad_state));
    case Tag::VIDEO_HOLE_QUAD_STATE:
      return mojo::Equals(*(data_.video_hole_quad_state), *(other.data_.video_hole_quad_state));
  }

  return false;
}
template <typename StructPtrType>
DebugBorderQuadStatePtr DebugBorderQuadState::Clone() const {
  return New(
      mojo::Clone(color),
      mojo::Clone(width)
  );
}

template <typename T, DebugBorderQuadState::EnableIfSame<T>*>
bool DebugBorderQuadState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->color, other_struct.color))
    return false;
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  return true;
}

template <typename T, DebugBorderQuadState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.color, rhs.color))
    return true;
  if (std::less<>{}(rhs.color, lhs.color))
    return false;
  if (std::less<>{}(lhs.width, rhs.width))
    return true;
  if (std::less<>{}(rhs.width, lhs.width))
    return false;
  return false;
}
template <typename StructPtrType>
CompositorRenderPassQuadStatePtr CompositorRenderPassQuadState::Clone() const {
  return New(
      mojo::Clone(render_pass_id),
      mojo::Clone(mask_resource_id),
      mojo::Clone(mask_uv_rect),
      mojo::Clone(mask_texture_size),
      mojo::Clone(filters_scale),
      mojo::Clone(filters_origin),
      mojo::Clone(tex_coord_rect),
      mojo::Clone(force_anti_aliasing_off),
      mojo::Clone(backdrop_filter_quality),
      mojo::Clone(can_use_backdrop_filter_cache)
  );
}

template <typename T, CompositorRenderPassQuadState::EnableIfSame<T>*>
bool CompositorRenderPassQuadState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->render_pass_id, other_struct.render_pass_id))
    return false;
  if (!mojo::Equals(this->mask_resource_id, other_struct.mask_resource_id))
    return false;
  if (!mojo::Equals(this->mask_uv_rect, other_struct.mask_uv_rect))
    return false;
  if (!mojo::Equals(this->mask_texture_size, other_struct.mask_texture_size))
    return false;
  if (!mojo::Equals(this->filters_scale, other_struct.filters_scale))
    return false;
  if (!mojo::Equals(this->filters_origin, other_struct.filters_origin))
    return false;
  if (!mojo::Equals(this->tex_coord_rect, other_struct.tex_coord_rect))
    return false;
  if (!mojo::Equals(this->force_anti_aliasing_off, other_struct.force_anti_aliasing_off))
    return false;
  if (!mojo::Equals(this->backdrop_filter_quality, other_struct.backdrop_filter_quality))
    return false;
  if (!mojo::Equals(this->can_use_backdrop_filter_cache, other_struct.can_use_backdrop_filter_cache))
    return false;
  return true;
}

template <typename T, CompositorRenderPassQuadState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.render_pass_id, rhs.render_pass_id))
    return true;
  if (std::less<>{}(rhs.render_pass_id, lhs.render_pass_id))
    return false;
  if (std::less<>{}(lhs.mask_resource_id, rhs.mask_resource_id))
    return true;
  if (std::less<>{}(rhs.mask_resource_id, lhs.mask_resource_id))
    return false;
  if (std::less<>{}(lhs.mask_uv_rect, rhs.mask_uv_rect))
    return true;
  if (std::less<>{}(rhs.mask_uv_rect, lhs.mask_uv_rect))
    return false;
  if (std::less<>{}(lhs.mask_texture_size, rhs.mask_texture_size))
    return true;
  if (std::less<>{}(rhs.mask_texture_size, lhs.mask_texture_size))
    return false;
  if (std::less<>{}(lhs.filters_scale, rhs.filters_scale))
    return true;
  if (std::less<>{}(rhs.filters_scale, lhs.filters_scale))
    return false;
  if (std::less<>{}(lhs.filters_origin, rhs.filters_origin))
    return true;
  if (std::less<>{}(rhs.filters_origin, lhs.filters_origin))
    return false;
  if (std::less<>{}(lhs.tex_coord_rect, rhs.tex_coord_rect))
    return true;
  if (std::less<>{}(rhs.tex_coord_rect, lhs.tex_coord_rect))
    return false;
  if (std::less<>{}(lhs.force_anti_aliasing_off, rhs.force_anti_aliasing_off))
    return true;
  if (std::less<>{}(rhs.force_anti_aliasing_off, lhs.force_anti_aliasing_off))
    return false;
  if (std::less<>{}(lhs.backdrop_filter_quality, rhs.backdrop_filter_quality))
    return true;
  if (std::less<>{}(rhs.backdrop_filter_quality, lhs.backdrop_filter_quality))
    return false;
  if (std::less<>{}(lhs.can_use_backdrop_filter_cache, rhs.can_use_backdrop_filter_cache))
    return true;
  if (std::less<>{}(rhs.can_use_backdrop_filter_cache, lhs.can_use_backdrop_filter_cache))
    return false;
  return false;
}
template <typename StructPtrType>
SolidColorQuadStatePtr SolidColorQuadState::Clone() const {
  return New(
      mojo::Clone(color),
      mojo::Clone(force_anti_aliasing_off)
  );
}

template <typename T, SolidColorQuadState::EnableIfSame<T>*>
bool SolidColorQuadState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->color, other_struct.color))
    return false;
  if (!mojo::Equals(this->force_anti_aliasing_off, other_struct.force_anti_aliasing_off))
    return false;
  return true;
}

template <typename T, SolidColorQuadState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.color, rhs.color))
    return true;
  if (std::less<>{}(rhs.color, lhs.color))
    return false;
  if (std::less<>{}(lhs.force_anti_aliasing_off, rhs.force_anti_aliasing_off))
    return true;
  if (std::less<>{}(rhs.force_anti_aliasing_off, lhs.force_anti_aliasing_off))
    return false;
  return false;
}
template <typename StructPtrType>
StreamVideoQuadStatePtr StreamVideoQuadState::Clone() const {
  return New(
      mojo::Clone(resource_id),
      mojo::Clone(resource_size_in_pixels),
      mojo::Clone(uv_top_left),
      mojo::Clone(uv_bottom_right)
  );
}

template <typename T, StreamVideoQuadState::EnableIfSame<T>*>
bool StreamVideoQuadState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->resource_id, other_struct.resource_id))
    return false;
  if (!mojo::Equals(this->resource_size_in_pixels, other_struct.resource_size_in_pixels))
    return false;
  if (!mojo::Equals(this->uv_top_left, other_struct.uv_top_left))
    return false;
  if (!mojo::Equals(this->uv_bottom_right, other_struct.uv_bottom_right))
    return false;
  return true;
}

template <typename T, StreamVideoQuadState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.resource_id, rhs.resource_id))
    return true;
  if (std::less<>{}(rhs.resource_id, lhs.resource_id))
    return false;
  if (std::less<>{}(lhs.resource_size_in_pixels, rhs.resource_size_in_pixels))
    return true;
  if (std::less<>{}(rhs.resource_size_in_pixels, lhs.resource_size_in_pixels))
    return false;
  if (std::less<>{}(lhs.uv_top_left, rhs.uv_top_left))
    return true;
  if (std::less<>{}(rhs.uv_top_left, lhs.uv_top_left))
    return false;
  if (std::less<>{}(lhs.uv_bottom_right, rhs.uv_bottom_right))
    return true;
  if (std::less<>{}(rhs.uv_bottom_right, lhs.uv_bottom_right))
    return false;
  return false;
}
template <typename StructPtrType>
SurfaceQuadStatePtr SurfaceQuadState::Clone() const {
  return New(
      mojo::Clone(surface_range),
      mojo::Clone(default_background_color),
      mojo::Clone(stretch_content_to_fill_bounds),
      mojo::Clone(is_reflection),
      mojo::Clone(allow_merge)
  );
}

template <typename T, SurfaceQuadState::EnableIfSame<T>*>
bool SurfaceQuadState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->surface_range, other_struct.surface_range))
    return false;
  if (!mojo::Equals(this->default_background_color, other_struct.default_background_color))
    return false;
  if (!mojo::Equals(this->stretch_content_to_fill_bounds, other_struct.stretch_content_to_fill_bounds))
    return false;
  if (!mojo::Equals(this->is_reflection, other_struct.is_reflection))
    return false;
  if (!mojo::Equals(this->allow_merge, other_struct.allow_merge))
    return false;
  return true;
}

template <typename T, SurfaceQuadState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.surface_range, rhs.surface_range))
    return true;
  if (std::less<>{}(rhs.surface_range, lhs.surface_range))
    return false;
  if (std::less<>{}(lhs.default_background_color, rhs.default_background_color))
    return true;
  if (std::less<>{}(rhs.default_background_color, lhs.default_background_color))
    return false;
  if (std::less<>{}(lhs.stretch_content_to_fill_bounds, rhs.stretch_content_to_fill_bounds))
    return true;
  if (std::less<>{}(rhs.stretch_content_to_fill_bounds, lhs.stretch_content_to_fill_bounds))
    return false;
  if (std::less<>{}(lhs.is_reflection, rhs.is_reflection))
    return true;
  if (std::less<>{}(rhs.is_reflection, lhs.is_reflection))
    return false;
  if (std::less<>{}(lhs.allow_merge, rhs.allow_merge))
    return true;
  if (std::less<>{}(rhs.allow_merge, lhs.allow_merge))
    return false;
  return false;
}
template <typename StructPtrType>
TextureQuadStatePtr TextureQuadState::Clone() const {
  return New(
      mojo::Clone(resource_id),
      mojo::Clone(resource_size_in_pixels),
      mojo::Clone(premultiplied_alpha),
      mojo::Clone(uv_top_left),
      mojo::Clone(uv_bottom_right),
      mojo::Clone(background_color),
      mojo::Clone(vertex_opacity),
      mojo::Clone(y_flipped),
      mojo::Clone(nearest_neighbor),
      mojo::Clone(secure_output_only),
      mojo::Clone(is_video_frame),
      mojo::Clone(protected_video_type)
  );
}

template <typename T, TextureQuadState::EnableIfSame<T>*>
bool TextureQuadState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->resource_id, other_struct.resource_id))
    return false;
  if (!mojo::Equals(this->resource_size_in_pixels, other_struct.resource_size_in_pixels))
    return false;
  if (!mojo::Equals(this->premultiplied_alpha, other_struct.premultiplied_alpha))
    return false;
  if (!mojo::Equals(this->uv_top_left, other_struct.uv_top_left))
    return false;
  if (!mojo::Equals(this->uv_bottom_right, other_struct.uv_bottom_right))
    return false;
  if (!mojo::Equals(this->background_color, other_struct.background_color))
    return false;
  if (!mojo::Equals(this->vertex_opacity, other_struct.vertex_opacity))
    return false;
  if (!mojo::Equals(this->y_flipped, other_struct.y_flipped))
    return false;
  if (!mojo::Equals(this->nearest_neighbor, other_struct.nearest_neighbor))
    return false;
  if (!mojo::Equals(this->secure_output_only, other_struct.secure_output_only))
    return false;
  if (!mojo::Equals(this->is_video_frame, other_struct.is_video_frame))
    return false;
  if (!mojo::Equals(this->protected_video_type, other_struct.protected_video_type))
    return false;
  return true;
}

template <typename T, TextureQuadState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.resource_id, rhs.resource_id))
    return true;
  if (std::less<>{}(rhs.resource_id, lhs.resource_id))
    return false;
  if (std::less<>{}(lhs.resource_size_in_pixels, rhs.resource_size_in_pixels))
    return true;
  if (std::less<>{}(rhs.resource_size_in_pixels, lhs.resource_size_in_pixels))
    return false;
  if (std::less<>{}(lhs.premultiplied_alpha, rhs.premultiplied_alpha))
    return true;
  if (std::less<>{}(rhs.premultiplied_alpha, lhs.premultiplied_alpha))
    return false;
  if (std::less<>{}(lhs.uv_top_left, rhs.uv_top_left))
    return true;
  if (std::less<>{}(rhs.uv_top_left, lhs.uv_top_left))
    return false;
  if (std::less<>{}(lhs.uv_bottom_right, rhs.uv_bottom_right))
    return true;
  if (std::less<>{}(rhs.uv_bottom_right, lhs.uv_bottom_right))
    return false;
  if (std::less<>{}(lhs.background_color, rhs.background_color))
    return true;
  if (std::less<>{}(rhs.background_color, lhs.background_color))
    return false;
  if (std::less<>{}(lhs.vertex_opacity, rhs.vertex_opacity))
    return true;
  if (std::less<>{}(rhs.vertex_opacity, lhs.vertex_opacity))
    return false;
  if (std::less<>{}(lhs.y_flipped, rhs.y_flipped))
    return true;
  if (std::less<>{}(rhs.y_flipped, lhs.y_flipped))
    return false;
  if (std::less<>{}(lhs.nearest_neighbor, rhs.nearest_neighbor))
    return true;
  if (std::less<>{}(rhs.nearest_neighbor, lhs.nearest_neighbor))
    return false;
  if (std::less<>{}(lhs.secure_output_only, rhs.secure_output_only))
    return true;
  if (std::less<>{}(rhs.secure_output_only, lhs.secure_output_only))
    return false;
  if (std::less<>{}(lhs.is_video_frame, rhs.is_video_frame))
    return true;
  if (std::less<>{}(rhs.is_video_frame, lhs.is_video_frame))
    return false;
  if (std::less<>{}(lhs.protected_video_type, rhs.protected_video_type))
    return true;
  if (std::less<>{}(rhs.protected_video_type, lhs.protected_video_type))
    return false;
  return false;
}
template <typename StructPtrType>
TileQuadStatePtr TileQuadState::Clone() const {
  return New(
      mojo::Clone(tex_coord_rect),
      mojo::Clone(texture_size),
      mojo::Clone(is_premultiplied),
      mojo::Clone(resource_id),
      mojo::Clone(nearest_neighbor),
      mojo::Clone(force_anti_aliasing_off)
  );
}

template <typename T, TileQuadState::EnableIfSame<T>*>
bool TileQuadState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tex_coord_rect, other_struct.tex_coord_rect))
    return false;
  if (!mojo::Equals(this->texture_size, other_struct.texture_size))
    return false;
  if (!mojo::Equals(this->is_premultiplied, other_struct.is_premultiplied))
    return false;
  if (!mojo::Equals(this->resource_id, other_struct.resource_id))
    return false;
  if (!mojo::Equals(this->nearest_neighbor, other_struct.nearest_neighbor))
    return false;
  if (!mojo::Equals(this->force_anti_aliasing_off, other_struct.force_anti_aliasing_off))
    return false;
  return true;
}

template <typename T, TileQuadState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.tex_coord_rect, rhs.tex_coord_rect))
    return true;
  if (std::less<>{}(rhs.tex_coord_rect, lhs.tex_coord_rect))
    return false;
  if (std::less<>{}(lhs.texture_size, rhs.texture_size))
    return true;
  if (std::less<>{}(rhs.texture_size, lhs.texture_size))
    return false;
  if (std::less<>{}(lhs.is_premultiplied, rhs.is_premultiplied))
    return true;
  if (std::less<>{}(rhs.is_premultiplied, lhs.is_premultiplied))
    return false;
  if (std::less<>{}(lhs.resource_id, rhs.resource_id))
    return true;
  if (std::less<>{}(rhs.resource_id, lhs.resource_id))
    return false;
  if (std::less<>{}(lhs.nearest_neighbor, rhs.nearest_neighbor))
    return true;
  if (std::less<>{}(rhs.nearest_neighbor, lhs.nearest_neighbor))
    return false;
  if (std::less<>{}(lhs.force_anti_aliasing_off, rhs.force_anti_aliasing_off))
    return true;
  if (std::less<>{}(rhs.force_anti_aliasing_off, lhs.force_anti_aliasing_off))
    return false;
  return false;
}
template <typename StructPtrType>
YUVVideoQuadStatePtr YUVVideoQuadState::Clone() const {
  return New(
      mojo::Clone(ya_tex_coord_rect),
      mojo::Clone(uv_tex_coord_rect),
      mojo::Clone(ya_tex_size),
      mojo::Clone(uv_tex_size),
      mojo::Clone(y_plane_resource_id),
      mojo::Clone(u_plane_resource_id),
      mojo::Clone(v_plane_resource_id),
      mojo::Clone(a_plane_resource_id),
      mojo::Clone(resource_offset),
      mojo::Clone(resource_multiplier),
      mojo::Clone(bits_per_channel),
      mojo::Clone(video_color_space),
      mojo::Clone(protected_video_type),
      mojo::Clone(hdr_metadata)
  );
}

template <typename T, YUVVideoQuadState::EnableIfSame<T>*>
bool YUVVideoQuadState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->ya_tex_coord_rect, other_struct.ya_tex_coord_rect))
    return false;
  if (!mojo::Equals(this->uv_tex_coord_rect, other_struct.uv_tex_coord_rect))
    return false;
  if (!mojo::Equals(this->ya_tex_size, other_struct.ya_tex_size))
    return false;
  if (!mojo::Equals(this->uv_tex_size, other_struct.uv_tex_size))
    return false;
  if (!mojo::Equals(this->y_plane_resource_id, other_struct.y_plane_resource_id))
    return false;
  if (!mojo::Equals(this->u_plane_resource_id, other_struct.u_plane_resource_id))
    return false;
  if (!mojo::Equals(this->v_plane_resource_id, other_struct.v_plane_resource_id))
    return false;
  if (!mojo::Equals(this->a_plane_resource_id, other_struct.a_plane_resource_id))
    return false;
  if (!mojo::Equals(this->resource_offset, other_struct.resource_offset))
    return false;
  if (!mojo::Equals(this->resource_multiplier, other_struct.resource_multiplier))
    return false;
  if (!mojo::Equals(this->bits_per_channel, other_struct.bits_per_channel))
    return false;
  if (!mojo::Equals(this->video_color_space, other_struct.video_color_space))
    return false;
  if (!mojo::Equals(this->protected_video_type, other_struct.protected_video_type))
    return false;
  if (!mojo::Equals(this->hdr_metadata, other_struct.hdr_metadata))
    return false;
  return true;
}

template <typename T, YUVVideoQuadState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.ya_tex_coord_rect, rhs.ya_tex_coord_rect))
    return true;
  if (std::less<>{}(rhs.ya_tex_coord_rect, lhs.ya_tex_coord_rect))
    return false;
  if (std::less<>{}(lhs.uv_tex_coord_rect, rhs.uv_tex_coord_rect))
    return true;
  if (std::less<>{}(rhs.uv_tex_coord_rect, lhs.uv_tex_coord_rect))
    return false;
  if (std::less<>{}(lhs.ya_tex_size, rhs.ya_tex_size))
    return true;
  if (std::less<>{}(rhs.ya_tex_size, lhs.ya_tex_size))
    return false;
  if (std::less<>{}(lhs.uv_tex_size, rhs.uv_tex_size))
    return true;
  if (std::less<>{}(rhs.uv_tex_size, lhs.uv_tex_size))
    return false;
  if (std::less<>{}(lhs.y_plane_resource_id, rhs.y_plane_resource_id))
    return true;
  if (std::less<>{}(rhs.y_plane_resource_id, lhs.y_plane_resource_id))
    return false;
  if (std::less<>{}(lhs.u_plane_resource_id, rhs.u_plane_resource_id))
    return true;
  if (std::less<>{}(rhs.u_plane_resource_id, lhs.u_plane_resource_id))
    return false;
  if (std::less<>{}(lhs.v_plane_resource_id, rhs.v_plane_resource_id))
    return true;
  if (std::less<>{}(rhs.v_plane_resource_id, lhs.v_plane_resource_id))
    return false;
  if (std::less<>{}(lhs.a_plane_resource_id, rhs.a_plane_resource_id))
    return true;
  if (std::less<>{}(rhs.a_plane_resource_id, lhs.a_plane_resource_id))
    return false;
  if (std::less<>{}(lhs.resource_offset, rhs.resource_offset))
    return true;
  if (std::less<>{}(rhs.resource_offset, lhs.resource_offset))
    return false;
  if (std::less<>{}(lhs.resource_multiplier, rhs.resource_multiplier))
    return true;
  if (std::less<>{}(rhs.resource_multiplier, lhs.resource_multiplier))
    return false;
  if (std::less<>{}(lhs.bits_per_channel, rhs.bits_per_channel))
    return true;
  if (std::less<>{}(rhs.bits_per_channel, lhs.bits_per_channel))
    return false;
  if (std::less<>{}(lhs.video_color_space, rhs.video_color_space))
    return true;
  if (std::less<>{}(rhs.video_color_space, lhs.video_color_space))
    return false;
  if (std::less<>{}(lhs.protected_video_type, rhs.protected_video_type))
    return true;
  if (std::less<>{}(rhs.protected_video_type, lhs.protected_video_type))
    return false;
  if (std::less<>{}(lhs.hdr_metadata, rhs.hdr_metadata))
    return true;
  if (std::less<>{}(rhs.hdr_metadata, lhs.hdr_metadata))
    return false;
  return false;
}
template <typename StructPtrType>
VideoHoleQuadStatePtr VideoHoleQuadState::Clone() const {
  return New(
      mojo::Clone(overlay_plane_id)
  );
}

template <typename T, VideoHoleQuadState::EnableIfSame<T>*>
bool VideoHoleQuadState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->overlay_plane_id, other_struct.overlay_plane_id))
    return false;
  return true;
}

template <typename T, VideoHoleQuadState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.overlay_plane_id, rhs.overlay_plane_id))
    return true;
  if (std::less<>{}(rhs.overlay_plane_id, lhs.overlay_plane_id))
    return false;
  return false;
}
template <typename StructPtrType>
DrawQuadPtr DrawQuad::Clone() const {
  return New(
      mojo::Clone(rect),
      mojo::Clone(visible_rect),
      mojo::Clone(needs_blending),
      mojo::Clone(sqs),
      mojo::Clone(draw_quad_state)
  );
}

template <typename T, DrawQuad::EnableIfSame<T>*>
bool DrawQuad::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->rect, other_struct.rect))
    return false;
  if (!mojo::Equals(this->visible_rect, other_struct.visible_rect))
    return false;
  if (!mojo::Equals(this->needs_blending, other_struct.needs_blending))
    return false;
  if (!mojo::Equals(this->sqs, other_struct.sqs))
    return false;
  if (!mojo::Equals(this->draw_quad_state, other_struct.draw_quad_state))
    return false;
  return true;
}

template <typename T, DrawQuad::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.rect, rhs.rect))
    return true;
  if (std::less<>{}(rhs.rect, lhs.rect))
    return false;
  if (std::less<>{}(lhs.visible_rect, rhs.visible_rect))
    return true;
  if (std::less<>{}(rhs.visible_rect, lhs.visible_rect))
    return false;
  if (std::less<>{}(lhs.needs_blending, rhs.needs_blending))
    return true;
  if (std::less<>{}(rhs.needs_blending, lhs.needs_blending))
    return false;
  if (std::less<>{}(lhs.sqs, rhs.sqs))
    return true;
  if (std::less<>{}(rhs.sqs, lhs.sqs))
    return false;
  if (std::less<>{}(lhs.draw_quad_state, rhs.draw_quad_state))
    return true;
  if (std::less<>{}(rhs.draw_quad_state, lhs.draw_quad_state))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace viz

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::DebugBorderQuadState::DataView,
                                         ::viz::mojom::DebugBorderQuadStatePtr> {
  static bool IsNull(const ::viz::mojom::DebugBorderQuadStatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::DebugBorderQuadStatePtr* output) { output->reset(); }

  static decltype(::viz::mojom::DebugBorderQuadState::color) color(
      const ::viz::mojom::DebugBorderQuadStatePtr& input) {
    return input->color;
  }

  static decltype(::viz::mojom::DebugBorderQuadState::width) width(
      const ::viz::mojom::DebugBorderQuadStatePtr& input) {
    return input->width;
  }

  static bool Read(::viz::mojom::DebugBorderQuadState::DataView input, ::viz::mojom::DebugBorderQuadStatePtr* output);
};


template <>
struct  StructTraits<::viz::mojom::CompositorRenderPassQuadState::DataView,
                                         ::viz::mojom::CompositorRenderPassQuadStatePtr> {
  static bool IsNull(const ::viz::mojom::CompositorRenderPassQuadStatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::CompositorRenderPassQuadStatePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::CompositorRenderPassQuadState::render_pass_id)& render_pass_id(
      const ::viz::mojom::CompositorRenderPassQuadStatePtr& input) {
    return input->render_pass_id;
  }

  static decltype(::viz::mojom::CompositorRenderPassQuadState::mask_resource_id) mask_resource_id(
      const ::viz::mojom::CompositorRenderPassQuadStatePtr& input) {
    return input->mask_resource_id;
  }

  static const decltype(::viz::mojom::CompositorRenderPassQuadState::mask_uv_rect)& mask_uv_rect(
      const ::viz::mojom::CompositorRenderPassQuadStatePtr& input) {
    return input->mask_uv_rect;
  }

  static const decltype(::viz::mojom::CompositorRenderPassQuadState::mask_texture_size)& mask_texture_size(
      const ::viz::mojom::CompositorRenderPassQuadStatePtr& input) {
    return input->mask_texture_size;
  }

  static const decltype(::viz::mojom::CompositorRenderPassQuadState::filters_scale)& filters_scale(
      const ::viz::mojom::CompositorRenderPassQuadStatePtr& input) {
    return input->filters_scale;
  }

  static const decltype(::viz::mojom::CompositorRenderPassQuadState::filters_origin)& filters_origin(
      const ::viz::mojom::CompositorRenderPassQuadStatePtr& input) {
    return input->filters_origin;
  }

  static const decltype(::viz::mojom::CompositorRenderPassQuadState::tex_coord_rect)& tex_coord_rect(
      const ::viz::mojom::CompositorRenderPassQuadStatePtr& input) {
    return input->tex_coord_rect;
  }

  static decltype(::viz::mojom::CompositorRenderPassQuadState::force_anti_aliasing_off) force_anti_aliasing_off(
      const ::viz::mojom::CompositorRenderPassQuadStatePtr& input) {
    return input->force_anti_aliasing_off;
  }

  static decltype(::viz::mojom::CompositorRenderPassQuadState::backdrop_filter_quality) backdrop_filter_quality(
      const ::viz::mojom::CompositorRenderPassQuadStatePtr& input) {
    return input->backdrop_filter_quality;
  }

  static decltype(::viz::mojom::CompositorRenderPassQuadState::can_use_backdrop_filter_cache) can_use_backdrop_filter_cache(
      const ::viz::mojom::CompositorRenderPassQuadStatePtr& input) {
    return input->can_use_backdrop_filter_cache;
  }

  static bool Read(::viz::mojom::CompositorRenderPassQuadState::DataView input, ::viz::mojom::CompositorRenderPassQuadStatePtr* output);
};


template <>
struct  StructTraits<::viz::mojom::SolidColorQuadState::DataView,
                                         ::viz::mojom::SolidColorQuadStatePtr> {
  static bool IsNull(const ::viz::mojom::SolidColorQuadStatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::SolidColorQuadStatePtr* output) { output->reset(); }

  static decltype(::viz::mojom::SolidColorQuadState::color) color(
      const ::viz::mojom::SolidColorQuadStatePtr& input) {
    return input->color;
  }

  static decltype(::viz::mojom::SolidColorQuadState::force_anti_aliasing_off) force_anti_aliasing_off(
      const ::viz::mojom::SolidColorQuadStatePtr& input) {
    return input->force_anti_aliasing_off;
  }

  static bool Read(::viz::mojom::SolidColorQuadState::DataView input, ::viz::mojom::SolidColorQuadStatePtr* output);
};


template <>
struct  StructTraits<::viz::mojom::StreamVideoQuadState::DataView,
                                         ::viz::mojom::StreamVideoQuadStatePtr> {
  static bool IsNull(const ::viz::mojom::StreamVideoQuadStatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::StreamVideoQuadStatePtr* output) { output->reset(); }

  static decltype(::viz::mojom::StreamVideoQuadState::resource_id) resource_id(
      const ::viz::mojom::StreamVideoQuadStatePtr& input) {
    return input->resource_id;
  }

  static const decltype(::viz::mojom::StreamVideoQuadState::resource_size_in_pixels)& resource_size_in_pixels(
      const ::viz::mojom::StreamVideoQuadStatePtr& input) {
    return input->resource_size_in_pixels;
  }

  static const decltype(::viz::mojom::StreamVideoQuadState::uv_top_left)& uv_top_left(
      const ::viz::mojom::StreamVideoQuadStatePtr& input) {
    return input->uv_top_left;
  }

  static const decltype(::viz::mojom::StreamVideoQuadState::uv_bottom_right)& uv_bottom_right(
      const ::viz::mojom::StreamVideoQuadStatePtr& input) {
    return input->uv_bottom_right;
  }

  static bool Read(::viz::mojom::StreamVideoQuadState::DataView input, ::viz::mojom::StreamVideoQuadStatePtr* output);
};


template <>
struct  StructTraits<::viz::mojom::SurfaceQuadState::DataView,
                                         ::viz::mojom::SurfaceQuadStatePtr> {
  static bool IsNull(const ::viz::mojom::SurfaceQuadStatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::SurfaceQuadStatePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::SurfaceQuadState::surface_range)& surface_range(
      const ::viz::mojom::SurfaceQuadStatePtr& input) {
    return input->surface_range;
  }

  static decltype(::viz::mojom::SurfaceQuadState::default_background_color) default_background_color(
      const ::viz::mojom::SurfaceQuadStatePtr& input) {
    return input->default_background_color;
  }

  static decltype(::viz::mojom::SurfaceQuadState::stretch_content_to_fill_bounds) stretch_content_to_fill_bounds(
      const ::viz::mojom::SurfaceQuadStatePtr& input) {
    return input->stretch_content_to_fill_bounds;
  }

  static decltype(::viz::mojom::SurfaceQuadState::is_reflection) is_reflection(
      const ::viz::mojom::SurfaceQuadStatePtr& input) {
    return input->is_reflection;
  }

  static decltype(::viz::mojom::SurfaceQuadState::allow_merge) allow_merge(
      const ::viz::mojom::SurfaceQuadStatePtr& input) {
    return input->allow_merge;
  }

  static bool Read(::viz::mojom::SurfaceQuadState::DataView input, ::viz::mojom::SurfaceQuadStatePtr* output);
};


template <>
struct  StructTraits<::viz::mojom::TextureQuadState::DataView,
                                         ::viz::mojom::TextureQuadStatePtr> {
  static bool IsNull(const ::viz::mojom::TextureQuadStatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::TextureQuadStatePtr* output) { output->reset(); }

  static decltype(::viz::mojom::TextureQuadState::resource_id) resource_id(
      const ::viz::mojom::TextureQuadStatePtr& input) {
    return input->resource_id;
  }

  static const decltype(::viz::mojom::TextureQuadState::resource_size_in_pixels)& resource_size_in_pixels(
      const ::viz::mojom::TextureQuadStatePtr& input) {
    return input->resource_size_in_pixels;
  }

  static decltype(::viz::mojom::TextureQuadState::premultiplied_alpha) premultiplied_alpha(
      const ::viz::mojom::TextureQuadStatePtr& input) {
    return input->premultiplied_alpha;
  }

  static const decltype(::viz::mojom::TextureQuadState::uv_top_left)& uv_top_left(
      const ::viz::mojom::TextureQuadStatePtr& input) {
    return input->uv_top_left;
  }

  static const decltype(::viz::mojom::TextureQuadState::uv_bottom_right)& uv_bottom_right(
      const ::viz::mojom::TextureQuadStatePtr& input) {
    return input->uv_bottom_right;
  }

  static decltype(::viz::mojom::TextureQuadState::background_color) background_color(
      const ::viz::mojom::TextureQuadStatePtr& input) {
    return input->background_color;
  }

  static const decltype(::viz::mojom::TextureQuadState::vertex_opacity)& vertex_opacity(
      const ::viz::mojom::TextureQuadStatePtr& input) {
    return input->vertex_opacity;
  }

  static decltype(::viz::mojom::TextureQuadState::y_flipped) y_flipped(
      const ::viz::mojom::TextureQuadStatePtr& input) {
    return input->y_flipped;
  }

  static decltype(::viz::mojom::TextureQuadState::nearest_neighbor) nearest_neighbor(
      const ::viz::mojom::TextureQuadStatePtr& input) {
    return input->nearest_neighbor;
  }

  static decltype(::viz::mojom::TextureQuadState::secure_output_only) secure_output_only(
      const ::viz::mojom::TextureQuadStatePtr& input) {
    return input->secure_output_only;
  }

  static decltype(::viz::mojom::TextureQuadState::is_video_frame) is_video_frame(
      const ::viz::mojom::TextureQuadStatePtr& input) {
    return input->is_video_frame;
  }

  static decltype(::viz::mojom::TextureQuadState::protected_video_type) protected_video_type(
      const ::viz::mojom::TextureQuadStatePtr& input) {
    return input->protected_video_type;
  }

  static bool Read(::viz::mojom::TextureQuadState::DataView input, ::viz::mojom::TextureQuadStatePtr* output);
};


template <>
struct  StructTraits<::viz::mojom::TileQuadState::DataView,
                                         ::viz::mojom::TileQuadStatePtr> {
  static bool IsNull(const ::viz::mojom::TileQuadStatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::TileQuadStatePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::TileQuadState::tex_coord_rect)& tex_coord_rect(
      const ::viz::mojom::TileQuadStatePtr& input) {
    return input->tex_coord_rect;
  }

  static const decltype(::viz::mojom::TileQuadState::texture_size)& texture_size(
      const ::viz::mojom::TileQuadStatePtr& input) {
    return input->texture_size;
  }

  static decltype(::viz::mojom::TileQuadState::is_premultiplied) is_premultiplied(
      const ::viz::mojom::TileQuadStatePtr& input) {
    return input->is_premultiplied;
  }

  static decltype(::viz::mojom::TileQuadState::resource_id) resource_id(
      const ::viz::mojom::TileQuadStatePtr& input) {
    return input->resource_id;
  }

  static decltype(::viz::mojom::TileQuadState::nearest_neighbor) nearest_neighbor(
      const ::viz::mojom::TileQuadStatePtr& input) {
    return input->nearest_neighbor;
  }

  static decltype(::viz::mojom::TileQuadState::force_anti_aliasing_off) force_anti_aliasing_off(
      const ::viz::mojom::TileQuadStatePtr& input) {
    return input->force_anti_aliasing_off;
  }

  static bool Read(::viz::mojom::TileQuadState::DataView input, ::viz::mojom::TileQuadStatePtr* output);
};


template <>
struct  StructTraits<::viz::mojom::YUVVideoQuadState::DataView,
                                         ::viz::mojom::YUVVideoQuadStatePtr> {
  static bool IsNull(const ::viz::mojom::YUVVideoQuadStatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::YUVVideoQuadStatePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::YUVVideoQuadState::ya_tex_coord_rect)& ya_tex_coord_rect(
      const ::viz::mojom::YUVVideoQuadStatePtr& input) {
    return input->ya_tex_coord_rect;
  }

  static const decltype(::viz::mojom::YUVVideoQuadState::uv_tex_coord_rect)& uv_tex_coord_rect(
      const ::viz::mojom::YUVVideoQuadStatePtr& input) {
    return input->uv_tex_coord_rect;
  }

  static const decltype(::viz::mojom::YUVVideoQuadState::ya_tex_size)& ya_tex_size(
      const ::viz::mojom::YUVVideoQuadStatePtr& input) {
    return input->ya_tex_size;
  }

  static const decltype(::viz::mojom::YUVVideoQuadState::uv_tex_size)& uv_tex_size(
      const ::viz::mojom::YUVVideoQuadStatePtr& input) {
    return input->uv_tex_size;
  }

  static decltype(::viz::mojom::YUVVideoQuadState::y_plane_resource_id) y_plane_resource_id(
      const ::viz::mojom::YUVVideoQuadStatePtr& input) {
    return input->y_plane_resource_id;
  }

  static decltype(::viz::mojom::YUVVideoQuadState::u_plane_resource_id) u_plane_resource_id(
      const ::viz::mojom::YUVVideoQuadStatePtr& input) {
    return input->u_plane_resource_id;
  }

  static decltype(::viz::mojom::YUVVideoQuadState::v_plane_resource_id) v_plane_resource_id(
      const ::viz::mojom::YUVVideoQuadStatePtr& input) {
    return input->v_plane_resource_id;
  }

  static decltype(::viz::mojom::YUVVideoQuadState::a_plane_resource_id) a_plane_resource_id(
      const ::viz::mojom::YUVVideoQuadStatePtr& input) {
    return input->a_plane_resource_id;
  }

  static decltype(::viz::mojom::YUVVideoQuadState::resource_offset) resource_offset(
      const ::viz::mojom::YUVVideoQuadStatePtr& input) {
    return input->resource_offset;
  }

  static decltype(::viz::mojom::YUVVideoQuadState::resource_multiplier) resource_multiplier(
      const ::viz::mojom::YUVVideoQuadStatePtr& input) {
    return input->resource_multiplier;
  }

  static decltype(::viz::mojom::YUVVideoQuadState::bits_per_channel) bits_per_channel(
      const ::viz::mojom::YUVVideoQuadStatePtr& input) {
    return input->bits_per_channel;
  }

  static const decltype(::viz::mojom::YUVVideoQuadState::video_color_space)& video_color_space(
      const ::viz::mojom::YUVVideoQuadStatePtr& input) {
    return input->video_color_space;
  }

  static decltype(::viz::mojom::YUVVideoQuadState::protected_video_type) protected_video_type(
      const ::viz::mojom::YUVVideoQuadStatePtr& input) {
    return input->protected_video_type;
  }

  static const decltype(::viz::mojom::YUVVideoQuadState::hdr_metadata)& hdr_metadata(
      const ::viz::mojom::YUVVideoQuadStatePtr& input) {
    return input->hdr_metadata;
  }

  static bool Read(::viz::mojom::YUVVideoQuadState::DataView input, ::viz::mojom::YUVVideoQuadStatePtr* output);
};


template <>
struct  StructTraits<::viz::mojom::VideoHoleQuadState::DataView,
                                         ::viz::mojom::VideoHoleQuadStatePtr> {
  static bool IsNull(const ::viz::mojom::VideoHoleQuadStatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::VideoHoleQuadStatePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::VideoHoleQuadState::overlay_plane_id)& overlay_plane_id(
      const ::viz::mojom::VideoHoleQuadStatePtr& input) {
    return input->overlay_plane_id;
  }

  static bool Read(::viz::mojom::VideoHoleQuadState::DataView input, ::viz::mojom::VideoHoleQuadStatePtr* output);
};


template <>
struct  StructTraits<::viz::mojom::DrawQuad::DataView,
                                         ::viz::mojom::DrawQuadPtr> {
  static bool IsNull(const ::viz::mojom::DrawQuadPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::DrawQuadPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::DrawQuad::rect)& rect(
      const ::viz::mojom::DrawQuadPtr& input) {
    return input->rect;
  }

  static const decltype(::viz::mojom::DrawQuad::visible_rect)& visible_rect(
      const ::viz::mojom::DrawQuadPtr& input) {
    return input->visible_rect;
  }

  static decltype(::viz::mojom::DrawQuad::needs_blending) needs_blending(
      const ::viz::mojom::DrawQuadPtr& input) {
    return input->needs_blending;
  }

  static const decltype(::viz::mojom::DrawQuad::sqs)& sqs(
      const ::viz::mojom::DrawQuadPtr& input) {
    return input->sqs;
  }

  static const decltype(::viz::mojom::DrawQuad::draw_quad_state)& draw_quad_state(
      const ::viz::mojom::DrawQuadPtr& input) {
    return input->draw_quad_state;
  }

  static bool Read(::viz::mojom::DrawQuad::DataView input, ::viz::mojom::DrawQuadPtr* output);
};


template <>
struct  UnionTraits<::viz::mojom::DrawQuadState::DataView,
                                        ::viz::mojom::DrawQuadStatePtr> {
  static bool IsNull(const ::viz::mojom::DrawQuadStatePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::DrawQuadStatePtr* output) { output->reset(); }

  static ::viz::mojom::DrawQuadState::Tag GetTag(const ::viz::mojom::DrawQuadStatePtr& input) {
    return input->which();
  }

  static const ::viz::mojom::DebugBorderQuadStatePtr& debug_border_quad_state(const ::viz::mojom::DrawQuadStatePtr& input) {
    return input->get_debug_border_quad_state();
  }

  static const ::viz::mojom::CompositorRenderPassQuadStatePtr& render_pass_quad_state(const ::viz::mojom::DrawQuadStatePtr& input) {
    return input->get_render_pass_quad_state();
  }

  static const ::viz::mojom::SolidColorQuadStatePtr& solid_color_quad_state(const ::viz::mojom::DrawQuadStatePtr& input) {
    return input->get_solid_color_quad_state();
  }

  static const ::viz::mojom::StreamVideoQuadStatePtr& stream_video_quad_state(const ::viz::mojom::DrawQuadStatePtr& input) {
    return input->get_stream_video_quad_state();
  }

  static const ::viz::mojom::SurfaceQuadStatePtr& surface_quad_state(const ::viz::mojom::DrawQuadStatePtr& input) {
    return input->get_surface_quad_state();
  }

  static const ::viz::mojom::TextureQuadStatePtr& texture_quad_state(const ::viz::mojom::DrawQuadStatePtr& input) {
    return input->get_texture_quad_state();
  }

  static const ::viz::mojom::TileQuadStatePtr& tile_quad_state(const ::viz::mojom::DrawQuadStatePtr& input) {
    return input->get_tile_quad_state();
  }

  static const ::viz::mojom::YUVVideoQuadStatePtr& yuv_video_quad_state(const ::viz::mojom::DrawQuadStatePtr& input) {
    return input->get_yuv_video_quad_state();
  }

  static const ::viz::mojom::VideoHoleQuadStatePtr& video_hole_quad_state(const ::viz::mojom::DrawQuadStatePtr& input) {
    return input->get_video_hole_quad_state();
  }

  static bool Read(::viz::mojom::DrawQuadState::DataView input, ::viz::mojom::DrawQuadStatePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_QUADS_MOJOM_H_