// services/viz/public/mojom/compositing/compositor_render_pass.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_RENDER_PASS_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_RENDER_PASS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/viz/public/mojom/compositing/compositor_render_pass.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositor_render_pass.mojom-forward.h"
#include "services/viz/public/mojom/compositing/compositor_render_pass_id.mojom.h"
#include "services/viz/public/mojom/compositing/copy_output_request.mojom.h"
#include "services/viz/public/mojom/compositing/filter_operations.mojom.h"
#include "services/viz/public/mojom/compositing/quads.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/rrect_f.mojom.h"
#include "ui/gfx/mojom/transform.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "services/viz/public/cpp/compositing/compositor_render_pass_mojom_traits.h"
#include "services/viz/public/cpp/compositing/quads_mojom_traits.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace viz {
namespace mojom {








class  CompositorRenderPass {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CompositorRenderPass, T>::value>;
  using DataView = CompositorRenderPassDataView;
  using Data_ = internal::CompositorRenderPass_Data;

  template <typename... Args>
  static CompositorRenderPassPtr New(Args&&... args) {
    return CompositorRenderPassPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CompositorRenderPassPtr From(const U& u) {
    return mojo::TypeConverter<CompositorRenderPassPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CompositorRenderPass>::Convert(*this);
  }


  CompositorRenderPass();

  CompositorRenderPass(
      const ::viz::CompositorRenderPassId& id,
      const ::gfx::Rect& output_rect,
      const ::gfx::Rect& damage_rect,
      const ::gfx::Transform& transform_to_root_target,
      const ::cc::FilterOperations& filters,
      const ::cc::FilterOperations& backdrop_filters,
      const base::Optional<::gfx::RRectF>& backdrop_filter_bounds,
      bool has_transparent_background,
      bool cache_render_pass,
      bool has_damage_from_contributing_content,
      bool generate_mipmap,
      std::vector<::std::unique_ptr<::viz::CopyOutputRequest>> copy_requests,
      std::vector<::viz::mojom::DrawQuadPtr> quad_list);

  ~CompositorRenderPass();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CompositorRenderPassPtr>
  CompositorRenderPassPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CompositorRenderPass::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CompositorRenderPass::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CompositorRenderPass::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CompositorRenderPass_UnserializedMessageContext<
            UserType, CompositorRenderPass::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CompositorRenderPass::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CompositorRenderPass::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CompositorRenderPass_UnserializedMessageContext<
            UserType, CompositorRenderPass::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CompositorRenderPass::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::viz::CompositorRenderPassId id;
  
  ::gfx::Rect output_rect;
  
  ::gfx::Rect damage_rect;
  
  ::gfx::Transform transform_to_root_target;
  
  ::cc::FilterOperations filters;
  
  ::cc::FilterOperations backdrop_filters;
  
  base::Optional<::gfx::RRectF> backdrop_filter_bounds;
  
  bool has_transparent_background;
  
  bool cache_render_pass;
  
  bool has_damage_from_contributing_content;
  
  bool generate_mipmap;
  
  std::vector<::std::unique_ptr<::viz::CopyOutputRequest>> copy_requests;
  
  std::vector<::viz::mojom::DrawQuadPtr> quad_list;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CompositorRenderPass);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CompositorRenderPass::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CompositorRenderPass::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CompositorRenderPass::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CompositorRenderPass::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CompositorRenderPassPtr CompositorRenderPass::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(output_rect),
      mojo::Clone(damage_rect),
      mojo::Clone(transform_to_root_target),
      mojo::Clone(filters),
      mojo::Clone(backdrop_filters),
      mojo::Clone(backdrop_filter_bounds),
      mojo::Clone(has_transparent_background),
      mojo::Clone(cache_render_pass),
      mojo::Clone(has_damage_from_contributing_content),
      mojo::Clone(generate_mipmap),
      mojo::Clone(copy_requests),
      mojo::Clone(quad_list)
  );
}

template <typename T, CompositorRenderPass::EnableIfSame<T>*>
bool CompositorRenderPass::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->output_rect, other_struct.output_rect))
    return false;
  if (!mojo::Equals(this->damage_rect, other_struct.damage_rect))
    return false;
  if (!mojo::Equals(this->transform_to_root_target, other_struct.transform_to_root_target))
    return false;
  if (!mojo::Equals(this->filters, other_struct.filters))
    return false;
  if (!mojo::Equals(this->backdrop_filters, other_struct.backdrop_filters))
    return false;
  if (!mojo::Equals(this->backdrop_filter_bounds, other_struct.backdrop_filter_bounds))
    return false;
  if (!mojo::Equals(this->has_transparent_background, other_struct.has_transparent_background))
    return false;
  if (!mojo::Equals(this->cache_render_pass, other_struct.cache_render_pass))
    return false;
  if (!mojo::Equals(this->has_damage_from_contributing_content, other_struct.has_damage_from_contributing_content))
    return false;
  if (!mojo::Equals(this->generate_mipmap, other_struct.generate_mipmap))
    return false;
  if (!mojo::Equals(this->copy_requests, other_struct.copy_requests))
    return false;
  if (!mojo::Equals(this->quad_list, other_struct.quad_list))
    return false;
  return true;
}

template <typename T, CompositorRenderPass::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.id, rhs.id))
    return true;
  if (std::less<>{}(rhs.id, lhs.id))
    return false;
  if (std::less<>{}(lhs.output_rect, rhs.output_rect))
    return true;
  if (std::less<>{}(rhs.output_rect, lhs.output_rect))
    return false;
  if (std::less<>{}(lhs.damage_rect, rhs.damage_rect))
    return true;
  if (std::less<>{}(rhs.damage_rect, lhs.damage_rect))
    return false;
  if (std::less<>{}(lhs.transform_to_root_target, rhs.transform_to_root_target))
    return true;
  if (std::less<>{}(rhs.transform_to_root_target, lhs.transform_to_root_target))
    return false;
  if (std::less<>{}(lhs.filters, rhs.filters))
    return true;
  if (std::less<>{}(rhs.filters, lhs.filters))
    return false;
  if (std::less<>{}(lhs.backdrop_filters, rhs.backdrop_filters))
    return true;
  if (std::less<>{}(rhs.backdrop_filters, lhs.backdrop_filters))
    return false;
  if (std::less<>{}(lhs.backdrop_filter_bounds, rhs.backdrop_filter_bounds))
    return true;
  if (std::less<>{}(rhs.backdrop_filter_bounds, lhs.backdrop_filter_bounds))
    return false;
  if (std::less<>{}(lhs.has_transparent_background, rhs.has_transparent_background))
    return true;
  if (std::less<>{}(rhs.has_transparent_background, lhs.has_transparent_background))
    return false;
  if (std::less<>{}(lhs.cache_render_pass, rhs.cache_render_pass))
    return true;
  if (std::less<>{}(rhs.cache_render_pass, lhs.cache_render_pass))
    return false;
  if (std::less<>{}(lhs.has_damage_from_contributing_content, rhs.has_damage_from_contributing_content))
    return true;
  if (std::less<>{}(rhs.has_damage_from_contributing_content, lhs.has_damage_from_contributing_content))
    return false;
  if (std::less<>{}(lhs.generate_mipmap, rhs.generate_mipmap))
    return true;
  if (std::less<>{}(rhs.generate_mipmap, lhs.generate_mipmap))
    return false;
  if (std::less<>{}(lhs.copy_requests, rhs.copy_requests))
    return true;
  if (std::less<>{}(rhs.copy_requests, lhs.copy_requests))
    return false;
  if (std::less<>{}(lhs.quad_list, rhs.quad_list))
    return true;
  if (std::less<>{}(rhs.quad_list, lhs.quad_list))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace viz

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::CompositorRenderPass::DataView,
                                         ::viz::mojom::CompositorRenderPassPtr> {
  static bool IsNull(const ::viz::mojom::CompositorRenderPassPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::CompositorRenderPassPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::CompositorRenderPass::id)& id(
      const ::viz::mojom::CompositorRenderPassPtr& input) {
    return input->id;
  }

  static const decltype(::viz::mojom::CompositorRenderPass::output_rect)& output_rect(
      const ::viz::mojom::CompositorRenderPassPtr& input) {
    return input->output_rect;
  }

  static const decltype(::viz::mojom::CompositorRenderPass::damage_rect)& damage_rect(
      const ::viz::mojom::CompositorRenderPassPtr& input) {
    return input->damage_rect;
  }

  static const decltype(::viz::mojom::CompositorRenderPass::transform_to_root_target)& transform_to_root_target(
      const ::viz::mojom::CompositorRenderPassPtr& input) {
    return input->transform_to_root_target;
  }

  static const decltype(::viz::mojom::CompositorRenderPass::filters)& filters(
      const ::viz::mojom::CompositorRenderPassPtr& input) {
    return input->filters;
  }

  static const decltype(::viz::mojom::CompositorRenderPass::backdrop_filters)& backdrop_filters(
      const ::viz::mojom::CompositorRenderPassPtr& input) {
    return input->backdrop_filters;
  }

  static const decltype(::viz::mojom::CompositorRenderPass::backdrop_filter_bounds)& backdrop_filter_bounds(
      const ::viz::mojom::CompositorRenderPassPtr& input) {
    return input->backdrop_filter_bounds;
  }

  static decltype(::viz::mojom::CompositorRenderPass::has_transparent_background) has_transparent_background(
      const ::viz::mojom::CompositorRenderPassPtr& input) {
    return input->has_transparent_background;
  }

  static decltype(::viz::mojom::CompositorRenderPass::cache_render_pass) cache_render_pass(
      const ::viz::mojom::CompositorRenderPassPtr& input) {
    return input->cache_render_pass;
  }

  static decltype(::viz::mojom::CompositorRenderPass::has_damage_from_contributing_content) has_damage_from_contributing_content(
      const ::viz::mojom::CompositorRenderPassPtr& input) {
    return input->has_damage_from_contributing_content;
  }

  static decltype(::viz::mojom::CompositorRenderPass::generate_mipmap) generate_mipmap(
      const ::viz::mojom::CompositorRenderPassPtr& input) {
    return input->generate_mipmap;
  }

  static  decltype(::viz::mojom::CompositorRenderPass::copy_requests)& copy_requests(
       ::viz::mojom::CompositorRenderPassPtr& input) {
    return input->copy_requests;
  }

  static const decltype(::viz::mojom::CompositorRenderPass::quad_list)& quad_list(
      const ::viz::mojom::CompositorRenderPassPtr& input) {
    return input->quad_list;
  }

  static bool Read(::viz::mojom::CompositorRenderPass::DataView input, ::viz::mojom::CompositorRenderPassPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_RENDER_PASS_MOJOM_H_