// services/viz/public/mojom/compositing/compositor_render_pass.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/compositor_render_pass.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/public/mojom/compositing/compositor_render_pass.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/compositor_render_pass.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/compositor_render_pass.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_RENDER_PASS_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_RENDER_PASS_MOJOM_JUMBO_H_
#endif
namespace viz {
namespace mojom {
CompositorRenderPass::CompositorRenderPass()
    : id(),
      output_rect(),
      damage_rect(),
      transform_to_root_target(),
      filters(),
      backdrop_filters(),
      backdrop_filter_bounds(),
      has_transparent_background(),
      cache_render_pass(false),
      has_damage_from_contributing_content(false),
      generate_mipmap(false),
      copy_requests(),
      quad_list() {}

CompositorRenderPass::CompositorRenderPass(
    const ::viz::CompositorRenderPassId& id_in,
    const ::gfx::Rect& output_rect_in,
    const ::gfx::Rect& damage_rect_in,
    const ::gfx::Transform& transform_to_root_target_in,
    const ::cc::FilterOperations& filters_in,
    const ::cc::FilterOperations& backdrop_filters_in,
    const base::Optional<::gfx::RRectF>& backdrop_filter_bounds_in,
    bool has_transparent_background_in,
    bool cache_render_pass_in,
    bool has_damage_from_contributing_content_in,
    bool generate_mipmap_in,
    std::vector<::std::unique_ptr<::viz::CopyOutputRequest>> copy_requests_in,
    std::vector<::viz::mojom::DrawQuadPtr> quad_list_in)
    : id(std::move(id_in)),
      output_rect(std::move(output_rect_in)),
      damage_rect(std::move(damage_rect_in)),
      transform_to_root_target(std::move(transform_to_root_target_in)),
      filters(std::move(filters_in)),
      backdrop_filters(std::move(backdrop_filters_in)),
      backdrop_filter_bounds(std::move(backdrop_filter_bounds_in)),
      has_transparent_background(std::move(has_transparent_background_in)),
      cache_render_pass(std::move(cache_render_pass_in)),
      has_damage_from_contributing_content(std::move(has_damage_from_contributing_content_in)),
      generate_mipmap(std::move(generate_mipmap_in)),
      copy_requests(std::move(copy_requests_in)),
      quad_list(std::move(quad_list_in)) {}

CompositorRenderPass::~CompositorRenderPass() = default;

void CompositorRenderPass::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("id", base::trace_event::ValueToString(this->id, "<value of type const ::viz::CompositorRenderPassId&>"));
  value->SetString("output_rect", base::trace_event::ValueToString(this->output_rect, "<value of type const ::gfx::Rect&>"));
  value->SetString("damage_rect", base::trace_event::ValueToString(this->damage_rect, "<value of type const ::gfx::Rect&>"));
  value->SetString("transform_to_root_target", base::trace_event::ValueToString(this->transform_to_root_target, "<value of type const ::gfx::Transform&>"));
  value->SetString("filters", base::trace_event::ValueToString(this->filters, "<value of type const ::cc::FilterOperations&>"));
  value->SetString("backdrop_filters", base::trace_event::ValueToString(this->backdrop_filters, "<value of type const ::cc::FilterOperations&>"));
  value->SetString("backdrop_filter_bounds", base::trace_event::ValueToString(this->backdrop_filter_bounds, "<value of type const base::Optional<::gfx::RRectF>&>"));
  value->SetBoolean("has_transparent_background", this->has_transparent_background);
  value->SetBoolean("cache_render_pass", this->cache_render_pass);
  value->SetBoolean("has_damage_from_contributing_content", this->has_damage_from_contributing_content);
  value->SetBoolean("generate_mipmap", this->generate_mipmap);
  value->BeginArray("copy_requests");
  for (const auto& item0 : this->copy_requests) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type ::std::unique_ptr<::viz::CopyOutputRequest>>"));
  }
  value->EndArray();
  value->BeginArray("quad_list");
  for (const auto& item0 : this->quad_list) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
}

bool CompositorRenderPass::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace viz

namespace mojo {


// static
bool StructTraits<::viz::mojom::CompositorRenderPass::DataView, ::viz::mojom::CompositorRenderPassPtr>::Read(
    ::viz::mojom::CompositorRenderPass::DataView input,
    ::viz::mojom::CompositorRenderPassPtr* output) {
  bool success = true;
  ::viz::mojom::CompositorRenderPassPtr result(::viz::mojom::CompositorRenderPass::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadOutputRect(&result->output_rect))
        success = false;
      if (success && !input.ReadDamageRect(&result->damage_rect))
        success = false;
      if (success && !input.ReadTransformToRootTarget(&result->transform_to_root_target))
        success = false;
      if (success && !input.ReadFilters(&result->filters))
        success = false;
      if (success && !input.ReadBackdropFilters(&result->backdrop_filters))
        success = false;
      if (success && !input.ReadBackdropFilterBounds(&result->backdrop_filter_bounds))
        success = false;
      if (success)
        result->has_transparent_background = input.has_transparent_background();
      if (success)
        result->cache_render_pass = input.cache_render_pass();
      if (success)
        result->has_damage_from_contributing_content = input.has_damage_from_contributing_content();
      if (success)
        result->generate_mipmap = input.generate_mipmap();
      if (success && !input.ReadCopyRequests(&result->copy_requests))
        success = false;
      if (success && !input.ReadQuadList(&result->quad_list))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif