// services/viz/public/mojom/compositing/compositor_frame_sink.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_SINK_MOJOM_BLINK_JUMBO_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_SINK_MOJOM_BLINK_JUMBO_H_
#include "gpu/ipc/common/mailbox_holder_mojom_traits.h"
#include "gpu/ipc/common/mailbox_mojom_traits.h"
#include "gpu/ipc/common/sync_token_mojom_traits.h"
#include "ipc/ipc_message_utils.h"
#include "services/viz/public/cpp/compositing/begin_frame_args_mojom_traits.h"
#include "services/viz/public/cpp/compositing/compositor_frame_metadata_mojom_traits.h"
#include "services/viz/public/cpp/compositing/compositor_frame_mojom_traits.h"
#include "services/viz/public/cpp/compositing/compositor_render_pass_id_mojom_traits.h"
#include "services/viz/public/cpp/compositing/compositor_render_pass_mojom_traits.h"
#include "services/viz/public/cpp/compositing/filter_operation_mojom_traits.h"
#include "services/viz/public/cpp/compositing/filter_operations_mojom_traits.h"
#include "services/viz/public/cpp/compositing/quads_mojom_traits.h"
#include "services/viz/public/cpp/compositing/selection_mojom_traits.h"
#include "services/viz/public/cpp/compositing/shared_quad_state_mojom_traits.h"
#include "services/viz/public/cpp/compositing/transferable_resource_mojom_traits.h"
#include "ui/gfx/mojom/selection_bound_mojom_traits.h"
#include "ui/gfx/mojom/transform_mojom_traits.h"
#include "ui/latency/mojom/latency_info_mojom_traits.h"
#endif
namespace viz {
namespace mojom {
namespace blink {
const char CompositorFrameSink::Name_[] = "viz.mojom.CompositorFrameSink";
bool CompositorFrameSink::SubmitCompositorFrameSync(const ::viz::LocalSurfaceId& local_surface_id, ::viz::CompositorFrame frame, base::Optional<::viz::HitTestRegionList> hit_test_region_list, uint64_t submit_time, WTF::Vector<::viz::ReturnedResource>* out_resources) {
  NOTREACHED();
  return false;
}
class CompositorFrameSink_SubmitCompositorFrameSync_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  CompositorFrameSink_SubmitCompositorFrameSync_HandleSyncResponse(
      bool* result, WTF::Vector<::viz::ReturnedResource>* out_resources)
      : result_(result), out_resources_(out_resources) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  WTF::Vector<::viz::ReturnedResource>* out_resources_;DISALLOW_COPY_AND_ASSIGN(CompositorFrameSink_SubmitCompositorFrameSync_HandleSyncResponse);
};

class CompositorFrameSink_SubmitCompositorFrameSync_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CompositorFrameSink_SubmitCompositorFrameSync_ForwardToCallback(
      CompositorFrameSink::SubmitCompositorFrameSyncCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CompositorFrameSink::SubmitCompositorFrameSyncCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CompositorFrameSink_SubmitCompositorFrameSync_ForwardToCallback);
};

CompositorFrameSinkProxy::CompositorFrameSinkProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CompositorFrameSinkProxy::SetNeedsBeginFrame(
    bool in_needs_begin_frame) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSink::SetNeedsBeginFrame", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("needs_begin_frame", in_needs_begin_frame);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCompositorFrameSink_SetNeedsBeginFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::CompositorFrameSink_SetNeedsBeginFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->needs_begin_frame = in_needs_begin_frame;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SetNeedsBeginFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CompositorFrameSinkProxy::SetWantsAnimateOnlyBeginFrames(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::CompositorFrameSink::SetWantsAnimateOnlyBeginFrames");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCompositorFrameSink_SetWantsAnimateOnlyBeginFrames_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::CompositorFrameSink_SetWantsAnimateOnlyBeginFrames_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SetWantsAnimateOnlyBeginFrames");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CompositorFrameSinkProxy::SubmitCompositorFrame(
    const ::viz::LocalSurfaceId& in_local_surface_id, ::viz::CompositorFrame in_frame, base::Optional<::viz::HitTestRegionList> in_hit_test_region_list, uint64_t in_submit_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSink::SubmitCompositorFrame", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("local_surface_id", base::trace_event::ValueToString(in_local_surface_id, "<value of type const ::viz::LocalSurfaceId&>"));
      raw_value->SetString("frame", base::trace_event::ValueToString(in_frame, "<value of type ::viz::CompositorFrame>"));
      raw_value->SetString("hit_test_region_list", base::trace_event::ValueToString(in_hit_test_region_list, "<value of type base::Optional<::viz::HitTestRegionList>>"));
      raw_value->SetString("submit_time", base::NumberToString(in_submit_time));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCompositorFrameSink_SubmitCompositorFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::CompositorFrameSink_SubmitCompositorFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->local_surface_id)::BaseType::BufferWriter
      local_surface_id_writer;
  mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
      in_local_surface_id, buffer, &local_surface_id_writer, &serialization_context);
  params->local_surface_id.Set(
      local_surface_id_writer.is_null() ? nullptr : local_surface_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->local_surface_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_surface_id in CompositorFrameSink.SubmitCompositorFrame request");
  typename decltype(params->frame)::BaseType::BufferWriter
      frame_writer;
  mojo::internal::Serialize<::viz::mojom::CompositorFrameDataView>(
      in_frame, buffer, &frame_writer, &serialization_context);
  params->frame.Set(
      frame_writer.is_null() ? nullptr : frame_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame in CompositorFrameSink.SubmitCompositorFrame request");
  typename decltype(params->hit_test_region_list)::BaseType::BufferWriter
      hit_test_region_list_writer;
  mojo::internal::Serialize<::viz::mojom::HitTestRegionListDataView>(
      in_hit_test_region_list, buffer, &hit_test_region_list_writer, &serialization_context);
  params->hit_test_region_list.Set(
      hit_test_region_list_writer.is_null() ? nullptr : hit_test_region_list_writer.data());
  params->submit_time = in_submit_time;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SubmitCompositorFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool CompositorFrameSinkProxy::SubmitCompositorFrameSync(
    const ::viz::LocalSurfaceId& param_local_surface_id, ::viz::CompositorFrame param_frame, base::Optional<::viz::HitTestRegionList> param_hit_test_region_list, uint64_t param_submit_time, WTF::Vector<::viz::ReturnedResource>* out_param_resources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "viz::mojom::CompositorFrameSink::SubmitCompositorFrameSync", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("local_surface_id", base::trace_event::ValueToString(param_local_surface_id, "<value of type const ::viz::LocalSurfaceId&>"));
      raw_value->SetString("frame", base::trace_event::ValueToString(param_frame, "<value of type ::viz::CompositorFrame>"));
      raw_value->SetString("hit_test_region_list", base::trace_event::ValueToString(param_hit_test_region_list, "<value of type base::Optional<::viz::HitTestRegionList>>"));
      raw_value->SetString("submit_time", base::NumberToString(param_submit_time));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCompositorFrameSink_SubmitCompositorFrameSync_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::CompositorFrameSink_SubmitCompositorFrameSync_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->local_surface_id)::BaseType::BufferWriter
      local_surface_id_writer;
  mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
      param_local_surface_id, buffer, &local_surface_id_writer, &serialization_context);
  params->local_surface_id.Set(
      local_surface_id_writer.is_null() ? nullptr : local_surface_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->local_surface_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_surface_id in CompositorFrameSink.SubmitCompositorFrameSync request");
  typename decltype(params->frame)::BaseType::BufferWriter
      frame_writer;
  mojo::internal::Serialize<::viz::mojom::CompositorFrameDataView>(
      param_frame, buffer, &frame_writer, &serialization_context);
  params->frame.Set(
      frame_writer.is_null() ? nullptr : frame_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame in CompositorFrameSink.SubmitCompositorFrameSync request");
  typename decltype(params->hit_test_region_list)::BaseType::BufferWriter
      hit_test_region_list_writer;
  mojo::internal::Serialize<::viz::mojom::HitTestRegionListDataView>(
      param_hit_test_region_list, buffer, &hit_test_region_list_writer, &serialization_context);
  params->hit_test_region_list.Set(
      hit_test_region_list_writer.is_null() ? nullptr : hit_test_region_list_writer.data());
  params->submit_time = param_submit_time;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SubmitCompositorFrameSync");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CompositorFrameSink_SubmitCompositorFrameSync_HandleSyncResponse(
          &result, out_param_resources));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "viz::mojom::CompositorFrameSink::SubmitCompositorFrameSync", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_resources) {
        raw_value->BeginArray("resources");
        for (const auto& item0 : (*out_param_resources)) {
          raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::viz::ReturnedResource&>"));
        }
        raw_value->EndArray();
      } else {
        raw_value->SetString("resources", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void CompositorFrameSinkProxy::SubmitCompositorFrameSync(
    const ::viz::LocalSurfaceId& in_local_surface_id, ::viz::CompositorFrame in_frame, base::Optional<::viz::HitTestRegionList> in_hit_test_region_list, uint64_t in_submit_time, SubmitCompositorFrameSyncCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSink::SubmitCompositorFrameSync", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("local_surface_id", base::trace_event::ValueToString(in_local_surface_id, "<value of type const ::viz::LocalSurfaceId&>"));
      raw_value->SetString("frame", base::trace_event::ValueToString(in_frame, "<value of type ::viz::CompositorFrame>"));
      raw_value->SetString("hit_test_region_list", base::trace_event::ValueToString(in_hit_test_region_list, "<value of type base::Optional<::viz::HitTestRegionList>>"));
      raw_value->SetString("submit_time", base::NumberToString(in_submit_time));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCompositorFrameSink_SubmitCompositorFrameSync_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::CompositorFrameSink_SubmitCompositorFrameSync_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->local_surface_id)::BaseType::BufferWriter
      local_surface_id_writer;
  mojo::internal::Serialize<::viz::mojom::LocalSurfaceIdDataView>(
      in_local_surface_id, buffer, &local_surface_id_writer, &serialization_context);
  params->local_surface_id.Set(
      local_surface_id_writer.is_null() ? nullptr : local_surface_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->local_surface_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_surface_id in CompositorFrameSink.SubmitCompositorFrameSync request");
  typename decltype(params->frame)::BaseType::BufferWriter
      frame_writer;
  mojo::internal::Serialize<::viz::mojom::CompositorFrameDataView>(
      in_frame, buffer, &frame_writer, &serialization_context);
  params->frame.Set(
      frame_writer.is_null() ? nullptr : frame_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->frame.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame in CompositorFrameSink.SubmitCompositorFrameSync request");
  typename decltype(params->hit_test_region_list)::BaseType::BufferWriter
      hit_test_region_list_writer;
  mojo::internal::Serialize<::viz::mojom::HitTestRegionListDataView>(
      in_hit_test_region_list, buffer, &hit_test_region_list_writer, &serialization_context);
  params->hit_test_region_list.Set(
      hit_test_region_list_writer.is_null() ? nullptr : hit_test_region_list_writer.data());
  params->submit_time = in_submit_time;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SubmitCompositorFrameSync");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CompositorFrameSink_SubmitCompositorFrameSync_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CompositorFrameSinkProxy::DidNotProduceFrame(
    const ::viz::BeginFrameAck& in_ack) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSink::DidNotProduceFrame", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("ack", base::trace_event::ValueToString(in_ack, "<value of type const ::viz::BeginFrameAck&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCompositorFrameSink_DidNotProduceFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::CompositorFrameSink_DidNotProduceFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->ack)::BaseType::BufferWriter
      ack_writer;
  mojo::internal::Serialize<::viz::mojom::BeginFrameAckDataView>(
      in_ack, buffer, &ack_writer, &serialization_context);
  params->ack.Set(
      ack_writer.is_null() ? nullptr : ack_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ack.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ack in CompositorFrameSink.DidNotProduceFrame request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("DidNotProduceFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CompositorFrameSinkProxy::DidAllocateSharedBitmap(
    ::base::ReadOnlySharedMemoryRegion in_region, const ::gpu::Mailbox& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSink::DidAllocateSharedBitmap", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("region", base::trace_event::ValueToString(in_region, "<value of type ::base::ReadOnlySharedMemoryRegion>"));
      raw_value->SetString("id", base::trace_event::ValueToString(in_id, "<value of type const ::gpu::Mailbox&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCompositorFrameSink_DidAllocateSharedBitmap_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::CompositorFrameSink_DidAllocateSharedBitmap_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->region)::BaseType::BufferWriter
      region_writer;
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_region, buffer, &region_writer, &serialization_context);
  params->region.Set(
      region_writer.is_null() ? nullptr : region_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->region.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null region in CompositorFrameSink.DidAllocateSharedBitmap request");
  typename decltype(params->id)::BaseType::BufferWriter
      id_writer;
  mojo::internal::Serialize<::gpu::mojom::MailboxDataView>(
      in_id, buffer, &id_writer, &serialization_context);
  params->id.Set(
      id_writer.is_null() ? nullptr : id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in CompositorFrameSink.DidAllocateSharedBitmap request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("DidAllocateSharedBitmap");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CompositorFrameSinkProxy::DidDeleteSharedBitmap(
    const ::gpu::Mailbox& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSink::DidDeleteSharedBitmap", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("id", base::trace_event::ValueToString(in_id, "<value of type const ::gpu::Mailbox&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCompositorFrameSink_DidDeleteSharedBitmap_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::CompositorFrameSink_DidDeleteSharedBitmap_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->id)::BaseType::BufferWriter
      id_writer;
  mojo::internal::Serialize<::gpu::mojom::MailboxDataView>(
      in_id, buffer, &id_writer, &serialization_context);
  params->id.Set(
      id_writer.is_null() ? nullptr : id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in CompositorFrameSink.DidDeleteSharedBitmap request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("DidDeleteSharedBitmap");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CompositorFrameSinkProxy::InitializeCompositorFrameSinkType(
    CompositorFrameSinkType in_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSink::InitializeCompositorFrameSinkType", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("type", base::trace_event::ValueToString(in_type));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCompositorFrameSink_InitializeCompositorFrameSinkType_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::CompositorFrameSink_InitializeCompositorFrameSinkType_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::viz::mojom::CompositorFrameSinkType>(
      in_type, &params->type);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("InitializeCompositorFrameSinkType");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder {
 public:
  static CompositorFrameSink::SubmitCompositorFrameSyncCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder> proxy(
        new CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CompositorFrameSink::SubmitCompositorFrameSyncCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const WTF::Vector<::viz::ReturnedResource>& in_resources);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder);
};

bool CompositorFrameSink_SubmitCompositorFrameSync_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "viz::mojom::CompositorFrameSink::SubmitCompositorFrameSyncCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CompositorFrameSink_SubmitCompositorFrameSync_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CompositorFrameSink_SubmitCompositorFrameSync_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  WTF::Vector<::viz::ReturnedResource> p_resources{};
  CompositorFrameSink_SubmitCompositorFrameSync_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResources(&p_resources))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CompositorFrameSink::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_resources));
  return true;
}

void CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder::Run(
    const WTF::Vector<::viz::ReturnedResource>& in_resources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)viz::mojom::CompositorFrameSink::SubmitCompositorFrameSyncCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("resources");
      for (const auto& item0 : in_resources) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::viz::ReturnedResource&>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCompositorFrameSink_SubmitCompositorFrameSync_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::CompositorFrameSink_SubmitCompositorFrameSync_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->resources)::BaseType::BufferWriter
      resources_writer;
  const mojo::internal::ContainerValidateParams resources_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>>(
      in_resources, buffer, &resources_writer, &resources_validate_params,
      &serialization_context);
  params->resources.Set(
      resources_writer.is_null() ? nullptr : resources_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resources.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resources in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)viz::mojom::CompositorFrameSink::SubmitCompositorFrameSyncCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSink::Name_);
  message.set_method_name("SubmitCompositorFrameSync");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool CompositorFrameSink_SubmitCompositorFrameSync_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::CompositorFrameSink_SubmitCompositorFrameSync_ResponseParams_Data* params =
      reinterpret_cast<internal::CompositorFrameSink_SubmitCompositorFrameSync_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  WTF::Vector<::viz::ReturnedResource> p_resources{};
  CompositorFrameSink_SubmitCompositorFrameSync_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResources(&p_resources))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CompositorFrameSink::Name_, 3, true);
    return false;
  }
  *out_resources_ = std::move(p_resources);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

// static
bool CompositorFrameSinkStubDispatch::Accept(
    CompositorFrameSink* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kCompositorFrameSink_SetNeedsBeginFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSink::SetNeedsBeginFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSink::SetNeedsBeginFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_SetNeedsBeginFrame_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_SetNeedsBeginFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_needs_begin_frame{};
      CompositorFrameSink_SetNeedsBeginFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_needs_begin_frame = input_data_view.needs_begin_frame();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNeedsBeginFrame(
std::move(p_needs_begin_frame));
      return true;
    }
    case internal::kCompositorFrameSink_SetWantsAnimateOnlyBeginFrames_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSink::SetWantsAnimateOnlyBeginFrames",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSink::SetWantsAnimateOnlyBeginFrames");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_SetWantsAnimateOnlyBeginFrames_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_SetWantsAnimateOnlyBeginFrames_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CompositorFrameSink_SetWantsAnimateOnlyBeginFrames_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetWantsAnimateOnlyBeginFrames();
      return true;
    }
    case internal::kCompositorFrameSink_SubmitCompositorFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSink::SubmitCompositorFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSink::SubmitCompositorFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_SubmitCompositorFrame_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_SubmitCompositorFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::LocalSurfaceId p_local_surface_id{};
      ::viz::CompositorFrame p_frame{};
      base::Optional<::viz::HitTestRegionList> p_hit_test_region_list{};
      uint64_t p_submit_time{};
      CompositorFrameSink_SubmitCompositorFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadLocalSurfaceId(&p_local_surface_id))
        success = false;
      if (success && !input_data_view.ReadFrame(&p_frame))
        success = false;
      if (success && !input_data_view.ReadHitTestRegionList(&p_hit_test_region_list))
        success = false;
      if (success)
        p_submit_time = input_data_view.submit_time();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubmitCompositorFrame(
std::move(p_local_surface_id), 
std::move(p_frame), 
std::move(p_hit_test_region_list), 
std::move(p_submit_time));
      return true;
    }
    case internal::kCompositorFrameSink_SubmitCompositorFrameSync_Name: {
      break;
    }
    case internal::kCompositorFrameSink_DidNotProduceFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSink::DidNotProduceFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSink::DidNotProduceFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_DidNotProduceFrame_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_DidNotProduceFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::BeginFrameAck p_ack{};
      CompositorFrameSink_DidNotProduceFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadAck(&p_ack))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidNotProduceFrame(
std::move(p_ack));
      return true;
    }
    case internal::kCompositorFrameSink_DidAllocateSharedBitmap_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSink::DidAllocateSharedBitmap",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSink::DidAllocateSharedBitmap");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_DidAllocateSharedBitmap_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_DidAllocateSharedBitmap_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::ReadOnlySharedMemoryRegion p_region{};
      ::gpu::Mailbox p_id{};
      CompositorFrameSink_DidAllocateSharedBitmap_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadRegion(&p_region))
        success = false;
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidAllocateSharedBitmap(
std::move(p_region), 
std::move(p_id));
      return true;
    }
    case internal::kCompositorFrameSink_DidDeleteSharedBitmap_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSink::DidDeleteSharedBitmap",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSink::DidDeleteSharedBitmap");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_DidDeleteSharedBitmap_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_DidDeleteSharedBitmap_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gpu::Mailbox p_id{};
      CompositorFrameSink_DidDeleteSharedBitmap_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidDeleteSharedBitmap(
std::move(p_id));
      return true;
    }
    case internal::kCompositorFrameSink_InitializeCompositorFrameSinkType_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSink::InitializeCompositorFrameSinkType",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSink::InitializeCompositorFrameSinkType");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSink_InitializeCompositorFrameSinkType_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSink_InitializeCompositorFrameSinkType_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CompositorFrameSinkType p_type{};
      CompositorFrameSink_InitializeCompositorFrameSinkType_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitializeCompositorFrameSinkType(
std::move(p_type));
      return true;
    }
  }
  return false;
}

// static
bool CompositorFrameSinkStubDispatch::AcceptWithResponder(
    CompositorFrameSink* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCompositorFrameSink_SetNeedsBeginFrame_Name: {
      break;
    }
    case internal::kCompositorFrameSink_SetWantsAnimateOnlyBeginFrames_Name: {
      break;
    }
    case internal::kCompositorFrameSink_SubmitCompositorFrame_Name: {
      break;
    }
    case internal::kCompositorFrameSink_SubmitCompositorFrameSync_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSink::SubmitCompositorFrameSync",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSink::SubmitCompositorFrameSync");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CompositorFrameSink_SubmitCompositorFrameSync_Params_Data* params =
          reinterpret_cast<
              internal::CompositorFrameSink_SubmitCompositorFrameSync_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::viz::LocalSurfaceId p_local_surface_id{};
      ::viz::CompositorFrame p_frame{};
      base::Optional<::viz::HitTestRegionList> p_hit_test_region_list{};
      uint64_t p_submit_time{};
      CompositorFrameSink_SubmitCompositorFrameSync_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadLocalSurfaceId(&p_local_surface_id))
        success = false;
      if (success && !input_data_view.ReadFrame(&p_frame))
        success = false;
      if (success && !input_data_view.ReadHitTestRegionList(&p_hit_test_region_list))
        success = false;
      if (success)
        p_submit_time = input_data_view.submit_time();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSink::Name_, 3, false);
        return false;
      }
      CompositorFrameSink::SubmitCompositorFrameSyncCallback callback =
          CompositorFrameSink_SubmitCompositorFrameSync_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SubmitCompositorFrameSync(
std::move(p_local_surface_id), 
std::move(p_frame), 
std::move(p_hit_test_region_list), 
std::move(p_submit_time), std::move(callback));
      return true;
    }
    case internal::kCompositorFrameSink_DidNotProduceFrame_Name: {
      break;
    }
    case internal::kCompositorFrameSink_DidAllocateSharedBitmap_Name: {
      break;
    }
    case internal::kCompositorFrameSink_DidDeleteSharedBitmap_Name: {
      break;
    }
    case internal::kCompositorFrameSink_InitializeCompositorFrameSinkType_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCompositorFrameSinkValidationInfo[] = {
    {internal::kCompositorFrameSink_SetNeedsBeginFrame_Name,
     {&internal::CompositorFrameSink_SetNeedsBeginFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCompositorFrameSink_SetWantsAnimateOnlyBeginFrames_Name,
     {&internal::CompositorFrameSink_SetWantsAnimateOnlyBeginFrames_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCompositorFrameSink_SubmitCompositorFrame_Name,
     {&internal::CompositorFrameSink_SubmitCompositorFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCompositorFrameSink_SubmitCompositorFrameSync_Name,
     {&internal::CompositorFrameSink_SubmitCompositorFrameSync_Params_Data::Validate,
      &internal::CompositorFrameSink_SubmitCompositorFrameSync_ResponseParams_Data::Validate}},
    {internal::kCompositorFrameSink_DidNotProduceFrame_Name,
     {&internal::CompositorFrameSink_DidNotProduceFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCompositorFrameSink_DidAllocateSharedBitmap_Name,
     {&internal::CompositorFrameSink_DidAllocateSharedBitmap_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCompositorFrameSink_DidDeleteSharedBitmap_Name,
     {&internal::CompositorFrameSink_DidDeleteSharedBitmap_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCompositorFrameSink_InitializeCompositorFrameSinkType_Name,
     {&internal::CompositorFrameSink_InitializeCompositorFrameSinkType_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CompositorFrameSinkRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::blink::CompositorFrameSink::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCompositorFrameSinkValidationInfo);
}

bool CompositorFrameSinkResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::blink::CompositorFrameSink::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kCompositorFrameSinkValidationInfo);

}
const char CompositorFrameSinkClient::Name_[] = "viz.mojom.CompositorFrameSinkClient";

CompositorFrameSinkClientProxy::CompositorFrameSinkClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CompositorFrameSinkClientProxy::DidReceiveCompositorFrameAck(
    const WTF::Vector<::viz::ReturnedResource>& in_resources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSinkClient::DidReceiveCompositorFrameAck", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("resources");
      for (const auto& item0 : in_resources) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::viz::ReturnedResource&>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCompositorFrameSinkClient_DidReceiveCompositorFrameAck_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->resources)::BaseType::BufferWriter
      resources_writer;
  const mojo::internal::ContainerValidateParams resources_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>>(
      in_resources, buffer, &resources_writer, &resources_validate_params,
      &serialization_context);
  params->resources.Set(
      resources_writer.is_null() ? nullptr : resources_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resources.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resources in CompositorFrameSinkClient.DidReceiveCompositorFrameAck request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSinkClient::Name_);
  message.set_method_name("DidReceiveCompositorFrameAck");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CompositorFrameSinkClientProxy::OnBeginFrame(
    const ::viz::BeginFrameArgs& in_args, const WTF::HashMap<uint32_t, ::viz::FrameTimingDetails>& in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSinkClient::OnBeginFrame", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("args", base::trace_event::ValueToString(in_args, "<value of type const ::viz::BeginFrameArgs&>"));
      raw_value->BeginDictionary("details");
      for (const auto& item0 : in_details) {
        raw_value->SetStringWithCopiedName(base::trace_event::ValueToString(item0.key, "<value of type uint32_t>"), base::trace_event::ValueToString(item0.value, "<value of type const ::viz::FrameTimingDetails&>"));
      }
      raw_value->EndDictionary();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCompositorFrameSinkClient_OnBeginFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::CompositorFrameSinkClient_OnBeginFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->args)::BaseType::BufferWriter
      args_writer;
  mojo::internal::Serialize<::viz::mojom::BeginFrameArgsDataView>(
      in_args, buffer, &args_writer, &serialization_context);
  params->args.Set(
      args_writer.is_null() ? nullptr : args_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->args.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null args in CompositorFrameSinkClient.OnBeginFrame request");
  typename decltype(params->details)::BaseType::BufferWriter
      details_writer;
  const mojo::internal::ContainerValidateParams details_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::MapDataView<uint32_t, ::viz::mojom::FrameTimingDetailsDataView>>(
      in_details, buffer, &details_writer, &details_validate_params,
      &serialization_context);
  params->details.Set(
      details_writer.is_null() ? nullptr : details_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->details.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in CompositorFrameSinkClient.OnBeginFrame request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSinkClient::Name_);
  message.set_method_name("OnBeginFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CompositorFrameSinkClientProxy::OnBeginFramePausedChanged(
    bool in_paused) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSinkClient::OnBeginFramePausedChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("paused", in_paused);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCompositorFrameSinkClient_OnBeginFramePausedChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::CompositorFrameSinkClient_OnBeginFramePausedChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->paused = in_paused;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSinkClient::Name_);
  message.set_method_name("OnBeginFramePausedChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CompositorFrameSinkClientProxy::ReclaimResources(
    const WTF::Vector<::viz::ReturnedResource>& in_resources) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositorFrameSinkClient::ReclaimResources", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("resources");
      for (const auto& item0 : in_resources) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::viz::ReturnedResource&>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCompositorFrameSinkClient_ReclaimResources_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::CompositorFrameSinkClient_ReclaimResources_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->resources)::BaseType::BufferWriter
      resources_writer;
  const mojo::internal::ContainerValidateParams resources_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::ReturnedResourceDataView>>(
      in_resources, buffer, &resources_writer, &resources_validate_params,
      &serialization_context);
  params->resources.Set(
      resources_writer.is_null() ? nullptr : resources_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resources.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resources in CompositorFrameSinkClient.ReclaimResources request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositorFrameSinkClient::Name_);
  message.set_method_name("ReclaimResources");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool CompositorFrameSinkClientStubDispatch::Accept(
    CompositorFrameSinkClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kCompositorFrameSinkClient_DidReceiveCompositorFrameAck_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSinkClient::DidReceiveCompositorFrameAck",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSinkClient::DidReceiveCompositorFrameAck");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::viz::ReturnedResource> p_resources{};
      CompositorFrameSinkClient_DidReceiveCompositorFrameAck_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadResources(&p_resources))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSinkClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidReceiveCompositorFrameAck(
std::move(p_resources));
      return true;
    }
    case internal::kCompositorFrameSinkClient_OnBeginFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSinkClient::OnBeginFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSinkClient::OnBeginFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSinkClient_OnBeginFrame_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSinkClient_OnBeginFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::viz::BeginFrameArgs p_args{};
      WTF::HashMap<uint32_t, ::viz::FrameTimingDetails> p_details{};
      CompositorFrameSinkClient_OnBeginFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadArgs(&p_args))
        success = false;
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSinkClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBeginFrame(
std::move(p_args), 
std::move(p_details));
      return true;
    }
    case internal::kCompositorFrameSinkClient_OnBeginFramePausedChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSinkClient::OnBeginFramePausedChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSinkClient::OnBeginFramePausedChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSinkClient_OnBeginFramePausedChanged_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSinkClient_OnBeginFramePausedChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_paused{};
      CompositorFrameSinkClient_OnBeginFramePausedChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_paused = input_data_view.paused();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSinkClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBeginFramePausedChanged(
std::move(p_paused));
      return true;
    }
    case internal::kCompositorFrameSinkClient_ReclaimResources_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositorFrameSinkClient::ReclaimResources",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositorFrameSinkClient::ReclaimResources");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositorFrameSinkClient_ReclaimResources_Params_Data* params =
          reinterpret_cast<internal::CompositorFrameSinkClient_ReclaimResources_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      WTF::Vector<::viz::ReturnedResource> p_resources{};
      CompositorFrameSinkClient_ReclaimResources_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadResources(&p_resources))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositorFrameSinkClient::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReclaimResources(
std::move(p_resources));
      return true;
    }
  }
  return false;
}

// static
bool CompositorFrameSinkClientStubDispatch::AcceptWithResponder(
    CompositorFrameSinkClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCompositorFrameSinkClient_DidReceiveCompositorFrameAck_Name: {
      break;
    }
    case internal::kCompositorFrameSinkClient_OnBeginFrame_Name: {
      break;
    }
    case internal::kCompositorFrameSinkClient_OnBeginFramePausedChanged_Name: {
      break;
    }
    case internal::kCompositorFrameSinkClient_ReclaimResources_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCompositorFrameSinkClientValidationInfo[] = {
    {internal::kCompositorFrameSinkClient_DidReceiveCompositorFrameAck_Name,
     {&internal::CompositorFrameSinkClient_DidReceiveCompositorFrameAck_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCompositorFrameSinkClient_OnBeginFrame_Name,
     {&internal::CompositorFrameSinkClient_OnBeginFrame_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCompositorFrameSinkClient_OnBeginFramePausedChanged_Name,
     {&internal::CompositorFrameSinkClient_OnBeginFramePausedChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCompositorFrameSinkClient_ReclaimResources_Name,
     {&internal::CompositorFrameSinkClient_ReclaimResources_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CompositorFrameSinkClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::blink::CompositorFrameSinkClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCompositorFrameSinkClientValidationInfo);
}

}  // namespace blink
}  // namespace mojom
}  // namespace viz

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif