// services/viz/public/mojom/compositing/compositor_frame_metadata.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_METADATA_MOJOM_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_METADATA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom.h"
#include "services/viz/public/mojom/compositing/delegated_ink_metadata.mojom.h"
#include "services/viz/public/mojom/compositing/frame_deadline.mojom.h"
#include "services/viz/public/mojom/compositing/selection.mojom-forward.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom.h"
#include "services/viz/public/mojom/compositing/surface_range.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-forward.h"
#include "ui/gfx/mojom/overlay_transform.mojom.h"
#include "ui/latency/mojom/latency_info.mojom.h"
#include <string>
#include <vector>




#include "services/viz/public/cpp/compositing/compositor_frame_metadata_mojom_traits.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace viz {
namespace mojom {








class  CompositorFrameMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CompositorFrameMetadata, T>::value>;
  using DataView = CompositorFrameMetadataDataView;
  using Data_ = internal::CompositorFrameMetadata_Data;

  template <typename... Args>
  static CompositorFrameMetadataPtr New(Args&&... args) {
    return CompositorFrameMetadataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CompositorFrameMetadataPtr From(const U& u) {
    return mojo::TypeConverter<CompositorFrameMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CompositorFrameMetadata>::Convert(*this);
  }


  CompositorFrameMetadata();

  CompositorFrameMetadata(
      float device_scale_factor,
      const ::gfx::Vector2dF& root_scroll_offset,
      float page_scale_factor,
      const ::gfx::SizeF& scrollable_viewport_size,
      ::gfx::mojom::ContentColorUsage content_color_usage,
      bool may_contain_video,
      bool is_resourceless_software_draw_with_scroll_or_animation,
      uint32_t root_background_color,
      std::vector<::ui::LatencyInfo> latency_info,
      std::vector<::viz::SurfaceRange> referenced_surfaces,
      const ::viz::FrameDeadline& deadline,
      std::vector<::viz::SurfaceId> activation_dependencies,
      const ::viz::BeginFrameAck& begin_frame_ack,
      uint32_t frame_token,
      bool send_frame_token_to_embedder,
      bool top_controls_visible_height_set,
      float top_controls_visible_height,
      float min_page_scale_factor,
      base::Optional<::base::TimeDelta> preferred_frame_interval,
      ::gfx::OverlayTransform display_transform_hint,
      ::std::unique_ptr<::viz::DelegatedInkMetadata> delegated_ink_metadata);

  ~CompositorFrameMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CompositorFrameMetadataPtr>
  CompositorFrameMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CompositorFrameMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CompositorFrameMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CompositorFrameMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CompositorFrameMetadata_UnserializedMessageContext<
            UserType, CompositorFrameMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CompositorFrameMetadata::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CompositorFrameMetadata::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CompositorFrameMetadata_UnserializedMessageContext<
            UserType, CompositorFrameMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CompositorFrameMetadata::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  float device_scale_factor;
  
  ::gfx::Vector2dF root_scroll_offset;
  
  float page_scale_factor;
  
  ::gfx::SizeF scrollable_viewport_size;
  
  ::gfx::mojom::ContentColorUsage content_color_usage;
  
  bool may_contain_video;
  
  bool is_resourceless_software_draw_with_scroll_or_animation;
  
  uint32_t root_background_color;
  
  std::vector<::ui::LatencyInfo> latency_info;
  
  std::vector<::viz::SurfaceRange> referenced_surfaces;
  
  ::viz::FrameDeadline deadline;
  
  std::vector<::viz::SurfaceId> activation_dependencies;
  
  ::viz::BeginFrameAck begin_frame_ack;
  
  uint32_t frame_token;
  
  bool send_frame_token_to_embedder;
  
  bool top_controls_visible_height_set;
  
  float top_controls_visible_height;
  
  float min_page_scale_factor;
  
  base::Optional<::base::TimeDelta> preferred_frame_interval;
  
  ::gfx::OverlayTransform display_transform_hint;
  
  ::std::unique_ptr<::viz::DelegatedInkMetadata> delegated_ink_metadata;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CompositorFrameMetadata);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CompositorFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CompositorFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CompositorFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CompositorFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CompositorFrameMetadataPtr CompositorFrameMetadata::Clone() const {
  return New(
      mojo::Clone(device_scale_factor),
      mojo::Clone(root_scroll_offset),
      mojo::Clone(page_scale_factor),
      mojo::Clone(scrollable_viewport_size),
      mojo::Clone(content_color_usage),
      mojo::Clone(may_contain_video),
      mojo::Clone(is_resourceless_software_draw_with_scroll_or_animation),
      mojo::Clone(root_background_color),
      mojo::Clone(latency_info),
      mojo::Clone(referenced_surfaces),
      mojo::Clone(deadline),
      mojo::Clone(activation_dependencies),
      mojo::Clone(begin_frame_ack),
      mojo::Clone(frame_token),
      mojo::Clone(send_frame_token_to_embedder),
      mojo::Clone(top_controls_visible_height_set),
      mojo::Clone(top_controls_visible_height),
      mojo::Clone(min_page_scale_factor),
      mojo::Clone(preferred_frame_interval),
      mojo::Clone(display_transform_hint),
      mojo::Clone(delegated_ink_metadata)
  );
}

template <typename T, CompositorFrameMetadata::EnableIfSame<T>*>
bool CompositorFrameMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->device_scale_factor, other_struct.device_scale_factor))
    return false;
  if (!mojo::Equals(this->root_scroll_offset, other_struct.root_scroll_offset))
    return false;
  if (!mojo::Equals(this->page_scale_factor, other_struct.page_scale_factor))
    return false;
  if (!mojo::Equals(this->scrollable_viewport_size, other_struct.scrollable_viewport_size))
    return false;
  if (!mojo::Equals(this->content_color_usage, other_struct.content_color_usage))
    return false;
  if (!mojo::Equals(this->may_contain_video, other_struct.may_contain_video))
    return false;
  if (!mojo::Equals(this->is_resourceless_software_draw_with_scroll_or_animation, other_struct.is_resourceless_software_draw_with_scroll_or_animation))
    return false;
  if (!mojo::Equals(this->root_background_color, other_struct.root_background_color))
    return false;
  if (!mojo::Equals(this->latency_info, other_struct.latency_info))
    return false;
  if (!mojo::Equals(this->referenced_surfaces, other_struct.referenced_surfaces))
    return false;
  if (!mojo::Equals(this->deadline, other_struct.deadline))
    return false;
  if (!mojo::Equals(this->activation_dependencies, other_struct.activation_dependencies))
    return false;
  if (!mojo::Equals(this->begin_frame_ack, other_struct.begin_frame_ack))
    return false;
  if (!mojo::Equals(this->frame_token, other_struct.frame_token))
    return false;
  if (!mojo::Equals(this->send_frame_token_to_embedder, other_struct.send_frame_token_to_embedder))
    return false;
  if (!mojo::Equals(this->top_controls_visible_height_set, other_struct.top_controls_visible_height_set))
    return false;
  if (!mojo::Equals(this->top_controls_visible_height, other_struct.top_controls_visible_height))
    return false;
  if (!mojo::Equals(this->min_page_scale_factor, other_struct.min_page_scale_factor))
    return false;
  if (!mojo::Equals(this->preferred_frame_interval, other_struct.preferred_frame_interval))
    return false;
  if (!mojo::Equals(this->display_transform_hint, other_struct.display_transform_hint))
    return false;
  if (!mojo::Equals(this->delegated_ink_metadata, other_struct.delegated_ink_metadata))
    return false;
  return true;
}

template <typename T, CompositorFrameMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.device_scale_factor, rhs.device_scale_factor))
    return true;
  if (std::less<>{}(rhs.device_scale_factor, lhs.device_scale_factor))
    return false;
  if (std::less<>{}(lhs.root_scroll_offset, rhs.root_scroll_offset))
    return true;
  if (std::less<>{}(rhs.root_scroll_offset, lhs.root_scroll_offset))
    return false;
  if (std::less<>{}(lhs.page_scale_factor, rhs.page_scale_factor))
    return true;
  if (std::less<>{}(rhs.page_scale_factor, lhs.page_scale_factor))
    return false;
  if (std::less<>{}(lhs.scrollable_viewport_size, rhs.scrollable_viewport_size))
    return true;
  if (std::less<>{}(rhs.scrollable_viewport_size, lhs.scrollable_viewport_size))
    return false;
  if (std::less<>{}(lhs.content_color_usage, rhs.content_color_usage))
    return true;
  if (std::less<>{}(rhs.content_color_usage, lhs.content_color_usage))
    return false;
  if (std::less<>{}(lhs.may_contain_video, rhs.may_contain_video))
    return true;
  if (std::less<>{}(rhs.may_contain_video, lhs.may_contain_video))
    return false;
  if (std::less<>{}(lhs.is_resourceless_software_draw_with_scroll_or_animation, rhs.is_resourceless_software_draw_with_scroll_or_animation))
    return true;
  if (std::less<>{}(rhs.is_resourceless_software_draw_with_scroll_or_animation, lhs.is_resourceless_software_draw_with_scroll_or_animation))
    return false;
  if (std::less<>{}(lhs.root_background_color, rhs.root_background_color))
    return true;
  if (std::less<>{}(rhs.root_background_color, lhs.root_background_color))
    return false;
  if (std::less<>{}(lhs.latency_info, rhs.latency_info))
    return true;
  if (std::less<>{}(rhs.latency_info, lhs.latency_info))
    return false;
  if (std::less<>{}(lhs.referenced_surfaces, rhs.referenced_surfaces))
    return true;
  if (std::less<>{}(rhs.referenced_surfaces, lhs.referenced_surfaces))
    return false;
  if (std::less<>{}(lhs.deadline, rhs.deadline))
    return true;
  if (std::less<>{}(rhs.deadline, lhs.deadline))
    return false;
  if (std::less<>{}(lhs.activation_dependencies, rhs.activation_dependencies))
    return true;
  if (std::less<>{}(rhs.activation_dependencies, lhs.activation_dependencies))
    return false;
  if (std::less<>{}(lhs.begin_frame_ack, rhs.begin_frame_ack))
    return true;
  if (std::less<>{}(rhs.begin_frame_ack, lhs.begin_frame_ack))
    return false;
  if (std::less<>{}(lhs.frame_token, rhs.frame_token))
    return true;
  if (std::less<>{}(rhs.frame_token, lhs.frame_token))
    return false;
  if (std::less<>{}(lhs.send_frame_token_to_embedder, rhs.send_frame_token_to_embedder))
    return true;
  if (std::less<>{}(rhs.send_frame_token_to_embedder, lhs.send_frame_token_to_embedder))
    return false;
  if (std::less<>{}(lhs.top_controls_visible_height_set, rhs.top_controls_visible_height_set))
    return true;
  if (std::less<>{}(rhs.top_controls_visible_height_set, lhs.top_controls_visible_height_set))
    return false;
  if (std::less<>{}(lhs.top_controls_visible_height, rhs.top_controls_visible_height))
    return true;
  if (std::less<>{}(rhs.top_controls_visible_height, lhs.top_controls_visible_height))
    return false;
  if (std::less<>{}(lhs.min_page_scale_factor, rhs.min_page_scale_factor))
    return true;
  if (std::less<>{}(rhs.min_page_scale_factor, lhs.min_page_scale_factor))
    return false;
  if (std::less<>{}(lhs.preferred_frame_interval, rhs.preferred_frame_interval))
    return true;
  if (std::less<>{}(rhs.preferred_frame_interval, lhs.preferred_frame_interval))
    return false;
  if (std::less<>{}(lhs.display_transform_hint, rhs.display_transform_hint))
    return true;
  if (std::less<>{}(rhs.display_transform_hint, lhs.display_transform_hint))
    return false;
  if (std::less<>{}(lhs.delegated_ink_metadata, rhs.delegated_ink_metadata))
    return true;
  if (std::less<>{}(rhs.delegated_ink_metadata, lhs.delegated_ink_metadata))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace viz

namespace mojo {


template <>
struct  StructTraits<::viz::mojom::CompositorFrameMetadata::DataView,
                                         ::viz::mojom::CompositorFrameMetadataPtr> {
  static bool IsNull(const ::viz::mojom::CompositorFrameMetadataPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::CompositorFrameMetadataPtr* output) { output->reset(); }

  static decltype(::viz::mojom::CompositorFrameMetadata::device_scale_factor) device_scale_factor(
      const ::viz::mojom::CompositorFrameMetadataPtr& input) {
    return input->device_scale_factor;
  }

  static const decltype(::viz::mojom::CompositorFrameMetadata::root_scroll_offset)& root_scroll_offset(
      const ::viz::mojom::CompositorFrameMetadataPtr& input) {
    return input->root_scroll_offset;
  }

  static decltype(::viz::mojom::CompositorFrameMetadata::page_scale_factor) page_scale_factor(
      const ::viz::mojom::CompositorFrameMetadataPtr& input) {
    return input->page_scale_factor;
  }

  static const decltype(::viz::mojom::CompositorFrameMetadata::scrollable_viewport_size)& scrollable_viewport_size(
      const ::viz::mojom::CompositorFrameMetadataPtr& input) {
    return input->scrollable_viewport_size;
  }

  static decltype(::viz::mojom::CompositorFrameMetadata::content_color_usage) content_color_usage(
      const ::viz::mojom::CompositorFrameMetadataPtr& input) {
    return input->content_color_usage;
  }

  static decltype(::viz::mojom::CompositorFrameMetadata::may_contain_video) may_contain_video(
      const ::viz::mojom::CompositorFrameMetadataPtr& input) {
    return input->may_contain_video;
  }

  static decltype(::viz::mojom::CompositorFrameMetadata::is_resourceless_software_draw_with_scroll_or_animation) is_resourceless_software_draw_with_scroll_or_animation(
      const ::viz::mojom::CompositorFrameMetadataPtr& input) {
    return input->is_resourceless_software_draw_with_scroll_or_animation;
  }

  static decltype(::viz::mojom::CompositorFrameMetadata::root_background_color) root_background_color(
      const ::viz::mojom::CompositorFrameMetadataPtr& input) {
    return input->root_background_color;
  }

  static const decltype(::viz::mojom::CompositorFrameMetadata::latency_info)& latency_info(
      const ::viz::mojom::CompositorFrameMetadataPtr& input) {
    return input->latency_info;
  }

  static const decltype(::viz::mojom::CompositorFrameMetadata::referenced_surfaces)& referenced_surfaces(
      const ::viz::mojom::CompositorFrameMetadataPtr& input) {
    return input->referenced_surfaces;
  }

  static const decltype(::viz::mojom::CompositorFrameMetadata::deadline)& deadline(
      const ::viz::mojom::CompositorFrameMetadataPtr& input) {
    return input->deadline;
  }

  static const decltype(::viz::mojom::CompositorFrameMetadata::activation_dependencies)& activation_dependencies(
      const ::viz::mojom::CompositorFrameMetadataPtr& input) {
    return input->activation_dependencies;
  }

  static const decltype(::viz::mojom::CompositorFrameMetadata::begin_frame_ack)& begin_frame_ack(
      const ::viz::mojom::CompositorFrameMetadataPtr& input) {
    return input->begin_frame_ack;
  }

  static decltype(::viz::mojom::CompositorFrameMetadata::frame_token) frame_token(
      const ::viz::mojom::CompositorFrameMetadataPtr& input) {
    return input->frame_token;
  }

  static decltype(::viz::mojom::CompositorFrameMetadata::send_frame_token_to_embedder) send_frame_token_to_embedder(
      const ::viz::mojom::CompositorFrameMetadataPtr& input) {
    return input->send_frame_token_to_embedder;
  }

  static decltype(::viz::mojom::CompositorFrameMetadata::top_controls_visible_height_set) top_controls_visible_height_set(
      const ::viz::mojom::CompositorFrameMetadataPtr& input) {
    return input->top_controls_visible_height_set;
  }

  static decltype(::viz::mojom::CompositorFrameMetadata::top_controls_visible_height) top_controls_visible_height(
      const ::viz::mojom::CompositorFrameMetadataPtr& input) {
    return input->top_controls_visible_height;
  }

  static decltype(::viz::mojom::CompositorFrameMetadata::min_page_scale_factor) min_page_scale_factor(
      const ::viz::mojom::CompositorFrameMetadataPtr& input) {
    return input->min_page_scale_factor;
  }

  static const decltype(::viz::mojom::CompositorFrameMetadata::preferred_frame_interval)& preferred_frame_interval(
      const ::viz::mojom::CompositorFrameMetadataPtr& input) {
    return input->preferred_frame_interval;
  }

  static decltype(::viz::mojom::CompositorFrameMetadata::display_transform_hint) display_transform_hint(
      const ::viz::mojom::CompositorFrameMetadataPtr& input) {
    return input->display_transform_hint;
  }

  static const decltype(::viz::mojom::CompositorFrameMetadata::delegated_ink_metadata)& delegated_ink_metadata(
      const ::viz::mojom::CompositorFrameMetadataPtr& input) {
    return input->delegated_ink_metadata;
  }

  static bool Read(::viz::mojom::CompositorFrameMetadata::DataView input, ::viz::mojom::CompositorFrameMetadataPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_METADATA_MOJOM_H_