// services/viz/public/mojom/compositing/bitmap_in_shared_memory.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BITMAP_IN_SHARED_MEMORY_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BITMAP_IN_SHARED_MEMORY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/viz/public/mojom/compositing/bitmap_in_shared_memory.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "skia/public/mojom/image_info.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace viz {
namespace mojom {
class BitmapInSharedMemoryDataView;



}  // namespace mojom
}  // namespace viz

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::BitmapInSharedMemoryDataView> {
  using Data = ::viz::mojom::internal::BitmapInSharedMemory_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz {
namespace mojom {


class BitmapInSharedMemoryDataView {
 public:
  BitmapInSharedMemoryDataView() {}

  BitmapInSharedMemoryDataView(
      internal::BitmapInSharedMemory_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetImageInfoDataView(
      ::skia::mojom::ImageInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadImageInfo(UserType* output) {
    
    auto* pointer = data_->image_info.Get();
    return mojo::internal::Deserialize<::skia::mojom::ImageInfoDataView>(
        pointer, output, context_);
  }
  uint64_t row_bytes() const {
    return data_->row_bytes;
  }
  inline void GetPixelsDataView(
      ::mojo_base::mojom::WritableSharedMemoryRegionDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPixels(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::WritableSharedMemoryRegionDataView, UserType>(),
    "Attempting to read the optional `pixels` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPixels` instead "
    "of `ReadPixels if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->pixels.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::WritableSharedMemoryRegionDataView>(
        pointer, output, context_);
  }
 private:
  internal::BitmapInSharedMemory_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace viz

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::BitmapInSharedMemoryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::BitmapInSharedMemoryDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::viz::mojom::internal::BitmapInSharedMemory_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::image_info(input)) in_image_info = Traits::image_info(input);
    typename decltype((*output)->image_info)::BaseType::BufferWriter
        image_info_writer;
    mojo::internal::Serialize<::skia::mojom::ImageInfoDataView>(
        in_image_info, buffer, &image_info_writer, context);
    (*output)->image_info.Set(
        image_info_writer.is_null() ? nullptr : image_info_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->image_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null image_info in BitmapInSharedMemory struct");
    (*output)->row_bytes = Traits::row_bytes(input);
    decltype(Traits::pixels(input)) in_pixels = Traits::pixels(input);
    typename decltype((*output)->pixels)::BaseType::BufferWriter
        pixels_writer;
    mojo::internal::Serialize<::mojo_base::mojom::WritableSharedMemoryRegionDataView>(
        in_pixels, buffer, &pixels_writer, context);
    (*output)->pixels.Set(
        pixels_writer.is_null() ? nullptr : pixels_writer.data());
  }

  static bool Deserialize(::viz::mojom::internal::BitmapInSharedMemory_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::BitmapInSharedMemoryDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz {
namespace mojom {

inline void BitmapInSharedMemoryDataView::GetImageInfoDataView(
    ::skia::mojom::ImageInfoDataView* output) {
  auto pointer = data_->image_info.Get();
  *output = ::skia::mojom::ImageInfoDataView(pointer, context_);
}
inline void BitmapInSharedMemoryDataView::GetPixelsDataView(
    ::mojo_base::mojom::WritableSharedMemoryRegionDataView* output) {
  auto pointer = data_->pixels.Get();
  *output = ::mojo_base::mojom::WritableSharedMemoryRegionDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace viz

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BITMAP_IN_SHARED_MEMORY_MOJOM_SHARED_H_