// services/viz/privileged/mojom/compositing/display_private.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_DISPLAY_PRIVATE_MOJOM_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_DISPLAY_PRIVATE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/viz/privileged/mojom/compositing/display_private.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/display_private.mojom-forward.h"
#include "gpu/ipc/common/context_result.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "ui/gfx/mojom/ca_layer_params.mojom.h"
#include "ui/gfx/mojom/display_color_spaces.mojom.h"
#include "ui/gfx/mojom/overlay_transform.mojom-forward.h"
#include "ui/gfx/mojom/transform.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/latency/mojom/latency_info.mojom.h"
#include "services/viz/privileged/mojom/compositing/layered_window_updater.mojom.h"
#include "services/viz/privileged/mojom/compositing/vsync_parameter_observer.mojom.h"
#include "services/viz/public/mojom/compositing/delegated_ink_point.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace viz {
namespace mojom {

class DisplayPrivateProxy;

template <typename ImplRefTraits>
class DisplayPrivateStub;

class DisplayPrivateRequestValidator;


class  DisplayPrivate
    : public DisplayPrivateInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = DisplayPrivateInterfaceBase;
  using Proxy_ = DisplayPrivateProxy;

  template <typename ImplRefTraits>
  using Stub_ = DisplayPrivateStub<ImplRefTraits>;

  using RequestValidator_ = DisplayPrivateRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetDisplayVisibleMinVersion = 0,
    kResizeMinVersion = 0,
    kSetDisplayColorMatrixMinVersion = 0,
    kSetDisplayColorSpacesMinVersion = 0,
    kSetOutputIsSecureMinVersion = 0,
    kSetDisplayVSyncParametersMinVersion = 0,
    kForceImmediateDrawAndSwapIfPossibleMinVersion = 0,
    kAddVSyncParameterObserverMinVersion = 0,
    kSetDelegatedInkPointRendererMinVersion = 0,
  };
  virtual ~DisplayPrivate() {}

  
  virtual void SetDisplayVisible(bool visible) = 0;

  
  virtual void Resize(const ::gfx::Size& size) = 0;

  
  virtual void SetDisplayColorMatrix(const ::gfx::Transform& color_matrix) = 0;

  
  virtual void SetDisplayColorSpaces(const ::gfx::DisplayColorSpaces& display_color_spaces) = 0;

  
  virtual void SetOutputIsSecure(bool secure) = 0;

  
  virtual void SetDisplayVSyncParameters(::base::TimeTicks timebase, ::base::TimeDelta interval) = 0;

  
  virtual void ForceImmediateDrawAndSwapIfPossible() = 0;

  
  virtual void AddVSyncParameterObserver(::mojo::PendingRemote<::viz::mojom::VSyncParameterObserver> observer) = 0;

  
  virtual void SetDelegatedInkPointRenderer(::mojo::PendingReceiver<::viz::mojom::DelegatedInkPointRenderer> receiver) = 0;
};

class DisplayClientProxy;

template <typename ImplRefTraits>
class DisplayClientStub;

class DisplayClientRequestValidator;


class  DisplayClient
    : public DisplayClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = DisplayClientInterfaceBase;
  using Proxy_ = DisplayClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = DisplayClientStub<ImplRefTraits>;

  using RequestValidator_ = DisplayClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDidCompleteSwapWithNewSizeMinVersion = 0,
  };
  virtual ~DisplayClient() {}

  
  virtual void DidCompleteSwapWithNewSize(const ::gfx::Size& size) = 0;
};



class  DisplayPrivateProxy
    : public DisplayPrivate {
 public:
  using InterfaceType = DisplayPrivate;

  explicit DisplayPrivateProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetDisplayVisible(bool visible) final;
  
  void Resize(const ::gfx::Size& size) final;
  
  void SetDisplayColorMatrix(const ::gfx::Transform& color_matrix) final;
  
  void SetDisplayColorSpaces(const ::gfx::DisplayColorSpaces& display_color_spaces) final;
  
  void SetOutputIsSecure(bool secure) final;
  
  void SetDisplayVSyncParameters(::base::TimeTicks timebase, ::base::TimeDelta interval) final;
  
  void ForceImmediateDrawAndSwapIfPossible() final;
  
  void AddVSyncParameterObserver(::mojo::PendingRemote<::viz::mojom::VSyncParameterObserver> observer) final;
  
  void SetDelegatedInkPointRenderer(::mojo::PendingReceiver<::viz::mojom::DelegatedInkPointRenderer> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  DisplayClientProxy
    : public DisplayClient {
 public:
  using InterfaceType = DisplayClient;

  explicit DisplayClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DidCompleteSwapWithNewSize(const ::gfx::Size& size) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DisplayPrivateStubDispatch {
 public:
  static bool Accept(DisplayPrivate* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DisplayPrivate* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DisplayPrivate>>
class DisplayPrivateStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DisplayPrivateStub() {}
  ~DisplayPrivateStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DisplayPrivateStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DisplayPrivateStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DisplayClientStubDispatch {
 public:
  static bool Accept(DisplayClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DisplayClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DisplayClient>>
class DisplayClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DisplayClientStub() {}
  ~DisplayClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DisplayClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DisplayClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DisplayPrivateRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DisplayClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace viz

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_DISPLAY_PRIVATE_MOJOM_H_