// services/video_capture/public/mojom/video_source.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_MOJOM_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/video_capture/public/mojom/video_source.mojom-shared.h"
#include "services/video_capture/public/mojom/video_source.mojom-forward.h"
#include "media/capture/mojom/image_capture.mojom.h"
#include "media/capture/mojom/video_capture_types.mojom.h"
#include "services/video_capture/public/mojom/video_frame_handler.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace video_capture {
namespace mojom {

class PushVideoStreamSubscriptionProxy;

template <typename ImplRefTraits>
class PushVideoStreamSubscriptionStub;

class PushVideoStreamSubscriptionRequestValidator;
class PushVideoStreamSubscriptionResponseValidator;


class  PushVideoStreamSubscription
    : public PushVideoStreamSubscriptionInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = PushVideoStreamSubscriptionInterfaceBase;
  using Proxy_ = PushVideoStreamSubscriptionProxy;

  template <typename ImplRefTraits>
  using Stub_ = PushVideoStreamSubscriptionStub<ImplRefTraits>;

  using RequestValidator_ = PushVideoStreamSubscriptionRequestValidator;
  using ResponseValidator_ = PushVideoStreamSubscriptionResponseValidator;
  enum MethodMinVersions : uint32_t {
    kActivateMinVersion = 0,
    kSuspendMinVersion = 0,
    kResumeMinVersion = 0,
    kGetPhotoStateMinVersion = 0,
    kSetPhotoOptionsMinVersion = 0,
    kTakePhotoMinVersion = 0,
    kCloseMinVersion = 0,
  };
  virtual ~PushVideoStreamSubscription() {}

  
  virtual void Activate() = 0;


  using SuspendCallback = base::OnceCallback<void()>;
  
  virtual void Suspend(SuspendCallback callback) = 0;

  
  virtual void Resume() = 0;


  using GetPhotoStateCallback = base::OnceCallback<void(::media::mojom::PhotoStatePtr)>;
  
  virtual void GetPhotoState(GetPhotoStateCallback callback) = 0;


  using SetPhotoOptionsCallback = base::OnceCallback<void(bool)>;
  
  virtual void SetPhotoOptions(::media::mojom::PhotoSettingsPtr settings, SetPhotoOptionsCallback callback) = 0;


  using TakePhotoCallback = base::OnceCallback<void(::media::mojom::BlobPtr)>;
  
  virtual void TakePhoto(TakePhotoCallback callback) = 0;


  using CloseCallback = base::OnceCallback<void()>;
  
  virtual void Close(CloseCallback callback) = 0;
};

class VideoSourceProxy;

template <typename ImplRefTraits>
class VideoSourceStub;

class VideoSourceRequestValidator;
class VideoSourceResponseValidator;


class  VideoSource
    : public VideoSourceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = VideoSourceInterfaceBase;
  using Proxy_ = VideoSourceProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoSourceStub<ImplRefTraits>;

  using RequestValidator_ = VideoSourceRequestValidator;
  using ResponseValidator_ = VideoSourceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreatePushSubscriptionMinVersion = 0,
  };
  virtual ~VideoSource() {}


  using CreatePushSubscriptionCallback = base::OnceCallback<void(CreatePushSubscriptionResultCode, const ::media::VideoCaptureParams&)>;
  
  virtual void CreatePushSubscription(::mojo::PendingRemote<::video_capture::mojom::VideoFrameHandler> subscriber, const ::media::VideoCaptureParams& requested_settings, bool force_reopen_with_new_settings, ::mojo::PendingReceiver<PushVideoStreamSubscription> subscription, CreatePushSubscriptionCallback callback) = 0;
};



class  PushVideoStreamSubscriptionProxy
    : public PushVideoStreamSubscription {
 public:
  using InterfaceType = PushVideoStreamSubscription;

  explicit PushVideoStreamSubscriptionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Activate() final;
  
  void Suspend(SuspendCallback callback) final;
  
  void Resume() final;
  
  void GetPhotoState(GetPhotoStateCallback callback) final;
  
  void SetPhotoOptions(::media::mojom::PhotoSettingsPtr settings, SetPhotoOptionsCallback callback) final;
  
  void TakePhoto(TakePhotoCallback callback) final;
  
  void Close(CloseCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  VideoSourceProxy
    : public VideoSource {
 public:
  using InterfaceType = VideoSource;

  explicit VideoSourceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePushSubscription(::mojo::PendingRemote<::video_capture::mojom::VideoFrameHandler> subscriber, const ::media::VideoCaptureParams& requested_settings, bool force_reopen_with_new_settings, ::mojo::PendingReceiver<PushVideoStreamSubscription> subscription, CreatePushSubscriptionCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PushVideoStreamSubscriptionStubDispatch {
 public:
  static bool Accept(PushVideoStreamSubscription* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PushVideoStreamSubscription* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PushVideoStreamSubscription>>
class PushVideoStreamSubscriptionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PushVideoStreamSubscriptionStub() {}
  ~PushVideoStreamSubscriptionStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PushVideoStreamSubscriptionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PushVideoStreamSubscriptionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VideoSourceStubDispatch {
 public:
  static bool Accept(VideoSource* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoSource* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoSource>>
class VideoSourceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoSourceStub() {}
  ~VideoSourceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoSourceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoSourceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PushVideoStreamSubscriptionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  VideoSourceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PushVideoStreamSubscriptionResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  VideoSourceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace video_capture

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_SOURCE_MOJOM_H_