// services/service_manager/public/mojom/service_manager.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_MANAGER_MOJOM_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_MANAGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/service_manager/public/mojom/service_manager.mojom-shared.h"
#include "services/service_manager/public/mojom/service_manager.mojom-forward.h"
#include "services/service_manager/public/mojom/connector.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "base/component_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace service_manager {
namespace mojom {

class ServiceManagerListenerProxy;

template <typename ImplRefTraits>
class ServiceManagerListenerStub;

class ServiceManagerListenerRequestValidator;


class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM) ServiceManagerListener
    : public ServiceManagerListenerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ServiceManagerListenerInterfaceBase;
  using Proxy_ = ServiceManagerListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceManagerListenerStub<ImplRefTraits>;

  using RequestValidator_ = ServiceManagerListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnInitMinVersion = 0,
    kOnServiceCreatedMinVersion = 0,
    kOnServiceStartedMinVersion = 0,
    kOnServicePIDReceivedMinVersion = 0,
    kOnServiceFailedToStartMinVersion = 0,
    kOnServiceStoppedMinVersion = 0,
  };
  virtual ~ServiceManagerListener() {}

  
  virtual void OnInit(std::vector<RunningServiceInfoPtr> running_services) = 0;

  
  virtual void OnServiceCreated(RunningServiceInfoPtr service) = 0;

  
  virtual void OnServiceStarted(const ::service_manager::Identity& identity, uint32_t pid_deprecated) = 0;

  
  virtual void OnServicePIDReceived(const ::service_manager::Identity& identity, uint32_t pid) = 0;

  
  virtual void OnServiceFailedToStart(const ::service_manager::Identity& identity) = 0;

  
  virtual void OnServiceStopped(const ::service_manager::Identity& identity) = 0;
};

class ServiceManagerProxy;

template <typename ImplRefTraits>
class ServiceManagerStub;

class ServiceManagerRequestValidator;


class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM) ServiceManager
    : public ServiceManagerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ServiceManagerInterfaceBase;
  using Proxy_ = ServiceManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceManagerStub<ImplRefTraits>;

  using RequestValidator_ = ServiceManagerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAddListenerMinVersion = 0,
  };
  virtual ~ServiceManager() {}

  
  virtual void AddListener(::mojo::PendingRemote<ServiceManagerListener> listener) = 0;
};



class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM) ServiceManagerListenerProxy
    : public ServiceManagerListener {
 public:
  using InterfaceType = ServiceManagerListener;

  explicit ServiceManagerListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnInit(std::vector<RunningServiceInfoPtr> running_services) final;
  
  void OnServiceCreated(RunningServiceInfoPtr service) final;
  
  void OnServiceStarted(const ::service_manager::Identity& identity, uint32_t pid_deprecated) final;
  
  void OnServicePIDReceived(const ::service_manager::Identity& identity, uint32_t pid) final;
  
  void OnServiceFailedToStart(const ::service_manager::Identity& identity) final;
  
  void OnServiceStopped(const ::service_manager::Identity& identity) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM) ServiceManagerProxy
    : public ServiceManager {
 public:
  using InterfaceType = ServiceManager;

  explicit ServiceManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddListener(::mojo::PendingRemote<ServiceManagerListener> listener) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM) ServiceManagerListenerStubDispatch {
 public:
  static bool Accept(ServiceManagerListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceManagerListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceManagerListener>>
class ServiceManagerListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceManagerListenerStub() {}
  ~ServiceManagerListenerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceManagerListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceManagerListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM) ServiceManagerStubDispatch {
 public:
  static bool Accept(ServiceManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceManager>>
class ServiceManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceManagerStub() {}
  ~ServiceManagerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM) ServiceManagerListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM) ServiceManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM) RunningServiceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RunningServiceInfo, T>::value>;
  using DataView = RunningServiceInfoDataView;
  using Data_ = internal::RunningServiceInfo_Data;

  template <typename... Args>
  static RunningServiceInfoPtr New(Args&&... args) {
    return RunningServiceInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RunningServiceInfoPtr From(const U& u) {
    return mojo::TypeConverter<RunningServiceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RunningServiceInfo>::Convert(*this);
  }


  RunningServiceInfo();

  RunningServiceInfo(
      const ::service_manager::Identity& identity,
      uint32_t pid,
      InstanceState state);

  ~RunningServiceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RunningServiceInfoPtr>
  RunningServiceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RunningServiceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RunningServiceInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RunningServiceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RunningServiceInfo_UnserializedMessageContext<
            UserType, RunningServiceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<RunningServiceInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return RunningServiceInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RunningServiceInfo_UnserializedMessageContext<
            UserType, RunningServiceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RunningServiceInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::service_manager::Identity identity;
  
  uint32_t pid;
  
  InstanceState state;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RunningServiceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RunningServiceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RunningServiceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RunningServiceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
RunningServiceInfoPtr RunningServiceInfo::Clone() const {
  return New(
      mojo::Clone(identity),
      mojo::Clone(pid),
      mojo::Clone(state)
  );
}

template <typename T, RunningServiceInfo::EnableIfSame<T>*>
bool RunningServiceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->identity, other_struct.identity))
    return false;
  if (!mojo::Equals(this->pid, other_struct.pid))
    return false;
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  return true;
}

template <typename T, RunningServiceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.identity, rhs.identity))
    return true;
  if (std::less<>{}(rhs.identity, lhs.identity))
    return false;
  if (std::less<>{}(lhs.pid, rhs.pid))
    return true;
  if (std::less<>{}(rhs.pid, lhs.pid))
    return false;
  if (std::less<>{}(lhs.state, rhs.state))
    return true;
  if (std::less<>{}(rhs.state, lhs.state))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace service_manager

namespace mojo {


template <>
struct COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM) StructTraits<::service_manager::mojom::RunningServiceInfo::DataView,
                                         ::service_manager::mojom::RunningServiceInfoPtr> {
  static bool IsNull(const ::service_manager::mojom::RunningServiceInfoPtr& input) { return !input; }
  static void SetToNull(::service_manager::mojom::RunningServiceInfoPtr* output) { output->reset(); }

  static const decltype(::service_manager::mojom::RunningServiceInfo::identity)& identity(
      const ::service_manager::mojom::RunningServiceInfoPtr& input) {
    return input->identity;
  }

  static decltype(::service_manager::mojom::RunningServiceInfo::pid) pid(
      const ::service_manager::mojom::RunningServiceInfoPtr& input) {
    return input->pid;
  }

  static decltype(::service_manager::mojom::RunningServiceInfo::state) state(
      const ::service_manager::mojom::RunningServiceInfoPtr& input) {
    return input->state;
  }

  static bool Read(::service_manager::mojom::RunningServiceInfo::DataView input, ::service_manager::mojom::RunningServiceInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_MANAGER_MOJOM_H_