// services/service_manager/public/mojom/service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/service_manager/public/mojom/service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/service_manager/public/mojom/service.mojom-params-data.h"
#include "services/service_manager/public/mojom/service.mojom-shared-message-ids.h"

#include "services/service_manager/public/mojom/service.mojom-import-headers.h"


#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_MOJOM_JUMBO_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_MOJOM_JUMBO_H_
#endif
namespace service_manager {
namespace mojom {
BindSourceInfo::BindSourceInfo()
    : identity(),
      required_capabilities() {}

BindSourceInfo::BindSourceInfo(
    const ::service_manager::Identity& identity_in,
    const ::service_manager::CapabilitySet& required_capabilities_in)
    : identity(std::move(identity_in)),
      required_capabilities(std::move(required_capabilities_in)) {}

BindSourceInfo::~BindSourceInfo() = default;

void BindSourceInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("identity", base::trace_event::ValueToString(this->identity, "<value of type const ::service_manager::Identity&>"));
  value->SetString("required_capabilities", base::trace_event::ValueToString(this->required_capabilities, "<value of type const ::service_manager::CapabilitySet&>"));
}

bool BindSourceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char Service::Name_[] = "service_manager.mojom.Service";

class Service_OnStart_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Service_OnStart_ForwardToCallback(
      Service::OnStartCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Service::OnStartCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Service_OnStart_ForwardToCallback);
};

class Service_OnBindInterface_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Service_OnBindInterface_ForwardToCallback(
      Service::OnBindInterfaceCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Service::OnBindInterfaceCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Service_OnBindInterface_ForwardToCallback);
};

ServiceProxy::ServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceProxy::OnStart(
    const ::service_manager::Identity& in_identity, OnStartCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "service_manager::mojom::Service::OnStart", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("identity", base::trace_event::ValueToString(in_identity, "<value of type const ::service_manager::Identity&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kService_OnStart_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::service_manager::mojom::internal::Service_OnStart_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->identity)::BaseType::BufferWriter
      identity_writer;
  mojo::internal::Serialize<::service_manager::mojom::IdentityDataView>(
      in_identity, buffer, &identity_writer, &serialization_context);
  params->identity.Set(
      identity_writer.is_null() ? nullptr : identity_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->identity.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null identity in Service.OnStart request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Service::Name_);
  message.set_method_name("OnStart");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Service_OnStart_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceProxy::OnBindInterface(
    const ::service_manager::BindSourceInfo& in_source, const std::string& in_interface_name, ::mojo::ScopedMessagePipeHandle in_interface_pipe, OnBindInterfaceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "service_manager::mojom::Service::OnBindInterface", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("source", base::trace_event::ValueToString(in_source, "<value of type const ::service_manager::BindSourceInfo&>"));
      raw_value->SetString("interface_name", in_interface_name);
      raw_value->SetBoolean("interface_pipe", in_interface_pipe.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kService_OnBindInterface_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::service_manager::mojom::internal::Service_OnBindInterface_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->source)::BaseType::BufferWriter
      source_writer;
  mojo::internal::Serialize<::service_manager::mojom::BindSourceInfoDataView>(
      in_source, buffer, &source_writer, &serialization_context);
  params->source.Set(
      source_writer.is_null() ? nullptr : source_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source in Service.OnBindInterface request");
  typename decltype(params->interface_name)::BaseType::BufferWriter
      interface_name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_interface_name, buffer, &interface_name_writer, &serialization_context);
  params->interface_name.Set(
      interface_name_writer.is_null() ? nullptr : interface_name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->interface_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null interface_name in Service.OnBindInterface request");
  mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
      in_interface_pipe, &params->interface_pipe, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->interface_pipe),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid interface_pipe in Service.OnBindInterface request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Service::Name_);
  message.set_method_name("OnBindInterface");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Service_OnBindInterface_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ServiceProxy::CreatePackagedServiceInstance(
    const ::service_manager::Identity& in_identity, ::mojo::PendingReceiver<Service> in_receiver, ::mojo::PendingRemote<::service_manager::mojom::ProcessMetadata> in_metadata) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "service_manager::mojom::Service::CreatePackagedServiceInstance", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("identity", base::trace_event::ValueToString(in_identity, "<value of type const ::service_manager::Identity&>"));
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      raw_value->SetBoolean("metadata", in_metadata.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kService_CreatePackagedServiceInstance_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::service_manager::mojom::internal::Service_CreatePackagedServiceInstance_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->identity)::BaseType::BufferWriter
      identity_writer;
  mojo::internal::Serialize<::service_manager::mojom::IdentityDataView>(
      in_identity, buffer, &identity_writer, &serialization_context);
  params->identity.Set(
      identity_writer.is_null() ? nullptr : identity_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->identity.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null identity in Service.CreatePackagedServiceInstance request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::service_manager::mojom::ServiceInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in Service.CreatePackagedServiceInstance request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::service_manager::mojom::ProcessMetadataInterfaceBase>>(
      in_metadata, &params->metadata, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->metadata),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid metadata in Service.CreatePackagedServiceInstance request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Service::Name_);
  message.set_method_name("CreatePackagedServiceInstance");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class Service_OnStart_ProxyToResponder {
 public:
  static Service::OnStartCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Service_OnStart_ProxyToResponder> proxy(
        new Service_OnStart_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Service_OnStart_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Service_OnStart_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Service_OnStart_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Service::OnStartCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingReceiver<::service_manager::mojom::Connector> in_connector_receiver, ::mojo::PendingAssociatedReceiver<::service_manager::mojom::ServiceControl> in_control_receiver);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Service_OnStart_ProxyToResponder);
};

bool Service_OnStart_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "service_manager::mojom::Service::OnStartCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::Service_OnStart_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Service_OnStart_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::mojo::PendingReceiver<::service_manager::mojom::Connector> p_connector_receiver{};
  ::mojo::PendingAssociatedReceiver<::service_manager::mojom::ServiceControl> p_control_receiver{};
  Service_OnStart_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success) {
    p_connector_receiver =
        input_data_view.TakeConnectorReceiver<decltype(p_connector_receiver)>();
  }
  if (success) {
    p_control_receiver =
        input_data_view.TakeControlReceiver<decltype(p_control_receiver)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Service::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_connector_receiver), 
std::move(p_control_receiver));
  return true;
}

void Service_OnStart_ProxyToResponder::Run(
    ::mojo::PendingReceiver<::service_manager::mojom::Connector> in_connector_receiver, ::mojo::PendingAssociatedReceiver<::service_manager::mojom::ServiceControl> in_control_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)service_manager::mojom::Service::OnStartCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("connector_receiver", in_connector_receiver.is_valid());
      raw_value->SetBoolean("control_receiver", in_control_receiver.is_valid());
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kService_OnStart_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::service_manager::mojom::internal::Service_OnStart_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::service_manager::mojom::ConnectorInterfaceBase>>(
      in_connector_receiver, &params->connector_receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->connector_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid connector_receiver in ");
  mojo::internal::Serialize<::service_manager::mojom::ServiceControlAssociatedRequestDataView>(
      in_control_receiver, &params->control_receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->control_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid control_receiver in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)service_manager::mojom::Service::OnStartCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Service::Name_);
  message.set_method_name("OnStart");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Service_OnBindInterface_ProxyToResponder {
 public:
  static Service::OnBindInterfaceCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Service_OnBindInterface_ProxyToResponder> proxy(
        new Service_OnBindInterface_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Service_OnBindInterface_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Service_OnBindInterface_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Service_OnBindInterface_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Service::OnBindInterfaceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Service_OnBindInterface_ProxyToResponder);
};

bool Service_OnBindInterface_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "service_manager::mojom::Service::OnBindInterfaceCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::Service_OnBindInterface_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Service_OnBindInterface_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  Service_OnBindInterface_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Service::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void Service_OnBindInterface_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)service_manager::mojom::Service::OnBindInterfaceCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kService_OnBindInterface_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::service_manager::mojom::internal::Service_OnBindInterface_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)service_manager::mojom::Service::OnBindInterfaceCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Service::Name_);
  message.set_method_name("OnBindInterface");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ServiceStubDispatch::Accept(
    Service* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kService_OnStart_Name: {
      break;
    }
    case internal::kService_OnBindInterface_Name: {
      break;
    }
    case internal::kService_CreatePackagedServiceInstance_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)service_manager::mojom::Service::CreatePackagedServiceInstance",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)service_manager::mojom::Service::CreatePackagedServiceInstance");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Service_CreatePackagedServiceInstance_Params_Data* params =
          reinterpret_cast<internal::Service_CreatePackagedServiceInstance_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::service_manager::Identity p_identity{};
      ::mojo::PendingReceiver<Service> p_receiver{};
      ::mojo::PendingRemote<::service_manager::mojom::ProcessMetadata> p_metadata{};
      Service_CreatePackagedServiceInstance_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadIdentity(&p_identity))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_metadata =
            input_data_view.TakeMetadata<decltype(p_metadata)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Service::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePackagedServiceInstance(
std::move(p_identity), 
std::move(p_receiver), 
std::move(p_metadata));
      return true;
    }
  }
  return false;
}

// static
bool ServiceStubDispatch::AcceptWithResponder(
    Service* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kService_OnStart_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)service_manager::mojom::Service::OnStart",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)service_manager::mojom::Service::OnStart");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Service_OnStart_Params_Data* params =
          reinterpret_cast<
              internal::Service_OnStart_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::service_manager::Identity p_identity{};
      Service_OnStart_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadIdentity(&p_identity))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Service::Name_, 0, false);
        return false;
      }
      Service::OnStartCallback callback =
          Service_OnStart_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStart(
std::move(p_identity), std::move(callback));
      return true;
    }
    case internal::kService_OnBindInterface_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)service_manager::mojom::Service::OnBindInterface",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)service_manager::mojom::Service::OnBindInterface");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Service_OnBindInterface_Params_Data* params =
          reinterpret_cast<
              internal::Service_OnBindInterface_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::service_manager::BindSourceInfo p_source{};
      std::string p_interface_name{};
      ::mojo::ScopedMessagePipeHandle p_interface_pipe{};
      Service_OnBindInterface_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success && !input_data_view.ReadInterfaceName(&p_interface_name))
        success = false;
      if (success)
        p_interface_pipe = input_data_view.TakeInterfacePipe();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Service::Name_, 1, false);
        return false;
      }
      Service::OnBindInterfaceCallback callback =
          Service_OnBindInterface_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBindInterface(
std::move(p_source), 
std::move(p_interface_name), 
std::move(p_interface_pipe), std::move(callback));
      return true;
    }
    case internal::kService_CreatePackagedServiceInstance_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kServiceValidationInfo[] = {
    {internal::kService_OnStart_Name,
     {&internal::Service_OnStart_Params_Data::Validate,
      &internal::Service_OnStart_ResponseParams_Data::Validate}},
    {internal::kService_OnBindInterface_Name,
     {&internal::Service_OnBindInterface_Params_Data::Validate,
      &internal::Service_OnBindInterface_ResponseParams_Data::Validate}},
    {internal::kService_CreatePackagedServiceInstance_Name,
     {&internal::Service_CreatePackagedServiceInstance_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::service_manager::mojom::Service::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kServiceValidationInfo);
}

bool ServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::service_manager::mojom::Service::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kServiceValidationInfo);

}
}  // namespace mojom
}  // namespace service_manager

namespace mojo {


// static
bool StructTraits<::service_manager::mojom::BindSourceInfo::DataView, ::service_manager::mojom::BindSourceInfoPtr>::Read(
    ::service_manager::mojom::BindSourceInfo::DataView input,
    ::service_manager::mojom::BindSourceInfoPtr* output) {
  bool success = true;
  ::service_manager::mojom::BindSourceInfoPtr result(::service_manager::mojom::BindSourceInfo::New());
  
      if (success && !input.ReadIdentity(&result->identity))
        success = false;
      if (success && !input.ReadRequiredCapabilities(&result->required_capabilities))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif