// services/resource_coordinator/public/mojom/resource_coordinator_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_RESOURCE_COORDINATOR_PUBLIC_MOJOM_RESOURCE_COORDINATOR_SERVICE_MOJOM_H_
#define SERVICES_RESOURCE_COORDINATOR_PUBLIC_MOJOM_RESOURCE_COORDINATOR_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/resource_coordinator/public/mojom/resource_coordinator_service.mojom-shared.h"
#include "services/resource_coordinator/public/mojom/resource_coordinator_service.mojom-forward.h"
#include "services/resource_coordinator/public/mojom/memory_instrumentation/memory_instrumentation.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "base/component_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace resource_coordinator {
namespace mojom {

class ResourceCoordinatorServiceProxy;

template <typename ImplRefTraits>
class ResourceCoordinatorServiceStub;

class ResourceCoordinatorServiceRequestValidator;


class COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM) ResourceCoordinatorService
    : public ResourceCoordinatorServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ResourceCoordinatorServiceInterfaceBase;
  using Proxy_ = ResourceCoordinatorServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = ResourceCoordinatorServiceStub<ImplRefTraits>;

  using RequestValidator_ = ResourceCoordinatorServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindMemoryInstrumentationCoordinatorControllerMinVersion = 0,
    kRegisterHeapProfilerMinVersion = 0,
  };
  virtual ~ResourceCoordinatorService() {}

  
  virtual void BindMemoryInstrumentationCoordinatorController(::mojo::PendingReceiver<::memory_instrumentation::mojom::CoordinatorController> receiver) = 0;

  
  virtual void RegisterHeapProfiler(::mojo::PendingRemote<::memory_instrumentation::mojom::HeapProfiler> profiler, ::mojo::PendingReceiver<::memory_instrumentation::mojom::HeapProfilerHelper> helper_receiver) = 0;
};



class COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM) ResourceCoordinatorServiceProxy
    : public ResourceCoordinatorService {
 public:
  using InterfaceType = ResourceCoordinatorService;

  explicit ResourceCoordinatorServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindMemoryInstrumentationCoordinatorController(::mojo::PendingReceiver<::memory_instrumentation::mojom::CoordinatorController> receiver) final;
  
  void RegisterHeapProfiler(::mojo::PendingRemote<::memory_instrumentation::mojom::HeapProfiler> profiler, ::mojo::PendingReceiver<::memory_instrumentation::mojom::HeapProfilerHelper> helper_receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM) ResourceCoordinatorServiceStubDispatch {
 public:
  static bool Accept(ResourceCoordinatorService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ResourceCoordinatorService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ResourceCoordinatorService>>
class ResourceCoordinatorServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ResourceCoordinatorServiceStub() {}
  ~ResourceCoordinatorServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResourceCoordinatorServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResourceCoordinatorServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(RESOURCE_COORDINATOR_PUBLIC_MOJOM) ResourceCoordinatorServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace resource_coordinator

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_RESOURCE_COORDINATOR_PUBLIC_MOJOM_RESOURCE_COORDINATOR_SERVICE_MOJOM_H_